const withJigsawBoxLayoutResult = (expectedResult, layouts) => {
  return layouts.map(l => ({ input: '.Jigsaw~' + l, solution: expectedResult }));
};

const VALID_JIGSAW_BOX_LAYOUTS = withJigsawBoxLayoutResult(true, [
  // From Mathimagics
  // http://forum.enjoysudoku.com/jigsaw-layouts-generate-test-t35712-30.html?sid=6523d33401485a4b2414c1d7cc15a060#p310543
  '111112222333311222333451122364455555366444557666664457889964777888997777888899999',
  '111111222131333422133335442666355422766555442776558444766588889776888989777999999',
  '111111223411122233444442233544462233566666663557768883557788888557779998577999999',
  '111123333111222223411225333444425366445555566447586666777588996788888999777789999',
  '111123333111122333142222235444426635446666655476685555478888859777889999777789999',
  '111111122333312222333312422355566444556666644555664447885897777888897777889999999',
  '111112222134444422133442225134466555136666657333668857399988557998888857999977777',
  '111111222311442222331455226344445766334555766334577776388557966888877996888999999',
  '111111222333141252663142255633442255633347775668844775668849755868949777888999999',
  '111111122131322222433335552436633552446666655744886685744488885777778989779999999',
  '111122223411123323415222333415556363444456666747455586777999586797798886799998888',
  '111112333114412333144452223446455223746555283766558288766658889777698899777699999',
  '111112222314444422311145222334445566333555666335577766888579996887777796888899999',
  '111111222113331222333344242356664442356564647855566647858557777888977799888999999',
  '111111112333341222333344422356664422755666442775566648775558888777958888799999999',
  '111111222113132222333334452663344552666645555766448855764488888777789899777999999',
  '111111122333312222344412562333455562344456667845556777845896667888897777889999999',
  '111111112331222222433556772443556772443356677844355677844355667888888966899999999',
  '111111222133112242333332244556336244556666644557688644557788888757799889777999999',
  '111111222131344442133334522334444522365555527665888877665877779688887979666999999',
  '111111222311444422314442222334545566333555666335575766888877796887777996888999999',
  '111111112333312222333344442355554442667754422677755558677778888666698888699999999',
  '111222223411232223411333333441155666445555566444557766888888776899989776899999777',
  '111111112333142222335446622335546662733546882755546688775544688777749888799999999',
  '111111122113342225333342255363344225666645555677448858667748888677748899779999999',
  '111222223411122233414123335444163335466666665477768555477798585779998885799999888',
  '111112222134112422134444422334455666335555566333557766887777769887899769888899999',
  '111111112333331222443322222433566666455555556444445776888887766888977777899999999',
  '111111112133322222334332525634442555636645575666844475686877477888887779899999999',
  '111112222331222224331154444331554464337555466737755866777758866799999866999988888',
  '111111112333314422353366442357366442557764422577668428577668828557798888599999999',
  '111111222311142222333344224335354444365555547666657577688667777888869997888999999',
  '111111222333111222333344225336445525666645555676644588677448888777999888777999999',
  '111111122113333222433352226433455526444456666475556886477758886777888899779999999',
  '111111112133344442533344442533664222536666672555866772588887772588887779599999999',
  '111111222333111422335544422333544442673555842677775888667775588667999888666999999',
  '111112333141122233144422233444452233455555556778856666778886669778889969777899999',
  '111111233144444233144222223154266623554666733586668739588888779558777779558999999',
  '111111122133332222133433225444443265466666665467855555477885889777788889779999999',
  '111122223112222323114445333414545333444555666777565686777566688797999988799998888',
  '111122223141222223141533333441533666445555566444775866777775868799999868799998888',
  '111111122314412222334442522344445566333555666335577776885877766888897796889999999',
  '111112233114422333114222333444442253455555556758866666777888699777886699778899999',
  '111111222113344442313354422333354442665555522677758888667758898677778899666999999',
  '111111122113344442533344442533334622566666662556788882577778882577778899559999999',
  '111111123144422223144444223555564623576666623576863333577888889577778889579999999',
  '111112222111333322133345522633445525666444555676644885776648889778888999777799999',
  '111112222311114425336444425336444225376666625377888655378888655378899995777799999',
  '111111222113322242155362244553366774533666774533667744558867449858887799888999999',
  '111111222111332222433356622433556666433555776444455776884457776888877999888999999',
  '111222333411122335416223355416223355416666675448899675448899675488997775888999777',
  '111112333112222234112523334662553434666555444676755844677785899678888899777899999',
  '111123333411122355441123335422226635426666675486677775488879955448779995888879999',
  '111111122331144442333344222335544422365555527668885577666887777688889977669999999',
  '111112222113122244513366244553366274533367774538667744558667794558889799888899999',
  '111111222113333222413566662443555762843357762843555766844445796888777799888999999',
  '111222233111223333114222333414455566444555666445556676888999677888899777889999777',
  '111111222133333442153363422153666422755564442775666849775868849755888889777999999',
  '111111222131144255333342255363342255663742855667748858667748888667449989777999999',
  '111122333112123344112225344666225334675555534677588444667588899667789899777889999',
  '111111222133333422113355442666355442776358422766558444766558899776888889777999999',
  '111111222333441222333341522663341552666645555766849955776849999777844999777888888',
  '111112222113444422133444442133556662735555562733355668799999668779999688777788888',
  '111111112314444222344422225336442555366666665333788655377778885777888895799999999',
  '111111112334122222344442562334444562335555566735888866735788886777779866799999999',
  '111111222344411222334441225344646625333666555376686885377988855777998885777999999',
  '111111112333451522333455552663455522633444772668884722688884777668984777699999999',
  '111112222113332442153333642155533642756666642756884449756888849755788899777799999',
  '111111112333321222343522262343556666443555766444455767848885767888987777899999999',
  '111222233411122335411622355416623335447666355477786695447886995477889995778888999',
  '111111222113331442333344422533644442566666662577776882557778888577988899555999999',
  '111111222311142222333544422333545444363555747666565777886665777888869997888999999',
  '111112222133112244133332244533362444566666664555768884557788889557799889777799999',
  '111111222111333422333335442637755542677754442675554482677588888667888999666999999',
  '111123333111122334512226634555266334552267744588667444586677794588779999888879999',
  '111112233111412223444442233454662233456666637558866737558877777588897999558899999',
  '111111222111322222333345525333444555366645557666444777686647777888887999888999999',
  '111111122133133224533333224555566624577666224576664444577888884577889889779999999',
  '111111223144411223445466223445462223555666333577768388577668388577998889577999999',
  '111112222311411225344462255334662775344666775344866755338867775388997995888899999',
  '111112222311422425311444425333644425366666665378886555378888995378778995777799999',
  '111122233141123223145523333144522663444555666744885669777785569788789969778889999',
  '111112222131144222135554224333354444333654777666657777688655579888669979888899999',
  '111111222111332222333344552363345552666444555766648858766448888777788999777999999',
  '111122223112223333415223366415553666414753686444755586447799586777799988799998888',
  '111122333141122223441523333441522366445555566447885966777785966788889969777889999',
  '111123333111222344112223344522663344556666644557766884557788899557888999777789999',
  '111112222113122442313324442333355544366555447665557777866687797866889799888899999',
  '111122333441122335411662355417662335487762235488766295448766995488779955888779999',
  '111112222133134255133134255663334225667444255677488855667489889667489889777799999',
  '111112222113333332411343322444444522455555556775666666778868996788888899777799999',
  '111111122133133222443333222444535526444555666475585666777888866777889889779999999',
  '111112222111132222445536277445336677455536667445533677448536677888839999888899999',
  '111111122113322222444325562444355667443356677433556777835586777888886699889999999',
  '111111122113333224333533224555522264566666664567774444577884888577888899779999999',
  '111122233111122334512223344555233364566666664567778444557788894577889999778889999',
  '111111122314441222344455526333452226334457766388857666385557776888977796889999999',
  '111111222331311244333352224633555224666654444677555884677758888667998988777999999',
  '111111222113442222133444442333344552335555566755886666788888669777788699777999999',
  '111111222131314222333334442555366642756368642756668444755588888777598989777999999',
  '111122333411225336411125336422225336444555666477588886477589996477588996777889999',
  '111112223111122323442225333444455363744555663747556666777588866787889999788899999',
  '111112222131312242133334442335554442366555447866655577866677779868897979888899999',
  '111111222113333244153363224553663224557666244577866844577868849557888899777999999',
  '111111112134222222334256627334556677344555667334455677384458677888888679899999999',
  '111112222133142252133144255663347255663347755668347755668449779868849779888899999',
  '111112222133452262133452662133455677134456678334556778944956778949956778999988888',
  '111111123441412223444452223666455523676458323675558333677758888677798988679999999',
  '111112222113144222133546226333546666333546777555546777588546779888449799888899999',
  '111111222311314222333354442336555422366654447886555477866657777888697997888999999',
  '111111112122222222333334444335366644355666447556667477555577777888888889899999999',
  '111111222133331242533331242555536642756666642756684444757988884757988889777999999',
  '111111122131332222333333244555556224566666664577644444557888888777788989779999999',
  '111122333441222233411252333411255536444456666475558996777858996778888966777889999',
  '111222233111223333441522336441525366441555766448595766488995766888899777889999777',
  '111111222133145222133345552333644552736645582766445888766648889777649889777999999',
  '111111222331144442333144422333544522635555572665885777668889777688889977666999999',
  '111222223112232233411133335444163655446666655446768555477778885779979988799999888',
  '111123333111123334515223234555222264566666664567777444587877494588879999888879999',
  '111111122333141222344442225344644255366666665337886885377788885777989555779999999',
  '111112222311144422333154422363555442363357747866555747886659777886669997888899999',
  '111111122333142222553144622533346662553347766855547776885449766888849777889999999',
  '111112223112222333112423335666444535676645535676444555677784899777888899788899999',
  '111112222311311442333355422336554422366654447886655477886557777866997997888899999',
  '111111112134442222334444522333445562733555662735588666775888866777788869799999999',
  '111222333111122343112222343566663344555564444557766664757888899757889999777888999',
  '112222223112122333411133335444136555466666665444678555477778885777998988799999988',
  '111112222331312242333311542363655542666654444765554848765998888767798988777799999',
  '111111122344411225344442255346646225337666255377686685337788885377998885779999999',
  '111111112344144222344445226333455226373555626377558666377588886777889886799999999',
  '111112222314412255344412225344416665334666755366687775399987775339987785999988888',
  '111111222331114222333354442363554442763555842766655848766658888777699988777999999',
  '111111222313311422333354442673355442677555442677558842677758888667998898666999999',
  '111112222111344442133345422333355442673555842677558888667578889677778999666699999',
  '111111222131333322133332222445556666445456566444455566777788889778888989777999999',
  '111112222131332422133352424133554444636555474666655778696957778996977878999988888',
  '111111222111334222555534226533334266533444776558477776588476666888477999888999999',
  '111112222311422222331444445331466665334467755366667855377777855999997885999988888',
  '111111222311122222333455526334445556377745556377744466387774666888889996888999999',
  '111111222311412225344462725334667725334666755384466755384867775388897995888999999',
  '111111122311222222333445672344455677344555667334556667834566777888888997889999999',
  '111111112331445222333345222366645522336645577886645557888647777888644977899999999',
  '111112222331112242531336242533366644555367444556667774858677974858899977888899999',
  '111111222311142225333342525633342555663444755666847775686847777688849997888999999',
  '111112222131312442133333442553636442756666642755686844755888889755798989777799999',
  '111111223444122233441122333444552233465555537668855777666889977668889777688999999',
  '111111122113344442533446422533366442533666772588667772558688772588887799559999999',
  '111111122133442225133342255333342255666645555667748888667748889677744889779999999',
  '111111122113332222333435222364435555666444555666674457888674777888877799889999999',
  '111111112313222222333334225363444555666645555666444757688477777888888797899999999',
  '111111122313132222333332244556636244555666444557686644557788888777789898779999999',
  '111123333111122234551223334555222634566666664576888444577788944578889999777789999',
  '112222223411222333441153336411155366447555366447558886477758866777999886799999988',
  '111112222113122422133334442533366444536666674555667774855577779885889799888899999',
  '111111122134122222334556672334556672334456677834455677834455677888889679889999999',
  '111111122133312222334552622344566677344555667334445667884855677888897779889999999',
  '111111222131331224333352224633552444666555444666755884677758888677988989777999999',
  '111111222134144252134446252334446652733666552736688855737688859737889859777999999',
  '111111222131441222334444422333455562335457566835557666887777766888977969888999999',
  '111111112133332222334532226334555626444456666474555688477785688777788889799999999',
  '111111112313332222333322244355626444556666644555676448557778888777788898799999999',
  '111111222113332244153333224553632244566666664557786844577888849557788899777999999',
  '111111122113333222433355622443355622444456666774558866774558886777888899779999999',
  '111112223111222333415552336444452336447852366477856666477855596777888999788899999',
  '111123333111222344112253334662553444622555774666855744688857799668777999888879999',
  '111111122313122222333342552366644557366444557366445557866847777888889797889999999',
  '111112223112222233112333334555666634555564444576666444577777899778888899788899999',
  '111112222131412522331466522333466577344465557334665777884665977884895979888899999',
  '111111112334412222344444252346462255336666655337768685737888885777798855799999999',
  '111111112312222222333245555333344555366444557666447777666648777888888897899999999',
  '111112222113333222413533262413535666444555666444575786949775786999777788999988888',
  '111112222111342522313345522333445555336645577666644777886647797886847999888899999',
  '111111112331444442333455422363335442666555222677588828667557888677777988699999999',
  '111112222134442222134444255133446655136666657336688557339888857999988857999977777',
  '111112222113112222333333244355366444556666644555667447558777777888899799888899999',
  '111111112133222222333344255633344255666645555667448885667448888777777889799999999',
  '111112222111334422133354422633355442663555744866557774886657779886677999888899999',
  '111122333112222233411223335416666535444465555474666685477799885779999988777998888',
  '111112222113112242533366244553667244533367774558366744558667774858899799888899999',
  '111112222311142225314446225344466655334467755336667775388677795388879995888899999',
  '111112222131342552133345552133445562738845562738844669788846669788746969777799999',
  '111112222331111222333344442353646642355666447856656747855557777888999977888899999',
  '111111222131132242333332444355322444665555544666778558666788888767789989777999999',
  '111112222313144442313155442333554442663357722688855777688559797688889797666699999',
  '111112333111122343222223343255566643555666444756664448757788888757889999777899999',
  '111111222333114222533314226533344626555546666575448886577498886777499888777999999',
  '111122223114422333114552333144522633444555666774885669777855699777886699788889999',
  '111111122134442222133344422334445552333555666755588866778886669777788869779999999',
  '111112223112222333112243353664443355666645555667744455767748899777888899788899999',
  '111111123444115223644455223644452223666752333677758883677558883677599888679999999',
  '111123333112223344111255334662225344662555744668577744688557999668877799888879999',
  '111112222111332425661377425666377425683374425683774555683774955683844999888899999',
  '111111122133122222334425555333425555633444775666684777666684477888889779889999999',
  '111111222331311242333355242663355442766654442766558844767558888767998988777999999',
  '111112222111133322444435322444455332664555733866557777886567777886669999888899999',
  '111222333111222333411522366414552336444555666477855696447885996777888999777888999',
  '111111122333311222433335252446365552746666652744468655747488885777998888779999999',
  '111112222131444422134455222134445666333555666333577768999557768997777868999988888',
  '111123333411122355412223335412223655466666665446788895477788895447889995777789999',
  '111111223411451223444452223644455223666653333677558883677758888677958998677999999',
  '111111222313144522333145552633345552677348552677748882677749888667449898666999999',
  '111111122331142222344444222344556666345555576333355776888777776888879966889999999',
  '111112222113311242533366242553366244553367744558667744858667774858997799888899999',
  '111111222131331222333334242355554442666654444766655558767688888777988989777999999',
  '111112222113311242333333442354444442655555552677777758677888888676998899666699999',
  '111111222111332222445533262447553366447753366447755366848775566888877999888999999',
  '111111222311144225344444425333664225376666625377866555378888885377889995777999999',
  '111111222113322222413335526444355666433357776444557666485577796888887799888999999',
  '111112333112212233412222335444466635474666535476665555477888895778898899777899999',
  '111112222113114222333344255366347255666347555668347557668447777888499799888899999',
  '111112333441112333441222335442266635422666775486667755488777955888799955888799999',
  '111111112134442222333445222344455266334555766338557776888577666888877769899999999',
  '111112233142222233144225333114445533444555666775566688777599668779999968779988888',
  '111111122333142222335146622355446627335546677385544667885549677888849777889999999',
  '111111122333112222333452252633455555634444475666664775868864777888899777889999999',
  '111112222331222224331155544333154444633654774666658777665558877699999877999988888',
  '111111122133132224533332244536622444536666674555886674558877774588879779889999999',
  '111111222113333224515332224555633324566666664578886444577788494577888899777999999',
  '111112222111342525313342525333342555663444755666847777686847797686847999888899999',
  '111112222113333322133342225163444555666645555666444758699947778997777788999988888',
  '111111122333131422533334442536777742566674442567777482566688882556989888559999999',
  '111122233141152333441152336447552336447752266488755266488759966888759969887779999',
  '111111222133333242155332242156336244556666644557688649757788449757888889777999999',
  '111112222331444222311154442333555442363357747866555777866659997888666977888899999',
  '111111122331122222433355266443335266443555766448577766448557776888889977889999999',
  '111111122133312224553332244533322664556666644566778884557788844577798889779999999',
  '111111222314142222314444225336644455336666655337776655388777795888879795888999999',
  '111122233111222333412223333414455556444456666455556676888899976888999777889997777',
  '111112222113333242511333642555533642756666642756884444756888994757888899777799999',
  '111111222344411222344441522344665552336666655733366885773988885777998885777999999',
  '111122333411112333415552366477752336444752666488752226448755596888799996888779999',
  '111122333411112233441555236444752236488752336487752666487555966887799996888779999',
  '111111222133312224153336624553366224555367444588667744586677749588897779888999999',
  '111111222313311222333333244555556224566666664577644444557888888777998898777999999',
  '111112222311444522311444552336464452736666652738868655733888995773888995777799999',
  '111111122133122224553226644533326774553666744533687774556688744588889779889999999',
  '111112222111133224533332224553366644553666744556667744588877774588779999888899999',
  '111112222331111242333442242333544444355555556777775666878877666878999966888899999',
  '111111222313112222333333442566344442556666644755558664755888888777799898777999999',
  '111111222113312222333344242356644447356666647355556647858557777888897799888999999',
  '111111122113222222333332444536364444536666674555567674555877777888888799889999999',
  '111111222131122224533366624553367724555367444583367744586667774588889979888999999',
  '111111222131331422333355422366355422666654444776558448776558888776988989777999999',
  '111112333111212344222222344566663344557763344557766664557888888557898999777899999',
  '111112222313311222333441225363455555366444557666664757688944777888997797888899999',
  '111111122333114222333334442536664442577666442577766682577788888555799888559999999',
  '111111122313132222333334222354444444655555554666666657888677777888879797889999999',
  '111111222333141222344441252344646255346666675338676775838977775888979555888999999',
  '111112222111332242513332244533366444536666674555667774558877794858877999888899999',
  '111111222344112222344156272334556677334555677334455677838459667888899667888999999',
  '111111123144422223145552223644457323666457333686457773688855579688887779689999999',
  '111112222333122442333144442331155442365555547866559977866669777866889777888899999',
  '111111222113344442133333442553366442576666642577668822577888889577778899555999999',
  '111111222113333222133433522666434552666444555766484555776884889777888899777999999',
  '111111222311341522333344522336345552766645552766648588776448888776948998777999999',
  '111111112333312222344352622334355626444555666474558688774758668777798888799999999',
  '111111112331422222344455262344455662334457766833557776838557776888887966899999999',
  '111123333111222233412225333412555666444456666444555786999577786997777888999978888',
  '111112222111122322444425333446455537466653337465557377666587777886889999888899999',
  '111112222113344252133345552133645572836645572836645779866647779868447799888899999',
  '111112222313311242333331442356664442756564642755566648755988888757998898777799999',
  '111111123114222223444422233444453333655555553666657777668887777688888799689999999',
  '111112222133314222553114622533344666553347766555447776885499766888497779888899999',
  '111122333111222334115552344666752334668752344688752444668755599688777999888779999',
  '111112222111322422133324444333355444365555547666557777666687779886887999888899999',
  '111111122311222222334444425334464455366666665337767755387777755888888995889999999',
  '111111222133314442133554442663544472633555772638885722688855779688897779666999999',
  '111111222344111222344444255333464225366666665377868555337888885777999885777999999',
  '111112333411122333414452233444555236477752226487555666887756696888779996888799999',
  '111122233411112233415552336444752336484752636488752666488755596887799996887779999',
  '111112222131312442133355442333554442637754482677755888677558889677698989666699999',
  '111111122131332222333334225666634255664444455667485555677488888777788989779999999',
  '111111222113312222433335522433365555466666665444467775884477775888897799888999999',
  '111111222333312222344315662334415562344555667845596677844597667888897777888999999',
  '111111222311142225333644255333642257366645557368845777668445777688849997888999999',
  '111111122331444422331452226334455226344555776388557766388857966887777966889999999',
  '111111222113122224333323244556333444566666664555777644558787777588889799888999999',
  '111122233111223333112245333662445555662444755666644755888647799888877999887779999',
  '111112222133144222133145252333345555663645755666647777868649779888449779888899999',
  '111111122333112222343555622343356662443456766844457767884555767888899777889999999',
  '111111112333314522366334522666334522776444522776488555776488558776498888799999999',
  '111111222311412222334444425344646625333666555376686885378888855777798995777999999',
  '111122333112223344511223344512266334556666644577668894557788994557788899777889999',
  '111112222113333322113343322444444552445555566755666666778868899778888899777799999',
  '111111222133312222134335522434335666444555666444577676885577679888897779888999999',
  '111111222133311244533332224536322644556666644556778684577788884557998889777999999',
  '111111122133144442333334222536364442576666642577768682555788888577779889559999999',
  '111112222311311242333352242365554447366654447366655547868857777868997997888899999',
  '111111222131314252333334252666344252666347555868447555868477777868497979888999999',
  '111112333411222335441222235441266335476666635477668955478888955477888995777899999',
  '111112222311144222344145266344445266335555566337588886337589886777889996777799999',
  '111111112331222222334452627334556667344555667344455677384856677888888977899999999',
  '111111233444412233444411233455222223665555533677777558667998888667798888667999999',
  '111111222333331242335511242335566642755666442756664488757994488757988888777999999',
  '111111222134144422134442225334646255336666655337686855377788859778889859777999999',
  '111112222111332244133352244333555244366654447668555777668857779668877999888899999',
  '111112222111134522333334522366344525666347555686447557886477777886479999888899999',
  '111122233412123335412226335411266335444666555477668995477688895477789895778889999',
  '111111122334142222344142522344445566333555666335577776885879776888879766889999999',
  '111112333112222233122443335124466635444666555476665589477755889778888899777899999',
  '111111122333114422335544222333554422366654447886655777888665577886699777889999999',
  '111111222331311224333352224335554244666654444667655588677758888677998988777999999',
  '111112222331142555311342555333342255367444258667748888666748998666749988777799999',
  '111112222331222242331444444331144556335555566355778866777777866979999866999988888',
  '111111222331411222355466272335466672335444677835554677838554667888994977888999999',
  '111111222113133224553333224556332244566666664557788644577888844577889899777999999',
  '111112222311122422331444425336646445337666455377676655387777955887889995888899999',
  '111112222111313222333333342555566642556564644756664444758888888777898999777799999',
  '111112333111222233122244533662445553766645553766644855776448889778888999777899999',
  '111112222311112224335566244355667274355567774358566774338667744388899994888899999',
  '111111222133333222113445225333455525666444555676664888677644899777888889777999999',
  '111111222313311442333334442553644442566666662577776822577788888577998898555999999',
  '111111112133442222333444442333554422635555572668855777688888777666688779699999999',
  '111222223111122333441223353441633555466666665444776855747799855777998888799999888',
  '111111222333311222333341225364445255666645555667644458677948888777998888777999999',
  '111122233411222333441522363411523366445555566447785996747885966777888996778889999',
  '111111112333331222333444222355546226555546666577546668777444888777988888799999999',
  '111112222133311222134355622334335666444555666444577677884557679888997779888899999',
  '111111222111333322433333522444455522444456666775556666775888886778888999777999999',
  '111111112133344222333344422335555442667754422677555588667778888666778889699999999',
  '111112222131142522133344552333345552663645755866647777866447779886849979888899999',
  '111111223414112223444444223556642233556666633557786633577888888577799898577999999',
  '111111222314112222344444255334446255366666665337688855337888885777799895777999999',
  '111111223414141233444442223546662223555666333577766683577788888557989898577999999',
  '111111122113334442533366442573336422577666442557688842577668882577788899559999999',
  '111111222133122242333152444333352444665555544666758888666759888767779889777999999',
  '111112222113313222145333262445553366444753666447755566848777569888797799888899999',
  '111112333122222333114252336144452366445555566447856669477858699777888889777899999',
  '111112222311112242333333342556666342555564444758666644758888888757799998777799999',
  '111122223411222333411123353444626353446666655747686555747789995777888995788889999',
  '111122333112222333112242353614445553666645555766644485767949988777999988777998888',
  '111111112333341522333345522637445522677745552667744582667748888667948888699999999',
  '111111122333112222334445662334545672834555672834565677844566677888899777889999999',
  '111112233411122333441552333444552223464457727866655777888655977888669997886699999',
  '111222223441233333441225336441255736411555776481559766488599766888889766899999777',
  '111112222111132242553336244553636274533666774538676744558677744858879999888899999',
  '111111223111442233444452233664555223674458823677555833667758888667788999677999999',
  '111111222133314242133344442536344642536666672586887672588887779585897779555999999',
  '111112233111222223414442333444452333455555556777856666777866696788888999778899999',
  '111112222113311222333334552366634552664444455766485558766488888777998899777799999',
  '111112233122222234111552334666655334667753344677554444677855999678888889778899999',
  '111112222311122224315566724355567744335666744335567774385667794388889994888899999',
  '111111122113333332444443222444553322645555572668855777666877777688888899669999999',
  '111111112133442222333344222335544442365555547866665577888667777888866779899999999',
  '111111122331142222355542266355542766355444776335847776338847776888849966889999999',
  '111112233111452233441452233444455233467752238667558888667758988667758999667799999',
  '111111112134452222334556222344456772333456777833456667888455677888856679899999999',
  '111111112333312222443333562744355562744456662745558662745888866777798888799999999',
  '111111112333414222334444422333455422365555527668558777668888877666898777699999999',
  '111112222314112422314444425333344625366666665376885555378888895778799895777799999',
  '111111122311442222344444222333334456355555556357766666888777776888877996889999999',
  '111111222133333322133345522164445552766645552766644458776649998779999998777888888',
  '111222223111122233411523333444556636474555636474455666777785996778889999788888999',
  '111112222111344225133342225663347755666347555663347755688847779688447999888899999',
  '111111222331113222433333225444443265466666665467855555477888885777899988777999999',
  '111122223411112233441422233444453333455555556777756666778886966778899996788889999',
  '111111222133311222433333552444663552746666652744866555744888885777998889777999999',
  '111111122113334422333335422677535442677555442677585442667588888667788899669999999',
  '111112222344411122344551222344566666344555776333335776888955776889997776888899999',
  '111112222311444442311344422333354522335555566775856666778886996788888996777799999',
  '111123333112222234112255334612553344666654444667755894677558899678888899777789999',
  '111112222111332322143333325444443625466666665476855555478888859778788999777799999',
  '111111223141422223144423323444523333455555556777785666787786669788886969788999999',
  '111111122313142222333342552336342555666444555666748588766748888777749898779999999',
  '111112222113311222433333225443636555446666655444676755488777775888997799888899999',
  '111111222111222222333334444353636644355666447556676747555577777888888999888999999',
  '111111112333341222353344262553342262555546666757748866757448868777948888799999999',
  '111112222313144422333155442333154442637555482677759888677559888667779898666699999',
  '111111222113333222413353262443355562444456666745558866747858896777888899777999999',
  '111122233112222334112253344615553444667753344666755584667759988677999988779998888',
  '111111122133314442333334422536644442556666622577776682557788888577798889559999999',
  '111122333111222223141552333444552363444456666747855666777855969788888999777889999',
  '111111222111344442333334422533634442566666662577786882557788888577778999555999999',
  '111111222331441422331444422333545462735555562738585666778888966778988966777999999',
  '111111122113333322444443222454443332655555552677788858666788888667777799669999999',
  '111111112333312222333444222553546662553546766855546766888444777888897777899999999',
  '111112222111122222333344455367744445367777745366667745336665555888889999888899999',
  '111122223122223233111443333551544663555546666755446866777744888779799998799998888',
  '111111222133112222333334452366634552666444555766485558764488888777799889777999999',
  '111111112133333222333345522666644522676444525776445555776648888777888889799999999',
  '111222223111222233411553333414455336444456666477556686777755886779999888799999888',
  '111122333114222233114223333414425556444555666455576686999977688997777688999778888',
  '111111222333114222335154662335554672835444672835466677855469677888499777888999999',
  '111222223111222323411553333414455336444456666477556686777755886797999888799999888',
  '111111222311331442333334442355554442666754222677755558677788888677988998666999999',
  '111111122331441222334442255344466225346666675388667775338877755888977955889999999',
  '111111122334441225344441625337446625377666225376688255376988885377988855779999999',
  '111111122341412222344445266344455226333555666377558886337588886777798986779999999',
  '111222223441223223441133333411153566445555566445758886777778866799799866799999888',
  '111111122341145222344445622334445622333555666773588866773588886777589986779999999',
  '111111122334151222334452222334556667334456677344455677888856677888959677889999999',
  '111112222113333224133333244155662244556666644557766448557999998577999988777788888',
  '111112222113311244333332224356362444556666644555768648577788888557998899777799999',
  '111112222131112242333444442335555462337754466837555566877777666878899969888899999',
  '111111122344141222334444222334545662335555566733585866777888866777989886779999999',
  '111112222133333332144335522144455622144456667884556667885599667899999997888877777',
  '111112222113312422133352424333354444665555544666657777686857779886897799888899999',
  '111111223144112233444442233455542223666555333677785558667788888667799889677999999',
  '111112233122222333112444533612645533666645555776645895776444899777888889778899999',
  '111111222333111244553366224533366244537762284557668884577668844557999888777999999',
  '111112222133333322143434322144444552145555567855666667889696967889999997888877777',
  '111112222113333332113435522664435552766444552766684455776684899788888899777799999',
  '111111222113341252663342252663344752663347755863447755868847755868947799888999999',
  '111111112333341222333444442353664442556666622577766828577777888555978888599999999',
  '111111222133311222333334422555534626555444666575486666774488888777998889777999999',
  '111112222113311422333333422536666442555564444755666684775888888775998899777799999',
  '111122233112223333412225333414455666414555676444556676888599976888899977889997777',
  '111112222331122224351167724355566744355666774335667774385569974388889944888899999',
  '111111122331144422333342222335544442365555547866665577888867777886669977889999999',
  '111112222113333242113533442665533442766555442766885544766885899767888899777799999',
  '111111222131412222334456772344556672334555677834455667833456677888896979888999999',
  '111111222113331222333334442555366442756666642755668444755588888777988899777999999',
  '111111222131322242133334442335554442365654547866655577866677779868887979888999999',
  '111111122311444222334444222344556662335555566733355886777888866777888996779999999',
  '111112222111332322415333326445553626444753666484755566487777596887877999888899999',
  '111111112133344442333334422355544422666555222667775558667788888677778889699999999',
  '111222223441123323441223333441113566455555556445788866777799866797798866799999888',
  '111111222331112222333344422533364444566666664555567774885557777888899977888999999',
  '111111112333144222533342262533342266555546666557748886757748886777449888799999999',
  '111111122331312224333355244363552244666752444667755848667558888677798988779999999',
  '111112222133142222133544442133554446337555466377755668977775668999978668999988888',
  '111112222133112444133352224336355524666357444685557477688857779666899779888899999',
  '111112333122112333142222355442663355446666655447766855447888859777899889777899999',
  '111111222113331442333333422567744442567777742566667742556888888566988899555999999',
  '111111112333144442333354422367355422667555422667558428667758888677779888699999999',
  '111112222131333222133344522163344555666645555666447758996447778999777878999988888',
  '111111222313131224333332244555636224556666644577686444557788888577989898777999999',
  '111112222113332242153632244156633344557666344557776648559976748959977788999988888',
  '111111222311144222333345252366345552336645577866647557868647777888449997888999999',
  '111111122313122222333345255334445255366645557668644477668647777888889797889999999',
  '111112222113311244533332244533662244536666674558866774558877774558997799888899999',
  '111111222113333222133344422536364442556666644755568684775558889777888899777999999',
  '111111122133333322143553662744553662774456622744855662744855869778888889779999999',
  '111111222113132224333333224553666624555564444576666844577888888577789899777999999',
  '111111222131314255633344255663342225633742885677748855667448885667498989777999999',
  '111112222133144222134444552134464652336666655736868859733888859777889559777799999',
  '111112222113332322144333322145536666445555566444475568997777668997977788999988888',
  '111112222113114252633334252663334255663444755668477755868477775868499799888899999',
  '111111122333114522633344552673345552677348552677748852677448882667499888669999999',
  '111112333112212333142222353444266553446666655744668555747888859777898899777899999',
  '111112222313411122333445222344445566344555776335577776888577666889997696888899999',
  '111112233141122333441522333444552223444555666788855666777885966777889969778899999',
  '111111222331311222333344225366644255366645557668445557688447777888997977888999999',
  '111122333111123334551226334552226634552666744586677744588677944588879999888779999',
  '111112222133314225633314225663314255663444755668497755688497775688497779888899999',
  '111112222111334242133344442333544422355555556778885666788886669787866999777799999',
  '111111222111333222444353266433355226443555766488557776448757666888777999888999999',
  '111111222133444242133334442135335442665555522677588589677788889676777889666999999',
  '111111222111322222333333244566633444555666444555776664558777777888887999888999999',
  '111122233112222223411453333414455363444555666747556686777756886799999988779998888',
  '111112222131312242133334242533664444536666674555566774858577779858897979888899999',
  '111111222113332222133334442536364442556666644755568684755588889777788899777999999',
  '111111112333122222343322555346625557346666657344486657444887757888889777899999999',
  '111111222313113224333333244555622244566666664557776444557888888577899898777999999',
  '111111222113333442133344442534446622536666672556688872588887779588777799555999999',
  '111112222131344222133334442135554442336555477866655579866677779888667979888899999',
  '111111222331114522333334522663344522666645555776448855776488888776499988777999999',
  '111112222331144222333114422533336444566666664555677774885599777888559977888899999',
  '111111222113122224533333244556333244566666664557888644557888884577779899777999999',
  '111112222113311422333355442363354442766555442766658848766558888776998899777799999',
  '111112222311455222316455772316445772336645577833644597833664597888664997888899999',
  '111112222113333244513332224516336244556666644557688694577788894557888899777799999',
  '111112222311112222344455672334445677334555677334566677834556667888899997888899999',
  '111111112333331222443355262443552266443752866447755866747558866777988888799999999',
  '111111222133331222133433255666432255664444455667784555667884889777988889777999999',
  '111112222111132222444335627443355677433555667443556677483566777888869999888899999',
  '111111223141222223441245233444445333665555533666577777668578977688888979688999999',
  '111112233441112333441222333445552236447555266487755566888777966888799966887799999',
  '111111122131222222333445552363447555663347755666344757866644777888888979889999999',
  '111111122333142222333144552363345522666645555776648858766449888777749888779999999',
  '111112222133333322133455522134455552166444557866664497886664997889999997888877777',
  '111111222314141225334442225344442665336666655366788885377788855377989895777999999',
  '111111122331441442333344442533646622553666722556686772588887777588988977559999999',
  '111112222111322244331352444333352444635555574666857777666857977668887999888899999',
  '111111122333113222343333252446665552744666552744466655747888858777899888779999999',
  '111111223111444223444442223546666223555563333577666683577788888577888999577999999',
  '111111122313314422333444442563334422566666662557788862577777888557798898559999999',
  '111112333411222223415522333414552336444456666477855696777885596788888996777899999',
  '111111122331142225633344225663347225666347555688347755688447775688849977889999999',
  '111112222131311242533336244533366244557666244557668884557688884757998989777799999',
  '111112222111334255613344255633347255688347225668347775668447795668477999888899999',
  '111111222131122222334444245336644445336666655377776655378777755888889959888999999',
  '111123333111123343516222343556222244556666644557777644858777694858879999888879999',
  '111111222333111224533332224536662444535666474555866674588877774588999777888999999',
  '111112222311114225344444225346464255336666655337868685377888885377899995777799999',
  '111111122113444442333554642773544622733555662773885622783855666788888699779999999',
  '111111233141442223144422233445425233665555533667578588667778889677788989667999999',
  '111111122341422222341444252344466655333666555336667775838777975888887975889999999',
  '111111112333341222533444442533466642536467682576667882577777882555978888599999999',
  '111112222311122422314444442333445566335555566335577666877777796887889996888899999',
  '111111112314444222334542262334545662734555862733585866737785866777888896799999999',
  '111111222131122222334566277334556667344555667344455677338445677888889979888999999',
  '111111122331122222333442552336645557366444557366645577866844777888889977889999999',
  '111112333111212343222222344566633344555666444557776664557888888757898999777899999',
  '111112233112222223144253333144455633444555666774556668777759668799999988779988888',
  '111112222131112222333345526334445666334555677444566677485567777888899979888899999',
  '111111112334412222334442255344622675346666675346886775338877755888897755899999999',
  '111111222113122222333344452363345555663645755666647757864447777888889799888999999',
  '111111222113332222133433225664443355666645555667744455688774779888877799888999999',
  '111111122133331222334355552674335552674444452677788452677778488666988889669999999',
  '111112222113312242133334442335354442665555544766658588766688889767798899777799999',
  '111112222133311442133355422636335422666555444776588484776558889766998889777799999',
  '111222223441223323411233333415556666411555776444455576888889776898899766899999777',
  '111112222131114442333355422336355422366654447886557477886557777866699979888899999',
  '111112222331444442331444222311554266335555566337855996777888966788888966777799999',
  '111112222133122422133555424133354444636357474666657778696555778996998778999988888',
  '111112222331111242333332244355662444356666647555866447558877777858999977888899999',
  '111111112331442222344442522344466552336666655733668885773788885777788955799999999',
  '111112222131312244333312444356662447356862647355866647555897777558897979888899999',
  '111112222131142442333142442333344452355555556758886666788789666788789969777799999',
  '111111112313344222333544422333555442667754422677555888667775888666778898699999999',
  '111111222133331422335361422355366442755666442755668448775968488775988889777999999',
  '111122233112224333112224343155554343666654444767655558767699988777699988779998888',
  '111111222331444442331142222333444552335555566755888666777789966788888966777999999',
  '111111222331145222336145227366445277366645557338644557388649577888649977888999999',
  '111112222134142252134444452136446552336666655733688659738888859737789859777799999',
  '111222223111123333411223335446263555446666655444768655477788995777789999788888999',
  '111111122331132224333332224356666244555564444557666648577788888577789988779999999',
  '111111122133322222134333225434436665444666555466675575488777579888887779889999999',
  '111111222314444225314442225314466255336666655337668895377788895377888895777999999',
  '111112222133311222333441225633455555663444755666664775688944777888997779888899999',
  '111122233411223333441222355411623355466666665447786995447888955777788995778889999',
  '111222223411222333411523363415533666414555676444885576848895776888999776899999777',
  '111111112333122222443332552433662555436666675444866775844877755888889777899999999',
  '111112222113144222333134422353334444655555554666677757886679777888669799888899999',
  '111111122331445222341455222344456772333456777833456667888556967888566977889999999',
  '111111223141122223444452333644552233644555773668855773666857777688889979688999999',
  '111112222131311222333344452333645552666645555766645888764448888777998989777799999',
  '111112222111342552133342255333442555336645577666844777668847779866847999888899999',
  '111112222111133222333333422563444444566666664555555764885777777888779999888899999',
  '111111233112122233442225333466625533444666555774486665777488855778889899778999999',
  '111112222311113222333333342555566442556666644755664444758888888777899998777799999',
  '111222333111222233441255336411253366444555666447758996477558966778888999777888999',
  '111112222331444422311452226314455766334555766334557786399957886997777866999988888',
  '111111222133331422133533442666553422766555442776855444766885889776988889777999999',
  '111112222311444442313345422313445522333555666775588696778586696788888996777799999',
  '111112222311112442333322542336665547366555447365544477865887777866899997888899999',
  '111112222111132422333334442355366442356666647855667447855577777885879999888899999',
  '111122223441223333441223335411126355466666665447689995477788955777788955788889999',
  '111122223114423223114223333144555533444456666775555668777799688799796688799998888',
  '111111112334451222334552222344456277334456677338456667888855677888956677899999999',
  '111111122313312222333333222444566666455555556444445666777888888777798898779999999',
  '111111122113333222333444222335546662555546666755546688777444888777888899779999999',
  '111112222113312224133352644773552644773555644773855644773856669788896699888899999',
  '111112222314445222311455226314457766333457666334457786399557886999577786999988888',
  '111112222314444225314464255311464225336666655377868995337868895377888895777799999',
  '111111222113133332433332222444455552444456666755556666777788886788889899777999999',
  '111111112331444442533444622533346622533666772556687772556888772588888977599999999',
  '111111123414122223444223323444253333455555556777758666787788666788889696789999999',
  '111112222131144225331342225633345555633645775666647775688847977688449979888899999',
  '111111222311331222333345252663445552663444755866644755868647777888977997888999999',
  '111112222113112442333355442336354442736555482766658488766558888766799899777799999',
  '111111112331444222344455526334452226337458266377758866375558886777888966799999999',
  '111111123411442223444442333455552333677752223666755558666788888677788998679999999',
  '111112222311144522336145522336645572333645777836645577886649577886449997888899999',
  '111111112312222222333455266344455776344457776344557776338557666888888896899999999',
  '111111222131331244333355224666335224676555424677588444677558888667988989777999999',
  '111112222113333322113445322663445552663645755866644755887644799887777799888899999',
  '111111222331112222344566622334556677334555677334455677884445667888899977888999999',
  '111111222113331242333444442353344422655555552667778858677777888676988899666999999',
  '111111122133333322134352222664355552664444455766668455777768489778888889779999999',
  '111112222131114222335444442335554662337754466833755566877777566888799969888899999',
  '111111122133333342133354442667554422677555442667755422677758889678888889669999999',
  '111112333144122333142222533144422536445555566475886669775888869777889669777899999',
  '111111222113331442333335442666355422776555422776558444766588888766988899777999999',
  '111111222113332222413536622433536666435555576444475776884475796888877799888999999',
  '111123333111122234515222334555262334566666664577868444577888494578889999777789999',
  '111111222111345522333345552637445882637745582633744582677748888667748999666999999',
  '111112222133311224133355224663355424666357444686557744688557779688997779888899999',
  '111111122113444222333334222334444452355555556758888866777866666777888699779999999',
  '111111222133313222143333252444366652444666555746668555747888859777898889777999999',
  '111112222111322422531366424533366444533367774555667774585667974885887999888899999',
  '111111222111332222333334224556334444566666664555577644588577777888877999888999999',
  '111112222111133342533333442556636422755666442775686644755888884758889999777799999',
  '111111222333122222443115672443555677443356677443555677843599677888889666888999999',
  '111111122344451226344451226333455226374458826377558666377958886377958886779999999',
  '111112222311114222333354662355554672335444677835466667855467777888499997888899999',
  '111111222113322222143355526443357666443357766444357766485557769888887799888999999',
  '111111112333341522333344522637745522677745552667745582667448888667948888699999999',
  '111123333111224353611224353662224355662444755668477755868477995868477999888879999',
  '111123333112222334111252334666252344665555544667858444677858999677888899777789999',
  '111112222331144422331544426331545426378555426378585966378885966778889966777799999',
  '111122333112223333415522336414522666414555676444885676499885576999988877999887777',
  '111111112314444222333442222344455662335555566733558886777788666777888896799999999',
  '111111112331344222333345222663345552766645552766648855777648888777448988799999999',
  '111111112312222222334255666334455677334456677334556677444558677888888897899999999',
  '111111112333145222333345522336645552776444522766645588776648888777649888799999999',
  '111111222311414442333444222334455562733555662735558866777888666788898996777999999',
  '111222223411222333411253366441553336441555766488855766448859776888999776899999777',
  '111111222331112222333344422535346666535546676555547676884447777888899977888999999',
  '111111123122222223124445333444445333465555537666577777666577789688888889689999999',
  '111112233111222334122253334626555334666654444677555484677758889677888999778899999',
  '111112222131112242333335442336665542366555447865544477866577777868899979888899999',
  '111111222134444222134455226134445626333555666373588869377558869777888869777999999',
  '111112222311411422334444422333545462335555566738585666778888866778998996777799999',
  '111111122344411222344442225343466625333666555376668585377788885777998885779999999',
  '111111122113344422533344442533366442536666672588667772588887772558887799559999999',
  '111112222133312222443115552433333655466666665446777775844499755888897779888899999',
  '111111222113322242513323244556333344566666664557777644558787794858887799888999999',
  '111111122333114422533364442533364442576666642577768882577768882557799888559999999',
  '111111222133311422333355442663355422766654442776558844766558888776998889777999999',
  '111123333111122223122223333445566666445555566444445566777788889788889999777789999',
  '111111222331422222331444442331544466355555556337775866977777866999997866999888888',
  '111111222111344442333334222335544442635555572688885577666877777688887999666999999',
  '111111222311444225314464425334462225336666655377768855378868895377888995777999999',
  '111112222111342252613342255633344555633347775666447775668847795868847999888899999',
  '111112222133334422115334422165333442665555544766888549776688599776688889777799999',
  '111112222113311222333455522364445577366645557336644457886664777888997799888899999',
  '111111122133341222533342266553442666533742886555744866557748886777948889779999999',
  '111111122133331222333445552336445522766645552776644588766644888777988889779999999',
  '111122233112222233111442335666433355666444555667774555677844999778888899778889999',
  '111111222131133224333335244667535244667555244667585244667588888677889989777999999',
  '111122333111122344551223334522266334556666644577668884577788944557889999777889999',
  '111111222113341222333344442335354442675555542677758588677778888666978899666999999',
  '111111222113122222333444452366664455377764445337766665837777555888889599888999999',
  '111122333411222223415522333411556336444456666477455886777995586799999886777998888',
  '111111222331341222533341262533344266555546666557448886757948886777948988777999999',
  '111111112331444442333442442333352222655555552666657777688688777688888977699999999',
  '111112222113312222133344442335554444633555774666655577866667779888897799888899999',
  '111112333112222333112442353666422355666444555667884555767844899777888899777899999',
  '111112222131144422133334222335354444365555547666657577888677779886669979888899999',
  '111112222311414225331444255364444225366666665377888865337888955377898995777799999',
  '111111222331141222333345552336445552736645582766644588766648888777949988777999999',
  '111111222133132224133335224663355244666555444667558844677588889677789889777999999',
  '111112223111144233444442233445522233665555533667775588667788888667889999677799999',
  '111111222134444422134554622133544622333555666773885669773855869778888869777999999',
  '111111112133334442335344222335544422667555422667775588666778588677788889699999999',
  '111112222113332422133333442156364442556666644755568649755888889775788899777799999',
  '111122233112222223111433333444453566445555566445756666777776888799999988779998888',
  '111112222111133222443335622443535666433555776444575766884577766888779999888899999',
  '111112222113322224113554424333355444663357744666557777686655799688887799888899999',
  '111112222331311222333331442555366442556666644755668444755988888777998988777799999',
  '111111122131332222433335222444335566444555666445577666888577776888877979889999999',
  '111111112333331222435336672455536772455666772455687772456688782444988888499999999',
  '111111222133341522333341552673345552677444552677748852677948888667948889666999999',
  '111112233111142223444442233445452233665555533667758588667788888677789999667799999',
  '111111112333312222433552226433356626444555666474458886477755886777798888799999999',
  '111111122133422222133455552663477752663444755863334755866664779888884779889999999',
  '111111112133345552333345522663345552667444522677748822667748888677748889699999999',
  '111111222333311222344315262343355266444555666447558868747598668777998888777999999',
  '111111222113312242555366244533366274538367274538667774558667444858897799888999999',
  '111112233112122234512223334566663344555763444557766664577788894578889899778899999',
  '111112222331145522331645572331644572836645572836445977836645977886649977888899999',
  '111222223411522323441552333411153366444753666447758886777955866797995886799999888',
  '111112222113312422133333422563344444566666664555557764885777779885897799888899999',
  '111112222131444222131544422333545466337555466337575666887775969888777969888899999',
  '111112333112122234152223334555623344566666664557786444577788849578889899777899999',
  '111111122333141225663342255633442225663347755688844775668847755688949777889999999',
  '111112222311444255314442225316444255366666665337888695377788895337888995777799999',
  '111112222131142252336142557336642557336444577366845577366849577868849979888899999',
  '111112222111333244531336244533366224557666244577668884557688984557888999777799999',
  '111111233142221233142422233444455533644555773665557777668887879668988879668999999',
  '111112222111132242333332442563334444566666664555577764855877777858879999888899999',
  '111111222331312222433315522444355666443357766444557666885597776888897977888999999',
  '111111122131222222433556662433557766443357766443355776844455776888888979889999999',
  '111111222313311222333344252366644552366645557866445557868447777888997797888999999',
  '111111222314441222314445522344455626333356666373558886775588896777988896777999999',
  '111111222313314222333314422355366442556666644755668448775598888777598898777999999',
  '111111122112222223455266333455556733455666773445677773444668773488888899889999999',
  '111112222313314222333114255633344255666645555667448885667499888777498898777799999',
  '111112222133111222443355627444355627443356677483556777483556677888999669888899999',
  '111222333111123334511223334522264444566666664555567774588877994588879999888777999',
  '111112222113333222113334252633644455666645555664445775868477799888777799888899999',
  '111112333112112333422222355442663355446666655447766855447888885777899899777899999',
  '111111112333331222344435522344435622744555662774586668775586668777988888799999999',
  '111111122133144442334442222334455662735555562733558866777788866788889669779999999',
  '111111222331114222344444252334644652336666655736886855737888885777899955777999999',
  '111111222113444442133345422333355442663555722688557777668587779688888799666999999',
  '111111122334411222344442222333544466355555556337775666888877776888997766889999999',
  '111111112331422222333444442333545442635555572688585777688888777666668977699999999',
  '111111112331334222333344222344445552644555772655577778666778888666788988699999999',
  '111111122133341422333444442553466642533666772586668722588888777558987779559999999',
  '111122333111122234551223334556223344566666664557788644577788944578889999777889999',
  '111112222311444222311544462335554462333754666837755566837775996888777996888899999',
  '111111112312222222333333342566634444555666444555576664857777777888888897899999999',
  '111111112331332222433355222433455626444456666474556886777558886777788988799999999',
  '111111112314444422333544222335554622733854662773855566777885666778888896799999999',
  '111111122313134422333334222355554442677754442677755558666788888667789898669999999',
  '111112233112222333122244433156664433555666444775566648775559998777999988779988888',
  '111111222133134222533134226553334266555444666557488866577489886777489889777999999',
  '111111223111445223444455233466452223667458233677758338667558888677588999677999999',
  '111112222313311222333341442344444452355555556758888886788986666777996696777799999',
  '111111122313144422333333422566634442577666442577786662557888888557779898559999999',
  '111112222113312222313344424333554444365555547666655777686667797888897799888899999',
  '111222223411122233415123333415553636444456666474755586777798586779998886799999888',
  '111111122113332222433352662433552666434555676444855776844857776888877799889999999',
  '111111222133311222333444442333454442655555552677757888677777888666998889666999999',
  '111111222314115226334455226334452276344457776348857766388557766388599796888999999',
  '111112233111222233142223335444466635476465635476665555477788859778888999778899999',
  '111111112341555552344466552334466552344467772388667722388667772388888972399999999',
  '111111222111332222443335262433535666443555766444575776848577766888877999888999999',
  '111112222311311222333334425636344525666645555676448585674488888777998998777799999',
  '111112222111344442133355442333354442663555722688857777688557779688887999666699999',
  '111111222311133422333335442666355422766555442776558444766588888776889998777999999',
  '111112222311122222334155677344445667334555677344566667334558677999998887999988888',
  '111111112344122222334444422333554426335555566378855666778888866777779886799999999',
  '111111112333341222533342222535342666555444666555748686777748886777948888799999999',
  '111112333122222343112253344162555334666654444677555849667758899767888889777899999',
  '111112333412212333411222533442255536444456666475558866775888996777898896777899999',
  '111122333114422333114552323144552223444456666788855669787855699777886699777889999',
  '111111122331142222334444422333544426355555556378885666778888866777789966779999999',
  '111111222113341222333345225363445255366645557668644757688647777888947799888999999',
  '111111222113333222413335226443355526444456666475558866477588896777888899777999999',
  '111111222311312242333344242353664442356666647855566747858557777858897997888999999',
  '111122223111223333411522633444525636474555636474585666774885996777788999788889999',
  '111112222111133222443333552433366652444666555746668885744888855777889999777799999',
  '111111122333144222333145252336645552736645582766645588767649888777449888779999999',
  '111112222331112222333314552636344455666347555664447575866497777888899977888899999',
  '111111122331312222333332444355662244556666644557766448555788888777798988779999999',
  '111111112133332222433352222433455566444456666445556776888857776888877779899999999',
  '111112333441122333411222335442262355466666665447868855477888995777889955777899999',
  '111111122331414222344444222344555526333356666375555886777888886777898966779999999',
  '111111222133112222333345552366345552364444457866647557866647777888899779888999999',
  '111123333112224443122225433116525433666555444776585499776588889766688899777789999',
  '111222223111233333411235366412255366444555666447558896447578996777778999788888999',
  '111112222113332322411333322444443556445555566455766666887777996887877799888899999',
  '111112222133333242113353242166355244666555444667558449767858899767888889777799999',
  '111112222133333322144435322144455362144555667849556667889596667889999997888877777',
  '111122233122223223111443333155544636555546666575446668777744888799799998779998888',
  '111112222131144222331334422333355444665555544666557777886677977888669979888899999',
  '111112222111133322443335322444355326444555666478558666778588866778889999777799999',
  '111122333112123344512226334512266334555666444577668894577688894557789899777889999',
  '111111222331444422311354422333355442673555842677558888667758998667777988666999999',
  '111112333111122233444422333444422253455555556758886666777886666778889999777899999',
  '111111122133134442533336442553366642577764442576668822577688882577789889559999999',
  '111122333144452233114552233114652733444652777884652799886655799886657779888669999',
  '111112222113332222411333332444355666445555566444557666877777996888877799888899999',
  '111111222113333242513332242555366642556367644856667444858877794858777799888999999',
  '111112222133314222335314262335314666555444666555478688959478688999478887999977777',
  '111111222131342222133344442334445542335555566785588866788886669777786969777999999',
  '111111233141451233444452223444552223666752333677755888677758888667958989667999999',
  '111112222113114522663344572666345572866345772863345777863445577883499599888899999',
  '111112222111334422516333442556663342758863342758866644755888694775588999777799999',
  '111112222311112242335556642355556742335666744835677774836677744838899994888899999',
  '111112222133111224533336624553366224555367444588667744586677774588999779888899999',
  '111111222131341222333344422335544442365555547866665577886667777888967979888999999',
  '111112222131112224333352424633355444636555474666557774686857777688899979888899999',
  '111112333111122343222222344556663344557666344557766644557888888757889999777899999',
  '111111122333331222333441552673445552677745552677744852677944888666988888669999999',
  '111222233112223223111453333614455535666444555676664485777764888799799988779999888',
  '111222223111122333411225333466665335444465555477466665777488995777889999788888999',
  '111112222133344422111345442333355442637555482677558888677578999667778889666699999',
  '111112222314442222311544462315544466333555666337775586937775886999977786999988888',
  '111111112133333222433322252444326555466666665444678555747778885777888889799999999',
  '111111222113334422133333442536664442577666442577766682577888889557788899555999999',
  '111111112133345222336345552736344522736645582776448582766648588777648889799999999',
  '111112222311142252331345552333345552366444557866647777866647977868849997888899999',
  '111111122313312222333342242563344444566666664555557764858857777888897797889999999',
  '111111122133344422153366422753366442753368842755668842775668849775558889779999999',
  '111111122333141552333345552633445522667745522667744882677748888677949888669999999',
  '111111222311412222334455522334456667333456777344456677885556677888896997888999999',
  '111111122133342222133342225636345555636444575666647575688847779888847779889999999',
  '111111222344412222334115662344445562334555766835577776833599766888897776888999999',
  '111111122341144222344444222343355526333555666375556686777888886777889986779999999',
  '111111122133333442135333442665544442667555422677775522677888589677888889669999999',
  '111111112133344442334442222333455522635457582665557888666677788677778889699999999',
  '111122223111224333512264333512664433555666444775566894777568894777588999788889999',
  '111111122314414442334444222333555522633357772665555777666888877688898897669999999',
  '111111122133122224533226424533666444533367774555666774585688774588889779889999999',
  '111112222111132242333332444355362644356666647556867447555877777858879999888899999',
  '111112223114452223114452333444552233664457733668855777666857799688857799688899999',
  '111111222311314442333354422633554442673555842677755882667758888677798998666999999',
  '111112233122222333112442333144455663445555566744556668777966988777999998779988888',
  '111112222314411222334451226334557776334555766344455766388957766888997796888899999',
  '111112222314411122334444522333444526335555566375888666775888866779998896777799999',
  '111111122113222222433333325444336555466666665444677555487777775888888799889999999',
  '111111122113333224553332224556332624556666644576788644577788844577888899779999999',
  '111112222331311222431355622433356666434555676444457776884557976888997977888899999',
  '111222223411152223441552333441153336444753666477758866777955866799958886799999888',
  '111111112133333222334444422334445422655555552667577788667777788666888889699999999',
  '111111222133311222334333252664443552666645555766844455767888488777998889777999999',
  '111122333141225333141225366441255336442257766488557966448577969888577969888779999',
  '111111222333312242353112242553336644556666644556677744858899747858897777888999999',
  '111111222131144422333354422336355442736555482766558488776658888776669989777999999',
  '111112222113122242313554442333354444363555747666657777866655797868889799888899999',
  '111122233411123333412125336442225536444555666475588866477589896777789996778889999',
  '111111112344441222344442225336646255337666255337686655377788885777988885799999999',
  '111112222111322242551336244533336644533666774556677774558677944858887999888899999',
  '111111122331144222333345522366345552766348552766648558776648888777449988779999999',
  '111112333411122333441552323444552223464457727866655777868655977888669997888699999',
  '111111223411441223444445223666545223676555323677585333677588888677988998677999999',
  '111112233441112333444122333445552223446555277866655577888669777888699977886699999',
  '111112222333114252331144252333345552666645555766648888767449988767499888777799999',
  '111112222113314422333314442335555442637754482677555588677798888667798899666699999',
  '111111222131134225633334225663344225666347555688447755688477775688479979888999999',
  '111112222113311222333334425666344525666347555686447555684477777888997799888899999',
  '111112233112222333142253363144253666445555566444758669747758869777888899778899999',
  '111112222131112244335522444333524464733555664737785666777885566778899969888899999',
  '111111222333144222331154422336554442336555477866655477886659977888669777888999999',
  '111111122333311222433555262443352266444357666448857766848555776888997777889999999',
  '111111112313342222333342222335444444655555554666666577888867777888867797899999999',
  '111111112313345522333344552667345522677348552667748522677448888667748898699999999',
  '111112222133112242133355442663355442663357744866557744866557779868899779888899999',
  '111111122311222224335526624337566664377555664377775644387785544388888994889999999',
  '111111122311222224355566724335566724335567744385667744385667774388888994889999999',
  '111112222113333244133335224163555224666654444677555849677588889667888899777799999',
  '111111122133344422133354422633554442673555842677755882667758889667778889669999999',
  '111111112333331222433322252446362555446666655444768655747778885777988888799999999',
  '111112222113332242113334242533634444566666664555576774858577799858877799888899999',
  '111112222131112222334455672334456677344555667334456677834556677888899979888899999',
  '111111123114422223444455233644455233667752233667558883667558888677778899679999999',
  '111111122131333222333344222535546626555444666575546686777448888777888989779999999',
  '111111222311134222333334422355534424666555444676685558776688888777689998777999999',
  '111111222331314222533314442553366642753666842756668844755598884777598988777999999',
  '111111222314112222344444422333554466335555566337755666887777776888899796888999999',
  '111111122344411222344442222354466666355555556333337756888877776888997776889999999',
  '111111122133344442135334242335444222365555527666888577686877579688887779669999999',
  '111111222113132242333334242356364442556666644755568648757588888757789899777999999',
  '111111122113222222333334425633644555636645575666445775684477777888888799889999999',
  '111111112331422222344444222333444556335555566355777666888777776888887966899999999',
  '111112222331444222311444452331664452336666655738866955738888995777888955777799999',
  '111122333111222233411422335444426635476666635476685555477885995778888999777889999',
  '111111122131444442533464742533466722533666772553668772583868772588888979559999999',
  '111123333111122343512222344566223344556666644557788664557888894757889999777789999',
  '111111112333331222443322222444335556444555666455577666888887766888977777899999999',
  '111112222131142222331445562334455766344457776334557766835577966888879969888899999',
  '111111112344441222344442255333462225366666665377768555337788885777988885799999999',
  '111111112134442222333342222335544446375555546377775566888876666888877769899999999',
  '111112222111344422133344442335545462733555662738585566788886669778886999777799999',
  '111112222133322442153366442153336442153666748955677748955667748955997778999988888',
  '111111112331345522333344522633745522677745552667745882667448888667748988699999999',
  '111112223112222333122433335144436655446666655446675558477775998777999988799988888',
  '111111122314412222334445226344455266334555766338557776388577766888897796889999999',
  '111112233114112333444452333444452223665555522766658888777658888777699899776699999',
  '111111222311142222334444422333455446335555566377557666887777766888879996888999999',
  '111112222131142225133342525333345555636444575666647777686847779688849979888899999',
  '111111223141152233444452223664557223664457733688455733688857777668859979688999999',
  '111111222133342222113345522633345555663444755666647775886647799888847779888999999',
  '111112222131342225133342255133345555636444575666647778669947778699947878999988888',
  '111112222113334442113335422633535422666555444776585884776588899766688899777799999',
  '111111222344111222344455266344455266337458266337558886337558886777999886777999999',
  '111112233144111223444455223464452223666555333677758838677558888677999889667799999',
  '111112222113312224133354224635554444633357774666655574688657779688897799888899999',
  '111112222113342252613344752616347752666347555863347595863447795868847799888899999',
  '111111122333122222333144422335544444365555547666665577886669777888889777889999999',
  '111111122334152222344152266344552766344457776334855776338859776888859766889999999',
  '111112222111333322133333222444445666455555556444566666777888889778888999777799999',
  '111111222331145522331345222333345552666444555766648888777648988776649988777999999',
  '111111122314441225344422225334442655366666665336788855377778885377988895779999999',
  '111111112133332222333342555364442255666742555667744458666748888777788889799999999',
  '111112222113314442313344222333444452355555556758888666777886696788896699777799999',
  '111111222111334222533334226535334266555444666557488686577488886777488999777999999',
  '111112333112212333142222355444662335446666655477866555447888859777898899777899999',
  '111111222314112222344455262334455766334457766334557766838557776888899796888999999',
  '111111222333111242353336244355366224557666244577668448557688848757999888777999999',
  '111111122133333322133342222444445562445555566745566666777768889778888889779999999',
  '111111222313121244333322244536332444566666664555788684557778888557979898777999999',
  '111112222333312224335116244355516247356666647358694447558699477588897777888899999',
  '111112222113322422113544442333545644733555664773575666877775699887886699888899999',
  '111222223111242223515443333515643777515643787555643787666644787699949888699999888',
  '111112222131114422333334422355334442665555544766688558776688888776699989777799999',
  '111112222113344222133345225136345555636347575666647578699647778999447788999988888',
  '111111112333331222433332222444555526444456666475555666777788886777988888799999999',
  '111122223141122333441522333441523366445555566447785966777885966777889969788889999',
  '111111112331342222533342266533342266555444666557748886557748886777748988799999999',
  '111122333141112233441552233444452236478555236478856666778855966778899969777889999',
  '111122233112223333111224433566244443556666644755558664775588999777788899778889999',
  '111111222131441252334444252334446652736666652736688855737888855737988959777999999',
  '111122333412123333412222233415555666414456676444555576889999976888897976888997777',
  '111112222131414222134444225336664455336764655337766655388777759888797959888899999',
  '111111222111333322443355662743355662744358662744558862744558866778888999777999999',
  '111111122311332222333345552663345552764444452766648855766648888777788998779999999',
  '111123333111223233145522223144552663444456666744855669788885569778788999777789999',
  '111122233111223334551226634551226334557666344577688944576688944577788999778889999',
  '111111233414112223444442333455542223667555233677785558666788888677799898667999999',
  '111111112341444422344422222343555526333356666375555686777778886778888986799999999',
  '111111112313344222333354222336554442766555442766655488777658888777668898799999999',
  '111112222311444442331554422331544622333555666773885966778855966788888996777799999',
  '111112222131313442133333422556634442756666642755586644775888889755898989777799999',
  '111111222311451226334452226334552776344457776344855766388857766388957996888999999',
  '111122223411222333412253333411455536444456666475556886777759986777999886799998888',
  '111112222133333224113333244155566224556666644577664448557999988577999998777788888',
  '111112222111133242333333242553664442556666644755566844757888888757889999777799999',
  '111122233111223333411222353446625553446666655744486655747888995777788999778889999',
  '111112222111132222444433332444455533664555733665557777866667777888869999888899999',
  '111112222133142222133544442133545444333555666777575668977775668999978668999988888',
  '111112222131114422333355422333554442366654447866655777886557777886699979888899999',
  '111112222331112442333122444335552446377555446377855566777889666877899966888899999',
  '111111122334451222344551226334457226334457766388457766388955776888957766889999999',
  '111122223111122323415552333444452366447753366447856666777855596787889999788889999',
  '111112233112222223114423333555443636555546666575744666777784499788888899778899999',
  '111111122314451226344552226344452666344752886333758886377755886377958896779999999',
  '111112222113311442333344442335345442665555522677578588677778888677998899666699999',
  '111112222113332224113355224666355744663357744663557444688557799688877799888899999',
  '111111222113345552163344522763348552763348852766348852776448859766648899777999999',
  '111112222111322222144333335444466335476666635477665555477777558999997888999988888',
  '111112333112222233412526333415526663444555666744485596777485896778888899777899999',
  '111111122333331222344331222345566662445555566744445568777988668777988888779999999',
  '111111122333112222443335622443355662443555766844557766884577766888899777889999999',
  '111122333111223333112224453666244553666247555866447555864477799888877999888779999',
  '111111222131331442333344422334445422655555552667577788667778888677988989666999999',
  '111111222113331242553366642753368442755368442755368842756668844757988899777999999',
  '111111222131332222133345522633444555636645575666444775886647779888877979888999999',
  '111111223144141223444444233556666233577762223557666633557888888577989889577999999',
  '111112222311144255313342255333342255366645557668847777668847797668449997888899999',
  '111111222314412222313444422333554446335555566377755666887777696888897796888999999',
  '111111112333145522633344552663345552673745852677748822677448882667749888699999999',
  '111111222311422222341455562344457666343457676333457776835557976888887996888999999',
  '111112233112222333112422335444446335466666665477655555477885899777888899778899999',
  '111122223441122333411552366471552366477852336447855936447855996777889966788889999',
  '111111112331444442333445422363335422665555522667588828667577888677777988699999999',
  '111111112334155222334452222344452666344457776333857776888857766888559766899999999',
  '111111122131332222433352266433355266444555666447558886447758886777788989779999999',
  '111122233141123333142225633142525663444555666744585869774588869777789969778889999',
  '111112333122222233144252633114556633444555666774455688774959668779999998777988888',
  '111111222133333222133344422155346626555546666575548669774448889777888889777999999',
  '111111222113322242313552442333554444363654747666655777866855797868887799888999999',
  '111111112314445222344455262334452266337458266337758866737558886777588896799999999',
  '111111122314444422314442225333466625373666525376668555377788895778888895779999999',
  '111111122334114225344444425334666625377762225376666855378888885377899855779999999',
  '111123333111223334115523324666522224666555444677775444678875599688877999888879999',
  '111111122313331422333355442667355442677754442677558422677558888667988898669999999',
  '111112333121122343122222344555633344566666664557776444557888889757889989777899999',
  '111111112313332222333342522666344552666444555766448555776748888777788898799999999',
  '111111122333311442533334422563774442567777742566677842556688882566998888559999999',
  '111111222113333222413355226444355266443357766448557666488557796888777799888999999',
  '111111222133312222444313225444333365466666665467777555488797555888897779888999999',
  '111122223144123333441122233444125533445555566775589666778889966777789669788889999',
  '111112222111132422555534426575334426577734446587733646587736666887839999888899999',
  '111111222133332222145333322145553666444456666444755568997777568999977778999888888',
  '111111112312222222333324455633344555666347555666447775664487777888888897899999999',
  '111111222333111222343334522344444562345555567845666667885677767888999777888999999',
  '111122333111223333142225533144255666444257666444557668995577768999977888999778888',
  '111111122333311222433332225444366625444666555476668555477788885777998888779999999',
  '111111222133333322133435522166455552764444452766664558776694998779999998777888888',
  '111111112133332222433322555443322655466666665446778855444778885777788889799999999',
  '111111123144444223144544233677552233667555233667755223667885889677888889679999999',
  '111112222133442222133456627134455677134555678334556678394456778999966778999988888',
  '111111122133122222334444522333455567344456667345556777885666677888889779889999999',
  '111111222331412225341462225344466755344666775334667775388867975388897955888999999',
  '111112222311144442314444422333335526375555526375566666778888896788889996777799999',
  '111111223144115223444455233664452233677458223667758833667558888677599889677999999',
  '111112222111333442133334442335555442667754422677555588677788889677888999666699999',
  '111111122131444422333354422635554442633357772688855572668857777668888979669999999',
  '111111122333145222336145222366445572336645577836644557888649577888649777889999999',
  '111111222331455522331455562731445562733845662738844962738884966778884966777999999',
  '111111112333144222335544422633544472638555472638885772668885577666889777699999999',
  '111111112344441222343444522333334522365555527665877777665888787666988887699999999',
  '111111222341151266344452226334552276344457776348855766388857776338959976888999999',
  '111112223112222333112452336444455336447555366477556666477856899777888899788899999',
  '111111222133141552333344552667348552677348552677348522677448888677949889666999999',
  '111112222113414222133444422333354446355555556377756666887777669888797699888899999',
  '111111222311133222333333224556666244555564444557666644577888888777889998777999999',
  '111111222314112222344444522333444566335555566335777666885777776888899796888999999',
  '111112222313114222333144442333355442665555544766558888766669888777699898777799999',
  '111111222333114252333314552677334552677444552677488552677498888676499888666999999',
  '111111222111322222333333424353664444556666644555566747585777777888887999888999999',
  '111111122113333322433555662473356662477756662477758862477555882448888899449999999',
  '111112222133111244333335224663535244667555244667585844677588888667999889777799999',
  '111112222113322222413355566413357766444357666443357786445557786999997788999988888',
  '111112222314144222334114522334444566335555566335777766885799766888779796888899999',
  '111112233111222233415522336444552336474456636477855666477885596778888999778899999',
  '111111112313322222333344222355544444366555447666665557888667777888887797899999999',
  '111111222311422225361472725366477755336444755336664775386864975388884995888999999',
  '111111122311222224333332244353366444556666644555667747558877777588888997889999999',
  '111111112333312222333444222344445552344555667855566667888666777888897777899999999',
  '111111122133122222333345552633344552666444555766448885766648888777779889779999999',
  '111111112133333332453367772455666722445567722445666772455568872488888889499999999',
  '111112222314442255311444225331444625366666665376888955377888995337788895777799999',
  '111112222133122242333155244633155444663357744666558774669558777969998778999988888',
  '111111122331134422333335442667355442677555442677558422677588888667789988669999999',
  '111111122113333332444432222444332256455555556457788666777786666788888899779999999',
  '111111112331344442333345442633545422666555222667575882677578888677778988699999999',
  '111111122311222222334444442334544566335555566335775766877777766888888996889999999',
  '111123333121124335621124335622224355666444555667488885677489985677489989777789999',
  '111112222111333242551333442556633342756666642758886644755888944757888999777799999',
  '111111222311142222333444425336444425366666665378888655378888555777789995777999999',
  '111111222331444222311445522334455662334457766833557766885577996888777966888999999',
  '111111112333415222344445222344455226333457666388557776888577776888597666899999999',
  '111112222331442222311544442331554466337555466337755866977775886999977866999988888',
  '111112222133322224133355424113335444666555444666577788696557778699997778999988888',
  '111112222111322224331335424633335444665555544666577774686577977688887999888899999',
  '111112222133333222144433225144663355146666657448866557499885557999888887999977777',
  '111111122131332222333344225663344525666645555676448855677448888777788989779999999',
  '111111123144442223144444223556622233556666633557776633577888889577788889579999999',
  '111111222313131222333334252666434255666444555667484555767488888777989898777999999',
  '111122233411123333412225533414255636444257666484557696885577796888879996887779999',
  '111122333112222333111224335666244535666444555676448555677488999777888899777889999',
  '111111112313344442333334422355664442556666622577766228557788888577778898599999999',
  '111111222334441222344551226334551726334457766384955766388955776888977766888999999',
  '111111112334441222333452222333455562344456667845556777888856777888966677899999999',
  '111122233112222333111423353664423555666444555666784455767784999777888899778889999',
  '111111122133333422133533422675554442677754442677755542667885889667888889669999999',
  '111111122313122222333442255363345555663444755666647757668844777888889797889999999',
  '111112222113313224153333324555366224556666644577668444578888849577898899777799999',
  '111112333112222334122252344165553344666753444667755548667959998677999988777988888',
  '111112223111422323144422333444423353455555556757786666777886669787886999788899999',
  '111111122344141222334442222334455566335457566335557766888877766888979776889999999',
  '111122333122222333114252363114455563444456666745556688747959688777999998777998888',
  '111111122311222222333445525333345555663444755666647777686644777888888997889999999',
  '111111112133333222333322244556662244555666444557766644557778888777888889799999999',
  '111111122333311222344355266343352266447555266447758868447558668777998888779999999',
  '111111122131344442333354422637355422637555482667558482667758888677778989669999999',
  '111111222111222222344556677334455677334456677334556677334455667888888999888999999',
  '111111222131312222333333244356666244555564444557666648557888888777798989777999999',
  '111111112133332222334555262334456662734456682744456688747555688777788889799999999',
  '111111122344112222334442225336444455366666665337777655388877755888899775889999999',
  '111112223112222333142555333142456336444456666477456869777555869777888899788899999',
  '111111122333314222335614442335664422735666482775566488755596488777598888779999999',
  '111112222113312442133522244333554444363555747666655777668885779866897799888899999',
  '112222223111223333411233355441163555466666665444768855447779885777799888799999988',
  '111111112333331222344533262344552262444555666747755668747885668777988888799999999',
  '111111222113331442333354422336554422766555442776655488776658888766988899777999999',
  '111112333114152233144452333444552223464652727866655777888657779886659799888699999',
  '111122333411225336411125336442225336442555766488577766488579996488577996888779999',
  '111123333122222344111225344661255334667555344677558944667588999667888889777789999',
  '111112222333122224331154424331554444336555477666655877696658877699998777999988888',
  '111111112313344222333554422673554442673358842677755842667755888666778898699999999',
  '111122223111223333142223335144446635446666655476655558477799958777799888799998888',
  '111111122311322222333324424553336444566666664555677744585587777888887997889999999',
  '111111233441112233444442233445552223665752533677755588667788888667799988667999999',
  '111112223111442223414455233444455223666653333677558888667558898677788999677799999',
  '111111112314455662344756622344756682344756882347756882337756882377558892399999999',
  '111112223112222333112233333455666666445555566444444556777778899777888899788899999',
  '111122223112223333112244433155554433666654444776655558776669988777799988799998888',
  '111111222113331222443333252444336652446666655746688555747888855777988899777999999',
  '111112222331114222533134422533336444566666664555677774885579774888599977888899999',
  '111122223111223333112243353662445553666444555766644855767748899777788999788889999',
  '111112222113114422333333442553636442756666642755686844755888888775599899777799999',
  '111111122133122224333224444333254444355555556777758666777788666788889669889999999',
  '111112222133422222134444444133556664135555567833355667888888867999998667999977777',
  '111122233411122335441123335442223365466666665467788855477789955477889995778889999',
  '111122233122224233112544333115546633555546666775546688777446988779499998779998888',
  '111111222331142252333142552363445552363645757866644757866849777868849977888999999',
  '111111112333142222344442255344442265366666665367788885337788885777789555799999999',
  '111111112314555552344566752344556722344666772334688772384668772388888792399999999',
  '111111233112222233412526333442556663744555663744455866777485896778888899778999999',
  '111111222133332224113352444633552244663555744668855774666857799688877779888999999',
  '111111122133144422333333442553644442566666662577776822577888888557779889559999999',
  '111222223411122333415522366411533366447555366447775886447995586777998886799999888',
  '111112222111122222344556666334457776344555776344457766333355776888889999888899999',
  '111122223411523233411523333414522366444555666447885696777785996778785996788889999',
  '111111122331144552633745522633745882637745582633745882667745882677449988669999999',
  '111111122331441225344462225346662255344467775338866675388867775388977955889999999',
  '111111112333331222333322244555552264566666664567744444557778888777988888799999999',
  '111111122314441222344444522346665522333666555773366685773888885777988895779999999',
  '111112333111222234122253334625553434666654444676755584677758889678888999777899999',
  '111112222331411242331444442333354422355555556778856666788888966787998966777799999',
  '111112222333311122333341522344445526444555666475566668775968888779998888777799999',
  '111112222311114225334444425334464225366666665377868855378888855377899995777799999',
  '111112222133111222443333252446633355446666655447776655848777755888999779888899999',
  '111111122133331222433352266434355226444555666477558686447758886777988889779999999',
  '111111112333314222333444422533446442566666662577677882557777888555798888599999999',
  '111112222131112242333332444536362444536666674555867674555877777858899979888899999',
  '111111222131333244133355224663352224666555444677758844677558889667888989777999999',
  '111111222313311242333355242636355242666654444767558484767558888767998898777999999',
  '111112222111322224133324444333544544335555566775775666777786669788886999888899999',
  '111122233111222233144252333144455533444456666775556668777959668779999888779998888',
  '111112222331122242333155542333154444663654744666658777965558777969998877999988888',
  '111111222311452252313455552333456652783444652783384666788884696787784996777999999',
  '111112222113134442133334222335534442665555544766685588777688889766689899777799999',
  '111112222311114222335444462335554462337754466837755566837777566888799996888899999',
  '111111222311312242333332542663355542666654444765558844765788888767798998777999999',
  '111112222311412222331455526334457766344457776334457766385557966888897996888899999',
  '111112222111312222333344526377744556377745556377445556387446666888896999888899999',
  '111111122331442222331542422335544466377555446337775566887875966888877966889999999',
  '111122223112223323411123333444453566445555566445756666777789996787788899788889999',
  '111222233122223333111244433551146636555546666575548866774449888777799998779999888',
  '111111122333112224533622244533626444533666774555686774558886774588899777889999999',
  '111112222113122442133325442333355444366555447666557777866587779866889799888899999',
  '111111112133322222334335252334555552664444455766666488767688488777778889799999999',
  '111111222311144442333444422333545522363555727665585777668888777688889997666999999',
  '111111112334412222334442522344445526333555666375588886775788866777798866799999999',
  '111111122313142222333344222355554446377754446377755556888776666888879696889999999',
  '111112222133344222135444226135544466137555468337775568399777568999776668999988888',
  '111122223112223333112244334155554334666654444677655558677669988777799988799998888',
  '111122333411122233441225333441225536444555666475588966777588966778889996777889999',
  '111111112333341222335342262335442266555546666557744688757748688777948888799999999',
  '111111233412222233412233335412663555446666655444766895477778895778888895778999999',
  '111112222134412222334114255334444465366666665367777755338799755888897759888899999',
  '111112222113333222133453322144453666445555566444756668997756778999777788999988888',
  '111112222331122442333124444335125446375555546377589566777789666877889966888899999',
  '111112222113132222413333325443636555446666655444676755487777795888879799888899999',
  '111111223144422223145552223144453333646457373666657778699955578699997778699888888',
  '111222223411233333441222335441116355466666665447688855477999855777779885799999888',
  '111111122133312222333444222353344444655555554666667757888666777888897779889999999',
  '111111222133132222143335262443355566444357666445557766848577769888879779888999999',
  '111111122331451226344452226344455266347458286337558886377758886377958966779999999',
  '111111122311334422333355422673355442677754442677558842667558888667788998669999999',
  '111112222131112222333333424335555444666654444666555577686777777888899979888899999',
  '111112223112222323144255333144453363444555666747756668777559668797999988799988888',
  '111122223114222223114333333144455563445456566745556668777777688799999688799998888',
  '111112222331122244351662274351566774355567774355667874359966874339998844999988888',
  '111123333111422233511442233555542236557546266587746666887744996887774999888879999',
  '111111222313112242333335242366355442666555444766558448767588888767799898777999999',
  '111111123441144223544444223556666233577762223557666633577888883577889988579999999',
  '111111122133412222334456272344556672334555677834455667838456677888896779889999999',
  '111122333111222233411522336445552336444456666477855566477885996778888999777889999',
  '111111122133314442333344422566334442556666622577788662557778888577798889559999999',
  '111112222113313332414333222444453266455555556447856666777888696788898899777799999',
  '111112222113342442113344422333344452355555556758886666778886699788786699777799999',
  '111112233122222234112553334616653334666555444677754484677755988679999998779988888',
  '111111123441144223444442233556662233577666223557766633557788888577889988579999999',
  '111122233112222333114223335614445355666645555667644485677799488777999988779998888',
  '111112222133111222433335226433535666444555666444575776488577776888999779888899999',
  '111112222113132244133332224553336444566666664555677744588877779558879799888899999',
  '111111112133344222534444662534474762537777762537878862533888862555886669599999999',
  '111112222133112224133333324536666424555564444575666684578888889577799889777799999',
  '111111223411122223444455233464452233664555733668857737668557777688889997688999999',
  '111111112133333222333344222555554662755444662755466666777448888777888889799999999',
  '111112222111132244555532244665532774665333744655837744668837777668839999888899999',
  '111111122334141222334444422333445552633555772655588777668888877666989877669999999',
  '111111222113312242553333342553636642755666442756686844758888844757798899777999999',
  '111111222131122222334455526333445556377745556377744666387774466888889969888999999',
  '111111122333312222344312225344336655446666655446677557488897557888897777889999999',
  '111112223111222223441253333445553663444753666744755566777758966788888999788899999',
  '111112222113333332411335532466665222444465555777466665784488995788888899777799999',
  '111111112341444452344445552367775522366777552336677752366688882368888982399999999',
  '111111112333122222333422525633455555634444475666664775686884777888889777899999999',
  '111112222333142252331144255333145255366645557668649777668449977868849777888899999',
  '111123333111123333122222234552664444556666644555566744587777779888879999888879999',
  '111111112331342222333342255636344225666645555677448585667748888777748988799999999',
  '111123333111224353162224353166244553662247755866447559868477759868477999888879999',
  '111112222113122442133334442333355442665555544766558888766688889766779899777799999',
  '111111122314422225314424225333444465366666665367777555388787795388887795889999999',
  '111111222131122222333333424335554444665654544666655577686777777888889979888999999',
  '111111223411142223444445233647455233667555233667558283667588888677789998677999999',
  '111112222113333222413353262414355566444357666445557686949757786999777788999988888',
  '111111222131144422333354422335554442633754882677755588667758888667779989666999999',
  '111111112133344442333344242563344222566666662555778862575778888577778889599999999',
  '111112222131142222134444526334444566335555566335777766385777769888879969888899999',
  '111122233411222235411262335416663355447763355447766685477969885479999885779998888',
  '111111112331344422333355442667335442667555422677588422677558888667778988699999999',
  '111111233111444233444455223664552223674752823677755833677558888667888999667999999',
  '111111122133332222133433525666434525676444525676484555676884889777788889779999999',
  '111111122344115222344455622334457622333457666883457766883557776888599776889999999',
  '111112222113344422113554442333554442633357772688855777688855799668887799666699999',
  '111111233112222233144442333444542233455555556778865666777866669778888899778999999',
  '111112222314411225314462255334466275344666775348667755338867795388997795888899999',
  '111112222113312242513366242533667444553367744555366774858667794858897799888899999',
  '111111222331112244333355244637335244667555244667588284667558888667799988777999999',
  '111111112133333222444533262444533262745555562747885666747885666777888889799999999',
  '111112222331144422331155426337775426387555426387544466387559966887779966888899999',
  '111111112333314222344444222344455522333555666775558886777888886777896666799999999',
  '111122223412223333411122333415555636444456666474555586777998886777799986799998888',
  '111112222333312222334415266334115566344555667445588677449586677999987777999988888',
  '111111122113333222333443552666443552776645522766844555766844888777888899779999999',
  '111111222113331222333344422556336442556666644755688644775558888777988899777999999',
  '111123333411123335411223235466222255446666655447777665487877995488879995888879999',
  '111111122113344442333554422663354442633555772688857722668855777688887799669999999',
  '111112222113314222333314442335554442366555447866655577866697777888697799888899999',
  '111111122133312224333552424633522444636555474666885774686855777688897779889999999',
  '111111222111334422333334442335544442665555522677775588677788888667788999666999999',
  '111111222131332224133335224636535244666555444667585484677588889677788989777999999',
  '111112222331112222334156267344556667334555677344455667348459677888899977888899999',
  '111112222131142225133342555333442565737745565737844666777846669788849969888899999',
  '111111122331122224333332424566633424555666444575886664575788888577779988779999999',
  '111112222113333322415553322414453326444456666478856696778855596778888899777799999',
  '111111233112222233412225333444455536474456636475556666777588896778888899778999999',
  '111111112134444222334442252333446652736666652736688555737788855777888859799999999',
  '111111122131322222433333352444663552446666655744866555748888885777778989779999999',
  '111111222131122224533366244533667244553367744558366774558667774588889979888999999',
  '111112222113444222313444442313555542333356666785555696788888696777888699777799999',
  '111112222113142552333142255333342555663444755666847777668849777866849799888899999',
  '111111222314112222334445226334445566344555776335577766388577766888899796888999999',
  '111112222113112222443333325443336665444666555466677755487777755888899799888899999',
  '111112222333312222343315552443311655466666665446778855944478858999978888999977777',
  '111111122113322224553662724553662744533367774553866744583866744588887799889999999',
  '111112222131444422133444522134466552336666655733668859773888559778888959777799999',
  '111112222131444422131544662333544462735555562738885666733885969778888969777799999',
  '111111122131442222334442522334455566334457766335557766885877766888877969889999999',
  '111112333122222333114522363414525366444555666447585696747885699777888889777899999',
  '111111222331112244333522244333525444663555744666585777668885777668899977888999999',
  '111111122331133422533334442536644442576666642577776682577788882557889988559999999',
  '111111112344144222334442225334466225336666655377668855377788855777889885799999999',
  '111111122333311222343344522344445522344555667885566667885667767888997777889999999',
  '111111122133312222334352262344355566444357666445557667848857677888897779889999999',
  '111111222314142222334145262344445666345555576333577776838579766888879796888999999',
  '111111222131333322133345552663445522766444552776644855766648889778888989777999999',
  '111112233112222333122244333155546663555444666755546668777449998777999988779988888',
  '111112222311312442313354442333555422366654447886555777866657797866897997888899999',
  '111111122331144422344445422333555422633357772668555777668588887668889977669999999',
  '111112222113314422313344222333354444655555554666657777888667797886697799888899999',
  '111111222111334442333335442637355422677555442667558482677588888677788999666999999',
  '111111222133342222135544622133546667335546677355546778995446678999947778999888888',
  '111111122331122222333333452663644452666645555764445855764888888777779988779999999',
  '111112222311142555333142255363342257366444557368847757668849777666849997888899999',
  '111122233111222234516232334516633344555666444557776684577979684579999888779998888',
  '111111123444441223444451223667755233667555233667552233677859999677899999678888888',
  '111111222113122222333333442533644444566666664555556774855777777888889799888999999',
  '111111112333312222333332224555662444556666644555766444577788888777798888799999999',
  '111111112334451222344455226334452226334457766388857766388557776888957766899999999',
  '111122223112223333112243333144445556444555666455566667888869977888899977899997777',
  '111112222131112222334445627344545677334555677334565667384566677888899979888899999',
  '111111222133344222113334442553366642753666842756668844755588899777558889777999999',
  '111111122133444222133344442333354422655555552667758888677778889666777889669999999',
  '111112333141122333142222335444662235446666655478866555477888859777889959777899999',
  '111111122331444422331445422333335442665555522677588888667577988667777988669999999',
  '111111122133142222333544222353546666353546767555546767888446777888849779889999999',
  '111112233141122333441552336444552236478852236478855666477855966777889969778899999',
  '111111122331455222331456672834456672833456772834456672834456977888556977889999999',
  '111122333122222344111125334666625334675555534677584444677589999667888889777889999',
  '111122233111223223141223333444455663445555566744556666777788969788788999778889999',
  '111112222311114425334444425336446225376666625377688655378888855378899995777799999',
  '111111122331122222333332424536364444556666644555567674585877777888889977889999999',
  '111111222133331422333351442637755542677754442675554482677958888667988889666999999',
  '111111112134444422334444222536667772536367672533366672555888877558888879599999999',
  '111122233111223334151223334552263444566666664555768844577788949577788999778889999',
  '111112222111333222441353326433355626444555666474558886478858966777888999777799999',
  '111111122333112222333342225633444555666645555666444775688847777888899777889999999',
  '111111222331412222341444255344466255346666675338667775338777975888897955888999999',
  '111111222131122242333352442363354444365555547666657747866857777868889979888999999',
  '111111122131334442333344422335545422667555422667575588667778888677788989669999999',
  '111112222113132332143333352444666652744465552746666555748888859788789899777799999',
  '111122223111223233142253333144555366444456666447555668777759968779799888799998888',
  '111111122333141222334444222344455562334555766835557776888777766888979666889999999',
  '111112222331114222334144562344444562335555566735888886735889866777899966777799999',
  '111112222311442225331142255344446675346666675346677775338879955388877995888899999',
  '111111123144422223144442233554462233566666663557768833557788889577778889579999999',
  '111111222113322232144333332445356662445555566744458566788888669787778899777999999',
  '111112233111222333441252333442255563444456666745558866777858966777888999778899999',
  '111111122333331222343431522344444522445555566775666668775986868777988888779999999',
  '111111233114441223444442233455552233667752233667755558667788888677988899667999999',
  '111111222133112224533332444563332244566666664557788864555788884577799889777999999',
  '111112222311411222344455562344456662334457766833357776835557776888997996888899999',
  '111222233111243335611244355661243335662247755688847955668447995688847999887777999',
  '111111123441412223444422233546462233556666633557768683557778888577798988579999999',
  '111111122311442222334444425333644625376666625376886555378888855777788995779999999',
  '111123333111122334122225334622655534666654444675554884677588889677889999777789999',
  '111111122113333322433433522444445522464555727665577777665887887668888899669999999',
  '111112222133333222111334224556334444566666664555577644588577999888777779888899999',
  '111111222331451222334451262344455266344457776338557776838957766888957966888999999',
  '111111122133313442335333442665554422677754442667755522677888588677898889669999999',
  '111111122134144222334444252334466252336666655737668855737888855777889859779999999',
  '111112222133312242135313244665333244665555544667888544667898589767798889777799999',
  '111111122331133222333332222444444566455555556445666666777788888777889988779999999',
  '111111122113333224553633244553663224577666224577866844557886844577888899779999999',
  '111111222113344242133334442335544422635555572668885577688877779686887799666999999',
  '111112233122222233111233333444566666455555556444445666777778999778888889778899999',
  '111112233441222233441552223441153333444555666777758866799955866779999866779988888',
  '111112223112222223144553333144455363447456366747556668777755668799999988799988888',
  '111111122113344222333345252663345552763645852766648855767648888777448899779999999',
  '111112222111133422333335442336555442766654442766555488766588888776889999777799999',
  '111122233111222223414253333414553366444555666447755686777759686799999888779998888',
  '111111222313312222333314422335555444666654444666555577886697777888897797888999999',
  '111111112333132222333332444566662244555762444557766664555788888777789888799999999',
  '111111122331441222344445222334445662335555566733588866777588886777988966779999999',
  '111112222311114222333444526344444526335555566375888886375888666777899996777799999',
  '111123333111122344122222334566623344555666444557786664577888889557889999777789999',
  '111111122131444222334454422333454662735555562733858666778858866777888969779999999',
  '111112233144412333144412223445452223665555533677758588677798889666798889667799999',
  '111111222331131224333332244355552444666752444666755558667788888677989988777999999',
  '111111222311314422333335422663355442766555442766558844776588888776698998777999999',
  '111112222333122224533116244533616744553666744553686774559688774599998777999988888',
  '111112222111222322143333333445536666445555566444475566777777768997999888999988888',
  '111111122133331224533336244555366224577666224577668444557688884577988889779999999',
  '111122333122222334111255334616253344666555444667758494677558999677888889777889999',
  '111111122133344442135554422633354422633754882667758882667755589677778889669999999',
  '111111222133112222334455662334456672334555677834456677844556677888899779888999999',
  '111112233141452223144452333144552333446652277888655779888657779866657979886699999',
  '111111112133222222443333352443636552446666655744686855748888855777777889799999999',
  '111112222133332442135332244115332444665555544666788599667788589766788889777799999',
  '111111122133122222443335622433535666443555766444575776884577766888889779889999999',
  '111112222113312222144333325444363355466666665447767555487777559888897799888899999',
  '111122233112223233411123335444423665446666655466785555477789995778788899778889999',
  '111112222311444225314442225314466655336467655336667785399977785399777885999988888',
  '111112222313122422333112444333444454355555556757777666777899666887889696888899999',
  '111112222133112242333312442563334444566666664555577764855897777858899779888899999',
  '111111222113132222433333522444633555466666665444776555884777775888879799888999999',
  '111111222133311244533362244533662224553666744588866774558867774558997779888999999',
  '111112222133134522133334522166344525666347555686447559886477779886479779888899999',
  '111111112331344442533333442556634442556666622577786622577888882577778988599999999',
  '111111222131341255633344255663347225688347225688347755668447775668947979888999999',
  '111111222133322222143335552143366655443666755446667758944477758999997778999888888',
  '111111222111334422333354422333555422666654444776555888776658888776688999777999999',
  '111111112333341442533644422533644422536666672558886772558886772588987777599999999',
  '111111122314451222334452226344455266334457766338557776388857766888957796889999999',
  '111112222113311242333554442336544472836555472836665477866655777868997799888899999',
  '111112222131145522133345522333445552363645757866644777886647779886649979888899999',
  '111111222311134222333334242356664442356564647855566647858577777888579997888999999',
  '111111112133322222333442224335544444635555574666665577688866777888887779899999999',
  '111111122333311222343445222344455627344555667384556667888566767888997777889999999',
  '111112233111222223414422333444445333455555556777566666777886696788888999778899999',
  '111112222313114222333144422335554446375754546377755566887779666888799696888899999',
  '111111112133333322443552226443352266447555266447758866477755866778888889799999999',
  '111123333111222233441522333441552266444555666447755866999775866997777888999978888',
  '111112222111342222331344442333355444635555574666557777866667977888867999888899999',
  '111112222313122242333144442333155544663555744665558777966668777969998787999988888',
  '111111222333111222343335226344555266344456667448555667488577767888999777888999999',
  '111111122311333422333355422666354442776555422766658444776558888776888998779999999',
  '111112222133333242133335242116555442666654444766555488767599998767999998777788888',
  '111122333441222233411122333414525536444555666475585696777889996778888966777889999',
  '111112222113412222313455267333455667344456667344556777348556797888896799888899999',
  '111111122113222224333325244663355544663357744665557744668587777688888799889999999',
  '111112222131314242333314442353344442655555552677778858677798888676798989666699999',
  '111111222131331222433333552443665552746666652744466855744888885777988989777999999',
  '111111112333415222366445222336645522333645777886645577888644557888694777899999999',
  '111122333412125336412225336411255336444257666488557996488577796488579796888779999',
  '111122223112222333114523363144533666445555566444775668747795688777999988799998888',
  '111111112333312222433332252444362655446666655446768555747788885777798888799999999',
  '111112222331444422331544442331554662731555862733955866799995866779999866777788888',
  '111111122311444422334454622334455622733555662773558866773858866778888996779999999',
  '111111233411222233441445233444455223667555233677558888667588988667777998667999999',
  '111111123444141223444442233566222233556666633557777663557788888577989888579999999',
  '111122333122222333114452363114552663444555666744855699747856699777888889777889999',
  '111112222133333322134443322114555526444456666475555688779966698779999998777788888',
  '111111233141412233444455233446452233766555223776658288776558888776698989776999999',
  '111111223414112223444455523464452223666653333677758838675558888677799898677999999',
  '111112222333142225333142525631145555633444775666648875696948777699948777999988888',
  '111111222113332222133445252333455555663444755666664777868644779888877799888999999',
  '111111222331411255333422225333425555636444575666684777688884777668994977888999999',
  '111111122311444422333334422563334442566666662577788862557788888557777998559999999',
  '111122233111422233141442533444422533465555537665887777665877979668887999668889999',
  '111111222311455522331452222333455556373444656377774666888874966887774996888999999',
  '111111112333314422335564222335664422735666482775566488777564488775598888799999999',
  '111111122133444442133334422533634422566666662557786882557788889577777889559999999',
  '111112222111133222444435252444635557466635557466635777868637777888339999888899999',
  '111111222134442222134455562134456662334457766833357769835557769888877769888999999',
  '111111122113222222333234555633334555664444455666477775666478777888888799889999999',
  '111111112133322222333334225366644425666645555674445558677488888777778889799999999',
  '111111233111422223444422533644422533645555573665887773665887777688887999668999999',
  '111112222131444222135554226137754666337754466333754468399755568999777868999988888',
  '111222223111123333141223335444626635444666555476686555477788959777789999788888999',
  '111112222134122252134467752134667755334666755334466758934467758939998758999988888',
  '111111222314444442314454222313555262333356666737555686777959986799999986777888888',
  '111111122333312222344312552343366552446666655744668858744798558777798888779999999',
  '111111222113122222333444424333335444655555554666577777686666777888889799888999999',
  '111222233111223233411223333415666666455555556444444576888899776889899777889999777',
  '111111112134442222333442222344445556333555666355577776888877666888877769899999999',
  '111122333111222233144422533144442533445555566775866669775886669778888999777889999',
  '111111122333142222335142662335544662335546677855446677855849677888849777889999999',
  '111111222133333422135563442135663442775666422755866489755864489775888889777999999',
  '111112222134112422134444422333344566355555556335776666887777769887899769888899999',
  '111112222331144222331145526377745526337745566387745556387749966888449966888899999',
  '111111222311312224333352224333655544666654444665554777688857777688897997888999999',
  '111112222133332442133544442113554442633555772688855799688885779688677779666699999',
  '111222233111222234551233334561133444566666664555778864577779844579999888779999888',
  '111112222133314422133334422153636442556666644755686849775588889775598889777799999',
  '111111222111322242333355244363655247366654447368554747668557777868887999888999999',
  '111112222331112244333312244353662444356666647555866747558897777558899977888899999',
  '111111122333331222333341225666644525676444525676445555677849999777899999778888888',
  '111112222113333222411353262433355566444456666445557776848757996888777799888899999',
  '111111233114441233444422223554466223576666623577668833577778888557988899557999999',
  '111112222311142522313342552333345555366444557666647777866847797886849997888899999',
  '111112222133144442134444222134555526333356666375555869777888869788889669777799999',
  '111112222113312242133355244633355244666357444668557774668557779868897799888899999',
  '111111122331144222333444422333545442635555572688585777668888777666889977669999999',
  '111111112313332222333435222444435662445555566744586666777586888777788898799999999',
  '111111222344112225344162725334662755344666775334866755384869775388899775888999999',
  '111111222113345552133345522637344552637348582677448582667748889677748899666999999',
  '111112333122112344152222334555662334576666634577866444577888849557899889777899999',
  '111111112331422222334422255344466775346666675344667775338887755888887955899999999',
  '111112233122222333142255336144453366144555667448856667488559967888999997889977777',
  '111122223111122233145223336445333666445555566444777566477788569778889999788889999',
  '111112222311312222331334424533364444566666664555567774585577977888897997888899999',
  '111111112333341222333344552663745552677745552677745822677448888666948888699999999',
  '111222233141222233441152336441153336445555566477758866477958866779999868779999888',
  '111111222334412252344116252344466752334666755834667775838699775838897755888999999',
  '111112222344415262341115262344445662334555766833577776838599976838597776888899999',
  '111112222111332332414333322444445326455555556478566666778888696788788999777799999',
  '111111222344112222334415562344445662334555766833577776835597766888899776888999999',
  '111112222311112222333444526343455576344457776345557676385777666888899996888899999',
  '111112222311144442313554442333554642773356622783855666788855696788889996777799999',
  '111122333112122343112223344555526334566666664577684444557788899757889899777889999',
  '111112222311411225344444225333444625366666665376888555377888885377998995777799999',
  '111112222113144222133354242333554444336555477666655777868657779888669799888899999',
  '111111112133333222433555552433665552476666652477766882477777882444888889499999999',
  '111112222133112442533132642533336642555666444756688884756789884755799889777799999',
  '111111122131342222333342555336442555636742585666744588666748888777748989779999999',
  '111112222133122242333124444333155544366555447665558777666698777969998778999988888',
  '111111233441112223444442233454662223556666633577766838557788888577799988557999999',
  '111112222311112224333332424355334444665555544666677557686877777688899997888899999',
  '111111122133455222134456662733456882733456882733456882744456689777556889779999999',
  '111111122133314222334444222344445562335555566735588886777888866777896669779999999',
  '111123333111122333412222335444226555466666665444677555488777795888779999888879999',
  '111112222113112242333333442356664442355666447855566647855777777858899799888899999',
  '111112222314411122344444522343345562333555666735586686775888886779998896777799999',
  '111112222313144522333145552333145522366645557886649777866649777886449797888899999',
  '111122233111442233141422533444422533465555537665887777665887979668877999668889999',
  '111111122133332222143352262444355566443357766445557666848857769888877779889999999',
  '111111222111333322433353622444355626474555626474558666774858886778888999777999999',
  '111111222133311244533362224553662724553666744583866744588867774558997779888999999',
  '111111122311342222333344522666347525666347555686347555886447777888847997889999999',
  '111111222313114422333333422356664422555666444775566648775888888775599898777999999',
  '111112333112222233144222333144455563444555666745556668777999668779999988777988888',
  '111111222341112222344456622344555666344457776333555776883357776888899976888999999',
  '111112222111332244153336224553666724553367744583666744588677749558877999888899999',
  '111112222331111422333333442355666642755564442756666448755888888775999988777799999',
  '111111122314441222334452226334555726334457766384555766388857766888977796889999999',
  '111111122311322222333333452666634452666444555764485555764888888777778998779999999',
  '111111122334141222334442225334644425366666665378886855377788855777989855779999999',
  '111112333111222333122244435622645335666645555677645885674448889777888999777899999',
  '111112222113333222113343322556344444566666664555557644887757799888777799888899999',
  '111111112333312222344552622344455672334456677834556667884855667888897777899999999',
  '111111222331114422334444452637744552637777752633887752638888855668899955666999999',
  '112222233411222335411123335411633555466666665444776885477798885477999885779999988',
  '111112222333145222363145522366144557336148577366448557996648757999648777999988888',
  '111111112133342222553442622553342666533347776555847766885844766888847779899999999',
  '111122333412222233412253333411556666441555766444455776888859976889999976888997777',
  '111111112334412222334445222344545662334555766833575776888577766888897766899999999',
  '111111112133322222333344522633445525666645555676644885776448888777778889799999999',
  '111112223111422333144442333445552263748555263748855566777866669777886999788899999',
  '111111122133341222335444442635554472633854772638855572688888577666987779669999999',
  '111111122131222222333445552336445557336645577366644577866644777888888979889999999',
  '111111222131332244133333224553662244556666644557766844577888889557788989777999999',
  '111222223111123323415223333415553666444456666444755586777799586797798888799999888',
  '111111222131144222333444422333444526355555556375888666778888666777889969777999999',
  '111111222113333222133443522444433562445555566745886666775866889777888899777999999',
  '111111122134441222334442255344646225336666655377686885337788855777988859779999999',
  '111112223141412223444412233445555233466653337668555577668897777688897979688899999',
  '111112233111422223144423323444525333445555566777585666787786669788886999778899999',
  '111111122314142225344442255344662255346666675338866775338877775388879795889999999',
  '111111222131441222334455526333457726384457726384457666385557766888977969888999999',
  '112222233411123235441123335411626335446666655477686995477789955478789995778888899',
  '111112333111122334552223334556222634556666644576888644577788844577889999777899999',
  '111111233141222233142255633442256633744555663774458866774558869778888969778999999',
  '111112222111312245663372245663772445663777455633877455638874455638894999888899999',
  '111111222333111244333333224566662224555564444577766664577888888557999888777999999',
  '111111222314156222344156722334556772334456677833455677883459667888459697888999999',
  '111112222133342555133342255163342255163444758669947758669947778666947778999988888',
  '111111222333312222334311552344665552346666657844466557844997577888897777888999999',
  '111112222113333224156632224155633334555666444577776448599976648599777788999988888',
  '111112222111314222333334242335354444665555544666657577868677777888697999888899999',
  '111111223144412223445412233645442233665555533667788583667798588677798889677999999',
  '111122333144142333144442233114545223665555522766585899776688889777689889777669999',
  '111111222344111222344444522333344562335555566735886666775888886777999886777999999',
  '111112222113113224533333324555366224556666644577668444578888884577899899777799999',
  '111122233141222223144255333114445333444555666777566688777559668799999868779998888',
  '111111222113132224533333244555336224566666664577688444557888884577789899777999999',
  '111112222313111222333344422536336444556666644555677674885557777888999797888899999',
  '111123333411222335411222355441262335466666665477868955447888995477888995777789999',
  '111111112333331442533644422537664422537666482557766482557776882577988888599999999',
  '111111122133331222334456662734556682734555682734455682744456688777988889779999999',
  '111111122333144522333145552663345552673745852677748822677749888667449888669999999',
  '111112222133342252113344552166347752666347555863347559866447799868847779888899999',
  '111112222311112222334455562377445566337745566337744556837774466888899996888899999',
  '111122233141122333144225363142255363444555666747558869747588669777889969778889999',
  '111112222333312222433311125444336555466666665444677555489997775888897777888899999',
  '111111222113333332144443222445543362745555562748865566777866669788888899777999999',
  '111111222111333332444433222444332256455555556457788666777886666788888999777999999',
  '111222223111223333114223333514446666555546666555544476888899477888899777899999777',
  '111111112312222222333344442335345444635555574666567577866667777888888897899999999',
  '111111112331455222333445522333645522736645582776645888776644888777664988799999999',
  '111111222331452222331455622331456677344456667334456877994556877999956877999888888',
  '111122223122223333111123343556664443555666444755566644757789999777788889788889999',
  '111111122314444425314644425333662225377666225377766555378886895378888895779999999',
  '111111222313141422333344442533364442566666662577768882577778888557979898555999999',
  '111112222111132222445533266447553366477753336447755366448775566888879999888899999',
  '111112222311444422311455426333454426373555626378858666378558996778888996777799999',
  '111112222311312442313344442333345442655555552677578888677778898677698998666699999',
  '111112222311142222314445266333455576344457776345557666338577796888879996888899999',
  '111222223412223323411133333415166666455555556444447576888887776898899976899999777',
  '111111122331142222333342252633445555663645755666644775868847777888849977889999999',
  '111111122133122222333324442353366444556666644555667747855587777888889779889999999',
  '111112222111322242133334244333554444365555547666655777668677779868887999888899999',
  '111112222113333322113444352663645552763645852766645855768444899778888899777799999',
  '111111122133122222433333225446336555446666655444677655488777775888889779889999999',
  '111112222111134222555534226553334776533444776533477766588476666888479999888899999',
  '111111222333312222333114422533644444566666664555556774885599777888897777888999999',
  '111112233122222333111243355666243355664444455667748555667748999777888889778899999',
  '111112222111132422555532444556332447556634477566833477666837777886839999888899999',
  '111112222311142222331444452336666455377764445337666655837777955888879995888899999',
  '111111122311333422333334422556666422755564442775666644775588888775888998779999999',
  '111222223111122233411523336444553366447555366447755666477785996778889999788888999',
  '111112333111122234522222334556663344556763644557766644577888884578889999777899999',
  '111112222131132224133335524636355424666357444686557474685577779688879979888899999',
  '111111222331112242333335542663355442766654442766558844765588888767799988777999999',
  '111111112331444442333455422633455422663357722668558772668558777688888977699999999',
  '111112222133311122333444222533664444536666674555566774888555777889997779888899999',
  '111112222113334422133335422136535442666555444766585489776588889776688899777799999',
  '111111222133114442333335422637755442637555482677554482667588888677799889666999999',
  '111111222111332242333333244536662244555666444557766684557888888757788999777999999',
  '111111222311132222333333324555556624556666644576644444578888888777789998777999999',
  '111112222331422252311466652331465557333465777344465877946665887949995877999988888',
  '111111222314411222344445526334445226333555666377588866375588886777998896777999999',
  '111111222113322222133334255633444555636645575666444775668477779888887799888999999',
  '111111222133131222333334225666634255664444455667485555677488888777989889777999999',
  '111112222133144222133154422333354444365555547666657777886659779888669779888899999',
  '111112222331311422333351442336554422666555444776655488766958888776998988777799999',
  '111122233114222233144252333114455633444555666774556688777959668779999688779998888',
  '111111222133312222133345522634445555633645775666644475886647779888897779888999999',
  '111112222111344225331342225633345555633645775666647775688847977688447999888899999',
  '111111222311122242333332442553336444566666664555677744855877777858889997888999999',
  '111111122333331442333431442556444422566666662557777622577897999577899999558888888',
  '111112222133332442133352444163352244165555547668859947666859997866899997888877777',
  '111111233144442223154444223156642223556666633577786639577888839577788889557999999',
  '111111222113312242553366242553367742553666744853367744858667744858897799888999999',
  '111111123411442223444442233455552333667752233666755558667788888677788998679999999',
  '111111222311144225333342225333345255666645555667648888677748888677449998777999999',
  '111123333112123343112225344662255344662555744668557744668577799868879799888879999',
  '111111222334112252344146252344446652334666755836677775838679775838899755888999999',
  '111111122311334442333344422553364442566666662577768822557778888577788998559999999',
  '111111122113442225633342555633342255633742885667748885666748885677744899779999999',
  '111111222133311422333444422333554442675555542677755888667777888667998889666999999',
  '111111222133332222114333322444435666455555556444576666887777699888877779888999999',
  '111111222133332242113332444566332244556666644557788664555788899757788889777999999',
  '111112222131144422331444422333345426355555556378586666778888966778889969777799999',
  '111112333141412223444412233445552233465752538667755588667798888677798989666799999',
  '111111112334414222344444425336622225336666655377776655378888885777898855799999999',
  '111111222331145252333145552333345552667444522677748888677749888676749988666999999',
  '111112222131312444333312244353662244356666647558866747558897777555897979888899999',
  '111222223111222333141233353441663555446666655444766855747779858777999888799999888',
  '111112333441212333441212533442222536445555566475888866775898966777898966777899999',
  '111112222311414442313444222333455552333456777855556777888666797866696997888899999',
  '111112222113344422113335442663555742863357742863555744866577799886667799888899999',
  '111112233412222233411123333444425536445555566475586666777789996778888896778899999',
  '111112222111333222441333225444663335446666655477766555488777955888777999888899999',
  '112222223411212333411112355446633335446666655477776655447899995777898995788888899',
  '111111112134442222334442222333444566355555556335777666888877766888877769899999999',
  '111111112333312222443355226443335266447555266447588866477558866777798888799999999',
  '111111122131422222334444252336444455366666665337777655838777755888887959889999999',
  '111111112312222222333445255333345555366444557666647777668644777888888897899999999',
  '111111222333111242333355442677355442677358442677558442677558888676999888666999999',
  '111112222133312222133333244155534444666555444666675558669777778999987778999988888',
  '111111222113412222333444442334455542333555666785558866788888666777798699777999999',
  '111111122344411222333444222355554662337754466833755556888777666888997776889999999',
  '111111112133322222333324424563324444566666664555578864575578888777778889799999999',
  '111111122133322222134455252333455555633444775666664777868664479888887779889999999',
  '111111222133314242133444442333454522635555572665858777688888779686897779666999999',
  '111111222311144425344446225334646225337666255377686855377688885378889995777999999',
  '111112233111444233144454223446555233776652233776555288766858889776888999776699999',
  '111122333112222333411522336414552366444555666447855696477885996777888899777889999',
  '111111222113333224513633244533622244556666644557776884557886894577888899777999999',
  '111123333111222344511262334555262234576666634578868444577868994557888999777789999',
  '111112223144112333444122333444222533455555556775888666777889666777899669788899999',
  '111111233112222223142253333444455633444555666774556666777758869788888899778999999',
  '111111112133333322433443522444455522664457722665557777665877887668888889699999999',
  '111111112134444222533444462533477662537777762533778662538888662555888869599999999',
  '111112222133311222333331424536664424555666444575566684575988888777998889777799999',
  '111111222311331242333344242335544442675555542677775588676778888676988998666999999',
  '111111222133314422335314442335554222366654447888655577866697577886697779888999999',
  '111112222333114422335166422355164427335666477385569447885669477885599777888899999',
  '111111222333142222341144252344446655346666675336677775838779975888879555888999999',
  '111111112344441222344442252346662255333666555337766685737788885777988885799999999',
  '111122233112223223411123333444553666445555566444755666777789996788788899778889999',
  '111122233412222335412263335411166355447666355447668885477769985477999985779998888',
  '111111222331142222355146662335446772335546677833544677855549667888849977888999999',
  '111111222311312244333355244336352224666555444677758488667558888667798998777999999',
  '111122223111223233411223335444463355466666665447765555477788995778788999788889999',
  '111112222133332242133544442133554442136555478966655778966665778969977778999988888',
  '111111222134142222134444255334464255366666665337868855337888859777789859777999999',
  '111112222131142252633142255663347755633444775663347755668849775868849979888899999',
  '111111122131344222333334242353444442655555552677777858676788888666778989669999999',
  '111111223144112233444442223564422333566666663555778863577788888557799889577999999',
  '111111122113332222443332255433362555466666665444768885447788855777788899779999999',
  '111111222113312222333344442553366642553666744856667744855557777888897799888999999',
  '111111122113332222333434222335444444655555554666666577888676777888877799889999999',
  '111111112331444442333442422333452222355555556777758666778788666788888966799999999',
  '111111122313312222333345552633444522666645555776444885766648888777798898779999999',
  '111111122334112222344445226334445526334555766385577766388577776888899766889999999',
  '111111222331113324533333624555566624577762224576664444576888884578899988777999999',
  '111112222111312222433333325444336655446666655446677555487777775888897999888899999',
  '111112222131145522133345222336645557336444577366645577888647779886649979888899999',
  '111111122333112222343355262343455266344456667448556767848557767888899777889999999',
  '111111112313222222333245525334445555633645775666644477686648777888888797899999999',
  '111112222134444222133444225133664455136666657338866557399888557999888857999977777',
  '111111222131314222333344422335445442365555547866566577886667777888697979888999999',
  '111112222331311224333315524666355224666357444688557444685597777688997977888899999',
  '111111122113333442333533422675554422677754442667755542667885888677888899669999999',
  '111111122131222222333334425633344555666645555666447775684477777888888979889999999',
  '111111122333112222333332244556362444556666644555768644557788888777799888779999999',
  '111111122131222222433355266433335666443555766444577776448557776888888979889999999',
  '111111222311133242333334442566634442577666442577786662577788888575889998555999999',
  '111112222131114222335544442633557742663357744863355774866665577888699979888899999',
  '111111122133331222333445522363445522666645555776644858776644888777988889779999999',
  '111112222113122244133526444735526644733555664773385564777385669778889699888899999',
  '111111222333112222343315522346665557346465657344466657884497757888899777888999999',
  '111111122333142222333142225633644555636645575666445775688849777888849777889999999',
  '111111222134444522134464522134664522333666555773866859773868859773888859777999999',
  '111111112314455552344466522344466552377468552377668882337668882377778892399999999',
  '111112233122222233112433335144443665446666655466755558477775988779999998779988888',
  '111111222111333222433355266443335266447555266447588866447558886777888999777999999',
  '111111112313344422333344442355344222665555522666778558677778888667778898699999999',
  '111112222113122444333124444333322454355555556757886666777789666777889699888899999',
  '111122333141122233444122333444122536455555556475889666777889666778889969777889999',
  '111111222131333222133343225666344525666444555676448555677848889777888989777999999',
  '111111223114441233444442223556646223557666233577686633577788888557988899577999999',
  '111111222131144442333444422533346662533666772566687772558888777588889979555999999',
  '111112222311112422333352424333555444636654474666555777686857777886899997888899999',
  '111111222131122242335524442333544466377555446337775666877785566878889969888999999',
  '111111223144112233445522233644552733644852773664855773668885577668899779688999999',
  '111111222113132222443335226433555666443357766444555776488577766888879799888999999',
  '111111222113331222433335262434535662444555666744585686747588886777988899777999999',
  '111111122333312222344312526344332566445555566445788668475798668777798888779999999',
  '111112223112122333412223333444455663445555566744556666777788896777889899788899999',
  '111122223112223333412255533411456633444456666774456886775559986777799988799998888',
  '111112222333312242335311142665334442665555544766688544769998588767798888777799999',
  '111112222331112222344155562334457766344457776334457766835559776888899966888899999',
  '111111222131132222433335662443335662445555566744588866744588886777789989777999999',
  '111112222311411222333455226344457766344555776334457776388557666888997996888899999',
  '111111122314442222314344422333344552335555566755886666778886896777788896779999999',
  '111111222133312222134335262334355566444456666445557677848577679888897779888999999',
  '111112333114442323114422223444455223665555533677558888677778899676788899666799999',
  '111111222113333222145533662444533362744555662748885666744885569777888899777999999',
  '111111222331441222344441522343445562333555666735588686775988886777988966777999999',
  '111111112133333332444353222444455222644555772666557777666858777688888889699999999',
  '111112222311112222333344424333544444355555556777775666787776666888899996888899999',
  '111111112313322222333442255333442555666645555666744888667744888777778898799999999',
  '111112222113322244113552644773552664773356644733855644773855699778886699888899999',
  '111111122311222222333442555333345555366444557666647777666844777888888997889999999',
  '111112222331111222334444425344644625336666655376886885378888855777999955777799999',
  '111112233441122233411455233444452233467555238667758888667558998667779988667799999',
  '111111112333144222333354442335554222677754442666755588677758888666779888699999999',
  '111111112341452222344452226344455266333457666338557776388857776888857976899999999',
  '111112222131142422133544422333545466377555446337575666887775669887879969888899999',
  '111112223112222223414553333414553636444753666474755686777755686799999988799988888',
  '111111112333122222343526662443557762443555766843355766844485767888889777899999999',
  '111111222333141222344144225344446625336666655376688885377889885777989555777999999',
  '111122233412222233411253333415553666414456676444855576888859776889999976889997777',
  '111112223441122233441125233444425333465555537666587777668589977668889977688899999',
  '111122333441123335411222335416262235446666655478868695477888995477789955777889999',
  '111111222311312244333352224666355524663357744685557444688857777668897997888999999',
  '111111122311322222333332452336644455666645555664445577864877777888887997889999999',
  '111111222131444422331444422335555462733356662738555566778888966778888969777999999',
  '111111233411222233415522333444552236474456636478855666777885596778888996778999999',
  '111122233441152333411552333441652237444652777486652977888655997888659977886669999',
  '111122333111123344551223334552222634566666664576888844577788944557789999777889999',
  '111112222311444422313455422313554442333356666788855696778558696778888996777799999',
  '111112233441222333411223335412266635444666555476668895477788995777888955778899999',
  '111112233441122333441225536441255336472258836477558966475588966777889966778899999',
  '111111122314122222334444442333455542333555666785558666788888866777779896779999999',
  '111111222133322222133445552136445557336645577366644578966644778999997778999888888',
  '111111122313122222333444442333545542366555447865565777866666777888889797889999999',
  '111111122313134222333334222566634424555666444575586664777588888777589898779999999',
  '111111222113133222333333422555555462554444466754666666774888888777889899777999999',
  '111111222131455222331456277334456227344456667388456677338456977888556979888999999',
  '111122233112122333112223343555566344556666644557664444757788899777889899778889999',
  '111111122311222222344444255334444655366666665336777755338777775888888995889999999',
  '111112222111345252133345552333344522366645557886447777866647779868647999888899999',
  '111111222133314222333314252636344255666645555667448585767498888777498889777999999',
  '111111112312222222334255677344556677344456667334455667334558677888888897899999999',
  '111111122113345522333344552367345552667348522677748528677448888667748899669999999',
  '111111122333341222333441222334445552444555666755566688777966888777968888779999999',
  '111111122333112222333344255663342255666444555667748855667448888777799888779999999',
  '111111222133333224153362244153366244557666244557668849557768849577888889777999999',
  '111111222113331242333344442536446442536666672588688672588887777585977799555999999',
  '111111233122222233142555333142456633444456666774456869777555869778888889778999999',
  '111123333121124353122224553166244533666247555886447559866477779868479979888879999',
  '111112222313311442333331422355554442677754442677755558667988888677998898666699999',
  '111112333111122333442225363422255563444456666745558886747588866777889999777899999',
  '111222333411222335411123355441226335466666665477688955447789995477888995777888999',
  '111222333111222343511262344516662344557763344557866694557868994757888999777888999',
  '111111222311144442333334422536336442576666642577688682557788888577779998555999999',
  '111111222331114252333344252633342255666645555667748885767448888767499988777999999',
  '111111222131312224533332224555333644566666664556777444588877774588897979888999999',
  '111112222111334252163334252663334552663444755866477755868477759868477999888899999',
  '111111112344144422334445422333335222365555527666577777668588877668889887699999999',
  '111111222133314422133334422536636422555666444775686684775588889775598889777999999',
  '111111223441411223444455233666455223677458223677558333667558888677998988677999999',
  '111111112333321222334322255334442555666645555666744488667778488777978888799999999',
  '111111122314144225334444225334466625377666225376668855377888855377889895779999999',
  '111111222133311242335333244665553244667752244667855544667888588767998889777999999',
  '111111112333144222536644442533647742583666742583386772588886672555889777599999999',
  '111122333111223334112222334552666634555564444576666844577888899577788999777889999',
  '111111122131442222335444262335544462337555466837775566838777566888877969889999999',
  '111111123114422223444425523664445223666555333677588833675578888677778899679999999',
  '111111222113144442333333342556663442577666442577866622578888888577779899555999999',
  '111111222333141222553341266553442266533347776558844766558947766888949777888999999',
  '111111222311442222341445662344455662334555766833557776833577976888877996888999999',
  '111111112331334442533344222563344442566666662577778862555778882577788988599999999',
  '111112223114422223411452323444455333646555373666557777686857997688887799688899999',
  '111112333144112333144442323445452223665555522766658588767688889777699889777699999',
  '111111222314141225334446225344666225334467755388666775388677755388979795888999999',
  '111112222133334442111355442333355422677754442667558888677558999677788889666699999',
  '111111122333314522633314552677334552677444552677488552677498882667498888669999999',
  '111112222311144225333146255773346255778346255778346655778349666788449996888899999',
  '111112222333312442333311142355566442756666642755664448759998888755798888777799999',
  '111111222134441222134544266334544226335555566377885866337885869777988869777999999',
  '111222233111222333141252336441555336444456666477555866477959868777999888779999888',
  '111122223114222323114233333144555563444456666745555668777779688797999688799998888',
  '111111222311132224333332444533662244556666644557766884555788888577789998777999999',
  '111111122314441225344444225336646255377666225337686655377888885377988895779999999',
  '111111122313122222333342525366445555336444577666644557686847777888889797889999999',
  '111111222133344222113334442556633342756666642758886644755588899777558889777999999',
  '111112222111322442133344442333554442335555566788855666788886669788776999777799999',
  '111112222111333224513333224555663324556666644578866444577888894577888999777799999',
  '111112222311411222344444252334666655334467755336666755838777775888997995888899999',
  '111111222131144222333554422363355442663357744866557747886655777888669979888999999',
  '111111222113142222553346772553446672553346677853344677855346677888849699888999999',
  '111112222113312444133332224536336244556666644557688684577788889555798899777799999',
  '111112222133311222134333252634435555666444555666674475868777479888997779888899999',
  '111122333441123333411122233444425226455555556477576666887779996888879966888779999',
  '111112222311114222333334442355366642556367644856667447855577777888599997888899999',
  '111112333412222233411522233441555633444456666774555866779995886779999986777988888',
  '111111222311144442333333422335554442665754522677755588667888888677779998666999999',
  '111123333111222343512222344516626334555666444577686694557888894757888999777789999',
  '111112233112222234115522334555633334566666664577776444577884499578888899778899999',
  '111111222111332224533366224533336244555666444557688884577668884577788999777999999',
  '111122223141122333142223353146666353444465555747666658747799958777998858799998888',
  '111112233121222333122244533144445533444555666775566668775669998777999898779988888',
  '111111122331312222333345222366445555366444557666644557888647777888897977889999999',
  '111111112331442222334452627334556627384555627384455677384856677888866977899999999',
  '111111122133122224333332224555336444566666664555677444588877777588889779889999999',
  '111111222133114522333334552637744552637745582677445582677488888667499889666999999',
  '111111112331444442533334422536336442556666622577688682557788882577777988599999999',
  '111111122333114222333554422363655422366654447886554747886655777888699777889999999',
  '111111122331314422333334422356664422755666442775566648775588888775598988779999999',
  '111112222331144222331154242336554447336555477366655477868659977888669977888899999',
  '111112333441122233411522333444522263445555566748885666777885996778889966777899999',
  '111122333112222334511122344556623334556666644577786644557889994577888899777889999',
  '111111222313144422313354422333355442677555442677558888667758898667779898666999999',
  '111111122131222222433335626433355666434555676444557776484577776888888979889999999',
  '111111122133331222443333552647375552647777752644478752644888855666988889669999999',
  '111111123112222223442233333444553663445555566744755666777778866788888899789999999',
  '111122233141122333144222333144525563444555666745585669777888669777889969778889999',
  '111112222133414222134444422134455556333356666355557768997777768999787668999988888',
  '111111122311422225344446625334446225334666755388677755386677775388887995889999999',
  '111111122331444422331445442333345222635555572666587777688588977668888977669999999',
  '111111112133332222334455662333455622744456662774556888744556688777788889799999999',
  '111111112313344222333544422333555422677754442667555888667775888666778898699999999',
  '111112222331112224533316624555366724553367744583667444586697774588899977888899999',
  '111111222133341422133344442335344422655555552667778588677778889667978889666999999',
  '111112233141212233441222333444255533444555666775558666777888966778898969778899999',
  '111112222113122224513333244553366644533666774556667744558777794588889799888899999',
  '111112222111122322443332355466333355446666655447777665447877755887889999888899999',
  '112222223111442233511142336551743366555743666557743866577948886779944888799999988',
  '111111222344411222344451262334455662334555766833557766838957776888997776888999999',
  '111111222133333242133353442166554442776555422766655448766959998767999998777888888',
  '111111122131222224333324444536626474533666774535686674555587777588888979889999999',
  '111122333441222333441252336411552236441555766489955776488959766888999766888997777',
  '111112222313111224333352224663355544666357444665557744688857777688999797888899999',
  '111112233141122333142222353444266653744666553746668555747888859777889959778899999',
  '111111222131122222333334442356644447356666647355556647855577777888889979888999999',
  '111111222133311222433333225434666625444465555476666585477888885777998889777999999',
  '111111222131334422531366422533366422555367444885667774885667974885577979888999999',
  '111122233111222233112243333554446636555546666575544466777748899778888999778889999',
  '111122233412222233411125333444155536474456636475558666777598886779999986779998888',
  '111111112334441222334552226334452276344555776348857766388855766888977766899999999',
  '111112222111333224513333224555633244566666664557886444577888894577888999777799999',
  '111112333112222333112242536444442536475555536475866666475868899777888899777899999',
  '111112222113311222333344252366345555366444557666647557868447777888997799888899999',
  '111112222311342255311344255333342255366645557668847777668447997668847997888899999',
  '111111112333314222333444422355544422367555428667775558667777888666798888699999999',
  '111122233111122233412223333444444453455555556756666666777788896778889999778889999',
  '111112333112222433112444443222454433655555553667757888677777899667888899666899999',
  '111111222113331222333334552666344552766444552766448555766488888777988899777999999',
  '111111122333112224333332424536662444556762644555766684575788888577799888779999999',
  '111111112133332222334533226344552266444555666447755668477885688777788889799999999',
  '111112223441112223441455233444455223666653333677558888667558988677799988677799999',
  '111111122331412222333444222344445566345555576335577776888777666888897966889999999',
  '111111122133331222334355222334556626444456666474455688777558688777988889779999999',
  '111111223111442233444444233566642233577666223557786663557888888557788999577999999',
  '111111222331341255333341255677344255667348255667448225667948888667948988777999999',
  '111112333111212344522222344562333344566666664557777864557888884557898999777899999',
  '111111222131314222333334422356636442555666444755686648775588888777598989777999999',
  '111222233111223233114223333414445556444555666455566676888899677889899777889999777',
  '111111122113342222553346662553344762853347762853447766855547766888847799889999999',
  '111112222331114222331444425334444625366666665376888855378888955777899955777799999',
  '111111222133341252333641552336645522736444582776645588766945888767948889777999999',
  '111111112133222222333344225663344555666347555666447755688447777888888779899999999',
  '111111222131144225633342225666342775663347755633847555688847775688449979888999999',
  '111111222311312224333352224335554444366654447666655577688857777688897997888999999',
  '111122333111222333112222334555555634566666664576444444577888899777888999777889999',
  '111111222311314422333344422335555442637754482677555588667778888667798998666999999',
  '111111122331144222333342252633345552666645555766648885767748888777449988779999999',
  '111111112133334422533344422536646442537666482577676682557778882557788889599999999',
  '111111222111332222333345262344445567344555667345566667848567777888877999888999999',
  '111111222311444422331444552633774452637777752638877552633888955668888995666999999',
  '111112222133312222334311552364335555664444455666677457866997477888897779888899999',
  '111112222311112242333332444533362444566666664555768884555788888757799998777799999',
  '111111222311331244333333244566662244557762244557766664557888888557988998777999999',
  '111111222313312222313444242333554444635555574666655777868666797888897797888999999',
  '111112333444122333444152323441152223465555527866659977868659777888669777888699999',
  '111111223411144223444442223554662233556666633557766833577788888577889998577999999',
  '111111222314151226334455226334452276344457776348857766388557766388959796888999999',
  '111222233411222335441226635441116335477666335477688855476699855477999885779999888',
  '111112222131134522133334522633344525666645555676448885776488889776489989777799999',
  '111112222314115222334155262344457766334457766334457776838559766888599796888899999',
  '111111112331322222433356222433556666434555676444455776888457776888887977899999999',
  '111112222133332224111533224666553344667555344667755444688775999688877779888899999',
  '111111112313444442333334242335554242666555222676755588676788888677777898699999999',
  '111112223444122333441152233444152233465555537668859777668859977666889777688899999',
  '111112333114452333144452323146452223446555277866657279868657779888657799888699999',
  '111111122344441222344551226344455226333356666377558886377955886777988886779999999',
  '111112222111222322441533336445533366447555366447775566477775866997999888999988888',
  '111111122333411222333442222353344444655555554666667757888866777888996777889999999',
  '111112222113333322145533322144536662444555666744485669778885569778888899777799999',
  '111112222111332224153332244553636644533666774556676744558877749588877999888899999',
  '111111112333122222333442225633445555636645575666644775688844777888889777899999999',
  '111112222331111244533366224533336244557666244557688884577668884557999988777799999',
  '111111112133332222435332662445336662745555562744488566744788586777788889799999999',
  '111112222333311222333441152344466652344666557846665557849955777888997777888899999',
  '111111122131322222433355622433556666443357766444455776884557776888887979889999999',
  '111112222333144422311144222335554466377555446337755566888779996887779666888899999',
  '111122233441522333441522366411522336471555836477995886447995866777995866779998888',
  '111112222111344255133346225737346225777346555788346565788346669778446999888899999',
  '111111222133331222334351522634355552664444455766668485776968488777988889777999999',
  '111111223441112223444452223644552333646555373666855773688857777688899977688999999',
  '111111122333331222433331225444466225446666655477665555477899995777899999778888888',
  '111112222113122224513333324553336444566666664555677744587777794588889799888899999',
  '111112222133333322144335322146665552144666557844466657889499557889999997888877777',
  '111112222133332322111333342555566642555666444756664444758888999778788889777799999',
  '111112222111133222444435522446435555646437575666637577886637777888339999888899999',
  '111112222333122444331112444335522446375555546377885566777899966777889666888899999',
  '111112233112222333411422333444442553445555566755866666777886996777888899778899999',
  '111111122133333322143343522444444522645555572665777777665878879668888889669999999',
  '111111222333111224533333224555636624575666424576686444577888884577999888777999999',
  '111123333111222433122255443122554433666654444776655889766558889776888999777789999',
  '111111122334412222344412255346444255366666665337888685337798885777798855779999999',
  '111112222113332322414433322414335556444555666455577686997776686997977788999988888',
  '111111222313142222313544422333545444363555747666565777886665797888869797888999999',
  '111112222113322222133333455133644455666645555664445778664777778999997788999988888',
  '111111122113334422333554422673354442673555842677758842667755888667788899669999999',
  '111111122313312222333345226344445266345555567448566667488567777888897797889999999',
  '111112222131113244533333244556332224566666664577788644557888884557899989777799999',
  '111112222311112242333342244335544446375555546377775566778876666878899996888899999',
  '111111222331415226341455226344452266344457776338857776388557976388597966888999999',
  '111123333122222334111223344551266344556666644557668944557788999577888889777789999',
  '111112222133333322114335622414355626444555666474558696774588699778888889777799999',
  '111112222111133332445553322444456322477456336887456666887755566877779999888899999',
  '111122223112223323114253333144455366444555666447556668777759688797799988799998888',
  '111112233112222333112422533664455553766444553766664455776884899777888899778899999',
  '111112333122222333114522633414552636444555666474855696774885699777888889777899999',
  '111111122331444225341464255344462225376666625377768885337868985377888955779999999',
  '111112222131314225133344225666347725666347555683347555688447779688497979888899999',
  '111111222333141522363144522663347522666347555886347755886449757886949777888999999',
  '111122233411123233412223333412455556444456666455556786999977786997978886997778888',
  '111111122133342222153344262553346662553347766855547766858447769888847779889999999',
  '111111222133144222133344422335335442665555544766588588776668889777669889777999999',
  '111111123144441223444455523666452223667752233677758333675558888677988889679999999',
  '111111222333111222343333562444355562744456662745558666745888868777999888777999999',
  '111111112333142222355542222355446677335546677335544667888846667888849777899999999',
  '111122333411223333411222335441226555466666665444677855499777885999977885999778888',
  '111112222331442222311444526314444566335555566335777786395777886999977866999988888',
  '111112222311142222331444526344444566335555566335777776385777966888879996888899999',
  '111112233111412223444422233454462633456666637556867737558887777588897999558899999',
  '111112222113132222413335662433535666434555676444575776844577796888879799888899999',
  '111111112334144222344442222344552666335555566333755886777788886777889866799999999',
  '111111112331334422333334222556664422755666442775566644777588888775588988799999999',
  '111112222131142552133342522333345555636444575666647777886847779866849979888899999',
  '111111122313414222333444442333455542663555722685558777688888777666898797669999999',
  '111112222331411122333455222334445667344555667344566677888556777889996977888899999',
  '111111122131333222433333222444455552444456666755556666777888886777888989779999999',
  '111122233122224233112444333115554433666555444776655588777666988779699998779998888',
  '111122233411123333415523236414522236444555666478885696478785596777789996778889999',
  '111111222331441222331444522344445526333555666375588886775888966777988966777999999',
  '111112222131122422333124444533366644536367674556667774555589777885889979888899999',
  '111122233111223333145226633145226663445555566744488569774488569777788999778889999',
  '111112222311412222315444266335544446337555466377775566338777596888897996888899999',
  '111111122331122224333552244663352444633555774666857744668855777688889977889999999',
  '111112222133333222114335552614433552666444555766884495766688499777888889777799999',
  '111112222311142525313342555333442256377745556378844666777846696787849996888899999',
  '111112222133144242113554442333554462733854662738855666788855699787889669777799999',
  '111123333111122223414422333444452236455555556478856666777886696788889999777789999',
  '111111222331311442333335442663555442677754442677555822677588888677998988666999999',
  '111112333441122233445112333445552236447752266487755566888799566887779966888799999',
  '111111122113345522333345222336345552766444552766648588777648888776648899779999999',
  '111112222111334242133354442663355742863555742863557744866657779868677999888899999',
  '111112222131144222133345662737345662777345666877345656877345559888449959888899999',
  '111111222333111244335522224333524444663555744666685777688885577668999777888999999',
  '111112222331144422311345442333335442675555542677588888677578998667779988666699999',
  '111123333111222233144522663145522633444555666774885569744885669778888999777789999',
  '111111222333341522336341522366341552766444552766849559776849599776849999777888888',
  '111112222113333442153364422153366442753666842755668849775568849755888899777799999',
  '111111122331312224333322224533664444556666644555566774588887777588897977889999999',
  '111111122331122224335552224333354444636654474666657777688855577688889977889999999',
  '111111122334411222334555226334452276344457776348857766388555766888997766889999999',
  '111111222311133422333333422555664442756666642755566444775888888775889998777999999',
  '111112222113334222133344252166347555666347555666347558969447778999477788999988888',
  '111222223412252233411155336411753366444753666447753886477558886779959986799999888',
  '111111222133312242533316442553366642755368442756668844755698884757798889777999999',
  '111111112133332222334532262334552666444555666444755688747785688777788889799999999',
  '111111112344441222334544222334554262333555666737855866777885866777988886799999999',
  '111111112333441222334455622333455622734456682774556888774556688777966888799999999',
  '111122233112222333111223333444445556444555666455566666777788999777888899778889999',
  '111222233441222233411123335441133655466666665446778855477798885779999855779999888',
  '111122333112224333111224533662244535666645555676448855776488999777488899777889999',
  '111111222333312222343115522443336555466666665444677755884499757888897777888999999',
  '111111222113412222333445522333455667344456667344556777885566777888896799888999999',
  '111111112133442222333342252336342555666645555666748588767748888777744889799999999',
  '111112222333311122334415222344455667344555667344556667888596677889997777888899999',
  '111112333122112334122222344556663344556763644557766644557888889577899889777899999',
  '111112222133311124333335224636555224666654444677555484677588888679998889777799999',
  '111111222113132222433333352444636652444666555746686555748888885777789899777999999',
  '111111122331144442333344422533364422566666662557768882557778888577779988559999999',
  '111112222131145522331344552333345552637745582677748888677448988667749989666699999',
  '111111233122122233142225333446655553746666653744446655777488859778889889778999999',
  '111112222333312442331112422335555444636654474666555577886899977866897777888899999',
  '111111222333111242553366642753364442753368842755568842756668844757999888777999999',
  '111111222133144252633147252663347552866347552866347755868349775868449779888999999',
  '111112223112222323114523333444555633444456666774555666777785699787888899788899999',
  '111111122113342225333344225666347255668347255668347555688447777688847799889999999',
  '111111223411421223444422223454433333655555553666667757688887777688987997688999999',
  '111111222133312222143333255443366255446666655447668855447888859777798889777999999',
  '111122333441222233411255336411225336444555666477588996477558996778888966777889999',
  '111111112314444222335554226333754426388754226387754666388755566888777796899999999',
  '111112222113145522133344552666347752863347752863347555866447779886649799888899999',
  '111122333112123333112224435666244535666247555686447555684477799888879799888779999',
  '111122233111222333112223333444556666445555566444455666777788899777888999778889999',
  '111111222311444225341442225344466255336666655337668885377788985377888995777999999',
  '111111122113332222433555226443357626444357666484357766488555776888877799889999999',
  '111111222131122222433333325466663555444763555444766665487777775888889979888999999',
  '111111112314442222344442255346422555366666665333778685337788885777788895799999999',
  '111111122113333224533633224555636224557666244577686444577886884577888899779999999',
  '111112222113222224153367744153366744553666744553667748553367748599999788999988888',
  '111111222334441222334551622334551672334456677834955677884955677888966677888999999',
  '111222233111232334516233334516224444516666674555588674599998674599898777998888777',
  '111112333141152333444152233644557223664457722866455772886659777888659979888699999',
  '111222333111423335661422335611442235666742555687744995688774955688874999888777999',
  '111111122331344222331344442533364442566666662577768882577778988555778988559999999',
  '111111112312222222334255666334455677334456677334556677444558677888888897899999999',
  '111111122313312222333344552666344552766348552766448555766448888777798898779999999',
  '111111222314442222311456662344455562334457766835557776833357996888877796888999999',
  '111112222331312222431315626433335666445555566444577776484597976888897977888899999',
  '111111112333122222334455222333445555366645557666644777888664477888889777899999999',
  '111112222133322424133524444113525444333555666777585699777785669787886669888899999',
  '111111222314411222344456662334555762834457762834555766833357776888997796888999999',
  '111112222113313244153333224556336224556666644577688644577888849557898899777799999',
  '111111112344122222334442225336644445336666655377776655388877755888889775899999999',
  '111112222314144222314444252314465555366666665333367785939777785999778785999988888',
  '111112222331142552331142256337445256377745556378744566378849966877849966888899999',
  '111111122113222224333332444356632444356666647555876647555877777588888799889999999',
  '111111112331422222334452226334557776344555776344455766388857766888887966899999999',
  '111111122131222222334425667334555667334456677344555677344586677888888979889999999',
  '111111122133144222333544222333544442365555547866665777888665777888669779889999999',
  '111112222133311222143333522444335566444555666445577666885777769888997779888899999',
  '111111222111333322443333522444355562744456662745558666775888866778888999777999999',
  '112222223411252333411552366441153366477158336447758866447955886777959886799999988',
  '111122333412222233411225333441155636444555666474558866777599886779999986777998888',
  '111122233111223334112223444562333444566666664555777864555788899577788999778889999',
  '111111122334112225344446225344646255347666285337686885377688885377799855779999999',
  '111112222333311124533331224555636224556666644577686444577988884579998888777799999',
  '111122223144112233444122333444123353455555556757789666777889666778899669788889999',
  '111111122314444222314455226334445226333555666377588866377558896777888896779999999',
  '111112333141222335142262355142663335442666755488866759448767759488777959888799999',
  '111111122113333224533666224553362244553762844557768844577666884577888899779999999',
  '111111122113344222333345522336345552766645552766648588776648888777448899779999999',
  '111111122311444222334445262334555262334457766838555766838577766888777996889999999',
  '111111223144411223444422233556442233566666663557788633557778888577998889577999999',
  '111111222331411225344444225344462255366666665337768885377888885377998955777999999',
  '111111112133333222443332252446362255446666655447768655747788855777888889799999999',
  '111111112341522222344552266344452766334457766334857776338855776888885976899999999',
  '111111222111334422333344442335444522365555527665888577688887777668877999666999999',
  '111111112333415552633445522663345552633745882677748822667744882677794888699999999',
  '111122333141123333142222223144444553445555566755666668799999968777798868777998888',
  '111111222111345222333345526377745526387444526387745556387746666888746999888999999',
  '111112222111333322143355226443355626444357666484557766488557769887777999888899999',
  '111111222133344422113335422663535442763555842766585844776588899776668889777999999',
  '111111222131133322433335622443555622444456666774555866774588886778889989777999999',
  '111111122334411225344422225336444425366666665378888655377778885377998855779999999',
  '111111233441115223444445233467455223667752233677558238667588888677599988667999999',
  '111112222311412222331445562344455766334457766334557776835577966888897996888899999',
  '111111222111222222344444445343466665333365555366667575377777775888888999888999999',
  '111111112314442222344444252333364652736666652736865555737888885777788895799999999',
  '111112222113311222444335226443355776443555766433557766488577666888997799888899999',
  '111111112333341222533342262553346662755444662755548866757748886777948888799999999',
  '111222233111233333411222233441455556444456666455556766889999776888889777889999777',
  '111222333111123334551622334551662234557666244587766944588776944588879999888777999',
  '111122223111122233414223333444555533444456666775555666777788696778889999788889999',
  '111112222133342222113444442133355544635357574665557778966666788999967778999988888',
  '111111122133142222333344242335554442365654547866655577868667777888869779889999999',
  '111111222311132224333333324556666224555564444577666644578888888577789998777999999',
  '111111122314444222314544266344552266337555266337755886337885896777888896779999999',
  '111112222331144422311444422333355442335555566788556666778888996778889966777799999',
  '111111222134414422133444422333335422355555556778566666778888669778898869777999999',
  '111111112333341522333345552667344552667745522677448522677748888667948888699999999',
  '111222223412233223411133333411455556444456666455556776888887776899889976899999777',
  '111111112331222222333244444335244546375555546375778566777778666888888966899999999',
  '111112233112112333442222355446233355466666665447778655447888855777899899778899999',
  '111111222131344222133334442335535442677555442677585588677788889666778989666999999',
  '111111112314444442333354222333554422366555227668855777666857777688888897699999999',
  '111112222133314222335114244335554246377754446378755566778799566888796669888899999',
  '111111112333122222433333222443455556444456666455556766888777776888889777899999999',
  '111111122133122222433333252444463355466666665447765555848777775888889779889999999',
  '111111233112222223142442333444455363745555563747556666777866869788888899778999999',
  '111112233111412233444444233445552223665752533677755588667888888667798999667799999',
  '111111122313314222333354242663554442763555842766655844767658888777698898779999999',
  '111111122333311222343355222344355662444456666744558668777558868777998888779999999',
  '111111122131334222333344442536644442536666672588886672588887777555877979559999999',
  '111111222344415222334415266344415266347555286337598886337598866777598886777999999',
  '111111122334112222344444222333554446335555566377755666888777776888899766889999999',
  '111112222133112224553313244563333244566666664557888864557898844577799889777799999',
  '111112222314115222344155226344456666344457776333357776388559776888599796888899999',
  '111112222314411425314444425336462225336666655377768655378888895378998895777799999',
  '111111222113142222533346622533446666533347776555544776885547776888849799888999999',
  '111111222311414422344444225346666225333365555377666685377888885778898995777999999',
  '111112222313311442333514442333544442665555522677775888677795888677998898666699999',
  '111112222111312442333354442366355542763358842765558448766658888766798999777799999',
  '111112222131444252134446252134646552334666755833676759838677759838777959888899999',
  '111111222331112222334444425336444425366666665378888655378888855777799955777999999',
  '111112222311122442331562247333566647355564447356664777358864977855889997888899999',
  '111222333112222234511662334551166344557763344557668844577966884579999988777999888',
  '111112222111333322413333522446635552446666655744486655774888895778888999777799999',
  '111111222113332244133333224555636224556666644577686444577888889557788899777999999',
  '111112222311311242333333242556636244555666444557686644757888888757998998777799999',
  '111111112333312222433356222443556662443555766844455766888457776888897777899999999',
  '111112222331311242333315242336655542666654444765554488767598888767998988777799999',
  '111111222333311244553316224533366224557666244577668884577698844557998888777999999',
  '111222333111122344511226334552266344577666334557668844577688994557889999777888999',
  '111111222313142222333145522366645577366444557336645557886649777888849797888999999',
  '111112222311311242333335244366355224666555444677558448667588888767998998777799999',
  '111112222331142225311444225334444465366666665367777755388777995388879955888899999',
  '111111233441222233411225233444525633474555636774585666778588996778888966778999999',
  '111111222311132222333334522366634555664444455666475557886477777888879997888999999',
  '111122223112222333114523366144553336444555666477755668447795688777999988799998888',
  '111112222113144255333142255633342755663842755663847775668849777668449799888899999',
  '111111222133333442133444442133545422665555522667575889677777889677888889666999999',
  '111112222131312242333315542336355442666654444766558488765598888767798989777799999',
  '111111222311314422333354442336555422736654482776555488766658888776698998777999999',
  '111111222311414225334444255344422265366666665367778885337888855377898995777999999',
  '111111233112222233142253333442556663444555666744455866777758869778888899778999999',
  '111111122333114222353344262353346262555546666757548868757448868777499888779999999',
  '111112333411222333411252233444452236445555566478856666778858996777888996777899999',
  '111111222333114222333314422566334442556666644755588664775598888777599888777999999',
  '111111222133122222443135266443335566433555776445577766448579766888889779888999999',
  '111122223112223333111423353666425553664444455766684555767784999777788899788889999',
  '111222233411122335411123355446226335476666635477688655447789995477889995778888999',
  '111112222113144255633142255633342755633842775663847775668849775668449799888899999',
  '111112333112222343112222343555566643755666443756664444757888899757888899777899999',
  '111122223111222333144526333145526633444555666774485569777485669777888999788889999',
  '111111223141122223444223333444425533465555537665587777666688777688889979688999999',
  '111112233411412223414422333444522333455555556777885666777886696788896996778899999',
  '111111122344141222344444255333466225376666625377668555337888885777989885779999999',
  '111111122313144222333334422335555442677754442677555588667788888666779898669999999',
  '111111222331314442333315442336555422776654422776555488766598888766698988777999999',
  '111112222111333244513332224533632444566666664555786884577788894557888999777799999',
  '111112222131144422331445226344455266334555766338557776388577966887779969888899999',
  '111112222111344422133345422333335442665555544766588888776568889776668999777799999',
  '111123333111123334512222334522624444566666664555576774588777794588879999888879999',
  '111111222311122222334556627334556677344456667334455677384455677888889997888999999',
  '111112222133332242113335242163535444666555444666575748969577788969977778999988888',
  '111111112333341522333345522367445552667745522677744528667748888667948888699999999',
  '111112222111344222515344226555334466577734446557733666588773696888773999888899999',
  '111112222111122223444452333644455533664457733665557773666857777688889999888899999',
  '111111222333331242333311442566667742567777742567744442566889999565899999555888888',
  '111112222131122442331444442333345542335555566785586666788888966788779969777799999',
  '111122223111122333441523336444522336445555566477885666477785966777889999788889999',
  '111111222333312222343115262344555667344456667344555667848599767888897777888999999',
  '111112222333142255311144225333345525666347555686647777688449997668849777888899999',
  '111111222113331222333344442553366442756666642755668844755558888777988899777999999',
  '111112333411222335412223355416622335446666655477886695447788895477888995777899999',
  '111111233411222233414442233444455223665555533677558888667788898667777998667999999',
  '111122233112222233411123333445556636444555666474455566777789996778888899778889999',
  '111222223141222323441553333441553677441853677441855677888855677898999676899999666',
  '111111122314144222344445226344555226333356666377555886377588886777889896779999999',
  '111112222111122222334444444333345554333555666755576666777777766888889999888899999',
  '111111222133141222333344522363345525666645555676648858776448888777949889777999999',
  '111111222314112222334444442333455562335457566835557666877777766888899796888999999',
  '111111222333314442333314422566314442576666642577789662557789999577789999555888888',
  '111112222311411222333444452344446652336666655736688885738888555777998995777799999',
  '111111222133114225333344255636342225666347555688847575668447777688499779888999999',
  '111111112333341222533344266533742266555742666557742886557448886777948888799999999',
  '111111222333111222433355522443356626444357666484457766885557776888999777888999999',
  '111111112314444222334542262344545266337555266337585886737785866777888896799999999',
  '111111112334441222333444422333455522635457582665557888667777888666977788699999999',
  '111112222133132442113333442556336442756666642755688644755888899755789889777799999',
  '111112222111322242513333342556633344556666644557776644857777794858887999888899999',
  '111111122131222222433332355446633355446666655447776655447877775888888979889999999',
  '111112222311412522314462557334662577334666577334866577344865597884895997888899999',
  '111112333111222334521266344522263344557666344557768884557668984577888999777899999',
  '111111112333142222333444422344455522335456577885556667886666777888869777899999999',
  '111111122133331222334432222334455566444555666445556677888876677888977779889999999',
  '111111222334111255344462225344666725384467725384666775388867775338999755888999999',
  '111122233111222333412255536412453336444456666477756896475558896777888999778889999',
  '111112222111342442313344442333354542635555572685857777688887797688687999666699999',
  '111111112133422222333422525633455555633444775666664775686884777888884779899999999',
  '111112222133313322143333225146666525444465555474666658477999958779989998777788888',
  '111111112133334422533334442536664422577666442557766682577788882557788889599999999',
  '111112222113333322133345552166344452766645552764448559766648889778888899777799999',
  '111111122334141222344442252344466552336666655733668885737788885777989855779999999',
  '111111223444111233444452223445552223666653333677755588677758888667999888677999999',
  '111111122333114442333335542667355442667754422677558422675588888677799888669999999',
  '111111222133322242135552442133354444663357744666657778966955578969997778999888888',
  '111111223114452223144455233444452223666653333677758888667558889677758899677999999',
  '111112222333114222353144266553147266553347766558349766558449767888499777888899999',
  '111111112334144422344442225334662225336666655377766855377788885778889855799999999',
  '111111222111222222333344555336445577366645557336644577666447777888888999888999999',
  '111112222331111222334444225344666655344467775336666775388777755888999955888899999',
  '111111112333331422335534422677534442667555422677785442667785588667988888699999999',
  '111112222133145222336145522336144577366645557336448577996648577999648778999988888',
  '111112222311442225331444425331644425366666665378886955378888955377788995777799999',
  '111112222313311222333314442344444542355555556785888886788896666777996696777799999',
  '111112222131112222333333442566334444556666644555577664855777777888899979888899999',
  '111112222113312222133333244335544444665555544666665577668777779888897799888899999',
  '111111112331222222333324244335544444365555547666665577668687777888888977899999999',
  '111112222111333224133333224556636424555666444575686644577888889577888999777799999',
  '111122233111223333112224335666624435666444555674485555677488899777788999778889999',
  '111111233444141233444441233556666233755562223775666622775899999775898999775888888',
  '111112222131144422331444222333554446335555566377755666888777966887779969888899999',
  '112222223111223333411123335414666635444465555476666585477798885777799888799999988',
  '111111222113133222333334422356666442555564444755666648775588888777889899777999999',
  '111111222134444442134334422133355522633555772665557778669977978699999978666888888',
  '111112222113333242153333242155366442556666644755668449757888849757888899777799999',
  '111112222113333322411333522444443526445555566475866666775888996778888899777799999',
  '111111222131422222331455562337445566377745556337744566837774966888884969888999999',
  '111111122133322222133445522633345555663444755666647775886644779888887779889999999',
  '111111222113332244133355244637355244667358244667558284667558889667788899777999999',
  '111111122333441422333341422533644442566666662577776882557978888557977888559999999',
  '111112222111134222555534262577734466577333446557734446858736666888739999888899999',
  '111112233111442223144442323445552333645752583666755588676788889677788999667799999',
  '111111122133334552163344522763345522766348552776648852776448859766488889779999999',
  '111112223111222333142253336444253366445555566447758666477758869777888999788899999',
  '111112223114122333144442333444522233455555556778885666777866669777889699788899999',
  '111112222331111222334455662333455662334456677844556777844556677888999977888899999',
  '111111222133112222333333342556664442556564644755566644758888888777799889777999999',
  '111112222131412222134455662334557766344457776334455766833557769888897969888899999',
  '111122333122224335111124355666224335667444355677488555667489999677488889777889999',
  '111112333111222233441253336442255366442555766448557766488857966887777999888799999',
  '111111122334141222344444422333335422355555556778566666778888886777989866779999999',
  '111111122341412222344455226334557266334457766338455766388557776888897976889999999',
  '111111122333311222343333552647755552647777752644447752644888858666998888669999999',
  '111111222113332244133332244536362244556666644557768684557788889557788899777999999',
  '111112222131112224333332524663355544666357444665557744685877777688899979888899999',
  '111111122344122222344152677344552677334555677334855667334859667888889667889999999',
  '111111222133313222133333224555566624555666444576664444577888889777898889777999999',
  '111111222133341225336341225366344225666347555688447557688947577688947779888999999',
  '111112222313111222333344225363445555663645755666644757688447777888999797888899999',
  '111111223141222223144423333444425333455555556777586666777786669788888969788999999',
  '111111222334151222334451672334456672834555672834456677834956677888959677888999999',
  '111112222113312422333312444356362444356666647555867647555897777885897799888899999',
  '111111222111333322443355222433356662444555666744458886777558866778888999777999999',
  '111111122333122222344145526334445726344555776384577766385579776888889666889999999',
  '111111222333114222333514662355554622335444677885466667855496777888499777888999999',
  '111111123444112223444455523664452223666752333677758833675558888677799888679999999',
  '111111122333311222345566222344556627334456677384455667888445567888997777889999999',
  '111112222133111222333334425663344525666645555676448855674488888777999889777799999',
  '111111222314412222334415662344455562334457766835557776833597766888897796888999999',
  '111222233411222233411152336444153336445555566477758666477958886779999886779999888',
  '111111222134122222334155672334456677344555667334456677834559677888889679888999999',
  '111112222314114222314444252334644655336666655336776755838777795888799795888899999',
  '111111222333122222334115662334455666334555677444556677844599677888889777888999999',
  '111112222113142222333144442335545644733555664773575566877779666888879699888899999',
  '111112222133312422135312444335332444665555544666788588666798589776798889777799999',
  '111111122133122222333455662334456662334555677844456677844556777888889779889999999',
  '111111122133314222533344622555346662753348862755548666775448886777498889779999999',
  '111112222313311422333315422366665442365555547866544447886597777886997797888899999',
  '111111222333311222444351262443355266433555776448557766848957666888997777888999999',
  '111111122133331222433332222444435666455555556444576666888877776888977779889999999',
  '111111122331331222333342252366644452666645555764445558767748888777988988779999999',
  '111111222311452222331455522333445556337745566377744666887774966888874996888999999',
  '111112222311144422314445422333345426335555566378586666778588896778889996777799999',
  '111112222133333222145533262144533666144555667444885667949885567999888887999977777',
  '111112233122222333112423333144455566444555666445556667888896977888999997889977777',
  '111111123441122223444223323444523333455555556777785666787788666788889966789999999',
  '111112333441122335411226335442266735482666735482667755488677995488779955888799999',
  '111111122133314222335344266355342266557348266557748668557448688777498889779999999',
  '111111112331222222333333224555553664556666644566744444588777777888888977899999999',
  '111111223111444223444454223667554233667555233667855233677858888677888999677999999',
  '111111222134412222134444452336644552336666655733886655738888859777798859777999999',
  '111112222341111222344444522333444566335555566335777666885777776888999976888899999',
  '111112222311314422331354222633354444635555574666657774888657977886697997888899999',
  '111111222113312222333334242355534444666555444666675557868677777888897799888999999',
  '111111122331122224355526224355556644355666774336677774388687774388889944889999999',
  '111111222331141222334445562334455762834457762834557766835577766888979966888999999',
  '111112333114442223144522333144552233446555277886655779888665779866677799888699999',
  '111122333111123344122223344526626334555666444577686684557788889557789999777889999',
  '111111122333113422553333422653774442657777742655577842665888844665899888669999999',
  '111111122113322224533662224533667444553367744555366774588866774588887799889999999',
  '111112222311122422331555462377754466337754466337754446837555966887889996888899999',
  '111112222131133322133332224536666444555564444555666674588877779887779979888899999',
  '111111112331332222333342222535446666555444666555544676888847777888877977899999999',
  '111111122313331422333554442633544422677555442667775882677755888667988898669999999',
  '111111112344144222344444255336222255366666665337777655337888885777889885799999999',
  '111112223411122323441223333444425336455555556477586666777788966787889996788899999',
  '111112222131444442133455422133335422336555477886577779886556779866666979888899999',
  '111112222331312244333311244355366224556666644577668448557998888557798988777799999',
  '111112222113333322114443222555543336555546666577746666888744499887777799888899999',
  '111111222133142225333142255633344255666347555668447775668849777688849779888999999',
  '111112222113113324553333324555632224566666664577786444578888844578899899777799999',
  '111111223114412223444452233644455233667555233667558883667758888677798899677999999',
  '111222233111242223551442333551143336555546666577748866777944866799949888779999888',
  '111111222333111242333352244335552244666654444667755588667758888767999888777999999',
  '111112333112222344112253344662255344677555334667558844667758899667888899777899999',
  '111123333411122335416222355416222335446666655477888695447888695477889995777789999',
  '111111222113312242333332442355636442556666644755686448755788888757798899777999999',
  '111123333111223433112223444522263444566666664555768884555788899775788999777789999',
  '111111222313144225333142225333342555666645555666748888677749888677449898777999999',
  '111111112134444422334422222344552666335555566333755886777778866778888869799999999',
  '111112222331112224355516624335556724355666774385677744386697774388899944888899999',
  '111222333411152336411152236444552236477852336478855666478859996477859996777888999',
  '111112333121222333122244433125554434666555444676655589776668889777888989777899999',
  '111111222113144252633342252663347752666347555863347755868847775868449799888999999',
  '111112333141422333144452233144455223664555722866557779886657779888667979888699999',
  '111112222133311422133444422333444452355555556758888666778888669778996669777799999',
  '111111122331455552331452222333455552633444772688884777666684977688884977669999999',
  '111111122113333222443532262443535266443555766448575766848875766888777799889999999',
  '111111222113344442133354422633354442635555572688857772668857779688887799666999999',
  '111111112313334222333444422335545442667555422677575588667777888666788898699999999',
  '111111122331312224333333244556662244557666244557766644557888888577798988779999999',
  '111112222113313442513333422556633442756666642755886644775888894755898899777799999',
  '111111122313314222333344222335546662555546666755546688777448888777498898779999999',
  '111222223141252223141553333441653777441653877444653877666655878699959878699999888',
  '111112222341111222344445262344445666335555566333577776838577776888999976888899999',
  '111111122113332222333332422356644444556666644555556647885877777888877799889999999',
  '111111122131222222333444452344466655344666775336667775837777555888888959889999999',
  '111111233411122223442223233444553336445555566477755666778788866788889996778999999',
  '111112223111422223441445233444455233666555333667558888667588988677778999677799999',
  '111112223444122333441122333444122353455555556757889666777889966777889666788899999',
  '111111122133333222133443552637744552677745552677445582677844889666888889669999999',
  '111112222113145552133344552336345522736348582776648588766448889766649899777799999',
  '111112222113133222413333255443636255446666655447686855447888895777889899777799999',
  '111112222133111242333332242335544444665555544666665577868877777868999779888899999',
  '111111222331311222433355622434355662444357666844557676884557776888997977888999999',
  '111112222333312242333311442536614442556666644755586694755889999757789999777788888',
  '111111222311122224355555244355665244356666674338766774338777774388889994888999999',
  '111111122333112222333344442355344442675555542677778558677778888666699888669999999',
  '111111112133222222433335522433665555436666675444466775884477775888888779899999999',
  '111112333411122335441662235447662335487762235488766255487766955488779995888799999',
  '111111112344144222344445222333455226333555666377558666777588886777889886799999999',
  '111111222313112242333352444363552244663555744668855747666857777868899797888999999',
  '111122223411522233441522336441533336441555766488885766488995766889995776899997777',
  '111111233411222223441223333444425533445555566775586666777788966788888996778999999',
  '111112222311144222315554442333354642373754646873756666877755596888779996888899999',
  '111112222113311242533333242556633244556666644557886644757888884757998899777799999',
  '111112222313111224333342224335544444365555547666665577688867777688999797888899999',
  '111111112341222222344442525344466555346666675333667775383877775888888975899999999',
  '111111222133411242333444242335554442633555772688855577686888777686998779666999999',
  '111111122311222224333352424333354444665555544666657777686857777688888997889999999',
  '111111112134422222334455222344456666344555776333357776888557766888887769899999999',
  '111111122131444442334444222333552262335555566737755666777888866788888969779999999',
  '111112333111122334222223334525666634555564444576666484577788888577889999777899999',
  '111111112333314442335554442633354422666754222667758882677755588677798888699999999',
  '111111122331144425344442225334646625377666225376686855377788885378889955779999999',
  '111112222131422552131466572333466572334465577834665777834665979844885979888899999',
  '111111123144422223145442333645542233647555283667785583666788589677778889679999999',
  '111111112133332222433552666433552666437752286444755886444755886777788889799999999',
  '111111112331442222344452222334555677334456677334555677888856667888866977899999999',
  '111111122133333222133452226334455526444456666475556688477756889777888889779999999',
  '111112222331111222334555262374455566377444556337774456838777466888999966888899999',
  '111122333112222333112224343156664443555666444755566648757599988777999988777998888',
  '111111123122222223145266333445556333744456663777455566777448569788888889789999999',
  '111112222313142222333145552336145557366444557366648577966648777999948787999988888',
  '111111122133312222333344552366445522366645557886644557866447777888897779889999999',
  '111111112133344422333344442556334422566666662557788622577778888557778889599999999',
  '111112233111222334152223334555623344566666664557786444577788849577888999778899999',
  '111111112134444222334544226334542226335555566377785866377885866777888869799999999',
  '111111222131332222133333322445556666445456566444455566778888889777788989777999999',
  '111222223112222333114553333414553666414456676444855676888855677888999977899999777',
  '111111122113334442333544222333544442665555522677775888666775888677788899669999999',
  '111111222331444222311444522344455562333356666735558886775888996777888966777999999',
  '111111112133333222443353222444355522444456666775558666777858866777888889799999999',
  '111111222133122222334156662334556677344555667334455677844459677888889779888999999',
  '111111223144412223444512333444522233665555533667775888666795888677798889677999999',
  '111111122331312222333342225366645555364444457666645557688847777888897977889999999',
  '111111122133322222133345522336445555366444557666644577886647779888887779889999999',
  '111112222111332222144433235446463335476666635477765655478775559888877999888899999',
  '111111122133331442333534422677535422677555442667585442667785888677988889669999999',
  '111122233411122333441122333444522536445555566475885666777889966777889996778889999',
  '111111222311122242335552444333352444336654477666857777666855577868889997888999999',
  '111112222331444422331445422331155462337555466837559966887577966887777966888899999',
  '111112222311142442331444442333334522355555556775866666788888966788789996777799999',
  '111111122333331222433351226444352266445555566447758666477958886777988888779999999',
  '111111122331132222333334422536666424555564444575666684775588888777789988779999999',
  '111111112333134422333334222567744442567777742566667742555688888556689888599999999',
  '111112222111222223415556633447756633477756663447756633447755583499999888999988888',
  '111111122333312222344315262334355662444555666744558688747598668777798888779999999',
  '111111222131332242133333242555366244556666644557668444757888889757788989777999999',
  '111122233111223333112224533666424553666444555766484555776488899777788999778889999',
  '111111222313341552333341522663344522766645552776448855776948888766948898777999999',
  '111112222314411122334444422333455462335555566738558666778888866779998896777799999',
  '111111222333311222333415622344445662345555567844566667884596777888997777888999999',
  '111111122313314422333444422533364442566666662577768882557777888557798898559999999',
  '111111222311144422333344422353334442655555552677788858667778888667779998666999999',
  '111111122331132222433333522434445562444555666745566686775888886777789988779999999',
  '111222233412222333411253336441155366441555766448557766488859776888999976889999777',
  '111111222133311222433335522434355626444456666474558686775588886777998889777999999',
  '111112223141152323144452333444552363748852263747855666777856669787859969788899999',
  '111111222333111224533332244556336224556666644577688644557788884577999888777999999',
  '111111222311132222333333322444556666445555566444455666778888888777789998777999999',
  '111111222131312224333332244536632444556666644555786684557788888577798989777999999',
  '111112222111133222444443322456663377455666337445566637885577777888559999888899999',
  '111111222133312242133352244663555244663357744668555744668857779868897779888999999',
  '111111223144411233444422233546422233566666663557778683557778888557998889577999999',
  '111111112333331222343332255444466225476666625477665555447788858777988888799999999',
  '111112222331444422311142225344446655336666655336677775388879995887777955888899999',
  '111111122313312222333333442555664442756666642755566444755888888777798898779999999',
  '111111112314444422354464472355667772355666772355566772358868872338888892399999999',
  '111111122133312224333552244663552244663357744668855744668855777688897779889999999',
  '111112222311142552313344522333345525666347555686647777886447797866849997888899999',
  '111111112133333222333342252666642255664444455667745555767748888777888889799999999',
  '111111122133332222134445222334545667344555667344565677888566679888877779889999999',
  '111122233441223333411222355416623355416666675448896675448999775888899755889997777',
  '111222233112242335611142355617442355667743355667844395667849995677848899778888999',
  '111112222113332222311344442333354444655555554666657777866667997888877799888899999',
  '111111122133333332143355522444456622774456622774456666775558869788888889779999999',
  '111111222331331222433331552444366652744666552746668555744988885777988988777999999',
  '111111222131122222333455526334456666333456777444456677485556777888889979888999999',
  '111111112314442222344452662334555662734458862733555866733758886777788896799999999',
  '111122223112222233114443333144544533445555566775665668777766688779999988799998888',
  '111122333111123343152222344556226334556666644577688644557888849757789999777889999',
  '111112333411222223411225233444445333445555566777566666778588996788888996777899999',
  '111112233412222333412523366412533666415555576444885976448895976888999976889977777',
  '111111222133311224333332244356662444556762644555766648557788888577998889777999999',
  '111111122311455222333445226373745226377745556388745656388744666888774996889999999',
  '111111112133334522336634522666334522776444522776488555776485588776488889799999999',
  '111122233411122333415122366445552336447852366477855566447889596777889996778889999',
  '111111122133122222443332526443335566443555766445577766485877766888889779889999999',
  '111112222111222232144555533446655553476666653477776633447777338949999888999988888',
  '111222223411233333411235366412235666415555576444589976448589776888889776899999777',
  '111112333411222333411242233444445223455555556788566666778868996777888996777899999',
  '111112222133112244153362224553366774553666744533667744588867749558899779888899999',
  '111111222133332242113333242553666642555564444756666844757888899757788889777999999',
  '111112222111312242333354442363554442363555747866655747866657777868897999888899999',
  '111112222111312222433335552433636655443666755446676775844477775888897999888899999',
  '111122233112123333412225553416626533444666555774686695744488895777789899778889999',
  '111111233141222233142255633444255633744258663774558666774558869778888969778999999',
  '111112222314411255314462225344466725334666755384667775388867795338997795888899999',
  '111111222311132222333334242356664444356564647555566647858577777888879997888999999',
  '111111222133344442133334422133554442665555522677755889667788889677778889666999999',
  '111111222311122244333324444333225544365555547665588777666687777668889997888999999',
  '111111222333311222333441252633455552666444555766664885767944888777998888777999999',
  '111111222133112224333355244363352244666555444667758848667558888677799889777999999',
  '111111222331145222366145227336645527336444577386645577388649557888649977888999999',
  '111111222113134442333334422536344442566666662577778682557788888577789899555999999',
  '111111112331222222333324255663344555663444755666447755668487777888888977899999999',
  '111111122333122222333124442353344444655555554666667757866689777888889777889999999',
  '111112222111333422133334442553636442756666642755686844755588889775888999777799999',
  '111111222311312242333352244335554244366654447668655577668857777868897997888999999',
  '111112223141142333144442233445555233467752238667555588667788889666789989677799999',
  '111111112134444442333334422355334222665555522666788558667788888677777789699999999',
  '111111222331311222333333442556666442755564442755666644755888888777998988777999999',
  '111111222133331244533361224533662244557666244557766884577968884557988889777999999',
  '111111122131322222333324442335344444655555554666667577866687777888887979889999999',
  '111222223441122223444133333411133556445555566455778886777778666799998866799999888',
  '111112222333142422331144442333144452355555556758889666788889966778789666777799999',
  '111111112314222222344422566334455566344457776335557766335887776888888796899999999',
  '111112222311144422331445662334455762834555762834557766833577966887779996888899999',
  '111111122131334222333334222355544424666555444676665558777688888777688989779999999',
  '111111112334144422334445442333335222665555522666577777688588877668889877699999999',
  '111111122134442222134445622334555662334457766833555766883577769888877769889999999',
  '111111122313144222333342225636342555636645575666847575688847777888449797889999999',
  '111222233441223333411523366415522366411555776448995576448895776888899766889999777',
  '111111222131312224333332244536636244555666444557686684557788888577798989777999999',
  '111112223414122223414152323444553333644555773666655777686859797688889797688899999',
  '111111222311122242333333342555536642556666644756684444758888888757779998777999999',
  '111123333112222344511233334512226444566666664555677784599997884559777788999978888',
  '111122333141123333141222335442226655446666655446677755488777959888879959888779999',
  '111122223111223333144255366142253366447555366447758869447558669777788999788889999',
  '111111222344141255344441225346422255366666665337778685377988885337989885777999999',
  '111111222131144222333334422335554442366555447866655577886677777888669979888999999',
  '111111223141451233444452233644552233647752283667755883667758888667958989677999999',
  '111111222133314222533314262553334266555444666557488866757498886777498889777999999',
  '111112222113122224133333244536363444556666644555767674558777779588889799888899999',
  '111111122113322222333344425336345525666645555676648588674448888777778899779999999',
  '111111122314441225344422225344426655336666655336678885377778885377988895779999999',
  '111111222113312242553336242533336442556666644755688884757688844757798899777999999',
  '111112222133111422333344442334445542635555572685588877688887777668999779666699999',
  '111112222113345222133345552136445572336645577836644579866647779888647799888899999',
  '111111222133312242335516442335566422335666477885664477855694477858897779888999999',
  '111112222113122232133333332444445566445555566445566666788888889787779899777799999',
  '111111222113344222133334442335444542635555572685888577688877779666887799666999999',
  '111111112333134222333334242567774442566777442566677742565688888555689888599999999',
  '111112222331444422331444425331164625376666625376869955378888955778888955777799999',
  '111111222313114442333354222336554422366555447886655477888657777866699797888999999',
  '111111122313312224333332244555636224556666644577686444557788888577798898779999999',
  '111111122113344222333334442536634442576666642577786682577788888555778899559999999',
  '111111123142222223144442233444455333665555533666557777668877779688888879689999999',
  '111111222311122224335662244355677774355666774355556774338866744388889994888999999',
  '111112223111452333441452233444455233647752283667558888667758988666758999677799999',
  '111111122113333222443335226443355226444555666477558866477588866777888899779999999',
  '111111112133322222333332452666344452666645555764448555764788888777778889799999999',
  '111112222111133442533336422533636422555666444775686884775688884755889999777799999',
  '111111222311444422341452226344452666335555566333758886377758986778888996777999999',
  '111122223111423223411453223444453333445555566777756666788756996788786999788889999',
  '111112222131311422333354442363555422366654447886555747866657777886997979888899999',
  '111112222113333324153362224153366244555666444557668849577768849578888899777799999',
  '111111233111442223444422223546446233556666633557688683577778888577788999557999999',
  '111111122113342222333444442353334442655555552677788858677777888666678899669999999',
  '111111123414452223414452333444552233667752233667755888666758898677758898679999999',
  '111112222333312222334311125334466655444666555446665577489997577888897777888899999',
  '111112222341111222344455226334445766334555766334577766388557776888999976888899999',
  '111111233111442233444452233444555233677752223667555888667758888667788999667999999',
  '111111112314455552344555652334566672344467772346668722386888772388887792399999999',
  '111112222341152222344156627334156677334555677334458677394458667999958867999988888',
  '111122333111123344122223444526623334556666644577786684555788889557789999777889999',
  '111111122341441222344444522346665522333666555773366685773888885777988985779999999',
  '111112222331144222331546662331546672335546677835546977855546977888449977888899999',
  '111111222113122222443333332445556633444555666774455566877777766888889799888999999',
  '111112222113333242115533342666533442766555442766885444768885599767888899777799999',
  '111111112344122222334455622344455662334457766833557776883557766888889776899999999',
  '111112222311311242333355542663354442766358442766658844765558888767998998777799999',
  '111112222333311222344415262334515667344555667344585677949586667999887777999988888',
  '112222233411222335411662355441166335477168335477668855447966885477999885779999988',
  '111112222133133322113332224553644444566666664555556744588877799887779779888899999',
  '111112333122222333114422533144442563445555566745866669775886699777888889777899999',
  '111122233122223333111244355616243355666444555667748595667448999777788889778889999',
  '111111222111333222333344422356364442556666644755568648775558888777888999777999999',
  '111111233141412233444442233454222233655555553667777858667788888667798989667999999',
  '111112222113322244113552444633352744633555774663857774666855799668887799888899999',
  '111111222344441222344441255334661225336666655377866955337899995777899995777888888',
  '111111123114444223444454223667555233667752233667555233677858888677888899679999999',
  '111111112334412222334552226334457726344555776384457766388855766888897766899999999',
  '111111222113344242133444442563333342566666662578888862577777889575778899555999999',
  '111112233411112335442222335442626335476666635477686855477888855477899995778899999',
  '111111122311422225344444225336444255366666665337888655377888885377778995779999999',
  '111111223144151223444452223664455223666457333688557733688857777688959779688999999',
  '111112222133444222134444252136644555136666657333886657939888857999888557999977777',
  '111122333141222233141242233144445533445555566775566668779969868779999868777998888',
  '111112333141222333142255633142255663444257666844557769884557769888777969888799999',
  '111111222331144422331555422336654472833654772836654477886555977886669977888999999',
  '111112222313311222333341255363444255666645555667444858667948888777998898777799999',
  '111111222131333442133335442666535422776555422776585444766588889766888989777999999',
  '111112222134411122334444222344455566333555666335557776888777766889997769888899999',
  '111111122331132222333334442356666442755564442755666648755588888777789988779999999',
  '112222233411233235411233335411266555416666675444668775499998775498998775998888877',
  '111111122313341222333342252336445255666645555667644588767748888777948898779999999',
  '111222223411122233441132335441633355466666665447776855477978855779998885799999888',
  '111111222113331222333344522663345552666444555766648855776448888777988899777999999',
  '111111122331144442533333442553364442566666662577768822577888882577779988559999999',
  '111111112331333442533366442555366442577764442577668222577668882577888988599999999',
  '111222233411223335441223635441266635471168835476669855476799855477799885779999888',
  '111222223411122333411152336444552336447555366477855666477859996777889996788888999',
  '111122233111223333112224333556244444566666664555557644888577799888877999887779999',
  '111111222111332222433356622443555666433357776444555766884457776888877999888999999',
  '111111222311132224333333324555566624575666424576664444578888888577789998777999999',
  '111112222111332222144433332444335536445555566475577666877776669888877999888899999',
  '111111112133334222335544442333554422667754422667755888677775588666788889699999999',
  '111112222131114222333544422335554446337754466377755566887775666888799969888899999',
  '111122223111223323415526333414526633444555666774485696777485596787788999788889999',
  '111111122113322222433325266433335666445555566444577776448587776888887799889999999',
  '111112222111133324533333624555536624577666224576684444576888884578889999777799999',
  '111111223441222233441233333441223566455555556445788966777778966778888966788999999',
  '111112222111332332144333352444466352746666652748665555748888559788788999777799999',
  '111112233112212334152222344556333344566666664557777644557888849577898899778899999',
  '111112222111312442333332442355536642356666647856674447855877777855897999888899999',
  '111111222311342225313342255333442555366645557666844777668847797688847997888999999',
  '111112222113145222133345252333345555366444557666647777868647779888649799888899999',
  '111111112133342222333544662733546662753546862755546882755446888777748889799999999',
  '111122233411223333415522363411522366444555666447885996747885596777788996778889999',
  '111112222311314255333314225663334225666444555677488855677498888667498998777799999',
  '111111222131444442331455542633357442663357722688357772685558977688888979666999999',
  '111112222311422225331424445331444465366666665367777855377797855399997885999988888',
  '111111112313222222333244555333245555663444755666648777666448777888888797899999999',
  '111123333111122333122222334526644444556666644555556674588777779888779999888879999',
  '111112222133314222113344252663345555663347755666647755868447799888497779888899999',
  '111111222131441222334445522334455662334457766833557766885577766888977969888999999',
  '111222223111122323415552333414453366444753666447756686777955586797998888799999888',
  '111111222314444222311444522334466552336666655733668855773888995777888895777999999',
  '111111222313144422333142222344445566345555576335577776888879666887779696888999999',
  '111222233111423333551423363511422266555444666557774886959974866999974888997777888',
  '111111112331442222334445222344445562333555666735588886777588866777788966799999999',
  '111111112333312222333442252366644552366645557866445557868844777888897777899999999',
  '111111112333122222443526227443556677443555677443355677488385677888889666899999999',
  '111112222131132224133333224536636444555666444555676674588777779588879979888899999',
  '111111222331312224533316244553366224553666744588667744558697774588897977888999999',
  '111111222311314222333334225663344255666645555667448855677488888777498998777999999',
  '111112222311122222334156666334455677334555677334556677444458677999998887999988888',
  '111111122113344442333342222335544442635555572688885577666687777688887799669999999',
  '111112233111222234152262334555566634577763334576664444577868849578888999778899999',
  '111111122311334442333335422366555422776654422776555448776588888766688998779999999',
  '111111222113122244533326244533336244536666674558677774558687774558889799888999999',
  '111112222113333222133344522136344555666645555666447578996447778999777788999988888',
  '111111112333142222335644422335646422335666477885656477885556477888859777899999999',
  '111111112333312222344352266343352266445555566447758868447758668777798888799999999',
  '111112222111133242553333642555333642756666642756888444756888844757889999777799999',
  '111111222311122244333352444333352244665555544667758888666758888667779998777999999',
  '111112222113122224513336624553336744553666744553677744586677794588889799888899999',
  '111111222313311422333334422556634442756666642755586644775588888775998898777999999',
  '111111112333414442533444422533336422566666662557688882557777882577797888599999999',
  '111111122331142222333344422335554442365654547866655577886667777888869977889999999',
  '111112222131412422335414462335444462335555566738888566738898566778798969777799999',
  '111112222133142222135444424135556444333356666777355568797777568999978668999988888',
  '111112222331122242333112444353664447356666647355566747555899777858889977888899999',
  '111111122131334422333355422666355422676358424776558444776558888776688989779999999',
  '111111122133314442335364422735366422735666482775668482775568488755598889779999999',
  '111123333111222233112244335662244355666645555667448855677448899778888999777789999',
  '111111122333144442333155442633354442666555222677758882677559888677779888669999999',
  '111112222311114522336644522333645552333645777866645777886445577886499997888899999',
  '111112222113322224133334424135534444635555574666675578696677778699997788999988888',
  '112222223411122233411533336411535366444555666447575886477775886779998886799999988',
  '111111222111332222444433225443336665433666775466677755488775555888877999888999999',
  '111112222111312242333355442363355442366654447866557747866557777868897999888899999',
  '111111222314441222314445522344646552336666655733686885773388895777988895777999999',
  '111111222133455222113456662333456762833456772843456777844456799888556779888999999',
  '111112222113311422333354442336655422366555447886554477866657777886997799888899999',
  '111111223114122223444442333445452233665555533667758588666788888677779899677999999',
  '111111122313145552333345522366344522776348522776448558776648888766649898779999999',
  '111111222314441255314642225344644225336666655377886885377786895337988895777999999',
  '111111222341412222341445262344455666343555676333557776838577976888897976888999999',
  '111111122131222224332234444333335444655555554666577777666678877688888979889999999',
  '111111112134422222334422526344445566334555766335577776385887766888887769899999999',
  '111111123141422223444422323454423333655555553666678858676778888677778989679999999',
  '111111122314442222314544262344545662333555666733585886737885896777788896779999999',
  '111112222113112224333332244355366644556367644556667447558877777588899799888899999',
  '111123333111122223412225333444525636444555666474585666777588896788889999777789999',
  '111112222131142222135544267335546667333546777355546677358446679888849979888899999',
  '111122333441222333411225336411225366445555566447588996477588996777888966777889999',
  '111111222133132224133333244555366224556666644577668444557888889577789889777999999',
  '111111222113422242133444442333355442335555566788556666788888669787778699777999999',
  '111111222111344422333355422333354422666555444776658888776558888776668999777999999',
  '111112222131132244133332224335354444665555544666657577688877779668879979888899999',
  '111111222133333222133334242156664442555666444755566648757599998777999998777888888',
  '111112222133114222133334255636334255666444555667488585667488889777499889777799999',
  '111112222331444442311544422315546622333555666773385596778885996788888966777799999',
  '111112222313144225313142225333645555336645577666645777688849797688449797888899999',
  '111112222113311224533332244536332444566666664555788684557788884577998899777799999',
  '111111122133331222434432222444333556445555566455777666888876676888977779889999999',
  '111222223111222233411333333415566666445555566444445576888888776889999777899999777',
  '111112222331444222311154422335554446333754666377755566887759996888777966888899999',
  '111111122341412222344442255334442665336666655366788855337788885777798985779999999',
  '111111222131331222333334255666344225666444555677448555667488888777988989777999999',
  '111111222131122222334455526333457776344457776344457666385557766888889969888999999',
  '111111222331122224533126424533336444536666674555677774585689774588889977888999999',
  '111111122133322222133445522633455555633444775666664775886644779888887779889999999',
  '111111122133342222133344552663345552763645852766648855766448889777748889779999999',
  '111111222133314225633314225666344225663347755688447555688497775688497779888999999',
  '111111233141412233444442333456662233455666227885566627888577777885597979885999999',
  '111112222133311124333335224366555224666654444677555448677588888679998889777799999',
  '111122333441222233441123333441122556445555566455778866999978866997777866999778888',
  '112222233111122233411552336441553366444753666447755866477955886779998888779999988',
  '111112333122212333124222335144446635446666655476655558477999598777989998777988888',
  '111112222331222224331144444331445546335555566375577866777778866799999866999988888',
  '111222223141222333441233335411163655446666655446768885477779855777999858799999888',
  '111111222314442225314444255316446225336666655377688695337888895377788895777999999',
  '111111122333441442333341422355344422665555522667778558667978888677977888669999999',
  '111111122333131222343333225444466625476465625476665555477888858777989888779999999',
  '111111122133342225133342255333445225666645555677644888667748889677748889779999999',
  '111111112133333322443355222443556222444456666777455866777558866778888889799999999',
  '111112222314415222311455672333456672334456677834456777834556997888596697888899999',
  '111111112331332222433332252443666652444465555746666855747788885777788988799999999',
]);
