# ShuttleAI API

## Introduction

Are you a developer keen on integrating AI capabilities into your projects, but find the cost of GPT-4 prohibitive or are operating within budget constraints? Look no further!

ShuttleAI API provides a highly **efficient** and **reliable** service!

Our discord: https://discord.gg/shuttleai

Check out `shuttle-3` and `s1` for chat completions and `shuttle-2-diffusion` for image generations!

## Getting Started

To obtain your complimentary ShuttleAI API key, simply follow these steps:

1. Register on [Our Platform](https://shuttleai.com).
2. Proceed to the [Dashboard](https://shuttleai.com/keys) to generate your unique key.

For comprehensive instructions on utilizing our API effectively, refer to the ShuttleAI API documentation available at [https://docs.shuttleai.com/](https://docs.shuttleai.com/).

## ShuttleAI Models (131 Total):
[shuttleai.com/models](https://shuttleai.com/models)
| Name | Description | Type | Owned By | Pricing |
| --- | --- | --- | --- | --- |
| [s1 🍓](https://api.shuttleai.com/v1/models/s1) | ShuttleAI's reasoning model designed to solve complex tasks across domains, this model can also exec... | 💬 chat.completions | shuttleai | $0.00140/1K inTokens<br>$0.00180/1K outTokens |
| [s1 🍓 Mini](https://api.shuttleai.com/v1/models/s1-mini) | ShuttleAI's cheap and fast reasoning model, which can execute Python code live in its responses. | 💬 chat.completions | shuttleai | $0.00070/1K inTokens<br>$0.00090/1K outTokens |
| [Shuttle 2.5 (64k)](https://api.shuttleai.com/v1/models/shuttle-2.5) | ShuttleAI's smartest, most powerful model. shuttle-2.5 is perfect for large-scale applications and p... | 💬 chat.completions | shuttleai | $0.00050/1K inTokens<br>$0.00070/1K outTokens |
| [Shuttle Mini](https://api.shuttleai.com/v1/models/shuttle-2.5-mini-2024-09-11) | A smaller version of shuttle-2.5, shuttle-2.5-mini is perfect for smaller applications and projects.... | 💬 chat.completions | shuttleai | $0.00007/1K inTokens<br>$0.00009/1K outTokens |
| [Shuttle 2 Diffusion](https://api.shuttleai.com/v1/models/shuttle-2-diffusion) | ShuttleAI's image generation model, capable of creating high-quality images in seconds. Perfect for ... | 🎨 images.generations | shuttleai | $0.003/image |
| [o1 🍓 Preview](https://api.shuttleai.com/v1/models/o1-preview-2024-09-12) | reasoning model designed to solve hard problems across domains. | 💬 chat.completions | openai | $0.01500/1K inTokens<br>$0.06000/1K outTokens |
| [o1 🍓 Mini](https://api.shuttleai.com/v1/models/o1-mini-2024-09-12) | faster and cheaper reasoning model particularly good at coding, math, and science. | 💬 chat.completions | openai | $0.00300/1K inTokens<br>$0.01200/1K outTokens |
| [GPT-4o Mini (128k, 16k)](https://api.shuttleai.com/v1/models/gpt-4o-mini-2024-07-18) | OpenAI's affordable and intelligent small model for fast, lightweight tasks. GPT-4o mini is cheaper ... | 💬 chat.completions | openai | $0.00015/1K inTokens<br>$0.00060/1K outTokens |
| [ChatGPT 4o (128k, 16k)](https://api.shuttleai.com/v1/models/chatgpt-4o-latest) | Dynamic model continuously updated to the current version of GPT-4o in ChatGPT. | 💬 chat.completions | openai | $0.00500/1K inTokens<br>$0.01500/1K outTokens |
| [GPT-4o (128k, 16k)](https://api.shuttleai.com/v1/models/gpt-4o-2024-08-06) | Latest snapshot that supports [Structured Outputs](https://platform.openai.com/docs/guides/structure... | 💬 chat.completions | openai | $0.00250/1K inTokens<br>$0.01000/1K outTokens |
| [GPT-4o (128k, 4k)](https://api.shuttleai.com/v1/models/gpt-4o-2024-05-13) | OpenAI's high-intelligence flagship model for complex, multi-step tasks. GPT-4o is cheaper and faste... | 💬 chat.completions | openai | $0.00500/1K inTokens<br>$0.01500/1K outTokens |
| [GPT-4 Turbo](https://api.shuttleai.com/v1/models/gpt-4-turbo-2024-04-09) | Vision requests can now use JSON mode and function calling. | 💬 chat.completions | openai | $0.01000/1K inTokens<br>$0.03000/1K outTokens |
| [GPT-4 Turbo Preview (0125)](https://api.shuttleai.com/v1/models/gpt-4-0125-preview) | GPT-4 Turbo preview model intended to reduce cases of “laziness” where the model doesn't complete a ... | 💬 chat.completions | openai | $0.01000/1K inTokens<br>$0.03000/1K outTokens |
| [GPT-4 Turbo Preview (1106)](https://api.shuttleai.com/v1/models/gpt-4-1106-preview) | GPT-4 Turbo preview model featuring improved instruction following, JSON mode, reproducible outputs,... | 💬 chat.completions | openai | $0.01000/1K inTokens<br>$0.03000/1K outTokens |
| [GPT-4 (8k)](https://api.shuttleai.com/v1/models/gpt-4-0613) | Snapshot of gpt-4 from June 13th 2023 with improved function calling support. | 💬 chat.completions | openai | $0.03000/1K inTokens<br>$0.06000/1K outTokens |
| [GPT-3.5 Turbo (0125)](https://api.shuttleai.com/v1/models/gpt-3.5-turbo-0125) | The latest GPT-3.5 Turbo model with higher accuracy at responding in requested formats and a fix for... | 💬 chat.completions | openai | $0.00050/1K inTokens<br>$0.00150/1K outTokens |
| [GPT-3.5 Turbo (1106)](https://api.shuttleai.com/v1/models/gpt-3.5-turbo-1106) | GPT-3.5 Turbo model with improved instruction following, JSON mode, reproducible outputs, parallel f... | 💬 chat.completions | openai | $0.00100/1K inTokens<br>$0.00200/1K outTokens |
| [DALL-E 3](https://api.shuttleai.com/v1/models/dall-e-3) | The latest DALL·E model released in Nov 2023 | 🎨 images.generations | openai | $0.400/image |
| [Whisper 1](https://api.shuttleai.com/v1/models/whisper-1) | Whisper is a general-purpose speech recognition model. It is trained on a large dataset of diverse a... | 👂 audio.listen | openai | $0.00000/second |
| [TTS 1](https://api.shuttleai.com/v1/models/tts-1) | OpenAI's latest text to speech model, optimized for speed. | 🔊 audio.speech | openai | $0.01500/1K characters |
| [TTS 1 HD](https://api.shuttleai.com/v1/models/tts-1-hd) | OpenAI's latest text to speech model, optimized for quality. | 🔊 audio.speech | openai | $0.03000/1K characters |
| [Text Embedding 3 (Large)](https://api.shuttleai.com/v1/models/text-embedding-3-large) | OpenAI's most capable embedding model for both english and non-english tasks | 🧠 embeddings | openai | $0.00013/1K tokens |
| [Text Embedding 3 (Small)](https://api.shuttleai.com/v1/models/text-embedding-3-small) | Increased performance over 2nd generation ada embedding model | 🧠 embeddings | openai | $0.00002/1K tokens |
| [Text Moderation (007)](https://api.shuttleai.com/v1/models/text-moderation-007) | OpenAI's most capable moderation model across all categories. | 🛡️ moderations | openai | $0.000/request |
| [Claude 3.5 Sonnet](https://api.shuttleai.com/v1/models/claude-3-5-sonnet-20240620) | Anthropic's most intelligent model to date. | 💬 chat.completions | anthropic | $0.00300/1K inTokens<br>$0.01500/1K outTokens |
| [Claude 3 Opus](https://api.shuttleai.com/v1/models/claude-3-opus-20240229) | Powerful model for highly complex tasks | 💬 chat.completions | anthropic | $0.01500/1K inTokens<br>$0.07500/1K outTokens |
| [Claude 3 Haiku](https://api.shuttleai.com/v1/models/claude-3-haiku-20240307) | Anthropic's fastest and most compact model for near-instant responsiveness | 💬 chat.completions | anthropic | $0.00025/1K inTokens<br>$0.00125/1K outTokens |
| [Gemini 1.5 Pro](https://api.shuttleai.com/v1/models/gemini-1.5-pro) | Gemini 1.5 Pro is a mid-size multimodal model that is optimized for a wide-range of reasoning tasks.... | 💬 chat.completions | google | $0.00700/1K inTokens<br>$0.02100/1K outTokens |
| [Gemini 1.5 Pro Exp (0827)](https://api.shuttleai.com/v1/models/gemini-1.5-pro-exp-0827) | Quality improvements for Gemini 1.5 Pro | 💬 chat.completions | google | $0.00700/1K inTokens<br>$0.02100/1K outTokens |
| [Gemini 1.5 Flash](https://api.shuttleai.com/v1/models/gemini-1.5-flash) | Gemini 1.5 Flash is a fast and versatile multimodal model for scaling across diverse tasks. | 💬 chat.completions | google | $0.00015/1K inTokens<br>$0.00060/1K outTokens |
| [Gemini 1.5 Flash Exp (0827)](https://api.shuttleai.com/v1/models/gemini-1.5-flash-exp-0827) | Quality improvements for Gemini 1.5 Flash | 💬 chat.completions | google | $0.00015/1K inTokens<br>$0.00060/1K outTokens |
| [Gemini 1.5 Flash 8B Exp (0827)](https://api.shuttleai.com/v1/models/gemini-1.5-flash-8b-exp-0827) | Preview release of Gemini 1.5 Flash-8B Note: 1.5 Flash-8B has the same capabilities as 1.5 Flash | 💬 chat.completions | google | $0.00015/1K inTokens<br>$0.00060/1K outTokens |
| [Google Search](https://api.shuttleai.com/v1/models/search-google) | Google Search is a web_search model by google that can input->output text->web.search,image. This mo... | 🔍 web.search | google | $0.000/request |
| [Meta Llama 3.1 405b Instruct](https://api.shuttleai.com/v1/models/meta-llama-3.1-405b-instruct) | Meta Llama's most intelligent model to date. | 💬 chat.completions | meta-llama | $0.00270/1K inTokens<br>$0.00270/1K outTokens |
| [Meta Llama 3.1 70b Instruct](https://api.shuttleai.com/v1/models/meta-llama-3.1-70b-instruct) | Meta Llama's latest 70b model. | 💬 chat.completions | meta-llama | $0.00052/1K inTokens<br>$0.00075/1K outTokens |
| [Meta Llama 3.1 8b Instruct](https://api.shuttleai.com/v1/models/meta-llama-3.1-8b-instruct) | Meta Llama's latest 8b model. | 💬 chat.completions | meta-llama | $0.00006/1K inTokens<br>$0.00006/1K outTokens |
| [Reflection Llama 3.1 70b](https://api.shuttleai.com/v1/models/reflection-llama-3.1-70b) | Reflection Llama-3.1 70B is (currently) the world's top open-source LLM, trained with a new techniqu... | 💬 chat.completions | mattshumer | $0.00035/1K inTokens<br>$0.00040/1K outTokens |
| [Llama 3.1 Sonar Large 128k Online](https://api.shuttleai.com/v1/models/llama-3.1-sonar-large-128k-online) | Llama 3.1 Sonar Large 128k Online is a chat model by perplexity that can input->output text->text. T... | 💬 chat.completions | perplexity | $0.01500/1K inTokens<br>$0.03000/1K outTokens |
| [Llama 3.1 Sonar Small 128k Online](https://api.shuttleai.com/v1/models/llama-3.1-sonar-small-128k-online) | Llama 3.1 Sonar Small 128k Online is a chat model by perplexity that can input->output text->text. T... | 💬 chat.completions | perplexity | $0.01000/1K inTokens<br>$0.02000/1K outTokens |
| [Llama 3.1 Sonar Large 128k Chat](https://api.shuttleai.com/v1/models/llama-3.1-sonar-large-128k-chat) | Llama 3.1 Sonar Large 128k Chat is a chat model by perplexity that can input->output text->text. Thi... | 💬 chat.completions | perplexity | $0.01500/1K inTokens<br>$0.03000/1K outTokens |
| [Llama 3.1 Sonar Small 128k Chat](https://api.shuttleai.com/v1/models/llama-3.1-sonar-small-128k-chat) | Llama 3.1 Sonar Small 128k Chat is a chat model by perplexity that can input->output text->text. Thi... | 💬 chat.completions | perplexity | $0.01500/1K inTokens<br>$0.03000/1K outTokens |
| [Mistral Nemo Instruct (2407)](https://api.shuttleai.com/v1/models/mistral-nemo-instruct-2407) | Mistral Nemo Instruct (2407) is a chat model by mistralai that can input->output text->text. This mo... | 💬 chat.completions | mistralai | $0.00013/1K inTokens<br>$0.00013/1K outTokens |
| [Codestral Latest](https://api.shuttleai.com/v1/models/codestral-2405) | Codestral Latest is a chat model by mistralai that can input->output text->text. This model costs In... | 💬 chat.completions | mistralai | $0.00004/1K inTokens<br>$0.00004/1K outTokens |
| [Command R+ (08-2024)](https://api.shuttleai.com/v1/models/command-r-plus-08-2024) | Command R+ (08-2024) is a chat model by cohere that can input->output text->text. This model costs I... | 💬 chat.completions | cohere | $0.00004/1K inTokens<br>$0.00004/1K outTokens |
| [Command R+](https://api.shuttleai.com/v1/models/command-r-plus) | Command R+ is a chat model by cohere that can input->output text->text. This model costs In: $0.044/... | 💬 chat.completions | cohere | $0.00004/1K inTokens<br>$0.00004/1K outTokens |
| [Command R (08-2024)](https://api.shuttleai.com/v1/models/command-r-08-2024) | Command R (08-2024) is a chat model by cohere that can input->output text->text. This model costs In... | 💬 chat.completions | cohere | $0.00004/1K inTokens<br>$0.00004/1K outTokens |
| [Command R](https://api.shuttleai.com/v1/models/command-r) | Command R is a chat model by cohere that can input->output text->text. This model costs In: $0.044/M... | 💬 chat.completions | cohere | $0.00004/1K inTokens<br>$0.00004/1K outTokens |
| [FLUX.1 Pro](https://api.shuttleai.com/v1/models/flux1-pro) | FLUX.1 Pro is a image model by black-forest-labs that can input->output text->image. This model cost... | 🎨 images.generations | black-forest-labs | $0.050/image |
| [FLUX.1 Dev](https://api.shuttleai.com/v1/models/flux1-dev) | FLUX.1 Dev is a image model by black-forest-labs that can input->output text->image. This model cost... | 🎨 images.generations | black-forest-labs | $0.030/image |
| [FLUX.1 Schnell](https://api.shuttleai.com/v1/models/flux1-schnell) | FLUX.1 Schnell is a image model by black-forest-labs that can input->output text->image. This model ... | 🎨 images.generations | black-forest-labs | $0.010/image |
| [SDXL](https://api.shuttleai.com/v1/models/sdxl) | SDXL is a image model by stabilityai that can input->output ({<ModelModalities.TEXT: 'text'>}, {<Mod... | 🎨 images.generations | stabilityai | $0.003/image |
| [SDXL Inpaint](https://api.shuttleai.com/v1/models/sdxl-inpaint) | SDXL Inpaint is a image model by stabilityai that can input->output ({<ModelModalities.TEXT: 'text'>... | 🎨 images.generations | stabilityai | $0.007/image |
| [DreamShaperXL v10](https://api.shuttleai.com/v1/models/dreamshaperxl-v10) | DreamShaperXL v10 is a image model by stabilityai that can input->output ({<ModelModalities.TEXT: 't... | 🎨 images.generations | stabilityai | $0.003/image |
| [JuggernautXL](https://api.shuttleai.com/v1/models/juggernautxl) | JuggernautXL is a image model by stabilityai that can input->output ({<ModelModalities.TEXT: 'text'>... | 🎨 images.generations | stabilityai | $0.003/image |
| [TurboVisionXL](https://api.shuttleai.com/v1/models/turbovisionxl) | TurboVisionXL is a image model by stabilityai that can input->output ({<ModelModalities.TEXT: 'text'... | 🎨 images.generations | stabilityai | $0.003/image |
| [Realistic Vision v5.1](https://api.shuttleai.com/v1/models/realistic-vision-v5.1) | Realistic Vision v5.1 is a image model by stabilityai that can input->output ({<ModelModalities.TEXT... | 🎨 images.generations | stabilityai | $0.001/image |
| [Eleven Turbo v2.5 (Speed)](https://api.shuttleai.com/v1/models/eleven_turbo_v2_5) | ElevenLabs' high quality, lowest latency model that's great for developer use cases where speed matt... | 🔊 audio.speech | elevenlabs | $0.00500/1K characters |
| [Eleven Multilingual v2 (Quality)](https://api.shuttleai.com/v1/models/eleven_multilingual_v2) | ElevenLabs' most life-like, emotionally rich mode in 29 languages. Best for voice overs, audiobooks,... | 🔊 audio.speech | elevenlabs | $0.01000/1K characters |
| [Speechify](https://api.shuttleai.com/v1/models/speechify) | Speechify offeres a variety of both language specific and celebrity/character voices. | 🔊 audio.speech | cliffweitzma | $0.01200/1K characters |
| [DuckDuckGo Search](https://api.shuttleai.com/v1/models/search-ddg) | DuckDuckGo Search is a web_search model by duckduckgo that can input->output text->web.search. This ... | 🔍 web.search | duckduckgo | $0.001/request |
