// Generated by scripts/prepare.ts
import type { DynamicImportLanguageRegistration, BundledLanguageInfo } from '@shikijs/core'

export const bundledLanguagesInfo: BundledLanguageInfo[] = [
  {
    'id': 'abap',
    'name': 'ABAP',
    'import': (() => import('./langs/abap.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'actionscript-3',
    'name': 'ActionScript',
    'import': (() => import('./langs/actionscript-3.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'ada',
    'name': 'Ada',
    'import': (() => import('./langs/ada.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'angular-html',
    'name': 'Angular HTML',
    'import': (() => import('./langs/angular-html.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'angular-ts',
    'name': 'Angular TypeScript',
    'import': (() => import('./langs/angular-ts.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'apache',
    'name': 'Apache Conf',
    'import': (() => import('./langs/apache.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'apex',
    'name': 'Apex',
    'import': (() => import('./langs/apex.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'apl',
    'name': 'APL',
    'import': (() => import('./langs/apl.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'applescript',
    'name': 'AppleScript',
    'import': (() => import('./langs/applescript.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'ara',
    'name': 'Ara',
    'import': (() => import('./langs/ara.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'asciidoc',
    'name': 'AsciiDoc',
    'aliases': [
      'adoc'
    ],
    'import': (() => import('./langs/asciidoc.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'asm',
    'name': 'Assembly',
    'import': (() => import('./langs/asm.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'astro',
    'name': 'Astro',
    'import': (() => import('./langs/astro.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'awk',
    'name': 'AWK',
    'import': (() => import('./langs/awk.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'ballerina',
    'name': 'Ballerina',
    'import': (() => import('./langs/ballerina.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'bat',
    'name': 'Batch File',
    'aliases': [
      'batch'
    ],
    'import': (() => import('./langs/bat.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'beancount',
    'name': 'Beancount',
    'import': (() => import('./langs/beancount.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'berry',
    'name': 'Berry',
    'aliases': [
      'be'
    ],
    'import': (() => import('./langs/berry.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'bibtex',
    'name': 'BibTeX',
    'import': (() => import('./langs/bibtex.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'bicep',
    'name': 'Bicep',
    'import': (() => import('./langs/bicep.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'blade',
    'name': 'Blade',
    'import': (() => import('./langs/blade.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'c',
    'name': 'C',
    'import': (() => import('./langs/c.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'cadence',
    'name': 'Cadence',
    'aliases': [
      'cdc'
    ],
    'import': (() => import('./langs/cadence.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'cairo',
    'name': 'Cairo',
    'import': (() => import('./langs/cairo.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'clarity',
    'name': 'Clarity',
    'import': (() => import('./langs/clarity.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'clojure',
    'name': 'Clojure',
    'aliases': [
      'clj'
    ],
    'import': (() => import('./langs/clojure.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'cmake',
    'name': 'CMake',
    'import': (() => import('./langs/cmake.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'cobol',
    'name': 'COBOL',
    'import': (() => import('./langs/cobol.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'codeowners',
    'name': 'CODEOWNERS',
    'import': (() => import('./langs/codeowners.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'codeql',
    'name': 'CodeQL',
    'aliases': [
      'ql'
    ],
    'import': (() => import('./langs/codeql.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'coffee',
    'name': 'CoffeeScript',
    'aliases': [
      'coffeescript'
    ],
    'import': (() => import('./langs/coffee.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'common-lisp',
    'name': 'Common Lisp',
    'aliases': [
      'lisp'
    ],
    'import': (() => import('./langs/common-lisp.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'coq',
    'name': 'Coq',
    'import': (() => import('./langs/coq.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'cpp',
    'name': 'C++',
    'aliases': [
      'c++'
    ],
    'import': (() => import('./langs/cpp.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'crystal',
    'name': 'Crystal',
    'import': (() => import('./langs/crystal.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'csharp',
    'name': 'C#',
    'aliases': [
      'c#',
      'cs'
    ],
    'import': (() => import('./langs/csharp.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'css',
    'name': 'CSS',
    'import': (() => import('./langs/css.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'csv',
    'name': 'CSV',
    'import': (() => import('./langs/csv.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'cue',
    'name': 'CUE',
    'import': (() => import('./langs/cue.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'cypher',
    'name': 'Cypher',
    'aliases': [
      'cql'
    ],
    'import': (() => import('./langs/cypher.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'd',
    'name': 'D',
    'import': (() => import('./langs/d.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'dart',
    'name': 'Dart',
    'import': (() => import('./langs/dart.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'dax',
    'name': 'DAX',
    'import': (() => import('./langs/dax.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'desktop',
    'name': 'Desktop',
    'import': (() => import('./langs/desktop.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'diff',
    'name': 'Diff',
    'import': (() => import('./langs/diff.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'docker',
    'name': 'Dockerfile',
    'aliases': [
      'dockerfile'
    ],
    'import': (() => import('./langs/docker.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'dotenv',
    'name': 'dotEnv',
    'import': (() => import('./langs/dotenv.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'dream-maker',
    'name': 'Dream Maker',
    'import': (() => import('./langs/dream-maker.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'edge',
    'name': 'Edge',
    'import': (() => import('./langs/edge.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'elixir',
    'name': 'Elixir',
    'import': (() => import('./langs/elixir.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'elm',
    'name': 'Elm',
    'import': (() => import('./langs/elm.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'emacs-lisp',
    'name': 'Emacs Lisp',
    'aliases': [
      'elisp'
    ],
    'import': (() => import('./langs/emacs-lisp.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'erb',
    'name': 'ERB',
    'import': (() => import('./langs/erb.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'erlang',
    'name': 'Erlang',
    'aliases': [
      'erl'
    ],
    'import': (() => import('./langs/erlang.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'fennel',
    'name': 'Fennel',
    'import': (() => import('./langs/fennel.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'fish',
    'name': 'Fish',
    'import': (() => import('./langs/fish.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'fluent',
    'name': 'Fluent',
    'aliases': [
      'ftl'
    ],
    'import': (() => import('./langs/fluent.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'fortran-fixed-form',
    'name': 'Fortran (Fixed Form)',
    'aliases': [
      'f',
      'for',
      'f77'
    ],
    'import': (() => import('./langs/fortran-fixed-form.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'fortran-free-form',
    'name': 'Fortran (Free Form)',
    'aliases': [
      'f90',
      'f95',
      'f03',
      'f08',
      'f18'
    ],
    'import': (() => import('./langs/fortran-free-form.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'fsharp',
    'name': 'F#',
    'aliases': [
      'f#',
      'fs'
    ],
    'import': (() => import('./langs/fsharp.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'gdresource',
    'name': 'GDResource',
    'import': (() => import('./langs/gdresource.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'gdscript',
    'name': 'GDScript',
    'import': (() => import('./langs/gdscript.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'gdshader',
    'name': 'GDShader',
    'import': (() => import('./langs/gdshader.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'genie',
    'name': 'Genie',
    'import': (() => import('./langs/genie.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'gherkin',
    'name': 'Gherkin',
    'import': (() => import('./langs/gherkin.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'git-commit',
    'name': 'Git Commit Message',
    'import': (() => import('./langs/git-commit.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'git-rebase',
    'name': 'Git Rebase Message',
    'import': (() => import('./langs/git-rebase.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'gleam',
    'name': 'Gleam',
    'import': (() => import('./langs/gleam.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'glimmer-js',
    'name': 'Glimmer JS',
    'aliases': [
      'gjs'
    ],
    'import': (() => import('./langs/glimmer-js.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'glimmer-ts',
    'name': 'Glimmer TS',
    'aliases': [
      'gts'
    ],
    'import': (() => import('./langs/glimmer-ts.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'glsl',
    'name': 'GLSL',
    'import': (() => import('./langs/glsl.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'gnuplot',
    'name': 'Gnuplot',
    'import': (() => import('./langs/gnuplot.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'go',
    'name': 'Go',
    'import': (() => import('./langs/go.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'graphql',
    'name': 'GraphQL',
    'aliases': [
      'gql'
    ],
    'import': (() => import('./langs/graphql.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'groovy',
    'name': 'Groovy',
    'import': (() => import('./langs/groovy.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'hack',
    'name': 'Hack',
    'import': (() => import('./langs/hack.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'haml',
    'name': 'Ruby Haml',
    'import': (() => import('./langs/haml.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'handlebars',
    'name': 'Handlebars',
    'aliases': [
      'hbs'
    ],
    'import': (() => import('./langs/handlebars.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'haskell',
    'name': 'Haskell',
    'aliases': [
      'hs'
    ],
    'import': (() => import('./langs/haskell.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'haxe',
    'name': 'Haxe',
    'import': (() => import('./langs/haxe.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'hcl',
    'name': 'HashiCorp HCL',
    'import': (() => import('./langs/hcl.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'hjson',
    'name': 'Hjson',
    'import': (() => import('./langs/hjson.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'hlsl',
    'name': 'HLSL',
    'import': (() => import('./langs/hlsl.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'html',
    'name': 'HTML',
    'import': (() => import('./langs/html.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'html-derivative',
    'name': 'HTML (Derivative)',
    'import': (() => import('./langs/html-derivative.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'http',
    'name': 'HTTP',
    'import': (() => import('./langs/http.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'hxml',
    'name': 'HXML',
    'import': (() => import('./langs/hxml.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'hy',
    'name': 'Hy',
    'import': (() => import('./langs/hy.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'imba',
    'name': 'Imba',
    'import': (() => import('./langs/imba.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'ini',
    'name': 'INI',
    'aliases': [
      'properties'
    ],
    'import': (() => import('./langs/ini.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'java',
    'name': 'Java',
    'import': (() => import('./langs/java.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'javascript',
    'name': 'JavaScript',
    'aliases': [
      'js'
    ],
    'import': (() => import('./langs/javascript.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'jinja',
    'name': 'Jinja',
    'import': (() => import('./langs/jinja.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'jison',
    'name': 'Jison',
    'import': (() => import('./langs/jison.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'json',
    'name': 'JSON',
    'import': (() => import('./langs/json.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'json5',
    'name': 'JSON5',
    'import': (() => import('./langs/json5.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'jsonc',
    'name': 'JSON with Comments',
    'import': (() => import('./langs/jsonc.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'jsonl',
    'name': 'JSON Lines',
    'import': (() => import('./langs/jsonl.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'jsonnet',
    'name': 'Jsonnet',
    'import': (() => import('./langs/jsonnet.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'jssm',
    'name': 'JSSM',
    'aliases': [
      'fsl'
    ],
    'import': (() => import('./langs/jssm.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'jsx',
    'name': 'JSX',
    'import': (() => import('./langs/jsx.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'julia',
    'name': 'Julia',
    'aliases': [
      'jl'
    ],
    'import': (() => import('./langs/julia.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'kotlin',
    'name': 'Kotlin',
    'aliases': [
      'kt',
      'kts'
    ],
    'import': (() => import('./langs/kotlin.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'kusto',
    'name': 'Kusto',
    'aliases': [
      'kql'
    ],
    'import': (() => import('./langs/kusto.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'latex',
    'name': 'LaTeX',
    'import': (() => import('./langs/latex.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'lean',
    'name': 'Lean 4',
    'aliases': [
      'lean4'
    ],
    'import': (() => import('./langs/lean.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'less',
    'name': 'Less',
    'import': (() => import('./langs/less.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'liquid',
    'name': 'Liquid',
    'import': (() => import('./langs/liquid.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'log',
    'name': 'Log file',
    'import': (() => import('./langs/log.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'logo',
    'name': 'Logo',
    'import': (() => import('./langs/logo.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'lua',
    'name': 'Lua',
    'import': (() => import('./langs/lua.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'luau',
    'name': 'Luau',
    'import': (() => import('./langs/luau.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'make',
    'name': 'Makefile',
    'aliases': [
      'makefile'
    ],
    'import': (() => import('./langs/make.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'markdown',
    'name': 'Markdown',
    'aliases': [
      'md'
    ],
    'import': (() => import('./langs/markdown.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'marko',
    'name': 'Marko',
    'import': (() => import('./langs/marko.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'matlab',
    'name': 'MATLAB',
    'import': (() => import('./langs/matlab.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'mdc',
    'name': 'MDC',
    'import': (() => import('./langs/mdc.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'mdx',
    'name': 'MDX',
    'import': (() => import('./langs/mdx.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'mermaid',
    'name': 'Mermaid',
    'aliases': [
      'mmd'
    ],
    'import': (() => import('./langs/mermaid.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'mipsasm',
    'name': 'MIPS Assembly',
    'aliases': [
      'mips'
    ],
    'import': (() => import('./langs/mipsasm.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'mojo',
    'name': 'Mojo',
    'import': (() => import('./langs/mojo.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'move',
    'name': 'Move',
    'import': (() => import('./langs/move.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'narrat',
    'name': 'Narrat Language',
    'aliases': [
      'nar'
    ],
    'import': (() => import('./langs/narrat.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'nextflow',
    'name': 'Nextflow',
    'aliases': [
      'nf'
    ],
    'import': (() => import('./langs/nextflow.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'nginx',
    'name': 'Nginx',
    'import': (() => import('./langs/nginx.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'nim',
    'name': 'Nim',
    'import': (() => import('./langs/nim.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'nix',
    'name': 'Nix',
    'import': (() => import('./langs/nix.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'nushell',
    'name': 'nushell',
    'aliases': [
      'nu'
    ],
    'import': (() => import('./langs/nushell.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'objective-c',
    'name': 'Objective-C',
    'aliases': [
      'objc'
    ],
    'import': (() => import('./langs/objective-c.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'objective-cpp',
    'name': 'Objective-C++',
    'import': (() => import('./langs/objective-cpp.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'ocaml',
    'name': 'OCaml',
    'import': (() => import('./langs/ocaml.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'pascal',
    'name': 'Pascal',
    'import': (() => import('./langs/pascal.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'perl',
    'name': 'Perl',
    'import': (() => import('./langs/perl.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'php',
    'name': 'PHP',
    'import': (() => import('./langs/php.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'plsql',
    'name': 'PL/SQL',
    'import': (() => import('./langs/plsql.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'po',
    'name': 'Gettext PO',
    'aliases': [
      'pot',
      'potx'
    ],
    'import': (() => import('./langs/po.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'postcss',
    'name': 'PostCSS',
    'import': (() => import('./langs/postcss.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'powerquery',
    'name': 'PowerQuery',
    'import': (() => import('./langs/powerquery.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'powershell',
    'name': 'PowerShell',
    'aliases': [
      'ps',
      'ps1'
    ],
    'import': (() => import('./langs/powershell.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'prisma',
    'name': 'Prisma',
    'import': (() => import('./langs/prisma.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'prolog',
    'name': 'Prolog',
    'import': (() => import('./langs/prolog.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'proto',
    'name': 'Protocol Buffer 3',
    'aliases': [
      'protobuf'
    ],
    'import': (() => import('./langs/proto.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'pug',
    'name': 'Pug',
    'aliases': [
      'jade'
    ],
    'import': (() => import('./langs/pug.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'puppet',
    'name': 'Puppet',
    'import': (() => import('./langs/puppet.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'purescript',
    'name': 'PureScript',
    'import': (() => import('./langs/purescript.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'python',
    'name': 'Python',
    'aliases': [
      'py'
    ],
    'import': (() => import('./langs/python.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'qml',
    'name': 'QML',
    'import': (() => import('./langs/qml.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'qmldir',
    'name': 'QML Directory',
    'import': (() => import('./langs/qmldir.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'qss',
    'name': 'Qt Style Sheets',
    'import': (() => import('./langs/qss.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'r',
    'name': 'R',
    'import': (() => import('./langs/r.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'racket',
    'name': 'Racket',
    'import': (() => import('./langs/racket.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'raku',
    'name': 'Raku',
    'aliases': [
      'perl6'
    ],
    'import': (() => import('./langs/raku.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'razor',
    'name': 'ASP.NET Razor',
    'import': (() => import('./langs/razor.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'reg',
    'name': 'Windows Registry Script',
    'import': (() => import('./langs/reg.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'regexp',
    'name': 'RegExp',
    'aliases': [
      'regex'
    ],
    'import': (() => import('./langs/regexp.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'rel',
    'name': 'Rel',
    'import': (() => import('./langs/rel.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'riscv',
    'name': 'RISC-V',
    'import': (() => import('./langs/riscv.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'rst',
    'name': 'reStructuredText',
    'import': (() => import('./langs/rst.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'ruby',
    'name': 'Ruby',
    'aliases': [
      'rb'
    ],
    'import': (() => import('./langs/ruby.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'rust',
    'name': 'Rust',
    'aliases': [
      'rs'
    ],
    'import': (() => import('./langs/rust.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'sas',
    'name': 'SAS',
    'import': (() => import('./langs/sas.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'sass',
    'name': 'Sass',
    'import': (() => import('./langs/sass.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'scala',
    'name': 'Scala',
    'import': (() => import('./langs/scala.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'scheme',
    'name': 'Scheme',
    'import': (() => import('./langs/scheme.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'scss',
    'name': 'SCSS',
    'import': (() => import('./langs/scss.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'shaderlab',
    'name': 'ShaderLab',
    'aliases': [
      'shader'
    ],
    'import': (() => import('./langs/shaderlab.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'shellscript',
    'name': 'Shell',
    'aliases': [
      'bash',
      'sh',
      'shell',
      'zsh'
    ],
    'import': (() => import('./langs/shellscript.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'shellsession',
    'name': 'Shell Session',
    'aliases': [
      'console'
    ],
    'import': (() => import('./langs/shellsession.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'smalltalk',
    'name': 'Smalltalk',
    'import': (() => import('./langs/smalltalk.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'solidity',
    'name': 'Solidity',
    'import': (() => import('./langs/solidity.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'soy',
    'name': 'Closure Templates',
    'aliases': [
      'closure-templates'
    ],
    'import': (() => import('./langs/soy.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'sparql',
    'name': 'SPARQL',
    'import': (() => import('./langs/sparql.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'splunk',
    'name': 'Splunk Query Language',
    'aliases': [
      'spl'
    ],
    'import': (() => import('./langs/splunk.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'sql',
    'name': 'SQL',
    'import': (() => import('./langs/sql.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'ssh-config',
    'name': 'SSH Config',
    'import': (() => import('./langs/ssh-config.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'stata',
    'name': 'Stata',
    'import': (() => import('./langs/stata.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'stylus',
    'name': 'Stylus',
    'aliases': [
      'styl'
    ],
    'import': (() => import('./langs/stylus.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'svelte',
    'name': 'Svelte',
    'import': (() => import('./langs/svelte.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'swift',
    'name': 'Swift',
    'import': (() => import('./langs/swift.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'system-verilog',
    'name': 'SystemVerilog',
    'import': (() => import('./langs/system-verilog.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'systemd',
    'name': 'Systemd Units',
    'import': (() => import('./langs/systemd.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'tasl',
    'name': 'Tasl',
    'import': (() => import('./langs/tasl.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'tcl',
    'name': 'Tcl',
    'import': (() => import('./langs/tcl.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'templ',
    'name': 'Templ',
    'import': (() => import('./langs/templ.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'terraform',
    'name': 'Terraform',
    'aliases': [
      'tf',
      'tfvars'
    ],
    'import': (() => import('./langs/terraform.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'tex',
    'name': 'TeX',
    'import': (() => import('./langs/tex.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'toml',
    'name': 'TOML',
    'import': (() => import('./langs/toml.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'ts-tags',
    'name': 'TypeScript with Tags',
    'aliases': [
      'lit'
    ],
    'import': (() => import('./langs/ts-tags.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'tsv',
    'name': 'TSV',
    'import': (() => import('./langs/tsv.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'tsx',
    'name': 'TSX',
    'import': (() => import('./langs/tsx.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'turtle',
    'name': 'Turtle',
    'import': (() => import('./langs/turtle.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'twig',
    'name': 'Twig',
    'import': (() => import('./langs/twig.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'typescript',
    'name': 'TypeScript',
    'aliases': [
      'ts'
    ],
    'import': (() => import('./langs/typescript.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'typespec',
    'name': 'TypeSpec',
    'aliases': [
      'tsp'
    ],
    'import': (() => import('./langs/typespec.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'typst',
    'name': 'Typst',
    'aliases': [
      'typ'
    ],
    'import': (() => import('./langs/typst.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'v',
    'name': 'V',
    'import': (() => import('./langs/v.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'vala',
    'name': 'Vala',
    'import': (() => import('./langs/vala.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'vb',
    'name': 'Visual Basic',
    'aliases': [
      'cmd'
    ],
    'import': (() => import('./langs/vb.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'verilog',
    'name': 'Verilog',
    'import': (() => import('./langs/verilog.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'vhdl',
    'name': 'VHDL',
    'import': (() => import('./langs/vhdl.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'viml',
    'name': 'Vim Script',
    'aliases': [
      'vim',
      'vimscript'
    ],
    'import': (() => import('./langs/viml.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'vue',
    'name': 'Vue',
    'import': (() => import('./langs/vue.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'vue-html',
    'name': 'Vue HTML',
    'import': (() => import('./langs/vue-html.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'vyper',
    'name': 'Vyper',
    'aliases': [
      'vy'
    ],
    'import': (() => import('./langs/vyper.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'wasm',
    'name': 'WebAssembly',
    'import': (() => import('./langs/wasm.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'wenyan',
    'name': 'Wenyan',
    'aliases': [
      '文言'
    ],
    'import': (() => import('./langs/wenyan.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'wgsl',
    'name': 'WGSL',
    'import': (() => import('./langs/wgsl.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'wikitext',
    'name': 'Wikitext',
    'aliases': [
      'mediawiki',
      'wiki'
    ],
    'import': (() => import('./langs/wikitext.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'wolfram',
    'name': 'Wolfram',
    'aliases': [
      'wl'
    ],
    'import': (() => import('./langs/wolfram.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'xml',
    'name': 'XML',
    'import': (() => import('./langs/xml.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'xsl',
    'name': 'XSL',
    'import': (() => import('./langs/xsl.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'yaml',
    'name': 'YAML',
    'aliases': [
      'yml'
    ],
    'import': (() => import('./langs/yaml.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'zenscript',
    'name': 'ZenScript',
    'import': (() => import('./langs/zenscript.mjs')) as DynamicImportLanguageRegistration
  },
  {
    'id': 'zig',
    'name': 'Zig',
    'import': (() => import('./langs/zig.mjs')) as DynamicImportLanguageRegistration
  }
]

export const bundledLanguagesBase = Object.fromEntries(bundledLanguagesInfo.map(i => [i.id, i.import]))

export const bundledLanguagesAlias = Object.fromEntries(bundledLanguagesInfo.flatMap(i => i.aliases?.map(a => [a, i.import]) || []))

export type BundledLanguage =
  | 'abap'
  | 'actionscript-3'
  | 'ada'
  | 'adoc'
  | 'angular-html'
  | 'angular-ts'
  | 'apache'
  | 'apex'
  | 'apl'
  | 'applescript'
  | 'ara'
  | 'asciidoc'
  | 'asm'
  | 'astro'
  | 'awk'
  | 'ballerina'
  | 'bash'
  | 'bat'
  | 'batch'
  | 'be'
  | 'beancount'
  | 'berry'
  | 'bibtex'
  | 'bicep'
  | 'blade'
  | 'c'
  | 'c#'
  | 'c++'
  | 'cadence'
  | 'cairo'
  | 'cdc'
  | 'clarity'
  | 'clj'
  | 'clojure'
  | 'closure-templates'
  | 'cmake'
  | 'cmd'
  | 'cobol'
  | 'codeowners'
  | 'codeql'
  | 'coffee'
  | 'coffeescript'
  | 'common-lisp'
  | 'console'
  | 'coq'
  | 'cpp'
  | 'cql'
  | 'crystal'
  | 'cs'
  | 'csharp'
  | 'css'
  | 'csv'
  | 'cue'
  | 'cypher'
  | 'd'
  | 'dart'
  | 'dax'
  | 'desktop'
  | 'diff'
  | 'docker'
  | 'dockerfile'
  | 'dotenv'
  | 'dream-maker'
  | 'edge'
  | 'elisp'
  | 'elixir'
  | 'elm'
  | 'emacs-lisp'
  | 'erb'
  | 'erl'
  | 'erlang'
  | 'f'
  | 'f#'
  | 'f03'
  | 'f08'
  | 'f18'
  | 'f77'
  | 'f90'
  | 'f95'
  | 'fennel'
  | 'fish'
  | 'fluent'
  | 'for'
  | 'fortran-fixed-form'
  | 'fortran-free-form'
  | 'fs'
  | 'fsharp'
  | 'fsl'
  | 'ftl'
  | 'gdresource'
  | 'gdscript'
  | 'gdshader'
  | 'genie'
  | 'gherkin'
  | 'git-commit'
  | 'git-rebase'
  | 'gjs'
  | 'gleam'
  | 'glimmer-js'
  | 'glimmer-ts'
  | 'glsl'
  | 'gnuplot'
  | 'go'
  | 'gql'
  | 'graphql'
  | 'groovy'
  | 'gts'
  | 'hack'
  | 'haml'
  | 'handlebars'
  | 'haskell'
  | 'haxe'
  | 'hbs'
  | 'hcl'
  | 'hjson'
  | 'hlsl'
  | 'hs'
  | 'html'
  | 'html-derivative'
  | 'http'
  | 'hxml'
  | 'hy'
  | 'imba'
  | 'ini'
  | 'jade'
  | 'java'
  | 'javascript'
  | 'jinja'
  | 'jison'
  | 'jl'
  | 'js'
  | 'json'
  | 'json5'
  | 'jsonc'
  | 'jsonl'
  | 'jsonnet'
  | 'jssm'
  | 'jsx'
  | 'julia'
  | 'kotlin'
  | 'kql'
  | 'kt'
  | 'kts'
  | 'kusto'
  | 'latex'
  | 'lean'
  | 'lean4'
  | 'less'
  | 'liquid'
  | 'lisp'
  | 'lit'
  | 'log'
  | 'logo'
  | 'lua'
  | 'luau'
  | 'make'
  | 'makefile'
  | 'markdown'
  | 'marko'
  | 'matlab'
  | 'md'
  | 'mdc'
  | 'mdx'
  | 'mediawiki'
  | 'mermaid'
  | 'mips'
  | 'mipsasm'
  | 'mmd'
  | 'mojo'
  | 'move'
  | 'nar'
  | 'narrat'
  | 'nextflow'
  | 'nf'
  | 'nginx'
  | 'nim'
  | 'nix'
  | 'nu'
  | 'nushell'
  | 'objc'
  | 'objective-c'
  | 'objective-cpp'
  | 'ocaml'
  | 'pascal'
  | 'perl'
  | 'perl6'
  | 'php'
  | 'plsql'
  | 'po'
  | 'postcss'
  | 'pot'
  | 'potx'
  | 'powerquery'
  | 'powershell'
  | 'prisma'
  | 'prolog'
  | 'properties'
  | 'proto'
  | 'protobuf'
  | 'ps'
  | 'ps1'
  | 'pug'
  | 'puppet'
  | 'purescript'
  | 'py'
  | 'python'
  | 'ql'
  | 'qml'
  | 'qmldir'
  | 'qss'
  | 'r'
  | 'racket'
  | 'raku'
  | 'razor'
  | 'rb'
  | 'reg'
  | 'regex'
  | 'regexp'
  | 'rel'
  | 'riscv'
  | 'rs'
  | 'rst'
  | 'ruby'
  | 'rust'
  | 'sas'
  | 'sass'
  | 'scala'
  | 'scheme'
  | 'scss'
  | 'sh'
  | 'shader'
  | 'shaderlab'
  | 'shell'
  | 'shellscript'
  | 'shellsession'
  | 'smalltalk'
  | 'solidity'
  | 'soy'
  | 'sparql'
  | 'spl'
  | 'splunk'
  | 'sql'
  | 'ssh-config'
  | 'stata'
  | 'styl'
  | 'stylus'
  | 'svelte'
  | 'swift'
  | 'system-verilog'
  | 'systemd'
  | 'tasl'
  | 'tcl'
  | 'templ'
  | 'terraform'
  | 'tex'
  | 'tf'
  | 'tfvars'
  | 'toml'
  | 'ts'
  | 'ts-tags'
  | 'tsp'
  | 'tsv'
  | 'tsx'
  | 'turtle'
  | 'twig'
  | 'typ'
  | 'typescript'
  | 'typespec'
  | 'typst'
  | 'v'
  | 'vala'
  | 'vb'
  | 'verilog'
  | 'vhdl'
  | 'vim'
  | 'viml'
  | 'vimscript'
  | 'vue'
  | 'vue-html'
  | 'vy'
  | 'vyper'
  | 'wasm'
  | 'wenyan'
  | 'wgsl'
  | 'wiki'
  | 'wikitext'
  | 'wl'
  | 'wolfram'
  | 'xml'
  | 'xsl'
  | 'yaml'
  | 'yml'
  | 'zenscript'
  | 'zig'
  | 'zsh'
  | '文言'

export const bundledLanguages = {
  ...bundledLanguagesBase,
  ...bundledLanguagesAlias,
} as Record<BundledLanguage, DynamicImportLanguageRegistration>
