import fs from 'fs-extra'
import { themes as allThemes } from 'tm-themes'

async function main() {
  // if a theme doesn't define bracket colors, it falls back to these
  // from vscode /src/vs/editor/common/core/editorColorRegistry.ts
  const vsCodeBaseThemes: Record<string, Record<string, string>> = {
    light: {
      'editorBracketHighlight.foreground1': '#0431FA',
      'editorBracketHighlight.foreground2': '#319331',
      'editorBracketHighlight.foreground3': '#7B3814',
      'editorBracketHighlight.unexpectedBracket.foreground':
        'rgba(255, 18, 18, 0.8)',
    },
    dark: {
      'editorBracketHighlight.foreground1': '#FFD700',
      'editorBracketHighlight.foreground2': '#DA70D6',
      'editorBracketHighlight.foreground3': '#179FFF',
      'editorBracketHighlight.unexpectedBracket.foreground':
        'rgba(255, 18, 18, 0.8)',
    },
    lightHighContrast: {
      'editorBracketHighlight.foreground1': '#0431FA',
      'editorBracketHighlight.foreground2': '#319331',
      'editorBracketHighlight.foreground3': '#7B3814',
      'editorBracketHighlight.unexpectedBracket.foreground': '#B5200D',
    },
    darkHighContrast: {
      'editorBracketHighlight.foreground1': '#FFD700',
      'editorBracketHighlight.foreground2': '#DA70D6',
      'editorBracketHighlight.foreground3': '#87CEFA',
      'editorBracketHighlight.unexpectedBracket.foreground':
        'rgba(255, 50, 50, 1)',
    },
  }

  const themes: Record<string, string[]> = {}
  for (const t of allThemes) {
    const theme = await fs.readJSON(`./node_modules/shiki/node_modules/tm-themes/themes/${t.name}.json`)
    const isHighContrast = t.name.includes('high-contrast')
    const themeType = theme.type ?? 'dark'
    const baseTheme = isHighContrast ? `${themeType}HighContrast` : themeType
    const colors: Record<string, string> = {
      ...vsCodeBaseThemes[baseTheme],
      ...theme.colors,
    }
    const bracketTheme = [
      colors['editorBracketHighlight.foreground1'],
      colors['editorBracketHighlight.foreground2'],
      colors['editorBracketHighlight.foreground3'],
      colors['editorBracketHighlight.foreground4'],
      colors['editorBracketHighlight.foreground5'],
      colors['editorBracketHighlight.foreground6'],
      colors['editorBracketHighlight.unexpectedBracket.foreground'],
    ].filter(Boolean)
    themes[t.name] = bracketTheme
  }

  const sorted = Object.fromEntries(
    Object.entries(themes).sort((a, b) => a[0].localeCompare(b[0])),
  )

  await fs.writeFile(
    './src/themes.ts',
    `// Generated by scripts/prepare.ts
export default ${JSON.stringify(sorted, undefined, 2)} as Record<string, string[]>
`,
    { encoding: 'utf-8' },
  )
}

main()
