import shortid from 'shortid'
import siteConf from '../config/site'

export const log = siteConf.dev ? console.log.bind(console) : () => { }

// 校验合法ID
export const checkCurrentId = (ids) => {
  if (!ids) return false
  let idState = true
  const idsArr = ids.split(',')
  if (typeof idsArr === 'object' && idsArr.length > 0) {
    for (let i = 0; i < idsArr.length; i++) {
      if (!shortid.isValid(idsArr[i])) {
        idState = false
        break
      }
    }
  } else {
    idState = false
  }
  return idState
}

// 封装api返回的数据
export const renderApiData = (req, res, responseCode, responseMessage, data = {}) => {
  const sendData = {
    status: responseCode,
    success: true,
    message: responseMessage,
    request_time: (new Date()).getTime(),
    data
  }
  return sendData
}

// 封装api返回的错误数据
export const renderApiErr = (req, res, responseCode, responseMessage) => {
  if (typeof responseMessage === 'object') {
    responseMessage = siteConf.dev ? responseMessage : '悲哀！未知错误'
  }

  // 如果是生产模式，不返回具体的报错信息
  const errorData = {
    status: responseCode,
    success: false,
    message: responseMessage,
    request_time: (new Date()).getTime(),
    data: {}
  }

  return errorData
}

// 数组转树形结构
export const arrayToTree = (arr) => {
  if (arr.length < 2) return arr

  const result = arr.filter((ele) => {
    return ele.parent_id === '0'
  })
  const subArr = arr.filter((ele) => {
    return ele.parent_id !== '0'
  })

  result.forEach(obj1 => {
    obj1.children = []
    subArr.forEach(obj2 => {
      if (obj2.parent_id === obj1._id) {
        obj1.children.push(obj2)
      }
    })
  })

  return result
}

// 返回客户端IP地址
export const getClientIp = (req) => {
  return req.headers['x-forwarded-for'] ||
    req.connection.remoteAddress ||
    req.socket.remoteAddress ||
    req.connection.socket.remoteAddress || ''
}

// 接口中间件 判断是否是登陆状态
export const checkUserSession = (req, res, next) => {
  if (req.session.userLogined && req.session.userInfo.id) {
    next()
  } else {
    res.status(401).send(renderApiErr(req, res, 401, '用户未登陆，授权失败'))
  }
}
