---
id: inputs
title: Inputs
sidebar_label: Inputs
---

| Name                     | Type              | Default Value                                                      | Description                                                                                                                                                                                                                                                          |
| ------------------------ | ----------------- | ------------------------------------------------------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| domain                   | `Array`           | `null`                                                             | For example `['admin', 'portal.com']`                                                                                                                                                                                                                                |
| bucketName               | `string`          | `null`                                                             | Custom bucket name where static assets are stored. By default is autogenerated.                                                                                                                                                                                      |
| bucketRegion             | `string`          | `us-east-1`                                                        | Region where you want to host your s3 bucket. Make sure this is geographically closer to the majority of your end users to reduce latency when CloudFront proxies a request to S3.                                                                                   |
| nextConfigDir            | `string`          | `./`                                                               | Directory where your application `next.config.js` file is. This input is useful when the `serverless.yml` is not in the same directory as the next app. **Note:** `nextConfigDir` should be set if `next.config.js` `distDir` is used                                |
| nextStaticDir            | `string`          | `./`                                                               | If your `static` or `public` directory is not a direct child of `nextConfigDir` this is needed                                                                                                                                                                       |
| description              | `string`          | `*lambda-type*@Edge for Next CloudFront distribution`              | The description that will be used for both lambdas. Note that "(API)" will be appended to the API lambda description.                                                                                                                                                |
| policy                   | `string`          | `arn:aws:iam::aws:policy/service-role/AWSLambdaBasicExecutionRole` | The arn policy that will be assigned to both lambdas.                                                                                                                                                                                                                |
| runtime                  | `string\|object`  | `nodejs12.x`                                                       | When assigned a value, both the default and api lambdas will be assigned the runtime defined in the value. When assigned to an object, values for the default and api lambdas can be separately defined                                                              |  |
| memory                   | `number\|object`  | `512`                                                              | When assigned a number, both the default and api lambdas will be assigned memory of that value. When assigned to an object, values for the default and api lambdas can be separately defined                                                                         |  |
| timeout                  | `number\|object`  | `10`                                                               | Same as above                                                                                                                                                                                                                                                        |
| handler                  | `string`          | `index.handler`                                                    | When assigned a value, overrides the default function handler to allow for configuration. Copies `handler.js` in route into the Lambda folders. Your handler MUST still call the `default-handler` afterwards or your function won't work with Next.JS               |
| name                     | `string\|object`  | /                                                                  | When assigned a string, both the default and api lambdas will assigned name of that value. When assigned to an object, values for the default and api lambdas can be separately defined                                                                              |
| build                    | `boolean\|object` | `true`                                                             | When true builds and deploys app, when false assume the app has been built and uses the `.next` `.serverless_nextjs` directories in `nextConfigDir` to deploy. If an object is passed `build` allows for overriding what script gets called and with what arguments. |
| build.cmd                | `string`          | `node_modules/.bin/next`                                           | Build command                                                                                                                                                                                                                                                        |
| build.args               | `Array\|string`   | `['build']`                                                        | Arguments to pass to the build                                                                                                                                                                                                                                       |
| build.cwd                | `string`          | `./`                                                               | Override the current working directory                                                                                                                                                                                                                               |
| build.enabled            | `boolean`         | `true`                                                             | Same as passing `build:false` but from within the config                                                                                                                                                                                                             |
| build.env                | `object`          | `{}`                                                               | Add additional environment variables to the script                                                                                                                                                                                                                   |
| cloudfront               | `object`          | `{}`                                                               | Inputs to be passed to [aws-cloudfront](https://github.com/serverless-components/aws-cloudfront)                                                                                                                                                                     |
| domainType               | `string`          | `"both"`                                                           | Can be one of: `"apex"` - apex domain only, don't create a www subdomain. `"www"` - www domain only, don't create an apex subdomain.`"both"` - create both www and apex domains when either one is provided.                                                         |
| publicDirectoryCache     | `boolean\|object` | `true`                                                             | Customize the `public`/`static` folder asset caching policy. Assigning an object with `value` and/or `test` lets you customize the caching policy and the types of files being cached. Assigning false disables caching                                              |
| useServerlessTraceTarget | `boolean`         | `false`                                                            | Use the experimental-serverless-trace target to build your next app. This is the same build target that Vercel Now uses. See this [RFC](https://github.com/vercel/next.js/pull/8246) for details.                                                                    |
| verbose                  | `boolean`         | `false`                                                            | Print verbose output to the console.                                                                                                                                                                                                                                 |

Custom inputs can be configured like this:

```yaml
myNextApp:
  component: serverless-next.js
  inputs:
    bucketName: my-bucket
```
