using Newtonsoft.Json;

namespace TxtAI.NET;

public class Textractor
{
    private readonly HttpClient _client;

    public Textractor(string baseUrl, int timeout = 120, string token = null)
    {
        _client = Api.Create<HttpClient>(baseUrl, timeout, token);
    }

    public async Task<string> TextractAsync(string file)
    {
        var response = await _client.GetAsync($"textract?file={file}");

        if (!response.IsSuccessStatusCode)
            throw new Exception(await response.Content.ReadAsStringAsync());

        return await response.Content.ReadAsStringAsync();
    }

    public async Task<List<string>> BatchTextractAsync(List<string> files)
    {
        var payload = new { files };

        var response = await _client.PostAsJsonAsync("batchtextract", payload);

        if (!response.IsSuccessStatusCode)
            throw new Exception(await response.Content.ReadAsStringAsync());

        return JsonConvert.DeserializeObject<List<string>>(await response.Content.ReadAsStringAsync());
    }
}