/*
Copyright 2007-2011 Selenium committers

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 */

package  io.selendroid.webviewdrivertests.touch;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoMoreInteractions;
import static org.mockito.Mockito.verifyZeroInteractions;
import static org.mockito.Mockito.when;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.openqa.selenium.interactions.TouchScreen;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.interactions.touch.LongPressAction;
import org.openqa.selenium.internal.Locatable;

/**
 * Tests the long press action.
 */
public class TouchLongPressTest {

  @Mock private TouchScreen mockTouch;
  @Mock private Coordinates mockCoordinates;
  @Mock private Locatable locatableStub;

  @Before
  public void setUp() {
    MockitoAnnotations.initMocks(this);
    when(locatableStub.getCoordinates()).thenReturn(mockCoordinates);
  }

  @Test
  public void testCanLongPress() {
    LongPressAction longPress = new LongPressAction(mockTouch, locatableStub);
    longPress.perform();

    verify(mockTouch).longPress(mockCoordinates);
    verifyNoMoreInteractions(mockTouch);
    verifyZeroInteractions(mockCoordinates);
  }
}
