/*
 * Copyright 2014 eBay Software Foundation and selendroid committers.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package io.selendroid.driver;

import io.selendroid.support.BaseAndroidTest;
import io.selendroid.webviewdrivertests.HtmlTestData;

import org.junit.Assert;
import org.junit.Test;
import org.openqa.selenium.ScreenOrientation;

public class OrientationTest extends BaseAndroidTest {
  @Test
  public void shouldRotate() throws Exception {
    openWebdriverTestPage(HtmlTestData.ABOUT_BLANK);
    Assert.assertEquals(ScreenOrientation.PORTRAIT, driver().getOrientation());
    driver().rotate(ScreenOrientation.LANDSCAPE);
    Assert.assertEquals(ScreenOrientation.LANDSCAPE, driver().getOrientation());
    driver().rotate(ScreenOrientation.PORTRAIT);
    Assert.assertEquals(ScreenOrientation.PORTRAIT, driver().getOrientation());
  }
}
