/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.runner.intent;

import android.os.Looper;
import android.support.test.internal.util.Checks;
import android.support.test.runner.intent.IntentStubber;
import java.util.concurrent.atomic.AtomicBoolean;

public final class IntentStubberRegistry {
    private static IntentStubber mInstance;
    private static AtomicBoolean mIsLoaded;

    public static void load(IntentStubber intentStubber) {
        Checks.checkNotNull(intentStubber, "IntentStubber cannot be null!");
        Checks.checkState(!mIsLoaded.getAndSet(true), "Intent stubber already registered! Multiple stubbers are notallowedAre you running under an ");
        mInstance = intentStubber;
    }

    public static boolean isLoaded() {
        return mIsLoaded.get();
    }

    public static IntentStubber getInstance() {
        IntentStubberRegistry.checkMain();
        Checks.checkState(null != mInstance, "No intent monitor registered! Are you running under an Instrumentation which registers intent monitors?");
        return mInstance;
    }

    private static void checkMain() {
        Checks.checkState(Looper.myLooper() == Looper.getMainLooper(), "Must be called on main thread.");
    }

    private IntentStubberRegistry() {
    }

    public static synchronized void reset() {
        mInstance = null;
        mIsLoaded.set(false);
    }

    static {
        mIsLoaded = new AtomicBoolean();
    }
}

