/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.engine;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.webkit.WebSettings;
import android.webkit.WebView;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.cordova.CordovaBridge;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.CordovaWebViewEngine;
import org.apache.cordova.ICordovaCookieManager;
import org.apache.cordova.NativeToJsMessageQueue;
import org.apache.cordova.PluginManager;
import org.apache.cordova.engine.SystemCookieManager;
import org.apache.cordova.engine.SystemExposedJsApi;
import org.apache.cordova.engine.SystemWebView;

public class SystemWebViewEngine
implements CordovaWebViewEngine {
    public static final String TAG = "SystemWebViewEngine";
    protected final SystemWebView webView;
    protected final SystemCookieManager cookieManager;
    protected CordovaBridge bridge;
    protected CordovaWebViewEngine.Client client;
    protected CordovaWebView parentWebView;
    protected CordovaInterface cordova;
    protected PluginManager pluginManager;
    protected CordovaResourceApi resourceApi;
    protected NativeToJsMessageQueue nativeToJsMessageQueue;
    private BroadcastReceiver receiver;

    public SystemWebViewEngine(Context context, CordovaPreferences preferences) {
        this(new SystemWebView(context));
    }

    public SystemWebViewEngine(SystemWebView webView) {
        this.webView = webView;
        this.cookieManager = new SystemCookieManager(webView);
    }

    public void init(CordovaWebView parentWebView, CordovaInterface cordova, CordovaWebViewEngine.Client client, CordovaResourceApi resourceApi, PluginManager pluginManager, NativeToJsMessageQueue nativeToJsMessageQueue) {
        if (this.cordova != null) {
            throw new IllegalStateException();
        }
        this.parentWebView = parentWebView;
        this.cordova = cordova;
        this.client = client;
        this.resourceApi = resourceApi;
        this.pluginManager = pluginManager;
        this.nativeToJsMessageQueue = nativeToJsMessageQueue;
        this.webView.init(this, cordova);
        this.initWebViewSettings();
        nativeToJsMessageQueue.addBridgeMode(new NativeToJsMessageQueue.OnlineEventsBridgeMode(new NativeToJsMessageQueue.OnlineEventsBridgeMode.OnlineEventsBridgeModeDelegate(){

            public void setNetworkAvailable(boolean value) {
                SystemWebViewEngine.this.webView.setNetworkAvailable(value);
            }

            public void runOnUiThread(Runnable r) {
                SystemWebViewEngine.this.cordova.getActivity().runOnUiThread(r);
            }
        }));
        this.bridge = new CordovaBridge(pluginManager, nativeToJsMessageQueue);
        SystemWebViewEngine.exposeJsInterface(this.webView, this.bridge);
    }

    public CordovaWebView getCordovaWebView() {
        return this.parentWebView;
    }

    public ICordovaCookieManager getCookieManager() {
        return this.cookieManager;
    }

    public View getView() {
        return this.webView;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebViewSettings() {
        this.webView.setInitialScale(0);
        this.webView.setVerticalScrollBarEnabled(false);
        final WebSettings settings = this.webView.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        try {
            Method gingerbread_getMethod = WebSettings.class.getMethod("setNavDump", Boolean.TYPE);
            String manufacturer = Build.MANUFACTURER;
            Log.d((String)TAG, (String)("CordovaWebView is running on device made by: " + manufacturer));
            if (Build.VERSION.SDK_INT < 11 && Build.MANUFACTURER.contains("HTC")) {
                gingerbread_getMethod.invoke((Object)settings, true);
            }
        }
        catch (NoSuchMethodException e) {
            Log.d((String)TAG, (String)"We are on a modern version of Android, we will deprecate HTC 2.3 devices in 2.8");
        }
        catch (IllegalArgumentException e) {
            Log.d((String)TAG, (String)"Doing the NavDump failed with bad arguments");
        }
        catch (IllegalAccessException e) {
            Log.d((String)TAG, (String)"This should never happen: IllegalAccessException means this isn't Android anymore");
        }
        catch (InvocationTargetException e) {
            Log.d((String)TAG, (String)"This should never happen: InvocationTargetException means this isn't Android anymore.");
        }
        settings.setSaveFormData(false);
        settings.setSavePassword(false);
        if (Build.VERSION.SDK_INT >= 16) {
            settings.setAllowUniversalAccessFromFileURLs(true);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            settings.setMediaPlaybackRequiresUserGesture(false);
        }
        String databasePath = this.webView.getContext().getApplicationContext().getDir("database", 0).getPath();
        settings.setDatabaseEnabled(true);
        settings.setDatabasePath(databasePath);
        ApplicationInfo appInfo = this.webView.getContext().getApplicationContext().getApplicationInfo();
        if ((appInfo.flags & 2) != 0 && Build.VERSION.SDK_INT >= 19) {
            this.enableRemoteDebugging();
        }
        settings.setGeolocationDatabasePath(databasePath);
        settings.setDomStorageEnabled(true);
        settings.setGeolocationEnabled(true);
        settings.setAppCacheMaxSize(0x500000L);
        settings.setAppCachePath(databasePath);
        settings.setAppCacheEnabled(true);
        settings.getUserAgentString();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        if (this.receiver == null) {
            this.receiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    settings.getUserAgentString();
                }
            };
            this.webView.getContext().registerReceiver(this.receiver, intentFilter);
        }
    }

    @TargetApi(value=19)
    private void enableRemoteDebugging() {
        try {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        catch (IllegalArgumentException e) {
            Log.d((String)TAG, (String)"You have one job! To turn on Remote Web Debugging! YOU HAVE FAILED! ");
            e.printStackTrace();
        }
    }

    private static void exposeJsInterface(WebView webView, CordovaBridge bridge) {
        if (Build.VERSION.SDK_INT < 17) {
            Log.i((String)TAG, (String)"Disabled addJavascriptInterface() bridge since Android version is old.");
            return;
        }
        SystemExposedJsApi exposedJsApi = new SystemExposedJsApi(bridge);
        webView.addJavascriptInterface((Object)exposedJsApi, "_cordovaNative");
    }

    public void loadUrl(String url, boolean clearNavigationStack) {
        this.webView.loadUrl(url);
    }

    public String getUrl() {
        return this.webView.getUrl();
    }

    public void stopLoading() {
        this.webView.stopLoading();
    }

    public void clearCache() {
        this.webView.clearCache(true);
    }

    public void clearHistory() {
        this.webView.clearHistory();
    }

    public boolean canGoBack() {
        return this.webView.canGoBack();
    }

    public boolean goBack() {
        if (this.webView.canGoBack()) {
            this.webView.goBack();
            return true;
        }
        return false;
    }

    public void setPaused(boolean value) {
        if (value) {
            this.webView.pauseTimers();
        } else {
            this.webView.resumeTimers();
        }
    }

    public void destroy() {
        this.webView.chromeClient.destroyLastDialog();
        this.webView.destroy();
        if (this.receiver != null) {
            try {
                this.webView.getContext().unregisterReceiver(this.receiver);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Error unregistering configuration receiver: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

