/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.app.Activity;
import android.os.Bundle;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.cordova.LOG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CordovaPreferences {
    private HashMap<String, String> prefs = new HashMap(20);
    private Bundle preferencesBundleExtras;

    public void setPreferencesBundle(Bundle extras) {
        this.preferencesBundleExtras = extras;
    }

    public void set(String name, String value) {
        this.prefs.put(name.toLowerCase(Locale.ENGLISH), value);
    }

    public void set(String name, boolean value) {
        this.set(name, "" + value);
    }

    public void set(String name, int value) {
        this.set(name, "" + value);
    }

    public void set(String name, double value) {
        this.set(name, "" + value);
    }

    public Map<String, String> getAll() {
        return this.prefs;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.prefs.get(name = name.toLowerCase(Locale.ENGLISH));
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        if (this.preferencesBundleExtras != null) {
            Object bundleValue = this.preferencesBundleExtras.get(name);
            if (bundleValue instanceof String) {
                return "true".equals(bundleValue);
            }
            return this.preferencesBundleExtras.getBoolean(name, defaultValue);
        }
        return defaultValue;
    }

    public boolean contains(String name) {
        return this.getString(name, null) != null;
    }

    public int getInteger(String name, int defaultValue) {
        String value = this.prefs.get(name = name.toLowerCase(Locale.ENGLISH));
        if (value != null) {
            return (int)Long.decode(value).longValue();
        }
        if (this.preferencesBundleExtras != null) {
            Object bundleValue = this.preferencesBundleExtras.get(name);
            if (bundleValue instanceof String) {
                return Integer.valueOf((String)bundleValue);
            }
            return this.preferencesBundleExtras.getInt(name, defaultValue);
        }
        return defaultValue;
    }

    public double getDouble(String name, double defaultValue) {
        String value = this.prefs.get(name = name.toLowerCase(Locale.ENGLISH));
        if (value != null) {
            return Double.valueOf(value);
        }
        if (this.preferencesBundleExtras != null) {
            Object bundleValue = this.preferencesBundleExtras.get(name);
            if (bundleValue instanceof String) {
                return Double.valueOf((String)bundleValue);
            }
            return this.preferencesBundleExtras.getDouble(name, defaultValue);
        }
        return defaultValue;
    }

    public String getString(String name, String defaultValue) {
        Object bundleValue;
        String value = this.prefs.get(name = name.toLowerCase(Locale.ENGLISH));
        if (value != null) {
            return value;
        }
        if (this.preferencesBundleExtras != null && !"errorurl".equals(name) && (bundleValue = this.preferencesBundleExtras.get(name)) != null) {
            return bundleValue.toString();
        }
        return defaultValue;
    }

    public void copyIntoIntentExtras(Activity action) {
        for (String name : this.prefs.keySet()) {
            boolean asBool;
            int asInt;
            String value = this.prefs.get(name);
            if (value == null) continue;
            if (name.equals("loglevel")) {
                LOG.setLogLevel(value);
                continue;
            }
            if (name.equals("splashscreen")) {
                int resource = action.getResources().getIdentifier(value, "drawable", action.getClass().getPackage().getName());
                if (resource == 0) {
                    resource = action.getResources().getIdentifier(value, "drawable", action.getPackageName());
                }
                action.getIntent().putExtra(name, resource);
                continue;
            }
            if (name.equals("backgroundcolor")) {
                asInt = (int)Long.decode(value).longValue();
                action.getIntent().putExtra(name, asInt);
                continue;
            }
            if (name.equals("loadurltimeoutvalue")) {
                asInt = Integer.decode(value);
                action.getIntent().putExtra(name, asInt);
                continue;
            }
            if (name.equals("splashscreendelay")) {
                asInt = Integer.decode(value);
                action.getIntent().putExtra(name, asInt);
                continue;
            }
            if (name.equals("keeprunning")) {
                asBool = Boolean.parseBoolean(value);
                action.getIntent().putExtra(name, asBool);
                continue;
            }
            if (name.equals("inappbrowserstorageenabled")) {
                asBool = Boolean.parseBoolean(value);
                action.getIntent().putExtra(name, asBool);
                continue;
            }
            if (name.equals("disallowoverscroll")) {
                asBool = Boolean.parseBoolean(value);
                action.getIntent().putExtra(name, asBool);
                continue;
            }
            action.getIntent().putExtra(name, value);
        }
        if (this.preferencesBundleExtras == null) {
            this.preferencesBundleExtras = action.getIntent().getExtras();
        }
    }
}

