/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.Intent;
import android.net.Uri;
import android.os.Debug;
import android.util.Log;
import java.util.HashMap;
import java.util.List;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.ConfigXmlParser;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginEntry;
import org.apache.cordova.PluginResult;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager {
    private static String TAG = "PluginManager";
    private static final int SLOW_EXEC_WARNING_THRESHOLD = Debug.isDebuggerConnected() ? 60 : 16;
    private final HashMap<String, CordovaPlugin> pluginMap = new HashMap();
    private final HashMap<String, PluginEntry> entryMap = new HashMap();
    private final CordovaInterface ctx;
    private final CordovaWebView app;
    protected HashMap<String, List<String>> urlMap = new HashMap();

    @Deprecated
    PluginManager(CordovaWebView cordovaWebView, CordovaInterface cordova) {
        this(cordovaWebView, cordova, null);
    }

    PluginManager(CordovaWebView cordovaWebView, CordovaInterface cordova, List<PluginEntry> pluginEntries) {
        this.ctx = cordova;
        this.app = cordovaWebView;
        if (pluginEntries == null) {
            ConfigXmlParser parser = new ConfigXmlParser();
            parser.parse(this.ctx.getActivity());
            pluginEntries = parser.getPluginEntries();
        }
        this.setPluginEntries(pluginEntries);
    }

    public void setPluginEntries(List<PluginEntry> pluginEntries) {
        this.onPause(false);
        this.onDestroy();
        this.pluginMap.clear();
        this.urlMap.clear();
        for (PluginEntry entry : pluginEntries) {
            this.addService(entry);
        }
    }

    public void init() {
        LOG.d(TAG, "init()");
        this.onPause(false);
        this.onDestroy();
        this.pluginMap.clear();
        this.startupPlugins();
    }

    @Deprecated
    public void loadPlugins() {
    }

    @Deprecated
    public void clearPluginObjects() {
        this.pluginMap.clear();
    }

    @Deprecated
    public void startupPlugins() {
        for (PluginEntry entry : this.entryMap.values()) {
            if (!entry.onload) continue;
            this.getPlugin(entry.service);
        }
    }

    public void exec(String service, String action, String callbackId, String rawArgs) {
        CordovaPlugin plugin = this.getPlugin(service);
        if (plugin == null) {
            Log.d((String)TAG, (String)("exec() call to unknown plugin: " + service));
            PluginResult cr = new PluginResult(PluginResult.Status.CLASS_NOT_FOUND_EXCEPTION);
            this.app.sendPluginResult(cr, callbackId);
            return;
        }
        CallbackContext callbackContext = new CallbackContext(callbackId, this.app);
        try {
            long pluginStartTime = System.currentTimeMillis();
            boolean wasValidAction = plugin.execute(action, rawArgs, callbackContext);
            long duration = System.currentTimeMillis() - pluginStartTime;
            if (duration > (long)SLOW_EXEC_WARNING_THRESHOLD) {
                Log.w((String)TAG, (String)("THREAD WARNING: exec() call to " + service + "." + action + " blocked the main thread for " + duration + "ms. Plugin should use CordovaInterface.getThreadPool()."));
            }
            if (!wasValidAction) {
                PluginResult cr = new PluginResult(PluginResult.Status.INVALID_ACTION);
                callbackContext.sendPluginResult(cr);
            }
        }
        catch (JSONException e) {
            PluginResult cr = new PluginResult(PluginResult.Status.JSON_EXCEPTION);
            callbackContext.sendPluginResult(cr);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Uncaught exception from plugin", (Throwable)e);
            callbackContext.error(e.getMessage());
        }
    }

    @Deprecated
    public void exec(String service, String action, String callbackId, String jsonArgs, boolean async) {
        this.exec(service, action, callbackId, jsonArgs);
    }

    public CordovaPlugin getPlugin(String service) {
        CordovaPlugin ret = this.pluginMap.get(service);
        if (ret == null) {
            PluginEntry pe = this.entryMap.get(service);
            if (pe == null) {
                return null;
            }
            ret = pe.plugin != null ? pe.plugin : this.instantiatePlugin(pe.pluginClass);
            ret.privateInitialize(this.ctx, this.app, this.app.getPreferences());
            this.pluginMap.put(service, ret);
        }
        return ret;
    }

    public void addService(String service, String className) {
        PluginEntry entry = new PluginEntry(service, className, false);
        this.addService(entry);
    }

    public void addService(PluginEntry entry) {
        this.entryMap.put(entry.service, entry);
        List<String> urlFilters = entry.getUrlFilters();
        if (urlFilters != null) {
            this.urlMap.put(entry.service, urlFilters);
        }
        if (entry.plugin != null) {
            entry.plugin.privateInitialize(this.ctx, this.app, this.app.getPreferences());
            this.pluginMap.put(entry.service, entry.plugin);
        }
    }

    public void onPause(boolean multitasking) {
        for (CordovaPlugin plugin : this.pluginMap.values()) {
            plugin.onPause(multitasking);
        }
    }

    public void onResume(boolean multitasking) {
        for (CordovaPlugin plugin : this.pluginMap.values()) {
            plugin.onResume(multitasking);
        }
    }

    public void onDestroy() {
        for (CordovaPlugin plugin : this.pluginMap.values()) {
            plugin.onDestroy();
        }
    }

    public Object postMessage(String id, Object data) {
        Object obj = this.ctx.onMessage(id, data);
        if (obj != null) {
            return obj;
        }
        for (CordovaPlugin plugin : this.pluginMap.values()) {
            obj = plugin.onMessage(id, data);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public void onNewIntent(Intent intent) {
        for (CordovaPlugin plugin : this.pluginMap.values()) {
            plugin.onNewIntent(intent);
        }
    }

    public boolean onOverrideUrlLoading(String url) {
        for (PluginEntry entry : this.entryMap.values()) {
            List<String> urlFilters = this.urlMap.get(entry.service);
            if (urlFilters != null) {
                for (String s : urlFilters) {
                    if (!url.startsWith(s)) continue;
                    return this.getPlugin(entry.service).onOverrideUrlLoading(url);
                }
                continue;
            }
            CordovaPlugin plugin = this.pluginMap.get(entry.service);
            if (plugin == null || !plugin.onOverrideUrlLoading(url)) continue;
            return true;
        }
        return false;
    }

    public void onReset() {
        for (CordovaPlugin plugin : this.pluginMap.values()) {
            plugin.onReset();
        }
    }

    Uri remapUri(Uri uri) {
        for (CordovaPlugin plugin : this.pluginMap.values()) {
            Uri ret = plugin.remapUri(uri);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private CordovaPlugin instantiatePlugin(String className) {
        CordovaPlugin ret = null;
        try {
            Class<?> c = null;
            if (className != null && !"".equals(className)) {
                c = Class.forName(className);
            }
            if (c != null & CordovaPlugin.class.isAssignableFrom(c)) {
                ret = (CordovaPlugin)c.newInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error adding plugin " + className + ".");
        }
        return ret;
    }
}

