/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.TargetApi;
import android.net.Uri;
import android.os.Build;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.CordovaUriHelper;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.CordovaWebViewClient;
import org.apache.cordova.LOG;

@TargetApi(value=11)
public class IceCreamCordovaWebViewClient
extends CordovaWebViewClient {
    private static final String TAG = "IceCreamCordovaWebViewClient";
    private CordovaUriHelper helper;

    public IceCreamCordovaWebViewClient(CordovaInterface cordova) {
        super(cordova);
    }

    public IceCreamCordovaWebViewClient(CordovaInterface cordova, CordovaWebView view) {
        super(cordova, view);
    }

    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        try {
            Uri remappedUri;
            if (this.isUrlHarmful(url)) {
                LOG.w(TAG, "URL blocked by whitelist: " + url);
                return new WebResourceResponse("text/plain", "UTF-8", null);
            }
            CordovaResourceApi resourceApi = this.appView.getResourceApi();
            Uri origUri = Uri.parse((String)url);
            if (!origUri.equals((Object)(remappedUri = resourceApi.remapUri(origUri))) || IceCreamCordovaWebViewClient.needsSpecialsInAssetUrlFix(origUri) || IceCreamCordovaWebViewClient.needsKitKatContentUrlFix(origUri)) {
                CordovaResourceApi.OpenForReadResult result = resourceApi.openForRead(remappedUri, true);
                return new WebResourceResponse(result.mimeType, "UTF-8", result.inputStream);
            }
            return null;
        }
        catch (IOException e) {
            if (!(e instanceof FileNotFoundException)) {
                LOG.e(TAG, "Error occurred while loading a file (returning a 404).", e);
            }
            return new WebResourceResponse("text/plain", "UTF-8", null);
        }
    }

    private boolean isUrlHarmful(String url) {
        return (url.startsWith("http:") || url.startsWith("https:")) && !this.appView.getWhitelist().isUrlWhiteListed(url) || url.contains("app_webview");
    }

    private static boolean needsKitKatContentUrlFix(Uri uri) {
        return Build.VERSION.SDK_INT >= 19 && "content".equals(uri.getScheme());
    }

    private static boolean needsSpecialsInAssetUrlFix(Uri uri) {
        if (CordovaResourceApi.getUriType(uri) != 1) {
            return false;
        }
        if (uri.getQuery() != null || uri.getFragment() != null) {
            return true;
        }
        if (!uri.toString().contains("%")) {
            return false;
        }
        switch (Build.VERSION.SDK_INT) {
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }
}

