/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.TargetApi;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.util.Hashtable;
import org.apache.cordova.AuthenticationToken;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaUriHelper;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.LOG;
import org.json.JSONException;
import org.json.JSONObject;

public class CordovaWebViewClient
extends WebViewClient {
    private static final String TAG = "CordovaWebViewClient";
    CordovaInterface cordova;
    CordovaWebView appView;
    CordovaUriHelper helper;
    private boolean doClearHistory = false;
    boolean isCurrentlyLoading;
    private Hashtable<String, AuthenticationToken> authenticationTokens = new Hashtable();

    @Deprecated
    public CordovaWebViewClient(CordovaInterface cordova) {
        this.cordova = cordova;
    }

    public CordovaWebViewClient(CordovaInterface cordova, CordovaWebView view) {
        this.cordova = cordova;
        this.appView = view;
        this.helper = new CordovaUriHelper(cordova, view);
    }

    @Deprecated
    public void setWebView(CordovaWebView view) {
        this.appView = view;
        this.helper = new CordovaUriHelper(this.cordova, view);
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        return this.helper.shouldOverrideUrlLoading(view, url);
    }

    public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
        AuthenticationToken token = this.getAuthenticationToken(host, realm);
        if (token != null) {
            handler.proceed(token.getUserName(), token.getPassword());
        } else {
            super.onReceivedHttpAuthRequest(view, handler, host, realm);
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.isCurrentlyLoading = true;
        LOG.d(TAG, "onPageStarted(" + url + ")");
        this.appView.bridge.reset(url);
        this.appView.postMessage("onPageStarted", url);
        if (this.appView.pluginManager != null) {
            this.appView.pluginManager.onReset();
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (!this.isCurrentlyLoading) {
            return;
        }
        this.isCurrentlyLoading = false;
        LOG.d(TAG, "onPageFinished(" + url + ")");
        if (this.doClearHistory) {
            view.clearHistory();
            this.doClearHistory = false;
        }
        ++this.appView.loadUrlTimeout;
        this.appView.postMessage("onPageFinished", url);
        if (this.appView.getVisibility() == 4) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(2000L);
                        CordovaWebViewClient.this.cordova.getActivity().runOnUiThread(new Runnable(){

                            public void run() {
                                CordovaWebViewClient.this.appView.postMessage("spinner", "stop");
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            t.start();
        }
        if (url.equals("about:blank")) {
            this.appView.postMessage("exit", null);
        }
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        if (!this.isCurrentlyLoading) {
            return;
        }
        LOG.d(TAG, "CordovaWebViewClient.onReceivedError: Error code=%s Description=%s URL=%s", errorCode, description, failingUrl);
        ++this.appView.loadUrlTimeout;
        if (errorCode == -10) {
            if (view.canGoBack()) {
                view.goBack();
                return;
            }
            super.onReceivedError(view, errorCode, description, failingUrl);
        }
        JSONObject data = new JSONObject();
        try {
            data.put("errorCode", errorCode);
            data.put("description", (Object)description);
            data.put("url", (Object)failingUrl);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.appView.postMessage("onReceivedError", data);
    }

    @TargetApi(value=8)
    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        String packageName = this.cordova.getActivity().getPackageName();
        PackageManager pm = this.cordova.getActivity().getPackageManager();
        try {
            ApplicationInfo appInfo = pm.getApplicationInfo(packageName, 128);
            if ((appInfo.flags & 2) != 0) {
                handler.proceed();
                return;
            }
            super.onReceivedSslError(view, handler, error);
        }
        catch (PackageManager.NameNotFoundException e) {
            super.onReceivedSslError(view, handler, error);
        }
    }

    public void setAuthenticationToken(AuthenticationToken authenticationToken, String host, String realm) {
        if (host == null) {
            host = "";
        }
        if (realm == null) {
            realm = "";
        }
        this.authenticationTokens.put(host.concat(realm), authenticationToken);
    }

    public AuthenticationToken removeAuthenticationToken(String host, String realm) {
        return this.authenticationTokens.remove(host.concat(realm));
    }

    public AuthenticationToken getAuthenticationToken(String host, String realm) {
        AuthenticationToken token = null;
        token = this.authenticationTokens.get(host.concat(realm));
        if (token == null) {
            token = this.authenticationTokens.get(host);
            if (token == null) {
                token = this.authenticationTokens.get(realm);
            }
            if (token == null) {
                token = this.authenticationTokens.get("");
            }
        }
        return token;
    }

    public void clearAuthenticationTokens() {
        this.authenticationTokens.clear();
    }
}

