/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebBackForwardList;
import android.webkit.WebChromeClient;
import android.webkit.WebHistoryItem;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.cordova.Config;
import org.apache.cordova.CordovaBridge;
import org.apache.cordova.CordovaChromeClient;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.CordovaWebViewClient;
import org.apache.cordova.ExposedJsApi;
import org.apache.cordova.IceCreamCordovaWebViewClient;
import org.apache.cordova.LOG;
import org.apache.cordova.NativeToJsMessageQueue;
import org.apache.cordova.PluginEntry;
import org.apache.cordova.PluginManager;
import org.apache.cordova.PluginResult;
import org.apache.cordova.ScrollEvent;
import org.apache.cordova.Whitelist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CordovaWebView
extends WebView {
    public static final String TAG = "CordovaWebView";
    public static final String CORDOVA_VERSION = "3.6.4";
    private HashSet<Integer> boundKeyCodes = new HashSet();
    public PluginManager pluginManager;
    private boolean paused;
    private BroadcastReceiver receiver;
    private CordovaInterface cordova;
    CordovaWebViewClient viewClient;
    private CordovaChromeClient chromeClient;
    int loadUrlTimeout = 0;
    private long lastMenuEventTime = 0L;
    CordovaBridge bridge;
    private View mCustomView;
    private WebChromeClient.CustomViewCallback mCustomViewCallback;
    private CordovaResourceApi resourceApi;
    private Whitelist internalWhitelist;
    private Whitelist externalWhitelist;
    String loadedUrl;
    private CordovaPreferences preferences;
    static final FrameLayout.LayoutParams COVER_SCREEN_GRAVITY_CENTER = new FrameLayout.LayoutParams(-1, -1, 17);

    public CordovaWebView(Context context) {
        this(context, null);
    }

    public CordovaWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Deprecated
    public CordovaWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Deprecated
    @TargetApi(value=11)
    public CordovaWebView(Context context, AttributeSet attrs, int defStyle, boolean privateBrowsing) {
        super(context, attrs, defStyle, privateBrowsing);
    }

    public void init(CordovaInterface cordova, CordovaWebViewClient webViewClient, CordovaChromeClient webChromeClient, List<PluginEntry> pluginEntries, Whitelist internalWhitelist, Whitelist externalWhitelist, CordovaPreferences preferences) {
        if (this.cordova != null) {
            throw new IllegalStateException();
        }
        this.cordova = cordova;
        this.viewClient = webViewClient;
        this.chromeClient = webChromeClient;
        this.internalWhitelist = internalWhitelist;
        this.externalWhitelist = externalWhitelist;
        this.preferences = preferences;
        super.setWebChromeClient((WebChromeClient)webChromeClient);
        super.setWebViewClient((WebViewClient)webViewClient);
        this.pluginManager = new PluginManager(this, this.cordova, pluginEntries);
        this.bridge = new CordovaBridge(this.pluginManager, new NativeToJsMessageQueue(this, cordova));
        this.resourceApi = new CordovaResourceApi(this.getContext(), this.pluginManager);
        this.pluginManager.addService("App", "org.apache.cordova.App");
        this.initWebViewSettings();
        this.exposeJsInterface();
    }

    private void initIfNecessary() {
        if (this.pluginManager == null) {
            Log.w((String)TAG, (String)"CordovaWebView.init() was not called. This will soon be required.");
            CordovaInterface cdv = (CordovaInterface)this.getContext();
            if (!Config.isInitialized()) {
                Config.init(cdv.getActivity());
            }
            this.init(cdv, this.makeWebViewClient(cdv), this.makeWebChromeClient(cdv), Config.getPluginEntries(), Config.getWhitelist(), Config.getExternalWhitelist(), Config.getPreferences());
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebViewSettings() {
        this.setInitialScale(0);
        this.setVerticalScrollBarEnabled(false);
        if (this.shouldRequestFocusOnInit()) {
            this.requestFocusFromTouch();
        }
        WebSettings settings = this.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        try {
            Method gingerbread_getMethod = WebSettings.class.getMethod("setNavDump", Boolean.TYPE);
            String manufacturer = Build.MANUFACTURER;
            Log.d((String)TAG, (String)("CordovaWebView is running on device made by: " + manufacturer));
            if (Build.VERSION.SDK_INT < 11 && Build.MANUFACTURER.contains("HTC")) {
                gingerbread_getMethod.invoke((Object)settings, true);
            }
        }
        catch (NoSuchMethodException e) {
            Log.d((String)TAG, (String)"We are on a modern version of Android, we will deprecate HTC 2.3 devices in 2.8");
        }
        catch (IllegalArgumentException e) {
            Log.d((String)TAG, (String)"Doing the NavDump failed with bad arguments");
        }
        catch (IllegalAccessException e) {
            Log.d((String)TAG, (String)"This should never happen: IllegalAccessException means this isn't Android anymore");
        }
        catch (InvocationTargetException e) {
            Log.d((String)TAG, (String)"This should never happen: InvocationTargetException means this isn't Android anymore.");
        }
        settings.setSaveFormData(false);
        settings.setSavePassword(false);
        if (Build.VERSION.SDK_INT > 15) {
            Level16Apis.enableUniversalAccess(settings);
        }
        String databasePath = this.getContext().getApplicationContext().getDir("database", 0).getPath();
        settings.setDatabaseEnabled(true);
        settings.setDatabasePath(databasePath);
        ApplicationInfo appInfo = this.getContext().getApplicationContext().getApplicationInfo();
        if ((appInfo.flags & 2) != 0 && Build.VERSION.SDK_INT >= 19) {
            this.enableRemoteDebugging();
        }
        settings.setGeolocationDatabasePath(databasePath);
        settings.setDomStorageEnabled(true);
        settings.setGeolocationEnabled(true);
        settings.setAppCacheMaxSize(0x500000L);
        settings.setAppCachePath(databasePath);
        settings.setAppCacheEnabled(true);
        settings.getUserAgentString();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        if (this.receiver == null) {
            this.receiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    CordovaWebView.this.getSettings().getUserAgentString();
                }
            };
            this.getContext().registerReceiver(this.receiver, intentFilter);
        }
    }

    @TargetApi(value=19)
    private void enableRemoteDebugging() {
        try {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        catch (IllegalArgumentException e) {
            Log.d((String)TAG, (String)"You have one job! To turn on Remote Web Debugging! YOU HAVE FAILED! ");
            e.printStackTrace();
        }
    }

    public CordovaChromeClient makeWebChromeClient(CordovaInterface cordova) {
        return new CordovaChromeClient(cordova, this);
    }

    public CordovaWebViewClient makeWebViewClient(CordovaInterface cordova) {
        if (Build.VERSION.SDK_INT < 14) {
            return new CordovaWebViewClient(cordova, this);
        }
        return new IceCreamCordovaWebViewClient(cordova, this);
    }

    protected boolean shouldRequestFocusOnInit() {
        return true;
    }

    private void exposeJsInterface() {
        if (Build.VERSION.SDK_INT < 17) {
            Log.i((String)TAG, (String)"Disabled addJavascriptInterface() bridge since Android version is old.");
            return;
        }
        this.addJavascriptInterface(new ExposedJsApi(this.bridge), "_cordovaNative");
    }

    public void setWebViewClient(WebViewClient client) {
        this.viewClient = (CordovaWebViewClient)client;
        super.setWebViewClient(client);
    }

    public void setWebChromeClient(WebChromeClient client) {
        this.chromeClient = (CordovaChromeClient)client;
        super.setWebChromeClient(client);
    }

    public CordovaChromeClient getWebChromeClient() {
        return this.chromeClient;
    }

    public Whitelist getWhitelist() {
        return this.internalWhitelist;
    }

    public Whitelist getExternalWhitelist() {
        return this.externalWhitelist;
    }

    public void loadUrl(String url) {
        if (url.equals("about:blank") || url.startsWith("javascript:")) {
            this.loadUrlNow(url);
        } else {
            this.loadUrlIntoView(url);
        }
    }

    @Deprecated
    public void loadUrl(String url, int time) {
        if (url == null) {
            this.loadUrlIntoView(Config.getStartUrl());
        } else {
            this.loadUrlIntoView(url);
        }
    }

    public void loadUrlIntoView(String url) {
        this.loadUrlIntoView(url, true);
    }

    public void loadUrlIntoView(final String url, boolean recreatePlugins) {
        LOG.d(TAG, ">>> loadUrl(" + url + ")");
        this.initIfNecessary();
        if (recreatePlugins) {
            this.loadedUrl = url;
            this.pluginManager.init();
        }
        final CordovaWebView me = this;
        final int currentLoadUrlTimeout = me.loadUrlTimeout;
        final int loadUrlTimeoutValue = Integer.parseInt(this.getProperty("LoadUrlTimeoutValue", "20000"));
        final Runnable loadError = new Runnable(){

            public void run() {
                me.stopLoading();
                LOG.e(CordovaWebView.TAG, "CordovaWebView: TIMEOUT ERROR!");
                if (CordovaWebView.this.viewClient != null) {
                    CordovaWebView.this.viewClient.onReceivedError(me, -6, "The connection to the server was unsuccessful.", url);
                }
            }
        };
        final Runnable timeoutCheck = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    3 var1_1 = this;
                    synchronized (var1_1) {
                        this.wait(loadUrlTimeoutValue);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (me.loadUrlTimeout == currentLoadUrlTimeout) {
                    me.cordova.getActivity().runOnUiThread(loadError);
                }
            }
        };
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            public void run() {
                CordovaWebView.this.cordova.getThreadPool().execute(timeoutCheck);
                me.loadUrlNow(url);
            }
        });
    }

    void loadUrlNow(String url) {
        if (LOG.isLoggable(3) && !url.startsWith("javascript:")) {
            LOG.d(TAG, ">>> loadUrlNow()");
        }
        if (url.startsWith("file://") || url.startsWith("javascript:") || this.internalWhitelist.isUrlWhiteListed(url)) {
            super.loadUrl(url);
        }
    }

    public void loadUrlIntoView(String url, int time) {
        if (!url.startsWith("javascript:") && !this.canGoBack()) {
            LOG.d(TAG, "loadUrlIntoView(%s, %d)", url, time);
            this.postMessage("splashscreen", "show");
        }
        this.loadUrlIntoView(url);
    }

    public void stopLoading() {
        this.viewClient.isCurrentlyLoading = false;
        super.stopLoading();
    }

    public void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        ScrollEvent myEvent = new ScrollEvent(l, t, oldl, oldt, (View)this);
        this.postMessage("onScrollChanged", myEvent);
    }

    @Deprecated
    public void sendJavascript(String statement) {
        this.bridge.getMessageQueue().addJavaScript(statement);
    }

    public void sendPluginResult(PluginResult result, String callbackId) {
        this.bridge.getMessageQueue().addPluginResult(result, callbackId);
    }

    public void postMessage(String id, Object data) {
        if (this.pluginManager != null) {
            this.pluginManager.postMessage(id, data);
        }
    }

    public boolean backHistory() {
        if (super.canGoBack()) {
            super.goBack();
            return true;
        }
        return false;
    }

    public void showWebPage(String url, boolean openExternal, boolean clearHistory, HashMap<String, Object> params) {
        LOG.d(TAG, "showWebPage(%s, %b, %b, HashMap", url, openExternal, clearHistory);
        if (clearHistory) {
            this.clearHistory();
        }
        if (!openExternal) {
            if (url.startsWith("file://") || this.internalWhitelist.isUrlWhiteListed(url)) {
                this.loadUrl(url);
                return;
            }
            LOG.w(TAG, "showWebPage: Cannot load URL into webview since it is not in white list.  Loading into browser instead. (URL=" + url + ")");
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            Uri uri = Uri.parse((String)url);
            if ("file".equals(uri.getScheme())) {
                intent.setDataAndType(uri, this.resourceApi.getMimeType(uri));
            } else {
                intent.setData(uri);
            }
            this.cordova.getActivity().startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            LOG.e(TAG, "Error loading url " + url, e);
        }
    }

    public String getProperty(String name, String defaultValue) {
        Bundle bundle = this.cordova.getActivity().getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        Object p = bundle.get(name = name.toLowerCase(Locale.getDefault()));
        if (p == null) {
            return defaultValue;
        }
        return p.toString();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.boundKeyCodes.contains(keyCode)) {
            if (keyCode == 25) {
                this.loadUrl("javascript:cordova.fireDocumentEvent('volumedownbutton');");
                return true;
            }
            if (keyCode == 24) {
                this.loadUrl("javascript:cordova.fireDocumentEvent('volumeupbutton');");
                return true;
            }
            return super.onKeyDown(keyCode, event);
        }
        if (keyCode == 4) {
            return !this.startOfHistory() || this.isButtonPlumbedToJs(4);
        }
        if (keyCode == 82) {
            View childView = this.getFocusedChild();
            if (childView != null) {
                InputMethodManager imm = (InputMethodManager)this.cordova.getActivity().getSystemService("input_method");
                imm.hideSoftInputFromWindow(childView.getWindowToken(), 0);
                this.cordova.getActivity().openOptionsMenu();
                return true;
            }
            return super.onKeyDown(keyCode, event);
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (this.mCustomView != null) {
                this.hideCustomView();
                return true;
            }
            if (this.isButtonPlumbedToJs(4)) {
                this.loadUrl("javascript:cordova.fireDocumentEvent('backbutton');");
                return true;
            }
            if (this.backHistory()) {
                return true;
            }
        } else {
            if (keyCode == 82) {
                if (this.lastMenuEventTime < event.getEventTime()) {
                    this.loadUrl("javascript:cordova.fireDocumentEvent('menubutton');");
                }
                this.lastMenuEventTime = event.getEventTime();
                return super.onKeyUp(keyCode, event);
            }
            if (keyCode == 84) {
                this.loadUrl("javascript:cordova.fireDocumentEvent('searchbutton');");
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public void setButtonPlumbedToJs(int keyCode, boolean override) {
        switch (keyCode) {
            case 4: 
            case 24: 
            case 25: {
                if (override) {
                    this.boundKeyCodes.add(keyCode);
                } else {
                    this.boundKeyCodes.remove(keyCode);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported keycode: " + keyCode);
    }

    @Deprecated
    public void bindButton(boolean override) {
        this.setButtonPlumbedToJs(4, override);
    }

    @Deprecated
    public void bindButton(String button, boolean override) {
        if (button.compareTo("volumeup") == 0) {
            this.setButtonPlumbedToJs(24, override);
        } else if (button.compareTo("volumedown") == 0) {
            this.setButtonPlumbedToJs(25, override);
        }
    }

    @Deprecated
    public void bindButton(int keyCode, boolean keyDown, boolean override) {
        this.setButtonPlumbedToJs(keyCode, override);
    }

    @Deprecated
    public boolean isBackButtonBound() {
        return this.isButtonPlumbedToJs(4);
    }

    public boolean isButtonPlumbedToJs(int keyCode) {
        return this.boundKeyCodes.contains(keyCode);
    }

    public void handlePause(boolean keepRunning) {
        LOG.d(TAG, "Handle the pause");
        this.loadUrl("javascript:try{cordova.fireDocumentEvent('pause');}catch(e){console.log('exception firing pause event from native');};");
        if (this.pluginManager != null) {
            this.pluginManager.onPause(keepRunning);
        }
        if (!keepRunning) {
            this.pauseTimers();
        }
        this.paused = true;
    }

    public void handleResume(boolean keepRunning, boolean activityResultKeepRunning) {
        this.loadUrl("javascript:try{cordova.fireDocumentEvent('resume');}catch(e){console.log('exception firing resume event from native');};");
        if (this.pluginManager != null) {
            this.pluginManager.onResume(keepRunning);
        }
        this.resumeTimers();
        this.paused = false;
    }

    public void handleDestroy() {
        this.loadUrl("javascript:try{cordova.require('cordova/channel').onDestroy.fire();}catch(e){console.log('exception firing destroy event from native');};");
        this.loadUrl("about:blank");
        if (this.pluginManager != null) {
            this.pluginManager.onDestroy();
        }
        if (this.receiver != null) {
            try {
                this.getContext().unregisterReceiver(this.receiver);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Error unregistering configuration receiver: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void onNewIntent(Intent intent) {
        if (this.pluginManager != null) {
            this.pluginManager.onNewIntent(intent);
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    @Deprecated
    public boolean hadKeyEvent() {
        return false;
    }

    public void printBackForwardList() {
        WebBackForwardList currentList = this.copyBackForwardList();
        int currentSize = currentList.getSize();
        for (int i = 0; i < currentSize; ++i) {
            WebHistoryItem item = currentList.getItemAtIndex(i);
            String url = item.getUrl();
            LOG.d(TAG, "The URL at index: " + Integer.toString(i) + " is " + url);
        }
    }

    public boolean startOfHistory() {
        WebBackForwardList currentList = this.copyBackForwardList();
        WebHistoryItem item = currentList.getItemAtIndex(0);
        if (item != null) {
            String url = item.getUrl();
            String currentUrl = this.getUrl();
            LOG.d(TAG, "The current URL is: " + currentUrl);
            LOG.d(TAG, "The URL at item 0 is: " + url);
            return currentUrl.equals(url);
        }
        return false;
    }

    public void showCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        Log.d((String)TAG, (String)"showing Custom View");
        if (this.mCustomView != null) {
            callback.onCustomViewHidden();
            return;
        }
        this.mCustomView = view;
        this.mCustomViewCallback = callback;
        ViewGroup parent = (ViewGroup)this.getParent();
        parent.addView(view, (ViewGroup.LayoutParams)COVER_SCREEN_GRAVITY_CENTER);
        this.setVisibility(8);
        parent.setVisibility(0);
        parent.bringToFront();
    }

    public void hideCustomView() {
        Log.d((String)TAG, (String)"Hiding Custom View");
        if (this.mCustomView == null) {
            return;
        }
        this.mCustomView.setVisibility(8);
        ViewGroup parent = (ViewGroup)this.getParent();
        parent.removeView(this.mCustomView);
        this.mCustomView = null;
        this.mCustomViewCallback.onCustomViewHidden();
        this.setVisibility(0);
    }

    public boolean isCustomViewShowing() {
        return this.mCustomView != null;
    }

    public WebBackForwardList restoreState(Bundle savedInstanceState) {
        WebBackForwardList myList = super.restoreState(savedInstanceState);
        Log.d((String)TAG, (String)"WebView restoration crew now restoring!");
        this.pluginManager.init();
        return myList;
    }

    @Deprecated
    public void storeResult(int requestCode, int resultCode, Intent intent) {
    }

    public CordovaResourceApi getResourceApi() {
        return this.resourceApi;
    }

    public CordovaPreferences getPreferences() {
        return this.preferences;
    }

    @TargetApi(value=16)
    private static class Level16Apis {
        private Level16Apis() {
        }

        static void enableUniversalAccess(WebSettings settings) {
            settings.setAllowUniversalAccessFromFileURLs(true);
        }
    }

    class ActivityResult {
        int request;
        int result;
        Intent incoming;

        public ActivityResult(int req, int res, Intent intent) {
            this.request = req;
            this.result = res;
            this.incoming = intent;
        }
    }
}

