/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.webkit.WebView;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.LOG;

class CordovaUriHelper {
    private static final String TAG = "CordovaUriHelper";
    private CordovaWebView appView;
    private CordovaInterface cordova;

    CordovaUriHelper(CordovaInterface cdv, CordovaWebView webView) {
        this.appView = webView;
        this.cordova = cdv;
    }

    @TargetApi(value=15)
    boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (this.appView.pluginManager.onOverrideUrlLoading(url)) {
            return true;
        }
        if (url.startsWith("file://") | url.startsWith("data:")) {
            return url.contains("app_webview");
        }
        if (this.appView.getWhitelist().isUrlWhiteListed(url)) {
            return false;
        }
        if (this.appView.getExternalWhitelist().isUrlWhiteListed(url)) {
            try {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)url));
                intent.addCategory("android.intent.category.BROWSABLE");
                intent.setComponent(null);
                if (Build.VERSION.SDK_INT >= 15) {
                    intent.setSelector(null);
                }
                this.cordova.getActivity().startActivity(intent);
                return true;
            }
            catch (ActivityNotFoundException e) {
                LOG.e(TAG, "Error loading url " + url, e);
            }
        }
        return true;
    }
}

