/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.app.Activity;
import android.content.res.XmlResourceParser;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginEntry;
import org.apache.cordova.Whitelist;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigXmlParser {
    private static String TAG = "ConfigXmlParser";
    private String launchUrl = "file:///android_asset/www/index.html";
    private CordovaPreferences prefs = new CordovaPreferences();
    private Whitelist internalWhitelist = new Whitelist();
    private Whitelist externalWhitelist = new Whitelist();
    private ArrayList<PluginEntry> pluginEntries = new ArrayList(20);

    public Whitelist getInternalWhitelist() {
        return this.internalWhitelist;
    }

    public Whitelist getExternalWhitelist() {
        return this.externalWhitelist;
    }

    public CordovaPreferences getPreferences() {
        return this.prefs;
    }

    public ArrayList<PluginEntry> getPluginEntries() {
        return this.pluginEntries;
    }

    public String getLaunchUrl() {
        return this.launchUrl;
    }

    public void parse(Activity action) {
        int id = action.getResources().getIdentifier("config", "xml", action.getClass().getPackage().getName());
        if (id == 0 && (id = action.getResources().getIdentifier("config", "xml", action.getPackageName())) == 0) {
            LOG.e(TAG, "res/xml/config.xml is missing!");
            return;
        }
        this.parse(action.getResources().getXml(id));
    }

    public void parse(XmlResourceParser xml) {
        int eventType = -1;
        String service = "";
        String pluginClass = "";
        String paramType = "";
        boolean onload = false;
        boolean insideFeature = false;
        ArrayList<String> urlMap = null;
        this.internalWhitelist.addWhiteListEntry("file:///*", false);
        this.internalWhitelist.addWhiteListEntry("content:///*", false);
        this.internalWhitelist.addWhiteListEntry("data:*", false);
        while (eventType != 1) {
            String strNode;
            if (eventType == 2) {
                String src;
                strNode = xml.getName();
                if (strNode.equals("url-filter")) {
                    Log.w((String)TAG, (String)("Plugin " + service + " is using deprecated tag <url-filter>"));
                    if (urlMap == null) {
                        urlMap = new ArrayList<String>(2);
                    }
                    urlMap.add(xml.getAttributeValue(null, "value"));
                } else if (strNode.equals("feature")) {
                    insideFeature = true;
                    service = xml.getAttributeValue(null, "name");
                } else if (insideFeature && strNode.equals("param")) {
                    paramType = xml.getAttributeValue(null, "name");
                    if (paramType.equals("service")) {
                        service = xml.getAttributeValue(null, "value");
                    } else if (paramType.equals("package") || paramType.equals("android-package")) {
                        pluginClass = xml.getAttributeValue(null, "value");
                    } else if (paramType.equals("onload")) {
                        onload = "true".equals(xml.getAttributeValue(null, "value"));
                    }
                } else if (strNode.equals("access")) {
                    boolean external;
                    String origin = xml.getAttributeValue(null, "origin");
                    String subdomains = xml.getAttributeValue(null, "subdomains");
                    boolean bl = external = xml.getAttributeValue(null, "launch-external") != null;
                    if (origin != null) {
                        if (external) {
                            this.externalWhitelist.addWhiteListEntry(origin, subdomains != null && subdomains.compareToIgnoreCase("true") == 0);
                        } else if ("*".equals(origin)) {
                            this.internalWhitelist.addWhiteListEntry("http://*/*", false);
                            this.internalWhitelist.addWhiteListEntry("https://*/*", false);
                        } else {
                            this.internalWhitelist.addWhiteListEntry(origin, subdomains != null && subdomains.compareToIgnoreCase("true") == 0);
                        }
                    }
                } else if (strNode.equals("preference")) {
                    String name = xml.getAttributeValue(null, "name").toLowerCase(Locale.ENGLISH);
                    String value = xml.getAttributeValue(null, "value");
                    this.prefs.set(name, value);
                } else if (strNode.equals("content") && (src = xml.getAttributeValue(null, "src")) != null) {
                    this.setStartUrl(src);
                }
            } else if (eventType == 3 && (strNode = xml.getName()).equals("feature")) {
                this.pluginEntries.add(new PluginEntry(service, pluginClass, onload, urlMap));
                service = "";
                pluginClass = "";
                insideFeature = false;
                onload = false;
                urlMap = null;
            }
            try {
                eventType = xml.next();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void setStartUrl(String src) {
        Pattern schemeRegex = Pattern.compile("^[a-z-]+://");
        Matcher matcher = schemeRegex.matcher(src);
        if (matcher.find()) {
            this.launchUrl = src;
        } else {
            if (src.charAt(0) == '/') {
                src = src.substring(1);
            }
            this.launchUrl = "file:///android_asset/www/" + src;
        }
    }
}

