/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.spdy;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

final class Hpack {
    static final int PREFIX_5_BITS = 31;
    static final int PREFIX_6_BITS = 63;
    static final int PREFIX_7_BITS = 127;
    static final int PREFIX_8_BITS = 255;
    static final List<HeaderEntry> INITIAL_CLIENT_TO_SERVER_HEADER_TABLE = Arrays.asList(new HeaderEntry(":scheme", "http"), new HeaderEntry(":scheme", "https"), new HeaderEntry(":host", ""), new HeaderEntry(":path", "/"), new HeaderEntry(":method", "GET"), new HeaderEntry("accept", ""), new HeaderEntry("accept-charset", ""), new HeaderEntry("accept-encoding", ""), new HeaderEntry("accept-language", ""), new HeaderEntry("cookie", ""), new HeaderEntry("if-modified-since", ""), new HeaderEntry("user-agent", ""), new HeaderEntry("referer", ""), new HeaderEntry("authorization", ""), new HeaderEntry("allow", ""), new HeaderEntry("cache-control", ""), new HeaderEntry("connection", ""), new HeaderEntry("content-length", ""), new HeaderEntry("content-type", ""), new HeaderEntry("date", ""), new HeaderEntry("expect", ""), new HeaderEntry("from", ""), new HeaderEntry("if-match", ""), new HeaderEntry("if-none-match", ""), new HeaderEntry("if-range", ""), new HeaderEntry("if-unmodified-since", ""), new HeaderEntry("max-forwards", ""), new HeaderEntry("proxy-authorization", ""), new HeaderEntry("range", ""), new HeaderEntry("via", ""));
    static final List<HeaderEntry> INITIAL_SERVER_TO_CLIENT_HEADER_TABLE = Arrays.asList(new HeaderEntry(":status", "200"), new HeaderEntry("age", ""), new HeaderEntry("cache-control", ""), new HeaderEntry("content-length", ""), new HeaderEntry("content-type", ""), new HeaderEntry("date", ""), new HeaderEntry("etag", ""), new HeaderEntry("expires", ""), new HeaderEntry("last-modified", ""), new HeaderEntry("server", ""), new HeaderEntry("set-cookie", ""), new HeaderEntry("vary", ""), new HeaderEntry("via", ""), new HeaderEntry("access-control-allow-origin", ""), new HeaderEntry("accept-ranges", ""), new HeaderEntry("allow", ""), new HeaderEntry("connection", ""), new HeaderEntry("content-disposition", ""), new HeaderEntry("content-encoding", ""), new HeaderEntry("content-language", ""), new HeaderEntry("content-location", ""), new HeaderEntry("content-range", ""), new HeaderEntry("link", ""), new HeaderEntry("location", ""), new HeaderEntry("proxy-authenticate", ""), new HeaderEntry("refresh", ""), new HeaderEntry("retry-after", ""), new HeaderEntry("strict-transport-security", ""), new HeaderEntry("transfer-encoding", ""), new HeaderEntry("www-authenticate", ""));
    static final int INITIAL_CLIENT_TO_SERVER_HEADER_TABLE_LENGTH = 1262;
    static final int INITIAL_SERVER_TO_CLIENT_HEADER_TABLE_LENGTH = 1304;

    private Hpack() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Writer {
        private final OutputStream out;

        Writer(OutputStream out) {
            this.out = out;
        }

        public void writeHeaders(List<String> nameValueBlock) throws IOException {
            int size = nameValueBlock.size();
            for (int i = 0; i < size; i += 2) {
                this.out.write(96);
                this.writeString(nameValueBlock.get(i));
                this.writeString(nameValueBlock.get(i + 1));
            }
        }

        public void writeInt(int value, int prefixMask, int bits) throws IOException {
            if (value < prefixMask) {
                this.out.write(bits | value);
                return;
            }
            this.out.write(bits | prefixMask);
            value -= prefixMask;
            while (value >= 128) {
                int b = value & 0x7F;
                this.out.write(b | 0x80);
                value >>>= 7;
            }
            this.out.write(value);
        }

        public void writeString(String headerName) throws IOException {
            byte[] bytes = headerName.getBytes("UTF-8");
            this.writeInt(bytes.length, 255, 0);
            this.out.write(bytes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Reader {
        private final long maxBufferSize = 4096L;
        private final DataInputStream in;
        private final BitSet referenceSet = new BitSet();
        private final List<HeaderEntry> headerTable;
        private final List<String> emittedHeaders = new ArrayList<String>();
        private long bufferSize = 0L;
        private long bytesLeft = 0L;

        Reader(DataInputStream in, boolean client) {
            this.in = in;
            if (client) {
                this.headerTable = new ArrayList<HeaderEntry>(INITIAL_SERVER_TO_CLIENT_HEADER_TABLE);
                this.bufferSize = 1304L;
            } else {
                this.headerTable = new ArrayList<HeaderEntry>(INITIAL_CLIENT_TO_SERVER_HEADER_TABLE);
                this.bufferSize = 1262L;
            }
        }

        public void readHeaders(int byteCount) throws IOException {
            this.bytesLeft += (long)byteCount;
            while (this.bytesLeft > 0L) {
                int index;
                int b = this.readByte();
                if ((b & 0x80) != 0) {
                    index = this.readInt(b, 127);
                    this.readIndexedHeader(index);
                    continue;
                }
                if (b == 96) {
                    this.readLiteralHeaderWithoutIndexingNewName();
                    continue;
                }
                if ((b & 0xE0) == 96) {
                    index = this.readInt(b, 31);
                    this.readLiteralHeaderWithoutIndexingIndexedName(index - 1);
                    continue;
                }
                if (b == 64) {
                    this.readLiteralHeaderWithIncrementalIndexingNewName();
                    continue;
                }
                if ((b & 0xE0) == 64) {
                    index = this.readInt(b, 31);
                    this.readLiteralHeaderWithIncrementalIndexingIndexedName(index - 1);
                    continue;
                }
                if (b == 0) {
                    this.readLiteralHeaderWithSubstitutionIndexingNewName();
                    continue;
                }
                if ((b & 0xC0) == 0) {
                    index = this.readInt(b, 63);
                    this.readLiteralHeaderWithSubstitutionIndexingIndexedName(index - 1);
                    continue;
                }
                throw new AssertionError();
            }
        }

        public void emitReferenceSet() {
            int i = this.referenceSet.nextSetBit(0);
            while (i != -1) {
                this.emittedHeaders.add(this.getName(i));
                this.emittedHeaders.add(this.getValue(i));
                i = this.referenceSet.nextSetBit(i + 1);
            }
        }

        public List<String> getAndReset() {
            ArrayList<String> result = new ArrayList<String>(this.emittedHeaders);
            this.emittedHeaders.clear();
            return result;
        }

        private void readIndexedHeader(int index) {
            if (this.referenceSet.get(index)) {
                this.referenceSet.clear(index);
            } else {
                this.referenceSet.set(index);
            }
        }

        private void readLiteralHeaderWithoutIndexingIndexedName(int index) throws IOException {
            String name = this.getName(index);
            String value = this.readString();
            this.emittedHeaders.add(name);
            this.emittedHeaders.add(value);
        }

        private void readLiteralHeaderWithoutIndexingNewName() throws IOException {
            String name = this.readString();
            String value = this.readString();
            this.emittedHeaders.add(name);
            this.emittedHeaders.add(value);
        }

        private void readLiteralHeaderWithIncrementalIndexingIndexedName(int nameIndex) throws IOException {
            String name = this.getName(nameIndex);
            String value = this.readString();
            int index = this.headerTable.size();
            this.insertIntoHeaderTable(index, new HeaderEntry(name, value));
        }

        private void readLiteralHeaderWithIncrementalIndexingNewName() throws IOException {
            String name = this.readString();
            String value = this.readString();
            int index = this.headerTable.size();
            this.insertIntoHeaderTable(index, new HeaderEntry(name, value));
        }

        private void readLiteralHeaderWithSubstitutionIndexingIndexedName(int nameIndex) throws IOException {
            int index = this.readInt(this.readByte(), 255);
            String name = this.getName(nameIndex);
            String value = this.readString();
            this.insertIntoHeaderTable(index, new HeaderEntry(name, value));
        }

        private void readLiteralHeaderWithSubstitutionIndexingNewName() throws IOException {
            String name = this.readString();
            int index = this.readInt(this.readByte(), 255);
            String value = this.readString();
            this.insertIntoHeaderTable(index, new HeaderEntry(name, value));
        }

        private String getName(int index) {
            return this.headerTable.get(index).name;
        }

        private String getValue(int index) {
            return this.headerTable.get(index).value;
        }

        private void insertIntoHeaderTable(int index, HeaderEntry entry) {
            int delta = entry.length();
            if (index != this.headerTable.size()) {
                delta -= this.headerTable.get(index).length();
            }
            if ((long)delta > 4096L) {
                this.headerTable.clear();
                this.bufferSize = 0L;
                this.emittedHeaders.add(entry.name);
                this.emittedHeaders.add(entry.value);
                return;
            }
            while (this.bufferSize + (long)delta > 4096L) {
                this.remove(0);
                --index;
            }
            if (index < 0) {
                index = 0;
                this.headerTable.add(index, entry);
            } else if (index == this.headerTable.size()) {
                this.headerTable.add(index, entry);
            } else {
                this.headerTable.set(index, entry);
            }
            this.bufferSize += (long)delta;
            this.referenceSet.set(index);
        }

        private void remove(int index) {
            this.bufferSize -= (long)this.headerTable.remove(index).length();
        }

        private int readByte() throws IOException {
            --this.bytesLeft;
            return this.in.readByte() & 0xFF;
        }

        int readInt(int firstByte, int prefixMask) throws IOException {
            int b;
            int prefix = firstByte & prefixMask;
            if (prefix < prefixMask) {
                return prefix;
            }
            int result = prefixMask;
            int shift = 0;
            while (((b = this.readByte()) & 0x80) != 0) {
                result += (b & 0x7F) << shift;
                shift += 7;
            }
            return result += b << shift;
        }

        public String readString() throws IOException {
            int firstByte = this.readByte();
            int length = this.readInt(firstByte, 255);
            byte[] encoded = new byte[length];
            this.bytesLeft -= (long)length;
            this.in.readFully(encoded);
            return new String(encoded, "UTF-8");
        }
    }

    static class HeaderEntry {
        private final String name;
        private final String value;

        HeaderEntry(String name, String value) {
            this.name = name;
            this.value = value;
        }

        int length() {
            return 32 + this.name.length() + this.value.length();
        }
    }
}

