/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

final class HeaderParser {
    public static void parseCacheControl(String value, CacheControlHandler handler) {
        int pos = 0;
        while (pos < value.length()) {
            String parameter;
            int parameterStart;
            int tokenStart = pos;
            pos = HeaderParser.skipUntil(value, pos, "=,;");
            String directive = value.substring(tokenStart, pos).trim();
            if (pos == value.length() || value.charAt(pos) == ',' || value.charAt(pos) == ';') {
                ++pos;
                handler.handle(directive, null);
                continue;
            }
            ++pos;
            if ((pos = HeaderParser.skipWhitespace(value, pos)) < value.length() && value.charAt(pos) == '\"') {
                parameterStart = ++pos;
                pos = HeaderParser.skipUntil(value, pos, "\"");
                parameter = value.substring(parameterStart, pos);
                ++pos;
            } else {
                parameterStart = pos;
                pos = HeaderParser.skipUntil(value, pos, ",;");
                parameter = value.substring(parameterStart, pos).trim();
            }
            handler.handle(directive, parameter);
        }
    }

    public static int skipUntil(String input, int pos, String characters) {
        while (pos < input.length() && characters.indexOf(input.charAt(pos)) == -1) {
            ++pos;
        }
        return pos;
    }

    public static int skipWhitespace(String input, int pos) {
        char c;
        while (pos < input.length() && ((c = input.charAt(pos)) == ' ' || c == '\t')) {
            ++pos;
        }
        return pos;
    }

    public static int parseSeconds(String value) {
        try {
            long seconds = Long.parseLong(value);
            if (seconds > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (seconds < 0L) {
                return 0;
            }
            return (int)seconds;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private HeaderParser() {
    }

    public static interface CacheControlHandler {
        public void handle(String var1, String var2);
    }
}

