/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.RawHeaders;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Request {
    private final URL url;
    private final String method;
    private final RawHeaders headers;
    private final Body body;
    private final Object tag;

    private Request(Builder builder) {
        this.url = builder.url;
        this.method = builder.method;
        this.headers = new RawHeaders(builder.headers);
        this.body = builder.body;
        this.tag = builder.tag != null ? builder.tag : this;
    }

    public URL url() {
        return this.url;
    }

    public String urlString() {
        return this.url.toString();
    }

    public String method() {
        return this.method;
    }

    public String header(String name) {
        return this.headers.get(name);
    }

    public List<String> headers(String name) {
        return this.headers.values(name);
    }

    public Set<String> headerNames() {
        return this.headers.names();
    }

    RawHeaders rawHeaders() {
        return new RawHeaders(this.headers);
    }

    public int headerCount() {
        return this.headers.length();
    }

    public String headerName(int index) {
        return this.headers.getFieldName(index);
    }

    public String headerValue(int index) {
        return this.headers.getValue(index);
    }

    public Body body() {
        return this.body;
    }

    public Object tag() {
        return this.tag;
    }

    Builder newBuilder() {
        return new Builder(this.url).method(this.method, this.body).rawHeaders(this.headers).tag(this.tag);
    }

    public static class Builder {
        private URL url;
        private String method = "GET";
        private RawHeaders headers = new RawHeaders();
        private Body body;
        private Object tag;

        public Builder(String url) {
            this.url(url);
        }

        public Builder(URL url) {
            this.url(url);
        }

        public Builder url(String url) {
            try {
                this.url = new URL(url);
                return this;
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Malformed URL: " + url);
            }
        }

        public Builder url(URL url) {
            if (url == null) {
                throw new IllegalStateException("url == null");
            }
            this.url = url;
            return this;
        }

        public Builder header(String name, String value) {
            this.headers.set(name, value);
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.add(name, value);
            return this;
        }

        Builder rawHeaders(RawHeaders rawHeaders) {
            this.headers = new RawHeaders(rawHeaders);
            return this;
        }

        public Builder get() {
            return this.method("GET", null);
        }

        public Builder head() {
            return this.method("HEAD", null);
        }

        public Builder post(Body body) {
            return this.method("POST", body);
        }

        public Builder put(Body body) {
            return this.method("PUT", body);
        }

        public Builder method(String method, Body body) {
            if (method == null || method.length() == 0) {
                throw new IllegalArgumentException("method == null || method.length() == 0");
            }
            this.method = method;
            this.body = body;
            return this;
        }

        public Builder tag(Object tag) {
            this.tag = tag;
            return this;
        }

        public Request build() {
            return new Request(this);
        }
    }

    public static abstract class Body {
        public abstract MediaType contentType();

        public long contentLength() {
            return -1L;
        }

        public abstract void writeTo(OutputStream var1) throws IOException;

        public static Body create(MediaType contentType, String content) {
            contentType = contentType.charset() != null ? contentType : MediaType.parse(contentType + "; charset=utf-8");
            try {
                byte[] bytes = content.getBytes(contentType.charset().name());
                return Body.create(contentType, bytes);
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError();
            }
        }

        public static Body create(final MediaType contentType, final byte[] content) {
            if (contentType == null) {
                throw new NullPointerException("contentType == null");
            }
            if (content == null) {
                throw new NullPointerException("content == null");
            }
            return new Body(){

                public MediaType contentType() {
                    return contentType;
                }

                public long contentLength() {
                    return content.length;
                }

                public void writeTo(OutputStream out) throws IOException {
                    out.write(content);
                }
            };
        }

        public static Body create(final MediaType contentType, final File file) {
            if (contentType == null) {
                throw new NullPointerException("contentType == null");
            }
            if (file == null) {
                throw new NullPointerException("content == null");
            }
            return new Body(){

                public MediaType contentType() {
                    return contentType;
                }

                public long contentLength() {
                    return file.length();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void writeTo(OutputStream out) throws IOException {
                    long length = this.contentLength();
                    if (length == 0L) {
                        return;
                    }
                    FileInputStream in = null;
                    try {
                        int c;
                        in = new FileInputStream(file);
                        byte[] buffer = new byte[(int)Math.min(8192L, length)];
                        while ((c = ((InputStream)in).read(buffer)) != -1) {
                            out.write(buffer, 0, c);
                        }
                    }
                    catch (Throwable throwable) {
                        Util.closeQuietly(in);
                        throw throwable;
                    }
                    Util.closeQuietly(in);
                }
            };
        }
    }
}

