/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import org.jfree.data.AbstractDataset;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.XYDataset;
import org.jfree.util.Log;

public class JDBCXYDataset
extends AbstractDataset
implements XYDataset,
RangeInfo {
    private Connection connection;
    private String[] columnNames = new String[0];
    private ArrayList rows = new ArrayList();
    private double maxValue = 0.0;
    private double minValue = 0.0;
    private boolean isTimeSeries = false;

    private JDBCXYDataset() {
    }

    public JDBCXYDataset(String string, String string2, String string3, String string4) throws SQLException, ClassNotFoundException {
        this();
        Class.forName(string2);
        this.connection = DriverManager.getConnection(string, string3, string4);
    }

    public JDBCXYDataset(Connection connection) throws SQLException {
        this();
        this.connection = connection;
    }

    public JDBCXYDataset(Connection connection, String string) throws SQLException {
        this(connection);
        this.executeQuery(string);
    }

    public boolean isTimeSeries() {
        return this.isTimeSeries;
    }

    public void setTimeSeries(boolean bl) {
        this.isTimeSeries = bl;
    }

    public void executeQuery(String string) throws SQLException {
        this.executeQuery(this.connection, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(Connection connection, String string) throws SQLException {
        Object object = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = null;
        if (connection == null) {
            throw new SQLException("There is no database to execute the query.");
        }
        ResultSet resultSet = null;
        ResultSetMetaData resultSetMetaData = null;
        Statement statement = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            resultSetMetaData = resultSet.getMetaData();
            n3 = resultSetMetaData.getColumnCount();
            nArray = new int[n3];
            n = 0;
            while (n < n3) {
                try {
                    int n5 = resultSetMetaData.getColumnType(n + 1);
                    switch (n5) {
                        case -7: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 91: 
                        case 92: 
                        case 93: {
                            ++n4;
                            nArray[n] = n5;
                            break;
                        }
                        default: {
                            Log.warn((Object)("Unable to load column " + n + " (" + n5 + "," + resultSetMetaData.getColumnClassName(n + 1) + ")"));
                            nArray[n] = 0;
                            break;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    nArray[n] = 0;
                    throw sQLException;
                }
                ++n;
            }
            if (n4 <= 1) {
                throw new SQLException("Not enough valid columns where generated by query.");
            }
            this.columnNames = new String[n4 - 1];
            n2 = 0;
            n = 1;
            while (n < n3) {
                if (nArray[n] != 0) {
                    this.columnNames[n2] = resultSetMetaData.getColumnLabel(n + 1);
                    ++n2;
                }
                ++n;
            }
            if (this.rows != null) {
                n = 0;
                while (n < this.rows.size()) {
                    ArrayList arrayList = (ArrayList)this.rows.get(n);
                    arrayList.clear();
                    ++n;
                }
                this.rows.clear();
            }
            switch (nArray[0]) {
                case 91: 
                case 92: 
                case 93: {
                    this.isTimeSeries = true;
                    break;
                }
                default: {
                    this.isTimeSeries = false;
                    break;
                }
            }
            while (resultSet.next()) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                n = 0;
                while (n < n3) {
                    object = resultSet.getObject(n + 1);
                    switch (nArray[n]) {
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: {
                            arrayList.add(object);
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            arrayList.add(new Long(((Date)object).getTime()));
                            break;
                        }
                        case 0: {
                            break;
                        }
                        default: {
                            System.err.println("Unknown data");
                            nArray[n] = 0;
                        }
                    }
                    ++n;
                }
                this.rows.add(arrayList);
            }
            if (this.rows.size() == 0) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                n = 0;
                while (n < n3) {
                    if (nArray[n] != 0) {
                        arrayList.add(new Integer(0));
                    }
                    ++n;
                }
                this.rows.add(arrayList);
            }
            if (this.rows.size() < 1) {
                this.maxValue = 0.0;
                this.minValue = 0.0;
            } else {
                ArrayList arrayList = (ArrayList)this.rows.get(0);
                this.minValue = this.maxValue = ((Number)arrayList.get(1)).doubleValue();
                int n6 = 0;
                while (n6 < this.rows.size()) {
                    arrayList = (ArrayList)this.rows.get(n6);
                    n = 1;
                    while (n < n3) {
                        double d = ((Number)arrayList.get(n)).doubleValue();
                        if (d < this.minValue) {
                            this.minValue = d;
                        }
                        if (d > this.maxValue) {
                            this.maxValue = d;
                        }
                        ++n;
                    }
                    ++n6;
                }
            }
            this.fireDatasetChanged();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Number getXValue(int n, int n2) {
        ArrayList arrayList = (ArrayList)this.rows.get(n2);
        return (Number)arrayList.get(0);
    }

    public Number getYValue(int n, int n2) {
        ArrayList arrayList = (ArrayList)this.rows.get(n2);
        return (Number)arrayList.get(n + 1);
    }

    public int getItemCount(int n) {
        return this.rows.size();
    }

    public int getSeriesCount() {
        return this.columnNames.length;
    }

    public String getSeriesName(int n) {
        if (n < this.columnNames.length && this.columnNames[n] != null) {
            return this.columnNames[n];
        }
        return "";
    }

    public int getLegendItemCount() {
        return this.getSeriesCount();
    }

    public String[] getLegendItemLabels() {
        return this.columnNames;
    }

    public Number getMinimumRangeValue() {
        return new Double(this.minValue);
    }

    public Number getMaximumRangeValue() {
        return new Double(this.maxValue);
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            System.err.println("JdbcXYDataset: swallowing exception.");
        }
    }

    public Range getValueRange() {
        return new Range(this.minValue, this.maxValue);
    }
}

