/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.chart.Spacer;
import org.jfree.chart.event.TitleChangeEvent;
import org.jfree.chart.event.TitleChangeListener;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.VerticalAlignment;
import org.jfree.util.ObjectUtils;

public abstract class Title
implements Cloneable,
Serializable {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int WEST = 3;
    public static final int CENTER = 4;
    public static final int MIDDLE = 4;
    public static final RectangleEdge DEFAULT_POSITION = RectangleEdge.TOP;
    public static final HorizontalAlignment DEFAULT_HORIZONTAL_ALIGNMENT = HorizontalAlignment.CENTER;
    public static final VerticalAlignment DEFAULT_VERTICAL_ALIGNMENT = VerticalAlignment.CENTER;
    public static final Spacer DEFAULT_SPACER = new Spacer(0, 0.01, 0.15, 0.01, 0.15);
    private RectangleEdge position;
    private HorizontalAlignment horizontalAlignment;
    private VerticalAlignment verticalAlignment;
    private Spacer spacer;
    private transient EventListenerList listenerList;
    private boolean notify;
    static /* synthetic */ Class class$org$jfree$chart$event$TitleChangeListener;

    protected Title() {
        this(DEFAULT_POSITION, DEFAULT_HORIZONTAL_ALIGNMENT, DEFAULT_VERTICAL_ALIGNMENT, DEFAULT_SPACER);
    }

    protected Title(RectangleEdge rectangleEdge, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this(rectangleEdge, horizontalAlignment, verticalAlignment, DEFAULT_SPACER);
    }

    protected Title(RectangleEdge rectangleEdge, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, Spacer spacer) {
        if (rectangleEdge == null) {
            throw new IllegalArgumentException("Argument 'position' cannot be null.");
        }
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("Argument 'horizontalAlignment' cannot be null.");
        }
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("Argument 'verticalAlignment' cannot be null.");
        }
        if (spacer == null) {
            throw new IllegalArgumentException("Argument 'spacer' cannot be null.");
        }
        this.position = rectangleEdge;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.spacer = spacer;
        this.listenerList = new EventListenerList();
        this.notify = true;
    }

    public RectangleEdge getPosition() {
        return this.position;
    }

    public void setPosition(RectangleEdge rectangleEdge) {
        if (this.position != rectangleEdge) {
            this.position = rectangleEdge;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("Argument 'alignment' cannot be null.");
        }
        if (this.horizontalAlignment != horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("Argument 'alignment' cannot be null.");
        }
        if (this.verticalAlignment != verticalAlignment) {
            this.verticalAlignment = verticalAlignment;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public Spacer getSpacer() {
        return this.spacer;
    }

    public void setSpacer(Spacer spacer) {
        if (spacer == null) {
            throw new NullPointerException("AbstractTitle.setSpacer(..): Null argument.");
        }
        if (!this.spacer.equals(spacer)) {
            this.spacer = spacer;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean bl) {
        this.notify = bl;
    }

    public abstract float getPreferredWidth(Graphics2D var1, float var2);

    public abstract float getPreferredHeight(Graphics2D var1, float var2);

    public abstract void draw(Graphics2D var1, Rectangle2D var2);

    public Object clone() {
        Title title = null;
        try {
            title = (Title)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("AbstractTitle.clone()");
        }
        title.listenerList = new EventListenerList();
        return title;
    }

    public void addChangeListener(TitleChangeListener titleChangeListener) {
        this.listenerList.add(class$org$jfree$chart$event$TitleChangeListener == null ? (class$org$jfree$chart$event$TitleChangeListener = Title.class$("org.jfree.chart.event.TitleChangeListener")) : class$org$jfree$chart$event$TitleChangeListener, titleChangeListener);
    }

    public void removeChangeListener(TitleChangeListener titleChangeListener) {
        this.listenerList.remove(class$org$jfree$chart$event$TitleChangeListener == null ? (class$org$jfree$chart$event$TitleChangeListener = Title.class$("org.jfree.chart.event.TitleChangeListener")) : class$org$jfree$chart$event$TitleChangeListener, titleChangeListener);
    }

    protected void notifyListeners(TitleChangeEvent titleChangeEvent) {
        if (this.notify) {
            Object[] objectArray = this.listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$org$jfree$chart$event$TitleChangeListener == null ? Title.class$("org.jfree.chart.event.TitleChangeListener") : class$org$jfree$chart$event$TitleChangeListener)) {
                    ((TitleChangeListener)objectArray[n + 1]).titleChanged(titleChangeEvent);
                }
                n -= 2;
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Title) {
            Title title = (Title)object;
            if (this.position != title.position) {
                return false;
            }
            if (this.horizontalAlignment != title.horizontalAlignment) {
                return false;
            }
            if (this.verticalAlignment != title.verticalAlignment) {
                return false;
            }
            if (!ObjectUtils.equal((Object)this.spacer, (Object)title.spacer)) {
                return false;
            }
            return this.notify == title.notify;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

