/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer3D;
import org.jfree.chart.renderer.CategoryItemRendererState;
import org.jfree.chart.renderer.RangeType;
import org.jfree.data.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class StackedBarRenderer3D
extends BarRenderer3D
implements Cloneable,
PublicCloneable,
Serializable {
    public StackedBarRenderer3D() {
    }

    public StackedBarRenderer3D(double d, double d2) {
        super(d, d2);
    }

    public RangeType getRangeType() {
        return RangeType.STACKED;
    }

    protected void calculateBarWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, Integer n, CategoryItemRendererState categoryItemRendererState) {
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n);
        CategoryDataset categoryDataset = this.getDataset(categoryPlot, n);
        if (categoryDataset != null) {
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            double d = 0.0;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            double d2 = d * this.getMaxBarWidth();
            int n2 = categoryDataset.getColumnCount();
            double d3 = 0.0;
            if (n2 > 1) {
                d3 = categoryAxis.getCategoryMargin();
            }
            double d4 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d3);
            if (n2 > 0) {
                categoryItemRendererState.setBarWidth(Math.min(d4 / (double)n2, d2));
            } else {
                categoryItemRendererState.setBarWidth(Math.min(d4, d2));
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        EntityCollection entityCollection;
        double d;
        double d2;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d3 = number.doubleValue();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d4 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), double_, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n3 = 0;
        while (n3 < n) {
            Number number2 = categoryDataset.getValue(n3, n2);
            if (number2 != null) {
                double d7 = number2.doubleValue();
                if (d7 > 0.0) {
                    d5 += d7;
                } else {
                    d6 += d7;
                }
            }
            ++n3;
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        if (d3 > 0.0) {
            d2 = valueAxis.translateValueToJava2D(d5, double_, rectangleEdge);
            d = valueAxis.translateValueToJava2D(d5 + d3, double_, rectangleEdge);
        } else {
            d2 = valueAxis.translateValueToJava2D(d6, double_, rectangleEdge);
            d = valueAxis.translateValueToJava2D(d6 + d3, double_, rectangleEdge);
        }
        double d8 = Math.min(d2, d);
        double d9 = Math.max(Math.abs(d - d2), this.getMinimumBarLength());
        Rectangle2D.Double double_2 = null;
        double_2 = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d8, d4, d9, categoryItemRendererState.getBarWidth()) : new Rectangle2D.Double(d4, d8, categoryItemRendererState.getBarWidth(), d9);
        Paint paint = this.getItemPaint(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_2);
        double d10 = double_2.getMinX();
        double d11 = d10 + this.getXOffset();
        double d12 = double_2.getMaxX();
        double d13 = d12 + this.getXOffset();
        double d14 = double_2.getMinY() - this.getYOffset();
        double d15 = double_2.getMinY();
        double d16 = double_2.getMaxY() - this.getYOffset();
        double d17 = double_2.getMaxY();
        GeneralPath generalPath = null;
        GeneralPath generalPath2 = null;
        if (d3 > 0.0 || plotOrientation == PlotOrientation.VERTICAL) {
            generalPath = new GeneralPath();
            generalPath.moveTo((float)d12, (float)d17);
            generalPath.lineTo((float)d12, (float)d15);
            generalPath.lineTo((float)d13, (float)d14);
            generalPath.lineTo((float)d13, (float)d16);
            generalPath.closePath();
            if (paint instanceof Color) {
                graphics2D.setPaint(((Color)paint).darker());
            }
            graphics2D.fill(generalPath);
        }
        if (d3 > 0.0 || plotOrientation == PlotOrientation.HORIZONTAL) {
            generalPath2 = new GeneralPath();
            generalPath2.moveTo((float)d10, (float)d15);
            generalPath2.lineTo((float)d11, (float)d14);
            generalPath2.lineTo((float)d13, (float)d14);
            generalPath2.lineTo((float)d12, (float)d15);
            generalPath2.closePath();
            graphics2D.fill(generalPath2);
        }
        if (categoryItemRendererState.getBarWidth() > 3.0) {
            graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
            graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
            graphics2D.draw(double_2);
            if (generalPath != null) {
                graphics2D.draw(generalPath);
            }
            if (generalPath2 != null) {
                graphics2D.draw(generalPath2);
            }
        }
        if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null) {
            String string = null;
            CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
            if (categoryItemLabelGenerator != null) {
                string = categoryItemLabelGenerator.generateToolTip(categoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_2, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
            entityCollection.addEntity(categoryItemEntity);
        }
    }
}

