/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.CyclicNumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.DatasetChangeListener;
import org.jfree.data.DatasetGroup;
import org.jfree.data.XYDataset;

public class CyclicXYItemRenderer
extends StandardXYItemRenderer {
    public CyclicXYItemRenderer() {
    }

    public CyclicXYItemRenderer(int n) {
        super(n);
    }

    public CyclicXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator) {
        super(n, xYToolTipGenerator);
    }

    public CyclicXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(n, xYToolTipGenerator, xYURLGenerator);
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        double[] dArray;
        Object object;
        if (!this.getPlotLines() || !(valueAxis instanceof CyclicNumberAxis) && !(valueAxis2 instanceof CyclicNumberAxis) || n2 <= 0) {
            super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairInfo, n3);
            return;
        }
        Number number = xYDataset.getXValue(n, n2 - 1);
        Number number2 = xYDataset.getYValue(n, n2 - 1);
        if (number2 == null || number == null) {
            super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairInfo, n3);
            return;
        }
        Object object2 = new double[2];
        double[] dArray2 = new double[2];
        object2[0] = number.doubleValue();
        dArray2[0] = number2.doubleValue();
        number = xYDataset.getXValue(n, n2);
        number2 = xYDataset.getYValue(n, n2);
        if (number2 == null || number == null) {
            return;
        }
        object2[1] = number.doubleValue();
        dArray2[1] = number2.doubleValue();
        double d = Double.NaN;
        double d2 = Double.NaN;
        boolean bl = false;
        boolean bl2 = false;
        CyclicNumberAxis cyclicNumberAxis = null;
        CyclicNumberAxis cyclicNumberAxis2 = null;
        if (valueAxis instanceof CyclicNumberAxis) {
            cyclicNumberAxis = (CyclicNumberAxis)valueAxis;
            d = cyclicNumberAxis.getCycleBound();
            bl = cyclicNumberAxis.isBoundMappedToLastCycle();
            if (object2[0] != object2[1] && (d >= object2[0] && d <= object2[1] || d >= object2[1] && d <= object2[0])) {
                object = new double[3];
                dArray = new double[3];
                object[0] = object2[0];
                object[2] = object2[1];
                dArray[0] = dArray2[0];
                dArray[2] = dArray2[1];
                object[1] = d;
                dArray[1] = (dArray2[1] - dArray2[0]) * (d - object2[0]) / (object2[1] - object2[0]) + dArray2[0];
                object2 = object;
                dArray2 = dArray;
            }
        }
        if (valueAxis2 instanceof CyclicNumberAxis) {
            cyclicNumberAxis2 = (CyclicNumberAxis)valueAxis2;
            d2 = cyclicNumberAxis2.getCycleBound();
            bl2 = cyclicNumberAxis2.isBoundMappedToLastCycle();
            if (dArray2[0] != dArray2[1] && (d2 >= dArray2[0] && d2 <= dArray2[1] || d2 >= dArray2[1] && d2 <= dArray2[0])) {
                object = new double[((double[])object2).length + 1];
                dArray = new double[dArray2.length + 1];
                object[0] = object2[0];
                object[2] = object2[1];
                dArray[0] = dArray2[0];
                dArray[2] = dArray2[1];
                dArray[1] = d2;
                object[1] = (object2[1] - object2[0]) * (d2 - dArray2[0]) / (dArray2[1] - dArray2[0]) + object2[0];
                if (((double[])object2).length == 3) {
                    object[3] = object2[2];
                    dArray[3] = dArray2[2];
                }
                object2 = object;
                dArray2 = dArray;
            } else if (((double[])object2).length == 3 && dArray2[1] != dArray2[2] && (d2 >= dArray2[1] && d2 <= dArray2[2] || d2 >= dArray2[2] && d2 <= dArray2[1])) {
                object = new double[4];
                dArray = new double[4];
                object[0] = object2[0];
                object[1] = object2[1];
                object[3] = object2[2];
                dArray[0] = dArray2[0];
                dArray[1] = dArray2[1];
                dArray[3] = dArray2[2];
                dArray[2] = d2;
                object[2] = (object2[2] - object2[1]) * (d2 - dArray2[1]) / (dArray2[2] - dArray2[1]) + object2[1];
                object2 = object;
                dArray2 = dArray;
            }
        }
        if (((double[])object2).length == 2) {
            super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairInfo, n3);
            return;
        }
        object = new OverwriteDataSet((double[])object2, dArray2, xYDataset);
        if (cyclicNumberAxis != null) {
            if (d == object2[0]) {
                cyclicNumberAxis.setBoundMappedToLastCycle(object2[1] <= d);
            }
            if (d == object2[1]) {
                cyclicNumberAxis.setBoundMappedToLastCycle(object2[0] <= d);
            }
        }
        if (cyclicNumberAxis2 != null) {
            if (d2 == dArray2[0]) {
                cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[1] <= d2);
            }
            if (d2 == dArray2[1]) {
                cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[0] <= d2);
            }
        }
        super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, (XYDataset)object, n, 1, crosshairInfo, n3);
        if (cyclicNumberAxis != null) {
            if (d == object2[1]) {
                cyclicNumberAxis.setBoundMappedToLastCycle(object2[2] <= d);
            }
            if (d == object2[2]) {
                cyclicNumberAxis.setBoundMappedToLastCycle(object2[1] <= d);
            }
        }
        if (cyclicNumberAxis2 != null) {
            if (d2 == dArray2[1]) {
                cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[2] <= d2);
            }
            if (d2 == dArray2[2]) {
                cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[1] <= d2);
            }
        }
        super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, (XYDataset)object, n, 2, crosshairInfo, n3);
        if (((double[])object2).length == 4) {
            if (cyclicNumberAxis != null) {
                if (d == object2[2]) {
                    cyclicNumberAxis.setBoundMappedToLastCycle(object2[3] <= d);
                }
                if (d == object2[3]) {
                    cyclicNumberAxis.setBoundMappedToLastCycle(object2[2] <= d);
                }
            }
            if (cyclicNumberAxis2 != null) {
                if (d2 == dArray2[2]) {
                    cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[3] <= d2);
                }
                if (d2 == dArray2[3]) {
                    cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[2] <= d2);
                }
            }
            super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, (XYDataset)object, n, 3, crosshairInfo, n3);
        }
        if (cyclicNumberAxis != null) {
            cyclicNumberAxis.setBoundMappedToLastCycle(bl);
        }
        if (cyclicNumberAxis2 != null) {
            cyclicNumberAxis2.setBoundMappedToLastCycle(bl2);
        }
    }

    protected static class OverwriteDataSet
    implements XYDataset {
        protected XYDataset delegateSet;
        Double[] x;
        Double[] y;

        public OverwriteDataSet(double[] dArray, double[] dArray2, XYDataset xYDataset) {
            this.delegateSet = xYDataset;
            this.x = new Double[dArray.length];
            this.y = new Double[dArray2.length];
            int n = 0;
            while (n < dArray.length) {
                this.x[n] = new Double(dArray[n]);
                this.y[n] = new Double(dArray2[n]);
                ++n;
            }
        }

        public int getItemCount(int n) {
            return this.x.length;
        }

        public Number getXValue(int n, int n2) {
            return this.x[n2];
        }

        public Number getYValue(int n, int n2) {
            return this.y[n2];
        }

        public int getSeriesCount() {
            return this.delegateSet.getSeriesCount();
        }

        public String getSeriesName(int n) {
            return this.delegateSet.getSeriesName(n);
        }

        public void addChangeListener(DatasetChangeListener datasetChangeListener) {
        }

        public void removeChangeListener(DatasetChangeListener datasetChangeListener) {
        }

        public DatasetGroup getGroup() {
            return this.delegateSet.getGroup();
        }

        public void setGroup(DatasetGroup datasetGroup) {
        }
    }
}

