/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.DrawableLegendItem;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Legend;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.Spacer;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.event.LegendChangeEvent;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtils;

public class StandardLegend
extends Legend
implements Serializable {
    public static final Spacer DEFAULT_OUTER_GAP = new Spacer(1, 3.0, 3.0, 3.0, 3.0);
    public static final Spacer DEFAULT_INNER_GAP = new Spacer(1, 2.0, 2.0, 2.0, 2.0);
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke();
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    public static final Paint DEFAULT_BACKGROUND_PAINT = Color.white;
    public static final Font DEFAULT_TITLE_FONT = new Font("\u9ed1\u4f53", 1, 11);
    public static final Font DEFAULT_ITEM_FONT = new Font("\u9ed1\u4f53", 0, 10);
    private Spacer outerGap;
    private transient Stroke outlineStroke;
    private transient Paint outlinePaint;
    private transient Paint backgroundPaint;
    private Spacer innerGap;
    private String title = null;
    private Font titleFont;
    private Font itemFont;
    private transient Paint itemPaint;
    private boolean outlineShapes;
    private transient Stroke shapeOutlineStroke = new BasicStroke(0.5f);
    private transient Paint shapeOutlinePaint = Color.lightGray;
    private boolean displaySeriesShapes = false;
    private double shapeScaleX = 1.0;
    private double shapeScaleY = 1.0;
    private boolean displaySeriesLines = false;

    public StandardLegend() {
        this.outerGap = DEFAULT_OUTER_GAP;
        this.innerGap = DEFAULT_INNER_GAP;
        this.backgroundPaint = DEFAULT_BACKGROUND_PAINT;
        this.outlineStroke = DEFAULT_OUTLINE_STROKE;
        this.outlinePaint = DEFAULT_OUTLINE_PAINT;
        this.titleFont = DEFAULT_TITLE_FONT;
        this.itemFont = DEFAULT_ITEM_FONT;
        this.itemPaint = Color.black;
    }

    public StandardLegend(JFreeChart jFreeChart) {
        this();
    }

    public Spacer getOuterGap() {
        return this.outerGap;
    }

    public void setOuterGap(Spacer spacer) {
        if (spacer == null) {
            throw new NullPointerException("StandardLegend.setOuterGap(..): Null argument.");
        }
        this.outerGap = spacer;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Spacer getInnerGap() {
        return this.innerGap;
    }

    public void setInnerGap(Spacer spacer) {
        if (spacer == null) {
            throw new NullPointerException("StandardLegend.setInnerGap(..): Null argument.");
        }
        this.innerGap = spacer;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new NullPointerException("StandardLegend.setOutlineStroke(..): null argument");
        }
        this.outlineStroke = stroke;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        this.outlinePaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Font getItemFont() {
        return this.itemFont;
    }

    public void setItemFont(Font font) {
        this.itemFont = font;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getItemPaint() {
        return this.itemPaint;
    }

    public void setItemPaint(Paint paint) {
        this.itemPaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public boolean getOutlineShapes() {
        return this.outlineShapes;
    }

    public void setOutlineShapes(boolean bl) {
        this.outlineShapes = bl;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Stroke getShapeOutlineStroke() {
        return this.shapeOutlineStroke;
    }

    public void setShapeOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new NullPointerException("StandardLegend.setShapeOutlineStroke(..): null argument");
        }
        this.shapeOutlineStroke = stroke;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getShapeOutlinePaint() {
        return this.shapeOutlinePaint;
    }

    public void setShapeOutlinePaint(Paint paint) {
        this.shapeOutlinePaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public void setDisplaySeriesShapes(boolean bl) {
        this.displaySeriesShapes = bl;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public boolean getDisplaySeriesShapes() {
        return this.displaySeriesShapes;
    }

    public double getShapeScaleX() {
        return this.shapeScaleX;
    }

    public void setShapeScaleX(double d) {
        this.shapeScaleX = d;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public double getShapeScaleY() {
        return this.shapeScaleY;
    }

    public void setShapeScaleY(double d) {
        this.shapeScaleY = d;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public void setDisplaySeriesLines(boolean bl) {
        this.displaySeriesLines = bl;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public boolean getDisplaySeriesLines() {
        return this.displaySeriesLines;
    }

    public Rectangle2D draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        return this.draw(graphics2D, rectangle2D, (this.getAnchor() & 1) != 0, (this.getAnchor() & 2) != 0, chartRenderingInfo);
    }

    protected Rectangle2D draw(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl, boolean bl2, ChartRenderingInfo chartRenderingInfo) {
        LegendItemCollection legendItemCollection = this.getChart().getPlot().getLegendItems();
        if (legendItemCollection != null && legendItemCollection.getItemCount() > 0) {
            double d;
            double d2;
            DrawableLegendItem drawableLegendItem = null;
            Rectangle2D rectangle2D2 = new Rectangle2D.Double();
            double d3 = rectangle2D.getWidth();
            double d4 = rectangle2D.getHeight();
            Point2D.Double double_ = new Point2D.Double();
            DrawableLegendItem[] drawableLegendItemArray = new DrawableLegendItem[legendItemCollection.getItemCount()];
            if (bl) {
                d2 = rectangle2D.getX() + this.getOuterGap().getLeftSpace(d3);
                d = rectangle2D.getMaxX() + this.getOuterGap().getRightSpace(d3) - 1.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                boolean bl3 = true;
                if (this.title != null && !this.title.equals("")) {
                    graphics2D.setFont(this.getTitleFont());
                    LegendItem legendItem = new LegendItem(this.title, this.title, null, Color.black, DEFAULT_OUTLINE_PAINT, DEFAULT_OUTLINE_STROKE);
                    drawableLegendItem = this.createDrawableLegendItem(graphics2D, legendItem, d6, d8);
                    d7 = Math.max(d7, drawableLegendItem.getHeight());
                    d6 += drawableLegendItem.getWidth();
                }
                graphics2D.setFont(this.itemFont);
                int n = 0;
                while (n < legendItemCollection.getItemCount()) {
                    drawableLegendItemArray[n] = this.createDrawableLegendItem(graphics2D, legendItemCollection.get(n), d6, d8);
                    if (!bl3 && drawableLegendItemArray[n].getX() + drawableLegendItemArray[n].getWidth() + d2 > d) {
                        d5 = Math.max(d5, d6);
                        d6 = 0.0;
                        d8 += d7;
                        --n;
                        bl3 = true;
                    } else {
                        d7 = Math.max(d7, drawableLegendItemArray[n].getHeight());
                        d6 += drawableLegendItemArray[n].getWidth();
                        bl3 = false;
                    }
                    ++n;
                }
                d5 = Math.max(d5, d6);
                rectangle2D2 = new Rectangle2D.Double(0.0, 0.0, d5, d8 += d7);
                double d9 = bl2 ? rectangle2D.getMaxY() - d8 - this.getOuterGap().getBottomSpace(d4) : rectangle2D.getY() + this.getOuterGap().getTopSpace(d4);
                double d10 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - d5 / 2.0;
                double_ = new Point2D.Double(d10, d9);
            } else {
                d2 = 0.0;
                d = 0.0;
                if (this.title != null && !this.title.equals("")) {
                    graphics2D.setFont(this.getTitleFont());
                    LegendItem legendItem = new LegendItem(this.title, this.title, null, Color.black, DEFAULT_OUTLINE_PAINT, DEFAULT_OUTLINE_STROKE);
                    drawableLegendItem = this.createDrawableLegendItem(graphics2D, legendItem, 0.0, d2);
                    d2 += drawableLegendItem.getHeight();
                    d = Math.max(d, drawableLegendItem.getWidth());
                }
                graphics2D.setFont(this.itemFont);
                int n = 0;
                while (n < drawableLegendItemArray.length) {
                    drawableLegendItemArray[n] = this.createDrawableLegendItem(graphics2D, legendItemCollection.get(n), 0.0, d2);
                    d2 += drawableLegendItemArray[n].getHeight();
                    d = Math.max(d, drawableLegendItemArray[n].getWidth());
                    ++n;
                }
                rectangle2D2 = new Rectangle2D.Float(0.0f, 0.0f, (float)d, (float)d2);
                double d11 = bl2 ? rectangle2D.getMaxX() - d - this.getOuterGap().getRightSpace(d3) : rectangle2D.getX() + this.getOuterGap().getLeftSpace(d3);
                double d12 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - d2 / 2.0;
                double_ = new Point2D.Double(d11, d12);
            }
            graphics2D.translate(((Point2D)double_).getX(), ((Point2D)double_).getY());
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D2);
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.setStroke(this.outlineStroke);
            graphics2D.draw(rectangle2D2);
            if (drawableLegendItem != null) {
                graphics2D.setPaint(drawableLegendItem.getItem().getPaint());
                graphics2D.setPaint(this.itemPaint);
                graphics2D.setFont(this.getTitleFont());
                graphics2D.drawString(drawableLegendItem.getItem().getLabel(), (float)drawableLegendItem.getLabelPosition().getX(), (float)drawableLegendItem.getLabelPosition().getY());
            }
            EntityCollection entityCollection = null;
            if (chartRenderingInfo != null) {
                entityCollection = chartRenderingInfo.getEntityCollection();
            }
            int n = 0;
            while (n < drawableLegendItemArray.length) {
                graphics2D.setPaint(drawableLegendItemArray[n].getItem().getPaint());
                Shape shape = drawableLegendItemArray[n].getMarker();
                if (this.displaySeriesLines) {
                    graphics2D.setStroke(drawableLegendItemArray[n].getLineStroke());
                    graphics2D.draw(drawableLegendItemArray[n].getLine());
                    if (this.displaySeriesShapes) {
                        graphics2D.fill(shape);
                    }
                } else {
                    graphics2D.fill(shape);
                }
                if (this.getOutlineShapes()) {
                    graphics2D.setPaint(this.shapeOutlinePaint);
                    graphics2D.setStroke(this.shapeOutlineStroke);
                    graphics2D.draw(shape);
                }
                graphics2D.setPaint(this.itemPaint);
                graphics2D.setFont(this.itemFont);
                RefineryUtilities.drawAlignedString((String)drawableLegendItemArray[n].getItem().getLabel(), (Graphics2D)graphics2D, (float)((float)drawableLegendItemArray[n].getLabelPosition().getX()), (float)((float)drawableLegendItemArray[n].getLabelPosition().getY()), (TextAnchor)TextAnchor.CENTER_LEFT);
                if (entityCollection != null) {
                    Rectangle2D.Double double_2 = new Rectangle2D.Double(((Point2D)double_).getX() + drawableLegendItemArray[n].getX(), ((Point2D)double_).getY() + drawableLegendItemArray[n].getY(), drawableLegendItemArray[n].getWidth(), drawableLegendItemArray[n].getHeight());
                    LegendItemEntity legendItemEntity = new LegendItemEntity(double_2);
                    legendItemEntity.setSeriesIndex(n);
                    entityCollection.addEntity(legendItemEntity);
                }
                ++n;
            }
            graphics2D.translate(-((Point2D)double_).getX(), -((Point2D)double_).getY());
            if (bl) {
                double d13 = rectangle2D.getY();
                double d14 = bl2 ? d13 : d13 + rectangle2D2.getHeight() + this.getOuterGap().getBottomSpace(d4);
                return new Rectangle2D.Double(rectangle2D.getX(), d14, d3, d4 - rectangle2D2.getHeight() - this.getOuterGap().getTopSpace(d4) - this.getOuterGap().getBottomSpace(d4));
            }
            double d15 = bl2 ? rectangle2D.getX() : rectangle2D.getX() + rectangle2D2.getWidth() + this.getOuterGap().getLeftSpace(d3) + this.getOuterGap().getRightSpace(d3);
            return new Rectangle2D.Double(d15, rectangle2D.getY(), d3 - rectangle2D2.getWidth() - this.getOuterGap().getLeftSpace(d3) - this.getOuterGap().getRightSpace(d3), d4);
        }
        return rectangle2D;
    }

    private DrawableLegendItem createDrawableLegendItem(Graphics2D graphics2D, LegendItem legendItem, double d, double d2) {
        int n = 2;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        LineMetrics lineMetrics = fontMetrics.getLineMetrics(legendItem.getLabel(), graphics2D);
        float f = lineMetrics.getAscent();
        float f2 = f + lineMetrics.getDescent() + lineMetrics.getLeading();
        DrawableLegendItem drawableLegendItem = new DrawableLegendItem(legendItem);
        float f3 = (float)(d + (double)n + (double)(1.15f * f2));
        float f4 = (float)(d2 + (double)n + (double)(0.5f * f2));
        drawableLegendItem.setLabelPosition(new Point2D.Float(f3, f4));
        float f5 = (float)(drawableLegendItem.getLabelPosition().getX() - d + fontMetrics.getStringBounds(legendItem.getLabel(), graphics2D).getWidth() + 0.5 * (double)f);
        float f6 = (float)(2 * n) + f2;
        drawableLegendItem.setBounds(d, d2, f5, f6);
        float f7 = f2 * 0.7f;
        float f8 = (float)(d + (double)n + (double)(0.15f * f2));
        float f9 = (float)(d2 + (double)n + (double)(0.15f * f2));
        if (this.displaySeriesLines) {
            Line2D.Float float_ = new Line2D.Float(f8, f9 + f7 / 2.0f, f8 + f7 * 3.0f, f9 + f7 / 2.0f);
            drawableLegendItem.setLineStroke(legendItem.getStroke());
            drawableLegendItem.setLine(float_);
            drawableLegendItem.setBounds(drawableLegendItem.getX(), drawableLegendItem.getY(), drawableLegendItem.getWidth() + (double)(f7 * 2.0f), drawableLegendItem.getHeight());
            drawableLegendItem.setLabelPosition(new Point2D.Float(f3 + f7 * 2.0f, f4));
            if (this.displaySeriesShapes) {
                Shape shape = legendItem.getShape();
                AffineTransform affineTransform = AffineTransform.getScaleInstance(this.shapeScaleX, this.shapeScaleY);
                Shape shape2 = affineTransform.createTransformedShape(shape);
                AffineTransform affineTransform2 = AffineTransform.getTranslateInstance((double)f8 + (double)f7 * 1.5, f9 + f7 / 2.0f);
                Shape shape3 = affineTransform2.createTransformedShape(shape2);
                drawableLegendItem.setMarker(shape3);
            }
        } else if (this.displaySeriesShapes) {
            Shape shape = legendItem.getShape();
            AffineTransform affineTransform = AffineTransform.getScaleInstance(this.shapeScaleX, this.shapeScaleY);
            Shape shape4 = affineTransform.createTransformedShape(shape);
            AffineTransform affineTransform3 = AffineTransform.getTranslateInstance(f8 + f7 / 2.0f, f9 + f7 / 2.0f);
            Shape shape5 = affineTransform3.createTransformedShape(shape4);
            drawableLegendItem.setMarker(shape5);
        } else {
            drawableLegendItem.setMarker(new Rectangle2D.Float(f8, f9, f7, f7));
        }
        return drawableLegendItem;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof StandardLegend) {
            StandardLegend standardLegend = (StandardLegend)object;
            if (super.equals(object)) {
                if (!ObjectUtils.equal((Object)this.outerGap, (Object)standardLegend.outerGap)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.outlineStroke, (Object)standardLegend.outlineStroke)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.outlinePaint, (Object)standardLegend.outlinePaint)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.backgroundPaint, (Object)standardLegend.backgroundPaint)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.innerGap, (Object)standardLegend.innerGap)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.title, (Object)standardLegend.title)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.titleFont, (Object)standardLegend.titleFont)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.itemFont, (Object)standardLegend.itemFont)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.itemPaint, (Object)standardLegend.itemPaint)) {
                    return false;
                }
                if (this.outlineShapes != standardLegend.outlineShapes) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.shapeOutlineStroke, (Object)standardLegend.shapeOutlineStroke)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.shapeOutlinePaint, (Object)standardLegend.shapeOutlinePaint)) {
                    return false;
                }
                if (this.displaySeriesShapes == standardLegend.displaySeriesShapes) {
                    return true;
                }
            }
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke((Stroke)this.outlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.outlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.backgroundPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.itemPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.shapeOutlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.shapeOutlinePaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.outlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.backgroundPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.itemPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.shapeOutlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.shapeOutlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
    }
}

