### SCS0031 - LDAP Filter Injection
The dynamic value passed to the LDAP query should be validated.
#### Risk
If the user input is not properly filtered, a malicious user could extend the LDAP query.
#### Vulnerable Code
```cs
var searcher = new DirectorySearcher();
searcher.Filter = "(cn=" + input + ")";
```
#### Solution
Use proper encoder (`LdapFilterEncode` or `LdapDistinguishedNameEncode`) from [AntiXSS library](https://www.nuget.org/packages/AntiXSS/):
```cs
var searcher = new DirectorySearcher();
searcher.Filter = "(cn=" + Encoder.LdapFilterEncode(input) + ")";
```
#### References
[CWE-90: Improper Neutralization of Special Elements used in an LDAP Query ('LDAP Injection')](https://cwe.mitre.org/data/definitions/90.html)  
[WASC-29: LDAP Injection](http://projects.webappsec.org/w/page/13246947/LDAP%20Injection)  
[OWASP: LDAP Injection](https://www.owasp.org/index.php/LDAP_injection)  
[OWASP: LDAP Injection Prevention Cheat Sheet](https://www.owasp.org/index.php/LDAP_Injection_Prevention_Cheat_Sheet)  
[MSDN Blog - Security Tools: LDAP Injection and mitigation](https://blogs.msdn.microsoft.com/securitytools/2009/08/10/ldap-injection-and-mitigation/)  