### SCS0030 - Request validation is enabled only for pages (Configuration File)
The `requestValidationMode` which provides additional protection against [XSS](#SCS0029) is enabled only for pages, not for all HTTP requests in configuration file.
#### Risk
[XSS](#SCS0029)
#### Vulnerable Code
```xml
<system.web>
   ...
   <httpRuntime [..] requestValidationMode="2.0" [..]/>
   ...
</system.web>
```
#### Solution
```xml
<system.web>
   ...
   <httpRuntime [..] requestValidationMode="4.5" [..]/>
   ...
</system.web>
```
#### References
[CWE-554: ASP.NET Misconfiguration: Not Using Input Validation Framework](https://cwe.mitre.org/data/definitions/554.html)  
[MSDN: pages Element (ASP.NET Settings Schema)](https://msdn.microsoft.com/en-us/library/950xf363(v=vs.100).aspx)  
[MSDN: Request Validation in ASP.NET](https://msdn.microsoft.com/en-us/library/hh882339(v=vs.110).aspx)  
[OWASP: ASP.NET Request Validation](https://www.owasp.org/index.php/ASP.NET_Request_Validation)  
[MSDN: RequestValidationMode Property](https://msdn.microsoft.com/en-us/library/system.web.configuration.httpruntimesection.requestvalidationmode(v=vs.110).aspx)  
See [XSS](#SCS0029) references.  