### SCS0023 - View State Not Encrypted
The `viewStateEncryptionMode` is not set to `Always` in configuration file.
#### Risk
Web Forms controls use hidden base64 encoded fields to store state information. If sensitive information is stored there it may be leaked to the client side.
#### Vulnerable Code
The default value is `Auto`:
```xml
<system.web>
   ...
   <pages [..] viewStateEncryptionMode="Auto" [..]/>
   ...
</system.web>
```
or
```xml
<system.web>
   ...
   <pages [..] viewStateEncryptionMode="Never" [..]/>
   ...
</system.web>
```
#### Solution
Explicitly set to `Always` and encrypt with with the .NET [machine key](https://msdn.microsoft.com/en-us/library/w8h3skw9(v=vs.100).aspx):
```xml
<system.web>
   ...
   <pages [..] viewStateEncryptionMode="Always" [..]/>
   ...
</system.web>
```
#### References
[CWE-554: ASP.NET Misconfiguration: Not Using Input Validation Framework](https://cwe.mitre.org/data/definitions/554.html)  
[MSDN: pages Element (ASP.NET Settings Schema)](https://msdn.microsoft.com/en-us/library/950xf363(v=vs.100).aspx)  
[MSDN: ViewStateEncryptionMode Property](https://msdn.microsoft.com/en-us/library/system.web.configuration.pagessection.viewstateencryptionmode(v=vs.100).aspx)  
[MSDN: machineKey Element (ASP.NET Settings Schema)](https://msdn.microsoft.com/en-us/library/w8h3skw9(v=vs.100).aspx)  
