### SCS0019 - OutputCache Conflict
Caching conflicts with authorization.
#### Risk
Having the annotation [OutputCache] will disable the annotation [Authorize] for the requests following the first one.
#### Vulnerable Code
```cs
[Authorize]
public class AdminController : Controller
{
    [OutputCache]
    public ActionResult Index()
    {
        return View();
    }
}
```
#### Solution
Remove the caching:
```cs
[Authorize]
public class AdminController : Controller
{
    public ActionResult Index()
    {
        return View();
    }
}
```
#### References
[CWE-524: Use of Cache Containing Sensitive Information](https://cwe.mitre.org/data/definitions/524.html)  
[Improving Performance with Output Caching](https://docs.microsoft.com/en-us/aspnet/mvc/overview/older-versions-1/controllers-and-routing/improving-performance-with-output-caching-cs)  