### SCS0012 - Controller method is potentially vulnerable to authorization bypass

Neither the annotation [Authorize], nor [AllowAnonymous] is present.

#### Risk

The endpoint is potentially accessible to not authorized users. If it contains sensitive information, like log files for example, it may lead to privilege escalation. The warning may be ignored/suppressed if the application is using other authorization checks. It is possible to [customize](#external-configuration-files) the [rule](https://github.com/security-code-scan/security-code-scan/blob/6541aa9c52e856b2ce9da7d5916d8358760373da/SecurityCodeScan/Config/Main.yml#L2500) and register the additional attributes.

#### Vulnerable Code

```cs
public class AccountController : Controller
{
   public ActionResult Login()
   {
   }

   [Authorize]
   public ActionResult Logout()
   {
   }
}
```
#### Solution

```cs
[Authorize]
public class AccountController : Controller
{
    [AllowAnonymous]
    public ActionResult Login()
    {
    }

    public ActionResult Logout()
    {
    }
}
```

#### References
[CWE-284: Improper Access Control](https://cwe.mitre.org/data/definitions/284.html)  
[Access control vulnerabilities and privilege escalation](https://portswigger.net/web-security/access-control)  
[Simple authorization in ASP.NET Core](https://docs.microsoft.com/en-us/aspnet/core/security/authorization/simple?view=aspnetcore-3.1)  