### SCS0005 - Weak Random Number Generator
The random numbers generated could be predicted.
#### Risk
The use of a predictable random value can lead to vulnerabilities when used in certain security critical contexts.
#### Vulnerable Code
```cs
var rnd = new Random();
byte[] buffer = new byte[16];
rnd.GetBytes(buffer);
return BitConverter.ToString(buffer);
```
#### Solution
```cs
using System.Security.Cryptography;
var rnd = RandomNumberGenerator.Create();
```
#### References
[CWE-338: Use of Cryptographically Weak Pseudo-Random Number Generator (PRNG)](https://cwe.mitre.org/data/definitions/338.html)  
[OWASP: Insecure Randomness](https://www.owasp.org/index.php/Insecure_Randomness)  
