﻿// Copyright (c) Microsoft.  All Rights Reserved.  Licensed under the Apache License, Version 2.0.  See License.txt in the project root for license information.

namespace Analyzer.Utilities
{
    // IMPORTANT: Keep this file sorted alphabetically.
    internal static class WellKnownTypeNames
    {
        public const string MicrosoftAspNetCoreAntiforgeryIAntiforgery = "Microsoft.AspNetCore.Antiforgery.IAntiforgery";
        public const string MicrosoftAspNetCoreHttpCookieOptions = "Microsoft.AspNetCore.Http.CookieOptions";
        public const string MicrosoftAspNetCoreHttpInternalResponseCookies = "Microsoft.AspNetCore.Http.Internal.ResponseCookies";
        public const string MicrosoftAspNetCoreHttpIResponseCookies = "Microsoft.AspNetCore.Http.IResponseCookies";
        public const string MicrosoftAspNetCoreMvcController = "Microsoft.AspNetCore.Mvc.Controller";
        public const string MicrosoftAspNetCoreMvcControllerAttribute = "Microsoft.AspNetCore.Mvc.ControllerAttribute";
        public const string MicrosoftAspNetCoreMvcControllerBase = "Microsoft.AspNetCore.Mvc.ControllerBase";
        public const string MicrosoftAspNetCoreMvcFiltersAuthorizationFilterContext = "Microsoft.AspNetCore.Mvc.Filters.AuthorizationFilterContext";
        public const string MicrosoftAspNetCoreMvcFiltersFilterCollection = "Microsoft.AspNetCore.Mvc.Filters.FilterCollection";
        public const string MicrosoftAspNetCoreMvcFiltersIAsyncAuthorizationFilter = "Microsoft.AspNetCore.Mvc.Filters.IAsyncAuthorizationFilter";
        public const string MicrosoftAspNetCoreMvcFiltersIAuthorizationFilter = "Microsoft.AspNetCore.Mvc.Filters.IAuthorizationFilter";
        public const string MicrosoftAspNetCoreMvcFiltersIFilterMetadata = "Microsoft.AspNetCore.Mvc.Filters.IFilterMetadata";
        public const string MicrosoftAspNetCoreMvcFromServicesAttribute = "Microsoft.AspNetCore.Mvc.FromServicesAttribute";
        public const string MicrosoftAspNetCoreMvcHttpDeleteAttribute = "Microsoft.AspNetCore.Mvc.HttpDeleteAttribute";
        public const string MicrosoftAspNetCoreMvcHttpGetAttribute = "Microsoft.AspNetCore.Mvc.HttpGetAttribute";
        public const string MicrosoftAspNetCoreMvcHttpHeadAttribute = "Microsoft.AspNetCore.Mvc.HttpHeadAttribute";
        public const string MicrosoftAspNetCoreMvcHttpOptionsAttribute = "Microsoft.AspNetCore.Mvc.HttpOptionsAttribute";
        public const string MicrosoftAspNetCoreMvcHttpPatchAttribute = "Microsoft.AspNetCore.Mvc.HttpPatchAttribute";
        public const string MicrosoftAspNetCoreMvcHttpPostAttribute = "Microsoft.AspNetCore.Mvc.HttpPostAttribute";
        public const string MicrosoftAspNetCoreMvcHttpPutAttribute = "Microsoft.AspNetCore.Mvc.HttpPutAttribute";
        public const string MicrosoftAspNetCoreMvcNonActionAttribute = "Microsoft.AspNetCore.Mvc.NonActionAttribute";
        public const string MicrosoftAspNetCoreMvcNonControllerAttribute = "Microsoft.AspNetCore.Mvc.NonControllerAttribute";
        public const string MicrosoftAspNetCoreMvcRouteAttribute = "Microsoft.AspNetCore.Mvc.RouteAttribute";
        public const string MicrosoftAspNetCoreMvcRoutingHttpMethodAttribute = "Microsoft.AspNetCore.Mvc.Routing.HttpMethodAttribute";
        public const string MicrosoftAspNetCoreRazorHostingRazorCompiledItemAttribute = "Microsoft.AspNetCore.Razor.Hosting.RazorCompiledItemAttribute";
        public const string MicrosoftCodeAnalysisCompilation = "Microsoft.CodeAnalysis.Compilation";
        public const string MicrosoftCodeAnalysisCSharpCSharpCompilation = "Microsoft.CodeAnalysis.CSharp.CSharpCompilation";
        public const string MicrosoftCodeAnalysisCSharpCSharpExtensions = "Microsoft.CodeAnalysis.CSharp.CSharpExtensions";
        public const string MicrosoftCodeAnalysisCSharpExtensions = "Microsoft.CodeAnalysis.CSharpExtensions";
        public const string MicrosoftCodeAnalysisDiagnostic = "Microsoft.CodeAnalysis.Diagnostic";
        public const string MicrosoftCodeAnalysisDiagnosticDescriptor = "Microsoft.CodeAnalysis.DiagnosticDescriptor";
        public const string MicrosoftCodeAnalysisDiagnosticsAnalysisContext = "Microsoft.CodeAnalysis.Diagnostics.AnalysisContext";
        public const string MicrosoftCodeAnalysisDiagnosticsCodeBlockAnalysisContext = "Microsoft.CodeAnalysis.Diagnostics.CodeBlockAnalysisContext";
        public const string MicrosoftCodeAnalysisDiagnosticsCodeBlockStartAnalysisContext1 = "Microsoft.CodeAnalysis.Diagnostics.CodeBlockStartAnalysisContext`1";
        public const string MicrosoftCodeAnalysisDiagnosticsCompilationEndAnalysisContext = "Microsoft.CodeAnalysis.Diagnostics.CompilationAnalysisContext";
        public const string MicrosoftCodeAnalysisDiagnosticsCompilationStartAnalysisContext = "Microsoft.CodeAnalysis.Diagnostics.CompilationStartAnalysisContext";
        public const string MicrosoftCodeAnalysisDiagnosticsDiagnosticAnalyzer = "Microsoft.CodeAnalysis.Diagnostics.DiagnosticAnalyzer";
        public const string MicrosoftCodeAnalysisDiagnosticsDiagnosticAnalyzerAttribute = "Microsoft.CodeAnalysis.Diagnostics.DiagnosticAnalyzerAttribute";
        public const string MicrosoftCodeAnalysisDiagnosticsGeneratedCodeAnalysisFlags = "Microsoft.CodeAnalysis.Diagnostics.GeneratedCodeAnalysisFlags";
        public const string MicrosoftCodeAnalysisDiagnosticsOperationAnalysisContext = "Microsoft.CodeAnalysis.Diagnostics.OperationAnalysisContext";
        public const string MicrosoftCodeAnalysisDiagnosticsOperationBlockAnalysisContext = "Microsoft.CodeAnalysis.Diagnostics.OperationBlockAnalysisContext";
        public const string MicrosoftCodeAnalysisDiagnosticsOperationBlockStartAnalysisContext = "Microsoft.CodeAnalysis.Diagnostics.OperationBlockStartAnalysisContext";
        public const string MicrosoftCodeAnalysisDiagnosticsSemanticModelAnalysisContext = "Microsoft.CodeAnalysis.Diagnostics.SemanticModelAnalysisContext";
        public const string MicrosoftCodeAnalysisDiagnosticsSymbolAnalysisContext = "Microsoft.CodeAnalysis.Diagnostics.SymbolAnalysisContext";
        public const string MicrosoftCodeAnalysisDiagnosticsSyntaxNodeAnalysisContext = "Microsoft.CodeAnalysis.Diagnostics.SyntaxNodeAnalysisContext";
        public const string MicrosoftCodeAnalysisDiagnosticsSyntaxTreeAnalysisContext = "Microsoft.CodeAnalysis.Diagnostics.SyntaxTreeAnalysisContext";
        public const string MicrosoftCodeAnalysisHostMefMefConstruction = "Microsoft.CodeAnalysis.Host.Mef.MefConstruction";
        public const string MicrosoftCodeAnalysisLocalizableString = "Microsoft.CodeAnalysis.LocalizableString";
        public const string MicrosoftCodeAnalysisLocalizableResourceString = "Microsoft.CodeAnalysis.LocalizableResourceString";
        public const string MicrosoftCodeAnalysisSharedCollectionsTemporaryArrayExtensions = "Microsoft.CodeAnalysis.Shared.Collections.TemporaryArrayExtensions";
        public const string MicrosoftCodeAnalysisSymbolKind = "Microsoft.CodeAnalysis.SymbolKind";
        public const string MicrosoftCodeAnalysisVisualBasicVisualBasicCompilation = "Microsoft.CodeAnalysis.VisualBasic.VisualBasicCompilation";
        public const string MicrosoftCodeAnalysisVisualBasicVisualBasicExtensions = "Microsoft.CodeAnalysis.VisualBasic.VisualBasicExtensions";
        public const string MicrosoftCodeAnalysisVisualBasicExtensions = "Microsoft.CodeAnalysis.VisualBasicExtensions";
        public const string MicrosoftEntityFrameworkCoreEntityFrameworkQueryableExtensions = "Microsoft.EntityFrameworkCore.EntityFrameworkQueryableExtensions";
        public const string MicrosoftEntityFrameworkCoreRelationalQueryableExtensions = "Microsoft.EntityFrameworkCore.RelationalQueryableExtensions";
        public const string MicrosoftSecurityApplicationAntiXss = "Microsoft.Security.Application.AntiXss";
        public const string MicrosoftSecurityApplicationAntiXssEncoder = "Microsoft.Security.Application.AntiXssEncoder";
        public const string MicrosoftSecurityApplicationEncoder = "Microsoft.Security.Application.Encoder";
        public const string MicrosoftSecurityApplicationUnicodeCharacterEncoder = "Microsoft.Security.Application.UnicodeCharacterEncoder";
        public const string MicrosoftVisualBasicDevicesComputerInfo = "Microsoft.VisualBasic.Devices.ComputerInfo";
        public const string MicrosoftVisualStudioTestToolsUnitTestingAssert = "Microsoft.VisualStudio.TestTools.UnitTesting.Assert";
        public const string MicrosoftVisualStudioTestToolsUnitTestingCollectionAssert = "Microsoft.VisualStudio.TestTools.UnitTesting.CollectionAssert";
        public const string MicrosoftVisualStudioTestToolsUnitTestingDataTestMethodAttribute = "Microsoft.VisualStudio.TestTools.UnitTesting.DataTestMethodAttribute";
        public const string MicrosoftVisualStudioTestToolsUnitTestingExpectedExceptionAttribute = "Microsoft.VisualStudio.TestTools.UnitTesting.ExpectedExceptionAttribute";
        public const string MicrosoftVisualStudioTestToolsUnitTestingStringAssert = "Microsoft.VisualStudio.TestTools.UnitTesting.StringAssert";
        public const string MicrosoftVisualStudioTestToolsUnitTestingTestCleanupAttribute = "Microsoft.VisualStudio.TestTools.UnitTesting.TestCleanupAttribute";
        public const string MicrosoftVisualStudioTestToolsUnitTestingTestInitializeAttribute = "Microsoft.VisualStudio.TestTools.UnitTesting.TestInitializeAttribute";
        public const string MicrosoftVisualStudioTestToolsUnitTestingTestMethodAttribute = "Microsoft.VisualStudio.TestTools.UnitTesting.TestMethodAttribute";
        public const string MicrosoftWindowsAzureStorageCloudStorageAccount = "Microsoft.WindowsAzure.Storage.CloudStorageAccount";
        public const string MicrosoftWindowsAzureStorageSharedAccessProtocol = "Microsoft.WindowsAzure.Storage.SharedAccessProtocol";
        public const string NewtonsoftJsonJsonConvert = "Newtonsoft.Json.JsonConvert";
        public const string NewtonsoftJsonJsonIgnoreAttribute = "Newtonsoft.Json.JsonIgnoreAttribute";
        public const string NewtonsoftJsonJsonSerializer = "Newtonsoft.Json.JsonSerializer";
        public const string NewtonsoftJsonJsonSerializerSettings = "Newtonsoft.Json.JsonSerializerSettings";
        public const string NewtonsoftJsonTypeNameHandling = "Newtonsoft.Json.TypeNameHandling";
        public const string NUnitFrameworkAssert = "NUnit.Framework.Assert";
        public const string NUnitFrameworkOneTimeSetUpAttribute = "NUnit.Framework.OneTimeSetUpAttribute";
        public const string NUnitFrameworkOneTimeTearDownAttribute = "NUnit.Framework.OneTimeTearDownAttribute";
        public const string NUnitFrameworkSetUpAttribute = "NUnit.Framework.SetUpAttribute";
        public const string NUnitFrameworkTearDownAttribute = "NUnit.Framework.TearDownAttribute";
        public const string NUnitFrameworkTestAttribute = "NUnit.Framework.TestAttribute";
        public const string NUnitFrameworkTestCaseAttribute = "NUnit.Framework.TestCaseAttribute";
        public const string NUnitFrameworkTestCaseSourceAttribute = "NUnit.Framework.TestCaseSourceAttribute";
        public const string NUnitFrameworkTheoryAttribute = "NUnit.Framework.TheoryAttribute";
        public const string RoslynUtilitiesNonDefaultableAttribute = "Roslyn.Utilities.NonDefaultableAttribute";
        public const string SystemActivator = "System.Activator";
        public const string SystemAppContext = "System.AppContext";
        public const string SystemAppDomain = "System.AppDomain";
        public const string SystemArgumentException = "System.ArgumentException";
        public const string SystemAttribute = "System.Attribute";
        public const string SystemAttributeTargets = "System.AttributeTargets";
        public const string SystemAttributeUsageAttribute = "System.AttributeUsageAttribute";
        public const string SystemBoolean = "System.Boolean";
        public const string SystemBuffersMemoryManager1 = "System.Buffers.MemoryManager`1";
        public const string SystemByte = "System.Byte";
        public const string SystemChar = "System.Char";
        public const string SystemCLSCompliantAttribute = "System.CLSCompliantAttribute";
        public const string SystemCodeDomCompilerGeneratedCodeAttribute = "System.CodeDom.Compiler.GeneratedCodeAttribute";
        public const string SystemCollectionsConcurrentConcurrentBag1 = "System.Collections.Concurrent.ConcurrentBag`1";
        public const string SystemCollectionsConcurrentConcurrentDictionary2 = "System.Collections.Concurrent.ConcurrentDictionary`2";
        public const string SystemCollectionsConcurrentConcurrentQueue1 = "System.Collections.Concurrent.ConcurrentQueue`1";
        public const string SystemCollectionsConcurrentConcurrentStack1 = "System.Collections.Concurrent.ConcurrentStack`1";
        public const string SystemCollectionsGenericDictionary2 = "System.Collections.Generic.Dictionary`2";
        public const string SystemCollectionsGenericHashSet1 = "System.Collections.Generic.HashSet`1";
        public const string SystemCollectionsGenericICollection1 = "System.Collections.Generic.ICollection`1";
        public const string SystemCollectionsGenericIEnumerable1 = "System.Collections.Generic.IEnumerable`1";
        public const string SystemCollectionsGenericIEnumerator1 = "System.Collections.Generic.IEnumerator`1";
        public const string SystemCollectionsGenericIEqualityComparer1 = "System.Collections.Generic.IEqualityComparer`1";
        public const string SystemCollectionsGenericIList1 = "System.Collections.Generic.IList`1";
        public const string SystemCollectionsGenericIReadOnlyCollection1 = "System.Collections.Generic.IReadOnlyCollection`1";
        public const string SystemCollectionsGenericIReadOnlyList1 = "System.Collections.Generic.IReadOnlyList`1";
        public const string SystemCollectionsGenericKeyNotFoundException = "System.Collections.Generic.KeyNotFoundException";
        public const string SystemCollectionsGenericList1 = "System.Collections.Generic.List`1";
        public const string SystemCollectionsICollection = "System.Collections.ICollection";
        public const string SystemCollectionsIEnumerable = "System.Collections.IEnumerable";
        public const string SystemCollectionsIEnumerator = "System.Collections.IEnumerator";
        public const string SystemCollectionsIHashCodeProvider = "System.Collections.IHashCodeProvider";
        public const string SystemCollectionsIList = "System.Collections.IList";
        public const string SystemCollectionsImmutableIImmutableDictionary2 = "System.Collections.Immutable.IImmutableDictionary`2";
        public const string SystemCollectionsImmutableIImmutableList1 = "System.Collections.Immutable.IImmutableList`1";
        public const string SystemCollectionsImmutableIImmutableQueue1 = "System.Collections.Immutable.IImmutableQueue`1";
        public const string SystemCollectionsImmutableIImmutableSet1 = "System.Collections.Immutable.IImmutableSet`1";
        public const string SystemCollectionsImmutableIImmutableStack1 = "System.Collections.Immutable.IImmutableStack`1";
        public const string SystemCollectionsImmutableImmutableArray1 = "System.Collections.Immutable.ImmutableArray`1";
        public const string SystemCollectionsImmutableImmutableDictionary = "System.Collections.Immutable.ImmutableDictionary";
        public const string SystemCollectionsImmutableImmutableDictionary2 = "System.Collections.Immutable.ImmutableDictionary`2";
        public const string SystemCollectionsImmutableImmutableHashSet = "System.Collections.Immutable.ImmutableHashSet";
        public const string SystemCollectionsImmutableImmutableHashSet1 = "System.Collections.Immutable.ImmutableHashSet`1";
        public const string SystemCollectionsImmutableImmutableList1 = "System.Collections.Immutable.ImmutableList`1";
        public const string SystemCollectionsImmutableImmutableSortedDictionary2 = "System.Collections.Immutable.ImmutableSortedDictionary`2";
        public const string SystemCollectionsImmutableImmutableSortedSet1 = "System.Collections.Immutable.ImmutableSortedSet`1";
        public const string SystemCollectionsSpecializedNameValueCollection = "System.Collections.Specialized.NameValueCollection";
        public const string SystemCollectionsObjectModelReadOnlyCollection1 = "System.Collections.ObjectModel.ReadOnlyCollection`1";
        public const string SystemCollectionsObjectModelReadOnlyDictionary2 = "System.Collections.ObjectModel.ReadOnlyDictionary`2";
        public const string SystemCollectionsObjectModelReadOnlyObservableCollection1 = "System.Collections.ObjectModel.ReadOnlyObservableCollection`1";
        public const string SystemComponentModelComponent = "System.ComponentModel.Component";
        public const string SystemComponentModelCompositionExportAttribute = "System.ComponentModel.Composition.ExportAttribute";
        public const string SystemComponentModelCompositionImportingConstructorAttribute = "System.ComponentModel.Composition.ImportingConstructorAttribute";
        public const string SystemComponentModelCompositionInheritedExportAttribute = "System.ComponentModel.Composition.InheritedExportAttribute";
        public const string SystemComponentModelDesignerAttribute = "System.ComponentModel.DesignerAttribute";
        public const string SystemComponentModelDesignerCategoryAttribute = "System.ComponentModel.DesignerCategoryAttribute";
        public const string SystemComponentModelLocalizableAttribute = "System.ComponentModel.LocalizableAttribute";
        public const string SystemCompositionExportAttribute = "System.Composition.ExportAttribute";
        public const string SystemCompositionImportingConstructorAttribute = "System.Composition.ImportingConstructorAttribute";
        public const string SystemConfigurationConfigurationSection = "System.Configuration.ConfigurationSection";
        public const string SystemConfigurationIConfigurationSectionHandler = "System.Configuration.IConfigurationSectionHandler";
        public const string SystemConsole = "System.Console";
        public const string SystemConvert = "System.Convert";
        public const string SystemDataDataRow = "System.Data.DataRow";
        public const string SystemDataDataSet = "System.Data.DataSet";
        public const string SystemDataDataTable = "System.Data.DataTable";
        public const string SystemDataDataViewManager = "System.Data.DataViewManager";
        public const string SystemDataEntityDbSet1 = "System.Data.Entity.DbSet`1";
        public const string SystemDataEntityQueryableExtensions = "System.Data.Entity.QueryableExtensions";
        public const string SystemDataIDataAdapter = "System.Data.IDataAdapter";
        public const string SystemDataIDbCommand = "System.Data.IDbCommand";
        public const string SystemDataOdbcOdbcParameter = "System.Data.Odbc.OdbcParameter";
        public const string SystemDataOleDbOleDbParameter = "System.Data.OleDb.OleDbParameter";
        public const string SystemDataSqlClientSqlParameter = "System.Data.SqlClient.SqlParameter";
        public const string SystemDataTypedTableBase1 = "System.Data.TypedTableBase`1";
        public const string SystemDateTime = "System.DateTime";
        public const string SystemDateTimeOffset = "System.DateTimeOffset";
        public const string SystemDecimal = "System.Decimal";
        public const string SystemDiagnosticsCodeAnalysisNotNullAttribute = "System.Diagnostics.CodeAnalysis.NotNullAttribute";
        public const string SystemDiagnosticContractsContract = "System.Diagnostics.Contracts.Contract";
        public const string SystemDiagnosticsConditionalAttribute = "System.Diagnostics.ConditionalAttribute";
        public const string SystemDiagnosticsContractsPureAttribute = "System.Diagnostics.Contracts.PureAttribute";
        public const string SystemDiagnosticsDebug = "System.Diagnostics.Debug";
        public const string SystemDiagnosticsDebuggerNonUserCode = "System.Diagnostics.DebuggerNonUserCodeAttribute";
        public const string SystemDiagnosticsDebuggerTypeProxyAttribute = "System.Diagnostics.DebuggerTypeProxyAttribute";
        public const string SystemDiagnosticsProcess = "System.Diagnostics.Process";
        public const string SystemDiagnosticsProcessStartInfo = "System.Diagnostics.ProcessStartInfo";
        public const string SystemDiagnosticsTraceListener = "System.Diagnostics.TraceListener";
        public const string SystemDiagnosticsTracingEventSource = "System.Diagnostics.Tracing.EventSource";
        public const string SystemDirectoryDirectoryEntry = "System.DirectoryServices.DirectoryEntry";
        public const string SystemDirectoryServicesActiveDirectoryADSearcher = "System.DirectoryServices.ActiveDirectory.ADSearcher";
        public const string SystemDirectoryServicesDirectorySearcher = "System.DirectoryServices.DirectorySearcher";
        public const string SystemDouble = "System.Double";
        public const string SystemEnvironment = "System.Environment";
        public const string SystemEventArgs = "System.EventArgs";
        public const string SystemEventHandler1 = "System.EventHandler`1";
        public const string SystemException = "System.Exception";
        public const string SystemExecutionEngineException = "System.ExecutionEngineException";
        public const string SystemFlagsAttribute = "System.FlagsAttribute";
        public const string SystemGC = "System.GC";
        public const string SystemGlobalizationCultureInfo = "System.Globalization.CultureInfo";
        public const string SystemGuid = "System.Guid";
        public const string SystemIAsyncDisposable = "System.IAsyncDisposable";
        public const string SystemIComparable = "System.IComparable";
        public const string SystemIComparable1 = "System.IComparable`1";
        public const string SystemIDisposable = "System.IDisposable";
        public const string SystemIEquatable1 = "System.IEquatable`1";
        public const string SystemIFormatProvider = "System.IFormatProvider";
        public const string SystemIndex = "System.Index";
        public const string SystemInt16 = "System.Int16";
        public const string SystemInt32 = "System.Int32";
        public const string SystemInt64 = "System.Int64";
        public const string SystemInvalidOperationException = "System.InvalidOperationException";
        public const string SystemIOCompressionZipArchiveEntry = "System.IO.Compression.ZipArchiveEntry";
        public const string SystemIOCompressionZipFileExtensions = "System.IO.Compression.ZipFileExtensions";
        public const string SystemIODirectory = "System.IO.Directory";
        public const string SystemIODirectoryInfo = "System.IO.DirectoryInfo";
        public const string SystemIOFile = "System.IO.File";
        public const string SystemIOFileInfo = "System.IO.FileInfo";
        public const string SystemIOFileStream = "System.IO.FileStream";
        public const string SystemIOLogLogStore = "System.IO.Log.LogStore";
        public const string SystemIOPath = "System.IO.Path";
        public const string SystemIOStream = "System.IO.Stream";
        public const string SystemIOStringReader = "System.IO.StringReader";
        public const string SystemIOUnmanagedMemoryStream = "System.IO.UnmanagedMemoryStream";
        public const string SystemIProgress1 = "System.IProgress`1";
        public const string SystemLinqEnumerable = "System.Linq.Enumerable";
        public const string SystemLinqExpressionsExpression1 = "System.Linq.Expressions.Expression`1";
        public const string SystemLinqQueryable = "System.Linq.Queryable";
        public const string SystemMarshalByRefObject = "System.MarshalByRefObject";
        public const string SystemMemory1 = "System.Memory`1";
        public const string SystemNetHttpHttpClient = "System.Net.Http.HttpClient";
        public const string SystemNetHttpHttpClientHandler = "System.Net.Http.HttpClientHandler";
        public const string SystemNetHttpWinHttpHandler = "System.Net.Http.WinHttpHandler";
        public const string SystemNetSecurityProtocolType = "System.Net.SecurityProtocolType";
        public const string SystemNetSecurityRemoteCertificateValidationCallback = "System.Net.Security.RemoteCertificateValidationCallback";
        public const string SystemNetSecuritySslPolicyErrors = "System.Net.Security.SslPolicyErrors";
        public const string SystemNetServicePointManager = "System.Net.ServicePointManager";
        public const string SystemNonSerializedAttribute = "System.NonSerializedAttribute";
        public const string SystemNotImplementedException = "System.NotImplementedException";
        public const string SystemNotSupportedException = "System.NotSupportedException";
        public const string SystemNullable1 = "System.Nullable`1";
        public const string SystemNumber = "System.Number";
        public const string SystemObject = "System.Object";
        public const string SystemObsoleteAttribute = "System.ObsoleteAttribute";
        public const string SystemOperatingSystem = "System.OperatingSystem";
        public const string SystemOutOfMemoryException = "System.OutOfMemoryException";
        public const string SystemPlatformNotSupportedException = "System.PlatformNotSupportedException";
        public const string SystemRandom = "System.Random";
        public const string SystemRange = "System.Range";
        public const string SystemReadOnlyMemory1 = "System.ReadOnlyMemory`1";
        public const string SystemReadOnlySpan1 = "System.ReadOnlySpan`1";
        public const string SystemReflectionAssembly = "System.Reflection.Assembly";
        public const string SystemReflectionAssemblyName = "System.Reflection.AssemblyName";
        public const string SystemReflectionAssemblyVersionAttribute = "System.Reflection.AssemblyVersionAttribute";
        public const string SystemReflectionMemberInfo = "System.Reflection.MemberInfo";
        public const string SystemReflectionParameterInfo = "System.Reflection.ParameterInfo";
        public const string SystemResourcesNeutralResourcesLanguageAttribute = "System.Resources.NeutralResourcesLanguageAttribute";
        public const string SystemResourcesResourceManager = "System.Resources.ResourceManager";
        public const string SystemRuntimeCompilerServicesCallerFilePathAttribute = "System.Runtime.CompilerServices.CallerFilePathAttribute";
        public const string SystemRuntimeCompilerServicesCallerLineNumberAttribute = "System.Runtime.CompilerServices.CallerLineNumberAttribute";
        public const string SystemRuntimeCompilerServicesCallerMemberNameAttribute = "System.Runtime.CompilerServices.CallerMemberNameAttribute";
        public const string SystemRuntimeCompilerServicesCompilerGeneratedAttribute = "System.Runtime.CompilerServices.CompilerGeneratedAttribute";
        public const string SystemRuntimeCompilerServicesConfiguredValueTaskAwaitable1 = "System.Runtime.CompilerServices.ConfiguredValueTaskAwaitable`1";
        public const string SystemRuntimeCompilerServicesICriticalNotifyCompletion = "System.Runtime.CompilerServices.ICriticalNotifyCompletion";
        public const string SystemRuntimeCompilerServicesINotifyCompletion = "System.Runtime.CompilerServices.INotifyCompletion";
        public const string SystemRuntimeCompilerServicesInternalsVisibleToAttribute = "System.Runtime.CompilerServices.InternalsVisibleToAttribute";
        public const string SystemRuntimeCompilerServicesRestrictedInternalsVisibleToAttribute = "System.Runtime.CompilerServices.RestrictedInternalsVisibleToAttribute";
        public const string SystemRuntimeCompilerServicesTypeForwardedToAttribute = "System.Runtime.CompilerServices.TypeForwardedToAttribute";
        public const string SystemRuntimeExceptionServicesHandleProcessCorruptedStateExceptionsAttribute = "System.Runtime.ExceptionServices.HandleProcessCorruptedStateExceptionsAttribute";
        public const string SystemRuntimeInteropServicesCharSet = "System.Runtime.InteropServices.CharSet";
        public const string SystemRuntimeInteropServicesCoClassAttribute = "System.Runtime.InteropServices.CoClassAttribute";
        public const string SystemRuntimeInteropServicesComSourceInterfacesAttribute = "System.Runtime.InteropServices.ComSourceInterfacesAttribute";
        public const string SystemRuntimeInteropServicesComVisibleAttribute = "System.Runtime.InteropServices.ComVisibleAttribute";
        public const string SystemRuntimeInteropServicesDefaultDllImportSearchPathsAttribute = "System.Runtime.InteropServices.DefaultDllImportSearchPathsAttribute";
        public const string SystemRuntimeInteropServicesDllImportAttribute = "System.Runtime.InteropServices.DllImportAttribute";
        public const string SystemRuntimeInteropServicesFieldOffsetAttribute = "System.Runtime.InteropServices.FieldOffsetAttribute";
        public const string SystemRuntimeInteropServicesGCHandle = "System.Runtime.InteropServices.GCHandle";
        public const string SystemRuntimeInteropServicesHandleRef = "System.Runtime.InteropServices.HandleRef";
        public const string SystemRuntimeInteropServicesMarshalAsAttribute = "System.Runtime.InteropServices.MarshalAsAttribute";
        public const string SystemRuntimeInteropServicesOSPlatform = "System.Runtime.InteropServices.OSPlatform";
        public const string SystemRuntimeInteropServicesOutAttribute = "System.Runtime.InteropServices.OutAttribute";
        public const string SystemRuntimeInteropServicesRuntimeInformation = "System.Runtime.InteropServices.RuntimeInformation";
        public const string SystemRuntimeInteropServicesSafeHandle = "System.Runtime.InteropServices.SafeHandle";
        public const string SystemRuntimeInteropServicesStructLayoutAttribute = "System.Runtime.InteropServices.StructLayoutAttribute";
        public const string SystemRuntimeInteropServicesUnmanagedType = "System.Runtime.InteropServices.UnmanagedType";
        public const string SystemRuntimeSerializationDataContractAttribute = "System.Runtime.Serialization.DataContractAttribute";
        public const string SystemRuntimeSerializationDataContractSerializer = "System.Runtime.Serialization.DataContractSerializer";
        public const string SystemRuntimeSerializationDataMemberAttribute = "System.Runtime.Serialization.DataMemberAttribute";
        public const string SystemRuntimeSerializationFormattersBinaryBinaryFormatter = "System.Runtime.Serialization.Formatters.Binary.BinaryFormatter";
        public const string SystemRuntimeSerializationFormattersSoapSoapFormatter = "System.Runtime.Serialization.Formatters.Soap.SoapFormatter";
        public const string SystemRuntimeSerializationIDeserializationCallback = "System.Runtime.Serialization.IDeserializationCallback";
        public const string SystemRuntimeSerializationIgnoreDataMemberAttribute = "System.Runtime.Serialization.IgnoreDataMemberAttribute";
        public const string SystemRuntimeSerializationISerializable = "System.Runtime.Serialization.ISerializable";
        public const string SystemRuntimeSerializationJsonDataContractJsonSerializer = "System.Runtime.Serialization.Json";
        public const string SystemRuntimeSerializationKnownTypeAttribute = "System.Runtime.Serialization.KnownTypeAttribute";
        public const string SystemRuntimeSerializationNetDataContractSerializer = "System.Runtime.Serialization.NetDataContractSerializer";
        public const string SystemRuntimeSerializationOnDeserializedAttribute = "System.Runtime.Serialization.OnDeserializedAttribute";
        public const string SystemRuntimeSerializationOnDeserializingAttribute = "System.Runtime.Serialization.OnDeserializingAttribute";
        public const string SystemRuntimeSerializationOnSerializedAttribute = "System.Runtime.Serialization.OnSerializedAttribute";
        public const string SystemRuntimeSerializationOnSerializingAttribute = "System.Runtime.Serialization.OnSerializingAttribute";
        public const string SystemRuntimeSerializationSerializationInfo = "System.Runtime.Serialization.SerializationInfo";
        public const string SystemRuntimeSerializationStreamingContext = "System.Runtime.Serialization.StreamingContext";
        public const string SystemSecurityAuthenticationSslProtocols = "System.Security.Authentication.SslProtocols";
        public const string SystemSecurityCryptographyAesCcm = "System.Security.Cryptography.AesCcm";
        public const string SystemSecurityCryptographyAesGcm = "System.Security.Cryptography.AesGcm";
        public const string SystemSecurityCryptographyAsymmetricAlgorithm = "System.Security.Cryptography.AsymmetricAlgorithm";
        public const string SystemSecurityCryptographyCipherMode = "System.Security.Cryptography.CipherMode";
        public const string SystemSecurityCryptographyCryptoConfig = "System.Security.Cryptography.CryptoConfig";
        public const string SystemSecurityCryptographyDES = "System.Security.Cryptography.DES";
        public const string SystemSecurityCryptographyDSA = "System.Security.Cryptography.DSA";
        public const string SystemSecurityCryptographyDSASignatureFormatter = "System.Security.Cryptography.DSASignatureFormatter";
        public const string SystemSecurityCryptographyHashAlgorithmName = "System.Security.Cryptography.HashAlgorithmName";
        public const string SystemSecurityCryptographyHMACMD5 = "System.Security.Cryptography.HMACMD5";
        public const string SystemSecurityCryptographyHMACRIPEMD160 = "System.Security.Cryptography.HMACRIPEMD160";
        public const string SystemSecurityCryptographyHMACSHA1 = "System.Security.Cryptography.HMACSHA1";
        public const string SystemSecurityCryptographyMD5 = "System.Security.Cryptography.MD5";
        public const string SystemSecurityCryptographyPasswordDeriveBytes = "System.Security.Cryptography.PasswordDeriveBytes";
        public const string SystemSecurityCryptographyRC2 = "System.Security.Cryptography.RC2";
        public const string SystemSecurityCryptographyRfc2898DeriveBytes = "System.Security.Cryptography.Rfc2898DeriveBytes";
        public const string SystemSecurityCryptographyRIPEMD160 = "System.Security.Cryptography.RIPEMD160";
        public const string SystemSecurityCryptographyRSA = "System.Security.Cryptography.RSA";
        public const string SystemSecurityCryptographySHA1 = "System.Security.Cryptography.SHA1";
        public const string SystemSecurityCryptographySymmetricAlgorithm = "System.Security.Cryptography.SymmetricAlgorithm";
        public const string SystemSecurityCryptographyTripleDES = "System.Security.Cryptography.TripleDES";
        public const string SystemSecurityCryptographyX509CertificatesStoreName = "System.Security.Cryptography.X509Certificates.StoreName";
        public const string SystemSecurityCryptographyX509CertificatesX509Certificate = "System.Security.Cryptography.X509Certificates.X509Certificate";
        public const string SystemSecurityCryptographyX509CertificatesX509Certificate2 = "System.Security.Cryptography.X509Certificates.X509Certificate2";
        public const string SystemSecurityCryptographyX509CertificatesX509Chain = "System.Security.Cryptography.X509Certificates.X509Chain";
        public const string SystemSecurityCryptographyX509CertificatesX509Store = "System.Security.Cryptography.X509Certificates.X509Store";
        public const string SystemSerializableAttribute = "System.SerializableAttribute";
        public const string SystemServiceModelMessageContractAttribute = "System.ServiceModel.MessageContractAttribute";
        public const string SystemServiceModelOperationContractAttribute = "System.ServiceModel.OperationContractAttribute";
        public const string SystemSingle = "System.Single";
        public const string SystemSpan1 = "System.Span`1";
        public const string SystemStackOverflowException = "System.StackOverflowException";
        public const string SystemString = "System.String";
        public const string SystemStringComparison = "System.StringComparison";
        public const string SystemSystemException = "System.SystemException";
        public const string SystemTextEncoding = "System.Text.Encoding";
        public const string SystemTextRegularExpressionsRegex = "System.Text.RegularExpressions.Regex";
        public const string SystemTextStringBuilder = "System.Text.StringBuilder";
        public const string SystemThreadingCancellationToken = "System.Threading.CancellationToken";
        public const string SystemThreadingInterlocked = "System.Threading.Interlocked";
        public const string SystemThreadingMonitor = "System.Threading.Monitor";
        public const string SystemThreadingSpinLock = "System.Threading.SpinLock";
        public const string SystemThreadingTasksTaskCompletionSource1 = "System.Threading.Tasks.TaskCompletionSource`1";
        public const string SystemThreadingTasksTask = "System.Threading.Tasks.Task";
        public const string SystemThreadingTasksTask1 = "System.Threading.Tasks.Task`1";
        public const string SystemThreadingTasksTaskCompletionSource = "System.Threading.Tasks.TaskCompletionSource";
        public const string SystemThreadingTasksTaskContinuationOptions = "System.Threading.Tasks.TaskContinuationOptions";
        public const string SystemThreadingTasksTaskCreationOptions = "System.Threading.Tasks.TaskCreationOptions";
        public const string SystemThreadingTasksTaskFactory = "System.Threading.Tasks.TaskFactory";
        public const string SystemThreadingTasksTaskScheduler = "System.Threading.Tasks.TaskScheduler";
        public const string SystemThreadingTasksValueTask = "System.Threading.Tasks.ValueTask";
        public const string SystemThreadingTasksValueTask1 = "System.Threading.Tasks.ValueTask`1";
        public const string SystemThreadingThread = "System.Threading.Thread";
        public const string SystemTimeSpan = "System.TimeSpan";
        public const string SystemType = "System.Type";
        public const string SystemUri = "System.Uri";
        public const string SystemWebConfigurationHttpRuntimeSection = "System.Web.Configuration.HttpRuntimeSection";
        public const string SystemWebHttpApplication = "System.Web.HttpApplication";
        public const string SystemWebHttpCookie = "System.Web.HttpCookie";
        public const string SystemWebHttpRequest = "System.Web.HttpRequest";
        public const string SystemWebHttpRequestBase = "System.Web.HttpRequestBase";
        public const string SystemWebHttpRequestWrapper = "System.Web.HttpRequestWrapper";
        public const string SystemWebHttpResponse = "System.Web.HttpResponse";
        public const string SystemWebHttpResponseBase = "System.Web.HttpResponseBase";
        public const string SystemWebHttpRouteAttribute = "System.Web.Http.RouteAttribute";
        public const string SystemWebHttpServerUtility = "System.Web.HttpServerUtility";
        public const string SystemWebHttpServerUtilityBase = "System.Web.HttpServerUtilityBase";
        public const string SystemWebHttpServerUtilityWrapper = "System.Web.HttpServerUtilityWrapper";
        public const string SystemWebHttpUtility = "System.Web.HttpUtility";
        public const string SystemWebMvcAcceptVerbsAttribute = "System.Web.Mvc.AcceptVerbsAttribute";
        public const string SystemWebMvcActionResult = "System.Web.Mvc.ActionResult";
        public const string SystemWebMvcChildActionOnlyAttribute = "System.Web.Mvc.ChildActionOnlyAttribute";
        public const string SystemWebMvcController = "System.Web.Mvc.Controller";
        public const string SystemWebMvcControllerBase = "System.Web.Mvc.ControllerBase";
        public const string SystemWebMvcHttpDeleteAttribute = "System.Web.Mvc.HttpDeleteAttribute";
        public const string SystemWebMvcHttpGetAttribute = "System.Web.Mvc.HttpGetAttribute";
        public const string SystemWebMvcHttpHeadAttribute = "System.Web.Mvc.HttpHeadAttribute";
        public const string SystemWebMvcHttpOptionsAttribute = "System.Web.Mvc.HttpOptionsAttribute";
        public const string SystemWebMvcHttpPatchAttribute = "System.Web.Mvc.HttpPatchAttribute";
        public const string SystemWebMvcHttpPostAttribute = "System.Web.Mvc.HttpPostAttribute";
        public const string SystemWebMvcHttpPutAttribute = "System.Web.Mvc.HttpPutAttribute";
        public const string SystemWebMvcHttpVerbs = "System.Web.Mvc.HttpVerbs";
        public const string SystemWebMvcNonActionAttribute = "System.Web.Mvc.NonActionAttribute";
        public const string SystemWebMvcValidateAntiForgeryTokenAttribute = "System.Web.Mvc.ValidateAntiForgeryTokenAttribute";
        public const string SystemWebMvcValidateInputAttribute = "System.Web.Mvc.ValidateInputAttribute";
        public const string SystemWebScriptSerializationJavaScriptSerializer = "System.Web.Script.Serialization.JavaScriptSerializer";
        public const string SystemWebScriptSerializationJavaScriptTypeResolver = "System.Web.Script.Serialization.JavaScriptTypeResolver";
        public const string SystemWebScriptSerializationSimpleTypeResolver = "System.Web.Script.Serialization.SimpleTypeResolver";
        public const string SystemWebSecurityAntiXssAntiXssEncoder = "System.Web.Security.AntiXss.AntiXssEncoder";
        public const string SystemWebSecurityAntiXssUnicodeCharacterEncoder = "System.Web.Security.AntiXss.UnicodeCharacterEncoder";
        public const string SystemWebServicesWebMethodAttribute = "System.Web.Services.WebMethodAttribute";
        public const string SystemWebUIAdaptersPageAdapter = "System.Web.UI.Adapters.PageAdapter";
        public const string SystemWebUIControl = "System.Web.UI.Control";
        public const string SystemWebUIDataBoundLiteralControl = "System.Web.UI.DataBoundLiteralControl";
        public const string SystemWebUIDesignerDataBoundLiteralControl = "System.Web.UI.DesignerDataBoundLiteralControl";
        public const string SystemWebUIHtmlControlsHtmlContainerControl = "System.Web.UI.HtmlControls.HtmlContainerControl";
        public const string SystemWebUIHtmlControlsHtmlInputControl = "System.Web.UI.HtmlControls.HtmlInputControl";
        public const string SystemWebUIHtmlControlsHtmlTitle = "System.Web.UI.HtmlControls.HtmlTitle";
        public const string SystemWebUIHtmlTextWriter = "System.Web.UI.HtmlTextWriter";
        public const string SystemWebUIIndexedString = "System.Web.UI.IndexedString";
        public const string SystemWebUIITextControl = "System.Web.UI.ITextControl";
        public const string SystemWebUILiteralControl = "System.Web.UI.LiteralControl";
        public const string SystemWebUILosFormatter = "System.Web.UI.LosFormatter";
        public const string SystemWebUIObjectStateFormatter = "System.Web.UI.ObjectStateFormatter";
        public const string SystemWebUIPage = "System.Web.UI.Page";
        public const string SystemWebUIPageTheme = "System.Web.UI.PageTheme";
        public const string SystemWebUIResourceBasedLiteralControl = "System.Web.UI.ResourceBasedLiteralControl";
        public const string SystemWebUISimplePropertyEntry = "System.Web.UI.SimplePropertyEntry";
        public const string SystemWebUIStateItem = "System.Web.UI.StateItem";
        public const string SystemWebUIStringPropertyBuilder = "System.Web.UI.StringPropertyBuilder";
        public const string SystemWebUITemplateBuilder = "System.Web.UI.TemplateBuilder";
        public const string SystemWebUITemplateControl = "System.Web.UI.TemplateControl";
        public const string SystemWebUITemplateParser = "System.Web.UI.TemplateParser";
        public const string SystemWebUIWebControlsBaseDataList = "System.Web.UI.WebControls.BaseDataList";
        public const string SystemWebUIWebControlsBaseValidator = "System.Web.UI.WebControls.BaseValidator";
        public const string SystemWebUIWebControlsBulletedList = "System.Web.UI.WebControls.BulletedList";
        public const string SystemWebUIWebControlsButton = "System.Web.UI.WebControls.Button";
        public const string SystemWebUIWebControlsButtonColumn = "System.Web.UI.WebControls.ButtonColumn";
        public const string SystemWebUIWebControlsButtonField = "System.Web.UI.WebControls.ButtonField";
        public const string SystemWebUIWebControlsCalendar = "System.Web.UI.WebControls.Calendar";
        public const string SystemWebUIWebControlsChangePassword = "System.Web.UI.WebControls.ChangePassword";
        public const string SystemWebUIWebControlsCheckBox = "System.Web.UI.WebControls.CheckBox";
        public const string SystemWebUIWebControlsCheckBoxField = "System.Web.UI.WebControls.CheckBoxField";
        public const string SystemWebUIWebControlsCommandEventArgs = "System.Web.UI.WebControls.CommandEventArgs";
        public const string SystemWebUIWebControlsCreateUserWizard = "System.Web.UI.WebControls.CreateUserWizard";
        public const string SystemWebUIWebControlsDataKey = "System.Web.UI.WebControls.DataKey";
        public const string SystemWebUIWebControlsDataList = "System.Web.UI.WebControls.DataList";
        public const string SystemWebUIWebControlsDetailsView = "System.Web.UI.WebControls.DetailsView";
        public const string SystemWebUIWebControlsDetailsViewInsertEventArgs = "System.Web.UI.WebControls.DetailsViewInsertEventArgs";
        public const string SystemWebUIWebControlsDetailsViewUpdateEventArgs = "System.Web.UI.WebControls.DetailsViewUpdateEventArgs";
        public const string SystemWebUIWebControlsFormView = "System.Web.UI.WebControls.FormView";
        public const string SystemWebUIWebControlsFormViewInsertEventArgs = "System.Web.UI.WebControls.FormViewInsertEventArgs";
        public const string SystemWebUIWebControlsFormViewUpdateEventArgs = "System.Web.UI.WebControls.FormViewUpdateEventArgs";
        public const string SystemWebUIWebControlsGridView = "System.Web.UI.WebControls.GridView";
        public const string SystemWebUIWebControlsHiddenField = "System.Web.UI.WebControls.HiddenField";
        public const string SystemWebUIWebControlsHyperLink = "System.Web.UI.WebControls.HyperLink";
        public const string SystemWebUIWebControlsHyperLinkColumn = "System.Web.UI.WebControls.HyperLinkColumn";
        public const string SystemWebUIWebControlsHyperLinkField = "System.Web.UI.WebControls.HyperLinkField";
        public const string SystemWebUIWebControlsImage = "System.Web.UI.WebControls.Image";
        public const string SystemWebUIWebControlsImageButton = "System.Web.UI.WebControls.ImageButton";
        public const string SystemWebUIWebControlsLabel = "System.Web.UI.WebControls.Label";
        public const string SystemWebUIWebControlsLinkButton = "System.Web.UI.WebControls.LinkButton";
        public const string SystemWebUIWebControlsListControl = "System.Web.UI.WebControls.ListControl";
        public const string SystemWebUIWebControlsListItem = "System.Web.UI.WebControls.ListItem";
        public const string SystemWebUIWebControlsLiteral = "System.Web.UI.WebControls.Literal";
        public const string SystemWebUIWebControlsLogin = "System.Web.UI.WebControls.Login";
        public const string SystemWebUIWebControlsMenu = "System.Web.UI.WebControls.Menu";
        public const string SystemWebUIWebControlsMenuItem = "System.Web.UI.WebControls.MenuItem";
        public const string SystemWebUIWebControlsMenuItemBinding = "System.Web.UI.WebControls.MenuItemBinding";
        public const string SystemWebUIWebControlsPasswordRecovery = "System.Web.UI.WebControls.PasswordRecovery";
        public const string SystemWebUIWebControlsQueryStringParameter = "System.Web.UI.WebControls.QueryStringParameter";
        public const string SystemWebUIWebControlsRadioButtonList = "System.Web.UI.WebControls.RadioButtonList";
        public const string SystemWebUIWebControlsRepeatInfo = "System.Web.UI.WebControls.RepeatInfo";
        public const string SystemWebUIWebControlsServerValidateEventArgs = "System.Web.UI.WebControls.ServerValidateEventArgs";
        public const string SystemWebUIWebControlsSqlDataSource = "System.Web.UI.WebControls.SqlDataSource";
        public const string SystemWebUIWebControlsTable = "System.Web.UI.WebControls.Table";
        public const string SystemWebUIWebControlsTableCell = "System.Web.UI.WebControls.TableCell";
        public const string SystemWebUIWebControlsTextBox = "System.Web.UI.WebControls.TextBox";
        public const string SystemWebUIWebControlsTreeNode = "System.Web.UI.WebControls.TreeNode";
        public const string SystemWebUIWebControlsTreeNodeBinding = "System.Web.UI.WebControls.TreeNodeBinding";
        public const string SystemWebUIWebControlsTreeView = "System.Web.UI.WebControls.TreeView";
        public const string SystemWebUIWebControlsUnit = "System.Web.UI.WebControls.Unit";
        public const string SystemWebUIWebControlsWebPartsAppearanceEditorPart = "System.Web.UI.WebControls.WebParts.AppearanceEditorPart";
        public const string SystemWebUIWebControlsWebPartsPersonalizationEntry = "System.Web.UI.WebControls.WebParts.PersonalizationEntry";
        public const string SystemWebUIWebControlsWebPartsWebPartCatalogAddVerb = "System.Web.UI.WebControls.WebParts.WebPartCatalogAddVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartCatalogCloseVerb = "System.Web.UI.WebControls.WebParts.WebPartCatalogCloseVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartCloseVerb = "System.Web.UI.WebControls.WebParts.WebPartCloseVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartConnectionsCancelVerb = "System.Web.UI.WebControls.WebParts.WebPartConnectionsCancelVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartConnectionsCloseVerb = "System.Web.UI.WebControls.WebParts.WebPartConnectionsCloseVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartConnectionsConfigureVerb = "System.Web.UI.WebControls.WebParts.WebPartConnectionsConfigureVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartConnectionsConnectVerb = "System.Web.UI.WebControls.WebParts.WebPartConnectionsConnectVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartConnectionsDisconnectVerb = "System.Web.UI.WebControls.WebParts.WebPartConnectionsDisconnectVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartConnectVerb = "System.Web.UI.WebControls.WebParts.WebPartConnectVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartDeleteVerb = "System.Web.UI.WebControls.WebParts.WebPartDeleteVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartEditorApplyVerb = "System.Web.UI.WebControls.WebParts.WebPartEditorApplyVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartEditorCancelVerb = "System.Web.UI.WebControls.WebParts.WebPartEditorCancelVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartEditorOKVerb = "System.Web.UI.WebControls.WebParts.WebPartEditorOKVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartEditVerb = "System.Web.UI.WebControls.WebParts.WebPartEditVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartExportVerb = "System.Web.UI.WebControls.WebParts.WebPartExportVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartHeaderCloseVerb = "System.Web.UI.WebControls.WebParts.WebPartHeaderCloseVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartHelpVerb = "System.Web.UI.WebControls.WebParts.WebPartHelpVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartMinimizeVerb = "System.Web.UI.WebControls.WebParts.WebPartMinimizeVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartRestoreVerb = "System.Web.UI.WebControls.WebParts.WebPartRestoreVerb";
        public const string SystemWebUIWebControlsWebPartsWebPartVerb = "System.Web.UI.WebControls.WebParts.WebPartVerb";
        public const string SystemWebUIWebControlsXmlDataSource = "System.Web.UI.WebControls.XmlDataSource";
        public const string SystemWebUIXPathBinder = "System.Web.UI.XPathBinder";
        public const string SystemWebUtilHttpEncoder = "System.Web.Util.HttpEncoder";
        public const string SystemWindowsAssemblyPart = "System.Windows.AssemblyPart";
        public const string SystemWindowsMarkupXamlReader = "System.Windows.Markup.XamlReader";
        public const string SystemXmlDtdProcessing = "System.Xml.DtdProcessing";
        public const string SystemXmlSchemaXmlSchema = "System.Xml.Schema.XmlSchema";
        public const string SystemXmlSchemaXmlSchemaCollection = "System.Xml.Schema.XmlSchemaCollection";
        public const string SystemXmlSchemaXmlSchemaXPath = "System.Xml.Schema.XmlSchemaXPath";
        public const string SystemXmlSerializationXmlAnyAttributeAttribute = "System.Xml.Serialization.XmlAnyAttributeAttribute";
        public const string SystemXmlSerializationXmlAnyElementAttribute = "System.Xml.Serialization.XmlAnyElementAttribute";
        public const string SystemXmlSerializationXmlArrayAttribute = "System.Xml.Serialization.XmlArrayAttribute";
        public const string SystemXmlSerializationXmlArrayItemAttribute = "System.Xml.Serialization.XmlArrayItemAttribute";
        public const string SystemXmlSerializationXmlAttributeAttribute = "System.Xml.Serialization.XmlAttributeAttribute";
        public const string SystemXmlSerializationXmlChoiceIdentifierAttribute = "System.Xml.Serialization.XmlChoiceIdentifierAttribute";
        public const string SystemXmlSerializationXmlElementAttribute = "System.Xml.Serialization.XmlElementAttribute";
        public const string SystemXmlSerializationXmlEnumAttribute = "System.Xml.Serialization.XmlEnumAttribute";
        public const string SystemXmlSerializationXmlIgnoreAttribute = "System.Xml.Serialization.XmlIgnoreAttribute";
        public const string SystemXmlSerializationXmlIncludeAttribute = "System.Xml.Serialization.XmlIncludeAttribute";
        public const string SystemXmlSerializationXmlRootAttribute = "System.Xml.Serialization.XmlRootAttribute";
        public const string SystemXmlSerializationXmlSerializer = "System.Xml.Serialization.XmlSerializer";
        public const string SystemXmlSerializationXmlTextAttribute = "System.Xml.Serialization.XmlTextAttribute";
        public const string SystemXmlSerializationXmlTypeAttribute = "System.Xml.Serialization.XmlTypeAttribute";
        public const string SystemXmlXmlAttribute = "System.Xml.XmlAttribute";
        public const string SystemXmlXmlDocument = "System.Xml.XmlDocument";
        public const string SystemXmlXmlDocumentFragment = "System.Xml.XmlDocumentFragment";
        public const string SystemXmlXmlElement = "System.Xml.XmlElement";
        public const string SystemXmlXmlEntity = "System.Xml.XmlEntity";
        public const string SystemXmlXmlNode = "System.Xml.XmlNode";
        public const string SystemXmlXmlNotation = "System.Xml.XmlNotation";
        public const string SystemXmlXmlReader = "System.Xml.XmlReader";
        public const string SystemXmlXmlReaderSettings = "System.Xml.XmlReaderSettings";
        public const string SystemXmlXmlResolver = "System.Xml.XmlResolver";
        public const string SystemXmlXmlSecureResolver = "System.Xml.XmlSecureResolver";
        public const string SystemXmlXmlTextReader = "System.Xml.XmlTextReader";
        public const string SystemXmlXmlTextWriter = "System.Xml.XmlTextWriter";
        public const string SystemXmlXmlValidatingReader = "System.Xml.XmlValidatingReader";
        public const string SystemXmlXmlWriter = "System.Xml.XmlWriter";
        public const string SystemXmlXPathXPathDocument = "System.Xml.XPath.XPathDocument";
        public const string SystemXmlXPathXPathExpression = "System.Xml.XPath.XPathExpression";
        public const string SystemXmlXPathXPathNavigator = "System.Xml.XPath.XPathNavigator";
        public const string SystemXmlXslXslCompiledTransform = "System.Xml.Xsl.XslCompiledTransform";
        public const string SystemXmlXslXslTransform = "System.Xml.Xsl.XslTransform";
        public const string SystemXmlXslXsltSettings = "System.Xml.Xsl.XsltSettings";
        public const string XunitAssert = "Xunit.Assert";
        public const string XunitFactAttribute = "Xunit.FactAttribute";
        public const string XunitTraitAttribute = "Xunit.TraitAttribute";
    }
}
