pub type SvgIcon = &'static str;

pub const FEATHER_SVG_HTML: SvgIcon = r#"
	<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
		stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-feather">
			<path d="M20.24 12.24a6 6 0 0 0-8.49-8.49L5 10.5V19h8.5z"></path>
			<line x1="16" y1="8" x2="2" y2="22"></line>
			<line x1="17.5" y1="15" x2="9" y2="15"></line>
	</svg>
"#;
pub const BOOK_SVG_HTML: SvgIcon = r#"
	<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
		stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-book">
		<path d="M4 19.5A2.5 2.5 0 0 1 6.5 17H20"></path>
		<path d="M6.5 2H20v20H6.5A2.5 2.5 0 0 1 4 19.5v-15A2.5 2.5 0 0 1 6.5 2z"></path>
	</svg>
"#;
pub const CLOCK_SVG_HTML: SvgIcon = r#"
	<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
		stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-clock">
		<circle cx="12" cy="12" r="10"></circle>
		<polyline points="12 6 12 12 16 14"></polyline>
	</svg>
"#;
pub const HELP_CIRCLE_SVG_HTML: SvgIcon = r#"
	<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
		stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-help-circle">
		<circle cx="12" cy="12" r="10"></circle>
		<path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"></path>
		<line x1="12" y1="17" x2="12.01" y2="17"></line>
	</svg>
"#;
pub const ARCHIVE_SVG_HTML: SvgIcon = r#"
	<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
		stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-archive">
		<polyline points="21 8 21 21 3 21 3 8"></polyline>
		<rect x="1" y="3" width="22" height="5"></rect>
		<line x1="10" y1="12" x2="14" y2="12"></line>
	</svg>
"#;
pub const HOME_SVG_HTML: SvgIcon = r#"
	<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
		stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-home">
		<path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
		<polyline points="9 22 9 12 15 12 15 22"></polyline>
	</svg>
"#;

pub const USER_SVG_HTML: SvgIcon = r#"
	<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
		stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user">
		<path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
		<circle cx="12" cy="7" r="4"></circle>
	</svg>
"#;

pub const USER_CIRCLE_SVH_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256">
	<rect width="256" height="256" fill="none" />
	<circle cx="128" cy="128" r="96" fill="none" stroke="currentColor" stroke-linecap="round"
		stroke-linejoin="round" stroke-width="16" />
	<circle cx="128" cy="120" r="40" fill="none" stroke="currentColor" stroke-linecap="round"
		stroke-linejoin="round" stroke-width="16" />
	<path d="M63.8,199.37a72,72,0,0,1,128.4,0" fill="none" stroke="currentColor"
		stroke-linecap="round" stroke-linejoin="round" stroke-width="16" />
</svg>
"#;

pub const BATTERY_CHARGING_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
	stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-battery-charging">
	<path d="M5 18H3a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h3.19M15 6h2a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2h-3.19"></path>
	<line x1="23" y1="13" x2="23" y2="11"></line>
	<polyline points="11 6 7 12 13 12 9 18"></polyline>
</svg>
"#;

pub const MOON_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
	stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-moon">
	<path d="M21 12.79A9 9 0 1 1 11.21 3 7 7 0 0 0 21 12.79z"></path>
</svg>
"#;

pub const SUN_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
	stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-sun">
	<circle cx="12" cy="12" r="5"></circle>
	<line x1="12" y1="1" x2="12" y2="3"></line>
	<line x1="12" y1="21" x2="12" y2="23"></line>
	<line x1="4.22" y1="4.22" x2="5.64" y2="5.64"></line>
	<line x1="18.36" y1="18.36" x2="19.78" y2="19.78"></line>
	<line x1="1" y1="12" x2="3" y2="12"></line>
	<line x1="21" y1="12" x2="23" y2="12"></line>
	<line x1="4.22" y1="19.78" x2="5.64" y2="18.36"></line>
	<line x1="18.36" y1="5.64" x2="19.78" y2="4.22"></line>
</svg>
"#;

pub const FINGERPRINT_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
	style="fill: currentColor;transform: ;msFilter:;">
	<path
		d="M5.962 17.674C7 19.331 7 20.567 7 22h2c0-1.521 0-3.244-1.343-5.389l-1.695 1.063zM16.504 3.387C13.977 1.91 7.55.926 4.281 4.305c-3.368 3.481-2.249 9.072.001 11.392.118.122.244.229.369.333.072.061.146.116.205.184l1.494-1.33a3.918 3.918 0 0 0-.419-.391c-.072-.06-.146-.119-.214-.188-1.66-1.711-2.506-6.017.001-8.608 2.525-2.611 8.068-1.579 9.777-.581 2.691 1.569 4.097 4.308 4.109 4.333l1.789-.895c-.065-.135-1.668-3.289-4.889-5.167z">
	</path>
	<path
		d="M9.34 12.822c-1.03-1.26-1.787-2.317-1.392-3.506.263-.785.813-1.325 1.637-1.604 1.224-.41 2.92-.16 4.04.601l1.123-1.654c-1.648-1.12-3.982-1.457-5.804-.841-1.408.476-2.435 1.495-2.892 2.866-.776 2.328.799 4.254 1.74 5.405.149.183.29.354.409.512C11 18.323 11 20.109 11 22h2c0-2.036 0-4.345-3.201-8.601a19.71 19.71 0 0 0-.459-.577zm5.791-3.344c1.835 1.764 3.034 4.447 3.889 8.701l1.961-.395c-.939-4.678-2.316-7.685-4.463-9.748l-1.387 1.442z">
	</path>
	<path
		d="m11.556 9.169-1.115 1.66c.027.019 2.711 1.88 3.801 5.724l1.924-.545c-1.299-4.582-4.476-6.749-4.61-6.839zm3.132 9.29c.21 1.168.312 2.326.312 3.541h2c0-1.335-.112-2.608-.343-3.895l-1.969.354z">
	</path>
</svg>
"#;

pub const KEY_1_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
	style="fill: currentColor;transform: ;msFilter:;">
	<path
		d="M3.433 17.325 3.079 19.8a1 1 0 0 0 1.131 1.131l2.475-.354C7.06 20.524 8 18 8 18s.472.405.665.466c.412.13.813-.274.948-.684L10 16.01s.577.292.786.335c.266.055.524-.109.707-.293a.988.988 0 0 0 .241-.391L12 14.01s.675.187.906.214c.263.03.519-.104.707-.293l1.138-1.137a5.502 5.502 0 0 0 5.581-1.338 5.507 5.507 0 0 0 0-7.778 5.507 5.507 0 0 0-7.778 0 5.5 5.5 0 0 0-1.338 5.581l-7.501 7.5a.994.994 0 0 0-.282.566zM18.504 5.506a2.919 2.919 0 0 1 0 4.122l-4.122-4.122a2.919 2.919 0 0 1 4.122 0z">
	</path>
</svg>
"#;

pub const KEY_2_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
	style="fill: currentColor;transform: ;msFilter:;">
	<path
		d="M7 17a5.007 5.007 0 0 0 4.898-4H14v2h2v-2h2v3h2v-3h1v-2h-9.102A5.007 5.007 0 0 0 7 7c-2.757 0-5 2.243-5 5s2.243 5 5 5zm0-8c1.654 0 3 1.346 3 3s-1.346 3-3 3-3-1.346-3-3 1.346-3 3-3z">
	</path>
</svg>
"#;

pub const YUBIKEY_SVG_HTML: SvgIcon = r#"
<svg viewBox="0 0 48 48" width="24" height="24" xmlns="http://www.w3.org/2000/svg" fill="currentColor">
	<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
	<g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
	<g id="SVGRepo_iconCarrier">
		<g id="Layer_2" data-name="Layer 2">
			<g id="invisible_box" data-name="invisible box">
				<rect width="48" height="48" fill="none"></rect>
			</g>
			<g id="Layer_7" data-name="Layer 7">
				<g>
					<path d="M46,13H36V9H2V39H36V35H46ZM32,35H6V13H32Zm10-4H36V29h2a2,2,0,0,0,0-4H36V23h2a2,2,0,0,0,0-4H36V17h6Z">
					</path>
					<path d="M22,16a8,8,0,1,0,8,8A8,8,0,0,0,22,16Zm0,12a4,4,0,1,1,4-4A4,4,0,0,1,22,28Z"></path>
					<circle cx="22" cy="24" r="2"></circle>
					<circle cx="10" cy="24" r="2"></circle>
				</g>
			</g>
		</g>
	</g>
</svg>
"#;

pub const LOGIN_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
	stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-log-in">
	<path d="M15 3h4a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2h-4"></path>
	<polyline points="10 17 15 12 10 7"></polyline>
	<line x1="15" y1="12" x2="3" y2="12"></line>
</svg>
"#;

pub const USER_PLUS_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
	stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user-plus">
	<path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
	<circle cx="8.5" cy="7" r="4"></circle>
	<line x1="20" y1="8" x2="20" y2="14"></line>
	<line x1="23" y1="11" x2="17" y2="11"></line>
</svg>
"#;

pub const GLOBE_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
	stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-globe">
	<circle cx="12" cy="12" r="10"></circle>
	<line x1="2" y1="12" x2="22" y2="12"></line>
	<path d="M12 2a15.3 15.3 0 0 1 4 10 15.3 15.3 0 0 1-4 10 15.3 15.3 0 0 1-4-10 15.3 15.3 0 0 1 4-10z"></path>
</svg>
"#;

pub const COPY_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
	stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-copy">
	<rect x="9" y="9" width="13" height="13" rx="2" ry="2"></rect>
	<path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"></path>
</svg>
"#;

pub const SEARCH_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
	stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search">
	<circle cx="11" cy="11" r="8"></circle>
	<line x1="21" y1="21" x2="16.65" y2="16.65"></line>
</svg>
"#;

pub const ALERT_TRIANGLE_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
	stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-alert-triangle">
	<path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"></path>
	<line x1="12" y1="9" x2="12" y2="13"></line>
	<line x1="12" y1="17" x2="12.01" y2="17"></line>
</svg>
"#;

pub const CHECK_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
	stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-check">
	<polyline points="20 6 9 17 4 12"></polyline>
</svg>
"#;

pub const INFO_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
	stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-info">
	<circle cx="12" cy="12" r="10"></circle>
	<line x1="12" y1="16" x2="12" y2="12"></line>
	<line x1="12" y1="8" x2="12.01" y2="8"></line>
</svg>
"#;

pub const ALERT_OCTAGON_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
	stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-alert-octagon">
	<polygon points="7.86 2 16.14 2 22 7.86 22 16.14 16.14 22 7.86 22 2 16.14 2 7.86 7.86 2"></polygon>
	<line x1="12" y1="8" x2="12" y2="12"></line>
	<line x1="12" y1="16" x2="12.01" y2="16"></line>
</svg>
"#;

pub const CHEVRON_UP_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
	stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-up">
	<polyline points="18 15 12 9 6 15"></polyline>
</svg>
"#;

pub const CHEVRON_DOWN_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
	stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down">
	<polyline points="6 9 12 15 18 9"></polyline>
</svg>
"#;

pub const GIT_MERGE_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256">
	<rect width="24" height="24" fill="none" />
	<circle cx="80" cy="200" r="24" fill="none" stroke="currentColor" stroke-linecap="round"
		stroke-linejoin="round" stroke-width="16" />
	<circle cx="80" cy="56" r="24" fill="none" stroke="currentColor" stroke-linecap="round"
		stroke-linejoin="round" stroke-width="16" />
	<circle cx="208" cy="144" r="24" fill="none" stroke="currentColor" stroke-linecap="round"
		stroke-linejoin="round" stroke-width="16" />
	<path d="M184,144H152a48,48,0,0,1-38.4-19.2L80,80v96" fill="none" stroke="currentColor"
		stroke-linecap="round" stroke-linejoin="round" stroke-width="16" />
</svg>"#;

pub const CLOSE_X_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256">
	<rect width="256" height="256" fill="none" />
	<line x1="200" y1="56" x2="56" y2="200" stroke="currentColor" stroke-linecap="round"
		stroke-linejoin="round" stroke-width="16" />
	<line x1="200" y1="200" x2="56" y2="56" stroke="currentColor" stroke-linecap="round"
		stroke-linejoin="round" stroke-width="16" />
</svg>
"#;

pub const PASSWORD_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256">
	<rect width="256" height="256" fill="none" />
	<line x1="40" y1="56" x2="40" y2="200" fill="none" stroke="currentColor" stroke-linecap="round"
		stroke-linejoin="round" stroke-width="16" />
	<line x1="104" y1="96" x2="104" y2="128" fill="none" stroke="currentColor" stroke-linecap="round"
		stroke-linejoin="round" stroke-width="16" />
	<line x1="73.57" y1="118.11" x2="104" y2="128" fill="none" stroke="currentColor"
		stroke-linecap="round" stroke-linejoin="round" stroke-width="16" />
	<line x1="85.19" y1="153.89" x2="104" y2="128" fill="none" stroke="currentColor"
		stroke-linecap="round" stroke-linejoin="round" stroke-width="16" />
	<line x1="122.81" y1="153.89" x2="104" y2="128" fill="none" stroke="currentColor"
		stroke-linecap="round" stroke-linejoin="round" stroke-width="16" />
	<line x1="134.43" y1="118.11" x2="104" y2="128" fill="none" stroke="currentColor"
		stroke-linecap="round" stroke-linejoin="round" stroke-width="16" />
	<line x1="200" y1="96" x2="200" y2="128" fill="none" stroke="currentColor" stroke-linecap="round"
		stroke-linejoin="round" stroke-width="16" />
	<line x1="169.57" y1="118.11" x2="200" y2="128" fill="none" stroke="currentColor"
		stroke-linecap="round" stroke-linejoin="round" stroke-width="16" />
	<line x1="181.19" y1="153.89" x2="200" y2="128" fill="none" stroke="currentColor"
		stroke-linecap="round" stroke-linejoin="round" stroke-width="16" />
	<line x1="218.81" y1="153.89" x2="200" y2="128" fill="none" stroke="currentColor"
		stroke-linecap="round" stroke-linejoin="round" stroke-width="16" />
	<line x1="230.43" y1="118.11" x2="200" y2="128" fill="none" stroke="currentColor"
		stroke-linecap="round" stroke-linejoin="round" stroke-width="16" />
</svg>
"#;

pub const LAYOUT_SVG_HTML: SvgIcon = r#"
<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256">
	<rect width="256" height="256" fill="none" />
	<line x1="104" y1="104" x2="104" y2="208" fill="none" stroke="currentColor" stroke-linecap="round"
		stroke-linejoin="round" stroke-width="16" />
	<line x1="32" y1="104" x2="224" y2="104" fill="none" stroke="currentColor" stroke-linecap="round"
		stroke-linejoin="round" stroke-width="16" />
	<rect x="32" y="48" width="192" height="160" rx="8" fill="none" stroke="currentColor"
		stroke-linecap="round" stroke-linejoin="round" stroke-width="16" />
</svg>
"#;
