# Password Encryption

## Why

TODO:

## How

For secure password storage [argon2](https://en.wikipedia.org/wiki/Argon2) will be used for encryption before storing user passwords in the database.

Flow looks something like this:

   1. Configuration is defined and stored in a secret file somewhere on the server. This file should not be source controlled.
      - The configuration requires a few fields:
         - Sitewide secret
            - This is a string generated from a secure psuedo random number generator
            - Use argon2 to hash this with user specific salt to create the salt used in argon2 hash of user password. This makes it so that if your database is compromised the attacker must also have access to local files to crack passwords from the database.
         - Number of iterations for argon2
            - This is an implementation of a concept called Key Strengthening/Stretching
            - If it takes 0.00001 seconds for your hash function to return, someone can attempt to brute forcing 100,000 passwords a second until they find a match. But if it takes 1 second for your hash function to spit out a result, it means brute forcing therefore takes 100,000 times longer to test each case.
            - In order to slow down the hashing function, we run the argon2 hash however many times specified in this field.
   2. Password hash request is recieved and computed for new user
      - The iteration and sitewide secret are read from the configuration file
      - The password is hashed using the formula: hash(hash(user_salt + site_secret) + password)
         - A new user specific salt is generated by a secure psuedo random number generator
         - The user specific salt and the sitewide hash are hashed together using argon2 to create the password salt
         - The user's password is hashed with the password salt to create the hashed password
   3. The hashed password is stored with the iterations, and user specific salt in a string and added to the database in the following string format: "iterations.user_salt.hashed_key"
   4. For verification of a user password the fields are split out from the database string and used to created a new hash using the user input. The out put byte array is then compared with the hashed key from the database to determine if access should be granted.
