# Action Planning

- [`chronicle`]
- [`action`]
- [`feature`]

Chronicles represent all the lore associated with a given date in time.

Being able to track and plan actions/tasks/routines is one of the most important features for me currently.

I think actions is still a good encompassing word for the concept I am trying to capture.

Actions have multiple dimensions to them.

Examples:

- `duration`
  - actions can occur over a period of time or in an instant
- `frequency`
  - actions can be taken yearly, monthly, daily, hourly, etc.
  - could be every Thursday and Sunday
  - could be the first day of every quarter of the year
  - could be a desired number of completions within a repeated time-frame
  - could use a time range since the last completion time
- `procedure`
  - a series of actions completed in a certain order or manner
- `routine`
  - a collection of actions taken on a recurring basis
- `contingent actions`
  - occurring or existing only if (certain circumstances) are the case; dependent on something else
- `outcome`
  - what is the result of an action taken, if there is one
  - positive/negatives -- pros/cons -- risk/reward
  - anticipated vs actual outcome (pros/cons)
  - confidence level in outcome before taking the action
- `category`
  - human actions tend to fall under general categories
    - wellbeing/rest
      - sleeping
      - napping
      - meditation
      - spa
    - health/bodily maintenance
      - strength training
      - cardio training
      - stretching
    - organization/inventory upkeep
      - keeping inventory
    - entertainment/enjoyment
      - gaming
      - sports
      - movies
      - social media
      - food/beverage
    - experiential/observational
      - bird watching
      - hiking
      - exploring
      - touring
      - traveling
    - skill work
      - programming
      - design
      - painting
      - drawing
      - sports
      - woodwork
    - learning
      - studying
      - lectures
      - school
      - educational content
        - books
        - videos
    - social
      - party
      - events
      - gatherings
      - holidays
    - financial
      - paying taxes
      - work
      - side-hustle
      - investing
      - real estate
  - can fall under more than one

In order to fully implement `action planning`, I think most of these concepts ought to be included.
