
***

# Creating a pull request

Thank you for taking the time to create a pull request in this repository! Please fill out this form before submitting your PR.

**Note:** you can change the language of the formatting if needed, but it must be valid syntax. Supported languages include: ASCIIDoc, Org mode, Markdown, WikiText, ReStructuredText, Creole, Pod, RDoc, Textile, and plain text. Be sure to change thw `markdown` tag to the appropriate language.

Provide a general summary of your changes in the Title above

```markdown
Your summary description (title) goes here
```

## Description

Describe your changes in detail

```markdown
Your issue description (body) goes here
```

## Related Issue

- [ ] This project only accepts pull requests related to open issues
- [ ] If suggesting a new feature or change, please discuss it in an issue first
- [ ] If fixing a bug, there should be an issue describing it with steps to reproduce
- [ ] Please link to the issue here:

```markdown
Link to the issue here, #__
```

## Motivation and Context

Why is this change required? What problem does it solve?

```markdown

```

## How Has This Been Tested?

- [ ] Please describe in detail how you tested your changes.
- [ ] Include details of your testing environment, and the tests you ran to.
- [ ] see how your change affects other areas of the code, etc.

## Screenshots (if appropriate):

Please include the screenshots inside your pull request as well as a local link (hard copy)

**Warning:** `.webp` and `.heif` images are not accepted. Please convert them to a different format (such as PNG, JPG, JPEG, JIF, GIF, TIF, etc.)

**Warning:** Images outside of `/.github/Pull_Requests/Queue/PR/` are not accepted, and will be removed from the PR within 24 hours if not fixed

```markdown
Remove this section, and only include the links if you use this section. Be sure to delete image fields that are not needed. Max screenshots per PR: 5. Also, if screenshots aren't necessary, please delete this entire section

![Example1](/.github/Pull_Requests/Queue/PR/Image.png)
![Example2](/.github/Pull_Requests/Queue/PR/Image.png)
![Example3](/.github/Pull_Requests/Queue/PR/Image.png)
![Example4](/.github/Pull_Requests/Queue/PR/Image.png)
![Example5](/.github/Pull_Requests/Queue/PR/Image.png)
```

## Types of changes

What types of changes does your code introduce? Put an `x` in all the boxes that apply:

- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to change)

## Checklist:

Go over all the following points, and put an `x` in all the boxes that apply.

If you're unsure about any of these, don't hesitate to ask. We're here to help!

- [ ] My source code (if source code is provided) follows the source code style of this project.
- [ ] My change requires a change to the documentation.
- [ ] My change does not delete necessary files
- [ ] I have updated the documentation accordingly.
- [ ] I have read the [**`CONTRIBUTING`**](/CONTRIBUTING.md) document in my spoken language, and understand the terms
- [ ] I have added tests to cover my changes.
- [ ] I have gone through all the steps, and have thoroughly read the instructions

***

<!-- Template info

Pull request template

Version 1 (2022, Thursday, May 19th at 5:47 pm PST)

File type: Markdown document (*.md *.mkd *.mdown *.markdown)

Line count (including blank lines and compiler line): 102

!-->
