
***

# tvOS version history

_This article is for history of Apples tvOS prior to [tvOS 9](https://github.com/seanpm2001/WacOS/wiki/tvOS-9/). For the full version history, including the [iOS 4](https://github.com/seanpm2001/WacOS/wiki/iOS-4/) to [iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/) releases, see [tvOS complete version history](https://github.com/seanpm2001/WacOS/wiki/tvOS-complete-version-history/) for the early version history of tvOS only (versions 4 to 8) go to [tvOS early version history](https://github.com/seanpm2001/WacOS/wiki/tvOS-early-version-history/)_

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/tvOS/TvOS.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/tvOS/TvOS.svg)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/tvOS/13/Apple_tvOS_13_screenshot.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/tvOS/13/Apple_tvOS_13_screenshot.png)

_The homescreen of tvOS 13._

**Note: tvOS version 7 and up are still supported and are still/may still be receiving updates. This article will need to be updated in the future to include subsequent changes.**

**Note: Beta versions from iOS 4 (tvOS 4) and onward are not listed. They need to be added in the future as well.**

## tvOS 9

tvOS 9 is an operating system that is 95% based on iOS 9, with adaptations made for a television interface. It was announced on September 9, 2015, alongside the new iPad Pro and iPhone 6S. Tim Cook took the stage and introduced tvOS saying that it was time for the Apple TV to gain a modern OS with support for apps as they are "the future of TV". It will only be available on the Apple TV (4th generation), released in October 2015. It adds a native SDK to develop apps, and an App Store to distribute them, and support for Siri and universal search across multiple apps.

Table of versions: tvOS 9.x – Apple TV (4th generation)

tvOS version iOS version based on Build Release date Features

9.0 9.0 13T396 October 29, 2015; 5 years ago 

Initial release on Apple TV (4th generation).

User Interface

Introduces a new user interface that uses lighter colors and transparency, adds support for control via an all new remote. This remote can be used to navigate the user interface by using multi-touch gestures on the trackpad on the remote rather than physical buttons.

App Store/SDK

Adds support for an all new SDK for developers to build apps for the TV including all of the APIs included in iOS 9 such as Metal.

Adds an App Store which allows users to browse, download, and install a wide variety of applications from things such as games, video applications, etc.

Developers can now use their own interface inside of their application rather than only being able to use Apple's interface.

Siri

Adds support for Siri which can be toggled by pressing the microphone button on the remote.

Siri, beyond all of its iOS abilities, can take many voice commands tailored for the TV, such as a cross-application search for a movie/TV show, rewind, fast forward, name and actor/director of the current movie, and even skip back 15 seconds.

Experience

It is now possible to switch between two applications by double-clicking the trackpad on the remote and scrolling to the desired application.

Users can now customize the home screen by placing any applications they wish on the top row, including third-party types.

New cinematic screen savers display time-lapse images of scenic cities when the Apple TV is asleep.

It is now possible to control the volume of the TV and turn it on/off using just the new Siri Remote and the built in support for HDMI CEC in TVOS.

Third-Party Controllers

Adds support for pairing third-party Bluetooth game controllers in order to play games.

Apple Music

Adds Apple Music support for Apple TV.

9.0.1 9.1 13T402 November 9, 2015; 5 years ago 

General performance and stability improvements.

9.1 9.2 13U85 December 8, 2015; 5 years ago 

Adds support for controlling Apple Music with Siri.

Adds support for controlling the Apple TV with the Remote app for iOS and Apple Watch.

Improvements to networking and scrolling.

9.1.1 9.2.1 13U717 January 25, 2016; 5 years ago 

General performance and stability improvements

Adds the Podcasts app to the Apple TV

9.2 9.3 13Y234 March 21, 2016; 5 years ago 

Adds support for folders on the Apple TV.

A folder can be made by selecting an app, clicking and holding on the touchpad, clicking the Play/Pause button, and then choosing "New Folder" from the popup menu.

Adds the ability to pair Bluetooth keyboards with the 4th Generation Apple TV

Adds a redesigned application switcher similar to the one found in iOS 9 rather than the one found in iOS 8 as TVOS 9.1 contained.

Adds support for iCloud Photo Library and Live Photos

Enables developers to add maps to their applications with the use of the MapKit API.

Siri/Voice Dictation

Adds support for Voice Dictation to enable users to enter text in text fields using their voice. Voice Dictation can be invoked by selecting the text field and pressing the Siri button on the Siri Remote.

Adds Support for searching the App Store on the Apple TV using Siri.

Adds support for new Siri languages which include Spanish(United States), French(Canada), and English(United Kingdom and Australia).

Remote operability improvements

In order to rewind/fast forward the video in tvOS 9.2, it is now necessary to click the touchpad before swiping left or right.

Updates the remote firmware which includes improved motion sensor performance and support for additional sound bar and receiver hardware.

Enhancements to speed and performance.

9.2.1 9.3.2 13Y772 May 16, 2016; 5 years ago 

General performance and stability improvements.

9.2.2 9.3.3 13Y825 July 18, 2016; 5 years ago Final update for tvOS 9.

General performance and stability improvements.

Bug fixes.

## tvOS 10

Table of versions: tvOS 10.x – Apple TV (4th generation)

tvOS version iOS version based on Build Release date Features

10.0

10.0 14T330 September 13, 2016; 5 years ago 

User Interface

Adds the option for users to select between a light mode or a new dark mode.

Adds support for app notification badge icons on the tvOS home screen.

Siri

Support for searching YouTube for content using Siri.

Support for searching for content by topic.

Photos

Adds support for the new Photos app available in iOS 10 which adds a new feature called Memories

Music

Update the UI of Apple Music to match the UI of Apple Music on iOS 10 and macOS Sierra.

Control

When users start typing on the Apple TV using the Siri Remote, their iPhone on iOS 10 or later gives them a lockscreen notification that allows for text entry, even without the remote app installed on the iOS device.

No longer requires developers to provide support for the Siri Remote in games. A game can now make a third-party MFI controller required for gameplay.

HomeKit

Allows the control of HomeKit accessories from the Apple TV.

Developer Tools

Adds many new APIs that developers can take advantage of on tvOS such as ReplayKit, SpriteKit, SceneKit, and more.

10.0.1

10.1 14U71

14U100 October 24, 2016; 4 years ago

November 14, 2016; 4 years ago (14U100) 

General performance and stability improvements.

Bug fixes.

10.1

10.2 14U593 December 12, 2016; 4 years ago 

General performance and stability improvements.

New "TV" app

Added "Single Sign-On"

10.1.1

10.2.1 14U712a January 23, 2017; 4 years ago 

General performance and stability improvements.

10.2

10.3 14W265 March 27, 2017; 4 years ago 

Adds support for Apple File System (APFS)

General performance and stability improvements

10.2.1

10.3.2 14W585a May 15, 2017; 4 years ago 

Security and Bug Fixes

For full information regarding this security fix, please visit https://support.apple.com/en-us/HT207801

10.2.2

10.3.3 14W756 July 19, 2017; 4 years ago 

Final update for tvOS 10. There is no 10.2.3 update.

Security and Bug Fixes

For full information regarding this security fix, please visit https://support.apple.com/en-us/HT207924

## tvOS 11

Table of versions: tvOS 11.x – Apple TV (4th and 5th generations)

tvOS version iOS version based on Build Release date Features

11.0 11.0 15J381 September 19, 2017; 4 years ago 

Initial release on Apple TV 4K (5th generation).

Adds support for 2160p output in HDR10 and Dolby Vision with Apple TV 4K.

Control

Adds option to reprogram the TV button on Siri remote to open the TV app or to return to the home screen.

Adds support for controlling via Control Center from devices running iOS 11.

Experience

Apple AirPods automatically connect when paired with a device signed in with the same iCloud account.

Option for automatic switching between light and dark mode based on time of day.

Adds Home Screen Sync option that synchronizes apps and home screens across Apple TVs signed in with the same iCloud account.

Double tapping Siri remote will zoom in on pillarboxed or letterboxed video to fill frame.

Tapping timeline a second time will switch to a time-of-day display.

Developer tools

Increases maximum On-Demand Resource bundle size to 4 GB from 200 MB.

Adds support for HEVC and HEIF, hardware decoding on Apple TV 4K and software decoding on Apple TV (4th generation).

11.1 11.1 15J582 October 31, 2017; 3 years ago Includes bug fixes and security improvements

11.2 11.2 15K106 December 4, 2017; 3 years ago The update includes support for switching the Apple TV 4K display output to SDR for apps that are GPU-bound when running in HDR and it re-introduces the Unwatched category in Home Sharing for Movies, TV Shows, and Home Videos.

11.2.1 11.2.1 15K152 December 13, 2017; 3 years ago Includes bug fixes and security improvements

11.2.5 11.2.5 15K552 January 23, 2018; 3 years ago Includes bug fixes and security improvements

11.2.6 11.2.6 15K600 February 19, 2018; 3 years ago Includes bug fixes and security improvements

11.3 11.3 15L211 March 29, 2018; 3 years ago tvOS 11.3 beta provides Dolby Vision support for certain Sony 2017 4K HDR televisions with the X1 Extreme processor.

11.4 11.4 15L577 May 29, 2018; 3 years ago AirPlay 2

Listen to your favorite songs across every Apple TV, HomePod, and AirPlay 2-compatible speaker you have in your home. Or play something different in every room at the same time.

11.4.1 11.4.1 15M73 July 9, 2018; 3 years ago Final update for tvOS 11.

Bug fixes and improvements

## tvOS 12

Table of versions: tvOS 12.x – Apple TV (4th and 5th generations)

tvOS version iOS version based on Build Release date Features

12.0 12.0 16J364 September 17, 2018; 3 years ago 

Audio

Adds support for Dolby Atmos E-AC3 passthrough on Apple TV 4K, up to 7.1.4 channels

Experience

Adds support for Zero Sign-On automatic television app authentication with supported cable providers.

Adds password AutoFill from iPhones and iPads running iOS 12 or newer.

Adds new aerial screensavers.

Developer tools

Adds support for home control systems that include Control4, Crestron, and Savant.

Adds support for third-party remotes including Siri support.

12.0.1 12.0 16J380 September 24, 2018; 3 years ago Bug fixes and improvements

12.1 12.1 16J602 October 30, 2018; 2 years ago Bug fixes and improvements

12.1.1 12.1.1 16K45 December 5, 2018; 2 years ago Bug fixes and improvements

12.1.2 12.1.3 16K534 January 22, 2019; 2 years ago Bug fixes and improvements

12.2 12.2 16L226 March 25, 2019; 2 years ago Siri and Apple TV Remote improvements

12.2.1 12.2 16L250 April 10, 2019; 2 years ago Bug fixes and improvements

12.3 12.3 16M153 May 13, 2019; 2 years ago 

Adds redesigned TV app

GUI changes in video player

12.4 12.4 16M568 July 22, 2019; 2 years ago Bug fixes and improvements

12.4.1 12.4.1 16M600 August 26, 2019; 2 years ago Final update for tvOS 12.

Security fixes

## tvOS 13

Table of versions: tvOS 13.x – Apple TV (4th and 5th generations)

tvOS version iOS version based on Build Release date Features

13.0 13.1 17J586 September 24, 2019; 2 years ago 

Experience

Adds redesigned home screen with full-screen video previews.

Changes shape of app icons with more rounded corners.

Adds Control Center.

Adds support for multiple Apple IDs for built-in apps.

Adds scrolling music lyrics in the Music app.

Picture-in-picture multitasking in TV app.

Adds Apple Arcade app.

Adds new underwater screensavers.

Only menu and TV button wake from sleep.

Control

Adds support for the Xbox One and DualShock 4 wireless controllers.

Security Content

https://support.apple.com/kb/HT210604

13.2 13.2 17K82 October 28, 2019; 23 months ago 

Adds support for AirPods Pro.

Other stability improvements and bug fixes.

Security Content

https://support.apple.com/kb/HT210723

13.3 13.3 17K449 December 10, 2019; 21 months ago 

Stability improvements and bug fixes.

Security Content

https://support.apple.com/kb/HT210790

13.3.1 13.3.1 17K795 January 28, 2020; 20 months ago 

Security Content

https://support.apple.com/kb/HT210920

13.4 13.4 17L256 March 24, 2020; 18 months ago 

Security Content

https://support.apple.com/kb/HT211101

13.4.5 13.5 17L562 May 20, 2020; 16 months ago 

Stability improvements and bug fixes.

Security Content

https://support.apple.com/en-us/HT211171

13.4.6 13.5.1 17L570 June 1, 2020; 15 months ago 

Stability improvements and bug fixes.

Security Content

https://support.apple.com/en-us/HT211216

13.4.8 13.6 17M61 July 15, 2020; 14 months ago Final update for tvOS 13.

Stability improvements and bug fixes.

Security Content

https://support.apple.com/en-us/HT211290

## tvOS 14

Table of versions: tvOS 14.x – Apple TV (4th, 5th and 6th generations)

tvOS version iOS version based on Build Release date Features

14.0 14.0 18J386 September 16, 2020; 12 months ago 

Experience:

Changes shape of app icons with more rounded corners and reduced size.

Adds picture-in-picture to third-party apps.

Adds Audio Sharing for simultaneously connecting two sets of AirPods on Apple TV 4K.

Supports full-resolution AirPlay for 4K videos and photos on Apple TV 4K.

Redesigned Control Center.

Support for Microsoft Elite 2 and Adaptive Xbox One controllers.

HomeKit:

Adds camera feeds and picture-in-picture monitoring for HomeKit-enabled security cameras.

Adds direct control of HomeKit accessories in Control Center.

Developer:

Support for 4K YouTube videos on Apple TV 4K, supporting "the latest YouTube videos", reportedly through VP9 support.

14.0.1 14.0.1 18J400 September 24, 2020; 12 months ago 

This update includes general performance and stability improvements.

14.0.2 18J411 October 5, 2020; 11 months ago 

This update includes general performance and stability improvements.

14.2 14.2 18K57 November 5, 2020; 10 months ago 

14.3 14.3 18K561 December 14, 2020; 9 months ago 

Apple Fitness

14.4 14.4 18K802 January 26, 2021; 8 months ago 

14.5 14.5 18L204 April 26, 2021; 5 months ago 

Initial release on Apple TV 4K (2nd generation).

Adds support for Siri Remote (second generation).

14.6 14.6 18L569 May 24, 2021; 4 months ago 

Adds support for lossless playback and Dolby Atmos music in Apple Music on all Apple TV 4K models.

14.7 14.7 18M60 July 19, 2021; 2 months ago 

## tvOS 15

Table of versions: tvOS 15.x – Apple TV (4th, 5th and 6th generations)

tvOS version iOS version based on Build Release date Features

15.0 19J346 September 20, 2021; 9 days ago 

Adds support for controlling Apple TV with a HomePod or HomePod Mini.

Adds "Shared with You" row in TV app for movies and TV shows shared in Messages.

Redesigned video player interface.

Audio:

Adds ability to use HomePod Mini as a speaker, supporting up to a stereo pair.

Adds support for spatial audio on Apple TV 4K with AirPods Pro and AirPods Max.

Automatic onscreen notification to connect AirPods family headphones.

HomeKit:

Adds notifications from security devices.

Add support for viewing multiple HomeKit cameras simultaneously.

Developer:

Enables authenticating purchases and signing into apps using Touch ID or Face ID on a paired iPhone or iPad.

15.1 beta 2 19J5552e September 28, 2021; 1 day ago

***

## Sources

[Wikipedia - tvOS](https://en.wikipedia.org/wiki/TvOS/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Wednesday September 29th at 3:15 pm`

**Last revised on:** `2021 Wednesday September 29th at 3:15 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `543`

**Article version:** `1 (2021 Wednesday September 29th at 3:15 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

