
***

# tvOS early version history

_This article is for history of Apples tvOS, including its iOS releases. For the history of tvOS prior to tvOS 9, see [tvOS version history](https://github.com/seanpm2001/WacOS/wiki/tvOS-version-history/)_

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/tvOS/TvOS.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/tvOS/TvOS.svg)

**Note: tvOS version 7 and up are still supported and are still/may still be receiving updates. This article will need to be updated in the future to include subsequent changes.**

**Note: Beta versions from iOS 4 (tvOS 4) and onward are not listed. They need to be added in the future as well.**

Version history

Legend: 	  Obsolete 	  Discontinued 	  Current 	  Beta

Information about new updates to Apple TV (2nd generation) onwards is published on Apple's knowledge base.

## iOS 4

iOS 4.1 was the first version of iOS available on the Apple TV (2nd generation). It included Apple TV Software 4.0.

Table of versions: iOS 4.x – Apple TV (2nd generation)

iOS Version 	Apple TV Software 	Build 	Release date 	Features

4.1 	4.0 	8M89 	September 1, 2010; 11 years ago 	

Initial release on Apple TV (2nd generation)

4.2 	4.1 	8C150 (1539) 	2010-11-22 	

AirPlay support.

VoiceOver in menus.

Bug fixes.

4.2.1 	4.1.1 	8C154 (1553) 	2010-12-14 	

Bug fixes

Addresses an issue that causes some high-definition TVs to incorrectly display at 480p.

Addresses an issue that may cause a movie or TV show to be re-downloaded.

4.3 	4.2 	8F191m (2060) 	2011-03-09 	

AirPlay video support for third party apps on iDevices.

New slideshow themes: View photos with the new Scrapbook, Photo Mobile, and Holiday Mobile slideshow themes.

Improved on-screen keyboard: Search and enter names and passwords more easily with the redesigned on-screen keyboard.

Enjoy Dolby Digital 5.1 surround sound when watching Netflix.

4.2.1 	8F202 (2100) 	2011-03-22 	

Bug fixes

Addresses issues that may cause the screen to flicker or display incorrect colour on some older TVs.

Addresses an issue where Apple TV may not wake up from sleep.

Addresses an issue where audio may not be heard on some TV models after switching from another input.

Apple TV Software 4.2.1 includes stability and performance fixes for Apple TV.

4.2.2 	8F305 (2203) 	2011-05-11 	

Bug fixes

Addresses an issue in which audio is not output when playing some video content.

Addresses an issue in which video is not displayed when playing some content.

Adds an audio output setting for switching to 16-bit audio for compatibility with some TVs and AV receivers.

Improves the performance of fast-forwarding and rewinding live events.

Addresses an issue in which the description information is not displayed for some movies.

Addresses an issue in which YouTube subscription videos are not ordered by date.

4.3 	8F455 (2557) 	2011-08-01 	

Ability to watch videos from Vimeo.

US-only feature: streams purchased TV shows from iTunes on Apple TV (and past purchases); formerly, only rentals were available.

## iOS 5

On October 23, 2011, Apple TV (2nd generation) received the iOS 5.0 software, with My Photo Stream, AirPlay mirroring (from iPhone 4S & iPad 2), NHL, Wall Street Journal, slideshow themes and Netflix subtitles. Contrary to rumors and code found in iOS 5, the release did not bring support for Bluetooth or apps to the Apple TV (2nd generation).

Table of versions: iOS 5.x – Apple TV (2nd and 3rd generations)

iOS Version 	Apple TV Software 	Build 	Release date 	Features

5.0 	4.4 	9A334v (3140) 	2011-10-12 	

Coincides with iOS 5 for portable iOS devices.

Photo Stream.

AirPlay mirroring for iPad 2 and iPhone 4S.

Wall Street Journal.

New Slideshow themes.

Netflix subtitles.

Upgrading from this version resets the device to factory settings as part of the upgrade process.

4.4.1 	9A335a (3150) 	2011-10-17 	

Bug fixes

Upgrading from this version resets the device to factory settings as part of the upgrade process.

4.4.2 	9A336a (3160) 	2011-10-24 	

Audio playback: addresses an issue in which audio is not output when playing some video content.

Video playback: addresses an issue in which video is not displayed when playing some content.

Audio output setting: adds an audio output setting for switching to 16-bit audio for compatibility with some TVs and AV receivers.

Live FF/RW improvements: improves the performance of fast-forwarding and rewinding live events.

Movie description: addresses an issue in which the description information is not displayed for some movies.

YouTube video order: addresses an issue in which YouTube subscription videos were not ordered by date.

5.0.1 	4.4.3 	9A405l (3323) 	2011-11-17 	

Added support for Netflix in Mexico.

Addresses an issue in which audio may not play through the optical port when the TV is turned off.

4.4.4 	9A406a (3330) 	2011-12-15 	

General performance and stability improvements, including a fix for an issue that displayed an error when playing some video content.

5.1 	5.0 	9B179b (4099) 	2012-03-07 	

Initial release on Apple TV (3rd generation).

Support for 1080p video resolution.A3

Completely redesigned menus.

Content categories now resemble iOS app icons.

Third-party apps (Netflix, YouTube, NBA, Flickr, etc.) have their own icon.

Ability to create a Netflix account.

5.1.1 	5.0.1 	9B206f (4224) 	2012-05-10 	

Previews for movies and TV shows from the iTunes Store can now be viewed in HD.

Fixes an issue that caused some iOS apps to have trouble connecting via AirPlay.

Improves the reliability of Home Sharing connections.

Addresses an issue affecting Netflix login and navigation.

Includes fixes for issues affecting stability and performance.

5.0.2 	9B830 (4250) 	2012-06-05 	

Addresses an issue which caused content restrictions to be incorrectly applied for the iTunes Store in Australia.

## iOS 6

On September 24, 2012, Apple TV (2nd generation) onwards received the iOS 6.0 software update, with Shared Photo Streams, iTunes account switching, better AirPlay functionality, and Trailers searching, among other smaller improvements.

Table of versions: iOS 6.x – Apple TV (2nd and 3rd generations)

iOS Version 	Apple TV Software 	Build 	Release date 	Features

6.0 	5.1 	10A406E (5201) 	2012-09-24 	

Shared Photo Streams: Accept invitations for Shared Photo Streams, browse photos and comments, and receive notifications of new content.

AirPlay: Send audio content from Apple TV to AirPlay-enabled speakers/devices (including AirPort Express and other Apple TVs). Also includes the ability to require an onscreen code to use AirPlay with Apple TV.

iTunes account switching: Save multiple iTunes accounts and switch quickly between them.

Trailers: Search for movie trailers. In the United States, see show times for local theaters.

Screen savers: New Cascade, Shrinking Tiles, and Sliding Panels screen savers.

Main menu: Reorder icons on the second page by holding down the select button on the remote.

Subtitles: SDH support for the hearing-impaired; improvements to viewing and selecting subtitles.

Network configuration: Support for setting up advanced network options using configuration profiles.

Stability and performance: Includes general performance and stability improvements.

6.0.1 	5.1.1 	10A831 (5433) 	2012-11-29 	

Adds support for Up Next with iTunes 11 or iTunes Match.

Includes performance and stability improvements with the iTunes Store, AirPlay, Netflix, iTunes Match, and wired ethernet connections.

6.1 	5.2 	10B144b (6010.96) 	2013-01-28 	

Initial release on Apple TV (3rd generation Revision A).

Bluetooth keyboards: Adds support for some Bluetooth keyboards (including Apple Wireless Keyboard).

iTunes in the Cloud: Browse and play purchased iTunes music directly from iCloud.

Airplay: Send stereo audio from video content on Apple TV to AirPlay-enabled speakers/devices (including AirPort Express and other Apple TVs).

Stability and performance: Includes general performance and stability improvements.

6.1.3 	5.2.1 	10B329a (6025) 	2013-03-19 	

Hulu Plus app: Completely redesigned, adds support for closed-captioning.

iTunes in the Cloud: Adds support for Music in the Cloud in Japan and Israel.

Stability and performance: Including improvements for software update, subtitles, and general performance.

Security Fixes.

6.1.4 	5.3 	10B809 (6105) 	2013-06-19 	

Third-party content: Adds support for Crunchyroll, ESPN, HBO GO, Qello, and Sky News (some sources depend on country).

iTunes Store: Improves reliability of signing into the iTunes Store and playing purchased content.

Further channels added on August 27, 2013, without a software update: Vevo, Weather Channel, Disney Channel, Disney XD, and Smithsonian Channel (some sources depend on country)

## iOS 7

On September 20, 2013, Apple TV (second generation) onwards received the iOS 7.0 software update, with iTunes Radio and AirPlay from iCloud.

Table of versions: iOS 7.x – Apple TV (2nd and 3rd generations)

iOS version 	Apple TV Software 	Build 	Release date 	Features

7.0.1 / 7.0.2 	6.0 	11A470e/11A502 	2013-09-23 	

iTunes Radio

Create user radio stations and listen to them ad-free with iTunes Match (United States and Australia only).

iTunes Store

Browse, purchase, and play music directly from the iTunes Store.

iCloud Photos

Adds support to play video from a shared Photo Stream and view Photo Streams from multiple contributors.

AirPlay from iCloud

Apple TV will play content from iTunes In The Cloud instead of user AirPlay device when possible (needs iOS 7 on AirPlay device).

Podcasts

Sync user podcasts and podcast stations across Apple TV and all user iOS devices.

iMovie Theater

Stream user iMovie creations instantly in high definition from iCloud (needs latest version of iMovie for iOS or Mac and an iCloud account).

Subtitles & Captioning

Automatic subtitle selection based on Apple TV language setting, with customizable closed caption style.

Conference Room Display

Lock Apple TV into Conference Room Display (for business and education environments) and show onscreen instructions for using AirPlay.

Software update

Keep Apple TV always updated by automatically installing software updates when available.

Setup

Use an iPhone, iPad, or iPod Touch with iOS 7 to automatically transfer network settings, user Apple ID, and language preferences to Apple TV (3rd generation) (not available on iPhone 4 or iPad 2).

Third-party US-only content added on September 26, 2013, without a software update: Major League Soccer (MLS) and Disney Junior.

iMovie Theater app was added on October 22, 2013, without a software update.

7.0.3 	6.0.1 	11B511d 	2013-10-25 	

Stability and performance

Includes general performance and stability improvements.

7.0.4 / 7.0.6 	6.0.2 	11B554a/11B651 	2013-11-14 	

Stability and performance

Includes general performance and stability improvements.

Security (11B651 build only)

Provides a fix for SSL connection verification.

7.1 	6.1 	11D169b 	March 10, 2014; 7 years ago 	

Main menu

Includes ability to make hiding channels easier

AirPlay

Security option for iOS devices or Macs to require verifying via a one-time, onscreen code before using AirPlay (needs iOS 7.1 or later on an iOS device, or OS X 10.9.2 or later on a Mac).

Adds support to allow an AirPlay device to discover Apple TV over Bluetooth in environments where multicast or Bonjour traffic is blocked on the network or the AirPlay device is on a different subnet.

Remote app

View purchased TV Shows and Movies in the Remote app and tap to play them instantly on Apple TV.

Create and play iTunes Radio stations (needs Remote app version 4.2 or later).

Stability and performance

Bug fixes, general performance and stability improvements.

7.1.1 	6.1.1 	11D201c 	April 22, 2014; 7 years ago 	

Stability and performance

Includes general performance and stability improvements.

7.1.2 	6.2 	11D257c 	June 30, 2014; 7 years ago 	

Stability and performance

Includes general performance and stability improvements.

iTunes Extras

Added ability to explore deleted scenes, photos, cast and crew, and more with select iTunes movie purchases. (Only available for HD purchases)

6.2.1 	11D258 	September 17, 2014; 7 years ago 	

Final release on Apple TV (2nd generation)

As of May 2015, the YouTube app only works on newer Apple TVs that have software 7.2 or later due to an API change implemented by Google.

Stability and performance

Includes general performance and stability improvements.

## iOS 8

On September 18, 2014, the third generation Apple TV received the iOS 8.0 software update, with a redesigned UI, Family Sharing and peer-to-peer AirPlay.

Table of versions: iOS 8.x – Apple TV (3rd generation)

iOS Version 	Apple TV Software 	Build 	Release date 	Features

8.0 	7.0 	12A365b 	September 17, 2014; 7 years ago 	

UI

Redesigned UI that adopts a similar look to the "flat" look that is presented in iOS 8 and OS X Yosemite.

UI redesign includes redesigned icons and borders, menus, and many of the controls inside many of the apps that are included with the Apple TV.

Family Sharing

Adds support for a service of sharing purchases from iTunes between up to 6 people.

Supports iTunes music, video, podcasts, and TV show purchases.

All group members must pay for family purchases with the same credit/debit card.

Ask To Buy – parents can approve a child's spending from the parent's device.

Descriptive Video Services

Hear descriptive video with a new accessibility feature support select iTunes movies and TV shows.

Peer-to-peer AirPlay

Guests can AirPlay from their Mac or iOS device directly to an Apple TV without connecting to a wireless network (needs ATV 3 Rev-A (A1469), iPhone 4S and later; iPad 2 and later; and iPod Touch (5th generation) running iOS 8 or a Mac running OS X Yosemite (10.10) or later).A3R

Beats Music

Beats Music has now been shut down in favor of Apple Music, which requires an Apple TV 4 running tvOS 9.0 or later.

8.1 	7.0.1 	12B410a 	October 20, 2014; 6 years ago 	

Stability and performance

Includes general performance and stability improvements.

Bug fixes.

8.1.1 	7.0.2 	12B440 	November 17, 2014; 6 years ago 	

Stability and performance

Includes general performance and stability improvements.

Bug fixes.

8.1.3 	7.0.3 	12B466 	January 27, 2015; 6 years ago 	

Stability and performance

Includes general performance and stability improvements.

Bug fixes.

8.2 	7.1 	12D508 	March 9, 2015; 6 years ago 	

Stability and performance

Includes general performance and stability improvements.

Bug fixes.

8.3 	7.2 	12F69 	April 8, 2015; 6 years ago 	

As of May 2015, the YouTube app only works on Apple TVs that have software 7.2 or later due to an API change implemented by Google.

Stability and performance

Includes general performance and stability improvements.

Bug fixes

Apple TV Software updates released after the release of Apple TV (4th generation)

8.4 	7.2.1 	12H523 	February 25, 2016; 5 years ago 	

Stability and performance

Includes general performance and stability improvements.

Bug fixes

8.4.1 	7.2.2 	12H606 	December 12, 2016; 4 years ago 	

Stability and performance
Includes general performance and stability improvements.
Bug fixes

Amazon Video was automatically added to Apple TVs running 7.2.2 on December 6, 2017.

8.4.2 	7.3 	12H847 	May 13, 2019; 2 years ago 	Apple TV Software 7.3 brings the updated TV app to provide support for Apple TV+ services.

7.3.1 	12H864 	July 22, 2019; 2 years ago 	Bug fixes and stability improvements

8.4.3 	7.4 	12H876 	September 24, 2019; 2 years ago 	Bug fixes and stability improvements

8.4.4 	7.5 	12H885 	March 24, 2020; 18 months ago 	Adds the ability to control the Apple TV from the control center of an iOS device, bug fixes and stability improvements.

8.4.5 	7.6 	12H903 	September 16, 2020; 12 months ago 	Bug fixes and stability improvements

8.4.6 	7.6.2 	12H914 	December 14, 2020; 9 months ago 	Bug fixes and stability improvements

7.7 			Bug fixes and stability improvements 

***

## Sources

[Wikipedia - tvOS](https://en.wikipedia.org/wiki/TvOS/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Wednesday September 29th at 3:23 pm`

**Last revised on:** `2021 Wednesday September 29th at 3:23 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `501`

**Article version:** `1 (2021 Wednesday September 29th at 3:23 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

