
***

# iPhone 4

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/4/IPhone_4_Mock_No_Shadow_PSD.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/4/IPhone_4_Mock_No_Shadow_PSD.png)

## Technical specifications

### Developer

Apple Inc.

### Manufacturer

Foxconn (UMTS/GSM model)

Pegatron (CDMA model)

### Slogan

"This changes everything. Again."

### Generation

4th

### Model

A1332 (GSM model)

A1349 (CDMA model)

### First released

GSM model (black): June 24, 2010

CDMA model (black): February 10, 2011

GSM and CDMA models (white): April 28, 2011

### Discontinued

September 10, 2013

### Predecessor

iPhone 3GS

### Successor

iPhone 4S

### Type

Smartphone

### Form factor

Slate

### Dimensions

115.2 mm (4.54 in) H

58.6 mm (2.31 in) W

9.3 mm (0.37 in) D

Mass	137 g (4.8 oz)

### Operating system

Original: iOS 4.0 (GSM model), iOS 4.2.5 (CDMA model)

Last: iOS 7.1.2, released June 30, 2014

### System on chip

Apple A4

### CPU

1 GHz (Underclocked to 800 MHz) single core 32-bit ARM Cortex-A8

### GPU

PowerVR SGX535

### Memory

512 MB LPDDR DRAM

### Storage

8, 16, or 32 GB flash memory

### Battery

3.7 V, 5.3 Wh (1,420 mAh) Lithium-ion battery

### Data inputs

Multi-touch touchscreen display

Dual microphone

3-axis gyroscope

3-axis accelerometer

Digital compass

Proximity sensor

Ambient light sensor

### Display

3.5 in (89 mm) diagonal 3:2 aspect ratio widescreen

LED backlit IPS TFT LCD

960×640 resolution at 326 ppi (0.61 megapixels)

800:1 contrast ratio (typical)

500 cd/m2 max brightness (typical)

Fingerprint-resistant oleophobic coating on front and back glass

### Rear camera

5 MP back-side illuminated sensor

HD video (720p) at 30 frame/s

1.75 μm size pixels

5× digital zoom

4 element lens

LED flash

Photo and video geotagging

### Front camera

0.3 MP VGA (480p) at 30 frame/s

Tap to focus video or still images

Photo and video geotagging

Sound	Single loudspeaker

3.5 mm TRRS, frequency response: 20 Hz to 20 kHz

### Connectivity

Wi-Fi (802.11 b/g/n) (2.4 GHz only)

Bluetooth 2.1 + EDR

GSM model: quad-band GSM/GPRS/EDGE

(800, 850, 900, 1,800, 1,900 MHz)

Quad-band UMTS/HSDPA/HSUPA

(800, 850, 900, 1,900, 2,100 MHz) (800 MHz is not yet officially supported by Apple)

CDMA model: dual-band CDMA/EV-DO Rev. A (800, 1,900 MHz)

SAR	Model A1332 Head: 1.17 W/kg

Body: 1.11 W/kg

Model A1349 Head: 1.18 W/kg

Body: 0.87 W/kg 

Hearing aid compatibility

GSM

3G 850/1,900 MHz M4, T4

2G 850 MHz M3, T3

2G 1,900 MHz M2, T3

CDMA M4, T4

## About

The iPhone 4 is a smartphone that was designed and marketed by Apple Inc. It is the fourth generation of the iPhone lineup, succeeding the [iPhone 3GS](https://github.com/seanpm2001/WacOS/wiki/iPhone-3GS/) and preceding the [4S](https://github.com/seanpm2001/WacOS/wiki/iPhone-4S/). Following a number of notable leaks, the iPhone 4 was first unveiled on June 7, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/), at Apple's Worldwide Developers Conference in San Francisco, and was released on June 24, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/), in the United States, United Kingdom, France, Germany, and Japan. The iPhone 4 introduced a new hardware design to the iPhone family, which Apple's CEO [Steve Jobs](https://github.com/seanpm2001/WacOS/wiki/Steve_Jobs/) touted as the thinnest smartphone in the world at the time; it consisted of a stainless steel frame which doubled as an antenna, with internal components situated between two panels of aluminosilicate glass. The iPhone 4 also introduced Apple's new high-resolution "Retina Display" (with a pixel density of 326 pixels per inch), while maintaining the same physical size and aspect ratio as its precursors. The iPhone 4 also introduced Apple's A4 system-on-chip, along with [iOS 4](https://github.com/seanpm2001/WacOS/wiki/iOS-4/)—which notably introduced multitasking functionality and Apple's new FaceTime video chat service. The iPhone 4 was also the first iPhone to include a front-facing camera, and the first to be released in a version for CDMA networks, ending AT&T's period as the exclusive carrier of iPhone products in the United States.

The iPhone 4 received largely positive reception, with critics praising its revamped design and more powerful hardware, in comparison to previous models. While it was a market success (with over 600,000 pre-orders within 24 hours), the release of the iPhone 4 was plagued by highly publicized reports concerning abnormalities in its new antenna design that caused the device to lose its cellular signal if held in a certain way. Most human contact with the phone's outer edge would cause a significant decrease in signal strength. Apple released [iOS 4.0.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) to try and fix these issues, but unsuccessfully.

The iPhone 4 spent the longest time as Apple's flagship iPhone model at fifteen months. Although the succeeding [4S](https://github.com/seanpm2001/WacOS/wiki/iPhone-4S/) was announced in October [2011](https://github.com/seanpm2001/WacOS/wiki/2011/), the 4 continued to be sold as a midrange model until September [2012](https://github.com/seanpm2001/WacOS/wiki/2012/), and thereafter as the entry-level offering in Apple's lineup until September [2013](https://github.com/seanpm2001/WacOS/wiki/2013/) with the announcement of the [iPhone 5S](https://github.com/seanpm2001/WacOS/wiki/iPhone-5S/)/[iPhone 5C](https://github.com/seanpm2001/WacOS/wiki/iPhone-5C/). The iPhone 4 had the longest lifespan of any iPhone ever produced, spanning close to four years and available in some developing countries until early [2015](https://github.com/seanpm2001/WacOS/wiki/2015/).

## History

### Prototypes

Before the official unveiling of the iPhone 4 on June 7, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/), two prototypes were brought to the attention of the media, breaching Apple's normally secretive development process. Many of the speculations regarding technical specifications proved accurate.

### Engadget leak

On January 27, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/), gadget website Engadget received leaked images of the unreleased first-generation iPad. Unbeknownst to the editors and readers, these images contained two unreleased iPhone 4 models. It wasn't until the subsequent Gizmodo release that they were aware of the complete contents of the images.

### Gizmodo leak

On April 19, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/), gadget website Gizmodo reported that they had purchased an iPhone prototype for $5000, and furthermore, had conducted a product teardown of the device. The prototype was reported to have been lost by an Apple employee, Gray Powell, in Redwood City, California. Shortly after Gizmodo published detailed information about the prototype, Apple's legal associates formally requested for the phone to be returned to Apple, and Gizmodo responded with the intent to cooperate.

On April 23, officers from the Rapid Enforcement Allied Computer Team (REACT) task force of the California HTTAP Program raided the home of Jason Chen, the Gizmodo editor responsible for reviewing the prototype, seizing all of his computers and hard drives. The Electronic Frontier Foundation criticized the raid as violating journalist source protection laws that forbid the seizure of journalist computers, as well as the suspicion that Apple had used its influence as a member of the steering committee, which is charged with direction and oversight of the California REACT task force to push police into action in a way that would not normally be conducted for this type of incident. Apple had already received the iPhone prototype before the raid when it was returned by Gizmodo. The District Attorney stated that the investigation was suspended, and discontinued searching through the Gizmodo editor's belongings as they determine whether the shield laws are applicable, and cautioned that no charges have been issued at this point.

### Taoviet leak

Pictures and video of a second prototype were published on a Vietnamese website, Taoviet, on May 12, 2010. It was almost identical to the first, and used an A4 chip manufactured by Apple. The website purchased the prototype for $4,000. DigiTimes reported that the screen resolution of the new phone was 960-by-640, which was confirmed by Apple at the iPhone 4's official announcement.

### Release

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/4/Steve_Jobs_Headshot_2010.JPG](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/4/Steve_Jobs_Headshot_2010.JPG)

_Steve Jobs presenting the iPhone 4 in 2010_

The iPhone 4 was available for pre-order on June 15, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/). Customers attempting to pre-order the iPhone 4 reported problems with the pre-order process on the US and UK online Apple Stores which crashed due to the surge in traffic. The same issue was reported with AT&T and SoftBank, Apple's exclusive partners in the United States and Japan respectively, who suspended advance sales of the iPhone 4 as demand threatened to exceed supply. Retail stores were also unable to complete pre-order transactions due to the servers crashing.

Apple and its partner carriers received 600,000 pre-orders for the iPhone 4 in the first 24 hours, the largest number of pre-orders Apple had received in a single day for any device up to that point. Engadget reported that at 20:30 UTC, all iPhone 4 pre-order suppliers had sold out. 1.7 million iPhone 4 models were sold in its first three days of availability.

The iPhone 4 was also released through Orange in Tunisia and was available in eight cities at the launch. On July 30, 2010, iPhone 4 was made available for sale in Australia, New Zealand and 15 other countries with free bumper cases. In South Korea, it was released by KT on September 10. In Israel, it was released, too, on September 24, through Cellcom, Pelephone and Orange. It was launched in Thailand on September 23 by AIS, DTAC and True Move, and in Malaysia on September 26 in Kuala Lumpur, and nationwide on September 27 according to the website of Maxis.

The iPhone 4 was released in South Africa on September 22 on the Vodacom and MTN networks, in very limited quantities. The iPhone 4 was launched in Vietnam on September 30 on VinaPhone and Viettel, at first in 3 major cities: Hanoi, Ho Chi Minh city and Da Nang, and then all over the country by the end of October.

The iPhone 4 was launched in India on May 27, 2011 by Aircel and Airtel.

On January 11, [2011](https://github.com/seanpm2001/WacOS/wiki/2011/), Verizon Wireless announced during a media event that it had reached an agreement with Apple and would begin selling a CDMA iPhone 4 in the United States, ending Apple's exclusivity agreement with AT&T. The Verizon iPhone went on sale on February 10 and pre orders began on February 3. The Verizon iPhone includes the 'Personal Hotspot" feature which allows a user to use the iPhone as a wireless hotspot, with up to five devices connecting at one time. The February 3, [2011](https://github.com/seanpm2001/WacOS/wiki/2011/), presale of the iPhone 4 broke Verizon's first day sales records for a single device.

On June 24, 2010, Apple stated that the white iPhone 4 models were proving more "challenging to manufacture" than expected, and initially pushed the release date back to the second half of July. There was a lot of speculation surrounding the delay of the white iPhone 4. Among the most popular rumors are those concerning the phone's internal camera being adversely affected by light leaking in due to the semi-translucent glass and the white paint. Other sources report that the problem relates to Apple's inability to match the white color of the front faceplate with that of the home button. On April 27, 2011, Apple announced that it would be releasing the white iPhone 4 model on April 28, [2011](https://github.com/seanpm2001/WacOS/wiki/2011/), for both GSM and CDMA. The release of the white iPhone 4 was carried out on April 28.

During Apple's official unveiling of the iPhone 4S on October 4, 2011, it was announced that Sprint would begin carrying the reconfigured CDMA iPhone 4 and the iPhone 4S in the US on October 14.

## Discontinuation

In September [2013](https://github.com/seanpm2001/WacOS/wiki/2013/), after the release of the [iPhone 5S]((https://github.com/seanpm2001/WacOS/wiki/iPhone-5S/) and [iPhone 5C](https://github.com/seanpm2001/WacOS/wiki/iPhone-5C/), Apple stopped selling the iPhone 4 in most of their stores as well as on their website. It was replaced by the 8 GB iPhone 4S.

## Hardware

### Display

The display of the iPhone 4 was manufactured by LG under an exclusive contract with Apple. It features an LED backlit TFT LCD capacitive touchscreen with a pixel density of 326 pixels per inch (ppi) on a 3.5 in (8.9 cm) (diagonally measured), 960×640 display. Each pixel is 78 micrometers in width. The display has a contrast ratio of 800:1. The screen was marketed by Apple as the "Retina display", based on the assertion that a display of approximately 300 ppi at a distance of 305 millimetres (12 in) from one's eye, or 57 arcseconds per pixel is the maximum amount of detail that the human retina can perceive. With the iPhone expected to be used at a distance of about 12 inches from the eyes, a higher resolution would allegedly have no effect on the image's apparent quality as the maximum potential of the human eye has already been met.

This claim was widely disputed. Raymond Soneira, president of DisplayMate Technologies, said in an interview with the Wired magazine, that the claims by Jobs are something of an exaggeration: "It is reasonably close to being a perfect display, but Steve pushed it a little too far". Soneira stated that the resolution of the human retina is higher than claimed by Apple, working out to 477 PPI at 12 inches (305 mm) from the eyes, or 36 arcseconds per pixel.

However, Phil Plait, author of Bad Astronomy, whose career includes a collaboration with NASA regarding the camera on the Hubble Space Telescope, responded to the criticism by stating that "if you have [better than 20/20] eyesight, then at one foot away the iPhone 4's pixels are resolved. The picture will look pixellated. If you have average eyesight, the picture will look just fine".

### Camera

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/4/IPhone_4_cameras.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/4/IPhone_4_cameras.png)

The iPhone 4 is the first iPhone model to have two cameras. The LED flash for the rear-facing camera (top) and the forward-facing camera (bottom, left of the speaker) are not present in older models.

The iPhone 4 features an additional front-facing VGA camera, and a backside-illuminated 5 megapixel rear-facing camera with a 3.85 mm f/2.8 lens and an LED flash. The rear-facing 5-megapixel camera is capable of recording HD video in 720p at 30 frames per second. Both cameras make use of the tap to focus feature, part of iOS 4, for photo and video recording. The rear-facing camera has a 5× digital zoom.

### Connectivity

In contrast to Steve Jobs' announcement at WWDC 2010, recent Federal Communications Commission documentation showed that, in fact, the iPhone 4 contains a penta-band 3G UMTS antenna, not a quad-band 3G UMTS radio, as advertised by Apple. According to the FCC documentation filed by Apple, the radio inside the iPhone 4 supports 800, 850, 900, 1,900, and 2,100 MHz. The 800 MHz frequency, which is most commonly used in Japanese mobile phones, is not advertised as being supported by Apple. However, the 800 MHz band is a subset of the 850 MHz band, which probably explains why the device was advertised as quad-band. The chip-sets were manufactured by Skyworks Solutions and Infineon for GSM version.

As with most of Apple's mobile products at the time, the iPhone 4 also used the 30 pin dock connector as its only external data port.

The iPhone 4 is the first generation of iPhone to have a second microphone used for noise cancellation. It is located on the top of the unit near the headphone jack; the main microphone is on the bottom left.

### Gyroscope and accelerometer

The iPhone 4 introduces a gyroscopic sensor that detects 3-axis angular acceleration around the X, Y, and Z axes, enabling precise calculation of yaw, pitch, and roll. The gyroscope complements the accelerometer, a sensor that has been present since the original iPhone, which detects the device's acceleration, shake, vibration shock, or fall by detecting linear acceleration along with one of three axes (X, Y, and Z). The combined data from the accelerometer and the gyroscope provides detailed and precise information about the device's 6-axis movement in space. The 3 axes of the gyroscope combined with the 3 axes of the accelerometer enable the device to recognize approximately how far, fast, and in which direction it has moved in space.

### Processor, memory and storage

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/4/Apple_A4_Chip.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/4/Apple_A4_Chip.jpg)

Apple A4 chip used in the iPhone 4

The iPhone 4 is powered by the Apple A4 chip, which was designed by Intrinsity and, like all prior iPhone models, manufactured by Samsung. This system-on-a-chip is composed of an ARM Cortex-A8 CPU integrated with a PowerVR SGX535 GPU. The Apple A4 was also used in the first-generation iPad (released in 2010), where it was clocked at its rated speed of 1 GHz. The Apple A4 was the first ever CPU designed by Apple. The clock speed in the iPhone 4 was never disclosed. All prior models of the iPhone had underclocked the CPU, which typically extends battery life and lowers heat dissipation.

The iPhone 4 has 512 MB of DRAM. The additional DRAM supports increased performance and multi-tasking. As on prior models, all data is stored in flash memory, 8, 16 or 32 GB, and not on the SIM. Unlike prior generations, the storage capacity is not printed on the back of the unit.

### Micro-SIM

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/4/IPhone_4_Mini-SIM_Extracted.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/4/IPhone_4_Mini-SIM_Extracted.jpg)

An iPhone 4 A1332 with a micro-SIM card removed with a paper clip, showing its SIM card compartment.

The iPhone 4 uses a micro-SIM card on iPhone 4 devices running on a GSM network, which is positioned in an ejectable tray, located on the right side of the device. On a CDMA network, however, the phone connects to the network using an ESN. All prior models have used regular mini-SIM cards. Depending on the operator, micro-SIM cards may not be available for all networks globally. As a technical workaround it is possible to trim a mini-SIM card with a knife or scissors so that it fits into the micro-SIM tray.

### Design

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/4/IPhone_4_Black.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/4/IPhone_4_Black.jpg)

The iPhone 4 is constructed of glass faces and a metal rim.

The iPhone 4 features a redesigned structure, designed by Jony Ive, a design that would later be reused and adapted for the iPhone 4S, 5, 5S and first-generation iPhone SE. Most notably, the bulges of the back panel as well as the band between the front and back are gone and have been replaced with flattened surfaces. The redesign reflects the utilitarianism and uniformity of existing Apple products, such as the iPad and the iMac. The overall dimensions of the iPhone 4 have been reduced from its predecessor.

It is 115 millimetres (4.5 in) high, 58.6 millimetres (2.31 in) wide, and 9.4 millimetres (0.37 in) deep, compared to the iPhone 3GS, which is 116 millimetres (4.6 in) high, 62 millimetres (2.4 in) wide, and 12 millimetres (0.47 in) deep; making the iPhone 4 24% thinner than its predecessor, the iPhone 3GS. Steve Jobs claimed it to be "the thinnest smartphone on the planet." The reduced size of the device is primarily due to the externally placed antenna.

The iPhone 4 is structured around a stainless steel frame that wraps around the edge of the phone, acting both as the primary structure for the device and as the iPhone 4's antennas. This metal band features two slits on the GSM version of the phone, one at the lower left, and one at the top (and a fake slit along the lower right, to cosmetically mirror the one at the lower left) that divide the band into two antenna sections: the left section of the band serves as the Bluetooth, Wi-Fi, and GPS antenna, and the right and lower sections of the band act as the antenna for GSM and UMTS connectivity.

On the CDMA version of the phone, there are four slits in the metal band. Two at the top (on the left and right) and two at the bottom. This divides the metal band into four different segments, which like the GSM version of the phone, serves as different antennas for connectivity. The top portion of the band (divided by the top left and right slits) is for connecting to the CDMA network. The left portion of the metal band is for Bluetooth, Wi-Fi, and GPS just like the GSM version. The right side is not an antenna but serves to cosmetically mirror the left side and also to create a similar look to the GSM version of the phone.

The internal components are situated between two panels of aluminosilicate glass, described by Apple as being "chemically strengthened to be 20 times stiffer and 30 times harder than plastic," theoretically allowing it to be more scratch-resistant and durable than the prior models.

In fall 2010, pentalobe screws started to replace the Philips screws used in post-repair units in the US and in production units in Japan.

## Software

The iPhone 4 shipped with iOS 4, which was the newest version of Apple's iOS mobile operating system at the time. iOS 4 introduced a multitasking system, allowing apps to remain "suspended" in memory, perform certain operations in the background, and allowing users to switch between apps using an on-screen menu. It also introduced FaceTime, which allows users to perform video calls between other iPhone, iPad, iPod Touch, and OS X users.

The iPhone 4 supports up to iOS 7, released in September 2013. Due to the relatively aged hardware of the iPhone 4, certain features available on newer iPhone models are not available on the device; as of iOS 7, they include Siri, 3D maps and turn-by-turn navigation, AirDrop, AirPlay mirroring, live camera filters, panorama mode and certain visual effects introduced by iOS 7, such as the blurring of translucent interface elements, the parallax effect on the home screen, and live wallpapers. While still subject to the same limitations, iOS 7.1 did bring some slight performance improvements to the operating system on the iPhone 4. iOS 7, specifically iOS 7.1.2, is the last version of iOS to support the iPhone 4. Unlike the iPhone 4S, the iPhone 4 did not receive the iOS 8 update due to performance issues.
Accessories

### Bumper

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/4/Apple_iPhone_4_Bumper.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/4/Apple_iPhone_4_Bumper.jpg)

_An iPhone 4 next to a Bumper._

An iPhone 4 Bumper is a ring of rubber and plastic that surrounds the edge of the iPhone 4, to protect the phone. The inner part is rubber with the external band made of plastic. The Bumper wraps around the edges of the device protecting the edges, and to a lesser extent, the screen. The Bumper does not cover the front or rear of the phone, though it does slightly raise the iPhone off whatever surface it is sitting on.

Additionally, the plastic band houses metallic buttons for the volume controls and sleep/wake button. The six holes in the Bumper enable access to the mute switch, dock connector, headphone jack, speaker, and microphones.

Apple updated the bumper with a wider volume switch hole with the release of the iPhone 4 for CDMA networks. The updated bumper is also compatible with iPhone 4S, the next-generation iPhone that has the same exterior design and measurements as the CDMA model of the iPhone 4, but with a SIM card slot as well.

## Reception

### Pre-release

Pre-release reception was largely positive. The announcement included information that had not been covered by Gizmodo. Fox News commented that "seeing it in action is far more informative than staring at Gizmodo's photos of a busted test unit". Rhodri Marsden of The Independent said that "aside from the introduction of face-to-face video calling, it's not a staggering feature set," instead focusing on how the device is "more powerful than its predecessor, speedier, easier to use and will make previously laborious tasks seem like a cinch".

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/4/Medvedev_and_Steve_Jobs.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/4/Medvedev_and_Steve_Jobs.jpg)

Steve Jobs demonstrating the iPhone 4 to Russian President Dmitry Medvedev on June 23, 2010

CNET reacted to the announcement by explaining how it believes that iMovie for iOS was the "most exciting part of this year's WWDC Keynote". The article noted how the iPhone 4, unlike current cameras, can record HD content and then edit it from the same device, labeling it a "true mobile editing suite".

### Reviews

Reviews of the iPhone 4 were largely positive. Walt Mossberg of The Wall Street Journal called the device "the best device in its class". Engadget named it the "best smartphone on the market" in June 2010. CNET gave the iPhone 4 a rating of 8.6 out of 10, one of the highest ratings it had given any smartphone. TechRadar gave the device 4.5/5 stars. Consumer Reports said the signal problem was the reason they did not rate it a "recommended" model, although the other tests ranked it highest among smart phones.

Joshua Topolsky of Engadget described the device's industrial design as being "more detailed and sophisticated" than its predecessor.
Technical problems

Some users reported a yellow discoloration of the screen that disappeared after several days, which was attributed to the glass lamination glue that was used. It did not have time to dry fully before the unit reached consumers due to the speed of manufacturing.[83] Another issue reported by some users within days of the iPhone 4 release was that during calls the proximity sensor can be insensitive, so that facial contact with the touchscreen can end calls, mute calls, and dial other numbers. Some users reported that, particularly in low-light conditions, photos taken on the iPhone 4 sometimes contained blue or green "splotches." Issues with white balance were also discovered, particularly when using the flash.
Antenna

Shortly after the iPhone 4 was launched, some consumers reported that signal strength of the phone was reduced when touching the lower left edge of the phone, bridging one of the two locations which separates the two antennas, resulting in dropped calls in some areas with lower signal reception. In response, Apple issued a statement advising that customers should "avoid gripping [the phone] in the lower left corner" when making or receiving a call. Internally, senior antenna expert Ruben Caballero raised concerns to CEO Steve Jobs that the antenna design could lead to dropped calls.

As a consequence of this problem, it was reported on July 2, 2010 that several iPhone 4 users were planning on suing Apple and AT&T for fraud by concealment, negligence, intentional misrepresentation and defective design. The legal challenge was started by a law firm, who set up a website to recruit disenchanted iPhone 4 buyers for a lawsuit against Apple. Later that day, Apple issued another statement stating that it had discovered the cause of the "dramatic drop in bars".

Apple explained how the formula it used to calculate the number of bars to display was "wrong". Apple promised to correct the issue and release a software update within a few weeks that would address the "mistake", which had been present since the original iPhone. The New York Times commented that "the failure to detect this longstanding problem earlier is astonishing."

Consumer Reports initially stated that the iPhone 4's signal issues are not "unique, and may not be serious" and it continued to mention that signal loss is a problem that is faced by the entire smartphone industry. It was such a problem that Apple made a formal apology onstage. The next day, the magazine altered their stance after encountering instances of dropped calls. The magazine rejected Apple's explanation after conducting tests in a controlled environment, and comparing the results against prior generations of iPhone. It sarcastically pointed out that using a piece of tape to cover the lower left antenna gap was one way to fix the problem, but recommended that consumers who "want an iPhone that works well without a masking-tape fix" purchase the iPhone 3GS instead. The magazine also tested the iPhone 4 while it was wearing a Bumper, a frame-like cover sold by Apple that prevents direct contact with the antenna, reporting that it did resolve the problem. CNN repeated Consumer Reports' statement that a small amount of duct tape had proven an effective fix to the iPhone 4's dropped call issue.

On July 16, 2010, at a press conference which included a private tour of Apple's antenna design lab for journalists,[ Steve Jobs announced that Apple would provide all iPhone 4 owners with a free case to help solve the antenna issue and a refund to those users who had already purchased a Bumper. The free case offer would be valid until September 30, 2010, when Apple would re-evaluate the situation. To get a free case, owners were able to apply via an app installed on the phone found in the App Store from July 22, 2010 to September 30, 2010. Jobs also announced that Apple could not produce enough Bumpers for all owners of the phone, but would source a supply and offer a range of cases. Additionally, Jobs cited figures from AppleCare which showed that only 0.55 percent of all iPhone 4 users have complained to the company about the issue, while the number of phones returned to Apple was 1.7 percent – 4.3 percentage points less than the number of iPhone 3GS models that were returned in the first month of the phone's launch.

Consumer Reports noted that the solution was not permanent, though a good first step. However, because Jobs did not specify a time line for fixing the problem, and the offering for a free bumper only being a temporary solution, PC World decided to remove the iPhone 4 from its "Top 10 Cell Phones" chart and reassign it to a pending rating.

Despite the negative media attention regarding the antenna issues, 72% of iPhone 4 users say that they are "very satisfied" with their iPhone 4 according to an August 2010 survey by ChangeWave Research. The iPhone 4 model continued to be sold unchanged up until September 2013.

### iPhones in space

In [2011](https://github.com/seanpm2001/WacOS/wiki/2011/), two iPhone 4 units equipped with a special application were taken to the International Space Station aboard the Space Shuttle on the STS-135 mission. The devices were used in various experiments, utilizing sensors and a special app.

***

## Sources

[Wikipedia - iPhone 4](https://en.wikipedia.org/wiki/IPhone_4)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Tuesday September 28th at 7:51 pm`

**Last revised on:** `2021 Tuesday September 28th at 7:51 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `406`

**Article version:** `1 (2021 Tuesday September 28th at 7:51 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

