
***

# iPhone 3G

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/3G/IPhone_3G_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/3G/IPhone_3G_logo.svg)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/3G/IPhone_1st_Gen.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/3G/IPhone_1st_Gen.svg)

## Technical specifications

### Developer

Apple Inc.

### Manufacturer

Foxconn

### Slogan

"The iPhone you have been waiting for."

"The first phone to beat the iPhone."

"Twice as fast, for half the price."

"The most advanced mobile OS. Now even more advanced."

"New features, new price."

### Generation

2nd

### Model

A1324 (China)

A1241

### First released

July 11, [2008](https://github.com/seanpm2001/WacOS/wiki/2008/);

### Discontinued

June 7, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/);

### Units sold

1 million over first weekend (need a source on how many units sold total)

### Predecessor

[iPhone 2G](https://github.com/seanpm2001/WacOS/wiki/iPhone-2G/)

### Successor

[iPhone 3GS](https://github.com/seanpm2001/WacOS/wiki/iPhone-3GS/)

### Type

Smartphone

### Form factor

Slate

### Dimensions

115.5 mm (4.55 in) H

62.1 mm (2.44 in) W

12.3 mm (0.48 in) D

Mass	133 g (4.7 oz)

### Operating system

Original: [iPhone OS 2.0](https://github.com/seanpm2001/WacOS/wiki/iPhoneoS-2/)

Last: [iOS 4.2.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), released November 22, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/)

### CPU

Samsung 32-bit RISC ARM 1176JZ(F)-S v1.0

620 MHz

Underclocked to 412 MHz

### Memory

128 MB DRAM

### Storage

8 or 16 GB flash memory

### Battery

1150 mAh, 3.7 V Lithium-ion battery

### Data inputs

Multi-touch touchscreen display

3-axis accelerometer

Proximity sensor

Ambient light sensor

Microphone

Headset controls

### Display

3.5-inch screen (diagonally)

480×320 pixel resolution at 163 ppi

3:2 aspect ratio

18-bit (262,144-color) LCD

### Rear camera

2.0 MP with geotagging

### Sound

3.5 mm TRRS

One speaker

20 Hz to 20 kHz frequency response (internal, headset)

Microphone

### Connectivity

Quad-band GSM/GPRS/EDGE

(850 900 1,800 1,900 MHz)

Tri-band UMTS/HSDPA 3.6

(850 1,900 2,100 MHz)

Wi-Fi (802.11 b/g)

Bluetooth 2.0 + EDR

USB 2.0/Dock connector

## About

The iPhone 3G is a smartphone designed and marketed by Apple Inc.; it is the second generation of iPhone, successor to the original [iPhone](https://github.com/seanpm2001/WacOS/wiki/iPhone-2G/), and was introduced on June 9, [2008](https://github.com/seanpm2001/WacOS/wiki/2008/), at the WWDC 2008 at the Moscone Center in San Francisco, United States.

The iPhone 3G is internally similar to its predecessor, but included several new hardware features, such as GPS, 3G data and tri-band UMTS/HSDPA. The device was originally loaded with the concurrently launched [iPhone OS 2.0](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-2/). In addition to other features (including push email and turn-by-turn navigation), this new operating system introduced the App Store—Apple's new distribution platform for third-party applications.

## History

On July 11, [2008](https://github.com/seanpm2001/WacOS/wiki/2008/), Apple released the iPhone 3G across twenty-two countries in two storage options, 8GB and 16GB. The 16GB model was produced in either black or white. It was sold for a suggested retail price of $199 (US) for the 8GB model and $299 (US) for the 16GB model.

Following the release of the successor [iPhone 3GS](https://github.com/seanpm2001/WacOS/wiki/iPhone-3GS/) model one year later, the iPhone 3G remained on sale but became Apple's budget phone offer, with its price reduced. This $99 iPhone 3G required a two-year contract and was available only in black and with 8 GB of storage, but came bundled with the then-new [iPhone OS 3.0](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-3/) firmware. On June 7, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/), the iPhone 3G was finally discontinued, and replaced as Apple's budget phone by an 8GB iPhone 3GS selling for the same price of $99 with a 2-year contract.

## Software

The iPhone 3G came preloaded with the latest version of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) and continued to receive updates to its software for over two years, with major iterations released on an annual basis. However, the phone had access to a decreasing proportion of new features with each update as its hardware became superseded by later models.

When it was launched, the iPhone 3G came preloaded with [iPhone OS 2.0](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-2/). This introduced the App Store, Microsoft Exchange ActiveSync support, Apple's MobileMe service, and push email support, along with other new features and bug fixes.

In June [2009](https://github.com/seanpm2001/WacOS/wiki/2009/), iPhone 3G users received the [iPhone OS 3.0](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-3/) software update, which introduced the long-awaited MMS feature, copy and paste, landscape support for more applications, Bluetooth stereo support, and other improvements.

In June [2010](https://github.com/seanpm2001/WacOS/wiki/2010/), Apple released the [iOS 4.0](https://github.com/seanpm2001/WacOS/wiki/iOS-4/) software update. Unlike its successor models, the iPhone 3G does not support prominent features of [iOS 4.0](https://github.com/seanpm2001/WacOS/wiki/iOS-4/) such as multitasking, the ability to set a home screen wallpaper, or Bluetooth keyboard support. However, it does provide access to a unified mailbox feature, homescreen folders to better organize apps, playlist creation, and other enhancements. This update was widely criticized for slow performance on iPhone 3G, though September 2010's [iOS 4.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) release resolved this problem. However, unlike more modern iOS devices, this update again does not provide iPhone 3G owners with access to important features, in this case, the Game Center Application.

On November 22, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/), the iPhone 3G received the [iOS 4.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) software update (as [iOS 4.2.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/)), which introduced features such as YouTube voting, and security fixes. However, the iPhone 3G is unable to use many features included in this update, such as AirPlay and Safari Text Search. This is the last iOS release to support this iPhone model; [iOS 4.3](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) and later are not compatible with this iPhone model due to hardware limitations and performance issues.

Virtually all apps released after the release of iOS 6 in late September 2012 do not run on the iPhone 3G, as the software development kit (SDK) was changed to no longer allow the "targeting" (minimum) of iOS versions older than 4.3 (including 3.x and up to 4.2.1), or ARMv6 devices (first two generations).

## Hardware

### Design

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/3G/IPhone_%26_iPhone_3G.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/3G/IPhone_%26_iPhone_3G.jpg)

A rear view of the original iPhone (left) made of aluminum and plastic, and the iPhone 3G (right), made entirely from a hard plastic material.

The iPhone 3G's back featured a redesigned polycarbonate plastic housing, replacing the aluminum back of the first generation. Buttons were changed from plastic to metal, and the edges of the phone were tapered, providing a better grip. The iPhone 3G introduced the first official color options for the outer casing, with the 16GB version available in black and white.

The dimensions of the iPhone 3G were marginally larger than those of the original iPhone. It was 116 millimetres (4.6 in) high, 62 millimetres (2.4 in) wide, and 12 millimetres (0.47 in) deep, compared to its predecessor, which was 110 millimetres (4.3 in) high, 61 millimetres (2.4 in) wide, and 12 millimetres (0.47 in) deep.

The iPhone 3G sported a 3.5 in (89 mm) capacitive touchscreen with a 480×320 (HVGA) resolution at 163 ppi. The scratch-resistant glass sits on top of the display. Just like the original iPhone, the touchscreen was designed for a bare finger, or multiple fingers for multi-touch sensing. The device featured the same sensors as its predecessor. The proximity sensor (which deactivates the display during calls when the face is near) was repositioned to save battery power and to prevent inadvertent inputs from the user's face and ears. An ambient light sensor was included to adjust the display brightness for different lighting conditions, which helps save battery power. A 3-axis accelerometer was included to sense the orientation of the phone and change the screen accordingly, allowing the user to easily switch between portrait and landscape mode.

### Processor and memory

Most of the iPhone 3G's internal hardware is based on the original [iPhone](https://github.com/seanpm2001/WacOS/wiki/iPhone-2G/). It still includes a Samsung 32-bit RISC ARM11 620 MHz processor (underclocked to 412 MHz), a PowerVR MBX Lite 3D GPU, and 128 MB of package on package (PoP) DRAM.

### Rear camera

On the rear of the device, the iPhone 3G features the same fixed-focus 2.0 megapixel camera of its predecessor. This camera does not have optical zoom, flash, autofocus, or native video recording, although various applications became available to allow video recording on the device. The iPhone 3G's operating system supports the geotagging of photographs.

### Connectivity

In addition to EDGE, the iPhone 3G supports Assisted GPS, 3G data, and tri-band UMTS/HSDPA. These enhancements allow faster data downloads and turn-by-turn navigation with maps compared to previous devices.

Like its predecessor, the iPhone 3G features a proprietary 30-pin dock connector for charging the device. It can also be used to synchronize the device with a computer and to connect various accessories.

The iPhone 3G features a flush-mounted 3.5 mm headphone jack instead of the recessed headphone jack that was included on the original iPhone; it could, therefore, be used with any headphones other than those provided by Apple.

## Battery

The iPhone 3G features an internal rechargeable battery rated at 1150 mAh, which, like its predecessor, is not user-replaceable. Apple stated that the iPhone 3G's battery is capable of providing up to six hours of web browsing via Wi-Fi, or five hours via 3G, or 25 hours of audio playback. Alternatively, it is said to provide 300 hours of standby time.

## Reception

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/3G/Line_at_Apple_Store_in_NYC.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/3G/Line_at_Apple_Store_in_NYC.jpg)

_Line of people waiting for the iPhone 3G outside of the Apple Store in New York City, 2008._

Walt Mossberg of The Wall Street Journal described the device as "a more capable version of an already excellent device." However, he said that it had "hidden costs."[19]

## Issues

### Battery drain

[iOS 4](https://github.com/seanpm2001/WacOS/wiki/iOS-4/), which was still compatible with the iPhone 3G, was released on June 21, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/). An article in the Wall Street Journal's Digits column on July 28, 2010, reported that iPhone 3G phones updating to [iOS 4](https://github.com/seanpm2001/WacOS/wiki/iOS-4/) responded slowly, had diminished battery life, and became excessively hot.

## Sources

[Wikipedia - iPhone 3G](https://en.wikipedia.org/wiki/IPhone_3G)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Tuesday September 28th at 6:05 pm`

**Last revised on:** `2021 Tuesday September 28th at 6:05 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `263`

**Article version:** `1 (2021 Tuesday September 28th at 6:05 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

