
***

# iPhone 3GS

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/3GS/IPhone_3GS_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/3GS/IPhone_3GS_logo.svg)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/3G/IPhone_1st_Gen.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/3G/IPhone_1st_Gen.svg)

## Technical specifications

### Developer

Apple Inc.

### Manufacturer

Foxconn

### Slogan

"The fastest, smartest phone yet." (2009–2010)

"More to love. Less to pay." (2010–2012)

### Generation

3rd

### Model

A1325 (China)

A1303

### Compatible networks

Quad-band GSM/GPRS/EDGE

(850, 900, 1800, 1900 MHz)

Tri-band UMTS/HSDPA

(850, 1900, 2100 MHz)

### First released

June 19, [2009](https://github.com/seanpm2001/WacOS/wiki/2009/)

### Discontinued

June 24, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/) (16, 32GB)

September 12, [2012](https://github.com/seanpm2001/WacOS/wiki/2012/) (8GB)

### Predecessor

[iPhone 3G](https://github.com/seanpm2001/WacOS/wiki/iPhone-3G/)

### Successor

[iPhone 4](https://github.com/seanpm2001/WacOS/wiki/iPhone-4/)

### Type

Smartphone

### Form factor

Slate

### Dimensions

115.5 mm (4.55 in) H

62.1 mm (2.44 in) W

12.3 mm (0.48 in) D

Mass 135 g (4.8 oz)

### Operating system

Original: [iPhone OS 3.0](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-3/)

Last: [iOS 6.1.6](https://github.com/seanpm2001/WacOS/wiki/iOS-6/), released February 21, [2014](https://github.com/seanpm2001/WacOS/wiki/2014/)

### System on chip

Samsung S5PC100

### CPU

600 MHz ARM Cortex-A8

### GPU

PowerVR SGX535

### Memory

256 MB DRAM

### Storage

8, 16 or 32 GB flash memory

### Battery

Built-in rechargeable lithium-ion battery

3.7 V 1220 mAh

### Data inputs

Multi-Touch touchscreen display

3-axis accelerometer

Digital compass

Proximity sensor

Ambient light sensor

Microphone

Headset controls

### Display

3.5 in (89 mm) diagonal 3:2 aspect ratio screen

24-bit (16.76 million colors) LCD

480×320 pixel resolution at 163 ppi

### Rear camera

3 MPix with video (VGA at 30 fps)

Photo and video geotagging

Tap to focus video or still images

Exposure

### Sound

Single loudspeaker

3.5 mm TRRS, 20 Hz to 20 kHz frequency response (internal, headset)

Microphone

### Connectivity

Wi-Fi (802.11 b/g)

Bluetooth 2.1+EDR

Dock connector

SAR Head: 1.19 W/kg

Body: 0.67 W/kg

## About

The iPhone 3GS (originally styled iPhone 3G S) is a smartphone that was designed and marketed by Apple Inc. It is the third generation iPhone and the successor to the [iPhone 3G](https://github.com/seanpm2001/WacOS/wiki/iPhone-3G/). It was unveiled on June 8, [2009](https://github.com/seanpm2001/WacOS/wiki/2009/) at the WWDC 2009 which took place at the Moscone Center in San Francisco.

This iPhone is named "3GS" where "S" stood for Speed (Phil Schiller had mentioned it in the launch keynote). Improvements include performance, a 3-megapixel camera with higher resolution and video ability, voice control, and support for 7.2 Mbit/s HSDPA downloading (but remains limited to 384 kbps uploading as Apple had not implemented the HSUPA protocol). It was released in the United States, Canada, and six European countries on June 19, [2009](https://github.com/seanpm2001/WacOS/wiki/2009/), in Australia and Japan on June 26, and internationally in July and August [2009](https://github.com/seanpm2001/WacOS/wiki/2009/).

The iPhone 3GS runs Apple's [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) operating system. It was succeeded as Apple's flagship smartphone in [2010](https://github.com/seanpm2001/WacOS/wiki/2010/) by the [iPhone 4](https://github.com/seanpm2001/WacOS/wiki/iPhone-4/). On June 24, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/) an 8GB model was released, discontinuing the 16 and 32GB models. However, the 3GS continued in production until September [2012](https://github.com/seanpm2001/WacOS/wiki/2012/) when the [iPhone 5](https://github.com/seanpm2001/WacOS/wiki/iPhone-5/) was announced.

## History

The iPhone 3GS was released on June 19, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/) in the United States, Canada, France, Germany, Italy, Spain, Switzerland, and the United Kingdom. Within the first weekend of its release, over 1 million iPhone 3GS units were sold. It reached its first million units sold as quickly as its predecessor, the [iPhone 3G](https://github.com/seanpm2001/WacOS/wiki/iPhone-3G/).

## Features

The new features of the iPhone 3GS are mainly internal changes regarding speed. The iPhone 3GS is 2x faster than its [predecessor](https://github.com/seanpm2001/WacOS/wiki/iPhone-3G/). Though in addition to the upgrades mainly regarding performance, various software features were also introduced exclusively to the iPhone 3GS such as video recording, voice control, and digital compass.

### Operating system and software

The iPhone 3GS features [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/), Apple's mobile operating system. The user interface of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) is based on the concept of direct manipulation, using multi-touch gestures. Interface control elements consist of sliders, switches, and buttons. Interaction with the OS includes gestures such as swipe, tap, pinch, and reverse pinch, all of which have specific definitions within the context of the [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) operating system and its multi-touch interface. Internal accelerometers are used by some applications to respond to shaking the device (one common result is the undo command) or rotating it vertically (one common result is switching from portrait to landscape mode).

### Hardware

The LCD display on the device was designed by Apple and made by LG. It features a capacitive touchscreen with a pixel density of 163 pixels per inch (ppi) on a 3.5 in (8.9 cm) 480-by-320 display. Improvements over its predecessor's screen include 24-bit color emulation (18-bit color display plus dithering) for a more color rich display and oleophobic coating to help reduce fingerprints on the display. The capacitive touchscreen is designed for a bare finger, or multiple fingers for multi-touch sensing.

The iPhone 3GS features an improved 3-megapixel camera manufactured by OmniVision. In addition to the higher pixel count, it also features auto-focus, auto white balance and auto macro and is capable of capturing VGA video.

The iPhone 3GS's camera app features a slider which allows users to switch between capturing photos and recording videos, a tap-to-focus feature which allows users to tap on an area of the camera image to auto-focus on, 5x digital zoom (iOS 4 or later), autofocus and auto exposure lock when holding an area down (iOS 5 or later), and gridlines for composition (iOS 5 or later).

The iPhone 3GS is powered by the Samsung APL0298C05 chip, which was designed and manufactured by Samsung. This is the first iPhone with a system-on-a-chip. This system-on-a-chip is composed of an ARM Cortex-A8 CPU core underclocked to 600 MHz (from 833 MHz), integrated with a PowerVR SGX 535 GPU.

It has 256 MB of package on package (PoP) DRAM, twice the amount of the 3G, allowing for increased performance and multi-tasking.

Apple claims the iPhone 3GS is 2x faster than its [predecessor](https://github.com/seanpm2001/WacOS/wiki/iPhone-3G/), showing demonstrations of various apps loading in half the time its predecessor does.

As on previous models, all data is stored in flash memory and not in the SIM and it does not offer any options to expand storage. Initially, it was only available in 16 and 32 GB though an 8 GB model was later released, with Apple discontinuing the 16 and 32 GB models, forcing those needing more storage to select an [iPhone 4](https://github.com/seanpm2001/WacOS/wiki/iPhone-4/), or buy an older model 3GS.

The iPhone 3GS is powered by an internal 3.7 V 1220 mAh rechargeable lithium-ion polymer battery and is designed to retain up to 80% of its original capacity after 400 full charge and discharge cycles. A battery life indicator in percentage was also exclusive to the iPhone 3GS.

Apple claims that the 3GS can last for up to ten hours of video, nine hours of web browsing on Wi-Fi, twelve hours of 2G talk time, or five on 3G, 30 hours of music, or 300 hours of standby.

A magnetometer is also built-in the iPhone 3GS, which is used to measure the strength and/or direction of the magnetic field in the vicinity of the device. Sometimes certain devices or radio signals can interfere with the magnetometer requiring users to either move away from the interference or re-calibrate by moving the device in a figure 8 motion. The iPhone 3GS also features a Compass app that was unique at the time of release, showing a compass that points in the direction of the magnetic field.

In addition to the iPhone 3G's Tri-band UMTS/HSDPA radio and quad-band GSM/GPRS/EDGE radio, the 3GS also adds support for 7.2 Mbit/s HSDPA allowing faster downlink speeds though upload speeds remain the same as Apple had not implemented the HSUPA protocol. Other updates include the addition of a built-in Nike+iPod sensor which eliminates the need for an external sensor and allows native Nike+iPod support. The Bluetooth server on the iPhone 3GS has also been slightly improved adding support for Bluetooth 2.1 specifications.

Voice Control was introduced as an exclusive feature of the iPhone 3GS and allows for the controlling of the phone and music features of the phone by voice. There are two ways to activate Voice Control: hold the Home button while in the home screen for a few seconds; or, change the effect of what double-clicking the home button does so it will activate Voice Control (only on [iOS 3.x](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-3/); on [iOS 4](https://github.com/seanpm2001/WacOS/wiki/iOS-4/) or later, double-clicking the Home button opens the multitasking bar).

VoiceOver, Color Inversion, and Text Zoom were introduced as exclusive features to the iPhone 3GS. VoiceOver is a feature that dictates music details, system menus, text, and other things that were first introduced on the third generation iPod shuffle. Color inversion reverses the color scheme from black on white to white on black, while Text Zoom allows users to zoom into a text on the screen.

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/3GS/IPhone_3G_and_3G_S_backs.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/3GS/IPhone_3G_and_3G_S_backs.jpg)

_The reverse of the iPhone 3G (left) is almost identical to that of the 3GS, except for the latter's reflective silver text which now matches the silver Apple logo, replacing the 3G's grey text._

The iPhone 3GS retains the design of the [3G](https://github.com/seanpm2001/WacOS/wiki/iPhone-3G/), with a glossy plastic back with tapered edges and metal buttons. The 3GS has reflective silver text on the reverse side which matches the silver Apple logo, replacing the [3G's](https://github.com/seanpm2001/WacOS/wiki/iPhone-3G/) grey text. The iPhone 3GS was available in white and black for 16 GB and 32 GB, although the 8 GB model was only available in black.

## Critical reception

Reviews of the iPhone 3GS have been mixed. Walt Mossberg of The Wall Street Journal described the device packed with "new features that makes a great product even better, but for many users, the software may be enough of a boost to keep them from buying the new model." Engadget also said that "the additions of video recording, a compass, and a speed bump just don't seem that compelling to us."

The device managed to receive numerous favorable reviews. CNET gave the iPhone 3GS 4 out of 5 stars, citing battery life improvements and speed bump. Engadget praised the performance improvements.

The 8 GB version received more favorable reviews mainly because it comes pre-installed with [iOS 4](https://github.com/seanpm2001/WacOS/wiki/iOS-4/). Jason Snell of Macworld praised the iPhone 3GS, saying that "the device's internal changes shines in the iOS 4 update, making the iPhone 3GS a worthwhile upgrade compared to its predecessor although a little too late compared to the [iPhone 4](https://github.com/seanpm2001/WacOS/wiki/iPhone-4/)." TIPB stated that "aside from hardware-specific features like FaceTime, Retina Display, and gyroscope support, the bottom line is iPhone 3GS users are getting the same software that makes the [iPhone 4](https://github.com/seanpm2001/WacOS/wiki/iPhone-4/) great."

## Issues

Shortly after the release of the iPhone 3GS, some users reported overheating of the device while in heavy use, and others reported discoloration of the device due to heat (particularly on the white models). The discoloration issues were largely discounted as being as a result of iPhone covers rubbing against the back of the iPhone.

Apple responded to the heat issue reports by warning users against leaving their iPhones in a car on a hot day, leaving it in direct sunlight for extended periods of time, and refraining from heavy usage while in a hot/sunny environment. It is also worth pointing out the temperature specifications in which the iPhone should be operated, which follows safety standards in the countries the 3GS was released.

## Continued support

### iOS 4

After the release of the [iPhone 4](https://github.com/seanpm2001/WacOS/wiki/iPhone-4/), the iPhone 3GS received an update for [iOS 4](https://github.com/seanpm2001/WacOS/wiki/iOS-4/).

### iOS 5

After the release of the [iPhone 4S](https://github.com/seanpm2001/WacOS/wiki/iPhone-4S/), the 3GS was still offered for free on a contract until November 2011, when AT&T raised the price to 59 cents with no explanation. The 99¢ price was only available with a two-year contract on AT&T in the United States and a three-year contract on Telus, Rogers, Bell and Fido Solutions in Canada. This was a departure from Apple's previous trends, in which only two phones were sold.

### New bootrom and 2011 baseband update

On September 9, [2009](https://github.com/seanpm2001/WacOS/wiki/2009/), Apple launched an updated model of the iPhone 3GS that patched a segment overflow in the SecureROM of the Device that had allowed loading an unsigned LLB.

After the release of the iPhone 4S, Apple updated baseband hardware from an Infineon Baseband chip to a Toshiba Baseband chip in week 2 production in [2011](https://github.com/seanpm2001/WacOS/wiki/2011/) which removed the end-user's ability to change basebands. Although the new chip uses the same modem firmware as the Infineon chip, it cannot be updated to iPad baseband 06.15.00 that is still vulnerable to the AT+XAPP exploit.

### iOS 6

The 3GS received [iOS 6](https://github.com/seanpm2001/WacOS/wiki/Ios-6/), making it the first [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) device to receive updates for four major [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) releases. Although the 3GS was still supported, some major features of [iOS 6](https://github.com/seanpm2001/WacOS/wiki/iOS-6/) were not supported. The 3GS had generally positive reviews of smooth performance on [iOS 5](https://github.com/seanpm2001/WacOS/wiki/iOS-5/) (some even claim better performance), making it still a good candidate for [iOS 6](https://github.com/seanpm2001/WacOS/wiki/iOS-6/). On September 12, [2012](https://github.com/seanpm2001/WacOS/wiki/2012/), Apple announced that they would no longer be selling and supporting the iPhone 3GS and the device did not receive [iOS 7](https://github.com/seanpm2001/WacOS/wiki/iOS-7/), due to hardware limitations. On February 21, [2013](https://github.com/seanpm2001/WacOS/wiki/2013/), Apple issued [iOS 6.1.6](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) to fix the infamous "goto fail;" SSL security bug.

***

## Sources

[Wikipedia - iPhone 3GS](https://en.wikipedia.org/wiki/IPhone_3GS)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Tuesday September 28th at 7:24 pm`

**Last revised on:** `2021 Tuesday September 28th at 7:24 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `287`

**Article version:** `1 (2021 Tuesday September 28th at 7:24 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

