  
***

# iOS version history

( **Predecessor:** [iPhoneOS version history](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-version-history/) | **Successor:** [iPadOS Version history](https://github.com/seanpm2001/WacOS/wiki/iPadOS-Version-history/) )

**This article may not load within the Wiki. If you are reading this message, you either found the source code, or are viewing the separate `README.md` file, or the article is now able to load.**

**As of 2021 September 28th, iOS 12 and later are still supported and are receiving updates. The data here will need to be updated in the future.**

The version history of the mobile operating system [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/), developed by Apple Inc., began with the release of [iPhone OS](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS/) for the original [iPhone](https://github.com/seanpm2001/WacOS/wiki/iPhone-2G/) on June 29, [2007](https://github.com/seanpm2001/WacOS/wiki/2007/). Since its initial release, it has been used as the operating system for iPhone, iPad, iPod Touch, and HomePod, seeing continuous development since then, resulting in new major releases of the software typically being announced at the annual Apple Worldwide Developers Conference and later released in September, coinciding with the release of new iPhone models. Starting with the [13.0](https://github.com/seanpm2001/WacOS/wiki/iOS-13/) release, the operating system for iPad was split off as [iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/). The latest stable version of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) and [iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/), 15.0, was released on September 20, [2021](https://github.com/seanpm2001/WacOS/wiki/2021/). The latest beta version of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) and [iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/), 15.1 beta, was released on September 21, [2021](https://github.com/seanpm2001/WacOS/wiki/2021/).

Updates can be done over-the-air through settings (since [iOS 5](https://github.com/seanpm2001/WacOS/wiki/iOS-5/)), or via the iTunes or Finder applications.

## Overview

June 2007 saw the official release of what eventually became [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) – concurrently with the first [iPhone](https://github.com/seanpm2001/WacOS/wiki/iPhone-2G/). [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) did not have an official name until the official release of the iPhone software development kit (iPhone SDK) on March 6, [2008](https://github.com/seanpm2001/WacOS/wiki/2008/). Before then, Apple marketing simply stated that iPhone ran a version of [Mac OS X](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/) made specifically for the iPhone. When [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) was introduced, it was named iPhone OS. It was officially renamed [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) on June 7, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/), with the announcement and introduction of the first-generation iPad. The introduction of what would later become the iPad line, and the existence of iPod Touch, meant the iPhone was no longer the only device to run the mobile operating system. [iOS 4](https://github.com/seanpm2001/WacOS/wiki/iOS-4/) was the first major [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) release that reflected the name change. Apple licensed the "iOS" trademark from Cisco Systems.

Apple concurrently provides the same version of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) for the comparable model of iPhone and iPod Touch, usually devices released in the same calendar year. iPhone users receive all software updates for free, while iPod Touch users paid for the 2.0 and 3.0 major software updates. As of [iOS 4](https://github.com/seanpm2001/WacOS/wiki/iOS-4/), Apple no longer charges for iPod Touch updates.

As of [2020](https://github.com/seanpm2001/WacOS/wiki/2020/), four versions of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) were not publicly released, with the version numbers of three of them changed during development. [iPhone OS 1.2](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-version-history/) was replaced by a 2.0 version number after the first beta; the second beta was named 2.0 beta 2 instead of 1.2 beta 2. The second was iOS 4.2, replaced with 4.2.1 due to a Wi-Fi bug in 4.2 beta 3, causing Apple to release 2 golden masters (4.2 GM and 4.2.1 GM). The third was iOS 13.4.5, which was renamed to iOS 13.5 when Beta 3 was released, with the introduction of the Exposure Notification API, which required an SDK update. Similarly, iOS 13.5.5 was renamed to iOS 13.6 in beta 2, with the introduction of new features for the Health app.

One version of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) was pulled back by Apple after being released (iOS 8.0.1) due to issues with cellular service and Touch ID on iPhone 6 and iPhone 6 Plus units.

Current [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/)/[iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/) versions Version Build Architecture Release date Device end-of-life

iPad iPhone iPod Touch

3.1.3 7E18 32-bit ARM February 2, 2010 N/A 1st gen 1st

4.2.1 8C148 November 22, 2010 3G 2nd

5.1.1 9B206 May 7, 2012 1st gen N/A 3rd

6.1.6 10B500 February 21, 2014 N/A 3GS 4th

7.1.2 11D257 32/64-bit ARM June 30, 2014 4 N/A

9.3.5 13G36 August 25, 2016 2, 3rd, Mini N/A 5th

9.3.6 13G37 July 22, 2019 4S N/A

10.3.3 14G60 July 19, 2017 4th 5C

10.3.4 14G61 July 22, 2019 5

12.5.5 16H62 64-bit ARM September 23, 2021 Air (1st), Mini 2, Mini 3 5S, 6 6th

15.0 19A346 September 20, 2021 N/A

15.1 beta 19B5042h September 21, 2021

Legend:   Discontinued   Old, still maintained   Current   Beta

## Version history

**See iPhoneOS 1-3 history:** [Click/tap here](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-version-history/)

### iOS 4

<!--
<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 4 logo</p></summary>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS4_logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS4_logo.png)

<!-- Image is small enough and not too intrusive, so the dropdown isn't needed this time.
</details>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_4_Homescreen.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_4_Homescreen.png)

Apple announced [iOS 4](https://github.com/seanpm2001/WacOS/wiki/iOS-4/) in March [2010](https://github.com/seanpm2001/WacOS/wiki/2010/) and it was released to the public on June 21, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/), alongside the iPhone 4. With this release, Apple dropped support for the original iPhone and the 1st generation iPod Touch, which is the first time Apple had dropped support for any device in an [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) release. The iPhone 3G and the 2nd generation iPod Touch were capable of running [iOS 4](https://github.com/seanpm2001/WacOS/wiki/iOS-4/), but had limited features. For example, both devices lack multitasking capabilities and the ability to set a home screen wallpaper. However, [iOS 4](https://github.com/seanpm2001/WacOS/wiki/Ios-4/) was the first major release that iPod Touch users did not have to pay any money for. The release of iOS 4.2.1 brought compatibility to the original iPad and was the final release supported on the iPhone 3G and 2nd generation iPod Touch due to major performance issues. The release of iOS 4.3 brought iPad 2 compatibility.

#### iOS 4.0

iPhone:

3G 3GS 4

iPod touch:

2nd 3rd

Limited support on iPhone 3G and iPod Touch (2nd generation); initial release on iPhone 4; only available on iPhone and iPod Touch.

Version Build Release date Features

4.0 8A293 P2 P3 P4 T2 T3 June 21, 2010; 11 years ago 

Multitasking P3 P4 T3

User interface for app switching by double clicking Home button.

Portrait orientation lock.P3 P4 T3

iPod control widget.

FaceTime direct video calling ability over Wi-Fi (iPhone 4 and later, iPod Touch (4th generation), and OS X users).

iBooks sync support through iTunes for iPhone and iPod Touch.

iAd mobile advertising network.

Settings

App-specific location settings.

Cellular data toggle (on-off).

"Complex Password" setting: passwords with alphabet characters and numbers.

Simple Passcode Lock (4 digit number) option.

New wallpapers.

Wallpaper available for Home screen.P3 P4 T3

New wallpaper preview for Home screen and lock screen.

Support for Internet tethering.

New Gmail and Exchange icons in Mail, Contacts, Calendars account settings.

Support multiple Exchange accounts.

Custom Dictionary.

Airplane Mode for iPod Touch.

Separated Sounds settings from General settings.

Home screen

Ability to categorize apps into folders with default folder naming based on category name in App Store.

Up to 2,160 instead of 180 visible apps (12 apps per folder).

Folder name supports up to 13 characters.

Custom Home screen wallpaper.

Dock redesigned to that of the iPad dock.

Rate on deleting app removed.

Default Utilities folder which contains the Clock, Calculator, Voice Memos and Compass apps.

Revised scrolling on the Home Screen.

Camera

Up to 5x digital (as opposed to optical) zoom feature on the Camera app.

Tap to focus during video.P3 P4

Photos

Categorized by Albums, Faces, Events and Places (under iPhoto in OS X).

Support landscape mode.

Camera Roll

Support landscape mode.

App Store

Ability to gift apps.

Maps

Unified "locate me" icon.

Background location icon shown on status bar.

iPod

Playlist creation on device.

Nested playlists.

Lyrics and Podcast info in Settings.

Bluetooth headsets now support volume control.

Album art displayed in Album view.

Notes

Notes syncing with MobileMe, Gmail IMAP and Yahoo! Mail.

Accounts management appears if syncing is enabled.

Notes setting below Mail, Contacts, Calendars Settings if syncing is enabled.

Moved search box into title bar.

Calendar

Birthday calendar.

CalDAV invitations.

Ability to edit which calendar an event is located in after the initial saving.

Ability to select any combination of calendar categories to view.

Contacts

Unified info by linking contacts from different accounts.

CardDAV.

Streamlined "New Contact" screen.

Spotlight

Search with Web or Wikipedia.

Search Messages.

Safari

Bing is now a search option, along with Google and Yahoo!.

Recent searches below search field.

Top hit in search.

Suggestions appear below search field for all 3 search engines.

Unified "Search" keyboard button when search field being used.

In-page audio playback.

Voice control

The ability to ask what the current time is.P3 P4 T3

YouTube

Rotate and zoom videos in vertical and horizontal position.

Latest 480p for smoother and quicker video playback.

Accessibility

Larger fonts in Contacts, Mail, Messages and Notes.P3 P4 T3

Message

Include a Search bar.

Character count (can be enabled or disabled in Settings > Messages screen).

Failed SMS notification.

Option to toggle off the ability to send group messages.

Mail

Unified inboxes.

Edit from outbox.

Support for multiple Exchange accounts.

File and delete Mail search results.

Organize by thread in Mail.

Quick look attachments.

Open attachments by registered filetype with corresponding apps from the App Store.

Smart links for dates and addresses.

Contact pictures in emails.

Create Calendar events from dates within emails.

International

Spell check.

Added Cangjie and Wubihua keyboards for Simplified and Traditional Chinese.

Text replacement between Simplified and Traditional Chinese.

Switch keyboard shortcut (holding the "Earth" button on keyboard for a while).

Added support for Danish voice control.

New languages added (Catalan, Hungarian, Vietnamese).

Other

Support for Apple Bluetooth keyboards.P3 P4 T3

Persistent Wi-Fi.

Added support for iBooks application.

Wake on wireless.

Auto-join and auto-login and IPv6 on individual Wi-Fi networks setting.

Enhanced data protection.P3 P4 T3

Wireless app distribution.

Mobile device management.

SSL VPN support (both Juniper and Cisco).

Microsoft Exchange Server 2010 support.

Improved Bluetooth driver for A2DP devices.

Improved iOS animations.

Security Notes

http://support.apple.com/kb/HT4225

4.0.1 8A306 P2 P3 P4 July 15, 2010; 11 years ago iPhone only

Updated carrier signal strength display.

Increase in the length of the smaller signal bars.

The method in which signal strength is calculated was modified.

Fixed Exchange ActiveSync issues.

Only official SIM card number can be used for FaceTime identification.

4.0.2 8A400 P2 P3 P4 T2 T3 August 11, 2010; 11 years ago 

Patches a PDF exploit which allowed jailbreaking through Safari.

Security Notes

http://support.apple.com/kb/HT4291

#### iOS 4.1

iPhone:

3G 3GS 4

iPod touch:

2nd 3rd 4th

Initial release on iPod Touch (4th generation); limited support on iPhone 3G and iPod Touch (2nd generation). Only available on iPhone and iPod touch.
Version Build Release date Features
4.1 8B117 P2 P3 P4 T2 T3 T4 September 8, 2010; 11 years ago 

Improved calendar colors.

Bug fixes

iPhone 4 proximity sensor issues.

Bluetooth connectivity.

Improved performance on iPhone 3G.

Nike + iPod fixes and the Retina Display (iPhone 4 only).

Fixes white balance issue with iPhone 4 under certain lighting conditions.

Fixes FaceTime error where iPhone 3G and iPhone 3GS users could enter "facetime://" URLs in Safari.

Game Center.P3 P4 T2 T3 T4 no support for iPhone 3GP2 

Security updates to accessibility, FaceTime, ImageIO and WebKit.

Enables FaceTime call connection via email contacts (e.g. for iPod Touch (4th generation) users who won't have a phone number) and through favorites.

Nike + iPod statistics submissions over Wi-Fi.

High dynamic range imaging (HDR) (only available for the iPhone 4).

High-definition video uploads over Wi-Fi; iPhone 4 and iPod Touch (4th generation) only.

iTunes adds iTunes Ping, a social music network and discovery tool (only available in countries with iTunes Store).

TV show rentals (only available for iTunes US Store).

Can move an existing appointment from one calendar to another.

Notes syncing removed from iPhone 3G due to reported performance problems.

Restores Field test mode.

Security Notes: http://support.apple.com/kb/HT4334

#### iOS 4.2

iPad:

1st

iPhone:

3G 3GS 4

iPod touch:

2nd 3rd 4th

Limited support on iPhone 3G and iPod Touch (2nd generation).

Version Build Release date Features

4.2.1 8C148 P2 P4 T2 T3 T4 S1 S1C

8C148a P3 November 22, 2010; 10 years ago Final release supported on iPhone 3G and iPod Touch (2nd generation)

Bug fixes

Birthdays calendar does not display birthdays starting more than 77 years ago.

Fixes glitch that can let a user get into the Phone app while the phone is locked via "Emergency Call" by dialing a random number and quickly pressing the lock button after dialing that call.

Fixes the alarm bug caused by daylight saving time changing, affected on a part of iPhone and iPod Touch owners living in various countries.

Improved iPhone 3G and iPod Touch (2nd generation) performance.

AirPlay (replacement of AirTunes, AirPlay will offer stream video, music, and photos over Wi-Fi).

AirPrint wireless printing with Print Center (select models).

Import .ics calendar files directly for events.

Improved battery performance.

Birthdays icon has been changed in the Calendar app.

Text search on web pages.P3 P4 T3 T4

2 new fonts for Notes in Settings (Helvetica and Chalkboard).

Added support for Chinese URL over Safari.

Added an indicator in the App Store which shows if an app supports Game Center.

Support for CoreMIDI.

YouTube voting.

Minor improvements in UI graphics.

New parental controls for deleting apps, changing mail accounts and location services.

The font size of text in Calendar can now be changed in the Accessibility settings.

Security fixes.

Network-controlled fast dormancy implemented in baseband to improve battery life and reduce network congestion.

Fixes intermittent Wi-Fi issues in iOS 4.2 beta 3, which remained in the iOS 4.2 GM.

Fixes Voice over IP (VoIP) issues.

Find My iPhone location feature is free (iPhone 4, iPod Touch (4th generation), and iPad) running on iOS 4.2.1.P4 T4 S1 S1C

4.x support for the iPad.

iOS 4 features for iPad (multitasking, folders, etc.).

Up to 4,400 icons instead of 220 (20 apps a folder).

Updated carrier signal strength display (3G iPad only).

Increase in the length of the smaller signal bars.

The method in which signal strength is calculated has been enhanced.

Additions to the multitasking tray.

Brightness.

Volume control.

AirPlay controls.

Screen rotation lock switch.

Physical iPad screen rotation lock switch is converted into a sound/silent switch in iOS 4.2 (just like on the iPhones), with a virtual screen rotation lock switch added to the multitasking tray.

More than 30 new keyboards and dictionaries, including Arabic, Greek, and Hebrew.

New animation for Multitasking.

New bookmarks design (iPhone and iPod Touch only).

Additions to multitasking tray.

Volume controls.

AirPlay controls.

New Voice Memos icon.

Ability to initiate FaceTime calls from Voice Control.

FaceTime shortcut from Messages app (iPhone 4 only).

New text tone alerts (New and Original tone lists) (iPhone 4 only).

Ringer and alerts on/off switch (Settings > Sounds) for volume buttons (iPhone only).

Assign different text tone alerts to each contact.

Restores full field test mode.

Security Notes from iOS 4.2: http://support.apple.com/kb/HT4456

4.2.5 8E128 P4C January 11, 2011; 10 years ago Initial release on iPhone 4 (CDMA, Verizon version); deployed to demo and review units only, wasn't publicly released.

Adds Personal Hotspot.

4.2.6 8E200 P4C January 31, 2011; 10 years ago CDMA (Verizon) iPhone 4 only; released before the device's launch.

Bug fixes

Bug fixes for Personal Hotspot.

4.2.7 8E303 P4C April 14, 2011; 10 years ago CDMA (Verizon) iPhone 4 only

Security update.

Baseband update.

Security Notes: http://support.apple.com/kb/HT4607

4.2.8 8E401 P4C May 4, 2011; 10 years ago CDMA (Verizon) iPhone 4 only

Bug fixes

Reduced size of the iOS crowd-sourced location database cache.

No longer backs the cache up to iTunes.

Deletes it entirely when Location Services is turned off.

4.2.9 8E501 P4C July 15, 2011; 10 years ago CDMA (Verizon) iPhone 4 only; security update.

Disabled the possibility of viewing a maliciously crafted PDF file that may lead to an unexpected application termination or arbitrary code execution.

Disabled malicious code running as the user from gaining system privileges.

Security Notes: http://support.apple.com/kb/HT4803

4.2.10 8E600 P4C July 25, 2011; 10 years ago CDMA (Verizon) iPhone 4 only; security update.

Fixes a security vulnerability with certificate validation.

Security Notes: http://support.apple.com/kb/HT4825

#### iOS 4.3

iPad:

1st 2

iPhone:

3GS 4

iPod touch:

3rd 4th

Initial release on iPad 2

Version Build Release date Features

4.3 8F190

8F191 S2 S2C S2D March 9, 2011; 10 years ago 

AirPlay video support for third party apps.

HTTP Live Streaming statistics.

New font in Notes app ("Noteworthy").

Improved Safari performance with the Nitro JavaScript engine.

Redesigned "account" section under the Store menu.

Ability to switch on automatic downloads (for iTunes Music and App Store applications).

Location services have been shifted from General to Settings menu.

New parental controls for use with iTunes Ping.

New menu for scrubbing in videos.

Fine scrubbing: adjust by seconds / frames.

Quarter scrubbing: second.

Half speed scrubbing: adjust by minute(s).

Hi-speed scrubbing: run fast through minutes.

Ability to cancel and delete an app which is currently downloading. Before iOS 4.3, it was only possible to delete an app which had already downloaded.

Stream from an iTunes library to iOS using Home Sharing.

In-app purchases always ask for a password, even if one was entered before.

Internal system clock gets network time updated more often via NITZ (part of the official GSM standard since phase 2+ release 96) and gives a more accurate time for the device, it updates about every five days (iPhone only).

Personal Hotspot feature (Wi-Fi hotspot with up to 5 simultaneous devices (Wi-Fi hotspot iPhone 4 only)) on supported carriers.

Ability to set the number of times a text tone repeats (up to 10 times).

In field test mode refresh button has been removed and updated information has been displayed in bottom of the screen (it updates every 4–6 seconds).

Slideshow options moved to Photos app.

New look for taking a picture for a Contact.

When receiving a text message, the iPhone now vibrates 2 times.

Some SMS tones have been shortened (iPod Touch only).

New FaceTime icon (iPod Touch (4th generation) only).

Added FaceTime command in voice control (iPod Touch (4th generation) only).

New look for taking a picture for a Contact (iPod Touch (4th generation) only).

SMS App access through sms:num links is disabled (iPad only).

Ability to choose function of iPad's physical switch between rotation lock or mute.

Fullscreen iAd banner format.

Photo Booth and FaceTime app bug fixes (iPad 2 only).

Fixed issue that prevented controls from being dismissed in some cases.

Addressed issue where the keyboard could not be brought back when highlighting and swiping through search results.

VoiceOver now reads the entire chart in Stocks app while in landscape mode.

Fixed slideshow stop after 15 images when using AirPlay.

Enabled traffic volume indicator for IE (iPhone and iPad Wi-Fi + 3G only).

Fixed canceled recurring calendar events still showing on the event list.

Fixed deleting a recurring event make the alarm go away.

Fixed all-day alarm fired an hour early.

Fixed missing accented letters in European keyboard popups.

Increase font size for China and Pinyin inputs.

Fixed auto-correction issue when switch back from Emoji to English keyboard.

Fixed orientation of mail application not following device orientation under specific conditions.

Fixed mail message view and orientation when quickly selecting a message and hitting edit mode.

Fixed MMS messages with vCard]s scrolling up.

Added Address Space Layout Randomization (ASLR).

Added new icon for Wi-Fi tethering for personal hotspot on status bar.

Fixed issue that caused Safari and other apps to crash after loading certain heavy Web sites.

Fixed Personal Hotspot password failure with 22+ characters.

Added support for "find" in Safari.

Fixed wallpaper titles for VoiceOver.

Security Notes: http://support.apple.com/kb/HT4564

4.3.1 8G4 March 25, 2011; 10 years ago Bug fixes

Fixed graphics glitches on iPod Touch (4th generation).

Baseband updates for the iPhone 3GS and iPad (1st generation).

Fixed memory hang that results in memory corruption when reading large files from USIM filesystem.

Fixed problem with NTLM authentication in apps and on websites.

Fixed issue with the Springboard and 3rd party apps not recognizing the gyroscope on the iPad 2.

Fixes bugs related to activating and connecting to some cellular networks.

Fixes image flicker when using Apple Digital AV Adapter with some TVs.

Fixes an issue authenticating with some enterprise web services.

Changes the behavior of the battery percentage.

4.3.2 8H7P3 P4 S1 S2 S2C T3 T4

8H8S2D

April 14, 2011; 10 years ago Bug fixes

Fixed issue with blank or frozen video during (or before) a FaceTime call.

Fixed issue with connectivity to 3G networks on iPad Wi-Fi + 3G.

Fixed issue where Exchange redirection does not occur when ActiveSync server is on an Exchange 2010 server and user mailbox is on Exchange 2007.

Security notes: http://support.apple.com/kb/HT4606

4.3.3 8J2P3 P4 S2 S2C S2D T3 T4

8J3S1 S1C May 4, 2011; 10 years ago Bug fixes

This update contains changes to the iOS crowd-sourced location database cache.

Reduced size of the iOS crowd-sourced location database cache.

No longer backs the cache up to iTunes.

Deletes it entirely when Location Services is turned off.

No longer allows user to remove apps that have not been completely downloaded.

4.3.4 8K2 July 15, 2011; 10 years ago 

Re-introduced the ability to cancel and delete apps that are currently downloading.

Security fixes for jailbreak exploits.

Disabled the possibility of viewing a maliciously crafted PDF file that may lead to an unexpected application termination or arbitrary code execution.

Disabled a malicious code running as the user may gain system privileges.

Disabled "incomplete signing attacks", blocking "Untethered" jailbreak.

Security Notes: http://support.apple.com/kb/HT4802

4.3.5 8L1 July 25, 2011; 10 years ago Security Update

Final version of iOS 4 for iPhone 3GS, iPhone 4, iPod Touch, iPad (1st generation), iPad 2, and iPod Touch (3rd and 4th generations).

Fixes a security vulnerability with certificate validation.

Security Notes: http://support.apple.com/kb/HT4824

### iOS 5

<!--
<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 5 logo</p></summary>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_5_logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_5_logo.png)

<!--
</details>
!-->

Apple announced [iOS 5](https://github.com/seanpm2001/WacOS/wiki/iOS-5/) on June 6, [2011](https://github.com/seanpm2001/WacOS/wiki/2011/), at its annual Apple Worldwide Developers Conference (WWDC) event, and it was released to the public on October 12, [2011](https://github.com/seanpm2001/WacOS/wiki/2011/), alongside the iPhone 4S. Apple did not drop support for any devices with this release; support for the iPhone 3G and the iPod Touch (2nd generation) had already been dropped with the release of iOS 4.3 seven months earlier due to major performance issues. Therefore, [iOS 5](https://github.com/seanpm2001/WacOS/wiki/iOS-5/) was released for the iPhone 3GS onwards, iPod Touch (3rd generation) onwards, and the iPad (1st generation) and iPad 2. The release of iOS 5.1 brought support for the iPad (3rd generation). iOS 5.1.1 was the final release supported for the original iPad and iPod Touch (3rd generation).

#### iOS 5.0

iPad:

1st 2

iPhone:

3GS 4 4S

iPod touch:

3rd 4th

Limited support on iPod Touch (3rd generation)

Version Build Release date Features

5.0 9A334 October 12, 2011; 9 years ago Initial release on iPhone 4S

All notifications concentrated to Notification Center: swipe downwards from the status bar to open it. Notification center shows a list of all notifications and widgets (widgets available only on iPhone and iPod Touch).

Notification order can be arranged.

Choose Notification Type: Banner notifications, the classic pop-up notifications, or no notification at all (selectable on an app-by-app basis).

Notification list on lock screen. Swipe an icon to unlock and go to the specific notification.

Notifications announcing earthquakes with 2 minutes (only in Japan).

Messages

Messaging between all iOS devices running iOS 5 through Wi-Fi or 3G. Allows to send text, photos, videos, contacts, and locations.

All iMessages and conversations will be synced between all iOS devices linked under a single Apple ID. A conversation can be started on one device and continued on another.

Can message between multiple people simultaneously (group messaging).

Shows when other person(s) is typing.

Delivery receipts.

Optional read receipts (enable in Settings).

Animated GIF image support for iMessage.

Ability to set how many times an alert will be shown when a new message is received (ranges from once to ten times).

The name of the person that responds appears in small light blue text directly above the response when SMS is sent to a group.

Slight redesign for text messages. Font and time-stamp layout.

Hide keyboard; hidden by downwards scrolling in message screen (after being used to type a message). Unhidden again by tapping in text entry field.

Newsstand

A new icon on the Home Screen, which opens to an iBooks-inspired folder which shows all papers and magazines downloaded from the App Store.

Subscriptions to newspapers and magazines available for browsing and downloading in a dedicated section of the App Store, stored in the Newsstand folder.

Reminders

"To-Do list" functionality in Reminders app.

Date-based reminder notifications.

Location-based reminder notifications that can be set to when the user leaves, or arrives at a specified area (P4 P4S).

Twitter integration

Tweeting from native applications: Photos, Camera, YouTube, Maps, and Safari using new Tweet Sheet which supports multiple accounts.

Music

iPod app now split and renamed to Music and Videos (iPhone and iPad only; was always split on the iPod Touch).

Video podcasts can only be found in the Videos app.

Ability to play content while the device is synchronizing with iTunes.

Ability to delete songs from device (by swiping over the corresponding song).

Tap and hold on a song to view extended song information (iPhone and iPod Touch only).

Long names scrolling in now playing.

Album artwork now displays in full resolution (Retina Display only) on Now Playing screen.

Broadcast songs information on devices (e.g. car stereo) when connected over Bluetooth.

Improved Sound Check for Music.

"Group by Album Artist" option for Music.

iTunes Store button has been added to the Music app.

Removed ability to view lyrics (on iPad).

Camera

Volume-up key as shutter release button to take photos (also works using headphone remote volume up button). Also works for starting/stopping recording of videos.

Shortcut to Camera app from lock screen, accessed by double-clicking the home button (iPhone 3GS and later and iPod Touch 4th generation only).

Grid composition aide (3x3).

Spread to zoom-in, pinch to zoom-out.

Swipe left to reveal camera roll.

Tap and hold to lock/unlock Auto Exposure and Auto Focus.

Options button added, HDR toggle and Grid composition aide toggle.

New Camera button on Photos app that returns to Camera instead of a "Done" button (was on OS before this) to close the Camera Roll.

Face detection and video stabilization. P4S

Maps

Print maps.

Alternate routes.

Calendar

Can now create, rename, and delete calendars right on the device.

Tap and hold or double-tap to create a new event.

Tap and hold in "all-day events" to create a new all-day event.

Drag appointments to a new time slot.

Drag handles to change start and end times.

Creating new Event, now an "Invitees" field; takes to screen for multiple email address entry, emails sent to all invitees once event is saved.

Invitee can "Accept"/"Decline"/"Maybe"; reply sent to iCloud servers then reflected for all invitees to see.

Calendar event on device lists those invitees accepting event.

All users on iOS 5.x devices get notification when event is nearing.

Ability to specify a time zone to events.

Ability to add URLs to events.

Current time on Calendar if in landscape mode.

Navigate in day view by swiping.

Event attachments can now be viewed directly in the app.

Share calendars through iCloud with friends and family. Edits made by subscribers to that calendar are updated and pushed to other subscribers of that calendar (can be disabled by the creator of the calendar and locked so others cannot make edits).

Japanese or Buddhist calendars support.

Mail

Rich text formatting (bold, italics, and underline).

Indentation control.

Ability to mark multiple mail items as read.

Ability to flag emails.

Draggable mail address in the recipients field.

Alert if the subject line is blank.

Search now includes body of messages.

Delete mails while in Airplane mode.

Exchange ActiveSync Email can now be deleted offline.

Can create new email folders.

Mail sidebar.

S/MIME support.

Ability to show 1000 recent messages; 25 message option removed.

Ability to create additional @me.com email address within the Mail settings.

Ability to increase quote level in Mail settings.

New and updated tiny icons on Mail for Windows Live Mail, Gmail, Exchange, etc.

Hotmail accounts now have new icons and folders.

While reading an email the user can swipe right to open a list of messages and swipe left to bring back the open email message again.

If the user has multiple email accounts configured in Mail.app, swipe left or right from one's mailboxes folder list, it will take the user to another account's mailboxes.

Support for three popular Chinese email services: Tencent's QQ Mail, and Netease's 163.com and 126.com mail inboxes.

Photos

Built-in basic photo editing: crop, red-eye, auto-enhance and rotate photos.

Ability to create and edit local photo albums folders (only those that aren't synced with iTunes).

Ability to sync pictures taken on one iOS device automatically with other iOS 5 devices using Photo Stream.

Ability to select all when adding pictures to an album.

Slight re-design for video time-line under Photos app.

Safari

Safari Reader: new "Reader" icon appears in address bar if Safari detects a webpage article, removing need to click-through to each page. Scrollable window sheet appears over current webpage showing all article pages together separated by page breaks, removing ads and page clutter.

Ability to change font size in reader mode.

Reading List: a new area of the bookmarks window has been added, purposed for pages the user might want to read later. New pages can be added from a new option in the action menu or when long-pressing on a link.

Items from the Reading List can be synced to iCloud to be pushed to all of the user's other iOS devices.

Safari bookmarks can be synced to iCloud.

Ability to open pages in background or in new page (change in Settings).

Ability to replace a word with a word from a list of similarly spelled words spellings when typing in a text box on a web page.

Private Browsing; interface colours change from blue to black (change in Settings).

Ability to remove custom website data.

CSS fixed position support.

Slight fade out at end of long URLs (instead of ellipses) in the address bar.

HTML5 drawing is faster.

Kinetic scrolling within text fields in Safari.

iCloud

iTunes, iBooks (books and progress), App Store, Photo, Contacts, Calendar, Notes, Reminders, Mail, Safari (Bookmarks and Reading List), Settings, app data, iWork, and backup data; saved in iCloud to automatically or manually download to all linked devices (iOS and Mac/Windows PCs).

All iMessages and conversations will be synced between all iOS devices linked under a single Apple ID. The user can start a conversation on one device and continue it on another.

Backup home screen layout on iCloud.

Document sync.

Ability to buy more storage.

Free upgrade to 256 kbit/s bit rate for iTunes purchased songs if backing up on iCloud.

File names in iCloud Storage are case-sensitive.

Documents/data can now be selected to sync with iCloud account.

Option to disable iCloud Sync via cellular network to save cost, especially if roaming.

Game Center

Photos for Friends.

Ability to make the user's Profile public or private.

Points in Game Center: shows how many points the user has on the home screen of Game Center.

Sort and view Friends on the basis of Points.

Friend recommendations.

Game recommendations.

Games can be purchased from within Game Center.

New Friend requests screen.

Native support for turn based games.

Settings

Help Center: learn more about every option under settings app to explore more about it.

New menu under Location Services, named System Services, where some services can be toggled on or off (such as setting the time-zone, location-based iAds, Diagnostics, etc.).

Hearing Aid Mode.

Ability to rename the device.

Ability to set up an AirPort base station or Time Capsule devices.

Ability to organise Notification Center items "Manually" or "By Time".

Can select which apps can be included in Notification Center.

Can select which type of notification will be used for each app: banner notification, classic pop-up style notification, or no notification.

Ability to turn off app badges.

On the "Ringtone" and "Text Tone" page, instead of showing "new", they are all in one category now.

Custom sounds for New Message, New Voicemail, New Mail, Sent Mail and Reminders alerts.

Ability to purchase text, email, and voicemail alert tones.

Under "Mail, Contacts, Calendars", on the bottom it shows "Reminders" and gives an option to Sync.

In the "Messages" section, the "Alerts", "Show Preview", and "Repeat Alert" options have been removed.

The Usage screen is improved and now shows how much of the memory is consumed by each app.

Storage usage clean up.

Backup to iCloud shortcut added.

Software Update menu added. This allows easier and faster updating of devices independently, without a computer with iTunes installed; the update downloads directly to the iOS device; needs Wi-Fi or cellular network connection.

Photo Stream settings.

New purchases Settings; automatically download new purchases made on other devices (for music, apps, and books). This can also be enabled or disabled for use on cellular when not connected to Wi-Fi.

Twitter sign-in OS-wide with support for multiple Twitter accounts.

Ability to set left or right for mono audio.

Ability to turn on/off sending of iOS diagnostic data to Apple.

Keyboard

Ability to create keyboard shortcuts to replace custom phrases. By default includes "omw" which expands to "On my way!".

Emoji keyboard no longer needs an app to enable it (regarding non-Japanese devices).

Define the user's own words in Offline Dictionary.

New keyboard with prominent # (hash-tag) and @ (mention) buttons for Twitter app similar to the ".com" button when entering an address into the Safari address bar.

New Chinese-Pinyin keyboard spreading.

Quick Chinese input method.

List of associated words show on the top of Chinese input keyboard.

Function to convert voice to text P4S

PC-Free

iTunes/USB no longer needed to activate new devices via a computer.

New welcome screen when using the device for the first time (or after resetting a device).

Ability to start fresh with no need to tether it to iTunes. Option to restore all data on a device from an iCloud backup through a simple iCloud sign in.

Ability to wirelessly sync to iTunes over Wi-Fi added (an initial tethered sync is needed to pair them together and the setting must be enabled in iTunes).

OTA delta updates: from iOS 5 forward, devices can now self-update the system software right on the device itself through Wi-Fi or 3G; no iTunes or computer needed.

YouTube

Ability to play 480p/720p videos over 3G (iPhone only).

Scrolling titles for YouTube videos.

Seek bar fine scrubbing visual notification has been added.

FaceTime

Improved video quality.

Ability to set the FaceTime caller-ID to be the user's email or phone number.

Ability to mirror the FaceTime call on large screen.

iTunes/App Store

iTunes Tone Store.

New Purchased History section.

Genius support for finding songs and apps similar to ones users have purchased formerly.

Ability to completely disable in-app purchases.

iTunes password prompt.

Restrictions with password needed for purchases if enabled.

Shows "Install" instead of the price for formerly purchased apps. Shows "Installed" for installed apps.

Additional "iForgot" button on App Store if a user has forgotten their Apple ID password.

Simultaneous app downloads.

Custom tones for almost everything under "Sounds" with "Buy more tones" button.

Music app now has a "Store" button that goes to the iTunes Store.

Contacts

Add family relations ("related names") to contacts.

Add social media info into contacts.

VoiceOver

VoiceOver item chooser.

VoiceOver action support.

Arabic language support for VoiceOver.

Option to speak text selection.

New voices for VoiceOver.

Bluetooth

AVRCP 1.4 supported (sends track and artist info to supported devices).

Minor improvements/bug fixes

New rounded UI switch graphic.

Ability to use the device while syncing.

Spotlight search now includes Reminders and searches through Messages.

Built-in system-wide dictionary; in the typical Cut/Copy/Paste pop-up when selecting text, there is a new option to "Define". Define brings up a view with definition of the selected word.

Ability to delete app data.

Fixed a bug that caused a song to crash for a second while switching to another application in the multitasking tray.

Apps fade to home screen when they crash, rather than flicking off.

Option to automatically set the time (new for Wi-Fi-only devices).

Switching the ringer switch to "on", the indicator now shows the volume level bar (iPhone and iPad only).

Screenshots are saved using the device's orientation (formerly, all screenshots were saved as if the device was in portrait mode).

Hindi virtual keyboard based on standard InScript layout. (iPhone and iPod Touch only).

Notification Center

Option to display Stock and Weather widgets in Notification Center. Swipe weather left or right to get five-day forecast.

Calendar

Week view in landscape orientation.

Clock

Ability to pause Timer.

Tbilisi, Georgia added to World Clock.

Weather

Weather for user's current location.

Hourly updated weather of 5-day forecasts.

Stocks

Real-time stock updates.iPhone only

Siri voice control. P4S Classed as beta software during whole of iOS 5.x.

Voice commands are now executable for different users on device.

Device can now translate voice into text and vice versa.

Available in English (UK, US, and Australia), French, and German.

Phone

Enable/disable option for voice-dial if the device is set to security with passcode lock.

Delete individual calls in "Recents" Phone app. Clear button is now Edit button.

Make FaceTime calls without a micro-SIM card.

"Unsecured Calls" warning lets users know if they are talking on unencrypted networks.

Shows city name or area/county in addition to number for unknown calls.

Time-mid call invitation alerts.

Messages

Option to have iMessages sent as SMS when iMessage is unavailable (enable in Settings).

Placeholder text indicates whether sending "iMessage" or "Text Message" (i.e. SMS/MMS message) in Messages.

SMS/MMS bubbles are green in colour, iMessage bubbles are baby blue.

General

Customised vibrate alert patterns (can be set per-contact).

LED flash alerts. P4 P4S

Assistive touch gestures (iPod Touch only).

New "Message" option to use iMessage using an email ID, in Settings (for iPod Touch and iPad only).

Keyboard

Split keyboard: swipe up or pull apart to split keyboard in half.

Undock keyboard option: keyboard can now be moved up and down the screen.

Mail

Swipe right to reveal Inbox when in portrait orientation.

Calendar

Swipe left and right to change months.

Year view with heat map colours to show busy/free status.

Safari

Tabbed browsing.

Tapping and holding the back or forward buttons in Safari will show recently visited website history.

Tapping and holding the new tab button will show a list of recently closed tabs.

Music

All-new user interface.

Quickly skip to prior or next track by swiping left or right (respectively) on album art when in the Now Playing screen in the Music app.

Picture frame

Ability to pick an event.

Multitasking gestures with 4 or 5 fingers: (iPad 2 only until iOS 5.0.1)

Pinch to return to the Home screen.

Swipe up to open multitasking tray.

Swipe left or right to move between open apps.

AirPlay mirroring

Ability to connect with AirPlay to an Apple TV; whatever is displayed on an iOS devices screen is mirrored on the TV.P4S S2

Videos

Ability to play 1080p content.

Security Notes

http://support.apple.com/kb/HT4999

5.0.1 9A405 P3 P4 P4C S1 S1C S2 S2C S2D

9A406 P4S November 10, 2011; 9 years ago (9A405)

December 12, 2011; 9 years ago (9A406) 

Bug fixes, security update

Attempted to fix battery drain bug.

Fixes bugs affecting iCloud mail push.

Adds Multitasking Gestures (for original iPad).

Fixes bugs with Documents in the Cloud.

Improves voice recognition for Australian users using dictation.

Contains security improvements.

Activates the LED camera flash, whether the speaker is muted or not, for incoming calls and messages, when activated within the Accessibility sub-menu.

Introduces a new way for developers to specify files that should not be backed up.iPhone 4S only (Build 9A406)

Attempts to fix "Invalid Sim" and "No SIM card installed" issues.

Baseband update.

Security notes: http://support.apple.com/kb/HT5052

#### iOS 5.1

iPad:

1st 2 3rd

iPhone:

3GS 4 4S

iPod touch:

3rd 4th

Limited support on and iPod Touch (3rd Generation)

Version Build Release date Features

5.1 9B176 P3 P4 P4C P4S S1C S3L S3D

9B179 P4S March 7, 2012; 9 years ago Initial release on iPad (3rd generation).

App Store

App Store download limit over 3G was increased to 50 MB from 20 MB.

Clock

"Sleep iPod" function in clock application changed to "Stop Playing", this function also works for applications other than Music.

Camera

Redesigned Camera app (for iPad). S2 S2C S2D S3 S3L S3D

Camera shortcut on lock screen now always present, and has a new slide-up gesture to activate (iPhone and iPod Touch only). P3 P4 P4C P4S T4

Face detection and video stabilization P4S S3.

Camera face detection now highlights all detected faces P4S S3.

General

License column added under the About menu.

Improved Location Services.

Maps

Minor UI changes in Maps.

Music

Fixed slowdown when changing to landscape (Cover Flow) in Music app.

Shake-to-shuffle bug fix, which formerly caused the Music app to freeze.

Smart playlists bug fix.

Genius Mixes and Genius playlists for iTunes Match subscribers.

Podcast controls for playback speed and a 30-second rewind (iPad).

Network

Baseband updates for some devices.

Carrier updates (e.g. AT&T 12.0, Verizon 12.0).

4G icon shown when on AT&T's HSPA+ network P4S.

Fixes iPhone 4S support for Caller ID Name Display (on supported carriers – e.g. Rogers and Fido in Canada).

Restores the 3G switch P4S.

Phone

Combined Voice/Data Roaming Switch (on iPhone).

Photos

Photos can now be deleted from Photo Stream.

Safari

Safari address bar now has "Go to this address" instead of a blank bar.

Bookmarks list no longer automatically displayed on browser opening if there are no open pages in Safari.

Security Updates

A string format exploit in an application named racoon that allowed executing unsigned code at boot-up is fixed.

A ROP exploit that allowed executing payloads vnimage is now fixed.

A flaw that was executed by mounting a maliciously crafted disk image and may lead to a device shutdown or arbitrary code execution is now fixed.

A logic issue with debug system calls that could bypass the iOS sandbox restrictions is fixed.

WebKit security updates.

A format string vulnerability related to the handling of virtual private network (VPN) configuration files is now fixed.

CFNetwork security updates.

Siri

Enhanced Siri dictation support during text input "on supported devices" (iPhone 4S in 2011, iPad (3rd generation) in 2012).

Japanese language support for Siri (availability may be limited during initial rollout).

Video

Audio for TV shows and movies optimized to sound louder and clearer (on iPad).

Other

Setup Assistant bug fix.

Attempts at fixing battery life; results are mixed.

Bluetooth status bar indicator bug fix.

Improved Assistive Touch.

Fixed bug that allowed nested folders (folders within folders), including Newsstand.

Fixed bug that caused stuck keys on Apple Bluetooth Keyboards during wakeup from low power states.

Redesigned fonts for a few non-Latin languages.

Security Notes

http://support.apple.com/kb/HT5192

5.1.1 9B206 P3 P4C P4S S1 S1C S2 S2C S2D S3 S3L S3D

9B208 P4 May 7, 2012; 9 years ago

May 25, 2012; 9 years ago Final release supported on iPad (1st generation) and iPod Touch (3rd generation)

Bug fixes, security update

Fixes battery drain bug.

Improves reliability of using HDR option for photos taken using the Lock Screen shortcut.

Fixes bugs that could prevent switching between 2G and 3G networks S3L S3D.

Fixes bugs that affected AirPlay video playback in some circumstances.

Improved reliability for syncing Safari bookmarks and Reading List.

Fixes an issue where "Unable to purchase" alert could be displayed after successful purchase.

Added a decline button to calls.

Podcast playback position now synced between iOS devices (presumably via iCloud).iPhone 4 and iPhone 4S only

Attempt to fix bugs with echoes in calls.

Security Notes

http://support.apple.com/kb/HT5278

### iOS 6

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 6 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_6_logo_(2).png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_6_logo_(2).png)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_6_Home_Screen.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_6_Home_Screen.png)

Apple announced [iOS 6](https://github.com/seanpm2001/WacOS/wiki/iOS-6/) on June 11, [2012](https://github.com/seanpm2001/WacOS/wiki/2012/), at its annual Apple Worldwide Developers Conference (WWDC) event, and it was released to the public on September 19, [2012](https://github.com/seanpm2001/WacOS/wiki/2012/), alongside the iPhone 5, iPod Touch (5th generation), and iPad (4th generation). With this release, Apple dropped support for the iPod Touch (3rd generation) and the iPad (1st generation) due to performance issues, and offered only limited support on the iPhone 3GS and iPod Touch (4th generation). The iPhone 4 onwards, the iPod Touch (5th generation), the iPad 2 onwards and the iPad Mini (1st generation) were fully supported iOS 6.1.6 was the final release supported for the iPhone 3GS and iPod Touch (4th generation).

#### iOS 6.0

iPad:

2 3rd 4th Mini

iPhone:

3GS 4 4S 5


iPod touch:

4th 5th

Limited support on iPhone 3GS and iPod Touch (4th generation)

Version Build Release date Features

6.0 10A403 P3 P4 P4C P4S T4 S2 S2C S2D S3 S3L S3D

10A405 P5

10A406 T5 September 19, 2012; 9 years ago Initial release on iPhone 5, iPod Touch (5th generation), iPad (4th generation) and iPad Mini (1st generation)

Not all features available across devices.

SiriP4S P5 T5 S3 S4 M1

Siri now available on iPad (3rd, 4th generation and Mini) and iPod Touch (5th generation).

Additional country and language support for Canada (English and Canadian French), China (Mandarin), Hong Kong (Cantonese), Italy (Italian), Korea (Korean), Mexico (Spanish), Spain (Spanish), Switzerland (Italian, French, German), Taiwan (Mandarin), US (Spanish).

Local search works around the world.

Siri can now provide information on sports leagues such as NFL, MLB, NBA, NHL, WNBA, NCAA basketball and American football, the Premier League, MLS, and more. Ask for player stats, team rosters, game schedules and team standings.

Siri can provide information on movies like find movie reviews, ask about actors and actresses, play a movie trailer, get showtimes for movies and find a theater/cinema.

Yelp! built-in reviews and launch to open up more information and create reservations with OpenTable.

Restaurants are listed by reviews and nearest with more information.

Apps can be launched by saying `"run <app name>"` or `"open <app name>"`.

Siri can send Tweets and update Facebook status.

Siri can read items from Notification Center.

"Eyes Free", allowing car companies to build-in Siri integration; with a mic button on steering wheel, and for launching Siri functions, and screen disabling during Eyes Free mode.

Facebook integration

Share to Facebook from Share button and apps can access Facebook accounts; similar to Twitter integration in iOS 5.

Integrated into Notification Center.

Integrated in Siri and APIs for third-party apps.

Contacts synced from friends' contact information on Facebook.

Facebook Events and birthdays in Calendar.

"Like" button on apps and content from the App Store and iTunes Store.

Twitter

Icon matches Twitter's new logo.

Passbook (iPhone and iPod Touch only)

New app that manages a user's boarding passes, movie tickets, retail coupons, loyalty cards, etc. in one app.

Store coupons and gift cards in a wallet-like app (e.g. Apple Store, Starbucks, Target, etc.).

Passes are updated in real time if changes are made (e.g. spending money on a store card, flight time, gate change, etc.).

Passes are location and time-based, appearing on the lock screen when relevant.

Notification Center

Update Facebook status or Tweet from new widget.

Message previews can now be toggled on/off for alerts.

Calendar now shows the current date in the title bar.

Shows ending times for Calendar events.

Added "Do Not Disturb" for Notifications. (See Settings, below, for more information)

Photos

Shared Photo Streams. Photos can be shared with other contacts. Photos shared can be commented on and liked. Notifications are enabled for when a contact shares a photo with the user.

New sharing menu, using new icons.

Constantly shows a button to create new Albums.

Sharing menu has options for Twitter, Facebook, Weibo (when Chinese keyboard is enabled), Copy, Slideshow, AirPlay, Use as Wallpaper, Print.

Videos can be uploaded to Youku and Tudou when Chinese keyboard is enabled.

Music

New streamlined UI with white and black themes.

Late Night Mode equaliser.

Redesigned rewind, play/pause, and fast forward controls (videos kept the same touch controls from prior iOS software.)

Settings

"Bluetooth" moved to top of Settings list.

Added "Do Not Disturb" mode, allowing users to avoid calls and notifications unless calling parties are on the user's Favorites group. A crescent moon icon will appear in the status bar when enabled. Has no effect when the screen is on.

Added in Notifications: Government warnings and AMBER Alerts (toggle on/off).

New Privacy Controls. Apps must now ask for permission to access the users photos, calendars, contacts and reminders.

Revised Settings icon, similar to that of the OS X System Preferences app icon.

New gear animation in the Settings app shown whilst downloading an over-the-air update.

In the Usage menu, Time Since Last Full Charge, showing "Usage" and "Standby" time, is now available for all devices.

Enable 3G under Cellular setting (iPhone).

Maps menu for changing voice volume, map label language, label size, and distance units (iPhone 4S and later, iPad 2 and later, and iPod Touch (5th generation)).

Settings categories now separated into groups on iPad.

"Advertising" option added under "About", just above "Diagnostics & Usage" to enable or disable advertising networks from serving "targeted ads".

Phone

Adds phone icon on lock screen for showing additional ignoring options, similar to the camera sliding icon on the lock screen in iOS 5.1.

When ignoring a call, the user can message the caller by sending one of three customizable quick SMS responses or set a Reminder to call them back later.

Phone call doesn't take up the entire lock screen when a call is incoming. (QuietIncomingCallsonLock)

New white themed UI for dial pad.

Maps

Maps are now Apple-sourced instead of using Google sources.

Turn-by-turn Navigation with Siri Voice powered by TomTom (iPhone 4S and later, iPad 2 and later, and iPod Touch (5th generation)), voice directions (iPhone 4S and later only).

3D overview for maps (iPhone 4S and later, iPad 2 and later, and iPod Touch (5th generation)).

Satellite view.

Flyover view for maps gives 3D satellite view.P4S P5 T5 S2 S2

New Map icon.

Lock Screen integration for turn-by-turn navigation (iPhone 4S and later, and iPad 2 and later), voice directions (iPhone 4S and later only).

Yelp!integration available for businesses provides reviews and information on the business. Allows the user to launch Yelp!app from Maps.

Info cards of businesses.

Traffic crowd sourcing with anonymous data sent from all iPhones, also adds events of traffic slow-down. Re-routing around traffic accidents and road work.

Tapping search bar will automatically give directions from current location to back home, can be changed.

FaceTime

Make FaceTime calls over cellular (some carriers need certain data plans, like AT&T).P4S P5 S3

Mail

VIP inbox stars important emails from user defined VIP group members.

Flagged emails inbox.

Attach photos and videos quickly with a long-press.

Open password-protected Microsoft Office documents.

Added Pull-to-Refresh gesture to update Mail accounts.

Per account Signatures.

Holding the Compose button now shows a list of all draft messages, rather than just the most recent draft message.

Email addressed used can now be removed from the Recent list

Contacts

Search All Fields.

Custom Vibrations for Text Message Notifications.

Reminders

Manual Reader.

Manual location based reminders.

Location based reminders (iPad (3rd generation); formerly only available for iPhone 4 and iPhone 4S) (option removed in Golden Master).

Safari

Fullscreen landscape mode (for iPhone and iPod Touch).

iCloud tab syncing across iOS devices and Macs.

Offline Reading List caches the user's Reading List for later use, even when not connected to the Internet (not available for iPhone 3GS and iPod Touch (4th generation)).

Smart App Banners: Banners on mobile webpages prompt users to download the website's native App Store counterpart in the App Store.

Faster JavaScript engine.

Apps in search results.

Support for photo upload via Camera Roll to web forms with `<input type="file">` elements.

Support for up to 24 open tabs on iPad (up from prior limit of 9).

Bookmarks window now displays tabs along the bottom of the window to switch between viewing "Bookmarks", "History" and "Reading List"; formerly was listed all in one source list (iPad 2 and later only).

Bookmarks button changes to Reading List icon with a progress bar when updating the Reading List for offline use (iPad 2 and later only).

Long press the "Back" or "Forward" button to reveal the browsing history (for iPhone 3GS and later, iPod Touch (4th generation) and later. formerly only available for iPad since iOS 5.x).

App Store

New UI.

Darker theme.

Applications can be purchased from within apps.

Installing an app no longer returns the user to the home screen; apps will download and install while continuing to browse the store.

Can update apps without entering iTunes password.

Tap the screenshots of app to enter Full Screen mode.

Already installed apps now show an "Open" button that can be tapped to open the respective app, as can tapping the app's icon.

Developer page on the bottom of app details screen (now available for iPhone and iPod Touch; formerly only available for iPad).

Update History on the bottom of app details screen.

Related item on the middle of app details screen.

Share sheet button on the right top of app details screen.

iTunes

New UI.

Darker theme.

Content can be purchased from within apps (formerly available since iOS 5.0).

Accessibility

Guided Access

Allows user to lock exiting of the app in Single App Mode.

Allows users to disable certain controls within a specific app.

Locks the home button from being used, so as to function like a kiosk.

Speak Selection

Allows selected text to be read using the same Text-to-Speech that powers VoiceOver.

Allows speech rate and dialect to be changed and words to be highlighted as they are read.

When in use, infers language from context, and when no context is available, offers a choice. Pause/resume is available.

iCloud

Personal Dictionary synchronisation.

Passbook synchronisation.

Clock

Set a song as an alarm sound.

Clock app for iPad.

Weather

New UI.

Stocks

Historical data can be viewed for the past 5 and 10 years when in landscape mode.

YouTube

Apple's integrated app removed, due to an ended licensing deal with Google.

Game Center

Game Center challenges.

Facebook friends integration.

Opportunity to delete games without deleting the apps from a device.

Camera

HDR improvements.

Darker theme (iPhone and iPod Touch only).

Panorama Mode (iPhone 4S and later, and iPod Touch (5th generation) only).

Ability to take pictures while recording video (iPhone 5 only).

Face detection is now on the iPad 2.

Calendar

Add Facebook events and friends' birthdays into Calendar.

Security

Kernel ASLR added.

Other

Lost Mode: If an iOS device is lost, Lost Mode triggers an attention grabbing sound, prompting the person who finds the iPhone to call a specific number set by the owner remotely.

Additional features for China (Baidu search engine added, China social network, improved inputting method).

Weibo Integrated (when Chinese Keyboard enabled).

VoiceOver improvements.

Custom Vibrations for Alerts.

Global Network proxy for HTTP.

IPv6 support for Wi-Fi and LTE.

New Sharing menu using new icons across all stock apps.

Auto Correction for every keyboard.

Bluetooth MAP support.

Improved keyboard layouts.

New Thai keyboard (full keyboard).

French, German, and Spanish dictionaries. (Download necessary at time of first use)

"Made For iPhone" specification for hearing aids.

A blue "New" ribbon over newly installed apps.

Status bar reflects the color of the top-most banner in 3rd party apps. (iPhone and iPod Touch only)

Spotlight lists name of folder an app is located in.

Setup for iMessage and FaceTime added to initial device first time setup.

Folders now let the user store up to 16 apps (iPhone 5 and iPod Touch (5th generation)).

Security Notes

http://support.apple.com/kb/HT5503

6.0.1 10A523

10A525 P5 10A8426 M1C S4L S4D

November 1, 2012; 8 years ago Bug fixes, security update

Fixes a bug that prevents iPhone 5 from installing software updates wirelessly over the air.

Fixes a bug where horizontal lines may be displayed across the keyboard.

Fixes an issue that could cause camera flash to not go off.

Improves reliability of iPhone 5 and iPod Touch (5th generation) when connected to encrypted WPA2 Wi-Fi networks.

Fixes an issue that prevents iPhone from using the cellular network in some instances.

Consolidated the Use Cellular Data switch for iTunes Match.

Fixes a Passcode Lock bug which sometimes allowed access to Passbook pass details from lock screen.

Fixes a bug affecting Exchange meetings.

Adds Finger-Rejection.

Security Notes

http://support.apple.com/kb/HT5567

6.0.2 10A550 M1

10A551 P5 10A8500 M1C

December 18, 2012; 8 years ago iPhone 5 and iPad Mini only

Bug fix

Fixes a bug that could impact Wi-Fi.

#### iOS 6.1

iPad:

2 3rd 4th Mini

iPhone:

3GS 4 4S 5

iPod touch:

4th 5th

Limited support on iPhone 3GS and iPod Touch (4th generation)

Version Build Release date Features

6.1 10B141 P3 S2 S2C S2D S3 S3L S3D S4 S4L S4D M1 M1C T5
10B142 P4S
10B143 P5 T4
10B144 P4 P4C January 28, 2013; 8 years ago 

Larger "Report a Problem" button in Maps.

New music controls on lock screen when the home button is double-pressed.

Siri can now purchase movie tickets via Fandango (USA only).

LTE now works with several European, African, Asian and American carriers.

Individual songs can again be downloaded or deleted when using iTunes Match.

An empty Passbook will automatically add a sample pass explaining passbook functionality. The pass text changes slightly for users in British English speaking countries, changing "movie tickets" to "cinema tickets" in the first sentence, and "theaters" to "cinemas" in the last sentence.

Reset Advertising Identifier button now works.

New cellular data option for iTunes (it is available from iOS 6.0).

When setting up an iOS device for the first time with iCloud, it will now ask the user to confirm the Apple ID password for FaceTime and iMessages. It will also ask to confirm how the user would like people to reply, and informs the user that these settings can be changed at any time later on.

Fixed an iPhone 5 bug that prevented the phone from reconnecting to the cellular network when it lost connection for an extended amount of time.

"Accessory attached" splashscreen removed. Bi-directional control now possible.

Fixed a Bluetooth A2DP trigger delay – the beginning of the audio stream cut off (e.g. when navigating turn-by-turn, the user heard "HT in .5 miles" instead of "TURN RIGHT in .5 miles" in the A2DP headset/speakers)

Security fixes.

Security Notes

http://support.apple.com/kb/HT5642

6.1.1 10B145 P4S[90] February 6, 2013; 8 years ago iPhone 4S only

Bug fix

Fixes an issue that could impact cellular performance and reliability.

6.1.2 10B146 P3 P4 P4C P4S P5 T4 T5 S2 S2C S3 S3L S3D S4 M1

10B147 S4L S4D M1C

February 19, 2013; 8 years ago Bug fix

Fixes an Exchange calendar bug that could result in increased network activity and reduced battery life.

6.1.3 10B329 P3 P4 P4C P4S P5 T4 T5 S2 S2C S3 S3L S3D S4 M1 S4L S4D M1C March 19, 2013; 8 years ago Bug fixes

Fixes a bug that could allow someone to bypass the passcode and access the Phone app.

Improvements to Maps in Japan, Turkey, Germany and Poland

Security fixes.

Fixes Facebook App

Patches exploits used by original evasi0n jailbreak, but is jailbreakable via the p0sixspwn jailbreak.

Security Notes

http://support.apple.com/kb/HT5704

6.1.4 10B350 P5 May 2, 2013; 8 years ago iPhone 5 only

Bug fix

Updates the audio profile for speakerphone.

EOL updates

6.1.5 10B400 T4 November 14, 2013; 7 years ago iPod Touch (4th generation) only

Bug fix

Fixes an issue that causes FaceTime calls to fail for some users on the iPod Touch (4th generation).

6.1.6 10B500 P3 T4 February 21, 2014; 7 years ago iPhone 3GS and iPod Touch (4th generation) only

Final release supported on iPhone 3GS and iPod Touch (4th generation)

Fix CVE-2014-1266, a bug in Secure Transport that can cause it to fail to properly authenticate a SSL/TLS connection. This bug also occurred in iOS 7, and was caused by a duplicate goto fail; statement in the source code that caused critical parts of the certificate verification code to become unreachable code. This bug is informally known as the goto fail bug as a result.

### iOS 7

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 7 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_7_Logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_7_Logo.png)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_7.1_homescreen.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_7.1_homescreen.png)

Apple announced [iOS 7](https://github.com/seanpm2001/WacOS/wiki/iOS-7/) on June 10, [2013](https://github.com/seanpm2001/WacOS/wiki/2013/), at its annual Apple Worldwide Developers Conference (WWDC) event, and it was released to the public on September 18, [2013](https://github.com/seanpm2001/WacOS/wiki/2013/), alongside the iPhone 5C and iPhone 5S. With this release, Apple dropped support for the iPhone 3GS due to hardware limitations and the iPod Touch (4th generation) due to performance issues. [iOS 7](https://github.com/seanpm2001/WacOS/wiki/iOS-7/) has limited support on the iPad 2 and the iPhone 4 since they do not support Siri. However, other devices from the iPhone 4S onwards, iPod Touch (5th generation) onwards, the iPad (3rd generation) onwards, and the iPad Mini (1st generation) onwards were fully supported. The release of iOS 7.0.3 brought support for the iPad Air and iPad Mini 2. iOS 7.1.2 was the final release on the iPhone 4.

#### iOS 7.0

iPad:

2 3rd 4th Air Mini (1st, 2)

iPhone:

4 4S 5 5C 5S

iPod touch:

5th

Limited support on iPhone 4 and iPad 2

Version Build Release date Features

7.0 11A465

11A466 September 18, 2013; 8 years ago Initial release on iPhone 5C and iPhone 5S

UI

Added Support for apps with 64-bit Architectures. The 32-bit subsystem loads when launching a 32-bit app as the 64-bit subsystem is now used with this version and future versions of IOS

Flat design and move away from skeuomorphism in general (exceptions exist – for a move towards more skeuomorphism, see for example the Countdown with a new skeuomorphic 3D animation of a spinning wheel).

System Helvetica Neue Regular font.

Full Screen apps that make use of the system status bar and navigation bar.

Translucent design in tab bar, navigation bar, status bar, system keyboard, Control Center, and Notification Center (some translucent layers not on the iPhone 4, the iPad 2 and the iPad 3 due to hardware constraints).

Opaque design in Alert view, Action Sheet and Share Sheet.

Borderless buttons in general.

Back navigation gesture by swiping from left edge of the screen.

New UI for arranging tab-bar icons.

System-wide dynamic font size, configurable in Settings.

Enhance the viewing experience of non-iPad apps on iPad 2 and iPad Mini, remove the 1x and 2x toggle, apps are opened in '2x' mode by default on iPad 2 and Mini.

Home Screen

Spotlight Search is now accessible on each screen by pulling it down.

"New" banner on newly installed apps have been replaced with blue dots.

Brand new icons for built-in apps.

Newsstand is now a dedicated app instead of a folder.

Control Center

A unified screen to quickly access toggles and controls for system settings and services, and for using AirDrop and AirPlay.

System wide, accessible by swiping upward from the bottom of the screen.

Accessible in the lock screen.

Flashlight (device-specific features that come with physical camera) toggle button.

Landscape support.

A grabber in full screen apps.

Mute/silent toggle button in iPad.

AirDrop P5 P5C P5S T5 S4 M1

Integrates Apple's ad hoc Wi-Fi sharing feature AirDrop (iPhone 5 and later, iPod Touch (5th generation) and later, iPad (4th generation) and later, and iPad Mini (1st generation) and later).

Alert view, for receive invitation from other devices, option to accept/cancel.

Options to set discoverable: Off/Contacts only/Everyone.

Inter-app Audio

Register audio streams to share with other apps.

Provides for MIDI control of audio rendering, remotely launching other registered Inter-App Audio apps.

Notification Center

Accessible in the lock screen.

Today tab, for previewing the events calendar, stocks, and tomorrow's events; provides traffic info on oft-visited places.

Missed filter: can filter list to see notifications that occurred when phone was not actively in use.

Bounces when swiped down quickly.

Folders

Unlimited number of apps via folder subpages.

Newsstand app can now be moved inside any folder.

Transparent background.

Folders change color when apps are downloading and clock-like animated progress graphic is superimposed over folders that have actively downloading apps.

Alert

A countdown for snooze.

Calculator

New feedback when pressing a key.

Toggle landscape mode button.

Spotlight

Accessible on every page of the Home screen by swiping downward from anywhere.

New animation.

Multitasking

Redesigned switcher, with horizontal scrolling for previewing all running apps, and swipe upward gesture to stop any running apps.

Can close multiple apps simultaneously by swiping with multiple fingers.

Landscape switcher.

Background App Refresh; fetches data in the background based on network connectivity and user habits.

Use apps while the app is updating.

Wallpapers

New wallpapers.

Dynamic wallpapers.P4S P5 P5C P5S T5 S2 S3 S4 M1

Gyroscope-responsive parallax wallpaper effect, based on user's movement.P4S P5 P5C P5S T5 S2 S3 S4 M1

Weather

Dynamic animation for different weathers (iPhone 4S and later and iPod Touch (5th generation)).P4S P5 P5C P5S T5

Shows sunrise/sunset humidity, chance of precipitation, and wind speed.

Can see multiple locations simultaneously when the menu icon is selected.

Can select GPS icon at bottom to immediately see weather for current location.

Phone

Block list.

Contact pictures on Favorites.

Transparency in the number pad button when pressing.

Phone History and Voicemail Info options allow one to return the call in multiple ways including call back, FaceTime and Messaging.

Contacts

New fields in Contacts: "Add Social Profile", and "Add Instant Message".

"Chat", "FaceTime", "Mail" buttons next to the contact information; no longer need to scroll down to the bottom.

Send contacts through AirDrop.

FaceTime

FaceTime Audio.

Block list.

A dedicated app on the iPhone, like the prior version on iPod Touch and iPad.

Messages

Long SMS.

Block list.

No longer have to scroll to the top to access "Call", "FaceTime", and "Info".

Contact pictures in group chats.

Ability to see exact time of when each message was sent by dragging conversation bubbles to the left.

Event and address detection in the message context, tap to open in Calendar and Maps.

A contact with a nickname will appear in Messages under the nickname, rather than the full name.

New animation when compressing video to be shared.

Safari

Full screen browsing in portrait mode (formerly only available in landscape).

Unified text field for both URL and search.

Bookmarked website thumbnail icons appear when text field is activated.

Top-hit, Google suggest, Bookmarks, and History appear on the unified text field while typing.

Preview tabs on iPhone and iPod Touch are no longer limited to 8.

Preview tabs use new 3D vertical animation for previewing the opened tabs; long press to edit positions, swipe to remove.

Reading List shows website thumbnails on the right.

Scrolls articles one-by-one vertically from Reading List, as per OS X Mavericks.

Swipe gestures for back/prior history, as per OS X.

Parental controls.

Private button: enables "Do not track me" feature per website within the app; formerly, configuration appeared in Settings for every website.

Recent links: a reading list of all user's friends on Facebook or Twitter post.

Reading List button: new round glasses icon pays tribute to Steve Jobs.

The .com button removed and replaced with a simple period button. The .com, .net, and .org domain extensions can be accessed by holding down on the button.

Bookmarks/Reading List/Shared Links tabs re-ordered/slightly tweaked.

Bolder loading bar, private browsing UI tweaks and tab/bookmark changes on the iPad .

iCloud

Photo Stream video support, and more than one contributor per photo stream.

Notification Sync across different iCloud devices.

Maps

Automatic Day/Night Mode that responds to ambient light and current time to switch between day and night color schemes.

Turn-by-turn walking directions, with estimated time.

Maps bookmarks syncing.

Receives notification data sent from the new Maps app in OS X Mavericks (version 10.9).

A live compass at the right top corner.

Clock

App icon reflects the live time.

Timer shows in the lock screen.

City shows how many hours ahead/behind from the current location.

Music

New iTunes Radio service.

Scrub along the song to get to a certain part directly from the lock screen.

Download full albums from iCloud from iTunes Match.

Tapping a song in the Now-Playing screen allows users to rate.

Cover Flow: Instead of swiping through individual albums, one can now swipe through multiple albums.

Reintroduced on-screen lyrics for iPads (this feature was absent in iOS 5 and iOS 6).

iTunes Radio

Slider/discovery feature.

App Store

Automatic app updates: switch to enable/disable in Settings, under iTunes, App Store.

New catalogues for youngsters based on their age.

Genius tab replaced with "Apps Near Me" tab for app recommendations based on user's location.

Volume purchase.

Search tab redesigned, the number of results appears on the right of the search field.

Circular download progress animation during downloading/updating in Home Screen.

Add to wish list.

It is now possible to download older versions of apps (the last compatible version supported by the device legacy firmware).

iTunes

Smart download of TV episodes.

Photos

Albums are organized by Places, Moments, and Years, using the EXIF data as the base of the collection.

Share Sheet shares photos to iCloud, social networks, and AirDrop (if available).

New default album "Panorama Photos".

Camera

Control redesign: swipe horizontally to select the still images, videos, square photos, and Panorama modes (if available).

New intuitive controls for adjusting exposure value and exposure/focus fixing.

Live image filters. P4S P5 P5C P5S T5

SDK for 60 FPS video recording.

Pinch to zoom while video recording.

Redeem iTunes gift card using front camera.

Panorama reduces when battery is low.

Slow motion video recording with 720p at 120 frames per second on the iPhone 5s.P5S

Burst mode. P5 P5C P5S

High-dynamic-range imaging (HDR) for iPad.

Calendar

New layout for Calendar list view on the iPhone.

Years view.

Week view.

Integration with Mail.

Integration with Maps, users are notified with transit information when entering places information.

Can now hide or show declined events.

Will support custom calendar colors.

All Day toggle on the Add Event Screen instead of buried in the Select Time control.

Can snooze or View Event when an Event Reminder appears.

Can set up a second alert time for an event.

Can change Busy/Free Status.

Selecting the name of the calendar month shows the monthly calendar.

Game Center

Secure game scores.

Authenticated players.

Turn-based game modes.

Ranking-style leader boards.

Compass

Inclinometer.

Mail

View PDF annotation.

New smart mailboxes.

Improved Mail search.

Hotmail is now Outlook when adding an account, using new Outlook icon.

Flagged, Unread, To or CC, Attachments, All drafts, All sent, All Trash smart mailboxes.

Shake to Undo to un-archive something.

When emailing a passbook pass, it appears as a pass.

New animation when compressing video to be shared.

New animation when moving mail into a folder.

When selecting a target folder while moving an email, an iconic image of the email above the folder selector appears.

Have the ability to move an email to Junk folder when flagging.

New Print option available when Reply option is selected.

Notes

New design, mostly white.

No longer change fonts in Notes.

Can AirDrop notes.

Settings

Per app cellular data usage permission.

Per app using microphone privacy permission.

Per app using camera privacy permission.

Password needed to reset networking and contents.

Accessibility

Head movement detection for different gestures.

China features

Tencent Weibo social network integration.

Chinese-English bilingual dictionary.

Improved Chinese input including T9 keyboard for pinyin (Added in Beta 4), and handwriting recognition for multiple Chinese characters.

Siri P4S P5 P5C P5S T5 S3 S4 M1

Updated voices, and a new male voice (in select regions/languages). English (US), French, and German will be available with the launch of iOS 7 (additional languages will be added over time).

Controls certain system settings, such as turning on/off Bluetooth, and changing display brightness.

Search from Wikipedia and Bing search engines.

Post to Sina Weibo.

Search tweets on Twitter.

Option to open MLB scores in the MLB.com At Bat app.

Navigation, access and voice are more natural.

Reminders

Geofencing.

Ability to create repeating reminders has been removed.

Passbook

Scan and recognize barcodes/QR codes.

Add gift cards as a folder.

Find My iPhone

Activation Lock: re-activation with iCloud account if the device have been wiped remotely using Find My iPhone service, to prevent unauthorized usage of the lost device.

Password needed to disable.

Enterprise

Enterprise single sign-on.

Per app VPN.

Managed app config, for more efficiently deploying and managing of iPhones and iPads.

Accessories

Unauthorized Lightning cables are blocked and can no longer be used.

Set up and configure Wi-Fi accessories, such as AirPlay speakers.

iBeacons, a new class of Bluetooth LE low-powered, low-cost transmitters that can notify devices of other nearby devices/services.

Bluetooth LE profiles; including time, notifications, keyboards, and stereo sound.

MFi game controllers.

Screenshot

No longer included in the AssistiveTouch, they appear on the layer of the image.

Trusted Devices

User is warned when plugging their iOS device into their Mac/PC, "Trust the currently connected computer? Trusting this computer will allow it to have full access to your device and all of its data."

Voice Memo

New design.

Save to iCloud.

Share using AirDrop.

Status bar

Translucent design.

1xRTT icon on CDMA iPhones changed from "o" icon to "1x" icon.

GPRS icon on GSM iPhones changed from "o" icon to "GPRS" icon.

Dots representations for cellular signal strength.

Icon size slightly increased for better readability on the lock screen.

Lock screen

Charging the battery: rather than battery image on the lock screen, x% charged briefly appears under the clock, then reverts to the date.

Access to Notification Center and Control Center.

When playing music, the lock screen will now display the time.

iPad has Camera control on the lock screen, like the prior version on iPhone and iPod Touch.

Timer counting down is shown when the device is locked.

Scrubbing bar is now displayed on the lock screen.

Wi-Fi

New Wi-Fi diagnostics mode.

Wi-Fi Hotspot 2.0.

Other

New first-time setup menus.

The unlock sound from prior iOS releases up to iOS 6 is no longer present. From now on, whenever one either correctly inputs a passcode or simply slide to unlock on the lock screen, no sound will play when unlocking a device's lock screen.
Add Passcode Lock during Setup Assistant.

Vimeo and Flickr social network integrations.

Italian, Korean, and Dutch dictionaries.

New fade animation when pressing the power button.

Touch ID.P5S

New ringtones and system sounds. In iOS 6, these are moved to a menu named "Classic".

in VoiceOver add best quality voice in languages

in VoiceOver Arabic voice has changed

Security Notes

http://support.apple.com/kb/HT5934

7.0.1 11A470a September 19, 2013; 8 years ago iPhone 5C and iPhone 5S only

Bug fixes

Fixes a bug with the Touch ID sensor on the iPhone 5S.

Fixes a bug with the App Store purchases system.

7.0.2 11A501 September 26, 2013; 8 years ago Bug fixes

Fixes bugs that could allow someone to bypass the Lock screen passcode.

Since iOS 7.0.1 was released for the iPhone 5c and 5s only, iOS 7.0.2 fixes the bugs that were fixed on iOS 7.0.1 on all other devices.

Features

Reintroduces a Greek keyboard option for passcode entry.

Security Notes

http://support.apple.com/kb/HT5957

7.0.3 11B511 October 22, 2013; 7 years ago Initial release on iPad Air and iPad Mini 2

Bug fixes

Updates lock screen to delay display of 'slide to unlock' when Touch ID is in use. P5S

Fixes iMessage bugs where messages failed to send and iMessage failed to activate.

Improves system stability for iWork app.

Fixes accelerometer calibration issue.

Fixes a bug where Siri or VoiceOver used a lower voice.

Fixes a bug that could allow someone to bypass the Lock screen passcode.

Fixes a bug that caused VoiceOver input to be too sensitive.

Fixes a bug that caused supervised devices to become unsupervised when updating software.

Features

Adds iCloud Keychain for website login and Wi-Fi network passwords, credit/debit card management, and other account info.

Adds Password Generator in Safari for generating unique, hard-to-guess passwords.

Adds back web search and Wikipedia search in Spotlight.

Updates the bold text setting to change dial pad text.

Security Notes

http://support.apple.com/kb/HT6010

7.0.4 11B554a November 14, 2013; 7 years ago Bug fixes

Bug fixes and improvements, including a fix for an issue that causes FaceTime calls to fail for some users.

Security Notes

http://support.apple.com/kb/HT6058

7.0.5 11B601 January 29, 2014; 7 years ago iPhone 5C and iPhone 5S only

Bug fixes

Corrects network provisioning for some iPhone 5C and iPhone 5S models sold in China.

7.0.6 11B651 February 21, 2014; 7 years ago Bug fixes

Fixes CVE-2014-1266, a bug in Secure Transport that can cause it to fail to properly authenticate an SSL/TLS connection.

Security Notes

http://support.apple.com/kb/HT6147

#### iOS 7.1

iPad:

2 3rd 4th Air Mini (1st, 2)

iPhone:

4 4S 5 5C 5S

iPod touch:

5th

Limited support on iPhone 4 and iPad 2

Version Build Release date Features

7.1 11D167

11D169 March 10, 2014; 7 years ago 

CarPlayP5 P5C P5S

Providing iOS control to in-car control systems on some car models by selected vendors from 2014.

Includes Siri integration (eyes-free/hands-free modes), satellite navigation, telephone, music, and iMessage integration.

iOS experience designed for the car (iPhone 5 and later).

Works by connecting a Lightning enabled iPhone to a CarPlay enabled vehicle.

Supports Phone, Messages, Maps, and audio apps (inc. Music and third-party).

Support for resuming audio playback in Bluetooth car stereo systems(that do not support CarPlay) while using Turn-By-Turn navigation in Maps.

Siri P4S P5 P5C P5S T5 S3 S4 S5 M1 M2

Manually control when Siri listens by holding down the Home button while speaking, then releasing it when finished.

New, more natural sounding male and female voices for Chinese, UK English, Australian English, and Japanese.

iTunes Radio

Search field above Featured Stations to create stations based on Artist or Song.

Buy albums directly from the Now Playing screen.

Accessibility

Bold font option now includes the keyboard, calculator, and many icon glyphs.

Reduce Motion option now includes Weather, Messages, and multitasking UI animations.

New options to display button shapes, darken app colors, and reduce white point.

Calendar

Option to display event list with the month view.

Country specific holidays automatically added for many countries.

List view has been redesigned.

UI

Camera app has a new "HDR Auto" feature.P5S

Photos and Camera tab in iOS Settings has a new "Upload Burst Photos" option.

The Parallax effect can be disabled independently of other animations when setting up wallpaper.

Notification Center now displays "No Notifications" and "No Missed Notifications" for the "All" and "Missed" sections respectively when there are no notifications.

Caller ID photos: no longer full screen, instead small circle portrait for incoming/outgoing calls.

New Yahoo logo, in both Notification Center and the Weather and Stocks apps.

A new dialogue "Touch ID requires your passcode when iPhone restarts" when restarting.P5S

New iPad wallpapers.

"Touch ID and Passcode" has been moved-up to the main menu in Settings.

Animations and transitions are noticeably faster.

Keyboard has new Shift/Backspace key highlights.

Control Center has a new "spring" animation upon opening.

Control Center sliders – volume and brightness – have momentum.

Icons for Phone, Messages and FaceTime apps have less vibrant colors.

Music app: Albums now in descending order when browsing by Artist.

The buttons are circular in shape and do not show the word of what the icon means.

The Phone and FaceTime apps have a new-look dialer and "end call" button.

The slide-to-power-off UI has been redesigned; the shape of the slider is circular and the thing that says "slide to power off" is oval in shape. Same with the "slide to answer" slider in the Phone and FaceTime apps.

Bug fixes/improvements

Fixes a home screen crash bug.

Fixes display of Mail unread badge for numbers greater than 10,000.

iCloud Keychain support in additional countries.

FaceTime call notifications, automatically clear when call answered on another device.

iBeacon improvements.

Patches 41 security exploits, including those used by the Evasi0n 7 jailbreak. This firmware, along with iOS 7.1.1 and 7.1.2 can be jailbroken via the Pangu jailbreak.

Reduce Motion function in Settings app is introduced. This function reduces the motion of the UI and disables the parallax effects.

Removes the infamous "black screen of death (BkSoD)" and "White screen of death (WSoD)" that appeared in iOS 7.0.x.

Stability and Performance

Improved performance on iPhone 4.

Software Update

First update to iOS that enables beta versions to update over-the-air to the final release.

Issues

Touch ID fingerprint recognition is disabled when rebooting, turning Touch ID on and off; even restoring or resetting the device does not solve the problem.P5S

Security Notes

http://support.apple.com/kb/HT6162

7.1.1 11D201 April 22, 2014; 7 years ago Bug fixes

Stability and performance

Further improvements to Touch ID fingerprint recognitionP5S

Fixes a bug that could impact keyboard responsiveness

Fixes the bug in which the "1" badge was stuck on the Settings app even after updating to the latest version of iOS

Fixes an issue when using Bluetooth keyboards with VoiceOver enabled

Security Notes

http://support.apple.com/kb/HT6208

7.1.2 11D257 June 30, 2014; 7 years ago Final release supported on iPhone 4.

Bug fixes and security improvements

Improves iBeacon connectivity and stability

Fixes a bug with data transfer for some 3rd party accessories, including bar code scanners

Corrects an issue with data protection class of Mail attachments

Security Notes

http://support.apple.com/kb/HT6297

### iOS 8

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 8 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/08/IOS_8_logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/08/IOS_8_logo.png)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/08/IOS_8_Homescreen.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/08/IOS_8_Homescreen.png)

Apple announced [iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/) on June 2, [2014](https://github.com/seanpm2001/WacOS/wiki/2014/), at its annual Apple Worldwide Developers Conference (WWDC) event, and it was released to the public on September 17, [2014](https://github.com/seanpm2001/WacOS/wiki/2014/), alongside the iPhone 6 and iPhone 6 Plus. With this release, Apple dropped support for one device, the iPhone 4. [iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/) has limited support on the iPad 2, iPhone 4S, iPad (3rd generation), iPad Mini (1st generation), and the iPod Touch (5th generation), as Apple received widespread complaints of extremely poor/slow performance from owners of these devices. All other devices from the iPhone 5 onwards, iPod Touch (6th generation) onwards, the iPad (4th generation) onwards, and the iPad Mini 2 onwards were fully supported. The release of iOS 8.1 brought support for the iPad Air 2 and iPad Mini 3, and the release of iOS 8.4 brought support for the iPod Touch (6th generation). iOS 8.3 was the first version of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) to have public beta testing available, where users could test the beta for upcoming releases of iOS and send feedback to Apple about bugs or issues. The final version of [iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/) was iOS 8.4.1.

#### iOS 8.0

iPad:

2 3rd 4th Air Mini (1st, 2)

iPhone:

4S 5 5C 5S 6 6 Plus

iPod touch:

5th

Limited support on iPad 2, iPad (3rd generation), iPad Mini (1st generation), iPhone 4S, and iPod Touch (5th generation)

Version Build Release date Features

8.0 12A365P4S P5 P5C P5S T5 S2 S2C S2D S3 S3L S3D S4 S4L S4D S5 S5L S5D M1 M1C M2 M2C

12A366P6 P6P

September 17, 2014; 7 years ago Initial release on iPhone 6 and iPhone 6 Plus

iCloud

Photo Library – all photos and videos are automatically available in the iCloud Photo Library, and is consistent on all the linked devices automatically.

iCloud Drive – various files that are being written or worked on are automatically saved in iCloud Drive and is consistent on all linked devices automatically, including a Mac or PC.

iCloud settings now display account information, payment information and security settings.

App Store

Trending searches.

Related searches.

TestFlight – a new system for developers to let others test their app; up to a 1,000 users per app.

App Bundles.

Video previews.

Editors choice badge.

Essentials badge.

If an installing app is paused, it now shows a pause icon.

App Store search results scroll vertically on iPhone.

Explore tab, which includes Near Me.

Apps now show supported languages and if the app is Family Sharing compatible.

Calendar

Calendar week numbers are displayed.

Custom calendar repeat events.

Travel time in calendar appointments.

Alert "When I need to leave" for calendar events.

Decline a calendar with a comment.

More days shown at once in week view on new iPhones.P6 P6P

Improved landscape view added to select iPhones.P6P

Control Center

UI Changes in Control Center: the buttons no longer have an outline.

Screen is no longer dimmed when brightness control is selected.

iTunes Radio "buy" song button in Control Center.

iTunes Radio skips remaining displayed in Control Center.

Bringing up the Control Center is now much easier while the keyboard is up.

Messages

Ability to send voice messages instantly by using a new "microphone" button to the right of the text entry field.

Pressing and holding on the microphone button lets you record your voice and then swipe up to send it.

Messages can be listened to by either pressing play or raise to listen. Messages can also be listened and responded to on the Lock Screen by raising to listen and raising to respond.

Ability to send photo and video messages instantly by using the "camera" button to the left of the text entry field.

Pressing and holding on the camera button lets you take a photo or record a video and instantly send it.

Tapping the camera button shows the most recent photos in your camera roll. Options are also present for taking a new photo or video and to view your entire photo library. Multiple photos and videos can be selected to send at once.

A new details menu is available for each conversation which contains many new functions:

You can now title group message threads.

A list of everyone participating in a message thread is listed with buttons to call, FaceTime and view their full contact card.

Ability to drop or add people to groups.

Ability to leave groups.

Send current location.

Can share location with an individual or group for one hour, until the end of the day or indefinitely until you choose to stop.

Do Not Disturb option per group.

A collection of all photos that have been sent in a message thread.

Batch save/delete all images in a message thread.

Message threads are now synced between all of your devices.

Images in conversations are now much larger.

Scrolling to the top of a message will now automatically cause older messages to load.

Can mark all texts as read.

Added options to automatically delete standard messages after 1 year, 30 days or never.

Added options to automatically delete video/audio messages after 2 minutes or never.

Faces of contacts display next to contact name on select iPhones.P6P

Music

Left swipe to delete albums.

Can add music to a playlist from another playlist.

Updated Icon.

Multitasking UI

The faces of recently conversed people now appear above the open applications, and with a swipe to the right one can also access their favorites.

The animation speed when entering and leaving the app switcher is now much faster.

Share sheets

Share sheet action icons are now redesigned.

Share sheet icons can now be rearranged and hidden.

UI

Improved animation system. Gestures such as bringing down Notification Center won't be blocked by an animation, such as the home screen icons flying in.

Landscape view added to iPhone 6 Plus.

FaceTime

Call waiting.

FaceTime Audio conference calls.

H.265 (HEVC) support added iPhone 6 and iPhone 6 Plus.

Slight tweaks to the interface.

Mail

Can swipe to the left for options to flag it for follow-up, move it to a folder or delete.

Can swipe all the way across the screen to the left to delete immediately.

Can swipe all the way across the screen to the right to mark as read/unread.

Ability to swipe mail compose sheet down allowing access to the rest of ones mailbox to gather the information needed in order to compose the message.

When Mail recognizes a reservation, flight confirmation, or phone number in an email, a notification appears at the top of the message. In order to add it to the calendar or contacts, one needs to tap the notification(s).

Mail conversations are now threads.

Individual threads can be set as VIP so that the user will receive a notification when a reply is received.

Per thread S/MIME.

Automatic reply messages.

Can delete attachments.

New mailboxes: Unread, To or CC, Attachments, Thread Notifications, Today.

Notes

Rich-text editing.

Image support.

Notification Center / Notifications

Support for third-party widgets in Today view.

Interactive notifications – one can take action on texts, email, calendar invitations, reminders, and messages from apps like Facebook and other third-party apps.

Can be performed from within Notification Center by swiping a notification to the left to reveal actions available.

Can be performed directly within an apps notification banner/alert all without having to leave the app one is in.

Notifications in Notification Center can be individually dismissed.

Removal of "Missed Notifications" section.

iBooks

Now pre-installed on iOS 8.

Auto night mode.

Books can now be categorized into series.

Passbook

Updated Icon.

Supports Apple Pay by taking a photo of the user's Credit/Debit Card and incorporating it into Passbook for NFC Payments P6 P6P.

A history of recent purchases made with Apple Pay is available within Passbook.P6 P6P

Passbook "info" card now only displays if no other cards are present.

Safari

The Tab view from iPhone is now available on iPads.S2 S3 S4 S5 M1 M2

A search function to search through all open tabs has been added in Tab view on iPad and select iPhones.P6 P6P S2 S3 S4 S5 M1 M2

Two-finger pinch to reveal Tab view on iPads and select iPhones.P6 P6P S2 S3 S4 S5 M1 M2

New Sidebar that slides out to reveal bookmarks, Reading List, and Shared Links in landscape view on iPads and select iPhones.P6 P6P S2 S3 S4 S5 M1 M2

Address bar now hides when scrolling down on iPads.S2 S3 S4 S5 M1 M2

Spotlight Search is now available from Safari's address bar.

Option to "Scan Credit Card" when filling out credit card info on a web form.

WebGL support.

APNG support.

Private browsing per tab.

RSS feeds in Shared Links.

DuckDuckGo support.

Option to Request the desktop site while entering in a web address.

Option to add website to Favorites while entering in a web address.

Swipe to close iCloud tabs from other devices.

Hold the "+" (new tab button) in tab view to list recently closed tabs is now available on iPhone.P4S P5 P5C P5S P6 P6P T5

Can delete individual items from History.

Safari now blocks ads from automatically redirecting to the App Store without user interaction.

Bookmark icon updated.

Improved, iPad-like interface available in landscape view on select iPhones.P6 P6P

Maps

Flyover city tours.

Indoor Mapping – iOS 8 adds the M7 and M8 processor's and iPhone motion sensors to the CoreLocation API, allowing venue owners to create indoor positioning systems.

SiriP4S P5 P5C P5S P6 P6P T5 S3 S4 S5 M1 M2

Hey, Siri – when plugged into power the user can say "Hey, Siri" and Siri will automatically be activated.

Shazam song recognition.

Purchase iTunes content.

Download apps via Siri.

Streaming voice recognition.

22 new dictation languages.

Phone

Wi-Fi calling (only for T-Mobile customers in the U.S.).

Person's name scrolls while in a call when all of it won't fit on screen at once.

Can access full Phone app during a call.

Return of full screen Caller ID.

Accessibility

Braille keyboard for direct 6-dot Braille.

Gray scale mode.

Improved zoom.

Speak screen.

Alex voice.

New voices and gesture for speech accessibility.

New options in AssistiveTouch (being able to call Notification Center and Control Center).

Guided Access

Exit Guided Access with Touch ID.P5S P6 P6P

Time limits and countdown timer for Guided Access.

Privacy

Background location notifications – popup asking to "continue to allow" apps accessing Location information while running in the background.[103]

More Location Services options per app.

Camera added to Privacy settings.

HomeKit added to Privacy settings.

Health added to Privacy settings.

Photos

Camera Roll and My Photo Stream removed and replaced by "Recently Added, Videos, Recently Deleted" albums.

Search Photos by location and more.

Date, time and location information displayed.

Photos can now be favorited.

Photos and videos can be hidden from Moments.

Hidden photos and videos get added to the "Hidden" album.

New Albums added for Bursts, Slo-Mo Videos, and Time-Lapse Videos.

Option to auto optimise storage on device by removing local copies of pictures and videos.

Improved editing.

Smart composition tools.

Smart adjustments.

Extension support.

Voice Memos

Play/Pause button next to the record button in Voice Memos.

Lock Screen

App shortcuts for Handoff on the Lock Screen.

App shortcuts on the Lock Screen based on device location.

Audio iMessages received while the phone is locked can be listened to by raising to listen and responded to by raising to respond.

iTunes Radio "buy" song button on Lock Screen.

iTunes Radio skips remaining displayed on Lock Screen.

New animation when opening apps from the Lock Screen.

Access to Medical ID from emergency dialer.

New "Slide to Unlock" text in certain languages.

Keyboard

QuickType – as one types, they see choices of words or phrases one would probably type next, based on their past conversations and writing style, using a more formal language for mail, and a casual one for Messages. The system also adjusts the system based on the person one converses with, and the region of the user (currently available in 14 countries).

QuickType can be hidden by swiping down.

QuickType can be toggled on or off from within the keyboard switcher.

Extra functions added to the keyboard on select iPhones.P6 P6P

Smiley icon for when emoji keyboard is the only alternate keyboard set up. Becomes a globe icon when multiple keyboards are set up.

Streaming voice recognition for Speech to Text.

iOS 6 keyboard no longer appears in apps that are not optimized or updated to a version optimized for iOS 7 or higher.

New keyboards (Indian language and Indian English keyboards, Tagalog, Irish Gaelic, and Slovenian).

Family Sharing – a service of sharing purchases from iTunes between up to 6 people.

Supports iBooks purchases, iTunes purchases, and App Store purchases.

All group members must pay for family purchases with the same credit/debit card.

Ask To Buy – a parent can approve youngsters' spending right from a parent's device.

Coincides with iCloud Photo Library – automatically sets up a family photo stream where the user can share photos, videos, and comments, and all the family photos are available from any device within the family.

Offers shared calendar and Reminders.

Family Sharing can automatically share the user's location with the family members, or keep their location hidden.

With the Find My iPhone app, family members can use their devices to locate one that's lost and have it play a sound.

Apple IDs for youngsters under age of 13 years are now possible due to Family Sharing.

Health app –shows a dashboard of all the fitness and health data of the user (iPhone and iPod Touch only).

Shows the heart rate, calories burned, blood sugar, cholesterol, etc. of the user.

One can create an Emergency card with medicinal details, from within either the application or the lock screen.

Natively tracks steps taken and other movement activity within the Health app.

Export health data.

Continuity – iPhone, iPad, iPod Touch, and Mac communication.

AirDrop now works with OS X Yosemite. P5 P5C P5S P6 P6P T5 S4 S5 M1 M2

Handoff – start writing an email or surfing a website on one device, then continue on another device, for devices connected to the same iCloud account.P5 P5C P5S P6 P6P T5 S4 S5 M1 M2

Answer a phone call, receive and send SMS/MMS from an iPhone on an iPad or a Mac (all devices must run iOS 8 or OS X Yosemite, and be connected to the same Wi-Fi network or to the device's hotspot).

Intelligent hotspot – intelligently discover when an iPhone is nearby and automatically list the device under Wi-Fi networks in Settings.

Spotlight

Spotlight now also searches Wikipedia, iBooks, iTunes, App Store, nearby places, news, Suggested Websites, and Movie showtimes.

Also works within Safari.

Spotlight will remember any prior searches.

Weather

Data is now provided by The Weather Channel instead of Yahoo!.

More days are shown.

Additional weather information is displayed at the bottom.

iTunes

Wish List includes new category for songs tagged with Siri.

Trending searches.

Apple Developers – iOS SDK 8.0

Includes 4000 new APIs.

Introduces a new programming language named Swift.

Metal API (low level graphics API).

Touch ID API – open to third-party apps.

Apple Pay API

Camera API – third-party camera apps can have precise control over exposure, focus, and white balance.

Native apps tap into Safari's AutoFill & Passwords for easy login experience.

CloudKit – provides cloud storage and computing power for cloud-based apps.

HomeKit – allows standardized control of home automation devices.

Discover accessories and add them to a persistent, cross-device, home configuration database.

Display, edit, and act upon the data in the home configuration database.

Communicate with configured accessories and services to get them to perform actions, such as turning on the lights in the living room.

Siri integration.

SceneKit – enables easy 2D/3D casual game development.

SpriteKit – improved to allow force fields, collision detection, and new lighting effects for games.

PhotoKit – developers can enable their photo apps to edit photos directly in the Camera Roll without having to import them first.

HealthKit – health and fitness apps can share their data with the new Health app and with each other (when the user approves).

Extensions.

Today – widgets for the Today view of Notification Center.

Share – post content to web services or share content with others.

Actions – app extensions to view or manipulate inside another app.

Photo Editing – edit a photo or video in Apple's Photos app with extensions from third-party apps.

Storage Provider – an interface between files inside an app and other apps on a user's device.

Custom Keyboard – system-wide alternative keyboards.

Enterprise

Improved security – expanded data protection and finer control over mail encryption.

IT departments have more ways to manage information securely.

Camera

Panorama Mode for iPad.S5 M2

Time Lapse mode.

Separate focus and exposure controls.

Shutter Mode (timer can be set to 3 or 10 seconds).

Burst photos can now be taken with the FaceTime camera in addition to the iSight camera.P5S P6 P6P

Settings

Every app installed now has its own settings panel, regardless of whether the app specifies its settings to appear in the Settings app (e.g. Notifications, Privacy, Background App Refresh, and Cellular Data usage).

A new "Allow Notifications" setting for each app.

"Raise to Listen" setting for Messages.

"Display Zoom" added to select iPhones.P6 P6P

New Wallpapers.

New "Handoff and Suggested Apps" menu under General.

Wallpapers and Brightness has been split into two separate menus:

"Display and Brightness": Brightness settings were moved here and Text Size and Bold Text from General and Accessibility is now included.

"Wallpapers" is now a standalone menu.

EU options for roaming.

Wi-Fi

Wi-Fi network scanning will use random, locally administered MAC addresses, to aid users' security/privacy concerns.

Bluetooth

Supports MIDI over Bluetooth LE.P4S P5 P5C P5S P6 P6P T5 S3 S4 S5 M1 M2

Podcasts

Now pre-installed on iOS 8.

China features

Vector based maps.

Turn-by-turn navigation.

Lunar calendar support.

Improved predictive input.

Improved weather data.

Other

"Send Last Location" option for Find My iPhone.

Screen activity recording as a video camera device using OS X Yosemite through Lightning cable.

New Tips app gives tips about using certain features of iOS 8.

New definition dictionaries for Russian, Brazilian Portuguese, Thai, Turkish and Hindi localization.

24-hour time is now formatted correctly (e.g. "00:10" instead of "0:10").

Home screen landscape view added to iPhone 6 Plus.

Patches the ability to access the .app folder within App Store and 3rd-party apps through device file explorer programs on non-jailbroken devices.

Security Notes

http://support.apple.com/kb/HT6441

8.0.1 12A402 September 24, 2014; 7 years ago Update withdrawn due to an issue that impacted cellular network connectivity and Touch ID on iPhone 6 and iPhone 6 Plus

Fixes a bug so HealthKit apps can now be made available on the App Store.

Fixes an issue where 3rd party keyboards could become deselected when a user enters their passcode.

Fixes an issue that prevented some apps from accessing photos from the Photo Library.

Improves the reliability of the Reachability feature on iPhone 6 and iPhone 6 Plus.

Fixes an issue that could cause unexpected cellular data usage when receiving SMS/MMS messages.

Better support of Ask To Buy for Family Sharing for In-App Purchases.

Fixes an issue where ringtones were sometimes not restored from iCloud backups.

Fixes a bug that prevented uploading photos and videos from Safari.

8.0.2 12A405 September 25, 2014; 7 years ago Includes all bug fixes and updates originally included in iOS 8.0.1

Fixes an issue in iOS 8.0.1 that impacted cellular network connectivity and Touch ID on iPhone 6 and iPhone 6 Plus.

#### iOS 8.1

iPad:

iPad (2, 3rd, 4th) Air (1st, 2) Mini (1st, 2, 3)

iPhone:

4S 5 5C 5S 6 6 Plus

iPod touch:

5th

Limited support on iPad 2, iPad (3rd generation), iPad Mini (1st generation), iPhone 4S, and iPod Touch (5th generation)

Version Build Release date Features

8.1 12B410S2 S2C S2D S3 S3L S3D S4 S4L S4D S5 S5L S5D S6 S6L S6D M1 M1C M2 M2C M3 M3C

12B411P4S P5 P5C P5S P6 P6P T5

October 20, 2014; 6 years ago Initial release on iPad Air 2 and iPad Mini 3

Option to Enable/Disable dictation in keyboard settings.

Books icon and Reader view icon in Safari have been redesigned.

Settings app for third-party apps has been tweaked.

Apple Pay support for iPhone 6 and iPhone 6 Plus (in physical store, online, or in app) P6 P6P, Apple Watch-compatible devices (in physical store) P5 P5C P5S P6 P6P, for Touch ID devices (online or in app). P5S P6 P6P P6P S6 M3

Photos

Adds iCloud Photo Library as a beta service.

Adds Camera Roll and My Photo Stream albums back to Photos app after disappearing in iOS 8.0.x.

Removes Recently Added album.

Camera

Provides alerts when running low on space before capturing Time Lapse videos.

Messages

Adds the ability for iPhone users to send and receive SMS and MMS text messages to/from an iPad, iPod Touch and OS X Yosemite.P5 P5C P5S P6 P6P

Fixes an issue where searching messages would sometimes not display results.

Fixes a bug that caused read messages not to be marked as read.

Fixes issues with group messaging.

Fixes issues with Wi-Fi performance that could occur when connected to some base stations, like the FIFA 15 Ultimate Team servers.

Fixes an issue that could prevent connections to Bluetooth hands-free devices.

Fixes bugs that could cause screen rotation to stop working.

Fixes an issue in Safari where videos would sometimes not play.

Adds an option to select between 2G, 3G, 4G, or LTE networks for cellular data on certain carriers (iPhone and iPad (Wi-Fi + Cellular) only).

Adds AirDrop support for Passbook passes.

Adds instant tethering for OS X Yosemite.

Enables HealthKit apps to access data in the background.

Accessibility

Fixes an issue that prevented Guided Access from working properly.

Fixes a bug where VoiceOver would not work with third-party keyboards.

Improves stability and audio quality when using MFi Hearing Aids with iPhone 6 and iPhone 6 Plus.

Fixes an issue with VoiceOver where tone dialing would get stuck on tone until dialing another number.

Improves reliability when using handwriting, Bluetooth keyboards, and Braille displays with VoiceOver.

Fixes an issue that was preventing the use of OS X Caching Server for iOS updates.

Fixes an issue that allowed launching applications with expired developer certificates by setting the date and time to prior the certificate's expiration.

This firmware can be jailbroken via the Pangu8 jailbreak.

Security Notes

https://support.apple.com/kb/HT6541

8.1.1 12B435P4S P5 P5C P5S T5 S2 S2C S2D S3 S3L S3D S4 S4L S4D S5 S5L S5D M1 M1C M2 M2C

12B436P6 P6P S6 S6L S6D M3 M3C

November 17, 2014; 6 years ago Stability and Performance

Improved performance on iPhone 4S and iPad 2.

Bug fixes

Other bug fixes.

Security updates.

Patched Pangu jailbreak for iOS 8.0 – 8.1

Can be jailbroken via the TaiG jailbreak

Security Notes

https://support.apple.com/en-us/HT204418

8.1.2 12B440 December 9, 2014; 6 years ago Bug fixes

Fixes an issue where ringtones purchased through the iTunes store may have been removed from the device.

Other Info

Can be jailbroken via the TaiG jailbreak

Security Notes

http://support.apple.com/en-us/HT204422

8.1.3 12B466 January 27, 2015; 6 years ago Stability and performance

Includes general performance and stability improvements.

Other Info

Can be jailbroken via the TaiG 2.0 jailbreak utility.

Bug fixes

Reduces the amount of storage needed to update software

Fixes an issue that prevented some users from entering their Apple ID password for Messages and FaceTime

Fixes an issue that caused Spotlight to stop displaying app results

Fixes an issue which prevented multitasking gestures from working on iPad

Adds new configuration options for education standardized testing

Security updates.

Patches certain exploits used by the TaiG 1.0 jailbreak.

Fixes an issue that allowed installation and usage of applications with expired developer certificates.

Security Notes

http://support.apple.com/en-us/HT204245

#### iOS 8.2

iPad:

iPad (2, 3rd, 4th) Air (1st, 2) Mini (1st, 2, 3)

iPhone:

4S 5 5C 5S 6 6 Plus

iPod touch:

5th

Limited support on iPad 2, iPad (3rd generation), iPad Mini (1st generation), iPhone 4S, and iPod Touch (5th generation)

Version Build Release date Features

8.2 12D508 March 9, 2015; 6 years ago 

Apple Watch Support

New Apple Watch app to pair and sync with iPhone, and to customize Watch settings

New Activity app for viewing fitness data and achievements from Apple Watch; appears when Apple Watch is paired

Available on iPhone 5 and later; iPad and iPod Touch is not supported

Health App improvements

Adds the ability to select the unit of measurement for body temperature, weight, height, distance, and blood glucose

Improves stability when dealing with large amounts of data

Includes the ability to add and visualize workout sessions from 3rd-party apps

Fixes an issue that may have prevented users from adding a photo in Medical ID

Fixes units for vitamins and minerals

Fixes an issue where Health data wouldn't refresh after changing data source order

Fixes an issue where some graphics showed no data values

Adds a privacy setting that enables turning off tracking of steps, distance, and flights climbed

Stability Enhancements

Increases stability of Mail

Improves stability of Flyover in Maps

Improves stability of Music

Improves VoiceOver reliability

Improves connectivity with Made for iPhone Hearing Aids

Other Info

Can be jailbroken via the TaiG 2.0 jailbreak utility.

Bug fixes

Fixes an issue in Maps that prevented navigating to some favorite locations

Fixes an issue where the last word in a quick reply message wasn't autocorrected

Fixes an issue where duplicate iTunes purchased content could prevent iCloud restore from completing

Fixes an issue where some music or playlists didn't sync from iTunes to the Music app

Fixes an issue where deleted audiobooks sometimes remained on the device

Fixes an issue that could prevent call audio from routing to car speakers while using Siri Eyes Free

Fixes a Bluetooth calling issue where no audio is heard until the call is answered

Fixes a time zone issue where Calendar events appear in GMT

Fixes an issue that caused certain events in a custom reoccurring meeting to drop from Exchange calendar

Fixes a certificate error that prevented configuring an Exchange account behind a third-party gateway

Fixes an issue that could cause an organizer's Exchange meeting notes to be overwritten

Fixes an issue that prevented some Calendar events from automatically showing as "busy" after accepting an invite.

Security Notes

https://support.apple.com/en-us/HT204423

#### iOS 8.3

iPad:

iPad (2, 3rd, 4th) Air (1st, 2) Mini (1st, 2, 3)

iPhone:

4S 5 5C 5S 6 6 Plus

iPod touch:

5th

Limited support on iPad 2, iPad (3rd generation), iPad Mini (1st generation), iPhone 4S, and iPod Touch (5th generation)

Version Build Release date Features

8.3 12F69 S2 S2C S2D S3L S3D S4L S4D S5L S5D S6L S6D M1C M2C M3C T5

12F70 P4S P5 P5C P5S P6 P6P

April 8, 2015; 6 years ago Performance Improvements

App launch

App responsiveness

Messages

Wi-Fi

Control Center

Safari tabs

Third-party keyboards

Keyboard shortcuts

Simplified Chinese keyboard

Wi-Fi and Bluetooth fixes

Fixes an issue where the user could be continuously prompted for login credentials

Fixes an issue where some devices disconnect intermittently from Wi-Fi networks

Fixes an issue where hands-free phone calls could become disconnected

Fixes an issue where audio playback could stop working with some Bluetooth speakers

Orientation and rotation fixes

Fixes an issue that sometimes prevented rotating back to portrait after having rotated to landscape

Improves performance and stability issues that occurred when rotating the device between portrait and landscape

Fixes an issue where device orientation appeared upside down after pulling the iPhone 6 Plus from your pocket

Fixes an issue that sometimes prevented apps from rotating to correct orientation after switching apps in multitasking

Messages fixes

Fixes issues that caused group messages to sometimes split

Fixes an issue that sometimes removed the ability to forward or delete individual messages

Fixes an issue that sometimes prevented a preview from appearing when taking a photo in Messages

Adds the ability to report junk messages directly from the Messages app

Adds the ability to filter out iMessages that are not sent by the user's contacts

Family Sharing fixes

Fixes a bug where certain apps would not launch or update on family members' devices

Fixes a bug that prevented family members from downloading certain free apps

Increased reliability for 'Ask to Buy' notifications

CarPlay fixes

Fixes an issue where Maps could come up as a black screen

Fixes an issue where the UI could be incorrectly rotated

Fixes an issue where the keyboard could appear on the CarPlay screen when it shouldn't

Enterprise fixes

Improves reliability of installing and updating enterprise apps

Corrects the time zone of Calendar events created in IBM Notes

Fixes a problem that could cause web clip icons to become generic after restarting

Improves reliability of saving the password for a web proxy

Exchange out-of-office messages can now be edited separately for external replies

Improves recovery of Exchange accounts from temporary connection problems

Improves compatibility of VPN and Web proxy solutions

Allows use of physical keyboards to log into Safari Web sheets, such as for joining a public Wi-Fi network

Fixes an issue that caused Exchange meetings with long notes to be truncated

Accessibility fixes

Fixes an issue where using the back button in Safari causes VoiceOver gestures to not respond

Fixes an issue where VoiceOver focus becomes unreliable in draft Mail messages

Fixes an issue where Braille Screen Input cannot be used to type text in forms on webpages

Fixes an issue where toggling Quick Nav on a Braille Display announces that Quick Nav is off

Fixes an issue keeping app icons from being moveable on home screen when VoiceOver is enabled

Fixes an issue in Speak Screen where speech will not start again after pausing

Other improvements and bug fixes

Introduces a redesigned Emoji keyboard with over 300 new characters

iCloud Photo Library has been optimized to work with the new Photos app on OS X 10.10.3 and is now out of beta

Improves the pronunciation of street names during turn-by-turn navigation in Maps

Includes support for Baum VarioUltra 20 and VarioUltra 40 Braille displays

Improves the display of Spotlight results when Reduce Transparency is turned on

Adds Italic and Underline format options for iPhone 6 Plus landscape keyboard

Adds the ability to remove shipping and billing addresses used with Apple Pay

Additional language and country support for Siri: English (India, New Zealand), Danish (Denmark), Dutch (Netherlands), Portuguese (Brazil), Russian (Russia), Swedish (Sweden), Thai (Thailand), Turkish (Turkey)

Additional dictation languages: Arabic (Saudi Arabia, United Arab Emirates) and Hebrew (Israel)

Improves stability for Phone, Mail, Bluetooth connectivity, Photos, Safari tabs, Settings, Weather, and Genius Playlists in Music

Fixes an issue where Slide to Unlock could fail to work on certain devices

Fixes an issue that sometimes prevented swiping to answer a phone call on the Lock screen

Fixes an issue that prevented opening links in Safari PDFs

Fixes an issue where selecting Clear History and Website Data in Safari Settings did not clear all data

Fixes an issue that prevented autocorrecting "FYI"

Fixes an issue where contextual predictions did not appear in Quick Reply

Fixes an issue where Maps did not enter night mode from hybrid mode

Fixes an issue that prevented initiating FaceTime calls from a browser or third-party app using FaceTime URLs

Fixes an issue that sometimes prevented photos from properly exporting to Digital Camera Image folders on Windows

Fixes an issue that sometimes prevented an iPad backup from completing with iTunes

Fixes an issue that could cause Podcast downloads to stall when switching from Wi-Fi to cellular networks

Fixes an issue where remaining time on timer would sometimes incorrectly display as 00:00 on Lock screen

Fixes an issue that sometimes prevented adjusting call volume

Fixes an issue that caused the status bar to sometimes appear when it shouldn't

Attempt to fix problems with custom keyboards crashing, not appearing, or being replaced with the default keyboard

Airplane mode no longer disable the GPS

Other info

Can be jailbroken via the TaiG 2.0 jailbreak. Latest TaiG version is 2.4.5.

Security Notes

https://support.apple.com/kb/HT204661

#### iOS 8.4

iPad:

iPad (2, 3rd, 4th) Air (1st, 2) Mini (1st, 2, 3)

iPhone:

4S 5 5C 5S 6 6 Plus

iPod touch:

5th 6th

Limited support on iPad 2, iPad (3rd generation), iPad Mini (1st generation), iPhone 4S, and iPod Touch (5th generation)

Version Build Release date Features

8.4 12H143 June 30, 2015; 6 years ago Initial Release on iPod Touch (6th generation)

Apple Music

Adds support for the new Apple Music streaming service which is available in 100 countries starting on June 30, 2015.

New features including personalized music discovery and recommendation based on the user's favorite genres or artists. Adds support for 24/7 online radio service named Beats 1 and new Connect tab in which all artists can communicate with their listeners.

Apple Music costs $9.99/month for 1 person and $14.99/mo. for up to 6 people and a free trial will be given to users for 3 months.

Apple Radio, Beats One, and Connect feature are still available for users not choosing to subscribe to Apple Music

Redesigned Music Application

Streamlined design

Recently Added tab makes it easier to discover music that was recently added

MiniPlayer makes it easier to see what's currently playing and to control music playback

Up Next section lets the user see and control what is going to play next

Enables search from anywhere in the music application with a new unified magnifying glass icon at the top. Trending Search was added which shows which music within Apple Music is being searched for most by users.

Adds support for offline music playback including a toggle and icon to show which songs are available offline.

iBooks improvements and fixes

Browse, listen, and download audiobooks inside iBooks

Enjoy the all-new Now Playing feature, designed specifically for audiobooks

Books that are made for iBooks now work on iPhone and iPad

Improves accessibility of widgets, glossary, and navigation in books made with iBooks Author

New default Chinese font.

New setting to turn off Auto-Night theme in the library

Fixes an issue that may have prevented Hide Purchases from working

Fixes an issue that may have prevented downloading books from iCloud.

Bug fixes and stability improvements

Fixes an issue where receiving a specific series of Unicode characters causes device to reboot.

Fixes an issue that prevented GPS accessories from providing location data

Fixes an issue where deleted Apple Watch apps would re-install

Fixes the Logjam vulnerability in TLS

Other info

Can be jailbroken via the TaiG 2 jailbreak. Latest TaiG version is 2.4.5.

Security Notes

https://support.apple.com/kb/HT204941

8.4.1 12H321 August 13, 2015; 6 years ago Final version

Fixes issues that could prevent turning on iCloud Music Library.

Fixes an issue that hides added music because Apple Music was set to show offline music only.

Provides a way to add songs to a new playlist if there aren't any playlists to choose from.

Fixes an issue that may show different artwork for an album on other devices.

Fixes several issues for artists while posting to Connect.

Fixes an issue where tapping Love doesn't work as expected while listening to Beats 1.

Security updates.

Patches TaiG 2 jailbreak for iOS 8.1.3–8.4 (8 exploits).

Security Notes

https://support.apple.com/kb/HT205030

### iOS 9

<!--
<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 9 logo</p></summary>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/09/IOS_9_Logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/09/IOS_9_Logo.png)

<!--
</details>
!-->

Apple announced [iOS 9](https://github.com/seanpm2001/WacOS/wiki/iOS-9/) on June 8, [2015](https://github.com/seanpm2001/WacOS/wiki/2015/), at its annual Apple Worldwide Developers Conference (WWDC) event, and it was released to the public on September 16, [2015](https://github.com/seanpm2001/WacOS/wiki/2015/), alongside the iPhone 6S, iPhone 6S Plus and iPad Mini 4. With this release, Apple did not drop support for any [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) devices. Therefore, [iOS 9](https://github.com/seanpm2001/WacOS/wiki/iOS-9/) was supported on the iPhone 4S onwards, iPod Touch (5th generation) onwards, the iPad 2 onwards, and the iPad Mini (1st generation) onwards. However, [iOS 9](https://github.com/seanpm2001/WacOS/wiki/iOS-9/) has limited support on devices with an Apple A5 or A5X processor: the iPhone 4S, iPad 2, iPad (3rd generation), iPad Mini (1st generation), and iPod Touch (5th generation). This release made the iPad 2 the first device to support six major releases of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/), supporting [iOS 4](https://github.com/seanpm2001/WacOS/wiki/iOS-4/) thru [iOS 9](https://github.com/seanpm2001/WacOS/wiki/iOS-9/). Despite Apple's promise of better performance on these devices, there were still widespread complaints that the issue had not been fixed. iOS 9.3.5 is the final release on the iPod Touch (5th generation), the Wi-Fi-only iPad 2, the Wi-Fi-only iPad (3rd generation), and the Wi-Fi-only iPad Mini (1st generation). iOS 9.3.6 is the final release on the iPhone 4S, the Wi-Fi + cellular iPad 2, the Wi-Fi + cellular iPad (3rd generation), and the Wi-Fi + cellular iPad Mini (1st generation).

#### iOS 9.0

iPad:

iPad (2, 3rd, 4th) Air (1st, 2) Mini (1st, 2, 3, 4)

iPhone:

4S 5 5C 5S 6 6 Plus 6S 6S Plus

iPod touch:

5th 6th

Limited support on iPad 2, iPad (3rd generation), iPad Mini (1st generation), iPhone 4S, and iPod Touch (5th generation)[120]

Version Build Release date Features

9.0 13A340 M4 M4C

13A342 P6S

13A343 P6SP

13A344P4S P5 P5C P5S P6 P6P T5 T6 S2 S2C S2D S3 S3L S3D S4 S4L S4D S5 S5L S5D S6 S6L S6D M1 M1C M2 M2C M3 M3C

September 16, 2015; 6 years ago Initial release on iPhone 6S, iPhone 6S Plus, and iPad Mini 4

iPhone 4S and iPad 2 was advertised a speed boost, including other 32-bit devices.

App Store

App Store reviews no longer allowed when using a beta version of iOS.

App Thinning allows the App Store to only download the assets needed for the device being used.

On-demand resources allows iConnect to host assets for later download.

CarPlay

Adds support for wireless CarPlay.

Lets users access the car's settings (such as climate control) through the CarPlay interface itself.

Battery level indicator added to onscreen display.

Plays back audio messages, letting the user hear from people in their own voices.

Full support for car knob controls, so the user can tilt and spin to scroll through lists or pan around in Maps.

Find My Friends

Find My Friends is now pre-installed.

Notification Center Widget.

Find My iPhone

Find My iPhone is now pre-installed.

Health

Added landscape view.

Adds support for reproductive health, UV exposure, water intake and sedentary state data types.

iBooks

Safari extension to turn a webpage into a PDF and open it in iBooks.

Mail

Attachments received can now be saved and attachments can be added to messages from iCloud Drive or other document providers while composing a new message.

Support for saving attachments to iCloud Drive.

Icons added to left and right swipe gestures.

Support for Markup allows annotating images or PDF attachments with text, shapes, or signatures.

Maps

Support for public transit lines, station details with exits and entrances, schedules and directions in select major cities. Also, popular places such as restaurants, stores, and points of interests will be highlighted and presented to the user in a central location.

Apple Pay support is indicated on place cards at participating retail locations.

Adds support for "Follow up by Email" that allows Apple to email users about issues reported.

Browse for places nearby by category, including Food, Drinks, Shopping, Fun and more.

Place cards include Wikipedia information for landmarks and cities.

Messages

Contact Pictures in list view.P6.

Redesigned overlay when sending an audio clip.

Music

Stream High Quality option in Music Settings.

Home Sharing returns (removed in iOS 8.4).

Updated design of share menus.

News

Adds a new app named News which provides curated lists of personalized news content for iOS users, offering content from popular websites and newspapers and displaying it in an iOS-friendly layout. This app replaces the Newsstand app.

Notes

Add photos to notes with the built-in camera or from the Photo Library.

Support for hand-drawn sketches, checklists, and inserting photos from the internet or the Camera Roll.

Adds different fonts for headings, body, and titles.

Recently deleted folder.

Share Sheet extension that allows a user to input text, pictures, or other attachments from anywhere in the system via an extension in the share sheet.

Notification Center/Notifications

Notifications are no longer sorted by application by default, instead being sorted by day starting with recent notifications.

Phone

Adds WiFi Calling support for iPhone users on AT&T. This feature was formerly limited to T-Mobile and Sprint users.

Support for Wi-Fi calling on iPad, iPod Touch and Mac, without iPhone in proximity on participating carriers.

Photos

Added preview scrubber bar to photo viewer.

Screenshots and Selfies albums added.

Hide photo added to Share Sheet.

Ability to hold and select multiple photos.

Podcasts

The Podcasts app has a new Unplayed tab which will show podcasts which have not yet been played.

All-new design to make it easier to find the latest episodes.

Notification when new episodes become available.

Reminders

Share Sheet extension.

Shows number of overdue items for each list next to title.

Safari

"Find on page" and "Request Desktop Version" now accessed from Share Sheet.

Support for content blockers.P5S P6 P6P P6S P6SP S5 S6 M2 M3 M4

Settings

Settings can now be searched.

There are now video recording settings to change the quality of recorded videos.

There is a new iCloud Drive app which can be enabled in the iCloud Settings.

Battery moved to the top level.

Updated Notifications icon.

Additional options for Auto-Lock.

Wallpapers

Adds 15 new wallpapers to iOS which replaces most of the wallpaper present in iOS 8.

When changing wallpapers, there is a new "Still" option which keeps the wallpaper still.

Wallet

Replaces the Passbook app with a new app named Wallet and enhances the features of Apple Pay with support for Discover credit/debit card, store loyalty card, and Apple Pay in the UK.

To check out even faster, upcoming payments can be prepared by double-clicking the Home button from the Lock Screen and keeping the finger on Touch ID.

Watch

Renamed from Apple Watch.

Updated haptic feedback icons.

Battery improvements

Up to one hour of additional time before the battery needs to be charged.

Facedown detection for turning display off when not in use

New Low Power Mode (iPhone only) disables Background App Refresh, Mail Fetch, Motion Effects, and Animated Wallpapers. It also extends device's battery life by up to three hours.P4S P5 P5C P5S P6 P6P P6S P6SP

Low Power Mode turns off when device is connected to a power source.

Notification Center Widget (when paired with Apple Watch).

Intelligence improvements

Proactive assistance.P5 P5C P5S P6 P6P T6 S4 S5 S6 M2 M3

Presents relevant information even before the user starts typing.

Notifies the user when the user needs to leave for appointments using traffic conditions.

Learns what the user listens to in a certain location or at a particular time of day and can automatically display playback controls for preferred music and audio apps.

Suggested events and contact details are added to apps based on information found in Mail.

Siri.

Siri has a new colorful interface, similar to that of the Apple Watch.

Removed sound from Siri activation.

Updated Siri icon in Settings.

Search personal photos and videos based on dates, locations and album names.

Ask Siri to remind about things being looked at in apps, including Safari, Mail, Notes and Messages.

Request directions via public transit.

Siri can now use an accent (same language) which differs from the input language.

Siri no longer asks for confirmation of reminders that are created.

Spotlight Search.

A more intelligent Spotlight search provides info such as Weather, News, Stocks, nearby places, and recent/favorite contacts based on the user's preference. Spotlight search can be activated by swiping to the right on the first page of the home screen or swiping down on any page of the home screen.P5 P5C P5S P6 P6P T6 S4 S5 S6 M2 M3

Perform tasks such as currency conversions and calculations.

Get sports scores, weather conditions and stock prices.

Initiate messages, phone calls and FaceTime calls from contact search results.

iPad experience improvements

Slide Over.S5 S6 M2 M3 M4

Quickly use a second app without leaving the current one.

Easily switch between Slide Over apps.

Support for Apple apps and enabled third party apps.

Split View.S6 M4

View and interact with two apps at once.

Ability to resize view to give equal attention to both apps or prioritize one app over another.

Support for Apple apps and enabled third party apps.

Picture in picture.S5 S6 M2 M3 M4

Continue watching a video while using favorite apps.

Support for Safari video, FaceTime, Videos and Podcasts and enabled third party apps.

QuickType improvements.

Multi-Touch gestures for easier text selection on iPad.

Quick access to text editing tools with Shortcut Bar on iPad.

Support for hardware keyboard shortcuts.

Support for all Unicode emoji flags.

Support for Alt Tab / Cmd Tab.

Folders on iPad use a 4x4 layout rather than 3x3.

Redesigned notification center view when in landscape.

Keyboard improvements

New keyboard now displays whether the letters are upper-case or lower-case depending on whether the Shift key has been toggled or not.

Cut/Copy functions on the keyboard have been replaced with an Undo/Redo button. The Cut/Copy buttons still appear when text is selected.

Over 50 new flag emojis.

A "deep press" (3D touch) on the keyboard will convert the keyboard to a track pad to move the cursor and make it easier to manipulate text. (6S and 6S Plus only)

Ability to disable character preview.

Performance and stability improvements.

Extends the battery life of iOS devices by an extra hour.

Minimizes iOS update file size to 1.3 GB.

Improves performance on iOS devices by utilising Metal API throughout iOS to deliver faster scrolling, smoother animation, and better overall performance.

Reduced touch latency from sixty milliseconds to less than thirty milliseconds.

Security improvements

Touch ID devices now use a 6-digit passcode by default, though a 4-digit option is still available alongside options for a passcode with a custom number of digits and an alphanumeric passcode.P5S P6 P6P S6 M3

Adds 2-factor authentication for iCloud on iOS.

Adds support for add an IKEv2 VPN directly in Settings without need for third-party app.

Other improvements

Print preview screen. Allows the user to view all pages, select which pages to print, and print in black and white.

Leave a message option if recipient isn't available for a FaceTime call.

Share voicemails from the Phone app using the share sheet.

Added confirmation dialog when an app attempts to open another app.

Support for right-to-left languages.

Flight and package tracking for data detectors

iCloud Drive app.

Easily search for a file or browse in the new iCloud Drive app by date, name, or tags added on associated Mac.

Open files in any compatible app.

Organize folders and files.

Get the iCloud Drive app in Settings > iCloud > iCloud Drive and select Show on Home Screen.

Wi-Fi Assist to automatically use cellular data when Wi-Fi connectivity is poor.

UI changes

3D Touch. (6S and 6S Plus only)

Helvetica Neue font used in iOS 7/8 replaced by San Francisco font used on Apple Watch.

It is possible to go directly back to a formerly used app if a link opens another app.

Recent Contacts have been removed from the multitasking UI. They have now been placed in the new Proactive Menu.

Handoff is now displayed as a pull up menu in the app switcher.

Redesigned Voice Control audio waveform.

Redesigned audio dictation audio waveform.

Expanded language support

New PingFang Chinese system font.

Improved predictions, learning and autocorrection for Chinese in QuickType.

Redesigned punctuation input on 10-key Chinese keyboard.

Redesigned User Interface for right-to-left languages.

Added Siri support for Austria, Belgium (French and Dutch), and Norway.

Added Spotlight search support for Mexico.

New display languages for German (Germany), German (Austria), German (Switzerland), English (Canada), French (France), French (Switzerland), Italian (Italy), Italian (Switzerland), and Traditional Chinese (Taiwan).

New keyboards for French (Belgium), German (Austria), Gujarati, Hindi (Transliteration), Hinglish, Punjabi, Spanish (Mexico), and Telugu.

Predictive input for French (Belgium), German (Austria), Korean, Russian, Spanish (Mexico), and Turkish.

Dictation support for Dutch (Belgium), English (Ireland, Philippines, South Africa), French (Belgium), German (Austria), and Spanish (Chile, Colombia).

Spell check for Finnish and Korean.

Definition dictionary for Hindi, Norwegian and Swedish.

Bilingual dictionary for French-English and German-English.

New Japanese autocorrection, improved predictions, and learning in QuickType.

Option to switch between number systems for Arabic and Hindi.

Enterprise and Education

DEP (Device Enrolment Program) Support added for 26 countries.

Assign apps directly to iOS devices without needing to have an iTunes Store account configured.

Improved calendar reliability for customers using Microsoft Exchange ActiveSync v16.

Expanded Per App VPN support for the built-in IPSec and IKEv2 VPN clients.

New networking controls for managed apps to help limit international data roaming costs.

New restrictions to prevent changes to passcodes, device names and wallpapers, and to disable AirDrop on managed devices.

Third party app extension support for VPN, advanced content filtering, and captive Wi-Fi networks.

Accessibility

Touch Accommodations provides additional touch control for those with physical motor limitations.

Speak Selection and Speak Screen can now use Siri voice.

Ability to customise Assistive Touch menu.

Support for hardware keyboard sticky keys, key repeat, and slow keys.

Ability to show only uppercase keys or case correct keys.

Ability to disable vibrations.

Ability to disable Shake to Undo.

Improved MFi hearing aid audio routing to choose where audio is played.

Apple Developers – iOS SDK 9.0

Support for Swift 2.0.

ReplayKit.

Allows recording gameplay in the background to enable sharing of short video clips of gameplay.

GameplayKit.

Model I/O.

Support for text input Notification Actions in 3rd party apps.

Search extension.

MapKit.

Access to 3D flyover view.

Access to traffic data.

ResearchKit iPad support.

HomeKit.

Support for additional devices.

Predefined scenes.

Wake up.

Leave Home.

Arrive Home.

Bed.

Test on device.

Predictive Touch.

CloudKit integration.

Can be jailbroken by Pangu 9 Fuxi Qin.

9.0.1 13A404 M4 M4C P4S P5 P5C P5S P6 P6P T5 T6 S2 S2C S2D S3 S3L S3D S4 S4L S4D S5 S5L S5D S6 S6L S6D M1 M1C M2 M2C M3 M3C

13A405 P6S P6SP

September 23, 2015; 6 years ago (13A404)

September 24, 2015; 6 years ago (13A405)

Fixes an issue where some users could not complete setup assistant after updating.

Fixes an issue where sometimes alarms and timers could fail to play.

Fixes an issue in Safari and Photos where pausing video could cause the paused frame to appear distorted.

Fixes an issue where some users with a custom APN setup via a profile would lose cellular data.

Can be jailbroken by Pangu 9 Fuxi Qin.

9.0.2 13A452 September 30, 2015; 5 years ago 

Fixes an issue with the setting to turn on or off app cellular data usage.

Fixes an issue that prevented iMessage activation for some users.

Fixes an issue where an iCloud backup could be interrupted after starting a manual backup.

Fixes an issue where the screen could incorrectly rotate when receiving notifications.

Improves the stability of Podcasts.

Fixes an issue where a lock screen issue allowed access to photos and contacts on a locked device.Can be jailbroken by Pangu 9 Fuxi Qin.

#### iOS 9.1

iPad:

iPad (2, 3rd, 4th) Air (1st, 2) Mini (1st, 2, 3, 4) Pro (1st, 12.9)

iPhone:

4S 5 5C 5S 6 6 Plus 6S 6S Plus

iPod touch:

5th 6th

Limited support on iPad 2, iPad (3rd generation), iPad Mini (1st generation), iPhone 4S, and iPod Touch (5th generation)

Version Build Release date Features

9.1 13B143 October 21, 2015; 5 years ago Initial release on iPad Pro (12.9-inch)

Live Photos now intelligently senses when the iPhone is raised or lowered, so that Live Photos will automatically not record these movements.

Over 150 new emoji characters with full support for Unicode 7.0 and 8.0 emojis.

Improved stability including CarPlay, Music, Photos, Safari, and Search.

Improved performance while in Multitasking UI.

Fixes an issue that could cause Calendar to become unresponsive in Month view.

Fixes an issue that prevented Game Center from launching for some users.

Fixes an issue that zoomed the content of some apps.

Fixes an issue that could cause an incorrect unread mail count for POP mail accounts.

Fixes an issue that prevented users from removing recent contacts from new mail or messages.

Fixes an issue that caused some messages to not appear in Mail search results.

Fixes an issue that left a gray bar in the body of an audio message.

Fixes an issue that caused activation errors on some carriers.

Fixes an issue that prevented some apps from updating from the App Store.

Originally patched the Pangu iOS 9 jailbreak, however the Pangu team released an update with support for iOS 9.1 on 64 bit devices.

#### iOS 9.2

iPad:

iPad (2, 3rd, 4th) Air (1st, 2) Mini (1st, 2, 3, 4) Pro (1st, 12.9)

iPhone:

4S 5 5C 5S 6 6 Plus 6S 6S Plus

iPod touch:

5th 6th

Limited support on iPad 2, iPad (3rd generation), iPad Mini (1st generation), iPhone 4S, and iPod Touch (5th generation)

Version Build Release date Features

9.2 13C75 December 8, 2015; 5 years ago 

Only supports iTunes 12.3 or higher, and thus does not work anymore together with iTunes on Mac OS X 10.7 or lower.

Apple Music improvements

Ability to create a new playlist when adding a song to a playlist.

Most recently changed playlist is now listed at the top when adding songs to playlists.

Ability to download albums or playlists from your iCloud Music Library by tapping the iCloud download button.

New download indicator next to each song in My Music and Playlists.

See works, composers, and performers while browsing Classical music in the Apple Music catalog.

New Top Stories section in News application (available in the US, UK, and Australia).

Mail Drop in Mail for sending large attachments.

iBooks now supports 3D Touch to peek and pop pages from the table of contents, notes and bookmarks, and from search results inside a book.

iBooks now supports listening to an audiobook while browsing the library, reading other books, and exploring the iBooks Store.

iPhone support for the USB Camera Adapter to import photos and videos.

Safari Improved stability.

Podcasts Improved stability.

Fixed an issue that caused mail attachments to be inaccessible for some users with POP email accounts.

Resolved an issue that caused attachments to overlap text in mail.

Fixed an issue where Live Photos could have turned off after restoring from a prior iCloud backup.

Addressed an issue that could cause search in Contacts to display no results.

Resolved an issue that could have prevented Calendar from displaying all seven days in week view.

Fixed an issue where Camera screen on iPad could be black when attempting to capture video.

Addressed an issue that could cause instability in the Activity app when viewing the day of daylight saving time transition.

Fixed an issue that could prevent data from appearing in Health.

Fixed an issue that could prevent Wallet updates and Lock screen alerts from displaying.

Addressed an issue where updating iOS could prevent an alarm from going off.

Fixed an issue where some users were unable to log into Find My iPhone.

Fixed an issue that prevented some manual iCloud Backups from completing.

Addressed an issue where using the iPad keyboard could unintentionally trigger text selection mode.

Improved keyboard responsiveness when using Quick Reply.

Improved punctuation input on the 10-key Chinese (Pinyin and Stroke) keyboards with new expanded view of punctuation symbols and better predictions.

Fixed an issue on Cyrillic keyboards where caps lock would be enabled when typing in URL or email fields.

Siri support for Arabic (Saudi Arabia, United Arab Emirates).

Accessibility improvements

Fixed issues with VoiceOver when using Camera face detection.

Added support for VoiceOver to wake up the screen.

Added support for VoiceOver to invoke app switcher with 3D Touch gesture.

Fixed an issue with Guided Access when trying to end phone calls.

Improved functionality for Switch Control users when using 3D Touch.

Fixed an issue with speech rate of Speak Screen.

SFSafariViewController now supports 3rd party Action Extensions. Any Action Extension that works in Safari will also work in SFSafariViewController.

Long tapping the Reload button in Safari View Controller now gives options to Reload Without Content Blockers and Request Desktop Site, like in Safari.

Fixed an issue where WebApps saved to the home screen would not respect the apple-mobile-web-app-status-bar-style meta tag.

9.2.1 13D15

13D20 P6 P6P P6S P6SP M3 M3C M4 M4C R1 R1C S6 S6L

January 19, 2016; 5 years ago

February 18, 2016; 5 years ago (13D20)

General bug fixes and security patches.

iTunes re-issued on February 18, 2016, (build 13D20) Fixes rare "Error 53" on iPhone 6.

#### iOS 9.3

iPad:

iPad (2, 3rd, 4th) Air (1st, 2) Mini (1st, 2, 3, 4) Pro (1st, 12.9 & 9.7)

iPhone:

4S 5 5C 5S SE (1st) 6 6 Plus 6S 6S Plus

iPod touch:

5th 6th

Limited support on iPad 2, iPad (3rd generation), iPad Mini (1st generation), iPhone 4S, and iPod Touch (5th generation)

Version Build Release date Features

9.3 13E233

13E234 R2 R2C P6S P6SP

13E236 S2C

13E237 P4S P5 P5C P5S

March 21, 2016; 5 years ago

March 25, 2016; 5 years ago (13E236)

March 28, 2016; 5 years ago (13E237)

Initial release on the iPhone SE (1st generation) and iPad Pro (9.7-inch)

Night Shift (only available on 64-bit devices).P5S PSE P6 P6P P6S P6SP T6 S5 S6 R1 R2 M2 M3 M4

Adds support for a new feature named Night Shift which, manually or automatically (based on user preference), makes the display color warmer so it is easier to view at night. Users can adjust the color temperature in the Settings app.

Control Center

Adds toggle for Night Shift mode on supported devices.

Night Shift toggle redesign in Beta 4.

Notes

Adds support for protecting notes inside the Notes app with a passcode or Touch ID.

News

News delivers stories that are better curated to a user's tastes.

News suggests editors' and top picks to users at the top.

When checking for updates, News refreshes much faster.

If a story contains video, it is possible to view it directly from your feed.

Support for landscape viewing on iPhone.

News appears in additional countries.

Apple Watch

Support for pairing multiple Apple Watches to your iPhone.

Health

Easier app discovery with the Health app.

Health now includes data from the Apple Watch and Activity app.

Photos

When removing a photo from an album, users are given a choice to remove the photo or to delete it.

CarPlay

Adds support for the For You and New tabs in the Music section of CarPlay

Adds the Nearby feature in Maps which quickly lets you discover points-of-interest nearby.

Classroom Enhancements

Adds support for multi-user logons in schools so any student can log in (with a passcode) to an iPad issued by the school.

Adds a new Classroom app for those devices registered with schools which allows teachers to guide students through a lesson, see their progress, keep them on track, present quizzes and tests, and wirelessly display their work with AirPlay and Apple TV.

Adds support for a device manager in which school administrators can set up multiple Apple IDs, change passwords, enroll students in iTunes U courses, etc.

Dolby Digital Plus

Adds support for playing video encoded with Dolby Digital Plus audio streams. (iPhone 5s and newer, iPod Touch 6th gen and newer, iPad Mini 2 and newer, iPad Air series, iPad Pro series)

Multichannel output is supported using the Apple Lightning Digital AV Adapter.

New 3D Touch shortcuts added for Health, App Store, iTunes, Settings, Weather, Stocks, and Compass apps.

Safari 9.1.

Wi-Fi calling enabled for Verizon

New language support

Support for Spanish (Latin America) display language.

Siri support for Finnish, Hebrew, and Malay.

Improvements to stability and performance.

Fixes an issue where manually changing the date to May 1970 or earlier could prevent 64-bit devices from turning on after a restart.

Fix CVE-2016-1788, a security vulnerability that allowed an attacker to decrypt iMessage attachments, by rejecting replay attempts.

Build 13E236 and 13E237 were issued to devices that were affected by the Activation Lock bug. These re-issued builds helped correct the issue after the prior builds were withdrawn.

9.3.1 13E238 March 31, 2016; 5 years ago 

Fixes an issue that caused apps to be unresponsive after tapping on links in Safari or other apps.

Fixes an issue where connecting to a fake Apple time server which sets system time to January 1, 1970 can cause 64-bit devices to overheat and become unresponsive after a restart.

9.3.2 13F69

13F72 R2 R2C

May 16, 2016; 5 years ago

June 2, 2016; 5 years ago (13F72) 

Bug fixes and improvements to security.

Fixes an issue where some Bluetooth accessories could experience audio quality issues when paired to iPhone SE.

Fixes an issue where looking up dictionary definitions could fail.

Fixes an issue that prevented typing email addresses when using the Japanese Kana keyboard in Mail and Messages.

Fixes an issue for VoiceOver users using the Alex voice, where the device switches to a different voice to announce punctuation or spaces.

Fixes an issue that prevented MDM servers from installing Custom B2B apps.

9.3.3 13G34 July 18, 2016; 5 years ago 

General bug fixes and improvements

9.3.4 13G35 August 4, 2016; 5 years ago 

Fixes CVE-2016–4654, a memory corruption vulnerability in IOMobileFrameBuffer found by Team Pangu that allows arbitrary code execution with kernel privileges.

9.3.5 13G36 August 25, 2016; 5 years ago Final release supported on iPod Touch (5th generation), iPad 2 Wi-Fi, iPad (3rd generation) Wi-Fi, and iPad Mini (1st generation) Wi-Fi

Fixes three zero-day vulnerabilities. These vulnerabilities were chained together by the NSO Group into the Trident exploit chain. Trident is composed of CVE-2016–4657, CVE-2016–4655 and CVE-2016–4656 and uses them in that order. First, Trident's first stage uses CVE-2016–4657 to exploit WebKit, iOS's built-in web browser engine, via malicious JavaScript to cause WebKit to execute arbitrary Trident's second stage malware. Trident's second stage then downloads the Pegasus spyware package, uses CVE-2016–4655 to locate the kernel, and uses CVE-2016–4656 to disable signature verification in order to allow unsigned code like Pegasus to execute. The second stage malware then uses the previously discovered location of the kernel to install and load Pegasus with kernel privileges, allowing the attacker to steal all data on the phone and spy on the victim's conversations live.

EOL updates

9.3.6 13G37 July 22, 2019; 2 years ago iPhone 4s, iPad mini (1st generation) Wi-Fi + Cellular, iPad 2 Wi-Fi + Cellular, and iPad (3rd generation) Wi-Fi + Cellular only

Final release supported on iPhone 4S, iPad 2 Wi-Fi + Cellular, iPad (3rd generation) Wi-Fi + Cellular, and iPad Mini (1st generation) Wi-Fi + Cellular

Fixes a GPS Week Number Rollover issue that would prevent GPS-enabled devices from maintaining an accurate GPS position or time after November 3, 2019.

### iOS 10

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 10 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/10/IOS_10_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/10/IOS_10_logo.svg)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/10/IOS_10_Homescreen_iPhone_7.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/10/IOS_10_Homescreen_iPhone_7.png)

Apple announced [iOS 10](https://github.com/seanpm2001/WacOS/wiki/iOS-10/) on June 13, [2016](https://github.com/seanpm2001/WacOS/wiki/2016/), at its annual Apple Worldwide Developers Conference (WWDC) event, and it was released to the public on September 13, [2016](https://github.com/seanpm2001/WacOS/wiki/2016/), alongside the iPhone 7 and iPhone 7 Plus. With this release, Apple dropped support for devices using an A5 or A5X processor: the iPhone 4S, the iPad 2, iPad (3rd generation), iPad Mini (1st generation), and iPod Touch (5th generation). [iOS 10](https://github.com/seanpm2001/WacOS/wiki/iOS-10/) has limited support on devices with 32-bit processors: the iPhone 5, iPhone 5C, and iPad (4th generation). However, the iPhone 5S onwards, iPod Touch (6th generation), iPad Air onwards, and the iPad Mini 2 onwards are fully supported. The release of iOS 10.2.1 brought support for the iPad (5th generation), and iOS 10.3.2 brought support for the iPad Pro (10.5-inch) and the iPad Pro (12.9-inch, 2nd generation). iOS 10.3.3 is the final supported release for the iPhone 5C and the Wi-Fi-only iPad (4th generation). iOS 10.3.4 is the final supported release for the iPhone 5 and the Wi-Fi + cellular iPad (4th generation). iOS 10 is the last [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) version to run on 32-bit processors and also the last to run 32-bit apps.

#### iOS 10.0

iPad:

iPad (4th) Air (1st, 2) Mini (2, 3, 4) Pro (1st, 12.9 & 9.7)

iPhone:

5 5C 5S SE (1st) 6 6 Plus 6S 6S Plus 7 7 Plus

iPod touch:

6th

Limited support on iPad (4th generation), iPhone 5, and iPhone 5C

Version Build Release date Features

10.0 14A403

14A346 P7I P7Q P7PI P7PQ September 13, 2016; 5 years ago Initial release on iPhone 7 and iPhone 7 Plus

Allow hiding home screen icons of most built-in apps:

Calculator, Calendar, Compass, Contacts, FaceTime, Find My Friends, Home, iBooks, iCloud Drive, iTunes Store, Mail, Maps, Music, News, Notes, Podcasts, Reminders, Stocks, Tips, Videos, Voice Memos, Watch app, Weather.

New Sounds

Locking device.

Keyboard Clicks.

2 new voices added to Arabic voiceover.

Lock Screen

Swipe left to open Camera.

Swipe right for Today view.

Press home button to unlock device.

Messages

Expressive Messaging.

Bubble effects allows sending messages loudly, gently, with a slam or with invisible ink.

Full-screen effects.

Tapback for quick replies to messages, links and photos.

Handwritten messages animate like ink on paper.

Digital Touch allows sending of sketches, taps and heartbeats.

Tap to replace can emojify text with just a tap.

Rich links show a preview of shared web pages.

iMessage apps

New App Store for iMessage.

Use the power of apps in Messages to share and collaborate with friends.

Download stickers to send and place on text bubbles and photos.

Siri

Siri now works with the following types of apps.

Messaging apps to send, search and read back text messages.

VoIP apps to make phone calls.

Photo apps to search for images and photos.

Ride service apps to book rides.

Payment apps to make personal payments.

Fitness apps to start, stop and pause workouts.

CarPlay carmaker apps to adjust climate, radio, seat and personal settings.

Maps

All-new look.

Proactive suggestions for places user is likely to go next, based on routine or appointments in Calendar.

Improved search with new callout design, clustered results and category filters.

Home, work, favourite locations and locations from upcoming Calendar events are displayed on the map.

Displays where the users car is parked via CarPlay or Bluetooth.

Weather for the currently viewed area.

Extensions

Make a reservation within Maps using extensions from participating reservations apps.

Book a ride to a destination within Maps using extensions from participating ride service apps.

Turn-by-turn navigation improvements.

Search along route for petrol stations, food and coffee shops.

Automatic view adjustment of the road ahead.

Use pan and zoom during navigation.

Option to avoid tolls and motorways.

Photos

Advanced face recognition designed with deep learning to automatically group similar faces together.

Object and scene recognition to intelligently search for photos by what's in them using computer vision that scans the photo library locally on the device.

Places album to see all photos, videos and Live Photos on a map.

Memories

Intelligently highlights forgotten events, trips and people, and presents them in a collection.

Memory movies automatically edited with theme music, titles and cinematic transitions.

Related memories to rediscover photos, based on location, time, people, scenes and objects.

Easily share with family and friends.

Brilliance control applies region-specific adjustments to brightness, highlights and contrast.

Home

New Home app to securely manage and control HomeKit-enabled accessories.

Scenes to control groups of accessories with just a tap.

Rich notifications with quick actions to control accessories.

Optionally share home access with family and friends.

Remote access and automation of accessories with Apple TV or iPad.

Apple Music

An all-new design.

Navigate Library with modified menu and see all the Downloaded Music that can play on device while offline.

See recommendations in For You that highlight mixes, playlists, albums and Connect posts – selected based on their music and artist preferences.

Browse to see exclusive releases, find curated playlists and discover the most important new releases – picked by editors.

Modified Radio interface – clearly see what's live on Beats 1, hear favourite shows on demand or choose a curated station for any genre of music.

Modified Now Playing interface – swipe up to view available lyrics and quickly see or edit songs that are coming up next.

Apple News

All-new design in For You adds bold typography, vibrant colour and distinct sections to find stories on specific topics.

Important stories of the day within Top Stories – updated by editors throughout the day.

Find most popular stories right now within Trending Stories – selected based on what others are reading.

User can see all stories grouped into sections based on the topics they follow or read.

Featured Stories – selected by editors.

Share stories – tap the icon on any story to send it to a friend from For You.

Receive breaking news notifications from users trusted sources.

Subscribe to favourite magazines and newspapers directly in News.

New personalised Today View widget lets user keep up with the latest stories throughout the day.

Experience

Raise to Wake automatically wakes the screen as iPhone is raised.P6S P6SP PSE P7 P7P

Rich notifications that support real-time information, audio, photos and videos.

Today view is redesigned and supports all-new widgets for apps like Weather, Up Next, Maps, Stocks and more.

Control Center is redesigned including dedicated cards for music playback and Home.

Expanded use of 3D Touch.

Lock screen notifications to support an expanded view and access to quick actions.

New quick actions for built-in apps like Weather, Stocks, Reminders, Health, Home, FaceTime, iCloud Drive and Settings.

Home screen widgets.

Control Center for access to quick actions for Torch, Timer, Calculator and Camera.

Clear all in Notification Center.

QuickType

New emoji, including gender-diverse options to existing characters, single-parent family variations, rainbow flag and redesigns of popular emoji.

Contextual predictions for current location, recent addresses, contact information and calendar availability using deep neural network technology.

Emoji predictions.

Calendar events are intelligently populated using deep learning technology with information from conversations in Mail and Messages.

Multilingual typing now lets user type in two languages at once without having to switch keyboards.

Rest & Type on iPad intelligently adapts to users unique typing patterns.

Predictive typing now uses deep neural network technology for greater prediction accuracy.

Phone

Voicemail transcription (beta).

Spam call alerts with spam call identification apps.

Support for third-party VoIP apps receiving calls on the Lock screen, including support for Call Waiting, Mute and Do Not Disturb.

Contacts

Emergency bypass allows call and text notifications to sound aloud regardless of silent or Do Not Disturb mode.

Other improvements

Apple Pay in Safari P6 P6P P6S P6SP PSE P7 P7P.

View two pages at once using Split View in Safari on iPad.

Notes collaboration lets user invite people to work on notes together.

Markup support in Messages, Photos and PDFs stored in Notes.

Bedtime Alarm in the Clock app lets user set a regular sleep schedule and receive bedtime reminders.

Health adds support for health records and organ donation (US only).

Stabilisation support for Live Photos for improved camera capture.

Live Filters support when capturing Live Photos.

iCloud Drive now supports Desktop and Documents folders from macOS.

Live search results in Spotlight for Chinese and Japanese.

Siri support for Spanish (Chile), Chinese (Cantonese – China), English (Ireland), English (South Africa).

Ling Wai and Kaiti Black document fonts for Chinese.

Yu Kyokasho and Toppan Bunkyu fonts for Japanese.

New definition dictionaries in Traditional Chinese and Danish and bilingual dictionaries in Dutch and Italian.

New keyboard for Spanish (Latin America).

New display languages and locales for English (Ireland), English (New Zealand), English (Singapore), English (South Africa), Spanish (Argentina), Spanish (Chile), Spanish (Colombia), Spanish (Costa Rica), Spanish (Ecuador), Spanish (United States), Spanish (El Salvador), Spanish (Guatemala), Spanish (Honduras), Spanish (Nicaragua), Spanish (Panama), Spanish (Paraguay), Spanish (Peru), Spanish (Puerto Rico), Spanish (Dominican Republic), Spanish (Uruguay), Spanish (Venezuela), French (Belgium), Dutch (Belgium), Dutch (Netherlands), and Traditional Chinese (Macau).

Accessibility

Magnifier now uses the camera on iPhone or iPad like a digital magnifying glass for real-life objects.

New range of display colour filters to support different forms of colour blindness or other vision challenges.

VoiceOver adds a Pronunciation Editor to customise the way words are pronounced, additional voices and support for multiple audio sources.

Additional text highlighting options in Speak Screen and Speak Selection, as well as the ability to speak keyboard letters and predictive typing suggestions to support multi-modal learning.

Switch control now lets user control iOS, macOS and tvOS all from the same iPhone or iPad, so user doesn't need to configure switches for the secondary device.

Software textphone allows user to make and receive textphone calls without the need for traditional hardware teleprinter accessories.

Bug Fixes from 10.0 (iPhone 7/Plus changelog)

Fixes an issue that could prevent recognizing "Hey Siri" requests.

Fixes issues that could affect audio quality for calls made over VoLTE.

Fixes issues that could impact Bluetooth connectivity and pairing with Apple Watch.

Improves stability of the Camera and Contacts apps.

10.0.2 14A456 September 23, 2016; 5 years ago 

Fixes an issue that could temporarily prevent headphone audio controls from working.

Fixes an issue that caused Photos to quit for some users when turning on iCloud Photo Library.

Fixes an issue that prevented enabling some app extensions.

10.0.3 14A551 P7I P7Q P7PI P7PQ October 17, 2016; 4 years ago iPhone 7 and iPhone 7 Plus only

Fixes an issue where cellular connectivity could drop on iPhone 7 and iPhone 7 Plus.

#### iOS 10.1

iPad:

iPad (4th) Air (1st, 2) Mini (2, 3, 4) Pro (1st, 12.9 & 9.7)

iPhone:

5 5C 5S SE (1st) 6 6 Plus 6S 6S Plus 7 7 Plus

iPod touch:

6th

Limited support on iPad (4th generation), iPhone 5, and iPhone 5C

Version Build Release date Features

10.1 14B72

14B72c P7I P7Q P7PI P7PQ

October 24, 2016; 4 years ago 

Camera and Photos

Introduces Portrait Camera for iPhone 7 Plus that creates a depth effect that keeps your subject sharp while creating a beautifully blurred background (beta).

People names in the Photos app are saved in iCloud backups.

Improved the display of wide color gamut photos in the grid views of the Photos app.

Fixes an issue where opening the Camera app would show a blurred or flashing screen for some users.

Fixes an issue that caused Photos to quit for some users when turning on iCloud Photo Library.

Maps

Transit support for every major train, subway, ferry, and national bus line, as well as local bus systems for Tokyo, Osaka, and Nagoya.

Sign-based transit navigation including layouts of all underground structures and walkways that connect large transit stations.

Transit fare comparison when viewing alternative transit routes.

Messages

New option to replay bubble and full screen effects.

Messages effects can play with Reduce Motion enabled.

Fixes an issue that could lead to contact names appearing incorrectly in Messages.

Fixes an issue where Messages could open to a white screen.

Fixes an issue that could prevent the report junk option from displaying with unknown senders.

Fixes an issue where videos captured and sent in the Messages app could be missing audio.

Apple Watch

Adds distance and average pace to workout summaries in the Activity app for outdoor wheelchair run pace and outdoor wheelchair walk pace.

Fixes issues that may have prevented Music playlists from syncing to Apple Watch.

Fixes an issue that was preventing invitations and data from appearing in Activity Sharing.

Fixes an issue that was allowing Activity Sharing to update over cellular when manually disabled.

Fixes an issue that was causing some third-party apps to crash when inputting text.

Other improvements and fixes

Improves Bluetooth connectivity with third party accessories.

Improves AirPlay Mirroring performance when waking a device from sleep.

Fixes an issue where playback would not work for iTunes purchased content when the "Show iTunes Purchases" setting is turned off.

Fixes an issue where certain selfie apps and face filters used with the FaceTime HD camera on iPhone 7 and iPhone 7 Plus did not display a live preview.

Fixes an issue in Health where individual strokes are converted to separate characters when using the Chinese handwriting keyboard.

Improves performance of sharing websites from Safari to Messages.

Fixes an issue in Safari that caused web previews in tab view to not display correctly.

Fixes an issue that caused certain Mail messages to be reformatted with very small text.

Fixes an issue that caused some HTML email to be formatted incorrectly.

Fixes an issue that in some cases caused the search field to disappear in Mail.

Fixes an issue that could prevent Today View Widgets from updating when launched.

Fixes an issue where Weather widget sometimes failed to load data.

Fixes an issue on iPhone 7 where Home Button click settings would not appear in search results.

Fixes an issue that prevented spam alert extensions from blocking calls.

Fixes an issue that could prevent alarm sounds from going off.

Fixes an issue where audio playback via Bluetooth would cause the Taptic engine to stop providing feedback for some users.

Fixes an issue preventing some users from restoring from iCloud Backup.

Security updates

List of patches.

10.1.1 14B100

14B150

October 31, 2016; 4 years ago

November 9, 2016; 4 years ago (14B150)

Fixes an issue where Health data could not be viewed for some users.

New security entries added since iOS 10.1.

#### iOS 10.2

iPad:

iPad (4th) Air (1st, 2) Mini (2, 3, 4) Pro (1st, 12.9 & 9.7)

iPhone:

5 5C 5S SE (1st) 6 6 Plus 6S 6S Plus 7 7 Plus

iPod touch:

6th

Limited support on iPad (4th generation), iPhone 5, and iPhone 5C

Version Build Release date Features

10.2 14C92 December 12, 2016; 4 years ago 

TV

Use Up Next to see the movies and shows you're currently watching and pick up where you left off.

Get recommendations for new movies and TV shows in Watch Now.

Discover new apps and the latest iTunes releases in the Store.

Access the Library for your iTunes purchases and rentals.

New Widget for TV and Videos app.

Videos

Removed from iOS completely, as the TV app replaces it (US only, as of this update).

Emoji

Redesigned emoji that reveal even more detail.

Over 100 new emoji including new faces, food, animals, sports, and professions. Unicode 9.0 support.

Photos

Improves stabilization and delivers faster frame rate for Live Photos.

Improves accuracy of groupings of similar photos of the same person in the People album.

Fixes an issue where Memories might generate a memory from photos of screenshots, whiteboards or receipts.

Fixes an issue where the camera would stay zoomed in after switching back from the Camera Roll on iPhone 7 Plus.

Additional support for RAW digital cameras.

Messages

Adds new love and celebration full screen effects in Messages.

Fixes an issue that sometimes prevented the keyboard from displaying in Messages.

Music

Swipe up the Now Playing screen to more easily access Shuffle, Repeat and Up Next.

Choose how to sort Playlists, Albums, and Songs in Library.

'Show Star Ratings' option under Music Settings.

News

Stories you've saved for later now appear in the new Saved section.

The best paid stories from channels you subscribe to will now appear in a dedicated section in For You.

It's now easier than ever to get to the next story, just swipe left or tap Next Story while reading.

Mail

Fixes an issue that caused the Move sheet to persist after filing a Mail message.

Fixes an issue with long press activating copy and paste in Mail.

Fixes an issue in which the wrong message would be selected after deleting a Mail conversation.

Settings

New wallpapers for iPhone 7 and 7 Plus – These include the ones Apple showed off at their iPhone 7 press event.

New 'Preserve Settings' menu under Camera Settings.

New 'Press and Hold to Speak' menu under Home Button Accessibility settings.

New TV app section

New TV Provider section for Single-Sign-On.

SOS

iPhone calls emergency services if power button is pressed five times (India only).

Siri

New introduction screen for Siri.

Accessibility

Adds BraillePen14 support to VoiceOver.

Fixes an issue where the braille table could switch unexpectedly with VoiceOver.

Fixes an issue where sometimes Siri enhanced voices were unavailable to VoiceOver.

Fixes an issue where VoiceOver users could not re-order items in lists.

Fixes an issue where Switch Control was sometimes unable to delete Voicemails.

Other improvements and fixes

Adds notification support for HomeKit accessories including window coverings, occupancy, motion, door/window, smoke, carbon monoxide, and water leak sensors.

Adds notification support for HomeKit accessories when software updates are available.

Improves Bluetooth performance and connectivity with third party accessories.

Fixes an issue that could cause FaceTime participants to appear out of focus.

Fixes an issue that could cause FaceTime calls to appear with incorrect aspect ratio and orientation.

Fixes an issue that prevented some Visual Voicemail from completing playback.

Fixes a Safari Reader issue that could cause articles to open as empty pages.

Fixes an issue that could cause Safari to quit unexpectedly after marking an item as read in Reading List.

Security updates: https://support.apple.com/en-us/HT207422

10.2.1 14D27 January 23, 2017; 4 years ago 

Initial release on iPad (5th generation)

General bug fixes and performance improvements.

Improves power management during peak workloads to avoid unexpected shutdowns.

Security updates: https://support.apple.com/en-us/HT207482

#### iOS 10.3

iPad:

iPad (4th, 5th) Air (1st, 2) Mini (2, 3, 4) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5)

iPhone:

5 5C 5S SE (1st) 6 6 Plus 6S 6S Plus 7 7 Plus

iPod touch:

6th

Limited support on iPad (4th generation), iPhone 5, and iPhone 5C

Version Build Release date Features

10.3 14E277 March 27, 2017; 4 years ago 

Find My iPhone

There's a new "Find My AirPods" tool in Find My iPhone to help users locate lost AirPods.

The Location and Play Sound is now supported for AirPods.

This sound emits a noise from the AirPods that reaches a high volume after a few seconds. Users should remove their AirPods from their ears before playing the sound.

HomeKit

Expanded HomeKit Programmable Light Switch accessory support.

Siri

Siri can now display cricket scores from the Indian Premier League and the International Cricket Council.

Siri updated to be able to pay bills, check on the status of payments, and schedule future rides via Uber and Lyft and other apps that support the function.

Siri now has breadcrumb support. For example, users can say "Hey Siri, open the App Store" and a back arrow (or left arrow) will appear in the left of the iOS status bar to jump back to the Siri interface.

Safari

Safari now supports the Reduced Motion accessibility preference for web apps.

Maps

The weather icon in the Maps app includes 3D Touch to show hourly forecasts.

Removed 3D globe, replaces it with a flat 2D look.

Calendar

Shows an alert below the "Event Details" page, for event invitations sent from unknown senders, and allows users to report event invites sent from unknown senders as junk.

CarPlay

CarPlay includes new shortcuts for launching recently used apps.

EV charging station locations show up in CarPlay.

New "Up next" option and quick access to albums.

News

The navigation bar icons are now visibly bolder.

There is now an option to 'show disliked' channels on the bottom of the "Favorites" page.

An option has been introduced to where users can now quickly favorite or dislike news channels from the "Explore" section or the news channel that is currently open.

Home

There is now support in Home which allows users to trigger scenes which use accessories that contain switches and buttons.

There is now support in Home which allows users to see the remaining charge of the batteries in their HomeKit accessories.

Mail

Conversation View in the Mail app features navigation improvements.

When an email is open in the Mail app, the "back" button in the left corner of the screen shows the number of unread emails in the mailbox you opened the email in (Similar to the Messages app).

Animations

Slightly refined opening animation for apps to where rounded edges are now visible when opening applications (more noticeable on applications that load slowly).

Field Test

Now updated for iPhone 7 and 7 Plus devices which contain modems from Intel.

Podcasts

Support for 3D Touch and a Today widget has been added which allows users to access recently updated podcasts.

Podcast shows or episodes can now be shared in the Messages app and they feature full playback support.

Settings

Notifications

Users can now get notifications for settings other than software updates such as for two-factor authentication.

Restrictions

Users can now restrict certain TV providers.

iTunes and App Store

New system level way for developers to request app ratings, opt out option in Settings.

iCloud

The iCloud tab has moved to the top of Settings instead of being at the bottom, and also now displays the user's name and picture along with the email address(es) associated with their Apple ID(s).

Underneath this new tab is where settings notifications appear.

The amount of storage users have and how much storage users have used is now shown.

iCloud Drive cellular data usage settings have been moved to the cellular tab.

"Backup" has been renamed to 'iCloud Backup".

General

"Diagnostics and Usage" is now labeled "Analytics", corresponding changes included in menu.

There is a new button to toggle iCloud data over cellular networks.

Touch ID and Passcode

When choosing an alphanumeric code with numbers only, passcodes can no longer be shorter than 4 characters in length. An error displays saying that "this passcode must be longer".

Calling

Calls on Other Devices even when not nearby is now enabled for Verizon's Integrated Calling feature.

News

An option was added where users can disable the Next Up button from appearing while in a news article.

"Show Disliked" section under Favourites, this shows the channels that you have disliked.

Keyboards and IME

Facemarks have been shuffled around in the Chinese and Japanese keyboard layouts.

The icon of the emoji button on the keyboard is now filled in and no longer outlined like it was in previous versions of iOS.

Music

It is now possible to rearrange songs while repeat mode is turned on.

App Store

Developers can now respond to reviews on the App Store.

Developers will now be able to update the icons for their apps at any time, with an app update no longer required to push out new icon artwork for their apps.

App Store reviews now include the publish date of when the review was published.

When a user uses 3D Touch on an app review, they can rate the review as Helpful, Not Helpful, or Report a Concern with the review.

Users no longer have to enter their Apple ID password when writing a review.

Spotlight

Spotlight Search Suggestions now have a border; floating text no longer appears.

Other improvements, bug fixes, and enhancements

Users can now rent a movie once and they can watch their iTunes movies across their various devices.

Fixes the 30% battery bug that was present in previous versions of iOS 10 for iPhone 6 and iPhone 6S devices.

An alert is now displayed to indicate that 32-bit apps on 10.3 need to be updated and will no longer work in future versions of iOS. An "App Compatibility" list of 32-bit apps can be accessed by going to General > About > tapping on "Applications".

Improves performance across the system and the responsiveness of the operating system.

The file system has been updated to the Apple File System (APFS), which replaces HFS Plus, and is designed for Flash/SSD storage. APFS also features improved security and encryption, and improves system performance.

Fixes an issue related to the Messages app where the app would freeze and crash upon receiving a long text message.

Fixes an issue on the iPad Pro where the Apple Pencil's battery wouldn't charge above 5%.

Fixes an issue where the Telephoto lens on the iPhone 7 Plus would not activate while in the 2x zoom mode.

Fixes an issue in Notification Center where tapping the search bar in between the Today view and Notification Center would cause the Springboard to crash and reload.

The passcode menu UIs have been updated to show dots instead of dashes.

VoiceOver stability improvements for the Phone, Safari, and Mail apps

Fixes an issue that could prevent Maps from displaying a user's current location after resetting Location & Privacy settings.

Security

Fixes over 100 security vulnerabilities in various aspects of iOS such as Audio, the Core libraries, and WebKit.

More at https://support.apple.com/HT207617.

10.3.1 14E304 April 3, 2017; 4 years ago 

Fixed in this release:

Security

Fixes a Wi-Fi-related vulnerability through improved input validation where an attacker within range may be able to execute arbitrary code on the Wi-Fi chipsets of iPhone 5 and later.

Visit https://support.apple.com/HT207688 for more information.

10.3.2 14F89

14F8089R3C R4C

14F90S7 S7L

14F91M4C

May 15, 2017; 4 years ago Initial release on iPad Pro 10.5" and 12.9" (2nd generation)

Security and Bug Fixes; see https://support.apple.com/en-us/HT207798

10.3.3 14G60 July 19, 2017; 4 years ago Final release supported on iPhone 5C and iPad (4th generation) Wi-Fi

Includes bug fixes and improves the security of your iPhone or iPad.

One of the bugs that is fixed is in the Broadcom Wi-Fi chipset formally known as CVE-2017–9417 and is nicknamed "Broadpwn". Broadpwn allows a worm to propagate among affected Broadcom Wi-Fi chipsets just by having the Wi-Fi chipset turned on even if it is not connected to any networks, and can be used to force a remote code execution on the main CPU of an affected smartphone.

Information on security updates in iOS 10.3.3 can be found at https://support.apple.com/en-us/HT207923.

3 new wallpapers on 12.9" iPad Pro

EOL updates

10.3.4 14G61 July 22, 2019; 2 years ago iPhone 5 and iPad (4th Generation) WiFi + Cellular only

Final release supported on iPhone 5 and iPad (4th generation) Wi-Fi + Cellular

Fixes a GPS Week Number Rollover issue that would prevent iOS devices from maintaining an accurate GPS date or position after November 3, 2019, including but not limited to App Store, iCloud, email, web browsing, OTA update, and iCloud backup .

### iOS 11

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 11 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_logo.svg)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_Homescreen_iPhone_7_Plus.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_Homescreen_iPhone_7_Plus.png)

Apple announced [iOS 11](https://github.com/seanpm2001/WacOS/wiki/iOS-11/) on June 5, [2017](https://github.com/seanpm2001/WacOS/wiki/2017/), at its annual Apple Worldwide Developers Conference (WWDC) event, and it was released to the public on September 19, [2017](https://github.com/seanpm2001/WacOS/wiki/2017/), alongside the iPhone 8 and iPhone 8 Plus. With this release, Apple dropped support for the 32-bit iPhone 5, iPhone 5C, and iPad (4th generation), and also dropped support for 32-bit applications, making [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) a 64-bit-only OS that only runs 64-bit apps. [iOS 11](https://github.com/seanpm2001/WacOS/wiki/iOS-11/) has limited support on devices with the Apple A7 or A8 processors: the iPhone 5S, iPhone 6/6 Plus, iPod Touch (6th generation), iPad Air, iPad Air 2, iPad Mini 2, 3, and 4. However, all other devices from the iPhone 6S/6S Plus onwards, iPhone SE (1st generation), iPad Pro, and iPad (5th generation) onwards are fully supported. iOS 11.0.1 brought support for the iPhone X and iOS 11.3 brought support for the iPad (6th generation). The final version of [iOS 11](https://github.com/seanpm2001/WacOS/wiki/iOS-11/) to be released was iOS 11.4.1.

#### iOS 11.0

iPad:

iPad (5th) Air (1st, 2) Mini (2, 3, 4) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5)

iPhone:

5S SE (1st) 6 6 Plus 6S 6S Plus 7 7 Plus 8 8 Plus X

iPod touch:

6th

Version Build Release date Features

11.0 15A372 September 19, 2017; 4 years ago 

Initial release on iPhone 8 and iPhone 8 Plus.

New Features

App Store

Redesigns the App Store to make the discovery of new apps and games easier.

Introduces the Today tab, a curated portal with stories, how-to guides, and more to help users discover new apps and games.

Dedicated Games and Apps tabs, allowing easier access and better curation of both app categories.

Redesigned app pages putting more of a focus on video previews, nicer display of Editors' Choice badges, easier access of user ratings and reviews, and more information about the In-App Purchases for an app.

Apple Music

Support for user profiles, allowing users to follow other users and see what they are listening to as well as see their playlists (if they have been made public).

Camera

Adds HDR, Optical Image Stabilization, and True Tone Flash to Portrait Mode.

Photos and Videos now use the HEIF / HEVC image and video formats by default, with the ability to use the JPEG / H.264 formats instead via an option in Camera Settings.

HEVC supports 8-bit and 10-bit with hardware decoding supported on devices containing an Apple A9 chip or newer while software-level decoding is supported on devices that have an Apple A8 chip and older.

Introduces a redesigned set of filters, optimized for natural skin tones. There are 9 filters in total.

Adds a QR code scanner allowing users to scan QR codes.

Photos

Several new Live Photo effects have been added: Loop, Bounce, and Long Exposure.

The ability to mute, trim, or choose a new Key Photo for a Live Photo has been added.

Memory Movies now automatically adapt to the given content for Landscape and Portrait orientations.

More than a dozen new types of memories have been added including the following: Pets, Babies, Weddings, Sporting Events, and more.

The "People" album has been made more accurate and now stays synchronized across devices with iCloud Photo Library.

Support for animated GIFs has been added.

Maps

Indoor maps for places such as Airports and Shopping Centers has been introduced.

Lane guidance and speed limit information is now available for Turn-by-turn directions / navigation.

Support for one-handed zoom by double tapping and swiping has been added.

Flyover: View renderings of places and cities in 3D.

Do Not Disturb while Driving

Notifications are automatically silenced while driving and puts the iPhone in silent mode while keeping the display turned off to avoid distractions.

Users can turn on iMessage auto-reply to alert any chosen contacts when they send a message and the user is driving.

Control Center

Redesigns the Control Center to be a customizable one page layout, replacing the previous 3 page system previously in place.

Introduces several new Control Center widgets: Accessibility, Guided Access, Screen Recording, and Wallet.

iPad-specific Features

Dock

The Dock has been redesigned, allowing access to apps that have been pinned to the dock as well as access to Recently Used / Continuity apps via the right portion of the Dock.

The Dock can automatically resize itself, allowing the user to pin more than 4 apps.

The Dock can now be accessed when a user is in an app by swiping up from the bottom of the display.

Slide Over and Split View

Apps can now be placed into Slide Over / Split View by touching and holding an app from the Dock and then dragging.

Apps in Split View and apps running in the background can now run simultaneously.

Apps in Slide Over / Split View now have the ability to be placed on the left side of the display.

Drag and Drop

Users can now move text, images, and files between apps.

Users can take advantage of Multi-Touch capabilities to move multiple items at the same time.

Markup

Markup allows users to markup webpages, documents, PDFs, screenshots, photos, and more.

Users can optionally use an Apple-Pencil

Notes

Notes can now be created even with the screen off by tapping the Lock Screen with an Apple Pencil.

Drawing in a note can be instantly activated by placing an Apple Pencil in the note's body.

Users now have the ability to search for handwritten text within notes.

The document scanner has been enhanced with the ability to autocorrect for skewing and now removes shadows with the use of image filters.

Notes can now contain tables to organize information into rows and columns.

Notes can now be pinned to the top of a folder for easy access.

Files (also available on iPhone and iPod Touch)

Allows users to search, browse, and organize files.

Supports iCloud Drive as well as third-party file storage providers.

Includes a Recents view allowing users to see and access recently accessed files across apps and cloud services.

Supports the ability to create folders as well as sort files by various parameters such as name, date, size, and tags.

QuickType

The ability to flick down on letter keys to easily enter symbols, numbers, and punctuation marks without having to hold down on a letter key has been added.

A keyboard layout designed for one-handed use is now supported on iPhone.

Several new keyboard types have been added: Armenian, Azerbaijani, Belarusian, Georgian, Irish, Kannada, Malayalam, Maori, Odia, Swahili, and Welsh.

Support for English input is now available on the 10-key Pinyin and Japanese Romaji keyboard layouts.

HomeKit

Support for various new accessory types have been added including AirPlay 2 speakers, sprinklers, and faucets.

Occupancy, Time, and accessory-based triggers have been expanded.

The ability to pair an accessory by scanning a QR code has been added.

Accessibility

Support for image descriptions in VoiceOver.

Support for tables and lists in PDF files in VoiceOver.

Support for Type to Siri, allowing users to manually type Siri queries.

Spoken and braille captions are now supported for videos.

Dynamic Type has been enhanced, adding support for more text styles and reworked to work better across the iOS system.

Invert Colors has been redesigned, making media such as photos and videos easier to see.

Improvements have been made to Highlight Colors in Speak Selection and Speak Screen.

Typing in Switch Control can now scan and type whole words at a time.

Features and APIs targeted at Developers

ARKit — Allows app developers to create augmented reality experiences.

Core ML — Allows app developers to implement machine learning in their apps using the same APIs that power technologies and apps like Siri, the QuickType keyboard, and the Camera app.

Core NFC — Allows app developers to tap into the NFC chips of iPhones and scan nearby environments and possibly provide users with more information.

MusicKit — Allows app developers to implement support for various Apple Music features into their apps such as playback, search, playback queues, recommendations and more.

Architectural Changes

Support for 32-bit ARM architectures has been removed. Apps designed for 32-bit architectures will no longer work until updated by the respective app developer to support 64-bit architectures.

Other Changes and Features

Redesigns the Apple Podcasts app and introduces several new capabilities, such as the ability to display seasons, trailers and bonus episodes of a podcast. Also introduces a Listen Now tab granting easy access to new Podcast episodes and episodes currently in the playback queue.

Support for annotating PDF files in iBooks.

Support for several new features in the Apple News app including Top Stories For You, Siri recommendations, Videos of the Day, and editor curated stories via a new tab called Spotlight.

Automatic Setup

Automatically signs a user into essential Apple services, including iCloud, Keychain, iTunes, the App Store, iMessage, and FaceTime with the given Apple ID.

Restores device settings including Language, Region, Network Settings, Keyboard Preferences, Frequently Visited Places, Siri preferences, as well as Home and Health data.

Introduces the ability for a user to easily share access to a given Wi-Fi network.

A new section in Settings dedicated to storage management. Storage optimization notifications are also now available.

Introduces Emergency SOS, allowing users to quickly call emergency services based on their current location while automatically notifying emergency contacts, sharing the user's location, and displaying the Medical ID profile of the user.

Users can check flight status via Spotlight Search and Safari.

Definitions, conversions, and math calculations are now supported by Safari.

Bilingual dictionaries have been added for Russian – English and Portuguese – English.

Arabic fonts are now supported by the system.

Removed Functionality

The iCloud Drive app has been removed in favor of the redesigned and more capable Files app.

The native iOS system integrations for Facebook, Twitter, Flickr, and Vimeo have been removed.

Security Notes: https://support.apple.com/en-us/HT208112

11.0.1 15A402/15A403

15A8391 PXI PXQ September 26, 2017; 4 years ago

November 3, 2017; 3 years ago on iPhone X

Initial release on iPhone X.

Bug Fixes

Fixes an issue with Exchange email servers where email would fail to send.

Security Notes: Identical to iOS 11.0.

11.0.2 15A421 October 3, 2017; 3 years ago 

Bug Fixes

Fixes an issue where, for a small amount of iPhone 8 / 8 Plus users, a crackling sound had the chance of occurring while on a call.

Fixes an issue where some photos could end up becoming hidden.

Fixes an issue where some email attachments would not open.

Security Notes: Identical to iOS 11.0.

11.0.3 15A432 October 11, 2017; 3 years ago 

Bug Fixes

Fixes an issue where haptic feedback was not working on some devices.

Fixes an issue where touch was not working properly due to the displays not being replaced with genuine Apple displays.

Security Notes: Identical to iOS 11.0.

#### iOS 11.1

iPad:

iPad (5th) Air (1st, 2) Mini (2, 3, 4) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5)

iPhone:

5S SE (1st) 6 6 Plus 6S 6S Plus 7 7 Plus 8 8 Plus X

iPod touch:

6th

Version Build Release date Features

11.1 15B93/15B101 October 31, 2017; 3 years ago 

New Features

Emoji

More than 70 new emoji characters were added.

Bug Fixes and Improvements

3D Touch

Restores the ability to access the App Switcher by hard pressing on the edge of a display with 3D Touch enabled.

Accessibility

Improves support for Braille with Grade 2 input.

Improves access to multi-page PDFs with VoiceOver.

Fixes and improvements to VoiceOver rotor.

Photos

Fixes an issue where some photos could become blurry.

Fixes an issue where Live Photo effects would play slowly.

Fixes an issue when restoring photos from an iCloud Backup.

Fixes an issue that could cause a performance implication when swiping between device screenshots.

Other Fixes

Fixes an issue where already cleared notifications sent from the Mail app could reappear on the Lock Screen.

Fixes an issue where data could not be moved between managed apps in enterprise environments.

Fixes an issue with some 3rd-party GPS accessories giving inaccurate results.

Fixes an issue where settings for Heart Rate notifications would appear in the Apple Watch app for 1st generation devices.

Fixes an issue on Apple Watch where app icons would refuse to appear in notifications.

Security Notes: https://support.apple.com/en-us/HT208222

11.1.1 15B150 November 9, 2017; 3 years ago 

Bug Fixes

Fixes an issue with keyboard auto-correct.

Fixes an issue where Hey Siri would stop working.

Security Notes: Identical to iOS 11.1.

11.1.2 15B202 November 16, 2017; 3 years ago 

Bug Fixes

Fixes an issue where a rapid drop in temperature caused problems with the touch screen of the iPhone X.

Fixes an issue where distortion could be caused in Live Photos and videos captured on the iPhone X.

Security Notes: Identical to iOS 11.1.

#### iOS 11.2

iPad:

iPad (5th) Air (1st, 2) Mini (2, 3, 4) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5)

iPhone:

5S SE (1st) 6 6 Plus 6S 6S Plus 7 7 Plus 8 8 Plus X

iPod touch:

6th

Version Build Release date Features

11.2 15C114 December 2, 2017; 3 years ago 

New Features

Apple Pay Cash (US only)

Improvements

Improved wireless charging on the iPhone 8 / 8 Plus and iPhone X.

Three new Live Wallpapers have been added on the iPhone X.

Improves stabilization for videos in the Camera.

Apple Podcasts now has the ability to automatically advance to the next episode in the current podcast / show.

HealthKit now has distance while skiing or snowboarding as an activity.

Bug Fixes and Reliability Improvements

Fixes an issue where Mail would appear to be checking for new messages even after a download has successfully completed.

Fixes an issue where cleared Mail notifications from Exchange accounts had a chance to reappear.

Improved stability in the Calendar app.

Fixes an issue where the Settings app had the chance of opening to a blank / empty screen.

Fixes a potential issue that could prevent the ability to swipe to the Today View or the Camera from the Lock Screen.

Fixes a potential issue with displays on the Home Screen and Lock Screen.

Fixes an issue that could prevent users from being able to delete recent photos from iCloud when their storage limit has been exceeded.

Fixes an issue that could prevent Find my iPhone from displaying the map.

Fixes an issue with truncated and overlapping content in Messages.

Fixes an issue in Calculator where rapidly typing numbers could lead to incorrect calculation results.

Fixes an issue that could cause the keyboard to appear slowly.

Accessibility

Introduces support for Real-time text calls.

Improves the stability of VoiceOver in the following apps: Messages, Settings, App Store, and Music.

Fixes an issue with VoiceOver to announcements.

Security Notes: https://support.apple.com/en-us/HT208334

11.2.1 15C153 December 13, 2017; 3 years ago 

Bug Fixes

Fixes an issue where remote access could unexpectedly be disabled for shared users in the Home app.

Security Notes: https://support.apple.com/en-us/HT208357

11.2.2 15C202 January 8, 2018; 3 years ago 

Security Improvements

Security fix included to mitigate the effects of the Spectre vulnerability.

Security Notes: https://support.apple.com/en-us/HT208401

11.2.5 15D60 January 23, 2018; 3 years ago This update introduces support for the HomePod.

New Features

Support for the HomePod

Users can setup and automatically transfer their Apple ID, Apple Music, Siri and Wi-Fi settings to their HomePod.

Siri News (US, UK and AU regions only)

Siri now has the ability to read the news. Users can say "Hey Siri, play the news" to begin news playback. Users can also ask for news from specific categories including: Sports, Business, Music, and more.

Bug Fixes and Improvements

Fixes an issue where the Phone app had the chance of displaying incorrect information in the call list.

Fixes an issue where notifications sent to the Mail app from Exchange accounts had the chance of disappearing from the Lock Screen when using Face ID to unlock the iPhone X.

Fixes an issue where conversations in Messages could end up being temporarily listed out of order.

Fixes an issue in CarPlay where the Now Playing controls had the chance of becoming unresponsive after multiple track changes have been made.

Adds ability for VoiceOver to announce playback destinations and the battery level of AirPods.

Security Notes: https://support.apple.com/en-us/HT208463

11.2.6 15D100 February 19, 2018; 3 years ago 

Bug Fixes

Fixes an issue that could cause apps to crash when using certain character sequences.

Fixes an issue where in some instances third-party apps would fail to connect to external accessories.

Security Notes: https://support.apple.com/en-us/HT208534

#### iOS 11.3

iPad:

iPad (5th, 6th) Air (1st, 2) Mini (2, 3, 4) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5)

iPhone:

5S SE (1st) 6 6 Plus 6S 6S Plus 7 7 Plus 8 8 Plus X

iPod touch:

6th

Version Build Release date Features

11.3 15E216/15E218 March 29, 2018; 3 years ago Initial release on iPad (6th generation). Includes support for ARKit 1.5.

New Features

Augmented Reality

Introduces ARKit 1.5, granting developers the ability to place virtual objects on vertical surfaces such as walls or doors in addition to horizontal surfaces.

Adds the ability to detect and implement images such as movie posters or artwork into Augmented Reality experiences.

A higher resolution real world camera view is now supported when in an AR experience.

iPhone Battery Health (Beta)

Displays information about an iPhone's battery, such as its current maximum capacity and if the battery is still supporting peak performance capabilities.

Indicates if the iPhone Performance Management feature is turned on, while including the option to disable the feature if desired.

This feature dynamically monitors performance to try and prevent automatic and unexpected shutdowns by reducing performance if necessary.

Gives a recommendation if the battery inside of the given iPhone should be replaced.

iPad Charge Management

Maintains the health of the battery when it has been connected to power for extended periods of time, such as when the device is being stored in kiosks, Point of sale (POS) systems, or charging carts.

Animoji

Introduces four new Animoji characters: Lion, Bear, Dragon, and a Skull.

Privacy

A link to more information explaining how a user's data is used / protected appears when an Apple-provided feature asks to use their personal information.

Business Chat (Beta) – US only

Communicate with companies / businesses directly from the Messages app on iPhone / iPad.

Health Records (Beta) – US only

Access health records using the Health app.

Apple Music

The music video experience has been revamped and redesigned, with an updated music videos section featuring playlists containing exclusive videos.

Genre suggestions have been revamped, allowing users to more easily find new friends who share similar tastes in music as well as displaying mutual friends.

Apple News

Top Stories has been moved to the top of the For You tab.

New Top Videos, curated by Apple News editors.

App Store

Adds the ability to sort customer reviews on app pages by the following filters: Most Helpful, Most Favorable, Most Critical, and Most Recent.

Improves the Updates tab information for an update by now showing the update's version number as well as the update's file size.

Safari

Usernames and passwords are now only automatically AutoFilled after selecting the respective field in web forms.

Warnings are now shown when accessing unencrypted webpages.

Autofill in web views are now supported by apps for username and password information.

When articles are shared to Mail from Safari, they are now formatted with Reader Mode by default if Reader Mode is available for the given article.

Icons added for bookmarks within favorites folders.

Keyboards

Introduces two new Shuangpin keyboard layouts.

Connected hardware keyboards are now supported when using the Turkish F keyboard layout.

Improves the Japanese and Chinese keyboards on 4.7-inch and 5.5-inch devices.

Users can now switch back to the keyboard from dictation mode with one tap.

Accessibility

The App Store now supports bold and large text when customizing display appearance.

Images on webpages and Mail Messages are now supported by Smart Invert.

Improvements have been made to the RTT experience and is now supported by T-Mobile.

App Switching on iPad for VoiceOver and Switch Control users has been improved.

Bug Fixes and Improvements

Keyboards

Fixes an issue where auto-correct had the chance of incorrectly capitalizing some words.

Fixes an issue where on iPad Pro the iPad Smart Keyboard wouldn't work when connected to a Wi-Fi network using Captive Login.

Fixes an issue with the Thai keyboard when in landscape view.

Accessibility

Fixes an issue with VoiceOver giving incorrect descriptions and failing to present an End Call button or an in-app app rating.

Fixes an issue where audio playback could be distorted when using Live Listen.

Other Fixes and Improvements

Support for the AML standard has been introduced granting the ability for more accurate location data to be provided to emergency responders when the Emergency SOS feature has been triggered.

Software authentication support has been added to HomeKit, allowing developers to create new accessories supporting the platform without relying on hardware authentication.

Episodes in the Podcasts app can now be played with a single tap, and users can tap the Details button to learn more about a given podcast episode.

Improves the performance of Search for users with long notes in the Contacts app.

Improves the performance of Handoff and Universal Clipboard when both devices are located on the same Wi-Fi network.

Fixes an issue where incoming calls could prevent a device's display from waking up from sleep.

Fixes an issue where playback of voicemails in the Visual Voicemail tab in the Phone app could be prevented or delayed.

Fixes an issue where web links could be prevented from opening in the Messages app.

Fixes an issue where users could be prevented from returning to the Mail app after opening a message attachment.

Fixes an issue where Mail notifications could reappear on the Lock Screen after they have already been cleared.

Fixes an issue where time and notifications could disappear from the Lock Screen.

Fixes an issue that could prevent Ask to Buy requests from being able to be authorized with Face ID.

Fixes an issue in the Weather app where the current weather conditions may not have been updated.

Fixes an issue with syncing with a vehicle's phonebook when connected over Bluetooth.

Fixes an issue where audio apps could be prevented from playing in vehicles if the app was running in the background.

Security Notes: https://support.apple.com/en-us/HT208693

11.3.1 15E302 April 24, 2018; 3 years ago 

Bug Fixes

Fixes an issue where on some iPhone 8 devices touch input could be unresponsive due to the displays being serviced with non-genuine replacement displays.

Security Notes: https://support.apple.com/en-us/HT208743

#### iOS 11.4

iPad:

iPad (5th, 6th) Air (1st, 2) Mini (2, 3, 4) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5)

iPhone:

5S SE (1st) 6 6 Plus 6S 6S Plus 7 7 Plus 8 8 Plus X

iPod touch:

6th

Version Build Release date Features

11.4 15F79 May 29, 2018; 3 years ago Introduces support for AirPlay 2.

New Features

AirPlay 2

AirPlay 2 allows the user to control their home audio system.

Allows users to broadcast music via multiple AirPlay 2-enabled speakers.

Users can control AirPlay 2-enabled speakers via Control Center, the Lock Screen, or via AirPlay controls within apps on their iPhone, iPad or iPod Touch.

Voice control of AirPlay 2-enabled speakers using Siri from their iPhone, iPad, iPod Touch, HomePod, or Apple TV.

Users can take calls or play games on their iPhone or iPad without having to interrupt playback on their AirPlay 2-enabled speakers.

HomePod Stereo Pairing

When pairing, the HomePod balances the sound based on the location of the speakers.

HomePod provides Advanced Beamforming, a technology that provides a wider sound stage than a traditional stereo pair.

HomePod automatically updates, unless updates are disabled in the Home app.

Messages in iCloud

Stores a user's content in iCloud and free ups space on their device(s).

All of the user's messages appear when they sign into a different device.

Deleted content is removed from all of the user's devices.

Messages in iCloud can be enabled by going to Settings > Apple ID > iCloud and turning on Messages under the "Apps Using iCloud" section.

Bug Fixes and Improvements

Adds the ability for teachers to assign reading activities to their students in iBooks with the Schoolwork app.

Fixes an issue where the Messages app could crash when certain character sequences are encountered.

Fixes an issue where some messages could appear out of order in the Messages app.

Fixes an issue with logging in or accessing files in Safari on certain sites such as Gmail and Google Drive.

Fixes an issue that could prevent Health data from syncing.

Fixes an issue that could prevent users from being able to change what apps have the ability to access Health data.

Fixes an issue where audio playback had the chance of being distorted in CarPlay.

Fixes an issue with the Bluetooth connection on some vehicles.

Security Notes: https://support.apple.com/en-us/HT208848

11.4.1 15G77 July 9, 2018; 3 years ago 

Bug Fixes

Fixes an issue where some users could be prevented from viewing the last known location of their AirPods in the Find My iPhone app.

Improves reliability when syncing data sources such as Mail and Contacts with Exchange accounts.

Security Notes: https://support.apple.com/en-us/HT208938

### iOS 12

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 12 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/12/IOS_12_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/12/IOS_12_logo.svg)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/12/IOS_12_Homescreen_iPhone_X.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/12/IOS_12_Homescreen_iPhone_X.png)

Apple announced [iOS 12](https://github.com/seanpm2001/WacOS/wiki/iOS-12/) on June 4, [2018](https://github.com/seanpm2001/WacOS/wiki/2018/), at its annual Apple Worldwide Developers Conference (WWDC) event, and it was released to the public on September 17, [2018](https://github.com/seanpm2001/WacOS/wiki/2018/), alongside the iPhone XS, iPhone XS Max and iPhone XR. With this release, Apple did not drop support for any [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) devices. Therefore, [iOS 12](https://github.com/seanpm2001/WacOS/wiki/iOS-12/) was supported on the iPhone 5S onwards, iPod Touch (6th generation), the iPad Air onwards, and the iPad Mini 2 onwards. However, [iOS 12](https://github.com/seanpm2001/WacOS/wiki/iOS-12/) has limited support on devices with the Apple A7 or A8 processors: the iPhone 5S, iPhone 6/6 Plus, iPod Touch (6th generation), iPad Air, iPad Air 2, iPad Mini 2, 3, and 4. All other devices from the iPhone 6S/6S Plus onwards, the iPad Air (2019), the iPad (5th generation) onwards, and all iPad Pro models are fully supported. iOS 12.1 brought support to the iPad Pro (12.9-inch, 3rd generation) and iPad Pro (11-inch, 1st generation) and iOS 12.2 brought support to the iPad Mini (5th generation) and iPad Air (3rd generation). iOS 12.5.5 is the final supported release for the iPhone 5S, iPhone 6, iPhone 6 Plus, iPad Air (1st generation), iPad mini 2, iPad mini 3, and iPod touch (6th generation).

#### iOS 12.0

iPad:

iPad (5th, 6th) Air (1st, 2) Mini (2, 3, 4) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5)

iPhone:

5S 6 6 Plus 6S 6S Plus SE (1st) 7 7 Plus 8 8 Plus X XR XS XS Max

iPod touch:

6th

Limited support on devices that have less than 2 GB of RAM (the iPhone 5S, iPhone 6/6 Plus, iPod Touch (6th generation), iPad Mini 2, iPad Mini 3, and iPad Air)

Version Build Release date Features

12.0 16A366 September 17, 2018; 3 years ago

September 21, 2018; 3 years ago on iPhone XS and iPhone XS Max

October 26, 2018; 2 years ago on iPhone XR

Initial release on iPhone XS, iPhone XS Max and iPhone XR

View a more complete list of features here.

Apple Books (formerly iBooks)

iBooks has been renamed to Apple Books. A continuation of Apple's phasing out of the "i" prefix for its services. Rebranding also includes a redesign, featuring a new introduction, a Reading Now screen that's like Apple Music and the App Store in being more editorialized, and new cards for individual books.

Apple Books settings preferences have been updated. More options and a change of layout when looking at Books under the Settings app.

Compass

Leveler has been removed and the function moved to the Measure app as one of its features, still working the same way as previous versions.

Measure

The new app built using ARKit 2.0, which allows users to measure the dimensions of real-world objects viewed through the iOS device's camera.

Measure app only works with A9 devices and later.

News

Redesigned to have three tabs at the bottom of the iPhone version including Spotlight section. A new tab was added, named Channels, which provides a browsable list of followed topics and outlets.

Stocks

Redesigned for easier-to-view stocks on a new welcome screen, as well as interactive charts. One of a number of first-party iOS apps that have also been ported to macOS Mojave, using new tools still under development.

Apple News integration, this allows you to see news in a panel at the bottom of the app. Expanding the news panel shows stocks in a ticker at the top of the app.

Now available on iPad.

Voice Memos

Redesigned; immediately shows a clear list of existing recordings when opening the app, with new recordings produced in a compact pop-up panel at the bottom of the app, complete with repositioned waveform graphic.

Now available on iPad.

Weather

Air quality settings preferences to track air quality. Scrolling to the bottom of the day's weather shows a general "Air Quality" category ("Good" etc.) for the location.

Weather app now tracks the air quality index. As with the general air quality feature, the "Air Quality Index" figure for the detected location is provided at the bottom of the day's weather report.

Phone

Field test mode now supports landscape view.

Settings

Redesigned app notifications

New wallpaper; removed older wallpapers

Screen Time added

Automatic updates toggle added in Software Update tab

Bedtime Feature in Do Not Disturb

Stocks section added

New Measure section

New app limits page

New Battery Statistics Chart

More battery information: Battery Health out of Beta for more accurate battery capacity readings

Improved Safari privacy

12.0.1 16A404/16A405 October 8, 2018; 2 years ago 

Fixes Lightning charging issue with iPhone XS

Fixes iPhone XS rejoining Wi-Fi networks at 2.4 GHz rather than 5 GHz

Puts the ".?123" key back to its original position on the iPad keyboard

Fixes subtitles not appearing in some video apps

Fixes issue where Bluetooth becomes unavailable

Security Notes

https://support.apple.com/HT209162

#### iOS 12.1

iPad:

iPad (5th, 6th) Air (1st, 2) Mini (2, 3, 4) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9)

iPhone:

5S 6/6 Plus 6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max

iPod touch:

6th

Limited support on devices that have less than 2 GB of RAM the iPhone 5S, iPhone 6/6 Plus, iPod Touch (6th generation), iPad Mini 2, iPad Mini 3, and iPad Air

Version Build Release date Features

12.1 16B92/16B93

16B94 PXR October 30, 2018; 2 years ago

November 7, 2018; 2 years ago on iPad Pro (3rd generation (12.9-inch)) and iPad Pro (11-inch)

Initial release on iPad Pro (3rd generation, 12.9-inch) and iPad Pro (11-inch)

Group FaceTime

Adds support for video and audio calls with up to 32 participants simultaneously

Encrypted end-to-end so your conversations remain private

Start Group FaceTime directly from a group Messages conversation or join an active call at any time

Emoji

Over 70 new emoji, including new characters with red hair, grey hair and curly hair, new emoji for bald people, more emotive smiley faces and additional emojis representing animals, sport and food

Dual SIM support

Introduces Dual SIM with eSIM, which allows two numbers in one device for iPhone XS, iPhone XS Max and iPhone XR

Other improvements and fixes

Introduces Depth Control in Camera preview for iPhone XS, iPhone XS Max and iPhone XR

Improves mobile connectivity for iPhone XS, iPhone XS Max and iPhone XR

Adds the ability to change or reset your child's Screen Time passcode using Face ID or Touch ID

Fixes an issue where the sharpest reference frame was not always selected in front-facing photos for iPhone XS, iPhone XS Max and iPhone XR

Fixes an issue that caused messages to be merged into one thread when two users were signed in with the same Apple ID on multiple iPhones

Fixes an issue that prevented some voicemails from appearing in the Phone app

Fixes an issue in the Phone app that could cause phone numbers to appear without their corresponding contact name

Fixes an issue that could prevent Screen Time from reporting specific websites in the activity report

Fixes an issue that could prevent adding or removing family members from Family Sharing

Improves reliability of VoiceOver in Camera, Siri and Safari

Fixes an issue that could cause MDM Device Enrolment to report an Invalid Profile error for some enterprise users

Security

https://support.apple.com/en-us/HT209192

12.1.1 16C50 December 5, 2018; 2 years ago Features and improvements

Notification preview using haptic touch on iPhone XR

Dual SIM with eSIM for additional service providers on iPhone XR, iPhone XS and iPhone XS Max

One-tap to flip between the rear and front-facing camera during a FaceTime call

Live Photo capture during one-to-one FaceTime calls

The option to hide the sidebar in News on iPad in landscape orientation

National Relay Service (NRS) when using Wi-Fi calling on iPad and iPod touch

Stability improvements for dictation and VoiceOver

Bug fixes

Fixes an issue where Face ID may temporarily become unavailable

Fixes an issue that prevented visual voicemail from downloading for some customers

Fixes an issue in Messages that could prevent predictive text suggestions when typing on the Chinese or Japanese keyboards

Fixes an issue that could prevent Voice Memos recordings from uploading to iCloud

Fixes an issue where time zones may not have updated automatically

HomePod compatibility

Support in Mainland China and Hong Kong

HomePod LEDs illuminate during Group FaceTime calls

Security

https://support.apple.com/en-us/HT209340

12.1.2 16C104 December 20, 2018; 2 years ago iPhone only

Bug fixes

Fixes bugs with eSIM activation for iPhone XR, iPhone XS, and iPhone XS Max

Fixes an issue that could affect cellular connectivity in Turkey for iPhone XR, iPhone XS, and iPhone XS Max

12.1.3 16D39/16D40 January 22, 2019; 2 years ago Bug fixes

Fixes an issue in Messages that could impact scrolling through photos in the Details view

Fixes an issue where photos could have striped artifacts after being sent from the Share Sheet

Fixes an issue that may cause audio distortion when using external audio input devices on iPad Pro (2018)

Fixes an issue that could cause certain CarPlay systems to disconnect from iPhone XR, iPhone XS, and iPhone XS Max

HomePod bug fixes

Fixes an issue that could cause HomePod to restart

Fixes an issue that could cause Siri to stop listening

12.1.4 16D57 February 7, 2019; 2 years ago Security

https://support.apple.com/en-us/HT209520

#### iOS 12.2

iPad:

iPad (5th, 6th) Air (1st, 2, 3rd) Mini (2, 3, 4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9)

iPhone:

5S 6/6 Plus 6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max

iPod touch:

6th

Limited support on devices that have less than 2 GB of RAM (the iPhone 5S, iPhone 6/6 Plus, iPod Touch (6th generation), iPad Mini 2, iPad Mini 3, and iPad Air)

Version Build Release date Features

12.2 16E227 March 25, 2019; 2 years ago Initial release on iPad Mini (5th generation) and iPad Air (3rd generation)

Apple News+ released and Apple News in Canada

New Animoji

Air Quality information in US, UK, India and can turn off weather information in Apple Maps

New Screen Time scheduling options

Wallet layout changes, Apple Pay Cash can transfer to a bank account

Third party support for AirPlay 2

Apple TV remote layout redesigned

AT&T 5G E icon added

Warranty information available in Settings

Safari

Enables TLS 1.3 support

Stronger messages for non-secure sites

Do Not Track removed, motion data privacy option

Password autofill submits the form automatically

Siri

Hey Siri support on AirPods

Play videos on Apple TV

Inline music playback

Security

https://support.apple.com/en-us/HT201222

#### iOS 12.3

iPad:

iPad (5th, 6th) Air (1st, 2, 3rd) Mini (2, 3, 4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9)

iPhone:

5S 6/6 Plus 6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max

iPod touch:

6th 7th

Limited support on devices that have less than 2 GB of RAM (the iPhone 5S, iPhone 6/6 Plus, iPod Touch (6th generation), iPad Mini 2, iPad Mini 3, and iPad Air)

Version Build Release date Features

12.3 16F156 May 13, 2019; 2 years ago 

Redesigned Apple TV App

AirPlay 2 support for Smart TVs

iOS now disables Bluetooth accessories with insecure connections.

Now you can follow a magazine with Apple News+ catalog view

Updates throughout the day for Apple Music's For You tab

Other bug fixes and stability improvements

12.3.1 16F203/16F8202 May 24, 2019; 2 years ago

May 28, 2019; 2 years ago on iPod Touch (7th generation)

Initial release on iPod Touch (7th generation)

Fixes an issue that could prevent making or receiving VoLTE calls

Fixes issues in Messages that could cause messages from unknown senders to appear in your conversation list even though Filter Unknown Senders is enabled

Fixes an issue that could prevent the Report Junk link from appearing in Messages threads from unknown senders

12.3.2 16F250 June 10, 2019; 2 years ago iPhone 8 Plus only

Fixes an issue with taking pictures in portrait mode

#### iOS 12.4

iPad:

iPad (5th, 6th) Air (1st, 2, 3rd) Mini (2, 3, 4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9)

iPhone:

5S 6/6 Plus 6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max

iPod touch:

6th 7th

Limited support on devices that have less than 2 GB of RAM (the iPhone 5S, iPhone 6/6 Plus, iPod Touch (6th generation), iPad Mini 2, iPad Mini 3, and iPad Air)

Version Build Release date Features

12.4 16G77 July 22, 2019; 2 years ago 

Support for wirelessly transferring data between iPhones during initial setup

Important security fix for Apple Watch Walkie-Talkie app concerning eavesdropping

HomePod support in Japan and Taiwan

Other bug fixes and improvements

12.4.1 16G102 August 26, 2019; 2 years ago 

Security update: patches a vulnerability that was accidentally unpatched in the previous update, allowing jailbreaks and hacking attempts to take place.

Post-iOS 13 security updates (iPhone 5S, iPhone 6/6 Plus, iPad Air, iPad Mini 2, iPad Mini 3, and iPod Touch (6th generation) only)

12.4.2 16G114 September 26, 2019; 2 years ago 

Security update: patches a vulnerability that permitted an attacker to access a user's phone and terminate running applications and potentially execute an arbitrary code execution attack.

12.4.3 16G130 October 28, 2019; 23 months ago 

Security update: Corrected an issue where AirDrop file transfers could be unexpectedly accepted while the user has permitted AirDrop file transfer requests from everyone.

12.4.4 16G140 December 10, 2019; 21 months ago 

Security update: patches a vulnerability that permitted an attacker to access a user's phone and execute an arbitrary code with a malicious FaceTime video.

12.4.5 16G161 January 28, 2020; 20 months ago 

Security update; no published CVE entries

12.4.6 16G183 March 24, 2020; 18 months ago 

Security update; no published CVE entries

12.4.7 16G192 May 20, 2020; 16 months ago 

Security Update: 

Corrected an issue where a maliciously crafted email could unexpectedly lead to heap corruption

Corrected an issue where a maliciously crafted email could unexpectedly modify memory or terminate applications

Corrected a vulnerability where a remote attacker could unexpectedly corrupt kernel memory or cause system termination.

12.4.8 16G201 July 15, 2020; 14 months ago 

Security update; no published CVE entries

12.4.9 16H5 November 5, 2020; 10 months ago 

Security update

#### iOS 12.5

iPad:

Air (1st) Mini (2, 3)

iPhone:

5S 6/6 Plus

iPod touch:

6th

Version Build Release date Features

12.5 16H20 December 14, 2020; 9 months ago 

Support for COVID-19 Exposure Notifications

Security fixes

12.5.1 16H22 January 11, 2021; 8 months ago 

Fixes an issue where Exposure Notifications could incorrectly display logging profile language.

12.5.2 16H30 March 26, 2021; 6 months ago 

Security fixes

12.5.3 16H41 May 3, 2021; 4 months ago 

Security fixes

12.5.4 16H50 June 14, 2021; 3 months ago 

Security fixes

12.5.5 16H62 September 23, 2021; 5 days ago 

Latest release supported on iPhone 5S, iPhone 6/6 Plus, iPad Air, iPad Mini 2, iPad Mini 3, and iPod Touch (6th generation)

Security fixes addressing actively exploited vulnerabilities in the CoreGraphics (PDF), WebKit (web content) und XNU (kernel) leading to arbitrary code execution.

### iOS 13 / iPadOS 13

<!-- <details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 13 logo</p></summary> !-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/13/IOS_13_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/13/IOS_13_logo.svg)

<!-- </details> !-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/13/IOS_13_Homescreen_iPhone_X.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/13/IOS_13_Homescreen_iPhone_X.png)

Apple announced [iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/) on June 3, [2019](https://github.com/seanpm2001/WacOS/wiki/2019/), at its annual Apple Worldwide Developers Conference (WWDC) event, and it was released to the public on September 19, [2019](https://github.com/seanpm2001/WacOS/wiki/2019/) alongside the iPhone 11 series (11, 11 Pro, 11 Pro Max). The principal features include dark mode and Memoji support for A9+ devices. The NFC framework now supports reading several types of contactless smartcards and tags. The iPad gains several tablet-oriented features, and its operating system has been rebranded as [iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/); [iPadOS 13](https://github.com/seanpm2001/WacOS/wiki/iPadOS-13/) was announced at the 2019 WWDC as well. With this release, Apple dropped support for all devices with less than 2 GB of RAM, which included the iPhone 5S and iPhone 6 and 6 Plus, iPod Touch (6th generation), iPad Mini 2, iPad Mini 3, and iPad Air. [iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/)/[iPadOS 13](https://github.com/seanpm2001/WacOS/wiki/iPadOS-13/) has limited support on devices with the A8/A8X. However, all other devices from the iPhone 6s/6s Plus onwards, iPod Touch (7th generation), iPad Pro (1st generation), iPad (5th generation), and iPad Mini (5th generation) onwards are fully supported (A9 and A10 devices having almost full support, A11 and on having full support). [iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/) brought support for the iPhone 11 and iPhone 11 Pro / Pro Max, second-generation iPhone SE, and [iPadOS 13](https://github.com/seanpm2001/WacOS/wiki/iPadOS-13/) brought support for the iPad (7th generation), the iPad Pro (12.9-inch, 4th generation) and the iPad Pro (11-inch, 2nd generation).

#### iOS 13.0

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max

Only available on iPhone.

Version Build Release date Features

13.0 17A577 September 19, 2019; 2 years ago 

Initial release on iPhone 11 and iPhone 11 Pro / iPhone 11 Pro Max

The OS on the iPad 2017, 2018, Air 2, Air 3, Mini 4, Mini 5, and Pro line has been renamed to iPadOS. It is similar to iOS 13, but has some features exclusively for iPad.

Dark Mode

When enabled, the UI, native apps, and supported third-party apps undergo a basic light-on-dark color scheme, and the iOS 13 wallpapers have a darker color scheme. The user can also set a schedule for what time Dark Mode comes on, and what time Light Mode comes back on.

Siri

Siri's voice is now done by software called "Neural TTS" instead of human voice clips, making Siri sound much more natural.

Siri can now play audio, including music, podcasts, audio books, and radio, with third-party apps.

There is now an option for an Indian-English voice.

Siri now offers personalized suggestions in Apple Podcasts, Safari, and Maps. Siri can also now detect reminders in messages and events in third-party apps.

Siri can now tune into radio shows on command.

Keyboard

The QuickType keyboard now includes QuickPath, which allows the user to type in a word by sliding a finger between the letters without moving it up. QuickPath supports English, Simplified Chinese, Spanish, German, French, Italian, and Portuguese.

Swiping or tapping to type works interchangeably, even mid-sentence.

Alternate word options now appear in the predictive bar.

Dictation will automatically detect what language a user is speaking. This language will be chosen from up to four keyboard languages enabled on the device.

Camera

After taking a picture in Portrait Mode, the user can adjust the position and intensity of each Portrait lighting effect.

A new Portrait Lighting effect, called High-Key Mono, "creates a beautiful, classic look with a monochromatic subject on a white background."

Portrait Segmentation API now has skin, hair, and teeth segmentation.

All-new Camera app on the iPhone 11 series

App Store

Apple Arcade: A new subscription service with over 100 new games, with no ads or additional purchases.

The Updates tab found in iOS 12 and earlier has been removed and merged into the Account bottom sheet.

The App Store now has support for Arabic and Hebrew in stories, collections and lists, product pages, and searches.

Apps with large sizes (especially games) can now be downloaded over a cellular connection, but the user will be warned if the file size exceeds a certain threshold.

Maps

The map itself has been redone from the ground up. According to Apple, it features "significantly improved and more realistic details" for areas like roads, beaches, parks, buildings, and more.

The user can now explore the area they are going to before they arrive with a 3D, 360-degree experience.

Collections of favorite locations can be built and shared with others.

The user can now make a list of places they visit often to access them quickly.

A feature called Junction View helps drivers in China eliminate wrong turns and directional misses by lining them up in the correct lane before they need to turn or enter an elevated road.

The process of submitting customer feedback has been redesigned to be faster.

Siri's navigation uses more natural language. For example, instead of saying "in x feet turn left," it says "turn left at the next traffic light". Navigation is also more accurate.

The user can now see departure times live, the location of their bus or train on its route, and a more detailed schedule of transit stops.

Flight details now include info about a terminal, gate locations, departure times, and more.

Place cards have more improved info, such as Today @ Apple sessions at Apple Store locations, and movie theater time listings.

MapKit now has vector overlays, point-of-interest filtering, camera zoom and pan limits, and Dark Mode support.

CarPlay now has easier route planning, search, and navigation. It also includes Junction View (China only), Favorites, and Collections.

Apple Music

Introduces support for lyrics synchronized to the song a user is currently listening to. Not all songs support this feature.

Redesigns the Now Playing bottom sheet, moving the Up Next queue to a dedicated action, while moving the Shuffle and Repeat actions to the Up Next view.

Adds over 100,000 live radio stations to the service.

Performance

Apps can now launch up to twice as fast as on iOS 12.

Unlocking the iPhone X, XS, XS Max, and XR using Face ID is up to 30% faster compared to iOS 12.

Apps from the App Store are packaged in a new way, making them as small as half the size compared to iOS 12, which makes them download faster and take up less storage.

App updates are on average 60% smaller compared to iOS 12, allowing for faster downloads.

Other Changes

Introduces support for pinch to zoom in the Voice Memos app when editing voice recordings.

Adds support for the DualShock 4 and Xbox One wireless controllers.

#### iOS / iPadOS 13.1

iPad:

iPad (5th, 6th, 7th) Air (2, 3rd) Mini (4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max

iPod touch:

7th

Limited support on iPad Air 2 and iPad Mini 4

Version Build Release date Features

13.1 17A844 September 24, 2019; 2 years ago 

Initial release on iPad (7th generation)

New Features and Improvements

AirDrop

Shortcuts

Maps

Battery Health

Bug Fixes

13.1.1 17A854 September 27, 2019; 2 years ago 

Bug Fixes

13.1.2 17A860/17A861 September 30, 2019; 23 months ago 

Bug Fixes

13.1.3 17A878 October 15, 2019; 23 months ago Bug Fixes

#### iOS / iPadOS 13.2

iPad:

iPad (5th, 6th, 7th) Air (2, 3rd) Mini (4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max

iPod touch:

7th

Limited support on iPad Air 2 and iPad Mini 4

Version Build Release date Features

13.2 17B84 October 28, 2019; 23 months ago 

Camera

Better representation of colors and lighting

Ability to adjust video resolution and framerate within the Camera app P11 P11P P11PM

Deep Fusion on the iPhone 11 series

Volume HUD and Control Center

The volume indicator disappears from view quicker

When connected to an audio device, an icon of the device will appear within the volume indicator

3D Touch/Haptic Touch

New sound when invoking 3D Touch/Haptic Touch, reminiscent of sounds made when typing on the keyboard

Icons on the Home screen can be deleted directly from the 3D Touch/Haptic Touch menu

Multitasking line is smaller if there are 3 apps or less

Emoji

59 new emoji

Some emoji, specifically couples, use a new emoji picker to select different skin tones or genders

Reintroduced "Announce Messages with Siri"

Bug Fixes

Delete Event is now available again for Calendar invites originating from emails

Provides support for new HomePod features [Update Pulled for HomePod]

The ability for HomePod to recognize the voices of different family members to provide a personalized experience

Handoff music, podcasts or phone calls by bringing the iPhone close to HomePod

Add music to HomeKit scenes

Play relaxing high-quality soundtracks with Ambient Sounds

Set sleep timers to fall asleep to music or Ambient Sounds

13.2.1 17B90 October 30, 2019; 22 months ago HomePod-only update

Fixes an issue caused by iOS 13.2 that bricked HomePod devices when installed or after a reset.

13.2.2 17B102 November 7, 2019; 22 months ago Bug fixes and improvements.

13.2.3 17B111 November 18, 2019; 22 months ago Bug fixes and improvements.

#### iOS / iPadOS 13.3

iPad:

iPad (5th, 6th, 7th) Air (2, 3rd) Mini (4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max

iPod touch:

7th

Limited support on iPad Air 2 and iPad Mini 4

Version Build Release date Features

13.3 17C54 December 10, 2019; 21 months ago

Screen Time

Communication Limits: In the Screen Time app, time limits can now be set for phone calls, messages, and FaceTime calls. Individual limits can be set for each contact.

Apple News

There is a new layout for Apple News+ stories from some "leading newspapers" such as the Wall Street Journal.

There is now a quick option to like or dislike a story from the main page.

Stocks

Stories from Apple News have been made available in Canada in English and French.

There is a new "continue reading" option with links to more stories that are related or from the same publisher.

New "Breaking" and "Developing" labels for Top Stories

Safari

Bug Fixes & Other Improvements

Security Notes: https://support.apple.com/en-us/HT210785

13.3.1 17D50 January 28, 2020; 20 months ago Bug fixes and improvements.

#### iOS / iPadOS 13.4

iPad:

iPad (5th, 6th, 7th) Air (2, 3rd) Mini (4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9; 4th, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max SE (2nd)

iPod touch:

7th

Limited support on iPad Air 2 and iPad Mini 4

Version Build Release date Features

13.4 17E255

17E8255PSE2G March 24, 2020; 18 months ago

April 24, 2020; 17 months agoPSE2G Initial release on iPad Pro (4th generation, 12.9-inch, 2nd generation, 11-inch) and iPhone SE (2nd generation)

Memoji

Files

Mail

App Store with Apple Arcade

CarPlay

Augmented Reality

Keyboard

Bug Fixes and Improvements

Security Notes: https://support.apple.com/en-us/HT201222

13.4.1 17E262

17E8258PSE2G April 7, 2020; 17 months ago

April 23, 2020; 17 months agoPSE2G Bug fixes, including an issue that prevented FaceTime calls with devices running iOS 9.3.6 or OS X El Capitan 10.11.6 or older

#### iOS / iPadOS 13.5

iPad:

iPad (5th, 6th, 7th) Air (2, 3rd) Mini (4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9; 4th, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max SE (2nd)

iPod touch:

7th

Limited support on iPad Air 2 and iPad Mini 4

Version Build Release date Features

13.5 17F75 May 20, 2020; 16 months ago 

Face ID and Passcode

Exposure Notification API

FaceTime

Emergency Services

Bug Fixes and Other Improvements

Security Notes: https://support.apple.com/en-us/HT211168

13.5.1 17F80 June 1, 2020; 15 months ago Security Update

Patches CVE-2020-9859, a memory consumption vulnerability that can be used by an application to perform arbitrary code execution with kernel privileges. This vulnerability was used by the unc0ver jailbreak.

#### iOS / iPadOS 13.6

iPad:

iPad (5th, 6th, 7th) Air (2, 3rd) Mini (4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9; 4th, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max SE (2nd)

iPod touch:

7th

Limited support on iPad Air 2 and iPad Mini 4

Version Build Release date Features

13.6 17G68 July 15, 2020; 14 months ago 

CarKey

Allows users to unlock, lock, and start compatible cars with an iPhone.

Uses NFC to communicate with compatible vehicles.

Can be found in the Wallet app.

Features

iCloud integration: Allows the removal of digital keys from devices that have been lost.

iMessage: Share digital keys with contacts using iMessage, potentially with restrictions.

Power Reserve: Allows users to unlock / start their car up to five hours after their iPhone has run out of battery.

Health

New 'Symptoms' section in the Health app.

News

Apple News+ Audio: Allows the user to listen to news stories as opposed to reading them, if subscribed to Apple News+.

Bug Fixes & Other Improvements

Settings Improvements

Automatic Updates

Renamed to "Customize Automatic Updates" from "Automatic Updates".

The "Automatic Updates" toggle was renamed to "Download iOS Updates".

If this toggle is enabled, an additional toggle labelled "Install iOS Updates" becomes visible, allowing users to automatically install new updates.

COVID-19 Exposure Logging

Enabled in more regions and states.

If not available in a given user's region, a notice letting the user know that the feature is "not currently available in their region" as well as a description of what the feature does is now visible.

Bug Fixes

Fixes an issue that could cause apps to become unresponsive while syncing from iCloud Drive.

Fixes an issue that could cause calls originating from Saskatchewan to appear as originating from the United States.

Release Notes: https://support.apple.com/en-us/HT210393#136

Security Notes: https://support.apple.com/en-us/HT211288

13.6.1 17G80 August 12, 2020; 13 months ago 

Bug Fixes & Other Improvements

Addresses an issue where unneeded system data files might not be automatically deleted when available storage is low

Fixes a thermal management issue that caused some displays to exhibit a green tint

Fixes an issue where Exposure Notifications could be disabled for some users

#### iOS / iPadOS 13.7

iPad:

iPad (5th, 6th, 7th) Air (2, 3rd) Mini (4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9; 4th, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max SE (2nd)

iPod touch:

7th

Limited support on iPad Air 2 and iPad Mini 4

Version Build Release date Features

13.7 17H35 September 1, 2020; 12 months ago 

Support Exposure Notifications Express.[173]

Allows to opt-in to COVID-19 exposure notifications without the need to download an app

Depends on local health authority

An app is still required to report positivity to COVID-19

### iOS 14 / iPadOS 14

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 14 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/14/IOS_14_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/14/IOS_14_logo.svg)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/14/IPhone_12_iOS_14_Homescreen.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/14/IPhone_12_iOS_14_Homescreen.png)

Apple announced [iOS 14](https://github.com/seanpm2001/WacOS/wiki/iOS-14/) and [iPadOS 14](https://github.com/seanpm2001/WacOS/wiki/iPadOS-14/) on June 22, [2020](https://github.com/seanpm2001/WacOS/wiki/2020/) at its annual WWDC [2020](https://github.com/seanpm2001/WacOS/wiki/2020/) event, with a developer beta released on the same day and a public beta released on July 9, [2020](https://github.com/seanpm2001/WacOS/wiki/2020/). [iOS 14](https://github.com/seanpm2001/WacOS/wiki/iOS-14/) and [iPadOS 14](https://github.com/seanpm2001/WacOS/wiki/iPadOS-14/) were released on September 16, [2020](https://github.com/seanpm2001/WacOS/wiki/2020/), alongside the iPad (8th Generation) and iPad Air (4th Generation). All devices that supported [iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/) also support [iOS 14](https://github.com/seanpm2001/WacOS/wiki/iOS-14/). This makes the iPad Air 2 the first device to support seven versions of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) and [iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/), from [iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/) to [iPadOS 14](https://github.com/seanpm2001/WacOS/wiki/iPadOS-14/). Some new features introduced in [iOS 14](https://github.com/seanpm2001/WacOS/wiki/iOS-14/) and [iPadOS 14](https://github.com/seanpm2001/WacOS/wiki/iPadOS-14/) include redesigned widgets that can now be placed directly on the homescreen (only for [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/)), along with the App Library, which automatically categorizes apps into one page, Picture in Picture in iPhone and iPod touch, and the CarKey technology to unlock and start a car with NFC. [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) and [iPadOS 14](https://github.com/seanpm2001/WacOS/wiki/iPadOS-14/) also allow the user to have incoming calls shown in banners rather than taking up the whole screen (the latter view is still available as an optional function).

The release of [iPadOS 14.0](https://github.com/seanpm2001/WacOS/wiki/iPadOS-14/) brought support for the 8th generation iPad and the 4th generation iPad Air and the release of iOS 14.1 brought support for the iPhone 12, the iPhone 12 Mini and the iPhone 12 Pro and Pro Max. [iOS 14](https://github.com/seanpm2001/WacOS/wiki/iOS-14/) and [iPadOS 14](https://github.com/seanpm2001/WacOS/wiki/iPadOS-14/) have limited support on devices with A8, A8X, A9, A9X, and A10 Fusion chips, whereas devices with A10X Fusion and A11 Bionic chip have almost full support, and devices with A12 Bionic chip and later have full support.

#### iOS / iPadOS 14.0

iPad:

iPad (5th, 6th, 7th, 8th) Air (2, 3rd, 4th) Mini (4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9; 4th, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max SE (2nd)

iPod touch:

7th

Limited support on iPhone 6S, iPhone 7, iPhone SE (1st generation), iPod Touch (7th generation), iPad (5th generation), iPad (6th generation), iPad (7th generation), iPad Air 2, iPad Mini 4 and iPad Pro (1st generation)

Version Build Release date Features

14.0 18A373 September 16, 2020; 12 months ago 

Main articles: iOS 14 and iPadOS 14

Initial release on iPad (8th generation) and iPad Air (4th generation)

All-new widgets

Redesigned widgets can be placed right on the Home Screen

Small, medium and large widget sizes allow you to pick the amount of information to display

Widget stacks make the most of your Home Screen space and the Smart Stack uses on-device intelligence to surface the right widget at the right time

Widget gallery includes all available widgets to browse and choose from

Redesigned Apple widgets for Weather, Clock, Calendar, News, Maps, Fitness, Photos, Reminders, Stocks, Music, TV, Tips, Notes, Shortcuts, Battery, Screen Time, Files, Podcasts, and Siri Suggestions

App Library

The App Library automatically organizes all of your apps into categories

The Suggestions category uses on-device intelligence to show apps you're likely to be looking for based on factors like time of day or location

The Recently Added category shows apps that were recently downloaded from the App Store, as well as App Clips that were recently launched

Ability to hide Home Screen pages to get to the App Library even faster by tapping on the dots at the bottom of the screen while in jiggle mode

Compact design

Incoming Phone and FaceTime calls appear as a banner at the top of the screen

Siri has a compact design that allows you to refer to information onscreen and seamlessly launch into your next task

Picture in Picture enables watching a video or making a FaceTime call while you use another app

Messages

Pinned conversations keep up to nine of your favorite message threads at the top of the list

Mentions let you direct a message to an individual in a group conversation

Inline replies let you reply to a specific message and see all related messages in their own view

Group photos can be customized for a shared group look

Memoji

11 new hairstyles and 19 new headwear styles to customize your Memoji

New Memoji stickers to send a fist bump, hug or blush

Six added age options

Face covering options

Maps

Cycling directions provide routes along bike lanes, bike paths, and bike-friendly roads, taking into consideration elevation or how busy a street is

Guides offer recommendations for places to eat, meet friends, or explore, curated by a selection of trusted brands

Electric vehicle routing helps you plan trips with supported electric vehicles and automatically adds charging stops along your route

Congestion zones help you route around or through active zones in cities like London or Paris

Speed cameras let you know when you're approaching speed and red-light cameras along your route

Refine Location enables a highly accurate location and orientation when in urban areas with a poor GPS signal

App Clips

An App Clip is a small part of an app that developers can create and that is discoverable at the moment you need it, and focused on a specific task

Small by design, App Clips are usable in a few seconds

Discover App Clips through tapping NFC tags or scanning QR codes, from Messages, Maps, and Safari

Recently used App Clips show up in App Library's Recently Added category, and you can download the full version of the app if you want to keep it around

Translate

The new Translate app is designed for conversations and can work completely offline so your conversations stay private

A split-screen design in conversation mode has a single microphone button that automatically detects which of the selected languages is being spoken and transcribes the original and translated text on the correct sides of the screen

Attention mode shows translations in larger text so you can capture someone's attention

Voice and text translations are supported for any combination of 11 languages

Siri

A new compact design allows you to refer to information onscreen and seamlessly launch into your next task

Expanded knowledge brings 20x more facts than three years ago

Web answers help find answers to a broader set of questions using information from across the Internet

Audio messages can be sent with Siri on iOS and CarPlay

Expanded language support for the new Siri voice and Siri translation

Search

One place where you can find everything: search for apps, contacts, files, quick information like weather and stocks, common knowledge questions about people or places, or even quickly start a web search

Top Hit results show the most relevant information including apps, contacts, knowledge, points of interest and websites

Quick Launcher allows you to launch an app or website by typing a few characters

As-you-type search suggestions show more relevant results as soon as you start typing

Web search suggestions to launch Safari and get the most relevant web results

Start a search in apps like Mail, Messages and Files

Home

Suggested automations help you set up automations with just a tap

A visual status at the top of the Home app gives you a summary of accessories that require your attention

Dynamic suggestions of the most relevant accessories and scenes appear in Home controls in Control Center

Adaptive Lighting automatically adjusts the color of your smart light bulbs throughout the day to maximize comfort and productivity

Face Recognition for video cameras and doorbells uses on-device intelligence to let you know who is there based on the people you’ve tagged in your Photos app and recent visitors you identify in the Home app

Activity Zones for video cameras and doorbells captures video or sends you a notification only when motion is detected in areas you define

Safari

Improved performance with an even faster JavaScript engine

A Privacy Report shows cross-site trackers that are being blocked by Intelligent Tracking Prevention

Password monitoring securely screens your saved passwords for any that may have been involved in a data breach

Web page translation (beta) translates entire web pages in English, Spanish, Simplified Chinese, French, German, Russian or Brazilian Portuguese

Weather

Next-hour precipitation chart shows a minute-by-minute forecast of the intensity of rain or snow over the coming hour for the U.S.

Severe weather information displays government-issued alerts about certain severe weather events including tornados, winter storms, flash floods and more, for the U.S., Europe, Japan, Canada, and Australia

AirPods

Spatial audio with dynamic head tracking on AirPods Pro places sounds anywhere in space, creating an immersive surround sound experience

Automatic device switching transfers audio from your iPhone, iPad, iPod touch, and Mac

Battery notifications let you know if you need to charge your AirPods

Privacy

A recording indicator is displayed whenever an app has access to the microphone or camera

Approximate location can now be shared with an app, rather than sharing your precise location

Limited Photos library access gives you the option to share only selected photos with an app whenever an app asks for access

App and web developers can now offer the option for you to upgrade your existing accounts to Sign in with Apple

Accessibility

Back Tap is a quick way to trigger accessibility features by tapping on the back of your iPhone

Headphone accommodations amplify soft sounds and adjust certain frequencies, customized for an individual's hearing

Sign language prominence in FaceTime detects when a participant is using sign language and makes the person prominent in a Group FaceTime call

Sound Recognition uses on-device intelligence to detect and identify important sounds such as alarms, and alerts you to them using notifications

VoiceOver Recognition uses on-device intelligence to recognize elements on your screen to improve VoiceOver support for app and web experiences

Image descriptions read complete-sentence descriptions of images and photos within apps and on the web

Text recognition speaks the text identified within images and photos

Screen Recognition automatically detects interface controls to aid in navigating apps

App Store

Important details about each app are displayed in a glanceable, scrollable view, including a way to see the games your friends are playing

Apple Arcade

Coming Soon gives you a sneak peek at upcoming Apple Arcade games and you can automatically download them as soon as they're released

See All Games is improved with sorting and filtering by release date, updates, category, controller support and more

Achievements are browsable right from within the Apple Arcade tab

Continue Playing makes it easy to resume recently played games across devices

Game Center dashboard showcases your profile, friends, achievements, leaderboards and more, all from within your game

Apple Cash Family

Apple Cash can be enabled for up to five family members under 18

Send money to your child through Messages or by asking Siri

Notifications for purchases or person to person payments as they occur

Parental controls to limit who your children can send money to

Option to turn off Apple Cash for family members under 18

Shared oversight with another adult in your Family Sharing group

Augmented Reality

Location Anchors in ARKit 4 enables apps to place AR experiences at a specific geographic coordinate

Extended face tracking support is extended to the new iPhone SE

Video textures in RealityKit enable apps to apply video to any part of a scene or virtual object

Camera

Improved shot-to-shot performance speeds up the time to first shot and makes shooting photos even faster

QuickTake video can now also be captured on iPhone XS and iPhone XR when in Photo mode

Quick toggles in Video mode to change video resolution and frame rate from the Camera app

Updated Night mode capture experience on iPhone 11 and iPhone 11 Pro provides guidance to help you stay steady throughout the capture, as well as an option to cancel the shot mid-capture

Exposure compensation control lets you lock an exposure value for an entire camera session

Mirror front camera lets you capture selfies that match the front camera preview

Improved QR code reading to scan codes, even if they are small or wrapped around objects

CarPlay

New categories of supported apps for parking, EV charging, and quick food-ordering

Wallpaper options

Share ETA and send audio messages with Siri

Horizontal status bar support for cars with portrait screens

Chinese and Japanese keyboard support gives users an additional option to search for points of interest

FaceTime

Improved video quality with up to 1080p resolution on iPhone X and later

New eye contact feature uses machine learning to subtly adjust the position of your eyes and face to make video calling more natural even when you're looking at the screen instead of the camera

Files

APFS encryption support for external drives

Health

Wind Down helps you create a pre-bedtime routine with apps and shortcuts, like listening to a relaxing playlist

Custom sleep schedules help you meet your sleep goals with bedtime reminders and wakeup alarms

Sleep mode minimizes distractions during Wind Down and Bedtime by turning on Do Not Disturb and simplifying your Lock screen

Health Checklist helps you track and manage health and safety features in one place

New Mobility category in the Health app, including metrics like walking speed, double support time, step length, and walking asymmetry

Keyboard and International

On-device dictation helps protect your privacy by performing all processing completely offline. Dictation in search uses server-based dictation in order to recognize terms you may be searching for from across the Internet.
Search within the Emoji keyboard using a word or phrase


Keyboard displays AutoFill suggestions from Contacts for email addresses, phone numbers, and more in apps

New dictionaries for French-German, Indonesian-English, Japanese-Simplified Chinese, and Polish‑English

Wubi input method for Simplified Chinese

Autocorrection support for Irish Gaelic and Norwegian Nynorsk

Redesigned Japanese Kana keyboard with easier input for numbers

Mail supports email addresses using non‑Latin languages

Music

A new Listen Now tab for playing and discovering your favorite music, artists, playlists and mixes

Autoplay keeps music playing when you reach the end of a song or playlist by finding similar songs to play

Search now showcases music for your favorite genres and activities, and shows helpful suggestions as you type

Library filtering helps you find artists, albums, playlists and other items in your library even faster

Notes

Enhanced actions menu provides easy access to locking, scanning, pinning and deleting

Top Hits in search surfaces your most relevant search results

Pinned Notes list can be collapsed or expanded

Shape recognition enables drawing perfect lines, arcs and other shapes

Enhanced scanning captures sharper scans and more precise auto-cropping

Photos

Filter and sort your collection to more easily locate and organize your photos and videos

Pinch and zoom to quickly find your photos and videos in more places, like Favorites and Shared Albums

Photos and videos caption support

Live Photos taken using iOS 14 or iPadOS 14 will autoplay with improved stabilization in Years, Months and Days View

Memories enhancements provide a more relevant selection of photos and videos and a larger music selection for Memory movies

Redesigned image picker in apps uses the same smart search from the Photos app to help you easily find content to share

Podcasts

Listen Now is smarter and includes your personal episode queue and new episodes picked for you

Reminders

Assign reminders to people you share lists with

New reminders can be created from the lists screen without having to enter a specific list

Smart suggestions let you add dates, times and locations with a tap

Personalized lists with emoji and newly added symbols

Rearrange or hide smart lists

Settings

Option to set your default email and web browser

Shortcuts

Starter Shortcuts let you get started with a built-in folder of shortcuts, tailored for you

Shortcuts automations are suggested based on your usage patterns

Folders let you organize your shortcuts and can be added as widgets to the Home Screen

New compact design for running shortcuts keeps you in context while you use another app

New Automation triggers can run shortcuts based on receiving an email or message, your battery level, closing an app and more

Wind Down Shortcuts provide a collection of relaxing shortcuts to help you get ready for a good night's sleep

Voice Memos

Folders help organize your Voice Memos recordings

Favorites lets you mark your best recordings and quickly access them later

Smart Folders automatically group together Apple Watch recordings, recently deleted recordings and recordings you marked as Favorites

Enhance Recording reduces background noise and room reverberation

14.0.1 18A393 September 24, 2020; 12 months ago Bug Fixes

Corrects a problem where default applications were reset after a device restart

Camera previews now display properly on the iPhone 7 and iPhone 7 Plus

Corrects an issue with devices being unable to access Wi-Fi

Corrects an issue where users were unable to send mail using certain providers

Images now appear properly in the News widget

#### iOS / iPadOS 14.1

iPad:

iPad (5th, 6th, 7th, 8th) Air (2, 3rd, 4th) Mini (4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9; 4th, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max SE (2nd) 12/12 Mini 12 Pro/12 Pro Max

iPod touch:

7th

Limited support on iPhone 6S, iPhone 7, iPhone SE (1st generation), iPod Touch (7th generation), iPad (5th generation), iPad (6th generation), iPad (7th generation), iPad Air 2, iPad Mini 4 and iPad Pro (1st generation)

Version Build Release date Features

14.1 18A8395 October 20, 2020; 11 months ago Initial release on iPhone 12, iPhone 12 Mini, iPhone 12 Pro and iPhone 12 Pro Max

Support for HomePod Mini and MagSafe certified accessories

Adds support for 10-bit HDR video playback and edit in Photos for iPhone 8 and later

Addresses an issue where some widgets, folders, and icons were showing up in reduced size on the Home Screen

Addresses an issue where dragging widgets on the Home Screen could remove apps from folders

Fixes an issue where some messages in Mail were sent from an incorrect alias

Fixes an issue that could prevent incoming calls from displaying region information

Fixes an issue on some devices where selecting zoomed display mode and an alphanumeric passcode could result in the Lock Screen emergency call button overlapping with the text input box

Addresses an issue where some users were occasionally unable to download or add songs to their library while viewing an album or playlist

Fixes an issue that could prevent zeroes from appearing in Calculator

Resolves an issue where streaming video resolution could temporarily be reduced at the start of playback

Fixes an issue that prevented setting up a family member's Apple Watch for some users

Resolves an issue where the Apple Watch case material was displayed incorrectly in the Apple Watch app

Addresses an issue in the Files app that could cause some MDM-managed cloud service providers to incorrectly display content as unavailable

Improves compatibility with Ubiquiti wireless access points

#### iOS / iPadOS 14.2

iPad:

iPad (5th, 6th, 7th, 8th) Air (2, 3rd, 4th) Mini (4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9; 4th, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max SE (2nd) 12/12 Mini 12 Pro/12 Pro Max

iPod touch:

7th

Limited support on iPhone 6S, iPhone 7, iPhone SE (1st generation), iPod Touch (7th generation), iPad (5th generation), iPad (6th generation), iPad (7th generation), iPad Air 2, iPad Mini 4 and iPad Pro (1st generation)

Version Build Release date Features

14.2 18B92, 18B111 November 5, 2020; 10 months ago 

New features:

Support for the new emoji for Unicode 13.0, including animals, food, smileys, faces, household objects, musical instruments, gender-inclusive emoji

Eight new wallpapers

Magnifier can detect people and report their distance using the LiDAR sensorP12PP12PM

Support for the iPhone 12 Leather Sleeve accessory

Optimized Battery Charging feature for AirPods (analogous to iOS)

Headphone audio level notifications to alert the user if the audio level may be harming

New AirPlay controls to manage other devices' playback

Intercom support for HomePod and HomePod Mini

Option to provide statistics about Exposure Notifications, without identifying the user, to participating public health authorities

Bug fixes:

Fixes an issue where apps could be realigned on the home screen dock

Fixes an issue where the camera viewfinder may appear black when launched

Fixes an issue where the keypad in the lock screen could not register inputs

Fixes an issue where reminders could default to times earlier than intended

Fixes an issue where the Photos widget may not display content

Fixes an issue where the Weather widget could display the high temperature in Celsius even if set to Fahrenheit

Fixes an issue where the Next-hour precipitation chart in Weather could incorrectly indicate when the precipitation stops

Fixes an issue where the voice memo recordings are interrupted by incoming calls regardless of whether they were answered

Fixes an issue where the screen could not show any image during Netflix video playback

Fixes an issue where Apple Pay Cash could fail to send or receive money when used via Siri

Fixes an issue where the Apple Watch app may crash when opened

Fixes an issue where the Workout GPS routes or Health data could not sync between Apple Watches and iPhones for some users

Fixes an issue where audio is incorrectly labeled as not playing in the CarPlay dashboard regardless of media playback

Fixes an issue where devices could fail to charge wirelessly

Fixes an issue where Exposure notifications are disabled when restoring an iPhone with an iCloud backup or transferring data to a new iPhone using the migration tool

14.2.1 18B121 November 19, 2020; 10 months ago[180] iPhone 12, 12 mini, 12 Pro and 12 Pro Max only

Bug fixes:

Fixes an issue where some MMS messages may not be received

Fixes an issue where Made for iPhone hearing devices could have sound quality issues when listening to audio from iPhone

Fixes an issue where Lock Screen could become unresponsive on iPhone 12 mini

#### iOS / iPadOS 14.3

iPad:

iPad (5th, 6th, 7th, 8th) Air (2, 3rd, 4th) Mini (4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9; 4th, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max SE (2nd) 12/12 Mini 12 Pro/12 Pro Max

iPod touch:

7th

Limited support on iPhone 6S, iPhone 7, iPhone SE (1st generation), iPod Touch (7th generation), iPad (5th generation), iPad (6th generation), iPad (7th generation), iPad Air 2, iPad Mini 4 and iPad Pro (1st generation)

Version Build Release date Features

14.3 18C66 December 14, 2020; 9 months ago 

Fitness and Fitness+

New Fitness app on iPhone, iPad and Apple TV to browse Fitness+ workouts, trainers and personalised recommendations

A new fitness experience powered by Apple Watch with studio-style workouts available on your iPhone, iPad and Apple TV

Video workouts added each week in ten popular workout types: High Intensity Interval Training, Indoor Cycling, Yoga, Core, Strength, Dance, Rowing, Treadmill Walking, Treadmill Running and Mindful Cooldown

Playlists curated by Fitness+ trainers to complement your workout

Fitness+ subscription available in Australia, Canada, Ireland, New Zealand, United Kingdom and United States

AirPods Max

Complete support for AirPods Max

Photos

Apple ProRAW support on iPhone 12 Pro and iPhone 12 Pro Max

Apple ProRAW photos can be edited in the Photos app

Option to record video at 25 fps (PAL format)

Mirror the front-facing camera for still photos on iPhone 8, iPhone X and earlier

Privacy

New privacy information section on App Store pages that includes a developer-reported summary of the app's privacy practices

TV app

Apple TV+ tab for Apple Original shows and movies

Enhanced search to browse by category such as genre and see recent searches and suggestions

Top search results shown with the most relevant matches across movies, TV shows, cast, channels and sports

App Clips

Support for launching App Clips by scanning QR codes

Health

Ability to indicate pregnancy, lactation or contraceptive use in Cycle Tracking in order to better manage period and fertile window predictions

Weather

Air quality data is now available in Weather, Maps and Siri for locations in mainland China

Air quality health recommendations are provided in Weather and Siri for the United States, United Kingdom, Germany, India and Mexico at certain air quality levels

Safari

Ecosia search engine option in Safari

Bug fixes

Fixes an issue where some MMS messages may not be received

Fixes an issue where some Messages notifications may not be received

Fixes an issue where contact groups failed to display members when composing a message

Fixes an issue where some videos would not appear correctly when shared from the Photos app

Fixes an issue where app folders may fail to open

Fixes an issue where Spotlight search results and opening apps from Spotlight may not work

Fixes an issue where Bluetooth could be unavailable in Settings

Fixes an issue where devices could be prevented from charging wirelessly

Fixes an issue where MagSafe Duo Charger could wirelessly charge at less than the maximum power

Fixes an issue where wireless accessories and peripherals using the WAC protocol could fail to complete setup

Fixes an issue where the keyboard would dismiss when adding a list in Reminders while using VoiceOver

#### iOS / iPadOS 14.4

iPad:

iPad (5th, 6th, 7th, 8th) Air (2, 3rd, 4th) Mini (4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9; 4th, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max SE (2nd) 12/12 Mini 12 Pro/12 Pro Max

iPod touch:

7th

Limited support on iPhone 6S, iPhone 7, iPhone SE (1st generation), iPod Touch (7th generation), iPad (5th generation), iPad (6th generation), iPad (7th generation), iPad Air 2, iPad Mini 4 and iPad Pro (1st generation)

Version Build Release date Features

14.4 18D52 January 26, 2021; 8 months ago 

Smaller QR codes can be recognized by Camera

Option to classify Bluetooth device type in Settings for correct identification of headphones for audio notifications

Notifications for when the camera on your iPhone is unable to be verified as a new, genuine Apple camera in iPhone 12, iPhone 12 mini, iPhone 12 Pro and iPhone 12 Pro Max

This release also fixes the following issues:

Image artifacts could appear in HDR photos taken with iPhone 12 Pro

Fitness widget may not display updated Activity data

Typing may be delayed and word suggestions may not appear in the keyboard

The keyboard may not come up in the correct language in Messages

Audio stories from the News app in CarPlay may not resume after being paused for spoken directions or Siri

Enabling Switch Control in Accessibility may prevent phone calls from being answered from the Lock Screen

14.4.1 18D61 March 8, 2021; 6 months ago Fix CVE-2021-1844, which allows a malicious web page to perform remote code execution in WebKit.

14.4.2 18D70 March 26, 2021; 6 months ago Fix CVE-2021-1879, a vulnerability that permits malicious web content to perform universal cross-site scripting.[

#### iOS / iPadOS 14.5

iPad:

iPad (5th, 6th, 7th, 8th) Air (2, 3rd, 4th) Mini (4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9; 4th, 11 & 12.9; 5th, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max SE (2nd) 12/12 Mini 12 Pro/12 Pro Max

iPod touch:

7th

Limited support on iPhone 6S, iPhone 7, iPhone SE (1st generation), iPod Touch (7th generation), iPad (5th generation), iPad (6th generation), iPad (7th generation), iPad Air 2, iPad Mini 4 and iPad Pro (1st generation)

Version Build Release date Features

14.5 18E199 April 26, 2021; 5 months ago Initial release on iPad Pro (5th generation, 12.9-inch, 3rd generation, 11-inch)

Apple Watch

Unlock your iPhone with Apple Watch when wearing a mask

You can now backup your Apple Watch to iCloud by a toggle function under the iCloud control panel on your iPhone

AirTags

Adds support for Apple AirTags within the "Find My" app using the U1 chip in the iPhone 11 and later for precision finding

Apple Maps

Adds a reporting feature to Apple Maps, similar to Waze

Uses crowdsourcing for reporting of Accidents, Hazards, and Speed Checks

When doing a walking or cycling route, you can now send an ETA to an individual using the Messages App

Can send an ETA message from Apple Maps in CarPlay via Siri or keyboard controls

AirPlay 2

Added support for Fitness+ workouts to be streamed to an AirPlay 2 compatible TV or device

Apple watch metrics cannot be displayed on screen of AirPlay 2 devices. Must view them on iOS device used to cast to AirPlay 2

5G

Global support has been added to iPhone 12 models for Dual-Sim 5G service

Standalone T-Mobile support has been added for better 5G range and connectivity for iPhone 12 models

Improved 5G data usage tracking via Smart Data Mode and extended battery life

Emojis

New Emojis have been added. These include heart on fire, mending heart, exhaling face, face with spiral eyes, and face in clouds

Male and female emojis now include the option to have beards for both genders

Apple added additional skin tone options for couples

Revamped the Stereo Headphones emoji to now use the Apple AirPods Max and removed the blood from the syringe emoji

Siri

Can now set a preferred streaming music service to use when asking Siri to play a song

Added two new English voices

Siri no longer has a female voice by default

When setting up a new iPhone, users can now set up what voice they prefer to use with Siri

Changed categorizations and labels within the Siri Control panel in the Settings App. "Siri & Search" is now "Siri Voice", "Accent" is now "Variety", and there is no longer a Gender section

Incoming Calls can now be announced with information on who is calling

AirPods and Beats now allow for Siri to answer calls hands-free

Siri can dial emergency contacts and create Group FaceTime calls

App Tracking Transparency

Developers are now required to ask and receive permission to track users across different applications

Apple Music

New slide gestures for adding a song to the Now Playing queue or to Apple Music Library

Long pressing on a song brings up new options to "Play Last" and "Show Album"

Three dots have been added to the Library in place of the download button. With this you can access many features for each song

Ability to send lyrics and sound clips of songs to people via the Share sheet

Addition of "City Charts" which are curated playlists of songs listened to in at least a hundred different cities

Podcasts

The Podcast app now resembles the Music App in terms of presentation of content, search functionality, and the "Browse" section representing new and trending Podcasts

Podcasts now say "Follow" instead of "Subscribe" due to the addition of a paid subscription ability for content creators

You can now save and download Podcast episodes without having to "Follow" the Podcast channel

Reminders

Ability to sort lists by Due Date, Creation Date, Priority, or Title

Ability to print Reminder lists

Apple News

Addition of a Search tab

News+ section now has a "For You" feature

Browse tab is now easier to access

Translate

Now can adjust playback speed by long pressing on the play button when listening to a translation

Shortcuts

New actions for screenshots, locking orientation of iPhone, and switching between different cellular data modes

Find My

Now supports Beats headphones, and Belkin wireless earbuds. Located under the new "Items" tab

Under the "Me" tab you can now toggle on or off "Item Safety Features". This will allow a person to see if an AirTag had been placed on them without their knowledge

MagSafe Wallet

When attaching or detaching a MagSafe Wallet from an iPhone 12 there is now a stronger haptic vibration

Security

Apple has begun using Google's Safe Browsing feature and is proxying it so Google can not collect as much data from an individual's IP address

Safari now includes a "Fraudulent Website Warning" that runs through the Google Safe Browsing function

Improved how Zero-click attacks are handled and prevented within Safari

Misc. Features

Emergency Alerts can now be toggled to play a sound or not, even when the phone is silenced. This is done by toggling the "Always Deliver" feature on or off

Added Accessibility Voice Control in English to Australia and Canada. Spanish is added for Mexico, Spain, and the United States

Expanded controller support for the Playstation 5 and Xbox Series S/X controllers

Bug Fixes

iPhone 11 models that had issues with Battery Health metrics will now have the Battery Health recalibrated to improve battery health, fix unexpected battery drain, and fix a bug with peak performance capability

Provided fixes for Green Tint issues for some iPhones

Fixed a bug regarding AirPods Automatic Switching connecting to the wrong device

Fixed a bug regarding notifications that were missing or duplicated for Automatic Switching for AirPods

Fixed a bug in Messages that caused texts to constantly fail to send when being sent to certain threads

14.5.1 18E212 May 3, 2021; 4 months ago 

Security fixes

#### iOS / iPadOS 14.6

iPad:

iPad (5th, 6th, 7th, 8th) Air (2, 3rd, 4th) Mini (4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9; 4th, 11 & 12.9; 5th, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max SE (2nd) 12/12 Mini 12 Pro/12 Pro Max

iPod touch:

7th

Limited support on iPhone 6S, iPhone 7, iPhone SE (1st generation), iPod Touch (7th generation), iPad (5th generation), iPad (6th generation), iPad (7th generation), iPad Air 2, iPad Mini 4 and iPad Pro (1st generation)

Version Build Release date Features

14.6 18F72 May 24, 2021; 4 months ago 

Apple Card Family

Apple Card can be shared with up to five people, including anyone 13 years or older in your Family Sharing group

Apple Card Family adds support for families to track expenses, manage spending with optional limits and controls, and build credit together

Podcasts

Subscription support for channels and individual shows

AirTag and Find My

Lost mode option to add an email address instead of a phone number for AirTag and Find My network accessories

AirTag will show the partially masked phone number of the owner when tapped with an NFC-capable device

Accessibility

Voice Control users can unlock their iPhone for the first time after a restart using only their voice

This release also fixes the following issues:

Unlock with Apple Watch may not work after using Lock iPhone on Apple Watch

Reminders may appear as blank lines

Call blocking extensions may not appear in Settings

Bluetooth devices could sometimes disconnect or send audio to a different device during an active call

iPhone may experience reduced performance during startup 

#### iOS / iPadOS 14.7

iPad:

iPad (5th, 6th, 7th, 8th) Air (2, 3rd, 4th) Mini (4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9; 4th, 11 & 12.9; 5th, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max SE (2nd) 12/12 Mini 12 Pro/12 Pro Max

iPod touch:

7th

Limited support on iPhone 6S, iPhone 7, iPhone SE (1st generation), iPod Touch (7th generation), iPad (5th generation), iPad (6th generation), iPad (7th generation), iPad Air 2, iPad Mini 4 and iPad Pro (1st generation)

Version Build Release date Features

14.7 18G69/16G70 July 19, 2021; 2 months ago

iPadOS: July 21, 2021; 2 months ago 

MagSafe Battery Pack support for iPhone 12, iPhone 12 mini, iPhone 12 Pro and iPhone 12 Pro Max

Apple Card Family adds the option to combine credit limits and share one co-owned account with an existing Apple Card user

Home app adds the ability to manage timers on HomePod

Air quality information is now available in Weather and Maps for Canada, France, Italy, Netherlands, South Korea, and Spain

Podcasts library allows you to choose to see all shows or only followed shows

Share playlist menu option missing in Apple Music

Dolby Atmos and Apple Music lossless audio playback may unexpectedly stop

Battery service message that may have disappeared after reboot on some iPhone 11 models is restored

Braille displays could show invalid information while composing Mail messages

Audio may skip when using USB-C to 3.5 mm headphone jack adapters with iPad

14.7.1 18G82 July 26, 2021; 2 months ago 

Fixes an issue where iPhone models with Touch ID cannot unlock a paired Apple Watch using the Unlock with iPhone feature.

Security fixes

#### iOS / iPadOS 14.8

iPad:

iPad (5th, 6th, 7th, 8th) Air (2, 3rd, 4th) Mini (4, 5th) Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9; 4th, 11 & 12.9; 5th, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max SE (2nd) 12/12 Mini 12 Pro/12 Pro Max

iPod touch:

7th

Limited support on iPhone 6S, iPhone 7, iPhone SE (1st generation), iPod Touch (7th generation), iPad (5th generation), iPad (6th generation), iPad (7th generation), iPad Air 2, iPad Mini 4 and iPad Pro (1st generation)

Version Build Release date Features

14.8 18H17 September 13, 2021; 15 days ago 

This release fixes two remote code execution vulnerabilities. One is FORCEDENTRY (CVE-2021-30860), an integer overflow bug that allows a malicious PDF to perform remote code execution. This is used by NSO Group to bypass iOS's BlastDoor to install its Pegasus spyware. The other is CVE-2021-30858, a use-after-free bug that allows a malicious web page to perform remote code execution.

### iOS 15 / iPadOS 15

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 15 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/15/IOS_15_logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/15/IOS_15_logo.png)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/15/IOS_15_Homescreen.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/15/IOS_15_Homescreen.png)

Apple announced [iOS 15](https://github.com/seanpm2001/WacOS/wiki/iOS-15/) and [iPadOS 15](https://github.com/seanpm2001/WacOS/wiki/iPadOS-15/) on June 7, [2021](https://github.com/seanpm2001/WacOS/wiki/2021/) at its annual WWDC 2021 event, with a developer beta released on the same day. All devices that supported [iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/), [iPadOS 13](https://github.com/seanpm2001/WacOS/wiki/iPadOS-13/), [iOS 14](https://github.com/seanpm2001/WacOS/wiki/iOS-14/), and [iPadOS 14](https://github.com/seanpm2001/WacOS/wiki/iPadOS-14/) also support [iOS 15](https://github.com/seanpm2001/WacOS/wiki/iOS-15/) and [iPadOS 15](https://github.com/seanpm2001/WacOS/wiki/iPadOS-15/). However, [iOS 15](https://github.com/seanpm2001/WacOS/wiki/iOS-15/) and [iPadOS 15](https://github.com/seanpm2001/WacOS/wiki/iPadOS-15/) have limited support on devices with A8, A8X, A9, A9X, A10 Fusion, A10X Fusion, and A11 Bionic chips, which include iPhone 6S, iPhone 7, iPhone 8, iPhone X, iPhone SE (1st generation), iPod Touch (7th generation), iPad (5th generation), iPad (6th generation), iPad (7th generation), iPad Air 2, iPad Mini 4, iPad Pro (1st generation), and iPad Pro (2nd generation).

#### iOS / iPadOS 15.0

iPad:

iPad (5th, 6th, 7th, 8th, 9th) Air (2, 3rd, 4th) Mini (4, 5th, 6th Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9; 4th, 11 & 12.9; 5th, 11 & 12.9)

iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max SE (2nd) 12/12 mini 12 Pro/12 Pro Max 13/13 mini 13 Pro/13 Pro Max

iPod touch:

7th

Limited support on iPhone 6S, iPhone 7, iPhone 8, iPhone X, iPhone SE (1st generation), iPod Touch (7th generation), iPad (5th generation), iPad (6th generation), iPad (7th generation), iPad Air 2, iPad Mini 4, iPad Pro (1st generation) and iPad Pro (2nd generation)

Version Build Release date Features

15.0 19A346 September 20, 2021; 8 days ago 

FaceTime

Spatial audio makes people’s voices sound like they’re coming from the direction in which they’re positioned on the screen on Group FaceTime calls (iPhone XS, iPhone XS Max, iPhone XR and later)

Voice Isolation blocks background noises so your voice is crystal clear (iPhone XS, iPhone XS Max, iPhone XR and later)

Wide Spectrum brings all background noises into your call (iPhone XS, iPhone XS Max, iPhone XR and later)

Portrait mode blurs your background and puts the focus on you (iPhone XS, iPhone XS Max, iPhone XR and later)

Grid view displays up to six people at a time in Group FaceTime calls in the same-size tiles and highlights the current speaker

FaceTime links allow you to invite your friends into a FaceTime call, even friends on Android or Windows devices can join from their browser

Messages and Memoji

Shared with You shows content sent to you by friends in Messages conversations in a new section in Photos, Safari, Apple News, Apple Music, Apple Podcasts, or the Apple TV app

Pinned content elevates the shared content you choose and makes it more prominent in Shared with You, Messages search, and the Details view of the conversation

Multiple photos sent in Messages are displayed as a glanceable collage or a swipeable stack

Over 40 Memoji outfit choices and up to three different colors to customize your Memoji stickers’s clothing and headwear

Focus

Focus lets you automatically filter notifications based on what you’re currently doing, such as fitness, sleep, gaming, reading, driving, work, or personal time

Focus uses on-device intelligence during set up to suggest apps and people you want to allow notifications from in a Focus

Home Screen pages can be customized to match your apps and widgets to a specific Focus

Contextual suggestions intelligently suggest a Focus based on your context, using signals like location or time of day

Status appears to your contacts in Messages conversations, indicating your notifications are silenced with Focus

Notifications

A new look displays contact photos for people and larger icons for apps

Notification summary delivers a helpful collection of your notifications daily, based on a schedule you set

Notifications can be muted from any app or messaging thread for the next hour or for the day

Maps

Detailed city maps display elevation, trees, buildings, landmarks, crosswalks and turn lanes, and 3D views to navigate complex interchanges, and more in San Francisco Bay Area, Los Angeles, New York, and London, with more cities coming in the future (iPhone XS, iPhone XS Max, iPhone XR and later)

New driving features include a new map that highlights details like traffic and incidents, and a route planner that lets you view your upcoming journey by choosing a future departure or arrival time

Immersive walking directions show step-by-step directions in augmented reality (iPhone XS, iPhone XS Max, iPhone XR and later)

Updated transit experience provides one-tap access to departures near you, makes it easy to see and interact with your route using one hand, and notifies you when approaching your stop

Interactive 3D globe shows enhanced details for mountain ranges, deserts, forests, oceans, and more (iPhone XS, iPhone XS Max, iPhone XR and later)

Redesigned place cards make it easy to learn about and interact with places, and a new home for Guides editorially curates the best recommendations for places you’ll love

Safari

Bottom tab bar is easier to reach and helps you move between tabs by swiping left or right

Tab Groups help you save and organize your tabs and easily access them across devices

Tab overview grid view displays your open tabs

Start page can be customized with a background image and new sections like Privacy Report, Siri Suggestions, and Shared With You

Web extensions on iOS help you personalize your browsing and can be downloaded through the App Store

Voice search lets you search the web using your voice

Wallet

Home keys let you tap to unlock a supported home or apartment door lock (iPhone XS, iPhone XS Max, iPhone XR and later)

Hotel keys allow you to tap to unlock your room at participating hotels

Office keys allow you to tap to unlock your office doors for participating corporate offices

Car keys with Ultra Wideband help you unlock, lock, and start your supported car without having to take your iPhone out of your bag or pocket (iPhone 11 and iPhone 12 models)

Remote keyless entry functions on your car keys allow you to lock, unlock, honk your horn, preheat your car, or open your trunk on your supported vehicle

Live Text

Live Text makes text interactive in your photos so you can copy and paste, look up, and translate in Photos, Screenshot, Quick Look, Safari, and live previews with Camera (iPhone XS, iPhone XS Max, iPhone XR and later)

Data detectors for Live Text recognize phone numbers, emails, dates, street addresses, and more in photos so you can take action on them

Live Text is available from the keyboard letting you insert text directly from the camera viewfinder into any text field

Spotlight

Rich results brings together all the information you’re looking for on contacts, actors, musicians, movies, and TV shows

Photos can be searched from your photo library by locations, people, scenes, text in the photos or other things in the photos, like a dog or a car

Web image search allows you to search for images of people, animals, monuments, and more

Photos

New look for Memories with a new interactive interface, animated cards with smart, adaptive titles, new animation and transition styles, and multiple image collages

Apple Music can be added to your Memories for Apple Music subscribers, and personalized song suggestions combine expert recommendations with your music tastes and what’s in your photos and videos

Memory mixes let you set the mood by selecting from different songs and a Memory look to match

New memory types include additional international holidays, child-focused memories, trends over time, and improved pet memories

Info pane now displays rich information about the photo like which camera and lens, shutter speed, file size, and more

Visual Look Up recognizes art, landmarks around the world, plants and flowers, books, and dog and cat breeds in your photos so you can learn more about them

Health

Sharing lets you choose health data, alerts, and trends to share with people important to you or those who are caring for you, including your healthcare provider

Trends lets you see how a given health metric is progressing over time and can notify you when a new trend has been detected

Walking Steadiness is a new metric that can assess your risk of falling and notify you if your walking steadiness is low (iPhone 8 and later)

Verifiable health records enable you to download and store verifiable versions of COVID-19 vaccines and lab results

Lab results can now be pinned for quick access and include highlights that show how your labs have changed over time

Weather

A new design shows the most important weather information for that location and includes new maps modules

Weather maps can be viewed in full-screen and show precipitation, temperature and air quality in supported countries

Next-hour precipitation notifications alert you when rain or snow is about to start or stop in Ireland, U.K., and US

New animated backgrounds more accurately represent the sun position, clouds, and precipitation (iPhone XS, iPhone XS Max, iPhone XR and later)

Siri

On-device processing means audio of your requests does not leave your device by default, and means Siri is able to process many requests while offline (iPhone XS, iPhone XS Max, iPhone XR and later)

Share items with Siri lets you send on screen items like photos, web pages and Maps locations to any of your contacts

Onscreen context can be used by Siri to refer to contacts on screen to send them a message or place a call

On-device personalization allows Siri speech recognition and understanding to improve privately (iPhone XS, iPhone XS Max, iPhone XR and later)

Privacy

Mail Privacy Protection protects your privacy by preventing email senders from learning about your Mail activity, your IP address or whether you've opened their email

Safari Intelligent Tracking Prevention now also prevents known trackers from profiling you using your IP address

iCloud+

iCloud+ is a cloud subscription service that gives you premium features and additional iCloud storage

iCloud Private Relay (beta) sends your requests through two separate internet relays and encrypts the internet traffic leaving your device so you can browse Safari in a more secure and private way

Hide My Email lets you create unique, random email addresses that forward to your personal inbox so you can send and receive email without having to share your real email address

HomeKit Secure Video supports connecting more security cameras without using your iCloud storage quota

Custom email domain personalizes your iCloud Mail address and allows you to invite family members to use the same domain

Accessibility

Image exploration with VoiceOver allows you to get even more details about people and objects, and learn about text and table data in photos

VoiceOver image descriptions in Markup let you add your own image descriptions that can be read by VoiceOver

Per-app settings allow you to customize display and text size settings only for the apps you want

Background sounds play balanced, bright, or dark noise, ocean, rain, and stream sounds continuously in the background to mask unwanted environmental or external noise

Sound actions for Switch Control enable you to control your iPhone with simple mouth sounds

Audiograms can be imported in Settings so you can customize Headphone Accommodations based on your hearing test results

New Voice Control languages include Mandarin Chinese (China mainland), Cantonese (Hong Kong), French (France), and German (Germany)

Memoji options including a cochlear implant, oxygen tubes, or a soft helmet

This release also includes other features and improvements:

Tags in Notes and Reminders help you quickly categorize your items to make them easy to find, and you can use custom Smart Folders and Smart Lists to automatically collect your notes and reminders based on rules you can define

Mentions in Notes enable you to notify others of important updates in shared notes, and an all-new Activity view displays all the recent changes in a note in a single list

Spatial audio with dynamic head tracking in Apple Music brings an even more immersive experience to Dolby Atmos music with AirPods Pro and AirPods Max

System-wide translation lets you select text throughout the system and translate it with a tap, even in photos

New widgets include Find My, Contacts, App Store, Sleep, Game Center, and Mail

Cross-app drag and drop function lets you pick up images, documents, and files from one app to another

Keyboard magnification loupe magnifies the text when moving the cursor

Apple ID Account Recovery Contacts lets you to choose one or more people you trust to help you reset your password and regain access to your account

Temporary iCloud storage grants you as much iCloud storage as you need to create a temporary backup of your data, free of charge, for up to three weeks when you buy a new device

Find My separation alerts notify you if you leave a supported device or item behind and Find My will give you directions to your item

Game highlights of up to the last 15 seconds of gameplay can be saved using game controllers like the Xbox Series X

#### iOS / iPadOS 15.1

##### iPad:

iPad (5th, 6th, 7th, 8th, 9th) Air (2, 3rd, 4th) Mini (4, 5th, 6th Pro (1st, 12.9 & 9.7; 2nd, 12.9 & 10.5; 3rd, 11 & 12.9; 4th, 11 & 12.9; 5th, 11 & 12.9)

##### iPhone:

6S/6S Plus SE (1st) 7/7 Plus 8/8 Plus X XR XS/XS Max 11 11 Pro/11 Pro Max SE (2nd) 12/12 mini 12 Pro/12 Pro Max 13/13 mini 13 Pro/13 Pro Max

##### iPod touch:

7th

Limited support on iPhone 6S, iPhone 7, iPhone 8, iPhone X, iPhone SE (1st generation), iPod Touch (7th generation), iPad (5th generation), iPad (6th generation), iPad (7th generation), iPad Air 2, iPad Mini 4, iPad Pro (1st generation) and iPad Pro (2nd generation)

Version Build Release date Features

15.1 beta 19B5042h September 21, 2021; 7 days ago 

## Device codes

### iPhone

^P1 iPhone (1st generation)

^P2 iPhone 3G

^P3 iPhone 3GS

^P4 iPhone 4 (GSM version)

^P4C iPhone 4 (CDMA version)

^P4S iPhone 4S

^P5 iPhone 5

^P5C iPhone 5C

^P5S iPhone 5S

^P6 iPhone 6

^P6P iPhone 6 Plus

^P6S iPhone 6S

^P6SP iPhone 6S Plus

^PSE iPhone SE (1st generation)

^P7I iPhone 7 with Intel PMB9943 modem

^P7Q iPhone 7 with Qualcomm MDM9645 modem

^P7PI iPhone 7 Plus with Intel PMB9943 modem

^P7PQ iPhone 7 Plus with Qualcomm MDM9645 modem

^P8I iPhone 8 with Intel PMB9948 modem

^P8Q iPhone 8 with Qualcomm MDM9655 modem

^P8PI iPhone 8 Plus with Intel PMB9948 modem

^P8PQ iPhone 8 Plus with Qualcomm MDM9655 modem

^PXI iPhone X with Intel PMB9948 modem

^PXQ iPhone X with Qualcomm MDM9655 modem

^PXS iPhone XS

^PXSM iPhone XS Max

^PXR iPhone XR

^P11 iPhone 11

^P11P iPhone 11 Pro

^P11PM iPhone 11 Pro Max

^PSE2G iPhone SE (2nd generation)

^P12 iPhone 12

^P12M iPhone 12 Mini

^P12P iPhone 12 Pro

^P12PM iPhone 12 Pro Max

^P13 iPhone 13

^P13M iPhone 13 Mini

^P13P iPhone 13 Pro

^P13PM iPhone 13 Pro Max

### iPad

^S1 iPad (1st generation) Wi-Fi only

^S1C iPad (1st generation) Wi-Fi+3G

^S2 iPad 2 Wi-Fi-only

^S2C iPad 2 Wi-Fi+3G GSM

^S2D iPad 2 Wi-Fi+3G CDMA

^S3 iPad 3 Wi-Fi-only

^S3L iPad 3rd generation Wi-Fi+4G (LTE) (AT&T/global version)

^S3D iPad 3rd generation Wi-Fi+4G (LTE) (Verizon version)

^S4 iPad 4th generation Wi-Fi-only

^S4L iPad 4th generation Wi-Fi+4G (LTE) (AT&T/global version)

^S4D iPad 4th generation Wi-Fi+4G (LTE) (Verizon version)

^S5 iPad Air Wi-Fi-only

^S5L iPad Air Wi-Fi+4G (LTE) (AT&T/global version)

^S5D iPad Air Wi-Fi+4G (LTE) (Verizon version)

^S6 iPad Air 2 Wi-Fi-only

^S6L iPad Air 2 Wi-Fi+4G (LTE) (AT&T/global version)

^S7 iPad (2017) Wi-Fi-only

^S7L iPad (2017) Wi-Fi+4G (LTE) (AT&T/global version)

^S8 iPad (2018) Wi-Fi-only

^S8L iPad (2018) Wi-Fi+4G (LTE) (AT&T/global version)

^S9 iPad Air (2019) Wi-Fi-only

^S9L iPad Air (2019) Wi-Fi+4G (LTE) (AT&T/global version)

^S10 iPad (2019) Wi-Fi-only

^S10L iPad (2019) Wi-Fi+4G (LTE) (AT&T/global version)

^S11 iPad Air (2020) Wi-Fi-only

^S11L iPad Air (2020) Wi-Fi+4G (LTE) (AT&T/global version)

^S12 iPad (2020) Wi-Fi-only

^S12L iPad (2020) Wi-Fi+4G (LTE) (AT&T/global version)

### iPad Mini

^M1 iPad Mini (1st generation) Wi-Fi-only

^M1C iPad Mini (1st generation) Wi-Fi+4G (LTE)

^M2 iPad Mini 2 Wi-Fi-only

^M2C iPad Mini 2 Wi-Fi+4G (LTE)

^M3 iPad Mini 3 Wi-Fi-only

^M3C iPad Mini 3 Wi-Fi+4G (LTE)

^M4 iPad Mini 4 Wi-Fi-only

^M4C iPad Mini 4 Wi-Fi+4G (LTE)

^M5 iPad Mini (5th generation) Wi-Fi-only

^M5C iPad Mini (5th generation) Wi-Fi+4G (LTE)

^M6 iPad Mini (6th generation) Wi-Fi-only

^M6C iPad Mini (6th generation) Wi-Fi+4G (LTE)

### iPad Pro

^R1 iPad Pro (1st generation (12.9-inch)) Wi-Fi-only

^R1C iPad Pro (1st generation (12.9-inch)) Wi-Fi+4G (LTE)

^R2 iPad Pro (9.7-inch) Wi-Fi-only

^R2C iPad Pro (9.7-inch) Wi-Fi+4G (LTE)

^R3 iPad Pro (2nd generation (12.9-inch)) Wi-Fi-only

^R3C iPad Pro (2nd generation (12.9-inch)) Wi-Fi+4G (LTE)

^R4 iPad Pro (10.5-inch) Wi-Fi-only

^R4C iPad Pro (10.5-inch) Wi-Fi+4G (LTE)

^R5 iPad Pro (3rd generation (12.9-inch)) Wi-Fi-only

^R5C iPad Pro (3rd generation (12.9-inch)) Wi-Fi+4G (LTE)

^R6 iPad Pro (1st generation (11-inch)) Wi-Fi-only

^R6C iPad Pro (1st generation (11-inch)) Wi-Fi+4G (LTE)

^R7 iPad Pro (4th generation (12.9-inch)) Wi-Fi-only

^R7C iPad Pro (4th generation (12.9-inch)) Wi-Fi+4G (LTE)

^R8 iPad Pro (2nd generation (11-inch)) Wi-Fi-only

^R8C iPad Pro (2nd generation (11-inch)) Wi-Fi+4G (LTE)

^R9 iPad Pro (5th generation (12.9-inch)) Wi-Fi-only

^R9C iPad Pro (5th generation (12.9-inch)) Wi-Fi+4G (LTE)

^R10 iPad Pro (3rd generation (11-inch)) Wi-Fi-only

^R10C iPad Pro (3rd generation (11-inch)) Wi-Fi+4G (LTE)

### iPod Touch

^T1 iPod Touch (1st generation)

^T2 iPod Touch (2nd generation)

^T3 iPod Touch (3rd generation)

^T4 iPod Touch (4th generation)

^T5 iPod Touch (5th generation)

^T6 iPod Touch (6th generation)

^T7 iPod Touch (7th generation)

### HomePod

^H1 HomePod (1st generation)

^H2 HomePod Mini (1st generation)

## See also

Information on other operating systems developed by Apple Inc.

[macOS](https://github.com/seanpm2001/WacOS/wiki/MacOS/)

[iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/)

[watchOS](https://github.com/seanpm2001/WacOS/wiki/WatchOS/)

[tvOS](https://github.com/seanpm2001/WacOS/wiki/tvOS/)

Version histories for other operating systems and products by Apple Inc.

[iPhoneOS version history](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-version-history/)

[macOS version history](https://github.com/seanpm2001/WacOS/wiki/Complete-MacOS-version-history/)

[iTunes version history](https://github.com/seanpm2001/WacOS/wiki/iTunes-version-history/)

[Safari version history](https://github.com/seanpm2001/WacOS/wiki/Safari-version-history/)

***

## Sources

[Wikipedia - iOS version history](https://en.wikipedia.org/wiki/IOS_version_history)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Tuesday September 28th at 3:34 pm`

**Last revised on:** `2021 Tuesday September 28th at 4:39 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `8,932`

**Article version:** `2 (2021 Tuesday September 28th at 4:39 pm)`

**Majority language:** `English (US) / Markdown`

**Minority languages:** `English (US) / Markdown`

**Current revision:** `2 (2021, Tuesday, September 28th at 4:39 pm)`

**All times are UTC-7 (PDT/Pacific Time)**

**You may need special rendering support for the `<dropdown>` HTML tag being used in this document**

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

