  
***

# iOS 15

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 15 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/15/IOS_15_logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/15/IOS_15_logo.png)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/15/IOS_15_Homescreen.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/15/IOS_15_Homescreen.png)

( **Predecessor:** [iOS 14](https://github.com/seanpm2001/WacOS/wiki/iOS-14/) | **iOS 15** | **Successor:** `To be announced, likely iOS 16` )

**As of 2021 September 27th, iOS 12 and later are still supported and are receiving updates. The data here will need to be updated in the future.**

iOS 15 is the fifteenth and current major release of the [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) mobile operating system developed by Apple for its iPhone and iPod Touch products. It was announced at the company's Worldwide Developers Conference on June 7, [2021](https://github.com/seanpm2001/WacOS/wiki/2021/) as the successor to [iOS 14](https://github.com/seanpm2001/WacOS/wiki/iOS-14/), and was released to the public on September 20, [2021](https://github.com/seanpm2001/WacOS/wiki/2021/).

## History

### Updates

The first developer beta of iOS 15 was released on June 7, [2021](https://github.com/seanpm2001/WacOS/wiki/2021/), and the first public beta was released at the end of June [2021](https://github.com/seanpm2001/WacOS/wiki/2021/), six days after the release of the second developer beta. The second public beta was released on July 16, [2021](https://github.com/seanpm2001/WacOS/wiki/2021/). iOS 15 was officially released on September 20, [2021](https://github.com/seanpm2001/WacOS/wiki/2021/).

Version 	Build 	Release date 	Notes

15.0 	19A346 	September 20, 2021 	Initial release

15.1 beta 	19B5042h 	September 21, 2021 	

Legend:   Past   Current   Beta

## Features

### Focus

The Focus allows users to set their "state", such as work, sleep, do not disturb or a custom one. Based on the selected state, users can set the type of notification they want to receive and from which application. It is also possible to choose which pages and then apps to show on the Home based on the state. The state can change automatically based on where the user is or a time.

Focus also controls the interactions with Contacts, so it's possible to decide which specific contacts can "disturb" the user.

Some Lock Screen settings can be controlled based on the state: for example, the Dim Lock Screen feature, which darkens the lock screen from not showing notifications on that screen, can be automatically turned on or off based on the state.

Focus is synchronized automatically across different [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) and [macOS](https://github.com/seanpm2001/WacOS/wiki/MacOS/) devices on the same iCloud account, as well as any paired watchOS devices.

### Notifications

Notifications receive a new look with contact photos for all communication apps and larger app icons.

The Summary allows the user to group and postpone the notifications coming from the chosen apps, delivering them at a scheduled time in a single big notification called summary notification.

### Live Text

Devices with an A12 chip or newer support Live Text in all apps which can transcribe text from the camera in the real world, images, photos through Artificial Intelligence text recognition.

### Smart stacks with suggested Widgets

The Widgets in iOS 15 are more dynamic: depending on the context, the system can add or remove widgets to existing stacks. For example, near the start of a certain event in the Calendar, the system can decide to add the Calendar Widget to an existing smart stack, if it is not already present, and then remove it at the end of the event.
Cross-App Drag and Drop

Users can now drag pictures and text from one app to another.

### Home

Users can now reorder the various Home screens.

### Per-App Text Size

From the Control Center, the text size can be set per app.

### Spotlight

The global search function has been enhanced and it is also available on the lock screen by pulling the page down.

### Dictation

Formerly limited to 60 seconds, the Voice-To-Text dictation available in the keyboard is unlimited.

### System-wide translation

System-wide translation allows the user to translate text in all apps by selecting it and tapping on the Translate option.

### Adjust video playback speed

The system default player, used for videos and by many apps, has the control to adjust the playback speed.
Video Effects and Mic Mode

Video Effects and Mic Mode are two new commands in the Control center that allow the user to add Portrait effect to the camera and set Microphone mode to Voice Isolation on any apps.

### Accessibility improvements

Per-App Accessibility: each app can have a different accessibility setting to customize the text (Bold Text, Larger Text, Button Shapes, On/Off Labels, Reduce Transparency), increase contrast, reduce motion, autoplay video-preview, etc.

Image Exploration with VoiceOver: it describes photos to give users with low vision more context about what’s displayed on the photo.

Audible charts: the Audio Graphs accessibility framework allows to represent chart data with audio for blind and low-vision people.

### iCloud

Backups to iCloud can now also be made on 5G cellular networks.

### RealityKit 2

The new version allows apps to build more immersive AR experiences using new APIs to capture objects even faster, custom shaders, dynamic assets, custom systems and character control.

### Increased 5G usage

iOS 15 allows more apps and system features to use 5G connectivity than iOS 14, including:

Downloading apps

Backing up from and restoring to iCloud

ownloading content from Apple TV+ in higher resolutions

It also allows devices with 5G connectivity to automatically fall back to the 5G connection when experiencing performance issues on unsecured or captive wireless network.

### Accounts for School and Work

It is possible to add to the iPhone the accounts of your organization, managed by schools or companies, without having to use external apps or profiles.

### StoreKit 2

StoreKit 2 allows apps to implement the "Request a Refund" option in-app. The users can tap this option, select a specific in-app purchase and identify the problem that led to the refund request. It also allows developers monitoring the purchases made by their users without using third-party solutions.

## App improvements

### FaceTime

iOS 15 adds several new features to FaceTime including:

Grid view for group conversations

Portrait mode, requires A12 Bionic chip or later

Spatial Audio

Voice isolation mode: remove background noise during calls

Wide spectrum mode

FaceTime links and web integration: Allow Android and Microsoft Windows users to join calls

Calendar integration

Mute alerts, which let users know when they are talking while muted

FaceTime can now take advantage of all rear cameras (on compatible devices)

### Memoji

Memoji have more customization options, including new clothing, two different eye colors, new glasses, new stickers, multicolored headwear, and new accessibility options.

### Messages


Multiple images in stack: messages now displays multiple images in a stack, making them easier to navigate.

Pinned content: it's possible to pin any content, text or link you receive from a contact.

Shared with You: Messages also introduces a new feature called "Shared with You", which organizes links and other content shared via Messages in a dedicated section in their native apps for later viewing (for instance, a news article shared via messages is shown in the News app).

### Maps

Apple Maps receives several new features:

Greater depth has been added to the driving maps with the use of 3D modeling, which will make it easier to interpret directions when faced with roads that go over or under the one being driven on, including buildings, bridges and trees.

3D globe with a new color palette and increased mountain, desert, and forest detail

Increased traffic information, turn lanes, bike, bus and taxi lanes, medians, crosswalks

Walking directions in augmented reality on A12 devices or later

Redesigned place cards

Improved filtering for search

The night mode set in Maps now follows the night mode set in the OS instead of activating it only at night and the colors are improved.

Public Transport Info: public transport routes and times with ability to pin favorite routes to the top. In-app notifications will alert users when they need to get off a bus or train. Transit information can be visible on a connected Apple Watch.

Reports and Reviews: you can report incidents, write reviews and add photos to points of interest, etc.

New features for driving, including a new map where details such as traffic and incidents are highlighted, as well as an itinerary planner that lets you view a future journey by selecting departure or arrival time.
  
### Photos

The Photos app can now manually set the time and date of a photo. The app also allows the user to view information about the photo such as the camera used to take the photo and the photo's file size. In the Photos app, the user can now look up places that are inside images, however, this feature only works on the Apple A12 chip and later.

### Camera

Improved panoramic shooting mode on iPhone 12 and above: less geometric distortion in panoramic shots with elongated fields of view, noise and banding reduction that are formed in the image due to changes in brightness and contrast when moving the camera from side to side other, a less blurry and clearer image even when capturing moving subjects within the panorama.

### Safari

Safari was completely redesigned, moving the tab bar and address bar to the bottom of the screen. It now has tab groups, allowing users to organize tabs and share entire groups of tabs. Browser extensions are available for the first time in Safari for iOS; they are the same extensions available in Safari for the Mac. Safari will automatically upgrade HTTP URLs to HTTPS if compatible. The WebM audio codec is supported.

Safari opens with a new start page; it is possible to have a custom page on startup that contains sections including favorites, most frequently visited sites Siri suggestions, etc.

App Clips more discoverable: it is possible to show a full-screen preview of the app clip in Safari.

### Weather

Weather received an overhaul, with new animations and weather maps in full screen, and the weather icon was updated.

Next-time precipitation notifications: you’ll get a notification whenever rain or snow is going to start or stop within the next hour for your current location and each saved location, independently.

### Siri

Siri now works offline, offering shorter response times for the most common requests that do not require an Internet connection. Requires A11 Bionic chip or later.

Share with Siri: you can finally just ask Siri “Hey Siri, share this with [name]” (or something similar like “send this to [name]”) and Siri will share the content on the screen to that person using Messages. Items like images, web pages, Apple Music or Podcasts, Apple News stories, and Maps locations will share the actual content (or a link to it). For content Siri can’t share, it will warn you that it can only send a screenshot—but Siri will still automatically take that screenshot and drop it in a Message to that person.

Announce Notifications: with announce notifications update in iOS 15, Siri can now read all incoming notifications and even allow users to respond to them using their voice. The user can choose to enable this for specific apps.

### Health

Health data can now be shared.

A new monitored parameter called "Walking Steadiness" has been added, which determines the risk of falling using gyroscopic sensors that measure balance, stability and coordination.

Added the Trend analysis i.e. horizontal lines that show the trend of the various parameters over the long term.

Lab Results allows you to import laboratory results into the Health app from a healthcare provider.

### Files

Groups is a new view mode that groups files of the same type.

The built-in PDF editor can insert pages from existing files or scans, remove pages, and rotate pages. PDFs can also be locked with a password.

### Notes

New #tags allow classifying, organizing, then finding your notes faster. Smart Folders automatically group various notes based on tags. Ability to share notes with other collaborators and work on them together. The activity view shows a summary of the changes made by other collaborators before your last reading and a day-by-day list of the activities carried out by each collaborator. It is possible to mention @someone in the notes, who will be notified.

### Reminders

Ability to insert #tags in reminders to classify them.

### Shortcuts

Sound recognition has been added to the automations, so it's possible to execute a customized command when a certain sound is recognized.

### Wallet

Keys: iPhone is able to unlock select HomeKit-enabled smart locks. Requires an iPhone with an A12 chip or newer.

Identification cards and driver licenses: iPhone can store a copy of a U.S. user's state-issued identity card or driver license. Arizona, Georgia, Connecticut, Iowa, Kentucky, Maryland, Oklahoma and Utah will be the first states to support the feature.
 
## Security and privacy

### App Privacy Report

By activating this app logging, the user can save a 7-day summary of the times when the various apps access certain data and the domains or websites they visit.

### Siri improved privacy

On devices with an Apple A12 Bionic system on a chip or newer, Siri now converts audio into words on the device itself instead of sending it to Apple servers.
Hide my IP for Trackers in Safari

Safari's anti-tracking now prevents known trackers from reading your real IP address

### Hide my IP for External Content in Mail

In the Mail app, you can enable the setting to hide your IP address when downloading external content that may be present in a mail message. In this way it is possible to privately download this external content without being tracked by spammers or commercial companies that have inserted them without the user's knowledge.

### Hide My Email

Hide My Email creates random email addresses that forward to the inbox so e-mail can be sent and received anonymously.

### iCloud Private Relay

Private Relay masks the user's IP address in Safari, preserving the region without revealing the actual location. It also protects the DNS query resolution and insecure HTTP traffic in all apps.

### Built-in one-time password authenticator With Autofill

The built-in authenticator allows iOS devices to be used to generate verification codes for additional sign-in security of accounts. There is no need to download a separate app because it is integrated into the OS. The verification codes are automatically filled when a user signs in to the site.

### WPA3 Hotspot

Hotspot connections now can also use the WPA3 security protocol.

### CSAM detection

CSAM detection identifies known Child Sexual Abuse Material (CSAM) in iCloud Photos accounts. This recognition is based on a perceptual hash called NeuralHash.

Siri and Search are also being updated to intervene when users perform searches for queries related to CSAM. The Messages app will warn children and their parents when receiving or sending sexually explicit photos, blurring sent and received photos.

### Other changes

New widgets have been added: Mail, Contacts, Game Center, Find My, App Store, Sleep.

[iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/) wallpapers were removed in the first beta of iOS 15.

iOS 15 features a new wallpaper in two modes: light and dark.

SharePlay is removed and disabled in iOS 15. SharePlay is not working yet in iOS 15, but will be re-enabled in [iOS 15.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/).

The 'Other' storage has been renamed to 'System Data'

## Supported devices

All the devices supporting [iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/) and [iOS 14](https://github.com/seanpm2001/WacOS/wiki/iOS-14/) also support iOS 15. The following is a list of devices that support iOS 15:

### iPhone

iPhone 6S

iPhone 6S Plus

iPhone 7

iPhone 7 Plus

iPhone 8

iPhone 8 Plus

iPhone X

iPhone XS

iPhone XS Max

iPhone XR

iPhone 11

iPhone 11 Pro

iPhone 11 Pro Max

iPhone SE (1st generation)

iPhone SE (2nd generation)

iPhone 12 Mini

iPhone 12

iPhone 12 Pro

iPhone 12 Pro Max

iPhone 13 Mini

iPhone 13

iPhone 13 Pro

iPhone 13 Pro Max

### iPod Touch

iPod Touch (7th generation)

***

## Sources

[Wikipedia - iOS 15](https://en.wikipedia.org/wiki/IOS_15/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Monday September 27th at 10:37 pm`

**Last revised on:** `2021 Monday September 27th at 10:37 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `391`

**Article version:** `1 (2021 Monday September 27th at 10:37 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

