  
***

# iOS 14

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 14 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/14/IOS_14_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/14/IOS_14_logo.svg)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/14/IPhone_12_iOS_14_Homescreen.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/14/IPhone_12_iOS_14_Homescreen.png)

( **Predecessor:** [iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/) / [iPadOS 13](https://github.com/seanpm2001/WacOS/wiki/iPadOS-13/) | **iOS 14** | **Successor:** [iOS 15](https://github.com/seanpm2001/WacOS/wiki/iOS-15/) )

**As of 2021 September 27th, iOS 12 and later are still supported and are receiving updates. The data here will need to be updated in the future.**

iOS 14 is the fourteenth major release of the [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) mobile operating system developed by Apple Inc. for their iPhone and iPod Touch lines. Announced at the company's Worldwide Developers Conference on June 22, [2020](https://github.com/seanpm2001/WacOS/wiki/2020/) as the successor to [iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/), it was released to the public on September 16, [2020](https://github.com/seanpm2001/WacOS/wiki/2020/). It was succeeded by [iOS 15](https://github.com/seanpm2001/WacOS/wiki/iOS-15/) on [September 20, 2021](https://github.com/seanpm2001/WacOS/wiki/2021/).

## History

### Updates

The first developer beta of iOS 14 was released on June 22, 2020 and the first public beta was released on July 9, 2020. The final beta, iOS 14 beta 8, was released on September 9, 2020. iOS 14 was officially released on September 16, 2020. There was no public beta testing of 14.1.

Version 	Build 	Release date 	Notes

14.0 	18A373 	September 16, 2020 	Initial release

14.0.1 	18A393 	September 24, 2020 	Bug fixes, including for an issue that could cause default browser and mail settings to reset after restarting the device

14.1 	18A8395 	October 20, 2020 	Initial release for the iPhone 12 and the iPhone 12 Pro

Updates to widgets, App Library, and incoming phone calls with Siri. Also includes pinned conversations, Memoji improvements, cycling directions, and App Clips

14.2 	18B92 	November 5, 2020 	Introduces a Shazam toggle in Control Center, revamped media controls, face detection in the Magnifier app, over 100 new emoji and eight new wallpapers in dark and light mode

18B111 	November 18, 2020 	Bugfix release for iPhone 12 and iPhone 12 Pro models onl

14.2.1 	18B121 	November 19, 2020 	Bugfix release for iPhone 12 and iPhone 12 Pro models only

Fixes missing Messages notifications

14.3 	18C66 	December 14, 2020 	Apple Fitness+ support for final release

New Apple TV app UI

Apple ProRAW for iPhone 12 Pro models

14.4 	18D52 	January 26, 2021 	Smaller QR codes can be recognized by Camera

Option to classify Bluetooth device type in Settings for correct identification of headphones for audio notifications

Notifications for when the camera on your iPhone is unable to be verified as a new, genuine Apple camera in iPhone 12, iPhone 12 mini, iPhone 12 Pro and iPhone 12 Pro Max

14.4.1 	18D61 	March 8, 2021 	Bug fixes, including an issue which may cause arbitrary code execution or memory corruption

14.4.2 	18D70 	March 26, 2021 	Security fixes

14.5 	18E199 	April 26, 2021 	UI tweaks for the Podcasts app

New interface for typing with Siri and sending messages with Siri

Support for using the Xbox Series S/X and PlayStation 5 controllers

Support for unlocking an iPhone with Apple Watch while wearing a face mask

New UI for Software Update in Settings

Full release date for songs in Apple Music

App Tracking Transparency goes live

2 new/improved Siri voices

Dual-SIM 5G support/T-Mobile standalone 5G

New emoji characters

14.5.1 	18E212 	May 3, 2021	App Tracking Transparency bug fix and security update

14.6 	18F72 	May 24, 2021	Spatial Audio with Dolby Atmos and Lossless Audio for Apple Music

You can now enter an email address as a contact method for lost AirTags

Apple Podcasts subscriptions

Apple Card Family support

14.7 	18G69 	July 19, 2021 	AQI feature in Weather app extended to Canada, France, Italy, Netherlands, South Korea and Spain

MagSafe Battery Pack support for iPhone 12, iPhone 12 mini, iPhone 12 Pro and iPhone 12 Pro Max

Home app adds the ability to manage timers on HomePod

Podcasts library allows you to choose to see all shows or only followed shows

Share playlist menu option missing in Apple Music

Dolby Atmos and Apple Music lossless audio playback may unexpectedly stop

Battery service message that may have disappeared after reboot on some iPhone 11 models is restored

Braille displays could show invalid information while composing Mail messages

14.7.1 	18G82 	July 26, 2021 	Fixes an issue where iPhone models with Touch ID cannot unlock a paired Apple Watch using the Unlock with iPhone feature.

Security fixes

14.8 	18H17 	September 13, 2021 	Security fixes

Legend:   Past   Current   Beta

## System features

### App Clips

App Clips are a new feature expanding on the functionality of the App Store. Intended as a dynamic feature rather than a permanently installed app, App Clips are extremely pared-back with very few OS permissions. At the time of the announcement, only the use of Apple Pay and Sign in with Apple were shown.

App Clips may be discovered in person via NFC tags (iPhone 7 or newer) or QR codes with App Clips branding. They may also be shared via Messages, or placed on websites or Maps.

### CarPlay

CarPlay was updated to allow users to set a built-in wallpaper. Route management in Apple Maps was extended with features alerting the user to available stops, such as parking and food ordering. Additionally, route planning for electric vehicles now considers the location of charging stations.

### Car keys

Car keys allow an iPhone to act as a virtual car key using NFC technology with compatible cars. The first compatible car showcased by Apple at the WWDC 2020 was the 2021 BMW 5 Series. Keys are accessible from the Wallet app. Keys may be shared; sharing may be temporary or given restrictions. In the event the iPhone is out of battery, car keys can still be accessed via the power reserve of the iPhone for about five hours. Car keys require an iPhone released in 2018 or later.

### Home screen

Unlike previous versions, in which icons on the home screen were rearranged in order and corresponded directly to apps, users may add app icons and newly-introduced app widgets; pages may be added or deleted at will. This allows users to hide infrequently used apps and avoid clutter.

### Widgets

To the left of the first page, the Today View is replaced by a scrollable widget UI. Widgets may be placed on the home screen to sit amongst app icons; they may be resized to two-by-two, horizontal two-by-four, or four-by-four icons. Widgets of the same size may be stacked over each other and swiped between for convenience; a Smart Stack may be placed which automatically shows the most relevant widget to the user based on the time of day.

### App Library

To the right of the last page, the App Library lists and categorizes apps installed on the device. Apps within each category are arranged based on the frequency of their usage. In addition to a category for suggested apps, a "recent" category lists apps recently installed alongside App Clips recently accessed. Users can search for the app they want or browse them in alphabetical order.

### Compact UI

A series of changes were made in iOS 14 to reduce the visual space taken by previously full-screen interfaces; such interfaces now appear and hover in front of an app, allowing for touch (and therefore multitasking) on the app behind. Voice calling interfaces, including Phone, or other third-party apps such as Skype, are made substantially thinner, taking approximately as much space as a notification. Siri's interface is now also compact.

Picture-in-picture allows users to continue watching video playback (or take voice calls, such as with FaceTime) in a thumbnail-sized view after leaving the app. This view may be resized with pinch gestures, or moved off-screen temporarily and re-summoned for multitasking. Picture-in-picture is currently supported by Safari and FaceTime, along with several third-party apps, including Disney+, ESPN, HBO Max, Netflix, and Amazon Prime Video. This feature was not available in the YouTube app at launch; Google subsequently announced that picture-in-picture will be supported on YouTube in a forthcoming update, but only for subscribers to YouTube Premium.

### Search and Siri

Improvements to the Search feature on the home screen were made, including a refined UI, quick launcher for apps, more detailed web search, shortcuts to in-app search, and improved as-you-type search suggestions.

While made compact so that content below is visible, Siri's interface does not allow for simultaneous multitasking, as designers felt it unclear how the interface would then be dismissed. Siri can now answer a broader set of questions and translate more languages. Users can also share their ETA with contacts and ask for cycling directions.

## Security and Privacy

### App Store

On iOS 14.3 and later, the App Store now displays the permissions required for each application (so users can see and understand permissions required by the application prior to downloading it). Users may change location permissions to inform the app of an approximate location, preserving privacy when exact location is unnecessary.

### Notifications for microphone, camera, and clipboard usage

A recording indicator appears at the top of the screen whenever an app uses the microphone (orange dot indicator) or camera (green dot indicator). Likewise, a notification appears when the clipboard is accessed by an app.

### Application Tracking Transparency

Apps must request the user consent if they intend to track user activities across apps and websites.

During the iOS 14 announcement, Apple pledged to improve users' privacy by limiting apps' access to Apple's Identifier for Advertisers (also known as IDFA or Advertising Identifier). This change was postponed "until early 2021 in iOS/iPadOS 14.5" to let developers migrate to more privacy-friendly alternatives. Facebook has notably opposed such privacy measures, arguing that small businesses need to access user data for targeted advertising. Statistics from Verizon subsidiary Flurry Analytics show after iOS 14.5 was released, only 11-12% of all consumers and 4% of American consumers have allowed Facebook to track them, in what has been described as a "nightmare" for Facebook.

### Wi-Fi MAC address randomization

To limit tracking and improve privacy, devices now use a different MAC address for each Wi-Fi network instead of using the physical device Wi-Fi MAC address.

### Local network restriction

A new privacy option can restrict certain applications from discovering and interacting with other devices on a home network through Bonjour or other network protocols.

### Other internal security changes

One of the major changes in iOS 14 is the introduction of a new, tightly sandboxed 'BlastDoor' service which is now responsible for almost all parsing of untrusted data in iMessages. BlastDoor inspects all inbound messages in a secure, sandboxed environment, which prevents any malicious code inside of a message from interacting with the rest of the operating system or accessing user data. A specially-crafted message sent to a target can no longer interact with the file system or perform network operations.

If the camera module is not detectable as genuine Apple component, the system will warn the user.

### ARKit 4

ARKit 4 introduced Depth API for new access to depth information from the LiDAR sensors on the iPhone 12 Pro. ARKit 4 also introduced Location Anchor, which uses data from Apple Maps and enables augmented reality experiences to be placed on geographical coordinates and other smaller improvements.

### MagSafe

iOS 14 adds MagSafe accessory support for the iPhone 12 lineup, with a new animation for each accessory.

### Other changes

The Emoji keyboard was updated with a search function. iOS 14 adds 20 new hair and headwear styles to Memoji and Animoji, including face mask options for Memoji.

The user's email and browser apps – by default the stock Mail app and Safari – may now be changed.

On iPhones released in 2017 and later (iPhone 8 and 8 Plus, iPhone X), a new accessibility feature allows users to perform common tasks by double-tapping the back of the device via the phone’s accelerometer (e.g. opening Control Center or running a shortcut).

Users with devices that do not automatically read NFC tags may add a shortcut on the Control Center to do so.

iOS 14 introduces support for the VP9 codec, allowing playback of YouTube videos in 4K resolution. In Safari, VP9 support is enabled through WebRTC, which is disabled by default.

In the Notes app, it is now easier to find notes using an improved "on-device intelligence." The skeuomorphic paper texture in the app has also been removed.

The Weather app now shows an air quality index and minute-by-minute forecasts for the next hour in the United States. Apple now uses data from their recently acquired service Dark Sky instead of only The Weather Channel.

Apple Arcade now has direct integration with Game Center.

The scroll wheel picker used for time has been reduced in size with the option to use a number pad.

A new Accessibility feature, called Sound Recognition, allows iPhones to listen for predefined sounds and issue an alert whenever the specific audio is detected. This way an iPhone can detect fire, various sirens, animals, multiple household noises, and a baby that's crying or someone that's shouting.

The Music icon was redesigned with a red gradient, similar to the icon used in iOS 7 through 8.3.

The iOS 12 wallpaper was removed, and eight new wallpapers were added in iOS 14.2.

Magnifier is now a separate app that can be accessed outside of the Control Center.

People Detection was added in Measure on iOS 14.2.

Unlock iPhone equipped with Face ID by Apple Watch while wearing a face mask on iOS 14.5 and watchOS 7.4.

## App features

### Calendar

The Calendar app now supports a Julian calendar format for years earlier than October 15, 1582 and the Calendar app icon now uses abbreviated names for the days of the week.

### Camera

The Camera app gained several new features. Features include:

The ability to mirror photos taken from the front camera on iPhone XS and later.

QR code reading enhancements.

Exposure compensation control on iPhone 11 and iPhone SE (2nd generation) and later.

Quick toggles in Video mode to change resolution and frame rate for all iPhones. Previously, this feature was limited to the iPhone 11 and iPhone 11 Pro.

QuickTake video function for iPhone XR and iPhone XS.

Camera UI from iPhone 11 and iPhone 11 Pro for the iPhone XR and the iPhone XS.

The ability to capture burst photos and QuickTake video with volume buttons on supported devices.
 
An updated Night mode capture experience on the iPhone 11 and iPhone 11 Pro.

Improvements were also made in shot-to-shot performance. According to Apple, photos can be shot up to 90% faster, time to first shot is now up to 25% faster, and Portrait shot-to-shot is up to 15% faster.

### FaceTime

On iPhone XS and later, FaceTime now automatically adjusts the visual appearance of eyes to account for the camera being above where a caller's eyes are displayed, allowing for direct two-way eye contact. Additionally, if a caller is using sign language in a call with multiple people, their window will be focused on accordingly.

FaceTime on iPhone XS and later now supports 1080p video on Wi-Fi. iOS [14.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) added support for 1080p FaceTime video on iPhone 8 and later on Wi-Fi, and for 5G and Wi-Fi on iPhone 12.

FaceTime now supports picture-in-picture mode. This allows users to continue seeing the other person while multitasking between other apps. Double tapping on the FaceTime window allows for the size to be changed to small, medium, or large. A single tap expands the window back to full screen.

### Home

The Home app received design changes to emphasize suggested accessories alongside those marked as favorite. In addition, a major set of automation capabilities were added for use with compatible HomeKit devices; this automation requires the presence of an iPad, HomePod or Apple TV to facilitate on-device processing.

Home security cameras may be instructed to only alert the user of activity if it occurs in a preselected activity zone. In addition, facial recognition performed in Photos app may be used to alert based on recognized people, with additional integration for use with smart doorbells.

Smart lighting products that support color temperatures may be instructed to match a preset color temperature setting. As the presence of blue light is a major zeitgeber – a factor which influences the perception of time with regards to circadian rhythm – this feature is designed to encourage activity in the day and calmness in the morning and evening.

### Messages

In the Messages app, users can now pin up to nine individual conversations above other message threads.

Group chats using iMessage may be given a custom image, a Memoji, or an emoji. Users may now mention other users, and change notification settings to only be notified when explicitly mentioned. Messages may be replied to with inline replies, allowing for simultaneous conversation threads and see the replies in the general conversation or as a separate thread.

SMS filter: third-party apps that filter unwanted SMS from unknown senders can show the custom categories with which they classify these messages (e.g. transactions, promotions, spam) directly in the Messages app.

### Maps

Apple Maps will now give users access to cycling routes, providing information including elevation and stairs. It also provides users with multiple options, suggesting routes with less busy streets. Cycling directions will be available at launch in New York, Los Angeles, San Francisco, Shanghai, and Beijing. Apple announced they will continue to roll out their enhanced maps detail to countries beyond the United States, including Canada, the United Kingdom and Ireland, and more in the future.

Apple also introduced EV routing, which allows users to take charging stations into account while planning their route and choose a route where they will be able to recharge when they need to. This feature requires integration with the car. Apple is currently working with Ford and BMW to implement this feature with their electric vehicles.

Curated guides for various places around the world have been added, which suggest where to eat, shop, and explore.

Look Around (Binoculars symbol) allows you to see the real overview of the streets at 360 degrees and move between them.

### Safari

Safari, the default web browser in [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/), gained the ability to monitor passwords for data breaches and generate privacy reports for trackers on websites. Major improvements were made to [JavaScript](https://github.com/seanpm2001/WacOS/wiki/JavaScript/) performance.

A web page translation tool has been added to Safari in seven languages: English, Spanish, Simplified Chinese, French, German, Russian and Brazilian Portuguese. This feature was only available in the United States and Canada at launch, but has started rolling out to more countries since then.

### Translate

Introduced in iOS 14, the stock Translate app allows users to translate voice and text between 11 languages: English, Spanish, Mandarin Chinese, Japanese, Korean, Russian, German, French, Italian, Brazilian Portuguese, and Arabic. When rotated to landscape view, the app features an "attention mode," making it easier for someone to read a translation. It can be used during verbal conversations between speakers of different languages. The Translate app can auto-detect which of the two chosen languages is being spoken and convert it to the other language.

Improvements made to translation are integrated with Siri, and pages may be translated inline in Safari.

## Supported devices

All the devices that supported [iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/) also support iOS 14.

### iPhone

iPhone 6S

iPhone 6S Plus

iPhone SE (1st generation)

iPhone 7

iPhone 7 Plus

iPhone 8

iPhone 8 Plus

iPhone X

iPhone XS

iPhone XS Max

iPhone XR

iPhone 11

iPhone 11 Pro

iPhone 11 Pro Max

iPhone SE (2nd generation)

iPhone 12 Mini

iPhone 12

iPhone 12 Pro

iPhone 12 Pro Max

### iPod Touch

iPod Touch (7th generation)

***

## Sources

[Wikipedia - iOS 14](https://en.wikipedia.org/wiki/IOS_14/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Monday September 27th at 10:19 pm`

**Last revised on:** `2021 Monday September 27th at 10:19 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `379`

**Article version:** `1 (2021 Monday September 27th at 10:19 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

