  
***

# iOS 13

<!-- <details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 13 logo</p></summary> !-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/13/IOS_13_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/13/IOS_13_logo.svg)

<!-- </details> !-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/13/IOS_13_Homescreen_iPhone_X.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/13/IOS_13_Homescreen_iPhone_X.png)

( **Predecessor:** [iOS 12](https://github.com/seanpm2001/WacOS/wiki/iOS-12/) | **iOS 13** | **Successor:** [iOS 14](https://github.com/seanpm2001/WacOS/wiki/iOS-14/) )

**As of 2021 September 27th, iOS 12 and later are still supported and are receiving updates. The data here will need to be updated in the future.**

iOS 13 is the thirteenth major release of the [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) mobile operating system developed by Apple Inc. for their iPhone, iPod Touch, and HomePod lines. The successor to [iOS 12](https://github.com/seanpm2001/WacOS/wiki/iOS-12/) on those devices, it was announced at the company's Worldwide Developers Conference (WWDC) on June 3, [2019](https://github.com/seanpm2001/WacOS/wiki/2019/), and released on September 19, [2019](https://github.com/seanpm2001/WacOS/wiki/2019/). It was succeeded by [iOS 14](https://github.com/seanpm2001/WacOS/wiki/iOS-14/), released on September 16, [2020](https://github.com/seanpm2001/WacOS/wiki/2020/).

As of iOS 13, the iPad lines run a separate operating system, derived from [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/), named [iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/). Both [iPadOS 13](https://github.com/seanpm2001/WacOS/wiki/iPadOS-13/) and iOS 13 dropped support for devices with less than 2 GB of RAM.

## History

### Introduction and initial release

iOS 13 and [iPadOS 13](https://github.com/seanpm2001/WacOS/wiki/iPadOS-13/) were introduced by Senior Vice President of Software Engineering Craig Federighi at the WWDC keynote address on June 3, [2019](https://github.com/seanpm2001/WacOS/wiki/2019/).

The first beta was made available to registered developers after the keynote. The second beta was released to registered developers on June 18, [2019](https://github.com/seanpm2001/WacOS/wiki/2019/), and the first public beta was released on June 24, [2019](https://github.com/seanpm2001/WacOS/wiki/2019/). The initial release of iOS 13 was version 13.0, which was released to the public on September 19, [2019](https://github.com/seanpm2001/WacOS/wiki/2019/).

### Updates

Version 	Build 	Release date 	Notes

13.0 	17A577 	September 19, 2019 	Initial release only on iPhones

13.1 	17A844 	September 24, 2019 	Initial release for iPod Touch and HomePod

13.1.1 	17A854 	September 27, 2019 	Bug fixes

13.1.2 	17A860

17A861[a] 	September 30, 2019	Bug fixes

13.1.3 	17A878 	October 15, 2019	Bug fixes

13.2 	17B84 	October 28, 2019 	Bug fixes

13.2.1 	17B90 	October 30, 2019	HomePod only

13.2.2 	17B102 	November 7, 2019 	Bug fixes, including for an issue that terminated background applications earlier than expected

13.2.3 	17B111 	November 18, 2019	Bug fixes

13.3 	17C54 	December 10, 2019 	Introduces communication limits for Screen Time and bug fixes

13.3.1 	17D50 	January 28, 2020 	Bug fixes

13.4 	17E255 	March 24, 2020 	Introduces iCloud Drive Folder Sharing and bug fixes

17E8255 	April 15, 2020	Initial release on the iPhone SE (2nd generation)

13.4.1 	17E262 	April 7, 2020 	Bug fixes

17E8258 	April 23, 2020 	iPhone SE (2nd generation) only

13.5 	17F75 	May 20, 2020 	Introduces Exposure Notification API support for contact tracing and bug fixes

13.5.1 	17F80 	June 1, 2020 	Bug fixes and patch for unc0ver jailbreak

13.6 	17G68 	July 15, 2020	Introduces Apple News+ Audio features and bug fixes

13.6.1 	17G80 	August 12, 2020 	Bug fixes

13.7 	17H35 	September 1, 2020 	Improvements to Exposure Notification API, adding support for notifications without requiring an application[c]

Legend:   Past   Current   Beta

iPhone X, iPhone XS, iPhone XS Max only

A different build of [iOS 13.4 (17E8255)](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) was shipped only with the iPhone SE (2nd generation), thus making the theoretical release date the same as the SE (2nd) itself. This build is also unavailable for download.

It is still necessary to have an authorized application to report positivity to COVID-19.

## System features

### Privacy

iOS 13 changes the handling of location data. When an app requests access to location, the user chooses whether to grant access whenever they are using the app, never, or only once. The user will receive similar prompts for background location access, and when an app requests access to Bluetooth or Wi-Fi (which may also be used for non-consensual location tracking).

In August 2019, it was reported that beginning in April 2020, the PushKit API for VoIP would be restricted to internet telephone usage, closing a "loophole" that had been used by other apps for background data collection.

### User interface

A system-wide dark mode allows users to enable a light-on-dark color scheme for the entire iOS and iPadOS user interface, all native applications, and supported third-party apps. It can be manually turned on or set to automatically switch between light and dark modes based on the time of day.

The volume indicator was redesigned, replacing the larger, centered overlay with a slimmer bar shown vertically near the volume keys in portrait orientation, or at the top in landscape. The bar can also be manipulated directly.

The card UI elements from Apple Music, Apple Podcasts, and Apple Books has been implemented system-wide, being an option for third-parties to use in their apps.

### Siri

Siri uses a software-generated voice called "Neural TTS", intended to sound more natural than previous versions that use clips of human voices. Siri also became more functional and new sound control is available. The Siri Shortcuts app is installed by default. Siri also uses HomePod to learn and recognize voices of different people. It is also possible for Siri to automatically read incoming messages aloud on AirPods.

### Keyboard

The QuickType virtual keyboard features QuickPath, allowing the user to swipe their finger across the keyboard to complete words and phrases. This functionality was previously exclusively available via third-party keyboard applications such as SwiftKey, Adaptxt, Gboard, or Swype. Emoji stickers have been included on the emoji keyboard and can be used wherever regular emoji can be.

### Text editing

iOS 13 and [iPadOS 13](https://github.com/seanpm2001/WacOS/wiki/iPadOS-13/) add a new system-wide gesture interface for cut, copy, paste, undo, and redo. A three-finger swipe left or up will undo; three fingers right or down will redo. A single three-finger pinch will copy, a second three-finger pinch will cut, and a three-finger spread pastes. A three-finger single tap will bring up a shortcut menu with all five options.

The blue text cursor can be moved around text fields by pressing and holding to pick it up and move it. Many new options for text selection have also been added: double-tapping a word will select it, triple-tapping selects a sentence, and quadruple-tapping a paragraph selects it.

### Sign in with Apple

A new single sign-on service known as "Sign in with Apple" is integrated with iOS 13, and allows users to create accounts for third-party services with a minimal amount of personal information. Users may optionally generate a disposable email address for each account, improving privacy and anonymity, and reducing the amount of information that can be associated with a single email address.

All iOS applications that support third-party social login are required to implement Sign in with Apple, The iOS human interface guidelines also state that Sign in with Apple should be given prominence above any other login provider in application interfaces.

### Performance

iOS 13 contains several performance improvements. Face ID unlocks the iPhone X, XS / XS Max, and XR up to 30% faster than on iOS 12. A new file format makes app downloads as much as 50% smaller, app updates as much as 60% smaller, and app launches up to twice as fast.

### Battery lifespan extender

Similar to many laptops, iOS 13 has a feature to limit the battery charging percentage to 80%.

Keeping the battery percentage more centered instead of complete charges and discharges reduces strain onto the battery. This reduces the battery aging of the lithium-ion battery and extends its lifespan.

### Haptics

iOS 13 introduced a new Core Haptics framework. Prior to iOS 13, apps could only provide the default haptic patterns. Core Haptics gives developers more fine-grained control over the iPhone's Taptic Engine, including synchronized audio, allowing apps to provide customized haptic and audio feedback. This feature is only available on iPhone 8 or newer. It is also not supported on the iPod Touch due to the lack of a haptic motor in those devices.

### External storage

iOS 13 introduced the ability to connect to external USB drives. Although primarily designed for thumb drives and hard drives, a wide variety of USB disk devices will work, thanks to the [iOS's](https://github.com/seanpm2001/WacOS/wiki/iOS/) support of the SCSI subclass of USB Mass Storage. Native SCSI disk devices will work as well, when used with a SCSI to USB adapter.

### Exposure Notification API

On 20 May [2020](https://github.com/seanpm2001/WacOS/wiki/2020/), Apple released [iOS 13.5](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), which includes the Exposure Notification API that provides access to the Apple / Google privacy-preserving contact tracing system that Apple have developed jointly with Google. This is provided to support digital contact tracing which came to light during the COVID-19 pandemic.

### ARKit 3

ARKit 3 was released as a part of iOS 13 and brought new features, such as People occlusion which allowed AR objects to be in front or behind people in a more realistic way. New features were restricted to devices with A12 processors and newer – like iPhone XS, iPhone XR, and the 2018 iPad Pro. Other features of ARKit 3 were multiple face tracking and collaborative sessions.

### ARKit 3.5

Released with the 2020 iPad Pro, ARKit 3.5 vastly improved positioning in virtual environments due to new anchors and use of data from a LiDAR scanner. It also improved its motion capture and people occlusion.

### Other changes

The version of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) for iPad devices was renamed [iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/), reflecting the precedence for the OS to include additional features intended primarily for use on tablets.

iOS 13 adds official support for the Sony DualShock 4 and the Microsoft Xbox One controller. iOS 13 also adds support for wireless audio sharing for AirPods and certain Beats headphones.

A new multi-select gesture is available in supported applications such as Files and Mail. Multiple items, such as files or emails, can be quickly selected by dragging two fingers over the desired items.

## App features

### Messages and Memoji

User profiles can be created and Memoji can be used as an iMessage profile picture. All [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) devices with an A9 processor or newer can create custom Memoji. Memoji and Animoji can be used as a sticker in iMessage and other apps; they are also available as regular emoji for use anywhere the emoji keyboard is available. There are a variety of new customization options for Memoji.

### Maps

The Maps app features a redesigned maps UI, featuring more detailed maps, and Look Around, a street level imagery implementation similar to Google Street View.

### Reminders

Redesigned and rebuilt from the ground up with new features such as the ability to suggest when a reminder should be delivered to the user, and the ability to tag contacts so that references to reminders can be surfaced elsewhere, such as in Messages.

### Photos

The Photos app includes a redesigned UI and uses machine learning to auto-hide "clutter" images such as screenshots and documents.

Photos has a redesigned interface showing users photos they took in the past year, month, week and day. This brings all photos to one page and shows users photos based on what their device suggests for them.

## Problems

There were a number of issues following the release of iOS 13, some relating to battery drain, call-dropping, and ringtones not functioning properly, resulting in frequent software updates and patches. Despite the frequency of bug fix releases, the updates have introduced new issues.

Other issues included incorrect artwork for user's playlists. Users reported the artwork is repeated for some playlists or uses a different picture.

## Supported devices

iOS 13 requires 2 GB of RAM. It ended support for all iPhones and iPod touches using the Apple A7 and A8 SoC, as they shipped with 1 GB of RAM. Devices unable to support iOS 13 include the iPhone 5S, iPhone 6 / 6 Plus, and the sixth-generation iPod Touch.

To further differentiate features between iPhones and iPads, Apple rebranded the tablet-oriented platform with its own operating system, [iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/).

### iPhone

iPhone 6S

iPhone 6S Plus

iPhone SE (1st generation)

iPhone 7

iPhone 7 Plus

iPhone 8

iPhone 8 Plus

iPhone X

iPhone XS

iPhone XS Max

iPhone XR

iPhone 11

iPhone 11 Pro

iPhone 11 Pro Max

iPhone SE (2nd generation)

### iPod Touch

iPod Touch (7th generation)
	
### HomePod

HomePod

***

## Sources

[Wikipedia - iOS 13](https://en.wikipedia.org/wiki/IOS_13/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Monday September 27th at 10:04 pm`

**Last revised on:** `2021 Monday September 27th at 10:04 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `263`

**Article version:** `1 (2021 Monday September 27th at 10:04 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

