
***

# Welcome to the WacOS wiki!

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Branding/Old/WACOS_LogoPrototype1.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Branding/Old/WACOS_LogoPrototype1.png)

_This is the home page of the Wiki. It is not to be confused with the [WacOS Home directory](https://github.com/seanpm2001/WacOS/wiki/Home(Directory))._

General description of WacOS: 

```plain-text
A Linux distribution that mimics MacOS (modern and classic) iOS, and other Apple operating systems, but is open, customizable, and free to use on non-apple hardware. 
```

WacOS is an open source replacement project for all versions of MacOS, iOS, iPhoneOS, TvOS, WatchOS, and all Apple software.

This Wiki is a glossary of Apple terms, alongside info on how it aligns with WacOS and how well it is supported/its re-development history.

Currently, a lot of articles are based of their Wikipedia counter-parts, being mirrored here, and reformatted in markdown with special details. A lot of articles here need lots of work, it is still good to have them all in one place.

## Start here

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Branding/Old/LogoPrototype1.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Branding/Old/LogoPrototype1.png)

[Read the rules for editing this Wiki](https://github.com/seanpm2001/WacOS/wiki/!All_Rules)

[WacOS and ElementaryOS, 2 good choices](https://github.com/seanpm2001/WacOS/wiki/ElementaryOS/)

## All articles:

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacWrite/MacWrite-software-icon.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacWrite/MacWrite-software-icon.png)

4 articles total (excluding home page)

[Image Credits (Apple)](https://github.com/seanpm2001/WacOS/wiki/ImageCredits(Apple))

[Finder (Application)](https://github.com/seanpm2001/WacOS/wiki/Finder-(application))

[Home (directory)](https://github.com/seanpm2001/WacOS/wiki/Home(Directory))

[Swift (programming language)](https://github.com/seanpm2001/WacOS/wiki/Swift-(programming-language))

List incomplete

## Categories

### General

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacWrite/MacWrite-software-icon.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacWrite/MacWrite-software-icon.png)

[WacOS and ElementaryOS, 2 good choices](https://github.com/seanpm2001/WacOS/wiki/ElementaryOS/)

### Desktop environment

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Aqua/Leopard_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Aqua/Leopard_Desktop.png)

[WacOS Desktop environment](https://github.com/seanpm2001/WacOS/wiki/WacOS_DE/)

> [Skeuowie, the desktop environment WacOS modified](https://github.com/seanpm2001/WacOS/wiki/Skeuowie/)

[Aqua (User Interface)](https://github.com/seanpm2001/WacOS/wiki/Aqua_(User_Interface)/)

### Processor support

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/AMD/AMD_Logo1.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/AMD/AMD_Logo1.png)

( [AMD Processor support](https://github.com/seanpm2001/WacOS/wiki/AMD_Processor_Support) | [Intel Processor support](https://github.com/seanpm2001/WacOS/wiki/Intel_Processor_Support) | [PowerPC Processor support](https://github.com/seanpm2001/WacOS/wiki/PowerPC_Processor_Support) )

<details>
	<summary><H4>Click/tap here to expand/collapse the list dropdown</H4></summary>

[AMD Processor support](https://github.com/seanpm2001/WacOS/wiki/AMD_Processor_Support)

[Intel Processor support](https://github.com/seanpm2001/WacOS/wiki/Intel_Processor_Support)

[PowerPC Processor support](https://github.com/seanpm2001/WacOS/wiki/PowerPC_Processor_Support)

</details>

### Common sources

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Apple_Logo/AppleLogo2011.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Apple_Logo/AppleLogo2011.png)

( [Wikipedia, the Free Encyclopedia at en.wikipedia.org](https://en.wikipedia.org/) | [Rosetta Code](https://github.com/seanpm2001/WacOS/wiki/RosettaCode/) | [Opensource.Apple.com](https://opensource.apple.com/) | [Developer.Apple.com](https://developer.apple.com/opensource/) | [Apple.com](https://www.apple.com/) )

<details>
	<summary><H4>Click/tap here to expand/collapse the list dropdown</H4></summary>

[Wikipedia, the Free Encyclopedia at en.wikipedia.org](https://en.wikipedia.org/)

[Rosetta Code](https://github.com/seanpm2001/WacOS/wiki/RosettaCode/)

[Opensource.Apple.com](https://opensource.apple.com/)

[Developer.Apple.com](https://developer.apple.com/opensource/)

[Apple.com](https://www.apple.com/)

</details>

### People

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Steve_Jobs/Steve_Jobs_Headshot_2010-CROP_(cropped_2).jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Steve_Jobs/Steve_Jobs_Headshot_2010-CROP_(cropped_2).jpg)

[Isaac Newton](https://github.com/seanpm2001/WacOS/wiki/Isaac_Newton/)

[Steve Jobs (link coming soon)](https://github.com/seanpm2001/WacOS/wiki/)

[Steve Wozniak (link coming soon)](https://github.com/seanpm2001/WacOS/wiki/)

[Dennis Ritchie (link coming soon)](https://github.com/seanpm2001/WacOS/wiki/)

[Seanpm2001](https://github.com/seanpm2001/) [Seanpm2001 (link coming soon)](https://github.com/seanpm2001/WacOS/wiki/)

### Special Extras

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacWrite/MacWrite-software-icon.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacWrite/MacWrite-software-icon.png)

["Twentieth Century" WACintosh, WAC or WAMMY](https://github.com/seanpm2001/WacOS/wiki/WAMMY/)

### Programming languages

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/C%2B%2B/ISO_C%2B%2B_Logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/C%2B%2B/ISO_C%2B%2B_Logo.svg)

( [See all languages used on this project](https://github.com/seanpm2001/WacOS/wiki/Languages_used/) | [Swift (programming language)](https://github.com/seanpm2001/WacOS/wiki/Swift-(programming-language)/) | [AppleScript](https://github.com/seanpm2001/WacOS/wiki/AppleScript/) | [Squeak](https://github.com/seanpm2001/WacOS/wiki/Squeak/) | [Objective-C](https://github.com/seanpm2001/WacOS/wiki/Objective-C/) | [Objective-C++](https://github.com/seanpm2001/WacOS/wiki/Objective-CPP/) | [C (Programming language)](https://github.com/seanpm2001/WacOS/wiki/C-(Programming-language)) | [YAML](https://github.com/seanpm2001/WacOS/wiki/YAML/) | [NewtonScript](https://github.com/seanpm2001/WacOS/wiki/NewtonScript/) | [Sir Isaac NewtonScript](https://github.com/seanpm2001/WacOS/wiki/Sir-Isaac-NewtonScript/) | XML | [Virtual Hard Disk Language (VHDL)](https://github.com/seanpm2001/WacOS/wiki/VHDL/) | [C++](https://github.com/seanpm2001/WacOS/wiki/C-Plus-Plus/) | [Self](https://github.com/seanpm2001/WacOS/wiki/Self/) | Prolog | PHP | JQuery | JavaScript | Ruby | Perl | [Python](https://github.com/seanpm2001/WacOS/wiki/Python/) | SQL | Shell (BASH) | [Pascal](https://github.com/seanpm2001/WacOS/wiki/Pascal/) | [Java](https://github.com/seanpm2001/WacOS/wiki/Java/) | GNU Make | SVG )

<details>
	<summary><H4>Click/tap here to expand/collapse the list dropdown</H4></summary>

[See all languages used on this project](https://github.com/seanpm2001/WacOS/wiki/Languages_used/)

[Swift (programming language)](https://github.com/seanpm2001/WacOS/wiki/Swift-(programming-language)/)

[AppleScript](https://github.com/seanpm2001/WacOS/wiki/AppleScript/)

[Squeak](https://github.com/seanpm2001/WacOS/wiki/Squeak/)

[Objective-C](https://github.com/seanpm2001/WacOS/wiki/Objective-C/)

[Objective-C++](https://github.com/seanpm2001/WacOS/wiki/Objective-CPP/)

[C (Programming language)](https://github.com/seanpm2001/WacOS/wiki/C-(Programming-language))

[YAML](https://github.com/seanpm2001/WacOS/wiki/YAML/)

[NewtonScript](https://github.com/seanpm2001/WacOS/wiki/NewtonScript/)

[Sir Isaac NewtonScript](https://github.com/seanpm2001/WacOS/wiki/Sir-Isaac-NewtonScript/)

XML

[Virtual Hard Disk Language (VHDL)](https://github.com/seanpm2001/WacOS/wiki/VHDL/)

[C++](https://github.com/seanpm2001/WacOS/wiki/C-Plus-Plus/)

[Self](https://github.com/seanpm2001/WacOS/wiki/Self/)

Prolog

PHP

JQuery

JavaScript

Ruby

Perl

[Python](https://github.com/seanpm2001/WacOS/wiki/Python/)

SQL

Shell (BASH)

[Pascal](https://github.com/seanpm2001/WacOS/wiki/Pascal/)

[Java](https://github.com/seanpm2001/WacOS/wiki/Java/

GNU Make

SVG

[Assembly](https://github.com/seanpm2001/WacOS/wiki/Assembly/)

Motorola S-Record

</details>

### Applications

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacWrite/MacWrite-software-icon.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacWrite/MacWrite-software-icon.png)

[Finder (Application)](https://github.com/seanpm2001/WacOS/wiki/Finder-(application))

**WacOS Equivalent:** currently unavailable

[MacWrite](https://github.com/seanpm2001/WacOS/wiki/MacWrite)

**WacOS Equivalent:** [WacWrite](https://github.com/seanpm2001/WacOS/wiki/WacWrite/)

[MacPaint](https://github.com/seanpm2001/WacOS/wiki/MacPaint)

**WacOS Equivalent:** [WacPaint](https://github.com/seanpm2001/WacOS/wiki/WacPaint)

[QuickTime](https://github.com/seanpm2001/WacOS/wiki/QuickTime)

**WacOS Equivalent:** currently unavailable

[Siri](https://github.com/seanpm2001/WacOS/wiki/Siri/)

**WacOS Equivalent:** [Kiri](https://github.com/seanpm2001/WacOS/wiki/Kiri/)

[MacOS server](https://github.com/seanpm2001/WacOS/wiki/MacOS-server/)

**WacOS Equivalent:** [WacOS Server](https://github.com/seanpm2001/WacOS/wiki/WacOS-server/)

#### Third party

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Growl/Growl.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Growl/Growl.png)

[Growl](https://github.com/seanpm2001/WacOS/wiki/Growl(Software))

WacOS Equivalent: None

### Features

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/DMG/Mac_OS_X_Disk_Image.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/DMG/Mac_OS_X_Disk_Image.png)

[DMG](https://github.com/seanpm2001/WacOS/wiki/DMG)

[IPA](https://github.com/seanpm2001/WacOS/wiki/IPA)

Linux

XNU

File systems

NOT LINKED

### Subsystems

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png)

[BaSYS](https://github.com/seanpm2001/WacOS/wiki/BaSYS/) - A subsystem for Classic Mac OS (versions 1.0 to 7.x prior to 7.5)

### Web browsers

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Safari/Safari_iOS6.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Safari/Safari_iOS6.png)

[Cyberdog](https://github.com/seanpm2001/WacOS/wiki/Cyberdog/)

[OpenCyberdog](https://github.com/seanpm2001/WacOS/wiki/OpenCyberdog/)

[Safari](https://github.com/seanpm2001/WacOS/wiki/Safari/)

[Savannah](https://github.com/seanpm2001/WacOS/wiki/Savannah/)

[Firefox](https://github.com/seanpm2001/WacOS/wiki/Firefox/)

[Internet Explorer for Mac](https://github.com/seanpm2001/WacOS/wiki/Internet_Explorer_for_Mac/)

* [Full browser list](https://github.com/seanpm2001/WacOS/wiki/Browser_list/)

### Standards to follow

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Acid/3/Acid3_reference.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Acid/3/Acid3_reference.png)

[Acid1](https://github.com/seanpm2001/WacOS/wiki/acid1)

[Acid2](https://github.com/seanpm2001/WacOS/wiki/acid2)

[Acid3](https://github.com/seanpm2001/WacOS/wiki/acid3)

[Computing longevity](https://github.com/Computing-longevity) [Wiki link unavailable](https://github.com/seanpm2001/WacOS/wiki/)

### File system and structure

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/APFS/APFS.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/APFS/APFS.png)

[Home (directory)](https://github.com/seanpm2001/WacOS/wiki/Home(Directory))

[Default File Systems in WacOS](https://github.com/seanpm2001/WacOS/wiki/Default_File_Systems/)

[Cloud support](https://github.com/seanpm2001/WacOS/wiki/Cloud/)

[Kernel](https://github.com/seanpm2001/WacOS/wiki/Kernel/)

[Languages used](https://github.com/seanpm2001/WacOS/wiki/Languages_used)

[Snapshots version control system](https://github.com/seanpm2001/WacOS/wiki/Snapshots-(version-control))

[Project language file](https://github.com/seanpm2001/WacOS/wiki/Project_Language_File/)

### Meta Wiki

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacWrite/MacWrite-software-icon.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacWrite/MacWrite-software-icon.png)

_Section renamed from `Wiki Meta` to `Meta Wiki` on 2021 Thursday September 23rd, as it produced a broken link, and ignored the word Wiki in the anchor link_

[_Footer](https://github.com/seanpm2001/WacOS/wiki/_Footer) - The footer of the Wiki, appears at the bottom of every page

[_Sidebar](https://github.com/seanpm2001/WacOS/wiki/_Sidebar) - The sidebar of the Wiki, under the pages section (which becomes a dropdown when you create the sidebar)

[.TODO](https://github.com/seanpm2001/WacOS/wiki/.TODO) - My main todo list for what to work on on this Wiki

[.Redirect](https://github.com/seanpm2001/WacOS/wiki/.Redirect) - A page to redirect you to the right article that you are looking for. I hope to automate this process in the future

[.TEMPLATE_Year](https://github.com/seanpm2001/WacOS/wiki/.TEMPLATE_Year) - A template used to make year articles faster

[!Collection_list_of_collections](https://github.com/seanpm2001/WacOS/wiki/!Collection_list_of_collections) - An article that lists all the collection articles on this Wiki.

[!Collection_list_of_Wiki_templates](https://github.com/seanpm2001/WacOS/wiki/!Collection_list_of_Wiki_templates) - A list article that lists all the Wiki templates on this Wiki

### Line of computers

#### Macintosh

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Macintosh/128K/Macintosh_128k_transparency.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Macintosh/128K/Macintosh_128k_transparency.png)

[Macintosh 128K](https://github.com/seanpm2001/WacOS/wiki/Macintosh_128K)

##### See also

[Macquarium](https://github.com/seanpm2001/WacOS/wiki/Macquarium/)

#### iPhone

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/IPhonelogo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/IPhonelogo.svg)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/2G/IPhone_1st_Gen.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhone/2G/IPhone_1st_Gen.svg)

_The iPhone is Apples flagship mobile touchscreen phone brand, starting in 2007 with the [iPhone 2G](https://github.com/seanpm2001/WacOS/wiki/iPhone-2G/)_

[iPhone 2G](https://github.com/seanpm2001/WacOS/wiki/iPhone-2G/)

[iPhone 3G](https://github.com/seanpm2001/WacOS/wiki/iPhone-3G/)

[iPhone 3GS](https://github.com/seanpm2001/WacOS/wiki/iPhone-3GS/)

[iPhone 4](https://github.com/seanpm2001/WacOS/wiki/iPhone-4/)

[iPhone 4S](https://github.com/seanpm2001/WacOS/wiki/iPhone-4S/)

[iPhone SE1 (Second Edition)](https://github.com/seanpm2001/WacOS/wiki/iPhone-SE1/)

[iPhone 5](https://github.com/seanpm2001/WacOS/wiki/iPhone-5/)

[iPhone 5S](https://github.com/seanpm2001/WacOS/wiki/iPhone-5S/)

[iPhone 6](https://github.com/seanpm2001/WacOS/wiki/iPhone-6/)

[iPhone 6 Plus](https://github.com/seanpm2001/WacOS/wiki/iPhone-6-Plus/)

[iPhone 6S](https://github.com/seanpm2001/WacOS/wiki/iPhone-6S/)

[iPhone 6S Plus](https://github.com/seanpm2001/WacOS/wiki/iPhone-6S-Plus/)

[iPhone 7](https://github.com/seanpm2001/WacOS/wiki/iPhone-7/)

[iPhone 7 Plus](https://github.com/seanpm2001/WacOS/wiki/iPhone-7-Plus/)

[iPhone 8](https://github.com/seanpm2001/WacOS/wiki/iPhone-8/)

[iPhone 8 Plus](https://github.com/seanpm2001/WacOS/wiki/iPhone-8-Plus/)

[iPhone SE2 (Second Edition)](https://github.com/seanpm2001/WacOS/wiki/iPhone-SE2/)

[iPhone X](https://github.com/seanpm2001/WacOS/wiki/iPhone-X/)

[iPhone XR](https://github.com/seanpm2001/WacOS/wiki/iPhone-XR/)

[iPhone XS](https://github.com/seanpm2001/WacOS/wiki/iPhone-XS/)

[iPhone XS Plus](https://github.com/seanpm2001/WacOS/wiki/iPhone-XS-Plus/)

[iPhone 12](https://github.com/seanpm2001/WacOS/wiki/iPhone-12/)

[iPhone 12 Mini](https://github.com/seanpm2001/WacOS/wiki/iPhone-12-Mini/)

[iPhone 12 Pro](https://github.com/seanpm2001/WacOS/wiki/iPhone-12-Pro/)

[iPhone 12 Pro Max](https://github.com/seanpm2001/WacOS/wiki/iPhone-12-Pro-Max/)

[iPhone 13](https://github.com/seanpm2001/WacOS/wiki/iPhone-13/)

[iPhone 13 Mini](https://github.com/seanpm2001/WacOS/wiki/iPhone-13-Mini/)

[iPhone 13 Pro](https://github.com/seanpm2001/WacOS/wiki/iPhone-13-Pro/)

[iPhone 13 Pro Max](https://github.com/seanpm2001/WacOS/wiki/iPhone-13-Pro-Max/)

#### iPod

##### Classic

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPod-Classic/IPodclassiclogo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPod-Classic/IPodclassiclogo.png)

_Classic iPods by Apple are portable audio players. It wasn't until the iPod touch that they gained touchscreen functionality, gestures, and the ability to do more than just play music._

[iPod Classic (1st generation)](https://github.com/seanpm2001/WacOS/wiki/iPod-Classic-1/)

[iPod Classic (2nd generation)](https://github.com/seanpm2001/WacOS/wiki/iPod-Classic-2/)

[iPod Classic (3rd generation)](https://github.com/seanpm2001/WacOS/wiki/iPod-Classic-3/)

[iPod Classic (4th generation)](https://github.com/seanpm2001/WacOS/wiki/iPod-Classic-4/)

[iPod Classic (5th generation)](https://github.com/seanpm2001/WacOS/wiki/iPod-Classic-5/)

[iPod Classic (6th generation)](https://github.com/seanpm2001/WacOS/wiki/iPod-Classic-6/)

[iPod Mini](https://github.com/seanpm2001/WacOS/wiki/iPod-Mini/)

[iPod Nano](https://github.com/seanpm2001/WacOS/wiki/iPod-Nano/)

[iPod Shuffle](https://github.com/seanpm2001/WacOS/wiki/iPod-Shuffle/)

##### Touch

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPod-Touch/IPodtouchlogo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPod-Touch/IPodtouchlogo.svg)

_The iPod touch is a brand of portable music players by Apple. They are nearly identical in functionality to an iPhone, with the exception that phone calls and cellular networks aren't accessible._

[iPod Touch (1st generation)](https://github.com/seanpm2001/WacOS/wiki/iPod-Touch-1/)

[iPod Touch (2nd generation)](https://github.com/seanpm2001/WacOS/wiki/iPod-Touch-2/)

[iPod Touch (3rd generation)](https://github.com/seanpm2001/WacOS/wiki/iPod-Touch-3/)

[iPod Touch (4th generation)](https://github.com/seanpm2001/WacOS/wiki/iPod-Touch-4/)

[iPod Touch (5th generation)](https://github.com/seanpm2001/WacOS/wiki/iPod-Touch-5/)

[iPod Touch (6th generation)](https://github.com/seanpm2001/WacOS/wiki/iPod-Touch-6/)

[iPod Touch (7th generation)](https://github.com/seanpm2001/WacOS/wiki/iPod-Touch-7/)

#### iPad

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPad/IPad_Logo_(2017).svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPad/IPad_Logo_(2017).svg)

_The iPad is a series of tablet computers by Apple Inc. starting with the 1st generation iPad on 2010 April 3rd._

[iPad (1st generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-1/)

[iPad (2nd generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-2/)

[iPad (3rd generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-3/)

[iPad (4th generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-4/)

[iPad (5th generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-5/)

[iPad (6th generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-6/)

[iPad (7th generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-7/)

[iPad (8th generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-8/)

[iPad (9th generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-9/)

##### iPad Air

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPad-Air/Apple_iPad_Air_Logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPad-Air/Apple_iPad_Air_Logo.svg)

_The iPad Air is a lightweight variant of the iPad tablet computer by Apple Inc. This series of models started with the 1st generation iPad Air on 2013 November 1st._

[iPad Air (1st generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-Air-1/)

[iPad Air (2nd generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-Air-2/)

[iPad Air (3rd generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-Air-3/)

[iPad Air (4th generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-Air-4/)

##### iPad Mini

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPad-Mini/IPad_Mini_logo_2019.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPad-Mini/IPad_Mini_logo_2019.svg)

_The iPad Mini is a much smaller variant of the iPad tablet computer by Apple Inc. This series of models started with the 1st generation iPad Mini on 2012 November 2nd._

[iPad Mini (1st generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-Mini-1/)

[iPad Mini (2nd generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-Mini-2/)

[iPad Mini (3rd generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-Mini-3/)

[iPad Mini (4th generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-Mini-4/)

[iPad Mini (5th generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-Mini-5/)

[iPad Mini (6th generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-Mini-6/)

##### iPad Pro

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPad-Pro/IPad_Pro_(2017-present%2C_logo).svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPad-Pro/IPad_Pro_(2017-present%2C_logo).svg)

_The iPad Pro is a premium variant of the iPad tablet computer by Apple Inc. intended for high power usage. This series of models started with the 1st generation iPad Pro on 2015 September 9th._

[iPad Pro (1st generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-Pro-1/)

[iPad Pro (2nd generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-Pro-2/)

[iPad Pro (3rd generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-Pro-3/)

[iPad Pro (4th generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-Pro-4/)

[iPad Pro (5th generation)](https://github.com/seanpm2001/WacOS/wiki/iPad-Pro-5/)

### Apple operating systems

#### MacOS

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS/MacOS_wordmark_(2017).svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS/MacOS_wordmark_(2017).svg)

_[MacOS](https://github.com/seanpm2001/WacOS/wiki/MacOS) is Apples infamous desktop operating system._

##### Classic

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Happy_Mac/Happy_Mac.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Happy_Mac/Happy_Mac.png)

[Classic MacOS version history](https://github.com/seanpm2001/WacOS/wiki/Classic-MacOS-version-history/)

[System 1](https://github.com/seanpm2001/WacOS/wiki/Apple-System-1)

[System 2](https://github.com/seanpm2001/WacOS/wiki/Apple-System-2)

[System 3](https://github.com/seanpm2001/WacOS/wiki/Apple-System-3)

[System 4](https://github.com/seanpm2001/WacOS/wiki/Apple-System-4)

[System 5](https://github.com/seanpm2001/WacOS/wiki/Apple-System-5)

[System 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6)

[System 7/MacOS 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/)

[MacOS 8](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-8/)

[MacOS 9](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-9/)

##### Mac OS X

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.4_Tiger/Macosx.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.4_Tiger/Macosx.png)

[Mac OS X version history](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-version-history/)

[Mac OS X 10.0 Public Beta](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-Public-Beta/)

[Mac OS X 10.0 (Cheetah)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/)

[Mac OS X 10.1 (Puma)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-1-Puma/)

[Mac OS X 10.2 (Jaguar)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-2-Jaguar/)

[Mac OS X 10.3 (Panther)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-3-Panther/)

[Mac OS X 10.4 (Tiger)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-4-Tiger/)

[Mac OS X 10.5 (Leopard)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-5-Leopard/)

[Mac OS X 10.6 (Snow Leopard)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-6-Snow-Leopard/)

##### OS X

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.6_Snow_Leopard/OSXLeopard.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.6_Snow_Leopard/OSXLeopard.svg)

[OS X version history](https://github.com/seanpm2001/WacOS/wiki/OS-X-version-history/)

[OS X 10.7 (Lion)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-7-Lion/)

[OS X 10.8 (Mountain Lion)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-8-Mountain-Lion/)

[OS X 10.9 (Mavericks)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-9-Mavericks/)

[OS X 10.10 (Yosemite)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-10-Yosemite/)

[OS X 10.11 (El Capitan)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-11-El-Capitan/)

##### MacOS Modern

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS/MacOS_wordmark_(2017).svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS/MacOS_wordmark_(2017).svg)

[Complete MacOS version history](https://github.com/seanpm2001/WacOS/wiki/Complete-MacOS-version-history/)

[Modern MacOS version history](https://github.com/seanpm2001/WacOS/wiki/Modern-MacOS-version-history/)

[MacOS 10.12 (Sierra)](https://github.com/seanpm2001/WacOS/wiki/MacOS-10-12-Sierra/)

[MacOS 10.13 (High Sierra)](https://github.com/seanpm2001/WacOS/wiki/MacOS-10-13-High-Sierra/)

[MacOS 10.14 (Mojave)](https://github.com/seanpm2001/WacOS/wiki/MacOS-10-14-Mojave/)

[MacOS 10.15 (Catalina)](https://github.com/seanpm2001/WacOS/wiki/MacOS-10-15-Catalina/)

[MacOS 11.0 (Big Sur)](https://github.com/seanpm2001/WacOS/wiki/MacOS-11-0-Big-Sur/)

[MacOS 12.0 (Monterey)](https://github.com/seanpm2001/WacOS/wiki/MacOS-12-0-Monterey/)

### iOS

#### iPhoneOS

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhoneOS/IPhone_OS_1_logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhoneOS/IPhone_OS_1_logo.png)

_[iPhoneOS](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS/) is a mobile operating system by Apple Inc, the predecessor to [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) and [iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/)._

[iPhoneOS version history](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-Version-History)

[iPhoneOS 1](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-1/)

[iPhoneOS 2](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-2/)

[iPhoneOS 3](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-3/)

##### Features

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhoneOS/IPhone_OS_2_Dock.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPhoneOS/IPhone_OS_2_Dock.png)

[iPhoneOS Dock](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-Dock/)

[iPhoneOS Wallpaper info](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-Wallpaper-info/)

#### Modern iOS

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_wordmark_(2017).svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_wordmark_(2017).svg)

_[iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) is a mobile operating system by Apple Inc._

[iOS version history](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/)

[iOS 4](https://github.com/seanpm2001/WacOS/wiki/iOS-4/)

[iOS 5](https://github.com/seanpm2001/WacOS/wiki/iOS-5/)

[iOS 6](https://github.com/seanpm2001/WacOS/wiki/iOS-6/)

[iOS 7](https://github.com/seanpm2001/WacOS/wiki/iOS-7/)

[iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/)

[iOS 9](https://github.com/seanpm2001/WacOS/wiki/iOS-9/)

[iOS 10](https://github.com/seanpm2001/WacOS/wiki/iOS-10/)

[iOS 11](https://github.com/seanpm2001/WacOS/wiki/iOS-11/)

[iOS 12](https://github.com/seanpm2001/WacOS/wiki/iOS-12/)

[iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/)

[iOS 14](https://github.com/seanpm2001/WacOS/wiki/iOS-14/)

[iOS 15](https://github.com/seanpm2001/WacOS/wiki/iOS-15/)

#### iPadOS

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPadOS/IPadOS_wordmark.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPadOS/IPadOS_wordmark.svg)

_[iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/) is a fork of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/)._

[iPadOS version history](https://github.com/seanpm2001/WacOS/wiki/iPadOS-version-history/)

[iPadOS 13](https://github.com/seanpm2001/WacOS/wiki/iPadOS-13/)

[iPadOS 14](https://github.com/seanpm2001/WacOS/wiki/iPadOS-14/)

[iPadOS 15](https://github.com/seanpm2001/WacOS/wiki/iPadOS-15/)

### tvOS

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/tvOS/TvOS.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/tvOS/TvOS.svg)

[tvOS version history](https://github.com/seanpm2001/WacOS/wiki/tvOS-Version-history/)

[iOS 4](https://github.com/seanpm2001/WacOS/wiki/iOS-4/)

[iOS 5](https://github.com/seanpm2001/WacOS/wiki/iOS-5/)

[iOS 6](https://github.com/seanpm2001/WacOS/wiki/iOS-6/)

[iOS 7](https://github.com/seanpm2001/WacOS/wiki/iOS-7/)

[iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/)

[tvOS 9](https://github.com/seanpm2001/WacOS/wiki/tvOS-9/)

[tvOS 10](https://github.com/seanpm2001/WacOS/wiki/tvOS-10/)

[tvOS 11](https://github.com/seanpm2001/WacOS/wiki/tvOS-11/)

[tvOS 12](https://github.com/seanpm2001/WacOS/wiki/tvOS-12/)

[tvOS 13](https://github.com/seanpm2001/WacOS/wiki/tvOS-13/)

[tvOS 14](https://github.com/seanpm2001/WacOS/wiki/tvOS-14/)

[tvOS 15](https://github.com/seanpm2001/WacOS/wiki/tvOS-15/)

### watchOS

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/WatchOS/Apple_watchOS_wordmark_2017.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/WatchOS/Apple_watchOS_wordmark_2017.svg)

[WatchOS version history](https://github.com/seanpm2001/WacOS/wiki/WatchOS-version-history/)

[WatchOS 1](https://github.com/seanpm2001/WacOS/wiki/WatchOS-1/)

[WatchOS 2](https://github.com/seanpm2001/WacOS/wiki/WatchOS-2/)

[WatchOS 3](https://github.com/seanpm2001/WacOS/wiki/WatchOS-3/)

[WatchOS 4](https://github.com/seanpm2001/WacOS/wiki/WatchOS-4/)

[WatchOS 5](https://github.com/seanpm2001/WacOS/wiki/WatchOS-5/)

[WatchOS 6](https://github.com/seanpm2001/WacOS/wiki/WatchOS-6/)

[WatchOS 7](https://github.com/seanpm2001/WacOS/wiki/WatchOS-7/)

[WatchOS 8](https://github.com/seanpm2001/WacOS/wiki/WatchOS-8/)

### Other

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/NeXTSTEP/NeXTSTEP_desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/NeXTSTEP/NeXTSTEP_desktop.png)

[Copland](https://github.com/seanpm2001/WacOS/wiki/Copland)

[Rhapsody](https://github.com/seanpm2001/WacOS/wiki/Rhapsody)

[Mac OS X Server 1.0](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-Server-1-0/)

[TaligentOS](https://github.com/seanpm2001/WacOS/wiki/Taligent-OS)

[NeXTSTEP](https://github.com/seanpm2001/WacOS/wiki/NeXTSTEP)

[OPENSTEP](https://github.com/seanpm2001/WacOS/wiki/OPENSTEP)

[Darwin](https://github.com/seanpm2001/WacOS/wiki/Darwin/)

> [Darwin version history](https://github.com/seanpm2001/WacOS/wiki/Darwin-version-history/)

[NewtonOS](https://github.com/seanpm2001/WacOS/wiki/NewtonOS/)

### Culture and humor

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Dogcow/DogCow_from_LaserWriter_8.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Dogcow/DogCow_from_LaserWriter_8.png)

For the culture and humor of Apple

[DogCow](https://github.com/seanpm2001/WacOS/wiki/Dogcow)

[Stevenote](https://github.com/seanpm2001/WacOS/wiki/SteveNote)

[Happy Mac](https://github.com/seanpm2001/WacOS/wiki/Happy-Mac/)

[Sad Mac](https://github.com/seanpm2001/WacOS/wiki/Sad-Mac/)

### Privacy

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/PRISM/PRISM_logo.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/PRISM/PRISM_logo.jpg)

For info on Apple and user privacy.

[Apple and Privacy (1976-2013)](https://github.com/seanpm2001/WacOS/wiki/Apple-and-privacy-(1976-2013))

[PRISM (Mass Surveillance Program by the USA: NSA & CIA](https://github.com/seanpm2001/WacOS/wiki/PRISM-(Surveillance-program))

[Apple and Privacy (2013-2021)](https://github.com/seanpm2001/WacOS/wiki/Apple-and-privacy-(2013-2021))

[iCloud 2021 privacy concerns](https://github.com/seanpm2001/WacOS/wiki/iCloud-2021-privacy-problems)

### Security

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Sad_Mac/Sad_mac.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Sad_Mac/Sad_mac.png)

[iCloud 2014 celebrity photo leak](https://github.com/seanpm2001/WacOS/wiki/iCloud-2014-celebrity-photo-leak)

### Criticism

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacWrite/MacWrite-software-icon.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacWrite/MacWrite-software-icon.png)

For criticism of Apple Inc. and related criticism from misuse of Apple products

[300 page iPhone Bill](https://github.com/seanpm2001/WacOS/wiki/300-Page-iPhone-Bill)

[iCon (book)](https://github.com/seanpm2001/WacOS/wiki/iCon(Book))

### Advertising

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/1984/Advertisement/Ad_apple_1984.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/1984/Advertisement/Ad_apple_1984.jpg)

For Apples advertising.

[Notable Apple advertisements](https://github.com/seanpm2001/WacOS/wiki/Notable_Apple_Advertisements)

> [1984 (Apple Ad)](https://github.com/seanpm2001/WacOS/wiki/1984(Advertisement))

> > [Related: Nineteen Eighty Four (Dystopia)](https://github.com/seanpm2001/WacOS/wiki/1984(Dystopia))

### Books

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacWrite/MacWrite-software-icon.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacWrite/MacWrite-software-icon.png)

For books about Apple Inc. and its employees

[iCon](https://github.com/seanpm2001/WacOS/wiki/iCon(Book))

### Litigation

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacWrite/MacWrite-software-icon.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacWrite/MacWrite-software-icon.png)

For Apples legal history.

[Full history of litigation (article coming soon)](https://github.com/seanpm2001/WacOS/wiki/Apple-litigation)

[Apple vs. Microsoft & IBM (Windows 2.0)](https://github.com/seanpm2001/WacOS/wiki/Windows-2-litigation)

### History

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Apple_Logo/Apple_Computer_Logo_rainbow.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Apple_Logo/Apple_Computer_Logo_rainbow.svg)

_Apple was founded on 1976, April 1st._

( [1976](https://github.com/seanpm2001/WacOS/wiki/1976/) | [1977](https://github.com/seanpm2001/WacOS/wiki/1977/) | [1978](https://github.com/seanpm2001/WacOS/wiki/1978/) | [1979](https://github.com/seanpm2001/WacOS/wiki/1979/) | [1980](https://github.com/seanpm2001/WacOS/wiki/1980/) | [1981](https://github.com/seanpm2001/WacOS/wiki/1981/) | [1982](https://github.com/seanpm2001/WacOS/wiki/1982/) | [1983](https://github.com/seanpm2001/WacOS/wiki/1983/) | [1984](https://github.com/seanpm2001/WacOS/wiki/1984/) | [1985](https://github.com/seanpm2001/WacOS/wiki/1985/) | [1986](https://github.com/seanpm2001/WacOS/wiki/1986/) | [1987](https://github.com/seanpm2001/WacOS/wiki/1987/) | [1988](https://github.com/seanpm2001/WacOS/wiki/1988/) | [1989](https://github.com/seanpm2001/WacOS/wiki/1989/) | [1990](https://github.com/seanpm2001/WacOS/wiki/1990/) | [1991](https://github.com/seanpm2001/WacOS/wiki/1991/) | [1992](https://github.com/seanpm2001/WacOS/wiki/1992/) | [1993](https://github.com/seanpm2001/WacOS/wiki/1993/) | [1994](https://github.com/seanpm2001/WacOS/wiki/1994/) | [1995](https://github.com/seanpm2001/WacOS/wiki/1995/) | [1996](https://github.com/seanpm2001/WacOS/wiki/1996/) | [1997](https://github.com/seanpm2001/WacOS/wiki/1997/) | [1998](https://github.com/seanpm2001/WacOS/wiki/1998/) | [1999](https://github.com/seanpm2001/WacOS/wiki/1999/) | [2000](https://github.com/seanpm2001/WacOS/wiki/2000/) | [2001](https://github.com/seanpm2001/WacOS/wiki/2001/) | [2002](https://github.com/seanpm2001/WacOS/wiki/2002/) | [2003](https://github.com/seanpm2001/WacOS/wiki/2003/) | [2004](https://github.com/seanpm2001/WacOS/wiki/2004/) | [2005](https://github.com/seanpm2001/WacOS/wiki/2005/) | [2006](https://github.com/seanpm2001/WacOS/wiki/2006/) | [2007](https://github.com/seanpm2001/WacOS/wiki/2007/) | [2008](https://github.com/seanpm2001/WacOS/wiki/2008/) | [2009](https://github.com/seanpm2001/WacOS/wiki/2009/) | [2010](https://github.com/seanpm2001/WacOS/wiki/2010/) | [2011](https://github.com/seanpm2011/WacOS/wiki/2011/) | [2012](https://github.com/seanpm2011/WacOS/wiki/2012/) | [2013](https://github.com/seanpm2011/WacOS/wiki/2013/) | [2014](https://github.com/seanpm2011/WacOS/wiki/2014/) | [2015](https://github.com/seanpm2011/WacOS/wiki/2015/) | [2016](https://github.com/seanpm2011/WacOS/wiki/2016/) | [2017](https://github.com/seanpm2011/WacOS/wiki/2017/) | [2018](https://github.com/seanpm2011/WacOS/wiki/2018/) | [2019](https://github.com/seanpm2011/WacOS/wiki/2019/) | [2020](https://github.com/seanpm2011/WacOS/wiki/2020/) | [2021](https://github.com/seanpm2011/WacOS/wiki/2021/) ) 

<details>
	<summary><H2>Click/tap here to expand/collapse the list dropdown</H2></summary>

[1976](https://github.com/seanpm2001/WacOS/wiki/1976/)

[1977](https://github.com/seanpm2001/WacOS/wiki/1977/)

[1978](https://github.com/seanpm2001/WacOS/wiki/1978/)

[1979](https://github.com/seanpm2001/WacOS/wiki/1979/)

[1980](https://github.com/seanpm2001/WacOS/wiki/1980/)

[1981](https://github.com/seanpm2001/WacOS/wiki/1981/)

[1982](https://github.com/seanpm2001/WacOS/wiki/1982/)

[1983](https://github.com/seanpm2001/WacOS/wiki/1983/)

[1984](https://github.com/seanpm2001/WacOS/wiki/1984/)

[1985](https://github.com/seanpm2001/WacOS/wiki/1985/)

[1986](https://github.com/seanpm2001/WacOS/wiki/1986/)

[1987](https://github.com/seanpm2001/WacOS/wiki/1987/)

[1988](https://github.com/seanpm2001/WacOS/wiki/1988/)

[1989](https://github.com/seanpm2001/WacOS/wiki/1989/)

[1990](https://github.com/seanpm2001/WacOS/wiki/1990/)

[1991](https://github.com/seanpm2001/WacOS/wiki/1991/)

[1992](https://github.com/seanpm2001/WacOS/wiki/1992/)

[1993](https://github.com/seanpm2001/WacOS/wiki/1993/)

[1994](https://github.com/seanpm2001/WacOS/wiki/1994/)

[1995](https://github.com/seanpm2001/WacOS/wiki/1995/)

[1996](https://github.com/seanpm2001/WacOS/wiki/1996/)

[1997](https://github.com/seanpm2001/WacOS/wiki/1997/)

[1998](https://github.com/seanpm2001/WacOS/wiki/1998/)

[1999](https://github.com/seanpm2001/WacOS/wiki/1999/)

[2000](https://github.com/seanpm2001/WacOS/wiki/2000/)

[2001](https://github.com/seanpm2001/WacOS/wiki/2001/)

[2002](https://github.com/seanpm2001/WacOS/wiki/2002/)

[2003](https://github.com/seanpm2001/WacOS/wiki/2003/)

[2004](https://github.com/seanpm2001/WacOS/wiki/2004/)

[2005](https://github.com/seanpm2001/WacOS/wiki/2005/)

[2006](https://github.com/seanpm2001/WacOS/wiki/2006/)

[2007](https://github.com/seanpm2001/WacOS/wiki/2007/)

[2008](https://github.com/seanpm2001/WacOS/wiki/2008/)

[2009](https://github.com/seanpm2001/WacOS/wiki/2009/)

[2010](https://github.com/seanpm2001/WacOS/wiki/2010/)

[2011](https://github.com/seanpm2011/WacOS/wiki/2011/)

[2012](https://github.com/seanpm2011/WacOS/wiki/2012/)

[2013](https://github.com/seanpm2011/WacOS/wiki/2013/)

[2014](https://github.com/seanpm2011/WacOS/wiki/2014/)

[2015](https://github.com/seanpm2011/WacOS/wiki/2015/)

[2016](https://github.com/seanpm2011/WacOS/wiki/2016/)

[2017](https://github.com/seanpm2011/WacOS/wiki/2017/)

[2018](https://github.com/seanpm2011/WacOS/wiki/2018/)

[2019](https://github.com/seanpm2011/WacOS/wiki/2019/)

[2020](https://github.com/seanpm2011/WacOS/wiki/2020/)

[2021](https://github.com/seanpm2011/WacOS/wiki/2021/)

</details>

### Apple structures

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Apple_Park/Apple_park_cupertino_2019.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Apple_Park/Apple_park_cupertino_2019.jpg)

[Apple Campus](https://github.com/seanpm2001/WacOS/wiki/Apple_Campus)

[Apple Park](https://github.com/seanpm2001/WacOS/wiki/Apple_Park)

[Apple Store](https://github.com/seanpm2001/WacOS/wiki/Apple_Store)

### Subsidiaries and ventures

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/NeXT/NeXT_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/NeXT/NeXT_logo.svg)

( [Taligent](https://github.com/seanpm2001/WacOS/wiki/Taligent-(company)) | [Claris](https://github.com/seanpm2001/WacOS/wiki/Claris) | [NeXT](https://github.com/seanpm2001/WacOS/wiki/NeXT/) )

<details>
	<summary><H2>Click/tap here to expand/collapse the list dropdown</H2></summary>

[Taligent](https://github.com/seanpm2001/WacOS/wiki/Taligent-(company))

[Claris](https://github.com/seanpm2001/WacOS/wiki/Claris)

[NeXT](https://github.com/seanpm2001/WacOS/wiki/NeXT/)

</details>

### System sounds

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/AIFF/AIFF.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/AIFF/AIFF.png)

For the system sounds used by Apple.

[Sosumi (MacOS 7 and onward error sound)](https://github.com/seanpm2001/WacOS/wiki/Sosumi/)

[MacOS Startup sound](https://github.com/seanpm2001/WacOS/wiki/MacOS-startup-sound/)

More pages coming soon

### Apple WorldWide Developers Conference

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/WWDC/Apple_WWDC_wordmark.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/WWDC/Apple_WWDC_wordmark.svg)

_The Apple WWDC is Apples yearly conference to announce new Apple products, and changes to Apple products._

( [Apple WWDC1987](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1987/) | [Apple WWDC1988](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1988/) | [Apple WWDC1989](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1989/) | [Apple WWDC1990](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1990/) | [Apple WWDC1991](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1991/) | [Apple WWDC1992](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1992/) | [Apple WWDC1993](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1993/) | [Apple WWDC1994](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1994/) | [Apple WWDC1995](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1995/) | [Apple WWDC1996](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1996/) |[Apple WWDC1997](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1997/) | [Apple WWDC1998](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1998/) | [Apple WWDC1999](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1999/) | [Apple WWDC2000](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2000/) | [Apple WWDC2001](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2001/) | [Apple WWDC2002](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2002/) | [Apple WWDC2003](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2003/) | [Apple WWDC2004](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2004/) | [Apple WWDC2005](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2005/) | [Apple WWDC2006](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2006/) | [Apple WWDC2007](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2007/) | [Apple WWDC2008](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2008/) | [Apple WWDC2009](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2009/) | [Apple WWDC2010](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2010/) | [Apple WWDC2011](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2011/) | [Apple WWDC2012](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2012/) | [Apple WWDC2013](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2013/) | [Apple WWDC2014](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2014/) | [Apple WWDC2015](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2015/) | [Apple WWDC2016](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2016/) | [Apple WWDC2017](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2017/) | [Apple WWDC2018](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2018/) | [Apple WWDC2019](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2019/) | [Apple WWDC2020](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2020/) | [Apple WWDC2021](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2021/) )

<details>
	<summary><H2>Click/tap here to expand/collapse the list dropdown</H2></summary>

[Apple WWDC1987](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1987/)

[Apple WWDC1988](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1988/)

[Apple WWDC1989](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1989/)

[Apple WWDC1990](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1990/)

[Apple WWDC1991](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1991/)

[Apple WWDC1992](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1992/)

[Apple WWDC1993](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1993/)

[Apple WWDC1994](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1994/)

[Apple WWDC1995](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1995/)

[Apple WWDC1996](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1996/)

[Apple WWDC1997](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1997/)

[Apple WWDC1998](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1998/)

[Apple WWDC1999](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1999/)

[Apple WWDC2000](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2000/)

[Apple WWDC2001](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2001/)

[Apple WWDC2002](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2002/)

[Apple WWDC2003](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2003/)

[Apple WWDC2004](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2004/)

[Apple WWDC2005](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2005/)

[Apple WWDC2006](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2006/)

[Apple WWDC2007](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2007/)

[Apple WWDC2008](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2008/)

[Apple WWDC2009](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2009/)

[Apple WWDC2010](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2010/)

[Apple WWDC2011](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2011/)

[Apple WWDC2012](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2012/)

[Apple WWDC2013](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2013/)

[Apple WWDC2014](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2014/)

[Apple WWDC2015](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2015/)

[Apple WWDC2016](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2016/)

[Apple WWDC2017](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2017/)

[Apple WWDC2018](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2018/)

[Apple WWDC2019](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2019/)

[Apple WWDC2020](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2020/)

[Apple WWDC2021](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2021/)

</details>

#### Other

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Apple_Logo/Vectorized_Apple_gray_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Apple_Logo/Vectorized_Apple_gray_logo.svg)

[Apple Public Source License](https://github.com/seanpm2001/WacOS/wiki/Apple-Public-Source-License)

[Seanpm2001's Apple experience](https://github.com/seanpm2001/WacOS/wiki/Seanpm2001-Apple-experience/)

### Credits

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Apple_Logo/Apple_logo_black.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Apple_Logo/Apple_logo_black.svg)

[Image Credits (Apple)](https://github.com/seanpm2001/WacOS/wiki/ImageCredits(Apple))

### Broken pages

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/ProjectWiki/Rendering/Problems/2021/September/This-Wiki-page-took-too-long-to-render_WacOS_2021September_LightMode.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/ProjectWiki/Rendering/Problems/2021/September/This-Wiki-page-took-too-long-to-render_WacOS_2021September_LightMode.png)

The following pages are currently broken on connections lower than 500 megabits/all connections (if it is on GitHubs end) these pages can still be viewed by source, or through separate `README.md` files. They are still problematic as of 2021 Tuesday September 28th at 6:00 pm.

[iOS version history](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/)

[Complete iOS version history](https://github.com/seanpm2001/WacOS/wiki/Complete-iOS-version-history/)

***

## Article info

**Wiki homepage version:** `12 (Tuesday, 2021 September 28th at 6:00 pm)`

**Wiki homepage version 3 release date:** `Wednesday, 2021 September 15th at 5:10 pm) accidentally published early.`

**Wiki homepage version 4 release date:** `Wednesday, 2021 September 15th at 5:16 pm) accidentally published early. I am now going to use Gedit instead, I can't keep risking it, I hate this GitHub shortcut`

**First version:** `1 (2020 May 27th at 1:59 pm)`

**File type:** `Markdown document (*.md *.mkd *.markdown)`

**Language:** `English (US) / Markdown (.md)`

**Line count (including blank lines and compiler line):** `1,095`

**All times are UTC-7 (PDT/Pacific Time)**

**You may need special rendering support for the `<dropdown>` HTML tag being used in this document**

***

