  
***

# iOS 9

<!--
<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 9 logo</p></summary>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/09/IOS_9_Logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/09/IOS_9_Logo.png)

<!--
</details>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/09/IOS_9_Homescreen.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/09/IOS_9_Homescreen.png)

( **Predecessor:** [iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/) | **iOS 9** | **Successor:** [iOS 10](https://github.com/seanpm2001/WacOS/wiki/iOS-10/) )

iOS 9 is the ninth major release of the [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) mobile operating system developed by Apple Inc., being the successor to [iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/). It was announced at the company's Worldwide Developers Conference on June 8, [2015](https://github.com/seanpm2001/WacOS/wiki/2015/), and was released on September 16, [2015](https://github.com/seanpm2001/WacOS/wiki/2015/). It was succeeded by [iOS 10](https://github.com/seanpm2001/WacOS/wiki/iOS-10/) on September 13, [2016](https://github.com/seanpm2001/WacOS/wiki/2016/)

iOS 9 incorporated many feature updates to built-in apps. Most notably, Notes received the ability to draw sketches with different tools, image insertion, prominent visual appearance for website links and map locations, and advanced list formatting; an all-new Apple News app aggregates articles from different sources; and Apple Maps received mass transit support, although in a limited number of locations at launch. Major new system updates include proactivity, where Siri and advanced search are combined to make the operating system more contextually aware of information (such as time and location), and can provide the user with information ahead of time. For searching, the proactive intelligence can display instant results in a widget-like format, including weather, sports, news, and more. iOS 9 also added multiple forms of multitasking to the iPad. In [iOS 9.3](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), Apple added a Night Shift mode that changes the color of the device's display to a warmer, less "blue light" containing shade, to reduce any negative eye health effects on users' circadian rhythms. Additionally, iOS 9 brought new user experience functions, including Quick Actions, and Peek and Pop, based on the touch-sensitive display technology in the iPhone 6S. Quick Actions are shortcuts on home screen app icons. Users can preview ("Peek") at content without moving away from the current screen before they enter ("Pop") the previewed content into full view.

Reception of iOS 9 was positive. Critics praised proactivity and Siri for making the Notification Center a central location for all information, and the potential for future updates to improve the functionality. The new multitasking features for the iPad were complimented, as were drawing and photo insertion in the Notes app. However, Apple News was criticized for a low number of decent-looking articles, and Apple Maps was criticized for the limited geographical availability of mass transit support.

Five days after release, Apple announced that iOS 9 had been installed on more than 50% of "active" [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) devices, which Apple described as the "fastest adoption rate ever for a new operating system".

## History

### Introduction and initial release

iOS 9 was introduced at the Apple Worldwide Developers Conference on June 8, [2015](https://github.com/seanpm2001/WacOS/wiki/2015/), with the first beta made available to registered developers after the keynote, and a public beta made available in July. This marked the first time that the general public had been able to test new versions of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) before official release, with Eddy Cue, Apple's Senior Vice President of Internet Software and Services, telling Fast Company that the public beta program was started "because of Maps", referring to the company's Apple Maps launch that had significant issues in its early days.

iOS 9 was officially released on September 16, [2015](https://github.com/seanpm2001/WacOS/wiki/2015/).

### Updates

Version 	Build 	Release date 	Notes

9.0 	13A340

13A342

13A343

13A344 	September 16, 2015 	Initial release

9.0.1 	13A404 	September 23, 2015 	

Fixes an issue where some users could not complete setup assistant after updating

Fixes an issue where sometimes alarms and timers could fail to play

Fixes an issue in Safari and Photos apps where pausing video could cause the paused frame to appear distorted

Fixes an issue where some users with a custom APN setup via a profile would lose cellular data

13A405	September 24, 2015

9.0.2 	13A452 	September 30, 2015 	

Fixes an issue with the setting to turn on or off app cellular data usage

Fixes an issue that prevented iMessage activation for some users

Fixes an issue where an iCloud backup could be interrupted after starting a manual backup

Fixes an issue where the screen could incorrectly rotate when receiving notifications

Fixes an issue where a lock screen issue allowed access to photos and contacts on a locked device

Improved the stability of Podcasts app

9.1 	13B143 	October 21, 2015 	

Live Photos now intelligently senses when the iPhone is raised or lowered, so that Live Photos will automatically not record these movements p

Over 150 new emoji characters with full support for Unicode 7.0 and 8.0 emojis

Improved overall stability, including CarPlay, Music, Photos, Safari and Search

Improved performance while in Multitasking UI

Fixes an issue that could cause Calendar to become unresponsive in Month view

Fixes an issue that prevented Game Center from launching some users

Fixes an issue that zoomed the content of some apps

Fixes an issue that could cause an incorrect unread mail count for POP mail accounts

Fixes an issue that prevented users from removing recent contacts from new mail or messages

Fixes an issue that caused some messages to not appear in Mail search results

Fixes an issue that left a gray bar in the body of an audio message

Fixes an issue that caused activation errors on some carriers

Fixes an issue that prevented some apps from updating from the App Store

13B144 	November 17, 2015

9.2 	13C75 	December 8, 2015 	

Apple Music improvements

Ability to create a new playlist when adding a song to a playlist

Most recently changed playlist is now listed at the top when adding songs to playlist

Ability to download albums or playlists from your iCloud Music Library by tapping the iCloud download button

New download indicator next to each song in My Music and Playlists

See works, composers, and performers while browsing Classical music in the Apple Music catalog

iBooks now supports listening to an audiobook while browsing the library, reading other books, or exploring the iBooks Store

iPhone support for USB Camera Adapter to import photos ans videos

Siri support for Arabic (Saudi Arabia, United Arab Emirates)

Bug fixes

9.2.1 	13D15 	January 19, 2016 	General bug fixes and security patches

13D20 	February 18, 2016

9.3 	13E233

13E234 	March 21, 2016 	

Adds support for a new feature named Night Shift which, manually or automatically (based on user preference), makes the display color warmer so it is easier to view at night. Users can adjust the color temperature in the Settings app
Night Shift works only on 64-bit devices

Adds support for protecting notes inside the Notes app with a passcode or Touch ID

Support for pairing multiple Apple Watches to your iPhone

Support for Spanish (Latin America) display language

Siri support for Finnish, Hebrew and Malay

Fixes an issue where manually changing the date to May 1970 or earlier could prevent 64-bit and 32-bit devices from turning on after a restart

13E236 	March 25, 2016 	Builds 13E236 and 13E237 were issued to devices that were affected by the Activation Lock bug. These re-issued builds helped correct the issue after the prior builds were withdrawn

13E237 	March 28, 2016

9.3.1 	13E238 	March 31, 2016 	

Fixes an issue that caused apps to be unresponsive after tapping on links in Safari or other apps

Fixes an issue where connecting to a fake Apple time server which sets system time to January 1, 1970 can cause 64-bit devices to overheat and become unresponsive after a restart

9.3.2 	13F69 	May 16, 2016 	

Fixes an issue where some Bluetooth accessories could experience audio quality issues when paired to iPhone SE

Fixes an issue where looking up dictionary definitions could fail

Fixes an issue that prevented typing email addresses when using the Japanese Kana keyboard in Mail and Messages

Fixes an issue for VoiceOver users, using the Alex voice, where the device switches to a different voice to announce punctuation or spaces

13F72	June 2, 2016 	A previous build of iOS 9.3.2 bricked some iPad Pros 9.7-inch. Build 13F72 fixes this issue

9.3.3 	13G34 	July 18, 2016 	General bug fixes and improvements

9.3.4 	13G35 	August 4, 2016 	Fixes a memory corruption vulnerability found by Team Pangu that allows arbitrary code execution with kernel privileges

9.3.5 	13G36 	August 25, 2016 	Fixes security vulnerabilities

9.3.6 	13G37 	July 22, 2019 	Fixes an issue that would prevent cellular devices from maintaining an accurate GPS position after November 3, 2019

Initial release on iPhone 6S, iPhone 6S Plus and iPad mini 4

iPad mini 4 only

iPhone 6S only

iPhone 6S Plus only

iPhone 6S and iPhone 6S Plus only

Initial release on iPad Pro 12.9-inch (1st generation)

iPad Pro 12.9-inch (1st generation) only

iPhone 6, iPhone 6 Plus, iPhone 6S, iPhone 6S Plus, iPad Air 2, iPad mini 3, iPad mini 4 and iPad Pro 12.9-inch (1st generation) only

Initial release on iPhone SE (1st generation) and iPad Pro 9.7-inch

iPhone 6S, iPhone 6S Plus and iPad Pro 9.7-inch only

iPad 2 (GSM) only

iPhone 4S, iPhone 5, iPhone 5C, iPhone 5S, iPad 2 (Wi-Fi), iPad 2 (CDMA), iPad (3rd generation), iPad (4th generation), iPad mini (1st generation), iPad mini 2, iPad Air (1st generation) and iPod touch (5th generation) only

iPad Pro 9.7-inch only

iPhone 4S, iPad mini (1st generation) (Wi-Fi + Cellular), iPad 2 (CDMA) and iPad (3rd generation) (Wi-Fi + Cellular) only

## System features

### 3D Touch

On the iPhone 6S and iPhone 6S Plus, a touch-sensitive display feature called 3D Touch is incorporated into iOS 9. It is similar to Force Touch, which can be found on the trackpad of some Apple MacBook computers. Quick Actions and shortcuts are added to apps that support the 3D Touch feature and are triggered by pressing slightly harder on the app icon. It also introduces actions known as Peek and Pop, which lets users firmly hold to preview ("Peek") any kind of content in a hovering window, before they optionally apply more pressure to enter ("Pop") the content into full view.

The taptic engine in the iPhone 6S provides haptic feedback each time users press the screen harder.

### Battery

iOS 9 comes with two important battery-saving updates. When a phone has been placed face-down, the screen will not light up upon receiving notifications. Apple has also added Low Power Mode, which modifies the amount of energy dedicated to background services and animations. For example, background app refresh and push email are paused during Low Power Mode. When a phone reaches 20% battery level, users are automatically prompted to turn on Low Power Mode, which changes the color of the battery icon in the top row status bar on the screen to yellow. When the battery goes higher than the 80% level, Low Power Mode automatically turns back off.

### Design

San Francisco, a new system font, replaced Helvetica Neue as the system typeface of iOS.

iOS 9 added a new battery widget to the Notification Center that displayed the battery life and charging status of any connected Bluetooth device.

When the shift button is inactive, lowercase letters are displayed on the keyboard, instead of the all-caps representation on previous iOS versions.

### Installation

iOS 9 is a smaller update than iOS 8, requiring 1.3 GB of space, compared to 4.58 GB for [iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/). Additionally, iOS 9 includes an option to temporarily delete apps to allow the update to install. Once the update has been installed, the apps will be automatically restored. iOS 9 also features "app thinning" functionality, whereby only the necessary assets needed to run apps on each individual device is downloaded rather than the entire app, potentially saving space.

### Multitasking

iOS 9 adds a number of features to the iPad to improve productivity. These include Slide Over, Split Screen, and Picture in Picture, for enhanced multitasking, similar to the experience found on OS X El Capitan. Slide Over allows the user to pull in a second app with a swipe from the right edge of the display. This app takes up 1/3 of the screen and sticks to the right side of the screen, while interactivity within the full-screen app is disabled while left inactive in the background. The feature allows users to perform quick tasks and then dismiss the app again.

If the user taps on the handle next to the Slide Over window or extends the window further towards the left of the screen, the user enters Split Screen, which allows them to interact with two apps simultaneously side-by-side in a 50/50 split. Users can also switch to another app in either Slide Over mode or Split Screen view by pulling down on the handle on top of either app and selecting another app from the list to replace the existing one.

Picture in Picture mode allows users to minimize FaceTime calls or supported videos to a smaller window and continue watching them while doing other tasks on the iPad.

The Split Screen multitasking feature is only available for iPad Air 2, iPad mini 4, and iPad Pro, while the Slide Over and Picture in Picture features are available on the iPad Air, iPad Air 2, iPad mini 2 and newer, and the iPad Pro.

When banner notifications are tapped, causing another app to open, a back button at the top-left corner of the screen has been added, bringing the user back to the previous app.

### Night Shift

Night Shift is a display mode introduced in [iOS 9.3](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/). The mode shifts the colors of the device's display to be warmer, similar to F.lux, a popular program for Microsoft Windows and Apple macOS computers. When enabled, it uses the device's clock and geographic location to determine when to turn the feature on or off. Optionally, the user can set a manual schedule, or not have a schedule at all. For ease of access, there is a new Night Shift toggle in the Control Center. The settings for Night Shift are located under "Display and Brightness" in the Settings app, and on top of enabling the feature and setting a schedule, the user can also set the warmth of the display.

Despite being introduced in [iOS 9.3](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) in March 2016, it wasn't possible to use Night Shift and Low Power Mode simultaneously until the release of iOS 9.3.2 two months later. Night Shift requires a 64-bit processor only found in the Apple A7 or newer chips, which means older iOS devices, including the iPhone 4S, iPhone 5, iPhone 5C, iPad 2, iPad 3, iPad 4, first-generation iPad Mini, and 5th generation iPod Touch, do not receive Night Shift mode.

### Performance

iOS 9 includes performance and speed improvements thanks to the expanded use of the Metal API. Metal was introduced in [iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/) and was previously limited to game developers. In iOS 9, the use of Metal is expanded to let it handle many of the core user interface elements and graphics.

### Proactivity

Intelligence is one of the main features in iOS 9, consisting of the newly integrated Siri and Search (previously known as Spotlight), as well as "proactivity" throughout the operating system. iOS is now more aware of contextual information (such as time and location), and proactively provides the user with what they may need in advance to save them time and effort. When typing, Search has also been improved to display instant answers in an at-a-glance, widget-like format, similar to that provided in the Siri interface. Search can display current weather, sports scores, news, and more. The Search screen with proactive suggestions can be accessed either by pulling down the notifications window, in the Safari web browser through the search bar, and to the left on the home screen.

The intelligence also extends into apps. For instance, in Mail, events can be automatically added to Calendar if details are found in the message content, and likely additional recipients are suggested during message composition. Siri is also aware of what is currently on screen when it is engaged by holding down the home button.

### Security

iOS 9 introduces multiple security enhancements. It introduces a 6-digit passcode as a default, an extra two digits from the previous 4-digit default, as well as support for two-factor authentication.

The original iOS 9 release in September [2015](https://github.com/seanpm2001/WacOS/wiki/2015/) fixed a security issue within previous [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) versions where a "flaw allowed anyone within range of an AirDrop user to install malware on a target device and tweak [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) settings so the exploit would still work if the victim rejected an incoming AirDrop file".

### Settings

The Settings app in iOS 9 has a search bar that makes it easier to find settings and options. The user also has options to have notifications be grouped by which app they came from, and the ability to turn on or off Shake to Undo.

### Other changes

On iPad, a two-finger drag on the keyboard moves the cursor freely like a traditional trackpad, making positioning the cursor and selecting text easier. The keyboard-to-trackpad feature is also extended to iPhone 6S and 6S Plus, in which users can 3D Touch (force press) the keyboard to enable the trackpad. Also on the iPad, a shortcut bar has been added for cut, copy, paste, undo, and redo functions, and folders display 16 apps per page in a 4-by-4 arrangement, compared to 9 on the iPhone, allowing for an increased total of 240 apps in a single folder.

iOS 9 introduced Wi-Fi Assist, a feature, on by default, that automatically switches the phone to cellular data when the Wi-Fi connection is spotty.

Whenever the user is presented with flight information, the user can click on a link to view a preview for that flight.

## App features

### iBooks

As of [iOS 9.3](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), PDFs saved to the iBooks application via Safari or iTunes can be synced with iCloud.

### iCloud

iOS 9 has a setting that enables an iCloud Drive app on the home screen. iCloud Drive lets the user save and browse files and folders in iCloud.

### Health

The Health app, introduced in [iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/), has received landscape mode on iPhone. It also added support for reproductive health, UV exposure, water intake and sedentary state data type.

In [iOS 9.3](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), it also tracks sleep, exercise, and weight from the Apple Watch.

### Messages

The Messages (previously iChat) app allows the user to search for text and have that text be highlighted (and scrolled).

### Maps

Apple Maps adds support for transit directions in Baltimore, Berlin, Chicago, London, Los Angeles, Mexico City, New York City, Paris, Philadelphia, San Francisco, Toronto, and Washington D.C., along with "over 300 locations in China."

The Maps app now also has enhanced location details, including a Nearby feature that recommends shops, restaurants and places to drink in close proximity to the user. For places serving food, users can specify exactly what type of food they want.

### News

iOS 9 includes a new Apple News app (replacing the Newsstand app), which aggregates news from different sources in a similar style as Flipboard. The app features a "mobile-formatted layout that loads quickly and has informative animations and full-bleed images". Additionally, News supports RSS feeds from the Safari web browser. At launch, the News app was only available in the United States, but it was expanded to the United Kingdom and Australia with the [iOS 9.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) update.

In March [2016](https://github.com/seanpm2001/WacOS/wiki/2016/), Apple opened the News platform to all news agencies, including independent bloggers.

### Notes

The Notes app has received a number of enhancements in iOS 9, including the ability to draw sketches with a number of different tools, including a ruler for straight lines. Images can also be added, and links to websites and Map locations get a more prominent, visual appearance when added to notes. On the iPad, and on iPhone in landscape mode, Notes has a range of color options for drawing, as well as an eraser. Advanced formatting options including checked, bulleted, dashed and numbered lists.

The app also supports iCloud and allows for easy folder creation.

A secure notes feature, introduced in [iOS 9.3](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), lets an iOS user protect their notes with either a passcode or Touch ID.

### Photos

The Photos app on iOS 9 included the improved scrubber bar in the photo viewer, "Screenshots" and "Selfies" albums, and the ability to hold and select multiple photos easily, without having to delete them individually. It also allows the user to hide sensitive material through a new Hide option. The app also allows the user to pinch to zoom while playing a video.

### Safari

With the release of iOS 9, the Safari web browser allows for third-party content blocking apps. Safari also allows users to customize the appearance of the Reader mode, with options for font and background color.

A few days after the release of iOS 9, ad blocking software had topped the App Store charts, with Marco Arment, developer of a Peace app, saying that "web advertising and behavioral tracking is out of control. They're unacceptably creepy, bloated, annoying, and insecure, and they're getting worse at an alarming pace."

### Wallet

The Passbook application was renamed Wallet in iOS 9 and includes many new changes, such as support for store loyalty cards, gift cards, Discover credit/debit cards, and Apple Pay in the UK. The Wallet app can also be accessed from the lock screen.

### Developer APIs

In iOS 9.3, a "Music API" allows developers to integrate apps into the Apple Music streaming service.

## Reception

iOS 9 received mostly positive reviews. Dan Seifert of The Verge praised the improvements in Proactivity and Siri, highlighting how the notification drop-down contains most, if not all, the information the user needs. Although he pointed out that Google's Google Now and Microsoft's Cortana personal assistants offer similar services, sometimes with "better and more varied ways" of achieving results, the improvements to iOS "lay the foundation for even more capabilities in the future". Chris Velazco of Engadget liked the "small, thoughtful" design changes, but was most impressed by the new multitasking features for the iPad, referring to Split Screen as a "lovely little feature." He did, however, criticize the low number of decent-looking articles in Apple News, writing that "you'll notice a discrepancy in how some articles are handled – most are just formatted text on a white background with the outlet's logo up top" and also noted the limited number of locations in Apple Maps that, at launch, supported mass transit directions] Matt Swider of TechRadar wrote that Siri and Proactivity lists were "robust," and enjoyed that notifications were sorted chronologically rather than by app. Samuel Gibbs of The Guardian welcomed the changes to the built-in apps such as drawing and photo insertion in Notes, unknown number identification from emails through Phone, and Siri automatically launching the Music app upon plugging in headphones. He also praised the updates to the keyboard, calling it "much easier to use."

Apple is facing a $5 million lawsuit over allegedly slowing the iPhone 4S with iOS 9. This is because according to the lawsuit, the iOS 9 update slowed down the iPhone 4S to the point that the phone was unusable (as performance was sluggish) and that Apple knew this fact (planned obsolescence).

On September 21, [2015](https://github.com/seanpm2001/WacOS/wiki/2015/), Apple announced that iOS 9 had been installed on more than 50% of "active" iOS devices, as measured by the App Store. According to Apple, this was "the fastest adoption rate ever for a new operating system".

## Problems

### Error 53 bricking issue

In February 2016, news outlets reported that users who updated to iOS 9 on a particular device that had components repaired by a third-party (notably the Touch ID fingerprint recognition sensor) rendered their phone bricked. The issue, named "Error 53", was, according to iFixIt, limited to iPhone 6 and 6 Plus devices Apple stated:

We protect fingerprint data using a secure enclave, which is uniquely paired to the Touch ID sensor. When iPhone is serviced by an authorised Apple service provider or Apple retail store for changes that affect the Touch ID sensor, the pairing is re-validated. ... This check ensures the device and the iOS features related to Touch ID remain secure. Without this unique pairing, a malicious Touch ID sensor could be substituted, thereby gaining access to the secure enclave. When iOS detects that the pairing fails, Touch ID, including Apple Pay, is disabled so the device remains secure.

Apple released a new version of [iOS 9.2.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) later in February to fix the issue.

### Date reboot issue

In February 2016, a bug was discovered that could render 64-bit devices unusable. The bug, caused by setting the time to January 1, 1970, would cause the device to get stuck in a reboot process until the battery died or the time setting shifted past January 1. A similar bug also applies to 32-bit devices, where the battery would report 0% of charge, and the Wi-Fi would be disabled. [iOS 9.3](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), released on March 21, [2016](https://github.com/seanpm2001/WacOS/wiki/2016/), fixed the issue.

### 9.7-inch iPad Pro bricking issue

In May [2016](https://github.com/seanpm2001/WacOS/wiki/2016/), Apple released [iOS 9.3.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/). The update was followed by reports that it bricked some 9.7-inch iPad Pros, with a "Connect to iTunes" message, and an "Error 56" message in iTunes that it couldn't restore the tablet.

Apple temporarily stopped offering the [9.3.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) update, until a re-release of the version in June 2016 fixed the issue.

### iBooks crash

The release of iOS [9.3.3](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) in July [2016](https://github.com/seanpm2001/WacOS/wiki/2016/) was followed by reports that the iBooks store crashed. However, Apple explained in August that the timing was a coincidence, and the iBooks app crash was a result of a server issue, not the software update.

### Spyware attack

The release of [iOS 9.3.5](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) in August [2016](https://github.com/seanpm2001/WacOS/wiki/2016/) fixed three critical security vulnerabilities. The vulnerabilities could be exploited to silently enable a jailbreak and allow the malicious installation of a spyware called "Pegasus". Pegasus could intercept and read text messages, emails, track calls, trace phone location, activate the microphone, and gather information from apps, including (but not limited to) iMessage, Gmail, Viber, Facebook, WhatsApp, Telegram, and Skype.

The discovery of the vulnerabilities dated 10 days before the [9.3.5](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) update was released. Arab human rights defender Ahmed Mansoor received a suspicious text message with a link and sent it to Citizen Lab. An investigation ensued with collaboration from Lookout that revealed that if Mansoor clicked the link, it would have jailbroken his phone and implanted it with the spyware. Citizen Lab linked the attack to an Israeli surveillance company known as NSO Group that sells Pegasus to governments for "lawful interception".

Regarding how widespread the issue was, Lookout explained in a blog post: "We believe that this spyware has been in the wild for a significant amount of time based on some of the indicators within the code" and pointed out that the code shows signs of a "kernel mapping table that has values all the way back to [iOS 7](https://github.com/seanpm2001/WacOS/wiki/iOS-7/)".

News of the spyware received significant media attention, particularly for being called the "most sophisticated" smartphone attack ever, and for being the first time in iPhone history that a remote jailbreak exploit has been detected.

### "Broadpwn" Wi-Fi vulnerability

In July 2017, information on a critical Wi-Fi security vulnerability affecting 1 billion iOS and Android devices was published. The issue, named "Broadpwn", allows an attacker to remotely take control of nearby vulnerable devices and turn affected devices into "rogue access points", further spreading the infection to other nearby devices. Apple released a security patch for the issue as part of its iOS 10.3.3 update, though older devices running iOS 9, including the iPad 2, 3rd generation iPad, iPhone 4S, the first-generation iPad Mini, and the 5th generation iPod Touch were left without an available update, causing concerns over the safety of the iPad 2, 3rd generation iPad, and the first-generation iPad Mini in schools.

### iPhone 4S lawsuit

See also: [batteryGate](https://github.com/seanpm2001/WacOS/wiki/BatteryGate/)

On December 22, 2015, Apple faced a class-action lawsuit for crippling the iPhone 4S with the iOS 9 update, with some people even going so far as to say that iOS 9 rendered their devices unusable. The 4S only had 512MB of RAM, so it could not handle the iOS 9 update.

## Supported devices

With this release, Apple did not drop support for any iOS devices, with all devices supporting iOS 8 also able to run iOS 9.

### iPhone

iPhone 4S

iPhone 5

iPhone 5C

iPhone 5S

iPhone 6

iPhone 6 Plus

iPhone 6S

iPhone 6S Plus

iPhone SE (1st generation)
	
### iPod Touch

iPod Touch (5th generation)

iPod Touch (6th generation)
	
### iPad

iPad 2

iPad (3rd generation)

iPad (4th generation)

iPad Air

iPad Air 2

iPad Mini (1st generation)

iPad Mini 2

iPad Mini 3

iPad Mini 4

iPad Pro (12.9-inch 1st generation)

iPad Pro (9.7-inch)

**This article is a modified copy of its Wikipedia counterpart and needs to be rewritten for originality.**

***

## Sources

[Wikipedia - iOS 9](https://en.wikipedia.org/wiki/IOS_9/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Monday September 27th at 3:26 pm`

**Last revised on:** `2021 Monday September 27th at 3:26 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `474`

**Article version:** `1 (2021 Monday September 27th at 3:26 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

