  
***

# iOS 12

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 12 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/12/IOS_12_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/12/IOS_12_logo.svg)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/12/IOS_12_Homescreen_iPhone_X.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/12/IOS_12_Homescreen_iPhone_X.png)

( **Predecessor:** [iOS 11](https://github.com/seanpm2001/WacOS/wiki/iOS-11/) | **iOS 12** | **Successor:** [iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/) / [iPadOS 13](https://github.com/seanpm2001/WacOS/wiki/iPadOS-13/) )

**As of 2021 September 27th, iOS 12 and later are still supported and are receiving updates. The data here will need to be updated in the future.**

iOS 12 is the twelfth major release of the [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) mobile operating system developed by Apple Inc. Aesthetically similar to its predecessor, [iOS 11](https://github.com/seanpm2001/WacOS/wiki/iOS-11/), it focuses less on new functions than on performance, quality improvements and security updates. Announced at the company's Worldwide Developers Conference on June 4, [2018](https://github.com/seanpm2001/WacOS/wiki/2018/), iOS 12 was released to the public on September 17, [2018](https://github.com/seanpm2001/WacOS/wiki/2018/). It was succeeded for the iPhone and iPod Touch by [iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/) on September 19, [2019](https://github.com/seanpm2001/WacOS/wiki/2019/) and for the iPad by [iPadOS 13](https://github.com/seanpm2001/WacOS/wiki/iPadOS-13/) on September 24, [2019](https://github.com/seanpm2001/WacOS/wiki/2019/). iOS 12 continues to receive security updates on devices that cannot support [iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/) or newer as of September [2021](https://github.com/seanpm2001/WacOS/wiki/2021/).

## History

### Introduction and initial release

iOS 12 was introduced by Craig Federighi at the Apple Worldwide Developers Conference keynote address on June 4, [2018](https://github.com/seanpm2001/WacOS/wiki/2018/). The first developer beta version was released after the keynote presentation, with the first public beta released on June 25, [2018](https://github.com/seanpm2001/WacOS/wiki/2018/). The initial release of version 12.0 was on September 17, [2018](https://github.com/seanpm2001/WacOS/wiki/2018/).

### Updates

Version 	Build 	Release date 	Notes

12.0 	16A366 	September 17, 2018 	Initial release; Initial release on the iPhone XS and XS Max

16A367 	October 26, 2018 	Initial release on the iPhone XR; Preinstalled on some early devices

12.0.1 	16A404

16A405 	October 8, 2018	

12.1 	16B92

16B93

16B94 	October 30, 2018

November 6, 2018 	Initial release on iPad Pro (3rd generation)

12.1.1 	16C50 	December 5, 2018

12.1.2 	16C101

16C104	December 17, 2018

December 20, 2018	Only for iPhones

12.1.3 	16D39

16D40 	January 22, 2019 	

12.1.4 	16D57 	February 7, 2019	

12.2 	16E227 	March 25, 2019	Initial release on iPad Air (3rd generation) and iPad Mini (5th generation)

12.3 	16F156 	May 13, 2019	

16F8155	May 28, 2019 	Initial release on iPod Touch (7th generation); Preinstalled on some early devices

12.3.1 	16F203 	May 24, 2019 	

16F8202	May 29, 2019

12.3.2 	16F250 	June 10, 2019 	Exclusive to iPhone 8 Plus, resolving an issue that could cause Camera to capture Portrait mode photos without depth effect on some devices

12.4 	16G77 	July 22, 2019 	Adds support for the Apple Card service; adds migration tool between iPhones running iOS 12

12.4.1 	16G102 	August 26, 2019 	Undoes a vulnerability fix reversal from the previous release

Exclusive to iOS devices that do not support iOS 13 and above

(iPhone 5S, iPhone 6/6 Plus, iPad Air, iPad Mini 2, iPad Mini 3, and iPod Touch (6th generation))

12.4.2 	16G114 	September 26, 2019 	Security Fixes
12.4.3 	16G130 	October 28, 2019

12.4.4 	16G140 	December 10, 2019

12.4.5 	16G161 	January 28, 2020

12.4.6 	16G183 	March 24, 2020

12.4.7 	16G192 	May 20, 2020

12.4.8 	16G201 	July 15, 2020

12.4.9 	16H5 	November 5, 2020

12.5 	16H20 	December 14, 2020

Adds COVID-19 exposure notification on iPhone 5S and iPhone 6/6 Plus

12.5.1 	16H22 	January 11, 2021	Solves an issue where Exposure Notifications could incorrectly display logging profile language on iPhone 5S and iPhone 6/6 Plus.

12.5.2 	16H30 	March 26, 2021 	Security fixes

12.5.3 	16H41 	May 3, 2021

12.5.4 	16H50 	June 14, 2021

12.5.5 	16H62 	September 23, 2021

iPhone XR only

iPhone XS, iPhone XS Max and iPhone XR only

Re-release of 12.1 for iPhone XR only on November 6, 2018

Re-release of 12.1.2 for all iPhones on December 20, 2018

iPhone XS, iPhone XS Max, iPhone XR and iPad Pro (3rd generation) only

iPod Touch (7th generation) only

Legend:   Past   Current   Beta

## System features

### Performance

Performance optimizations were made in order to speed up common tasks across all supported iOS devices. Tests done by Apple on an iPhone 6 Plus showed apps launching 40% faster, the system keyboard activating 50% faster, and the camera opening 70% faster.

### Screen Time

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/12/IOS12-ScreenTime.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/12/IOS12-ScreenTime.jpg)

_The Screen Time usage information screen in iOS 12 on an iPhone X_

Screen Time is a new feature in iOS 12 that records the amount of time a user spent on the device. The feature also displays the amount of time the user used particular apps, the amount of time the user used particular categories of apps (such as games), and the number of notifications the user received.

Screen Time also provides blocking features to limit usage of apps (with time limits) or set other restrictions such as on purchases or explicit content. It replaces Restrictions in the iOS Settings app, but can also be used by adults to limit their own usage. These features can be used with or without a passcode. Without setting a passcode, the limits can easily be bypassed but may serve as a useful reminder of usage goals.

### Shortcuts

A dedicated application in iOS 12 allows users to set up Shortcuts, automated actions that the user can ask Siri to perform. Using the Shortcuts app, a user can create a phrase and type in the action they want Siri to do for them. Once they tell the phrase to Siri, Siri will automatically do the task they set for it in the Shortcuts app. The Shortcuts app replaces the Workflow app that Apple acquired in March [2017](https://github.com/seanpm2001/WacOS/wiki/2017/).

### ARKit 2

ARKit now allows users to share their view with other iOS 12-supported devices. ARKit 2 additionally allows full 2D image tracking and incorporates the ability to detect 3D objects.

### CarPlay

CarPlay can now run third-party navigation applications. (Waze, Google Maps, etc.)

### iPad

The Voice Memos and Stocks apps are now available for iPads.

Control Center is separated from the app switcher on iPad and can be opened with a swipe down on the top right corner. In addition, iPhone X-style gestures are introduced across all iPads running iOS 12.

### Keyboard

In iOS 12, the trackpad mode (which allows the user to freely move the cursor) is enabled by long-pressing the space bar on devices without 3D Touch.

### App Switcher

For devices with gesture navigation and no home button (iPhone X and later), users can now force quit applications by swiping up from the bottom of the screen (without having to press and hold on them when in the app switcher).

### Exposure Notification API

On December 14, 2020, Apple released iOS 12.5, which includes the Exposure Notification API (backported from [iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/)) that provides access to the Apple / Google privacy-preserving contact tracing system that Apple have developed jointly with Google. This is provided to support digital contact tracing which came to light during the COVID-19 pandemic.

## App features

### Messages

Messages in iOS 12 introduces a new type of customizable Animoji called "Memoji" which allows a user to create a 3D character of themselves. Apple also introduced Koala, Tiger, Ghost, and T-Rex Animojis.  In addition, Apple added new text and GIF effects similar to those found on other social media applications.

### FaceTime

FaceTime gains support for Animoji and Memoji, as well as new text and GIF effects similar to those found on other social media applications and in the Messages application.

[iOS 12.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), released on October 30, [2018](https://github.com/seanpm2001/WacOS/wiki/2018/), adds the ability to include up to 32 people in a FaceTime conversation. This feature is only supported with video by devices with the Apple A8X or Apple A9 chip or later; it is only supported for audio on iPhone 5S, iPhone 6, and iPhone 6 Plus, and is not available at all on iPad Mini 2, iPad Mini 3, and iPad Air. Group FaceTime was disabled on January 28, 2019 due to a software bug that allowed calls to be answered by the caller rather than the recipient, allowing video and audio to be transmitted unless the call was declined. The functionality got restored on February 7, 2019, with the release of [iOS 12.1.4](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/). Group FaceTime remains disabled on devices running iOS 12 that are affected by the bug.

### Measure

Measure is a native AR application that allows the user to take measurements of real objects. It also works as a level, a feature that was originally packaged as part of the Compass app.

### Photos

Apple Photos has been completely redesigned with four new tabs, including "Photos," "For You," "Albums," and "Search." The new "For You" tab replaces the "Memories" tab previously found in iOS 11 and makes sharing recommendations, creates short-length video collages, photo editing suggestions, as well as featured photos from a specific day.

While the "Photos" and "Albums" tabs received only a few cosmetic changes, the "Search" tab includes new Artificial Intelligence and Machine Learning features which show the user photos by place and categories (e.g. animals, cars, objects).

### Notifications

Notifications are now grouped by application and have a "manage" button to turn off notifications for that app or to deliver them quietly right from the Notification Center without having to go into the Settings application.

### Do Not Disturb

Do Not Disturb gives users more options for automation. Users can hide notifications indefinitely or scheduled like previously, but can also hide notifications for 1 hour, until a time of day, until leaving a location, or until the end of a scheduled event in Calendar.

### Voice Memos and Stocks

Voice Memos and Stocks are supported on iPad, and have a newer design. Stocks was integrated with Apple News to show financial and other related news.

### Apple Books

iBooks was renamed Apple Books, and the app was redesigned, with five new tabs, including "Reading Now," "Library," "Book Store," "Audio Books," and "Search." The new app design is similar to that of Apple Music, and has been praised for its simplicity in allowing users to easily navigate their book library.

### Safari

Safari receives an update to Intelligent Tracking Prevention. This includes a feature which allows the user to disable social media "like" and "share" buttons.

### Maps

Apple Maps had started to be rebuilt from the ground up by relying on first-party map data instead of using map data provided by third parties. This allows for more accurate directions and predictions on the fastest routes. The new maps were rolled out in sections and the entire US completed by the end of 2019.

## Problems

### Rainbow flag emoji

After a rainbow flag emoji with an interdictory sign over it appeared on Twitter, several users accused Apple of encouraging anti-LGBT attitudes. However, Emojipedia has clarified that this occurs when a user tweets the two emojis together and is not an intended feature. This can be used with other emojis as well.

### FaceTime eavesdropping issue

A FaceTime issue impacting several versions of iOS 12 (versions 12.1–12.1.3) allowed users to call someone via FaceTime and hear the audio coming from their phone before answering the call, before the bug was fixed in [iOS 12.1.4](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/).

## Supported devices

Any device that supports [iOS 11](https://github.com/seanpm2001/WacOS/wiki/iOS-11/) can be upgraded to iOS 12. However, devices with an A7 or A8 chip and 1GB of RAM, such as the iPhone 5S, 6, 6 Plus, and the iPod Touch (6th generation), all have limited support. These are the list of the devices that support iOS 12:

### iPhone

iPhone 5S

iPhone 6

iPhone 6 Plus

iPhone 6S

iPhone 6S Plus

iPhone SE (1st generation)

iPhone 7

iPhone 7 Plus

iPhone 8

iPhone 8 Plus

iPhone X

iPhone XS

iPhone XS Max

iPhone XR
	
### iPod Touch

iPod Touch (6th generation)

iPod Touch (7th generation)

### iPad

iPad Air (1st generation)

iPad Air 2

iPad Air (3rd generation)

iPad (5th generation)

iPad (6th generation)

iPad Mini 2

iPad Mini 3

iPad Mini 4

iPad Mini (5th generation)

iPad Pro (9.7-inch)

iPad Pro (10.5-inch)

iPad Pro (11-inch, 1st generation)

iPad Pro (12.9-inch, 1st generation)

iPad Pro (12.9-inch, 2nd generation)

iPad Pro (12.9-inch, 3rd generation)

**This article is a modified copy of its Wikipedia counterpart and needs to be rewritten for originality.**

***

## Sources

[Wikipedia - iOS 12](https://en.wikipedia.org/wiki/IOS_12/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Monday September 27th at 4:50 pm`

**Last revised on:** `2021 Monday September 27th at 4:50 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `332`

**Article version:** `1 (2021 Monday September 27th at 4:50 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

