  
***

# iOS 11

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 11 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_logo.svg)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_Homescreen_iPhone_7_Plus.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_Homescreen_iPhone_7_Plus.png)

( **Predecessor:** [iOS 10](https://github.com/seanpm2001/WacOS/wiki/iOS-10/) | **iOS 11** | **Successor:** [iOS 12](https://github.com/seanpm2001/WacOS/wiki/iOS-12/) )

iOS 11 is the eleventh major release of the [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) mobile operating system developed by Apple Inc., being the successor to [iOS 10](https://github.com/seanpm2001/WacOS/wiki/iOS-10/). It was announced at the company's Worldwide Developers Conference on June 5, [2017](https://github.com/seanpm2001/WacOS/wiki/2017/), and released on September 19, [2017](https://github.com/seanpm2001/WacOS/wiki/2017/). It was succeeded by [iOS 12](https://github.com/seanpm2001/WacOS/wiki/iOS-12/) on September 17, [2018](https://github.com/seanpm2001/WacOS/wiki/2018/).

## Changes

Among iOS 11's changes: the lock screen and Notification Center were combined, allowing all notifications to be displayed directly on the lock screen. The various pages of the Control Center were unified, gaining custom settings and the ability to 3D Touch icons for more options. The App Store received a visual overhaul to focus on editorial content and daily highlights. A "Files" file manager app allowed direct access to files stored locally and in cloud services. Siri was updated to translate between languages and use a privacy-minded "on-device learning" technique to better understand a user's interests and offer suggestions. The camera had new settings for improved portrait-mode photos and utilised new encoding technologies to reduce file sizes on newer devices. In a later release, Messages was integrated with iCloud to better synchronize messages across iOS and macOS devices. A previous point release also added support for person-to-person Apple Pay payments. The operating system also introduced the ability to record the screen, limited forms of drag-and-drop functionality, and support for augmented reality. Certain new features appeared only on iPad, including an always-accessible application dock, cross-app drag-and-drop, and a new user interface to show multiple apps at once.

On June 4, 2018, at the Worldwide Developers Conference, Apple announced its successor, [iOS 12](https://github.com/seanpm2001/WacOS/wiki/iOS-12/).

## History

### Introduction and initial release

iOS 11 was introduced at the Apple Worldwide Developers Conference keynote address on June 5, 2017. The first developer beta version was released after the keynote presentation, with the first public beta released on June 26, 2017.

iOS 11 was officially released by Apple on September 19, 2017.

### Updates

Version 	Build 	Release date 	Notes

11.0 	15A372 	September 19, 2017 	Initial release

11.0.1 	15A402

15A403

15A8391 	September 26, 2017 	Fixes an issue with Exchange email servers where email would fail to send

11.0.2 	15A421 	October 3, 2017 	

Fixes an issue where, for some iPhone 8 and iPhone 8 Plus users, a crackling sound had the chance of occurring while on a call

Fixes an issue where some photos could end up becoming hidden

Fixes an issue where some email attachments would not open

11.0.3 	15A432 	October 11, 2017 	

Fixes an issue where haptic feedback was not working on some devices

Fixes an issue where touch was not working properly due to the displays not being replaced with genuine Apple displays

11.1 	15B93

15B101 	October 31, 2017 	

Added over 70 new emoji characters

Fixes and improvements to VoiceOver rotor

Fixes an issue where some photos could become blurry

Fixes an issue where Live Photo effects would play slowly

Fixes an issue where already cleared notifications sent from the Mail app could reappear on the Lock Screen

Fixes an issue on Apple Watch where app icons would refuse to appear in notifications

11.1.1 	15B150 	November 9, 2017 	

Fixes an issue with keyboard auto-correct

Fixes an issue where Hey Siri would stop working

11.1.2 	15B202 	November 16, 2017 	

Fixes an issue where a rapid drop in temperature caused problems with the touch screen of the iPhone X

Fixes an issue where distortion could be caused in Live Photos and videos captured on the iPhone X

11.2 	15C114 	December 2, 2017 	


Added support for Apple Pay Cash (USA only)

Improved wireless charging on the iPhone 8, iPhone 8 Plus and iPhone X

Added three new Live Wallpapers for the iPhone X

Fixes an issue that could cause the keyboard to appear slowly

Fixes an issue in Calculator app where rapidly typing numbers could lead to incorrect calculation results

11.2.1 	15C153 	December 13, 2017 	Fixes an issue where remote access could unexpectedly be disabled for shared users in the Home app

11.2.2 	15C202 	January 8, 2018 	Bug fixes and security patches

11.2.5 	15D60 	January 23, 2018 	

Adds support for HomePod

Siri News (USA, UK, and Australia only)
 
Siri now has the ability to read the news. Users can say «Hey Siri, play the news» to begin news playback. Users can also ask for news from specific categories

Bug fixes

11.2.6 	15D100 	February 19, 2018 	

Initial Release on iPad 6th generation

Fixes an issue that could cause apps to crash when using certain character sequences

Fixes an issue where in some instances third-party apps would fail to connect to external accessories

11.3 	15E216

15E218 	March 29, 2018 	

Augmented Reality

Introduces ARKit 1.5, granting developers the ability to place virtual objects on vertical surfaces, such as walls or doors, in addition to horizontal surfaces

Adds the ability to detect and implement images, such as movie posters or artwork, into Augmented Reality experiences

iPhone Battery Health (Beta)

Displays information about an iPhone’s battery, such as its current maximum capacity and if the battery is still supporting peal performance capabilities

Indicates if the iPhone Performance Management feature is turned on, while including the option to disable the feature is desired

Gives a recommendation if the battery inside of the iPhone should be replaced

iPad Charge Management

Maintains the health of the battery when it has been connected to power for extended periods of time

Animoji

Introduces four new Animoji characters: Lion, Bear, Dragon and a Skull

Safari

Warnings are now shown when accessing unencrypted webpages

Keyboard

Introduces two new Shuangpin keyboard layouts

Improves the Japanese and Chinese keyboards on 4.7-inch and 5.5-inch devices

Users can now switch back to the keyboard from dictation mode with one tap

Bug fixes and improvements

11.3.1 	15E302 	April 24, 2018 	Fixes an issue where on some iPhone 8 devices touch input could be unresponsive due to the displays being services with non-genuine replacement displays

11.4 	15F79 	May 29, 2018 	

AirPlay 2

Allows users to control their home audio system

Allows users to broadcast music via multiple AirPlay 2-enabled speakers

HomePod Stereo Pairing

When pairing, the HomePod balances the sound based on the location of the speaker

HomePod provides Advanced Beamforming, a technology that provides a wider sound stage than a tradition stereo pair

HomePod automatically updates, unless updates are disabled in the Home app

11.4.1 	15G77 	July 9, 2018 	

Fixes an issue where some users could be prevented from viewing the last known location of their AirPods in the Find my iPhone app

Improves reliability when syncing data sources, such as Mail and Contacts with Exchange accounts

Initial release on iPhone 8 and iPhone 8 Plus

Initial release on iPhone X

iPhone 8 and iPhone 8 Plus only

iPhone X only

Wasn’t released for iPhone X

iPad Pro (12.9-inch) (2nd generation) and iPad Pro (10.5-inch) only

Initial release on iPad (6th generation)

iPad (6th generation) (Wi-Fi + Cellular) only

## System features

### Lock screen

The lock screen and Notification Center are combined, allowing users to see all notifications directly on the lock screen. Scrolling up and down will either show or hide notifications.

### Control Center

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_Control_Center_iPhone_7_Plus.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_Control_Center_iPhone_7_Plus.png)

_The default Control Center on an iPhone 7 Plus_

The Control Center redesign unifies its pages and allows users to 3D Touch (or long press on devices without 3D Touch) buttons for more options. Sliders adjust volume and brightness. The Control Center is customizable via the Settings app, and allows more settings to be shown, including cellular service, Low Power Mode, and a shortcut to the Notes app.

### Siri

The Siri intelligent personal assistant has a more human voice and supports language translation, with English, Chinese, French, German, Italian and Spanish available at launch. It will also support follow-up questions by users. Users will also be able to type to Siri.

Siri will be able to use "on-device learning", a privacy-minded local learning technique to understand a user's behavior and interests inside different apps, to offer better suggestions and recommendations.

### Settings

A new "Do Not Disturb While Driving" mode lets users block unnecessary notifications as long as their iPhone is connected to a vehicle through Bluetooth. An auto-reply feature sends a specific reply to senders of messages to let them know the user is currently unavailable through text. Passengers can be granted full notification access to the phone.

A new "Smart Invert" feature, dubbed a "dark mode" by some publications, inverts the colors on the display, except for images, some apps, and some user interface elements. Using the iPhone X, which utilizes OLED technology, some news outlets have reported that this feature can conserve battery life by turning off pixels when black, saving energy by preventing itself from displaying a white pixel.

Users get expanded control over apps' location usage, with every app featuring a "While Using the App" location toggle in Settings. This differs from previous iOS versions, in which apps were only required to have "Never" or "Always" location options.

Users can remove rarely used apps without losing the app's data using the "Offload App" button. This allows for a later reinstallation of the app (if available on the App Store), in which data returns and usage can continue. Users can also have those apps removed automatically with the "Offload Unused Apps" setting. When an app is offloaded, the app appears on the home screen as a grayed-out icon.

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_storage_settings_iPhone_6S_Plus.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_storage_settings_iPhone_6S_Plus.png)

_Storage settings on an iPhone 6S Plus, showing personalized recommendations_

Personalized suggestions will help the user free up storage space on their device, including emptying Photos trash, backing up messages, and enabling iCloud Photo Library for backing up photos and videos.

### iPad

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_Multitasking_9.7-inch_iPad_Pro.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_Multitasking_9.7-inch_iPad_Pro.png)

_Multitasking interface on a 9.7-inch iPad Pro_

Certain new iOS 11 features will appear only on iPad. The application dock gets an overhaul, bringing it closer to the design seen on macOS, and is accessible from any screen, letting users more easily open apps in split-screen view. Users can also drag-and-drop files across different apps. A new multitasking interface shows multiple apps on the screen at the same time in floating "windows." Additionally, through a combination of "slide over," "split view," and "picture-in-picture" modes, users can have up to four active apps on-screen at the same time.

Each letter on the iPad keyboard features an alternative background number or symbol, accessible by pulling down on the respective key and releasing.

The Control Center is visible in the multitasking window on iPads.

Running iOS 11, the 9.7-inch, 10.5-inch and the 2nd-generation 12.9-inch iPad Pros now have flashlight support.

### Camera

iOS 11 introduces optical image stabilization, flash photography and high dynamic range for portrait photos.

Live Photos receives new "Loop", "Bounce" and "Long Exposure" effects, and uses High Efficiency Image File Format to decrease photo sizes.

On devices with an Apple A10 chip or newer, photos can be compressed in the new High Efficiency Image File Format and videos can be encoded in the new High Efficiency Video Coding video compression format, enabling improved quality while also decreasing size by half.

### Wallpapers

Apple significantly changed the wallpapers available for use with iOS 11. In the initial beta version, released after Apple's developer conference, Apple included one new wallpaper, and removed all the six "Live" animated fish wallpapers, introduced with the iPhone 6S in 2015. The iOS 11.2 release later brought iPhone X/8/8 Plus-exclusive wallpapers to older iPhones.

iPhone X exclusively features six "Live" wallpapers and seven new "Dynamic" wallpapers.

### Other changes

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_keyboard_iPhone_7_Plus.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_keyboard_iPhone_7_Plus.png)

_The default system keyboard, in one-handed mode, on an iPhone 7 Plus_

iOS 11 introduces native support for QR code scanning, through the Camera app. Once a QR code is positioned in front of the camera, a notification is created offering suggestions for actions based on the scanned content. Twitter users have so far discovered that joining Wi-Fi networks and adding someone to the contacts list are supported through QR codes.

Third-party keyboards can add a one-handed mode.

Users are able to record the screen natively. In order to record the screen, users must first add the feature to the Control Center through the Settings app. Once added, users can start and stop recordings from a dedicated Control Center icon, with a distinctly colored bar appearing at the top of the screen indicating active recording. Pressing the bar gives the option to end recording, and videos are saved to the Photos app.

When an iOS 11 device is attempting to connect to a Wi-Fi network, nearby iOS 11 or macOS High Sierra devices already connected can wirelessly send the password, streamlining the connection process.

The volume change overlay no longer covers the screen while playing video, and a smaller scrubber appears on the top right of the screen.

After a user takes a screenshot, a thumbnail of the screenshot will appear at the bottom left of the screen. The user can then tap the thumbnail to bring up an interface that allows them to crop, annotate, or delete the screenshot.

Third-party apps are also able to take advantage of iCloud Keychain to allow autofilling passwords.

The user's airline flight information can be viewed in Spotlight through a dedicated widget.

iOS 11 switches the top-left cellular network strength icons from five dots to four signal bars, similar to that before iOS 7.

A new "Automatic Setup" feature aims to simplify the first-time setup of new devices, with wireless transfer between the old and new device, transferring preferences, Apple ID and Wi-Fi info, preferred Settings, and iCloud Keychain passwords.

Similar to iPad, drag-and-drop file support is available on iPhone, though with more limitations, specifically only supported within apps, not between.

Many of Apple's pre-installed applications, including Notes, Contacts, Reminders, Maps, and App Store, have redesigned home screen icons.

An "Emergency SOS" feature was added that disables Touch ID after pressing the Sleep/Wake button five times in quick succession. It prevents Touch ID from working until the iPhone's passcode has been entered.

iOS 11 adds support for 8-bit and 10-bit HEVC. Devices with an Apple A9 chip or newer support hardware decoding, while older devices support software-based decoding.

When a device running iOS 11 or later is activated, Apple's verification server will check the device's UDID before it could be set up. If the device's UDID is malformed or not present in Apple's database, the device cannot be activated and will be denied access to the verification server. If said device is connected to iTunes, an error message will appear stating that the iPhone could not be activated because "the activation information could not be obtained from the device."

## App features

### Mail

Where there is empty space in the Mail app, users can draw inline.

### Messages

The Messages application synchronizes messages across iOS and macOS through iCloud, reflecting message deletion across devices.[62] This feature was temporarily removed in the fifth beta release and returned on May 29, 2018 when iOS 11.4 was released.

At the time of the iOS 11 announcement in June 2017, Apple presented functionality letting users send person-to-person payments with Apple Pay through Messages. By the time of the iOS 11 release in September 2017, the feature was not present, having been removed in an earlier beta version, with Apple announcing the feature as "coming this fall with an update to iOS 11". It was launched a few days after the iOS 11.2 update went live, although initially only available in the United States.

A new app drawer for iMessage apps aims to simplify the experience of using apps and stickers, and an optimized storage system reduces the backup size of messages.

The Messages app also incorporates a "Business Chat" feature for businesses to communicate directly with customers through the app. This can be accessed through a message icon next to search results of businesses. However, this feature was not included with the initial release of iOS 11 (instead launching with iOS 11.3).

The Messages app on the iPhone X introduces face-tracking emoji called "Animoji" (animated emoji), using Face ID.

### App Store

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IPhone_App_Store.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IPhone_App_Store.png)

_The "Apps" tab in the App Store on an iPhone 7 Plus_

The App Store receives a complete redesign, with a greater focus on editorial content such as daily highlights, and a design described as "cleaner and more consistent" to other apps developed by Apple. The app's design mimics the design seen in the Apple Music app in [iOS 10](https://github.com/seanpm2001/WacOS/wiki/iOS-10/).

### Maps

At select locations, Apple Maps will offer indoor maps for shopping malls and airports.

New lane guidance and speed limit features aim to guide drivers on unfamiliar roads.

### Photos

The Photos app in iOS 11 gains support for viewing animated GIFs. Users can access GIF images inside an album titled "Animated".

Memories can be viewed while the phone is in portrait orientation.

### Podcasts

The Podcasts app receives a redesign similar to the App Store, with a focus on editorial content.

### Notes

The Notes app has a built-in document scanner using the device's camera, and the feature removes artifacts such as glare and perspective.

An "Instant Notes" feature on the iPad Pro allows the user to start writing a note from the lock screen by putting the Apple Pencil onto the screen.

The app also allows users to input inline tables.

Where there is open space in the Notes app, the user can draw inline.

### Files

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_Files_1_App_iPad.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/11/IOS_11_Files_1_App_iPad.png)

_The layout of the "Files" app on an iPad_

A new "Files" app lets users browse the files stored on their device, as well as those stored across various cloud services, including iCloud Drive, Dropbox, OneDrive, and Google Drive. The app supports organization through structured sub-folders and various file-based options, and it also includes a built-in player for FLAC audio files. The Files app is available on both iPad and iPhone.

### Safari

The user's flight information can be found in the Safari app.

### Calculator

The Calculator app receives a redesign, with rounded buttons, replacing the grid ones seen on iOS 7.

### Developer APIs

A new "ARKit" application programming interface (API) lets third-party developers build augmented reality apps, taking advantage of a device's camera, CPU, GPU, and motion sensors. The ARKit functionality is only available to users of devices with Apple A9 and later processors. According to Apple, this is because "these processors deliver breakthrough performance that enables fast scene understanding and lets you build detailed and compelling virtual content on top of real-world scenes."

A new "Core ML" software framework will speed up app tasks involving artificial intelligence, such as image recognition.

A new "Depth" API allows third-party camera app developers to take advantage of the iPhone 7 Plus, iPhone 8 Plus, and iPhone X's dual-camera "Portrait mode". This will let apps implement the same depth-sensing technology available in the default iOS Camera app, to simulate a shallow depth-of-field.

A new "Core NFC" framework gives developers limited access to the near field communication (NFC) chip inside supported iPhones, opening potential use cases in which apps can scan nearby environments and give users more information.

## Removed functionality

Apps must be compiled for 64-bit architecture in order to be supported on iOS 11. 32-bit apps are not supported or shown in the App Store in iOS 11, and users who attempt to open such apps receive an alert about the app's incompatibility.[

iOS 11 drops the native system integration with Twitter, Facebook, Flickr, and Vimeo.

The iCloud Drive app is removed and replaced by the Files app.

The ability to trigger multitasking using 3D Touch was removed from the original iOS 11 release. In response to a bug report, an Apple engineer wrote that "Please know that this feature was intentionally removed". Apple's software engineering chief Craig Federighi wrote in reply to an email that the company had to "temporarily drop support" due to a "technical constraint," pledging to bring it back in a future update to iOS 11. It was brought back in [iOS 11.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/).

In [iOS 11.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) the toggle switch for Wi-Fi and Bluetooth were unexpectedly changed to not completely turning off those two things but temporarily until the next day. The real turn off is in the Settings app.

## Reception

iOS 11 received mixed reviews. Critics praised the application dock and new multitasking interface on the iPad, crediting them for renewing the user experience. Further praise was directed at the redesigned Control Center offering customizable toggles; criticism was widely focused on its lack of third-party app support, lack of Wi-Fi network selection ability and for difficult usage on small screen sizes, along with its instability. Critics also noted the new augmented reality development tools, but said their impact would depend on third-party apps and how fast developers embraced them. Praise was also directed at the App Store's redesign and the new file-management tools. Shortly after release, it was discovered that disabling Wi-Fi and Bluetooth connections through the Control Center does not disable the respective chips in the device in order to remain functional for background connectivity, a design decision sparking criticism for "misleading" users and reducing security due to potential vulnerabilities in inactive open connections. The iOS 11.2 update added warning messages and a new toggle color to explain the new functions. iOS 11 has also received continuous criticism from critics and end-users for its perceived stability and performance issues, particularly on older devices; Apple has issued numerous software updates to address such issues and has dedicated iOS 12 mainly toward stability and performance improvements in response. Two months after release, 52% of iOS devices were running iOS 11, a slower adoption rate than previous iOS versions. The number increased to 85% of devices by September 2018.

Dieter Bohn of The Verge liked the new Control Center setup, including customizable toggles and 3D Touch-expandable options, writing that "there are a few panels that I'm really impressed with", specifically highlighting the Apple TV remote as a possible replacement of the normal remote. He did, however, note the lack of third-party access to Control Center, with a hope for support in the future, and a lack of Wi-Fi network selection ability. He praised the screen-recording functionality, calling it "super neat". Bohn severely criticized the notifications view, writing that he has a "very serious disagreement" with Apple on how to manage it, elaborating that he prefers to use that screen as much as possible while stating that "Apple's philosophy is that I'm trying way too hard" to control speedy notifications. Bohn liked the new Files app, new drag-and-drop functionality on the home screen enabling users to drag multiple apps at once, and significantly praised multitasking on iPad. Writing that "Multitasking on the iPad is a near-revelatory experience", he enjoyed the application dock and the ability to place up to three apps on the screen at once with more freedom on placement. Bohn conceded that "It's not as intuitive nor as simple nor [sic] as easy to manipulate as a traditional windowing system like you'll get on a Mac, PC, or Chromebook", but still praised it for being "radically more powerful than what has ever been available on an iPad before". Finally, Bohn praised Siri for improvements to the voice, highlighted augmented reality allowing for "incredible games", and reiterated an earlier sentiment that iOS 11 is "the most ambitious software update from Apple in a very, very long time".

Macworld's Jason Snell wrote that the hype surrounding iOS 11 is "justified". Snell praised the new "smoother" transfer mode of data and settings between an old iPhone and a new iPhone, referring to the previous experience of doing it manually as "a frustrating exercise in entering in passwords repeatedly while tapping through a long series of questions about activating or deactivating numerous iOS features." He also praised the Control Center design, calling it "a great upgrade", though also highlighting the inability to easily switch Wi-Fi networks. Snell noted that the App Store's design had been unchanged for years, but received a full redesign in iOS 11, and wrote that Apple's commitment to editorial pages was "impressive", making the App Store "a richer, more fun experience." Regarding the introduction of augmented reality, he stated that most apps using it were "bad", though some also "mind-blowingly good," adding that the "huge potential" depended on how third-party apps were using it. Snell also praised improvements to the iPad experience, including multitasking and drag-and-drop across apps, the latter of which he stated "actually surpasses my expectations" due to ease of use. His review summarization states that iOS 11 is "Apple’s most ambitious and impressive upgrade in years."

Romain Dillet of TechCrunch focused mostly on the iPad in his review, writing that iOS 11 "turns your iPad into a completely different machine", with "much more efficient" multitasking and improved ease of access with the application dock. He also praised the design overhaul of the App Store, calling it "a huge improvement compared to the previous App Store", and also highlighted design changes in other apps, including "a huge bold header with the name of the app or section". Although he acknowledged that "Many tech friends have told me that they hate this change," Dillet stated that "I think most people will like it. It’s visually pleasing and distinctive." He stated that augmented reality will become more relevant in the days following the iOS 11 release as third-party developers incorporate features into their apps, and praised Apple for creating the ARKit development tools as it "makes it much easier to implement augmented reality features". In conclusion, Dillet wrote that "Ten years ago, iOS started as a constrained operating system. It is now one of the biggest digital playgrounds".

Devindra Hardawar of Engadget stated that the focus of iOS 11 was "all about transforming iOS into something more desktop-like", with many enhancements for iPad while "leaving the iPhone a bit behind." He had mixed feelings about the Control Center, writing that, on small phone screen sizes, it "feels like a jumbled mess," and adding that true comfort may only be present with larger screens, a troubling situation for owners of non-Plus devices. However, he praised the ability to customize the buttons, including removing those the user never uses, and the ability to quickly record the screen or enable accessibility features. He called the new app designs "attractive", and favorably pointed out the new app drawer at the bottom of conversations in the Messages app, referring to it as "a big improvement over the messy interface of last year." He praised Siri for an improved voice, the Photos app for creating better Memories, and new social features in Apple Music, though noting the lack of people in his social circle using the service. Referencing IKEA's "IKEA Place" app, which uses augmented reality to virtually place objects in a room, he significantly praised the performance of the augmented reality technology on iPhone, writing that "It did a great job of rendering furniture in physical spaces using both the iPhone 8, and, even more impressively, it ran smoothly on my iPhone 6S". Finally, Hardawar also enjoyed new functionality on iPad, calling multitasking, the application dock and drag-and-drop "dramatic changes," and highlighting the "particularly useful" experience of dragging Internet content directly from the web into the new Files app. In summarization, he recognized the significant strides made for iPad with iOS 11, writing that "it's a shame that iOS 11 doesn't bring more to the table on the iPhone", though acknowledging the rise of augmented reality.

In November 2017, Apple's App Store support page was updated to reflect that 52% of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) devices were running iOS 11, a slower migration rate than for the release of [iOS 10](https://github.com/seanpm2001/WacOS/wiki/iOS-10/) the year prior, which saw 60% user adoption by October 2016. The number increased to 59% of devices by December 2017.

### Design inconsistencies and software bugs

In September 2017, Jesus Diaz of Fast Company criticized design details in iOS 11 and Apple's built-in apps not adhering to Apple's user interface guidelines. Headers not being aligned properly between different apps, elements not being centered, and different colors and sizing caused Diaz to write that "When it comes to software, Apple’s attention to detail is crumbling away." However, he also looked back in history, mentioning that Apple Music's original design, a lack of optical typography alignment in the Calendar app, and previously-fixed iOS design mistakes being ported to the macOS software had established that "This inconsistency and lack of attention to detail are not new at Apple." He firmly stated: "Perhaps this is inevitable, given the monumental task of having to update the operating system every year. But for a company that claims to have an obsessive attention to detail, this is not acceptable."

In November [2017](https://github.com/seanpm2001/WacOS/wiki/2017/), Gizmodo's Adam Clark Estes wrote extensively on software bugs and product imperfections experienced while using iOS 11. Estes pointed to issues such as keyboard covering up messages and a disappearing reply field in the Messages app, the letter "i" converting to a Unicode symbol, and the screen becoming unresponsive, writing that "The new operating system has turned my phone into a bug-infested carcass of its former self, and the frustration of trying to use it sometimes makes me want to die, too." He also wrote on the aspect of technology becoming more advanced and sophisticated, explaining that "back when the iPhone 4 came out [...] smartphones were a lot simpler. The cameras were joyfully crappy. The screens were small. The number of apps we could download and things we could connect to was paltry compared to today. [...] We should expect some bugs, I guess. More complex pieces of technology contain more points of failure, and I’m oversimplifying the issue." He concluded by theorizing on technological development, writing: "However, I am trying to understand exactly how my life with computers veered so dramatically from the days of Windows 95 when nothing worked right, to the golden age of the iPhone 4 when everything seemed perfect, to now when just a handful of iOS bugs make me feel like the world is falling apart. [...] Maybe I’m the annoying thing, the whiny one who’s upset that nothing seems perfect any more. Or maybe, just maybe, Apple is slipping, and we were wrong to trust it all along."

## Problems

### Wi-Fi and Bluetooth Control Center toggles

Shortly after iOS 11 was released, Vice's Motherboard discovered new behaviors by the Wi-Fi and Bluetooth toggles in the Control Center. When users tap to turn off the features, iOS 11 only disconnects the chips from active connections, but does not disable the respective chips in the device. The report further states that "it's a feature, not a bug", referencing documentation pages by Apple confirming the new toggle behaviors as a means to disconnect from connections but remain active for AirDrop transfers, AirPlay streaming, Apple Pencil input, handoff and other features. Security researcher Andrea Barisani told Motherboard that the new user interface was "not obvious at all", making the user experience "more uncomfortable". In October [2017](https://github.com/seanpm2001/WacOS/wiki/2017/), the Electronic Frontier Foundation published an article, calling the interface "misleading" and "bad for user security", due to a higher risk of security vulnerabilities with Wi-Fi and Bluetooth chips activated while not in active use. The Foundation recommended that Apple fix the "loophole in connectivity", writing that "It's simply a question of communicating better to users, and giving them control and clarity when they want their settings off - not "off-ish"".

[iOS 11.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) changes this behavior slightly, by turning the toggles white and showing a warning message that explains the functions of the toggles in the Control Center, when the toggles are turned off.

### Battery drain issues

Some users have experienced battery drain problems after updating to iOS 11. In a poll on its website, 70% of 9to5Mac visitors reported decreased battery life after updating to the new operating system. However, in an article featuring Twitter complaints of battery life, Daily Express wrote that "honestly, this is to be expected. It happens every year, and it's completely normal. Major iOS releases will hammer the battery on your device much faster during the first few days of use", with Forbes stating in an article that "The days after you install a new version of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/), your iDevice is busy doing all sorts of housekeeping. Practically all of your apps have updates, so iOS is busy downloading and installing them in the background. [...] Additionally, after you install a new version of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/), it has to do something called "re-indexing." During this process, iOS 11 will comb through all of the data on your device so that it can be cataloged for quick Spotlight searching." The article further states that "The good news is that both of these things are temporary".

Within a week of the launch of the [11.3.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) update, users began reporting continued issues with this update regarding battery drainage. Some of these reports indicated drains from 57% down to 3% in just 3 minutes. Even users with the health of the battery measuring 96% noticed iPhones draining at around 1% per minute. In addition to battery drains, some iPhone users noticed their devices having excessive heat buildup.

It has been recommended by technology experts that users not upgrade their software until the release of a version subsequent to [11.3.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) unless specifically plagued by the 'third party display issue'.

### Calculator bug

In October [2017](https://github.com/seanpm2001/WacOS/wiki/2017/), users reported on Reddit that quickly typing in an equation in the built-in [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) calculator app gives incorrect answers, most notably making the query "1+2+3" result in "24" rather than "6". Analysts have blamed an animation lag caused during the redesign of the app in iOS 11. The problem can be worked around by typing the numbers slowly, or by downloading alternative calculator apps from the App Store that do not have this problem. With a large amount of bug reports filed, Apple employee Chris Espinosa indicated on Twitter that the company was aware of the issue. [iOS 11.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) fixed the issue.

### Keyboard autocorrect bugs

In November 2017, users reported a bug in the default iOS keyboard, in which pressing "I" resulted in the system rendering the text as "!" or "A" along with an incomprehensible symbol featuring a question mark in a box. The symbol is known as Variation Selector 16 for its intended purpose of merging two characters into an emoji. Apple acknowledged the issue in a support document, advising users to set up a Text Replacement feature in their device's keyboard settings as a temporary workaround. The company confirmed to The Wall Street Journal that devices using older iOS 11 versions, as opposed to just the latest 11.1 version at the time of the publication, were affected by the issue, and an Apple spokesperson announced that "A fix will be released very soon". [iOS 11.1.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) was released on November 9, [2017](https://github.com/seanpm2001/WacOS/wiki/2017/), fixing the issue.

At the end of the month, another keyboard autocorrection bug was reported, this time replacing the word "It" with "I.T." MacRumors suggested users set up the Text Replacement feature the same way they did for the earlier autocorrection issue, though its report notes that "some users insist this solution does not solve the problem". It was fixed with the release of [iOS 11.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/).

### December 2 crashes

In early December, users wrote on Twitter and Reddit that, at exactly 12:15 a.m. local time on December 2, any App Store app that sends local notifications would cause the device to repeatedly restart. Reddit users reported that disabling notifications or turning off background app refresh would stop the issue, while Apple staff on Twitter reported that it was a bug in date handling, recommending users to manually set the date prior to December 2. MacRumors wrote that the issue "looks like it's limited to devices running iOS [11.1.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/)", with users on the [11.2 beta](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) release not affected. [iOS 11.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), released on the same day, fixed the issue.

### iOS 11.2 HomeKit vulnerability

In December [2017](https://github.com/seanpm2001/WacOS/wiki/2017/), 9to5Mac uncovered a security vulnerability in [iOS 11.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) within Apple's HomeKit smart home system, allowing unauthorized access to smart locks and garage door openers. It noted that Apple had already issued a server-side fix that, while preventing unauthorized access, also limited HomeKit functionality, with an upcoming software fix for the [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) operating system intended to restore the lost functionality. On December 13, 2017, Apple released [iOS 11.2.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), which fixed the limitation on remote access.

## Supported devices

iOS 11 drops support for devices with a 32-bit processor: specifically the iPhone 5, iPhone 5C, and the fourth-generation iPad. It is the first version of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) to run exclusively on [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) devices with 64-bit processors.

### iPhone

iPhone 5S

iPhone 6

iPhone 6 Plus

iPhone 6S

iPhone 6S Plus

iPhone SE (1st generation)

iPhone 7

iPhone 7 Plus

iPhone 8

iPhone 8 Plus

iPhone X

### iPod Touch

iPod Touch (6th generation)

### iPad

iPad Air

iPad Air 2

iPad (2017)

iPad (2018)

iPad Mini 2

iPad Mini 3

iPad Mini 4

iPad Pro (9.7-inch)

iPad Pro (10.5-inch)

iPad Pro (12.9-inch 1st generation)

iPad Pro (12.9-inch 2nd generation)

**This article is a modified copy of its Wikipedia counterpart and needs to be rewritten for originality.**

***

## Sources

[Wikipedia - iOS 11](https://en.wikipedia.org/wiki/IOS_11/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Monday September 27th at 4:31 pm`

**Last revised on:** `2021 Monday September 27th at 4:31 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `536`

**Article version:** `1 (2021 Monday September 27th at 4:31 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

